<%--

/* $Header: apacheConfigLogin.jsp 12-sep-2006.14:34:50 yxie Exp $ */
/* Copyright (c) 2001, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     End User Monitoring Apache Configuration Login Page.

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      yxie   09/12/06 - XbranchMerge yxie_bug-5521573 from main
      yxie   09/08/06 - Fix bug 5521573
      andyao 08/30/05 - add noAutoComplete for textinput
      yxie   04/20/05 - 
      yxie   04/07/05 - add apache type
      yxie   03/23/05 - reformatting
      yxie   02/07/05 - change hostname name value pair
      yxie   01/25/05 - change login page look
      yxie   11/13/04 - yxie_apacheui
      yxie    11/03/04 - Creation.
 */

/**
 *  @version $Header: apacheConfigLogin.jsp 12-sep-2006.14:34:50 yxie Exp $
 *  @author  yxie
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ page import='oracle.sysman.eml.webapp.WebappConstants'%>

<uix:renderingContext id="renderingContext">
<oemjsp:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <uix:bundle name="cmnMsg" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrMsg" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>

    <uix:body>
        <uix:dataScope currentDataBinding="apacheConfigData@servletRequest" >
          <uix:form name="ApacheLogin" method="post" destinationBinding="loginURL">
    <uix:pageLayout>  
        <%@ include file="/oemGlobal.jspf"%>
        <%@ include file="/oemNoscript.jspf" %>

              <uix:contentFooter>
                <uix:pageButtonBar>
                  <uix:submitButton name="event" value="cancelLogin" textBinding="CANCEL@cmnMsg" />
                  <uix:submitButton name="event" value="login" textBinding="CONTINUE@cmnMsg" />
                </uix:pageButtonBar>
              </uix:contentFooter>
                  <uix:switcher childNameBinding="loginWarning">
                    <uix:case name="<%=Boolean.TRUE%>">
                      <uix:switcher childNameBinding="hasError">
                        <uix:case name="<%=Boolean.TRUE%>">
                          <uix:messageBox messageBinding="APACHE_CONFIG_LOGIN_WARNING@webappMsg" messageType="error">
                            <uix:contents>
                              <uix:styledText textBinding="errorMsg" /> 
                            </uix:contents>
                          </uix:messageBox>
                        </uix:case>
                        <uix:default>
                          <uix:messageBox messageBinding="APACHE_CONFIG_LOGIN_WARNING@webappMsg" messageType="error"/>
                        </uix:default>
                      </uix:switcher>
                    </uix:case>
                  </uix:switcher>
            <spacer height="10"/>
            <uix:header textBinding="configLoginHeader">
              <uix:contents>

                <uix:tableLayout width="100%">
                 <uix:contents>
              <uix:rowLayout hAlign="right" width="100%">

                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraInstructionText" 
                                textBinding="APACHE_CONFIG_LOGIN_MSG@webappMsg"/>
                </uix:cellFormat>

                <uix:spacer width="5"/>

                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:submitButton name="event" value="cancelLogin" textBinding="CANCEL@cmnMsg" />
                  <uix:spacer width="10"/>
                  <uix:submitButton name="event" value="login" textBinding="CONTINUE@cmnMsg" />
                </uix:cellFormat>

              </uix:rowLayout>

              <uix:rowLayout width="100%">
                <uix:stackLayout>
                  <uix:spacer height="10"/>
                </uix:stackLayout>
              </uix:rowLayout>

                  <uix:rowLayout hAlign="center">
                    <uix:contents>
                      <uix:tableLayout hAlign="center" cellSpacing="2">
                        <uix:contents>
                            <uix:messageStyledText promptBinding="HOST_VALUE_LABEL@webappMsg" 
                                            textBinding="host" 
                                            styleClass="oraDataText"/>
                          <uix:rowLayout>
                            <uix:stackLayout>
                              <uix:spacer height="4"/>
                            </uix:stackLayout>
                          </uix:rowLayout>
                          <uix:messageTextInput name="username" promptBinding="USERNAME_HDR@webappMsg" textBinding="userName" noAutoComplete="true"/>
                          <uix:messageTextInput name="password" promptBinding="PASSWORD_HDR@webappMsg" secret="true" noAutoComplete="true"/>
            
                        </uix:contents>
                      </uix:tableLayout>        
                    </uix:contents>
                  </uix:rowLayout>
                                          <uix:rowLayout>
                            <uix:stackLayout>
                              <uix:spacer height="10"/>
                            </uix:stackLayout>
                          </uix:rowLayout>
                </uix:contents>
                </uix:tableLayout>            


              </uix:contents>
            </uix:header> 

      </uix:pageLayout>
          <uix:formValue
                  name="<%=WebappConstants.APACHE_NAME%>"
                  valueBinding="apacheName"/>
          <uix:formValue
                  name="<%=WebappConstants.APACHE_TYPE%>"
                  valueBinding="apacheType"/>
                </uix:form>
        </uix:dataScope>
    </uix:body>

  </uix:document>
</uix:renderingContext>
