<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.webapp.WebappConstants'%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <uix:bundle name="cmnMsg" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrMsg" class="oracle.sysman.resources.MntrResourceBundle"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <uix:dataScope currentDataBinding="apacheConfigData@servletRequest" >
      <uix:form name="ApacheUrls" method="post">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>

              <uix:contentFooter>
                <uix:pageButtonBar>
                  <uix:submitButton textBinding="CANCEL@cmnMsg"
                                    name="event" value="cancelSetUrls"/>
                  <uix:submitButton textBinding="OK@cmnMsg"
                                    name="event" value="setUrls"/>
                </uix:pageButtonBar>
              </uix:contentFooter>

              <uix:switcher childNameBinding="hasError">
                <uix:case name="<%=Boolean.TRUE%>">
                  <uix:messageBox messageBinding="errorMsg" messageType="error"/>
                </uix:case>
              </uix:switcher>

          <uix:header textBinding="configURLHeader">
            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right" width="100%">

                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraInstructionText" textBinding="URLS_TO_MONITOR_MSG@webappMsg"/>
                </uix:cellFormat>

                <uix:spacer width="5"/>

                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:submitButton textBinding="CANCEL@cmnMsg"
                                    name="event" value="cancelSetUrls"/>
                  <uix:spacer width="10"/>
                  <uix:submitButton textBinding="OK@cmnMsg"
                                    name="event" value="setUrls"/>
                </uix:cellFormat>

              </uix:rowLayout>

              <uix:rowLayout width="100%">
                <uix:stackLayout>
                  <uix:spacer height="10"/>
                </uix:stackLayout>
              </uix:rowLayout>

              <uix:rowLayout hAlign="center" width="100%">
                <uix:stackLayout>
                  <uix:table name="urlConfigTable"
                             alternateTextBinding="NO_URLS_AVAILABLE@webappMsg"
                             showAll="yes" 
                             width="80%"
                             columnFormatsBinding="urlsTableColFormat"
                             tableDataBinding="currentUrlsTableData"
                             formSubmitted="true"
                             columnHeaderDataBinding="urlsTableHeaderData"
                             maxValueBinding="urlsTableMaxValue"
                             valueBinding="urlsTableValue"
                             blockSizeBinding="urlsTableBlockSize"
                             summaryBinding="configURLHeader">

                    <uix:columnHeaderStamp>
                      <uix:text textBinding="text"/>
                    </uix:columnHeaderStamp>   
                
                    <uix:tableSelection>
                      <uix:singleSelection selectedIndex="0" disabledBinding="disabled">
                        <uix:submitButton textBinding="INSERT_BEFORE@webappMsg" name="event" value="insertBefore"/>
                        <uix:submitButton textBinding="INSERT_AFTER@webappMsg" name="event" value="insertAfter"/>
                        <uix:submitButton textBinding="DELETE@webappMsg" name="event" value="deleteUrl"/>
                      </uix:singleSelection>
                    </uix:tableSelection> 

                    <uix:contents>

                    <uix:messageTextInput name="urlPattern" textBinding="EXP" readOnlyBinding="unchangable"/>

                    <uix:choice name="patternType"
                                selectedValueBinding="EXPTYPE"
                                readOnlyBinding="unchangable" >
                      <uix:option textBinding="STARTS_WITH@webappMsg" value="START"/>
                      <uix:option textBinding="ENDS_WITH@webappMsg" value="END"/>
                      <uix:option textBinding="CONTAINS@webappMsg" value="CONTAINS"/>
                      <uix:option textBinding="REGULAR_EXP@webappMsg" value="REGULAR"/>
                    </uix:choice>

                      <uix:checkBox name="monitor" checkedBinding="EXCLUDEORINCLUDE" readOnlyBinding="unchangable" /> 

                      <uix:switcher childNameBinding="unchangable">
                        <uix:case name="false">
                          <uix:image sourceBinding="moveUpIcon@apacheConfigData@servletRequest"
                                     shortDescBinding="MOVE_UP_COL_TEXT"
                                     onClickBinding="upImageOnClick" />
                        </uix:case>
                      </uix:switcher>

                      <uix:switcher childNameBinding="unchangable">
                        <uix:case name="false">
                          <uix:image  sourceBinding="moveDownIcon@apacheConfigData@servletRequest"
                                     shortDescBinding="MOVE_DOWN_COL_TEXT"
                                     onClickBinding="downImageOnClick" />
                        </uix:case>
                      </uix:switcher>
                    </uix:contents>
                  </uix:table> 

                  <uix:spacer width="1" height="10"/>
                  <uix:tip>
                    <uix:contents>
                      <uix:text textBinding="APACHE_URL_REGEX_TIP@webappMsg"/>
                    </uix:contents>
                  </uix:tip>
               </uix:stackLayout>

             </uix:rowLayout>

            </uix:tableLayout>
          </uix:header>

        </uix:pageLayout>
                <uix:formValue
                  name="<%=WebappConstants.APACHE_NAME%>"
                  valueBinding="apacheName"/>
                <uix:formValue
                  name="<%=WebappConstants.APACHE_TYPE%>"
                  valueBinding="apacheType"/>
      </uix:form>
    </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>