<%@ include file = "/sdk/oemTop.jspf"  %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
    <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:document>
    <%@ include file =" /oemTitle.jspf"  %>
    <uix:body>
    <uix:form name="customForm"
              method="POST">
    <uix:pageLayout>
      <%@ include file =" /oemGlobal.jspf"%>

      <uix:contents>
      <uix:switcher childNameBinding="dateInvalid@servletRequest">
        <uix:case name="true">
          <uix:messageBox messageBinding="errorMsg@servletRequest" messageType="error"/>
        </uix:case>
      </uix:switcher>      
    <uix:header textBinding="header@servletRequest" >
      <uix:formValue name="isDateInvalid" valueBinding="dateInvalid@servletRequest"/>
      <uix:rowLayout hAlign = "right">
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@sdkUIBundle"
                              shortDescBinding = "CANCEL@sdkUIBundle"
                              name="event"
                              value="cancel"/>
            <uix:submitButton textBinding="OK@sdkUIBundle"
                              shortDescBinding = "OK@sdkUIBundle"
                              name="event"
                              value="ok"/>
          </uix:pageButtonBar>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:spacer width ="20"/>
        <uix:styledText styleClass="OraPromptText"
                        textBinding="DATA_AVAILABLE_MSG@mntrResourceBundle"/>
        <uix:spacer width ="12"/>                
        <uix:styledText styleClass="OraDataText"
                        textBinding="dataAvailable@customPeriodData@servletRequest"/>
      </uix:rowLayout>
      <uix:spacer height ="20"/>
      <uix:tableLayout cellSpacing="20">
        <uix:rowLayout>
            <uix:messageDateField
                           promptBinding="START_DATE@sdkUIBundle"
                           name="startDate"
                           id="startDate"
                           tipBinding="dateTip@customPeriodData@servletRequest"
                           anchor="myAnchor"
                           shortDescBinding="START_DATE@sdkUIBundle"
                           columns="24"
                           required="yes"
                           valueBinding="startDate@customPeriodData@servletRequest">
                    <uix:onSubmitValidater>
                        <uix:date dateStyle="medium"/>
                    </uix:onSubmitValidater>
            </uix:messageDateField> 
            <uix:spacer width="5"/>
            
            <uix:messageDateField
                           promptBinding="END_DATE@sdkUIBundle"
                           name="endDate"
                           id="endDate"
                           tipBinding="dateTip@customPeriodData@servletRequest"
                           anchor="myAnchor"
                           shortDescBinding="END_DATE@sdkUIBundle"
                           columns="24"
                           required="yes"
                           valueBinding="endDate@customPeriodData@servletRequest">
                    <uix:onSubmitValidater>
                        <uix:date dateStyle="medium"/>
                    </uix:onSubmitValidater>
            </uix:messageDateField>            
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat>
          <uix:rowLayout>
            <uix:messageChoice promptBinding="START_HOUR@sdkUIBundle"
                           styleClass="OraPromptText"
                           name="startHour"
                           id="startHour"
                           required ="yes"
                           shortDescBinding="HOURS@sdkUIBundle"
                           selectedValueBinding="startHour@customPeriodData@servletRequest">
                <uix:option text="1" value="1"/>
                <uix:option text="2" value="2"/>
                <uix:option text="3" value="3"/>
                <uix:option text="4" value="4"/>
                <uix:option text="5" value="5"/>
                <uix:option text="6" value="6"/>
                <uix:option text="7" value="7"/>
                <uix:option text="8" value="8"/>
                <uix:option text="9" value="9"/>
                <uix:option text="10" value="10"/>
                <uix:option text="11" value="11"/>
                <uix:option text="12" value="12"/>
            </uix:messageChoice>
            <uix:spacer width="5"/>
            <uix:messageChoice name="startMinutes"
                               id="startMinutes"
                               shortDescBinding="MINUTES@sdkUIBundle"
                               selectedValueBinding="startMinutes@customPeriodData@servletRequest">
                <uix:option text="00" value="00"/>
                <uix:option text="05" value="05"/>
                <uix:option text="10" value="10"/>
                <uix:option text="15" value="15"/>
                <uix:option text="20" value="20"/>
                <uix:option text="25" value="25"/>
                <uix:option text="30" value="30"/>
                <uix:option text="35" value="35"/>
                <uix:option text="40" value="40"/>
                <uix:option text="45" value="45"/>
                <uix:option text="50" value="50"/>
                <uix:option text="55" value="55"/>
            </uix:messageChoice>
            
            <uix:spacer width="5"/>
            <uix:radioButton name="startTime"
                         textBinding="AM_LABEL@sdkUIBundle"
                         shortDescBinding="AM_LABEL@sdkUIBundle"
                         selectedValueBinding = "startTime@customPeriodData@servletRequest"
                         valueBinding="AM_LABEL@sdkUIBundle">
            </uix:radioButton>
            <uix:radioButton name="startTime"
                         textBinding="PM_LABEL@sdkUIBundle"
                         shortDescBinding="PM_LABEL@sdkUIBundle"
                         selectedValueBinding = "startTime@customPeriodData@servletRequest"
                         valueBinding="PM_LABEL@sdkUIBundle" >
            </uix:radioButton>
            </uix:rowLayout>
            </uix:cellFormat>
            <uix:cellFormat>
                <uix:spacer width="5"/>
            </uix:cellFormat>
            <uix:cellFormat>
            <uix:rowLayout>
            <uix:messageChoice promptBinding="END_HOUR@sdkUIBundle"
                           styleClass="OraPromptText"
                           name="endHour"
                           id="endHour"
                           required ="yes"
                           shortDescBinding="HOURS@sdkUIBundle"
                           selectedValueBinding="endHour@customPeriodData@servletRequest">
                <uix:option text="1" value="1"/>
                <uix:option text="2" value="2"/>
                <uix:option text="3" value="3"/>
                <uix:option text="4" value="4"/>
                <uix:option text="5" value="5"/>
                <uix:option text="6" value="6"/>
                <uix:option text="7" value="7"/>
                <uix:option text="8" value="8"/>
                <uix:option text="9" value="9"/>
                <uix:option text="10" value="10"/>
                <uix:option text="11" value="11"/>
                <uix:option text="12" value="12"/>
            </uix:messageChoice>
            <uix:spacer width="5"/>
            <uix:messageChoice name="endMinutes"
                               id="endMinutes"
                               shortDescBinding="MINUTES@sdkUIBundle"
                               selectedValueBinding="endMinutes@customPeriodData@servletRequest">
                <uix:option text="00" value="00"/>
                <uix:option text="05" value="05"/>
                <uix:option text="10" value="10"/>
                <uix:option text="15" value="15"/>
                <uix:option text="20" value="20"/>
                <uix:option text="25" value="25"/>
                <uix:option text="30" value="30"/>
                <uix:option text="35" value="35"/>
                <uix:option text="40" value="40"/>
                <uix:option text="45" value="45"/>
                <uix:option text="50" value="50"/>
                <uix:option text="55" value="55"/>
            </uix:messageChoice>
    
            <uix:spacer width="5"/>
            <uix:radioButton name="endTime"
                         textBinding="AM_LABEL@sdkUIBundle"
                         shortDescBinding="AM_LABEL@sdkUIBundle"
                         selectedValueBinding = "endTime@customPeriodData@servletRequest"
                         valueBinding="AM_LABEL@sdkUIBundle">
            </uix:radioButton>
            <uix:radioButton name="endTime"
                         textBinding="PM_LABEL@sdkUIBundle"
                         shortDescBinding="PM_LABEL@sdkUIBundle"
                         selectedValueBinding = "endTime@customPeriodData@servletRequest"
                         valueBinding="PM_LABEL@sdkUIBundle">
            </uix:radioButton> 
            </uix:rowLayout>
            </uix:cellFormat>
        </uix:rowLayout>
        </uix:tableLayout>

        <uix:formValue name="prevStartDate" valueBinding="startDate@customPeriodData@servletRequest"/>
        <uix:formValue name="prevStartHour" valueBinding="startHour@customPeriodData@servletRequest"/>
        <uix:formValue name="prevStartMinutes" valueBinding="startMinutes@customPeriodData@servletRequest"/>
        <uix:formValue name="prevStartTime" valueBinding="startTime@customPeriodData@servletRequest"/>
        <uix:formValue name="prevEndDate" valueBinding="endDate@customPeriodData@servletRequest"/>
        <uix:formValue name="prevEndHour" valueBinding="endHour@customPeriodData@servletRequest"/>
        <uix:formValue name="prevEndMinutes" valueBinding="endMinutes@customPeriodData@servletRequest"/>
        <uix:formValue name="prevEndTime" valueBinding="endTime@customPeriodData@servletRequest"/>
        <uix:formValue name="firstDataCollectedTime" valueBinding="firstDataCollectedTime@customPeriodData@servletRequest"/>
        <uix:formValue name="lastDataCollectedTime" valueBinding="lastDataCollectedTime@customPeriodData@servletRequest"/>
        <uix:formValue name="returnURL" valueBinding="returnURL@customPeriodData@servletRequest"/>
        <uix:formValue name="timeByPost" value="byCustom"/>
        <uix:formValue name="customTimeChoice" value="redirect" />
        
    </uix:header>       
    </uix:contents>
    <uix:contentFooter>
        <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@sdkUIBundle"
                            shortDescBinding = "CANCEL@sdkUIBundle"
                            name="event"
                            value="cancel"/>
          <uix:submitButton textBinding="OK@sdkUIBundle"
                            shortDescBinding = "OK@sdkUIBundle"
                            name="event"
                            value="ok"/>
        </uix:pageButtonBar>
    </uix:contentFooter>
    </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

