<%--

/* $Header: iasdmsloginpage.jsp 24-may-2007.17:23:03 rgraham Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      mvajapey  11/20/06 - Backport mvajapey_bug5630052 from main
      mvajapey  02/19/07 - adhoc support
      mvajapey  11/20/06 - Backport mvajapey_bug5630052 from main
      mvajapey  12/16/06 - ad hoc support
      andyao    09/23/05 - add auto complete 
      mvajapey  06/13/05 - ada bug 4427288. 
      mvajapey  02/06/05 - Add txnId to form. 
      mvajapey  01/28/05 - Add ctxType to form. 
      mvajapey  12/08/04 - Place cursor at password field. 
      rmarripa  06/10/03 - change the buttons order
      dbrown    05/28/03 - Set charset to utf-8.
      rmarripa  03/07/03 - remove ERR_OCCUR
      rmarripa  01/29/03 - remove checkbox and reset cancel
      rmarripa  01/16/03 - add target and type
      rmarripa  01/14/03 - add target name and type
      rmarripa  01/06/03 - change layout
      rmarripa  12/24/02 - rmarripa_e2e_trace_2
 */

/**
 *  @version $Header: iasdmsloginpage.jsp 24-may-2007.17:23:03 rgraham Exp $
 *  @author  rmarripa
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp"%>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.webapp.e2e.data.TraceConstants"%>
<%@ page import="oracle.sysman.eml.webapp.e2e.data.IASDMSLoginPageData"%>
<%@ page import="oracle.sysman.eml.webapp.WebappStr"%>
<%@ page import="oracle.cabo.ui.data.DataObject"%>
<%@ page import="oracle.cabo.ui.data.DataObjectList"%>
<%@ include file="/oemNoscript.jspf"%>

<jsp:useBean id="iasdmsCredsData" scope="request" type="oracle.sysman.eml.webapp.e2e.data.IASDMSLoginPageData"/>
<uix:renderingContext id="renderingContext">
  <oemjsp:setURLEncoder id="renderingContext"/>
  <uix:document>
    <head>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest"/>
      <uix:styleSheet/>
    </head>
    <uix:body onLoad="document.iasdmslogin.password0.focus()">
      <uix:form name="iasdmslogin" method="POST"> 
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <uix:stackLayout>
            <uix:contents>
              <uix:spacer height="5"/>
              <%--Login page start--%>
              <uix:header textBinding="pageHeader@iasdmsCredsData@servletRequest">
                <uix:switcher childNameBinding="nodeValue@iasdmsCredsData@servletRequest" defaultCase="okNode">
                  <uix:case name="errNode">
                    <uix:messageBox messageType="error" messageBinding="errorMessage@iasdmsCredsData@servletRequest"/>
                  </uix:case>
                </uix:switcher>
                <uix:stackLayout>
                  <uix:formValue name="<%=TraceConstants.NUM_DMS_LOGIN_REQ_PARAM%>" valueBinding="numberOfIASInst@iasdmsCredsData@servletRequest"/>
                 
                  <uix:styledText styleClass="OraPromptText" textBinding="IAS_DMS_LOGIN_INST_MSG@WebappMsgBundle@servletRequest"/>
                  <uix:tableLayout>
                    <%-- Login fields Start --%>
                    <%-- Repeating login screen per each DMS --%>
                    <%  int numberOfIASInst = Integer.parseInt(iasdmsCredsData.getNumberOfIASInst());
                   for (int i = 0; i < numberOfIASInst; i++)
                   {
                     String credsTitle = iasdmsCredsData.getCredsTitle(request, i);
                     
                     String realm = iasdmsCredsData.getRealm(i);
            
                     String userNameParamName = TraceConstants.USERNAME_PARAM + i;
                     String userName = iasdmsCredsData.getUserName(i);
                    
                     String passwdParamName = TraceConstants.PASSWORD_PARAM + i;
                    
                 %>
                    <uix:rowLayout>
                      <uix:header text="<%=credsTitle%>">
            
                        <uix:tableLayout width="100%" hAlign="left">
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraPromptText" textBinding="REALM_HDR@WebappMsgBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:spacer width="12"/>
                              <uix:styledText text="<%=realm%>" styleClass="OraInstructionTextStrong"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraPromptText" textBinding="USERNAME_HDR@WebappMsgBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:spacer width="8"/>
                              <uix:textInput shortDescBinding="USERNAME_HDR@WebappMsgBundle@servletRequest" name="<%=userNameParamName%>" columns="20" text="<%=userName%>"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraPromptText" textBinding="PASSWORD_HDR@WebappMsgBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:spacer width="8"/>
                              <uix:textInput shortDescBinding="PASSWORD_HDR@WebappMsgBundle@servletRequest" name="<%=passwdParamName%>" columns="20" secret="true" noAutoComplete="true" text=""/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:header>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:spacer height="10"/>
                    </uix:rowLayout>
                    <% 
                } //End for loop
               %>
                  </uix:tableLayout>
                </uix:stackLayout>
              </uix:header>
            </uix:contents>
          </uix:stackLayout>
          <uix:contentFooter>
            <uix:flowLayout>
              <uix:submitButton name="event" value="cancelLogin" textBinding="CANCEL_BTN_TEXT@WebappMsgBundle@servletRequest"/>
              <uix:spacer width="5"/>
              <uix:submitButton name="event" value="<%=TraceConstants.OK_EVENT%>" textBinding="OK_BTN_TEXT@WebappMsgBundle@servletRequest"/>
            </uix:flowLayout>
          </uix:contentFooter>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
