<%--

/* $Header: mainresults.jsp 24-may-2007.17:23:22 rgraham Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      mvajapey  11/20/06 - Backport mvajapey_bug5630052 from main
      mvajapey  02/19/07 - adhoc support 
      mvajapey  06/13/05 - ada bug 4427288. 
      jureyes   03/28/05 - Fix bug (remove extra error box)
      mvajapey  01/27/05 - Replace browser data table with an hGrid. 
      vjraghav  09/16/03 - 
      vjraghav  09/11/03 - 
      dbrown    05/28/03 - Set charset to utf-8.
      rmarripa  05/19/03 - fix help link
      rmarripa  03/07/03 - remove ERR_OCCUR
      rmarripa  01/16/03 - add txn name
      rmarripa  01/08/03 - change layout of summary and by URLsections
      rmarripa  12/27/02 - remove network time
      rmarripa  12/18/02 - change header and layout
      rmarripa  12/12/02 - rmarripa_e2e_trace_4.0.1
      rmarripa  12/05/02 - remove Total SQL Time 
 */

/**
 *  @version $Header: mainresults.jsp 24-may-2007.17:23:22 rgraham Exp $
 *  @author  rmarripa
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8"%> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp"%>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.emSDK.eml.jsp.tag.UIConstants"%>
<%@ page import="oracle.sysman.eml.webapp.e2e.data.TraceConstants"%>
<%@ include file="/oemNoscript.jspf"%>

 
<uix:renderingContext id="renderingContext">  
  <oemjsp:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <uix:document>
    <uix:head>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest"/>
      <uix:styleSheet/>
    </uix:head>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>
        <uix:stackLayout>
          <uix:contents>
            <%--Total Server Breakout Start--%>
            <uix:spacer height="5"/>
            <uix:header textBinding="txnPlayBackResultsHeader@e2ePlaybackData@servletRequest">
               <uix:switcher childNameBinding="nodeValue@e2ePlaybackData@servletRequest"
                            defaultCase="<%=Constants.OK_NODE_VALUE%>">
                  
                  <uix:case name="<%=TraceConstants.WARN_NODE_VALUE%>">
                     <uix:messageBox messageType="info" messageBinding="warnMessage@e2ePlaybackData@servletRequest"/>
                  </uix:case>
               </uix:switcher>
               <uix:stackLayout>
                    <uix:tableLayout width="100%">
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:button
                            destinationBinding="saveTxnDestination@e2ePlaybackData@servletRequest"
                            textBinding="SAVE_TRANSACTION@webappMsg"
                            renderedBinding="saveTxnDisplayed@e2ePlaybackData@servletRequest"/>
                        </uix:contents>   
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:spacer height="10"/>
                      </uix:rowLayout>
                      <uix:rowLayout width="100%" vAlign="top">
                        <uix:stackLayout>
                          <uix:spacer height="5"/>
                          <uix:tableLayout>
                            <uix:rowLayout width="100%">
                              <uix:cellFormat hAlign="left" vAlign="top">
                                <uix:header textBinding="RESP_TIME_OVERVIEW_HDR@webappMsg">
                                  <oemjsp:chart chartType="pieChart" title="n/a" titleVisible="false" width="400" height="200" hideZeroSlices="true" seriesColorsAutomatic="true" showSlicePercentLabels="true" legendPosition="east">
                                    <uix:contents>
                                      <oemjsp:boundChartDataSource chartDataSourceBinding="totalRespAggChartData@e2ePlaybackData@servletRequest"/>
                                      <oemjsp:chartColumn isKey="true" sourceIndex="0"/>
                                      <oemjsp:chartColumn sourceIndex="1"/>
                                    </uix:contents>
                                  </oemjsp:chart>
                                  <uix:labeledFieldLayout labelWidth="250" fieldWidth="50" columns="1" width="80%">
                                    <uix:styledText textBinding="TRANSACTION_STATUS@webappMsg"/>
                                    <uix:styledText textBinding="txnStatus@browserDataBean@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                                    <uix:styledText textBinding="TOTAL_RESPONSE_HDR@webappMsg"/>
                                    <uix:styledText textBinding="totalRespTime@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                                    <uix:styledText textBinding="TOTAL_SERVER_TIME_HDR@webappMsg"/>
                                    <uix:styledText textBinding="totalServerTime@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                                    <uix:styledText textBinding="AVG_RESPONSE_HDR@webappMsg"/>
                                    <uix:styledText textBinding="avgRespTime@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                                    <uix:styledText textBinding="MAX_RESPONSE_HDR@webappMsg"/>
                                    <uix:styledText textBinding="maxResponseTime@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                                  </uix:labeledFieldLayout>
                                </uix:header>
                              </uix:cellFormat>
                              <uix:cellFormat width="15%">
                                <uix:spacer width="25"/>
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="right" vAlign="top">
                                <uix:header textBinding="TRACE_SERVER_RESP_BYCOMP_HEADER@webappMsg">
                                  <oemjsp:chart chartType="pieChart" title="n/a" titleVisible="false" width="400" height="200" showSlicePercentLabels="true" hideZeroSlices="true" legendPosition="east">
                                    <uix:contents>
                                      <oemjsp:boundChartDataSource chartDataSourceBinding="srvRespAggChartData@e2ePlaybackData@servletRequest"/>
                                      <oemjsp:chartColumn isKey="true" sourceIndex="0"/>
                                      <oemjsp:chartColumn sourceIndex="1"/>
                                    </uix:contents>
                                  </oemjsp:chart>
                                  <uix:labeledFieldLayout labelWidth="150" fieldWidth="10" width="48%" columns="1">
                                    <uix:styledText textBinding="SVLT_JSP_TIME_HDR@webappMsg"/>
                                    <uix:styledText textBinding="totalSvltJSPTime@e2ePlaybackData@servletRequest" destinationBinding="svltDetailsLink@e2ePlaybackData@servletRequest"/>
                                    <uix:styledText textBinding="EJB_TIME_HDR@webappMsg"/>
                                    <uix:styledText textBinding="totalEJBTime@e2ePlaybackData@servletRequest" destinationBinding="ejbDetailsLink@e2ePlaybackData@servletRequest"/>
                                    <uix:styledText textBinding="JDBC_TIME_HDR@webappMsg"/>
                                    <uix:styledText textBinding="totalJDBCTime@e2ePlaybackData@servletRequest" destinationBinding="jdbcDetailsLink@e2ePlaybackData@servletRequest"/>
                                  </uix:labeledFieldLayout>
                                </uix:header>
                              </uix:cellFormat>
                            </uix:rowLayout>
                          </uix:tableLayout>
                        </uix:stackLayout>
                      </uix:rowLayout>
                      <%--Total Server Breakout End--%>
                      <%--URL Response Breakout Start--%>
                      <uix:rowLayout>
                        <uix:spacer height="10"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:header textBinding="SERVER_TIME_DETAILS@webappMsg">
                          <uix:rowLayout>
                            <uix:styledText textBinding="SERVER_TIME_TIP@webappMsg" styleClass="OraInstructionText"/>
                          </uix:rowLayout>
                          <uix:tableLayout width="100%">
                            <uix:rowLayout>
                              <uix:spacer height="10"/>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:table summaryBinding="SERVER_TIME_DETAILS@webappMsg"
                                         id="e2eUrlTableId" alternateTextBinding="NO_DATA_AVAIL@webappMsg" width="100%" tableDataBinding="tableDataKey@tableData@e2ePlaybackData@servletRequest" destinationBinding="tableDestination@e2ePlaybackData@servletRequest" columnFormatsBinding="columnFormats@e2ePlaybackData@servletRequest" columnHeaderDataBinding="columnHeaderData@e2ePlaybackData@servletRequest">
                                <uix:tableFormat tableBanding="rowBanding"/>
                                <uix:columnHeaderStamp>
                                  <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                                </uix:columnHeaderStamp>
                                <uix:contents>
                                  <uix:styledText textBinding="<%=TraceConstants.ORDER_KEY%>"/>
                                  <uix:styledText textBinding="<%=TraceConstants.REQUEST_KEY%>" shortDescBinding="<%=TraceConstants.URL_DESC%>"/>
                                  <uix:styledText textBinding="<%=TraceConstants.TOTAL_SERV_RESP_KEY%>"/>
                                  <uix:styledText textBinding="<%=TraceConstants.SVLTJSP_TIME_KEY%>" destinationBinding="<%=TraceConstants.SVLTJSP_COMP_DEST_KEY%>"/>
                                  <uix:styledText textBinding="<%=TraceConstants.EJB_TIME_KEY%>" destinationBinding="<%=TraceConstants.EJB_COMP_DEST_KEY%>"/>
                                  <uix:styledText textBinding="<%=TraceConstants.JDBC_TIME_KEY%>" destinationBinding="<%=TraceConstants.JDBC_COMP_DEST_KEY%>"/>
                                  <uix:include nodeBinding="cigar@"/>
                                </uix:contents>
                              </uix:table>
                            </uix:rowLayout>
                            <uix:spacer height="5"/>
                            <uix:rowLayout hAlign="right">
                              <uix:include nodeBinding="e2eUrlTableLegend@e2ePlaybackData@servletRequest"/>
                            </uix:rowLayout>
                          </uix:tableLayout>
                        </uix:header>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:spacer height="10"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                          <%@ include file="/webapp/e2e/trace/browsertree.jspf" %>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:stackLayout>
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
        <uix:contentFooter>
          <uix:pageButtonBar/>
        </uix:contentFooter>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
