<%--

/* $Header: traceNodeStack.jsp 24-may-2007.17:23:45 rgraham Exp $ */
/* Copyright (c) 2, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      mvajapey  12/16/06 - adhoc support
      mvajapey  09/10/05 - Make SQL drilldown links server-side redirects (bug 
                           4600305). 
      mvajapey  06/13/05 - ada bug 4427288. 
      mvajapey  01/27/05 - Remove tgt name and tgt type from form submission 
                           (placed in url). 
      mvajapey  12/22/04 - Add hideShow box to display long component names. 
      mvajapey  11/23/04 - Incorporate various UI changes. 
      andyao    11/12/04 - add license check 
      ratadiko  11/09/04 - Fix for bug# 3998377 
      dbrown    05/28/03 - Set charset to utf-8.
      rmarripa  05/19/03 - fix help link
      rmarripa  03/07/03 - remove ERR_OCCUR
      rmarripa  01/24/03 - add conn details
      rmarripa  01/16/03 - add tip
      rmarripa  12/27/02 - add droplist with call numbers
      rmarripa  12/18/02 - change header and layout
      rmarripa  12/12/02 - rmarripa_e2e_trace_4.0.1
 */

/**
 *  @version $Header: traceNodeStack.jsp 24-may-2007.17:23:45 rgraham Exp $
 *  @author  rmarripa
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp"%>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.webapp.e2e.data.TraceConstants"%>
<%@ include file="/oemNoscript.jspf"%>

<jsp:useBean id="e2ePlaybackData" scope="request" type="oracle.sysman.eml.webapp.e2e.data.J2EECompTraceDetails"/>

<script language="JavaScript">

function go() 
{
  var anchor = '<%= e2ePlaybackData.getAnchor() %>';
  if (anchor.length > 0 ) 
    location.href = '#' + anchor;
  document.traceCompStack.callChoiceNum.focus();  
}

function changeInvocPath()
{
  var form = document.traceCompStack;
  form.anchor.value = 'callInvocStack';
  submitForm(form, false, {event:'<%= TraceConstants.SHOW_DETAILS_EVENT %>'});
}

</script>

<uix:renderingContext id="renderingContext">
  <oemjsp:setURLEncoder id="renderingContext"/>
  <uix:document>
    <head>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest"/>
      <uix:styleSheet/>
    </head>
    <uix:body onLoad="go();">
      
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>
        <uix:stackLayout>
          <uix:contents>
            <uix:spacer height="5"/>
            <%--Total Server Breakout Start--%>
            <uix:header textBinding="pageHeader@e2ePlaybackData@servletRequest">
              <uix:form name="traceCompStack" method="POST" destinationBinding="formDest@e2ePlaybackData@servletRequest">
                <uix:formValue name="ecid" valueBinding="ECID@e2ePlaybackData@servletRequest"/>
                <uix:formValue name="drillDownSrc" valueBinding="drillDownSrc@e2ePlaybackData@servletRequest"/>
                <uix:formValue name="rowIndex" valueBinding="rowIndex@e2ePlaybackData@servletRequest"/>
                <uix:formValue name="j2eecomp" valueBinding="detailType@e2ePlaybackData@servletRequest"/>
                <uix:formValue name="j2eeCompIdx" valueBinding="j2eeCompIdx@e2ePlaybackData@servletRequest"/>
                <uix:formValue name="txnName" valueBinding="txnName@e2ePlaybackData@servletRequest"/>
                <uix:formValue name="<%=TraceConstants.SORTED_COLUMN_INDEX_PARAM%>" valueBinding="sortedColumnIndexString@e2ePlaybackData@servletRequest" />  
                <uix:formValue name="<%=TraceConstants.SORTED_COLUMN_STATE_PARAM%>" valueBinding="sortedColumnStateString@e2ePlaybackData@servletRequest" />
                <uix:formValue name="<%=TraceConstants.SHOW_HIDE_PARAM%>" valueBinding="hideShowString@e2ePlaybackData@servletRequest" />
                <uix:formValue name="<%=TraceConstants.ANCHOR_PARAM%>" />
                <uix:spacer height="10"/>
                <uix:switcher childNameBinding="nodeValue@e2ePlaybackData@servletRequest" defaultCase="okNode">
                  <uix:case name="errNode">
                    <uix:messageBox messageType="error" messageBinding="errorMessage@e2ePlaybackData@servletRequest"/>
                  </uix:case>
                </uix:switcher>
                <uix:tableLayout>
                  <uix:rowLayout>
                    <uix:spacer height="10"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="2"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="URL_HDR@WebappMsgBundle@servletRequest" styleClass="OraPromptText"/>
                    </uix:cellFormat>
                    <uix:spacer width="8"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText textBinding="urlName@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="2"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="detailComponentName@e2ePlaybackData@servletRequest" styleClass="OraPromptText"/>
                    </uix:cellFormat>
                    <uix:spacer width="8"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText textBinding="j2EETruncComponentName@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="2"/>
                  </uix:rowLayout>
                  <uix:switcher childNameBinding="tableType@e2ePlaybackData@servletRequest">
                    <uix:case name="jdbcTable">
                      <uix:rowLayout>
                        <uix:cellFormat/>
                        <uix:spacer width="8"/>
                        <uix:cellFormat hAlign="left">
                          <oemjsp:license>
                            <uix:link textBinding="SQL_STATEMENT_ANALYSIS@WebappMsgBundle@servletRequest" destinationBinding="sqlAnalysisLink@e2ePlaybackData@servletRequest" renderedBinding="showAnalaysis"/>
                          </oemjsp:license>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                  <uix:switcher childNameBinding="longCompName@e2ePlaybackData@servletRequest">
                    <uix:case name="true">
                        <uix:hideShowHeader formSubmitted="true"
                                      textBinding="hideShowHeaderName@e2ePlaybackData@servletRequest"  
                                      id="nameHideId" disclosedBinding="hideShow@e2ePlaybackData@servletRequest">
                          <uix:stackLayout>
                            <uix:textInput shortDescBinding="j2EETruncComponentName@e2ePlaybackData@servletRequest" columnsBinding="lenThreshold@e2ePlaybackData@servletRequest" rows="5" readOnly="true" textBinding="j2EEComponentName@e2ePlaybackData@servletRequest"/>
                          </uix:stackLayout>
                        </uix:hideShowHeader>
                    </uix:case>
                  </uix:switcher>
                </uix:tableLayout>
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:spacer height="10"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:header textBinding="ALL_COMP_CALLS_HDR@WebappMsgBundle@servletRequest">
                      <uix:contents>
                        <uix:styledText textBinding="invocPathInstrText@e2ePlaybackData@servletRequest" styleClass="OraInstructionText"/>
                      </uix:contents>
                      <uix:switcher childNameBinding="tableType@e2ePlaybackData@servletRequest">
                        <uix:case name="svltjspTable">
                          <%@ include file="svltjspdetailtable.jspf"%>
                        </uix:case>
                        <uix:case name="ejbTable">
                          <%@ include file="ejbdetailtable.jspf"%>
                        </uix:case>
                        <uix:case name="jdbcTable">
                          <%@ include file="jdbcdetailtable.jspf"%>
                        </uix:case>
                      </uix:switcher>
                      <uix:spacer height="10"/>
                    </uix:header>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="10"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:header textBinding="INV_PATH_DET_HDR@WebappMsgBundle@servletRequest">
                      <uix:stackLayout>
                        <uix:link id="callInvocStack"/>
                        <uix:rowLayout>
                          <uix:styledText textBinding="CALL_STACK_HDR@WebappMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                          <uix:spacer width="8"/>
                          <uix:choice shortDescBinding="CALL_STACK_HDR@WebappMsgBundle@servletRequest"
                                      name="<%=TraceConstants.CALL_CHOIE_PARAM%>" 
                                      onChange="changeInvocPath()" selectedValueBinding="j2eeCompIdx@e2ePlaybackData@servletRequest">
                            <uix:contents childDataBinding="callsList@e2ePlaybackData@servletRequest">
                              <uix:option textBinding="text" valueBinding="value" renderedBinding="rendered"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:rowLayout>
                        <uix:switcher childNameBinding="tableType@e2ePlaybackData@servletRequest">
                          <uix:case name="jdbcTable">
                            <uix:stackLayout>
                              <uix:header textBinding="CONNECTION_DETAILS_HEADER@WebappMsgBundle@servletRequest">
                                <uix:tableLayout>
                                  <uix:rowLayout>
                                    <uix:spacer height="10"/>
                                  </uix:rowLayout>
                                  <uix:rowLayout>
                                    <uix:cellFormat hAlign="right">
                                      <uix:styledText textBinding="DATASOURCE_HDR@WebappMsgBundle@servletRequest" styleClass="OraPromptText"/>
                                    </uix:cellFormat>
                                    <uix:spacer width="8"/>
                                    <uix:cellFormat hAlign="left">
                                      <uix:styledText textBinding="connectionDataSource@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                                    </uix:cellFormat>
                                  </uix:rowLayout>
                                  <uix:rowLayout>
                                    <uix:cellFormat hAlign="right">
                                      <uix:styledText textBinding="SCHEMA_HDR@WebappMsgBundle@servletRequest" styleClass="OraPromptText"/>
                                    </uix:cellFormat>
                                    <uix:spacer width="8"/>
                                    <uix:cellFormat hAlign="left">
                                      <uix:styledText textBinding="connectionSchema@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                                    </uix:cellFormat>
                                  </uix:rowLayout>
                                </uix:tableLayout>
                              </uix:header>
                              <uix:spacer height="10"/>
                              <uix:header textBinding="CALL_STACK_HDR@WebappMsgBundle@servletRequest">
                                <uix:rowLayout>
                                  <uix:styledText textBinding="invocPathBoldExpl@e2ePlaybackData@servletRequest" styleClass="OraInstructionText"/>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:styledText textBinding="INVOC_OTHER_EXPLANATION@WebappMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:spacer height="10"/>
                                </uix:rowLayout>
                                <%@ include file="j2eegrid.jspf"%>
                              </uix:header>
                            </uix:stackLayout>
                          </uix:case>
                          <uix:case name="svltjspTable">
                            <uix:stackLayout>
                              <uix:rowLayout>
                                <uix:spacer height="15"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:styledText textBinding="invocPathBoldExpl@e2ePlaybackData@servletRequest" styleClass="OraInstructionText"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:styledText textBinding="INVOC_OTHER_EXPLANATION@WebappMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer height="10"/>
                              </uix:rowLayout>
                              <%@ include file="j2eegrid.jspf"%>
                            </uix:stackLayout>
                          </uix:case>
                          <uix:case name="ejbTable">
                            <uix:stackLayout>
                              <uix:rowLayout>
                                <uix:spacer height="15"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:styledText textBinding="invocPathBoldExpl@e2ePlaybackData@servletRequest" styleClass="OraInstructionText"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:styledText textBinding="INVOC_OTHER_EXPLANATION@WebappMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer height="10"/>
                              </uix:rowLayout>
                              <%@ include file="j2eegrid.jspf"%>
                            </uix:stackLayout>
                          </uix:case>
                        </uix:switcher>
                      </uix:stackLayout>
                    </uix:header>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:form>
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
        <uix:contentFooter>
          <uix:pageButtonBar/>
        </uix:contentFooter>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
