<%--

/* $Header: tracedetails.jsp 13-jun-2005.20:00:39 mvajapey Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    mvajapey       06/13/05 - ada bug 4427288. 
    mvajapey       11/29/04 - Incorporate various UI changes. 
    dbrown         05/28/03 - Set charset to utf-8.
    rmarripa       05/19/03 - fix help link
    rmarripa       03/07/03 - remove ERR_OCCUR
    rmarripa       01/24/03 - add conn details
    rmarripa       01/16/03 - add spacer
    rmarripa       01/13/03 - add breadcrumbs
    rmarripa       12/27/02 - make sortable columns
    rmarripa       12/18/02 - change header and layout
    rmarripa       12/12/02 - rmarripa_e2e_trace_4.0.1
    rmarripa       12/09/02 - add txn and url namne
    rmarripa       11/20/02 - add tree ui
    rmarripa       10/11/02 - change the class name,
    rmarripa       10/11/02 - creation
 */

/**
 *  @version $Header: tracedetails.jsp 13-jun-2005.20:00:39 mvajapey Exp $
 *  @author  rmarripa
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp"%>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.webapp.e2e.data.TraceConstants"%>
<%@ include file="/oemNoscript.jspf"%>

<jsp:useBean id="e2ePlaybackData" scope="request" type="oracle.sysman.eml.webapp.e2e.data.TraceResultDetails"/>
<uix:renderingContext id="renderingContext">
  <oemjsp:setURLEncoder id="renderingContext"/>
  <uix:document>
    <head>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest"/>
      <uix:styleSheet/>
    </head>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>
        <uix:stackLayout>
          <uix:contents>
            <%--Total Server Breakout Start--%>
            <uix:spacer height="5"/>
            <uix:header textBinding="pageHeader@e2ePlaybackData@servletRequest">
              <uix:spacer height="10"/>
              <uix:switcher childNameBinding="nodeValue@e2ePlaybackData@servletRequest" defaultCase="okNode">
                <uix:case name="errNode">
                  <uix:messageBox messageType="error" messageBinding="errorMessage@e2ePlaybackData@servletRequest"/>
                </uix:case>
              </uix:switcher>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:spacer height="10"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="URL_HDR@WebappMsgBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:spacer width="8"/>
                    <uix:styledText textBinding="urlName@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:tableLayout width="100%">
                <uix:rowLayout width="100%" vAlign="top">
                  <uix:switcher childNameBinding="showConnDetails@e2ePlaybackData@servletRequest">
                    <uix:case name="show">
                      <uix:header textBinding="CONNECTION_DETAILS_HEADER@WebappMsgBundle@servletRequest">
                        <uix:spacer height="10"/>
                        <uix:table summaryBinding="CONNECTION_DETAILS_HEADER@WebappMsgBundle@servletRequest"
                                   id="connTable" alternateTextBinding="NO_JDBC_CONN_INFO@WebappMsgBundle@servletRequest" width="100%" tableDataBinding="tableDataKey@connTableData@e2ePlaybackData@servletRequest" columnFormatsBinding="connTableColFormats@e2ePlaybackData@servletRequest" columnHeaderDataBinding="connTableColHeaders@e2ePlaybackData@servletRequest">
                          <uix:columnHeaderStamp>
                            <uix:text textBinding="text"/>
                          </uix:columnHeaderStamp>
                          <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:contents>
                            <uix:styledText textBinding="connDataSourceKey"/>
                            <uix:styledText textBinding="schemaKey"/>
                            <uix:styledText textBinding="newConnKey"/>
                            <uix:styledText textBinding="connTimeKey"/>
                          </uix:contents>
                        </uix:table>
                      </uix:header>
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>
                <%-- Tree representation of position --%>
                <uix:rowLayout>
                  <uix:spacer height="10"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:header textBinding="tableHeader@e2ePlaybackData@servletRequest">
                    <uix:form name="traceDetailTable" method="POST" destinationBinding="componentsTableDest@e2ePlaybackData@servletRequest">
                      <uix:formValue name="<%=TraceConstants.SORTED_COLUMN_INDEX_PARAM%>" valueBinding="sortedColumnIndexString@e2ePlaybackData@servletRequest"/>
                      <uix:formValue name="<%=TraceConstants.SORTED_COLUMN_STATE_PARAM%>" valueBinding="sortedColumnStateString@e2ePlaybackData@servletRequest"/>
                      <uix:formValue name="<%=TraceConstants.TABLE_START_INDEX_PARAM%>" valueBinding="tableStartIndexString@e2ePlaybackData@servletRequest"/>
                      <uix:spacer height="5"/>
                      <uix:switcher childNameBinding="tableType@e2ePlaybackData@servletRequest">
                        <uix:case name="svltjspTable">
                          <%@ include file="svltjsptable.jspf"%>
                        </uix:case>
                        <uix:case name="ejbTable">
                          <%@ include file="ejbtable.jspf"%>
                        </uix:case>
                        <uix:case name="jdbcTable">
                          <%@ include file="jdbctable.jspf"%>
                        </uix:case>
                      </uix:switcher>
                    </uix:form>
                  </uix:header>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
        <uix:contentFooter>
          <uix:pageButtonBar/>
        </uix:contentFooter>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
