<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.webapp.eum.data.EUMConstants"%>

<uix:renderingContext id="renderingContext">
<oemjsp:setURLEncoder id="renderingContext"/>
<uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg" />
	<uix:document>
  	<%@ include file="/oemTitle.jspf"%>
  	<uix:styleSheet/>

  	<uix:body>
   		<uix:pageLayout>
     		<%@ include file="/oemGlobal.jspf"%>
     		<uix:dataScope currentDataBinding="requestComponentsData@servletRequest" >
          <uix:switcher childNameBinding="hasError">
            <uix:case name="<%=Boolean.TRUE%>">
	            <uix:messageBox messageBinding="errorMsg" messageType="error"/>
						</uix:case>
					</uix:switcher>

          <%--uix:switcher childNameBinding="isLargeResultSet"
                        defaultCase="<%=EUMConstants.NOT_LARGE%>">
            <uix:case name="<%=EUMConstants.LARGE%>">
              <uix:messageBox messageType="info" messageBinding="largeResultSetMsg"/>
            </uix:case>
          </uix:switcher--%>

					<uix:header textBinding="pageHeader">
       			<uix:contents>
							<uix:subTabBar selectedIndex="1">
								<uix:contents>
									<uix:link textBinding="homeTabText" destinationBinding="homeTabDest"/>
									<uix:link textBinding="requestTabText" destinationBinding="requestTabDest"/>
								</uix:contents>
							</uix:subTabBar>

									<%@include file="webappTimeChoice.jspf" %>

				          <uix:form name="requestComponent" method="POST">
									<uix:tableLayout width="100%"> 

										<uix:rowLayout>							
									    	<uix:header textBinding="PAGE_REQUEST_PERF@webappMsg">
													<uix:stackLayout>
														<uix:contents>
															<%--uix:styledText textBinding="PAGE_REQUEST_PERF_DESC@webappMsg" styleClass="OraPromptText" />
                              <uix:spacer height="3"/--%>
															<uix:table 	id="pageRequestsTbl"
                                          width="100%"
																					alternateTextBinding="NO_RESULTS_ALT_TEXT@webappMsg"
																					destinationBinding="currentRequest@servletRequest"
																					tableDataBinding="pageRequestsTableData"
                                          blockSizeBinding="blockSize"
                                          valueBinding="pageTableValue"
                                          maxValueBinding="pageMaxValue"
                                          summaryBinding="PAGE_REQUEST_PERF@webappMsg">
																<uix:tableFormat 
																					tableBanding="rowBanding"/>

																<uix:contents>
																	<uix:column>
																		<uix:columnFormat columnDataFormat="textFormat" width="40%"/>
																		<uix:columnHeader>
																			<uix:sortableHeader textBinding="requestColHdr@columnHeaders@requestComponentsData@servletRequest"
																													sortableBinding="pageUrlSortable@sortStates@requestComponentsData@servletRequest" value="0"/>	
																		</uix:columnHeader>
																<uix:contents>
																	<uix:link textBinding="requestUrlName" destinationBinding="requestUrlDest" disabledBinding="requestUrlDisabled"/>
																</uix:contents>
															</uix:column>

																	<uix:columnGroup>
																		<uix:columnHeader>
																			<uix:text textBinding="webcacheColGrpHdr@columnHeaders@requestComponentsData@servletRequest"/>
																		</uix:columnHeader>
																		<uix:contents>
																			<uix:column>
																				<uix:columnFormat columnDataFormat="numberFormat" width="15%"/>
																				<uix:columnHeader>
																					<uix:sortableHeader textBinding="countColHdr@columnHeaders@requestComponentsData@servletRequest"
																															sortableBinding="pageWebcacheCountSortable@sortStates@requestComponentsData@servletRequest" value="1"/>	
																				</uix:columnHeader>
																				<uix:contents>
																					<uix:text textBinding="webcacheCount"/>
																				</uix:contents>
																			</uix:column>
																			<uix:column>
																				<uix:columnFormat columnDataFormat="numberFormat" width="15%"/>
																				<uix:columnHeader>
																					<uix:sortableHeader textBinding="webcacheRadioColHdr@columnHeaders@requestComponentsData@servletRequest"
																															sortableBinding="pageWebcacheRatioSortable@sortStates@requestComponentsData@servletRequest" value="2"/>	
																				</uix:columnHeader>
																				<uix:contents>
																					<uix:text textBinding="webcacheRatio"/>
																				</uix:contents>
																			</uix:column>		
																		</uix:contents>
																	</uix:columnGroup>	

																	<uix:columnGroup>
																		<uix:columnHeader>
																			<uix:text textBinding="webserverColGrpHdr@columnHeaders@requestComponentsData@servletRequest"/>
																		</uix:columnHeader>
																		<uix:contents>
																			<uix:column>
																				<uix:columnFormat columnDataFormat="numberFormat" width="15%"/>
																				<uix:columnHeader>
																					<uix:sortableHeader textBinding="countColHdr@columnHeaders@requestComponentsData@servletRequest"
																															sortableBinding="pageWebserverCountSortable@sortStates@requestComponentsData@servletRequest" value="3"/>	
																				</uix:columnHeader>
																				<uix:contents>
																					<uix:text textBinding="webserverCount"/>
																				</uix:contents>
																			</uix:column>
																			<uix:column>
																				<uix:columnFormat columnDataFormat="numberFormat" width="15%"/>
																				<uix:columnHeader>
																					<uix:sortableHeader textBinding="avgtimeColHdr@columnHeaders@requestComponentsData@servletRequest"
																															sortableBinding="pageWebserverTimeSortable@sortStates@requestComponentsData@servletRequest" value="4"/>
																				</uix:columnHeader>
																				<uix:contents>
																					<uix:text textBinding="webserverTime"/>
																				</uix:contents>
																			</uix:column>		
																		</uix:contents>
																	</uix:columnGroup>
														</uix:contents>
													</uix:table>
												</uix:contents>
											</uix:stackLayout>
											</uix:header>
									</uix:rowLayout>

											<uix:rowLayout>
											<uix:stackLayout>
											<uix:spacer height="10"/>
											</uix:stackLayout>
											</uix:rowLayout>

												<uix:rowLayout>	
														<uix:contents>	
															<uix:cellFormat vAlign="top" hAlign="left">
									    				<uix:header textBinding="PAGE_REQUEST_PERF_ALL@webappMsg">
															<uix:stackLayout>
															<uix:contents>
																<uix:styledText textBinding="PAGE_REQUEST_PERF_ALL_DESC@webappMsg" styleClass="OraPromptText" />
                                  <uix:spacer height="3"/>
																	<uix:table 	id="allRequestsTbl"
                                              width="100%"
																			        alternateTextBinding="NO_RESULTS_ALT_TEXT@webappMsg"
																			        destinationBinding="currentRequest@servletRequest"
																			        tableDataBinding="allRequestsTableData"
                                              blockSizeBinding="blockSize"
                                              valueBinding="allTableValue"
                                              maxValueBinding="allMaxValue"
                                              summaryBinding="PAGE_REQUEST_PERF_ALL@webappMsg">
	
														<uix:tableFormat 
																			tableBanding="rowBanding"/>

														<uix:contents>

															<uix:column>
																<uix:columnFormat columnDataFormat="textFormat" width="30%"/>
																<uix:columnHeader>
																	<uix:sortableHeader textBinding="requestColHdr@columnHeaders@requestComponentsData@servletRequest"
																											sortableBinding="allUrlSortable@sortStates@requestComponentsData@servletRequest" value="0"/>
																</uix:columnHeader>
																<uix:contents>
																	<uix:link textBinding="requestUrlName" destinationBinding="requestUrlDest" disabledBinding="requestUrlDisabled"/>
																</uix:contents>
															</uix:column>

																	<uix:columnGroup>
																		<uix:columnHeader>
																			<uix:text textBinding="webcacheColGrpHdr@columnHeaders@requestComponentsData@servletRequest"/>
																		</uix:columnHeader>
																		<uix:contents>
																			<uix:column>
																				<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
																				<uix:columnHeader>
																					<uix:sortableHeader textBinding="countColHdr@columnHeaders@requestComponentsData@servletRequest"
																															sortableBinding="allWebcacheCountSortable@sortStates@requestComponentsData@servletRequest" value="1"/>
																				</uix:columnHeader>
																				<uix:contents>
																					<uix:text textBinding="webcacheCount"/>
																				</uix:contents>
																			</uix:column>
																			<uix:column>
																				<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
																				<uix:columnHeader>
																					<uix:sortableHeader textBinding="webcacheRadioColHdr@columnHeaders@requestComponentsData@servletRequest"
																															sortableBinding="allWebcacheRatioSortable@sortStates@requestComponentsData@servletRequest" value="2"/>
																				</uix:columnHeader>
																				<uix:contents>
																					<uix:text textBinding="webcacheRatio"/>
																				</uix:contents>
																			</uix:column>
																			
																		</uix:contents>
																	</uix:columnGroup>	
																	<uix:columnGroup>
																		<uix:columnHeader>
																			<uix:text textBinding="webserverColGrpHdr@columnHeaders@requestComponentsData@servletRequest"/>
																		</uix:columnHeader>
																		<uix:contents>
																			<uix:column>
																				<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
																				<uix:columnHeader>
																					<uix:sortableHeader textBinding="countColHdr@columnHeaders@requestComponentsData@servletRequest"
																															sortableBinding="allWebserverCountSortable@sortStates@requestComponentsData@servletRequest" value="3"/>
																				</uix:columnHeader>
																				<uix:contents>
																					<uix:text textBinding="webserverCount"/>
																				</uix:contents>
																			</uix:column>
																			<uix:column>
																				<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
																				<uix:columnHeader>
																					<uix:sortableHeader textBinding="avgtimeColHdr@columnHeaders@requestComponentsData@servletRequest"
																															sortableBinding="allWebserverTimeSortable@sortStates@requestComponentsData@servletRequest" value="4"/>
																				</uix:columnHeader>
																				<uix:contents>
																					<uix:text textBinding="webserverTime"/>
																				</uix:contents>
																			</uix:column>		
																		</uix:contents>
																	</uix:columnGroup>			

															<uix:columnGroup>
																<uix:columnHeader>
																		<uix:text textBinding="appserverColGrpHdr@columnHeaders@requestComponentsData@servletRequest"/>
																</uix:columnHeader>
																<uix:contents>
																	<uix:column>
																		<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
																		<uix:columnHeader>
																			<uix:sortableHeader textBinding="countColHdr@columnHeaders@requestComponentsData@servletRequest"
																													sortableBinding="allAppserverCountSortable@sortStates@requestComponentsData@servletRequest" value="5"/>
																		</uix:columnHeader>
																		<uix:contents>
																			<uix:text textBinding="appserverCount"/>
																		</uix:contents>
																	</uix:column>
																	<uix:column>
																		<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
																		<uix:columnHeader>
																			<uix:sortableHeader textBinding="avgtimeColHdr@columnHeaders@requestComponentsData@servletRequest"
																													sortableBinding="allAppserverTimeSortable@sortStates@requestComponentsData@servletRequest" value="6"/>
																		</uix:columnHeader>
																		<uix:contents>
																			<uix:text textBinding="appserverTime"/>
																		</uix:contents>
																	</uix:column>	
                                </uix:contents>
															</uix:columnGroup>
					                   
																	<uix:column>
																		<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
																		<uix:columnHeader>
																			<uix:sortableHeader textBinding="dbtimeColHdr@columnHeaders@requestComponentsData@servletRequest"
																													sortableBinding="allDBserverTimeSortable@sortStates@requestComponentsData@servletRequest" value="7"/>
																		</uix:columnHeader>
																		<uix:contents>
																			<uix:text textBinding="dbserverTime"/>
																		</uix:contents>
																	</uix:column>	

																	<uix:column>
																		<uix:columnFormat width="35%"/>
																		<uix:columnHeader>
																			<uix:text textBinding="cigarColHdr@columnHeaders@requestComponentsData@servletRequest"/>
																		</uix:columnHeader>
																		<uix:contents>
																			<uix:include nodeBinding="cigar"/>
																		</uix:contents>
																	</uix:column>
																

														</uix:contents>
													</uix:table>

											<uix:rowLayout>
											<uix:stackLayout>
											<uix:spacer height="3"/>
											</uix:stackLayout>
											</uix:rowLayout>

														<uix:rowLayout hAlign="right">
                             <uix:include nodeBinding="oc4jTableLegend" />
                            </uix:rowLayout>

													</uix:contents>
													</uix:stackLayout>
											</uix:header>
										</uix:cellFormat>
										</uix:contents>
										</uix:rowLayout>

												<%--/uix:stackLayout>
											</uix:rowLayout--%>
										</uix:tableLayout>
				            <uix:formValue name="event"
                                  valueBinding="pageUrl"/>
			              </uix:form>
							<uix:spacer height="20"/>
									<uix:subTabBar selectedIndex="1">
										<uix:contents>
											<uix:link textBinding="homeTabText" destinationBinding="homeTabDest"/>
											<uix:link textBinding="requestTabText" destinationBinding="requestTabDest"/>
										</uix:contents>
									</uix:subTabBar>
         </uix:contents>
        </uix:header>
     </uix:dataScope>
   </uix:pageLayout>
  </uix:body>
 </uix:document>
</uix:renderingContext>
