<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf" %>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="tmplData@servletRequest">
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
    <uix:formValue nameBinding="PAGE_NAME" valueBinding="APPLY_PAGE_NAME"/>
    <uix:header textBinding="VARIABLES@webappMsg">
      <uix:styledText textBinding="VARS_INSTR_TEXT_APPLY@webappMsg" styleClass="OraInstructionText" />
      <uix:contents>
        <uix:table summaryBinding="VARS_INSTR_TEXT_APPLY@webappMsg" nameBinding="VARIABLE_TABLE_NAME" tableDataBinding="variableTable" alternateTextBinding="NO_VARIABLES@webappMsg" width="80%">
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:contents>
            <uix:column>
              <uix:columnHeader>
                <uix:text textBinding="NAME_HDR@webappMsg"/>
              </uix:columnHeader>
              <uix:styledText textBinding="variableName@"/>
            </uix:column>
            <uix:column>
              <uix:columnHeader>
                <uix:text textBinding="VALUE_HDR@webappMsg"/>
              </uix:columnHeader>
              <uix:textInput columns="80" shortDescBinding="VALUE_HDR@webappMsg" textBinding="variableValue@" nameBinding="variableFormName@" secretBinding="isPassword@" noAutoCompleteBinding="isPassword@"/>
            </uix:column>
          </uix:contents>
        </uix:table>
      </uix:contents>
    </uix:header>
    <uix:header textBinding="SERVICE_TESTS@webappMsg">
      <uix:stackLayout>
        <uix:styledText textBinding="TXNS_INSTR_TEXT_APPLY@webappMsg" styleClass="OraInstructionText" />
     </uix:stackLayout> 
      <uix:contents>
        <uix:borderLayout>
          <uix:innerRight/>
          <uix:spacer width="1"/>
          <uix:bottom>
            <uix:flowLayout>
              <uix:contents>
                <uix:table summaryBinding="TXNS_INSTR_TEXT_APPLY@webappMsg" nameBinding="TRANSACTION_TABLE_NAME" tableDataBinding="applyTransactionTable" alternateTextBinding="NO_TRANSACTIONS@webappMsg" width="80%">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:contents>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="SELECT@commonResourceBundle"/>
                      </uix:columnHeader>
                      <uix:checkBox shortDescBinding="SELECT@commonResourceBundle"
                                    nameBinding="txnIncludedName@" valueBinding="txnIncludedName@" checkedBinding="txnIncludedState@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="NAME_HDR@webappMsg"/>
                      </uix:columnHeader>
                      <uix:link textBinding="txnName@" onClickBinding="txnOnClickEdit@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="OVERWRITE_EXISTING@webappMsg"/>
                      </uix:columnHeader>
                      <uix:checkBox shortDescBinding="OVERWRITE_EXISTING@webappMsg"
                                    nameBinding="txnOverwriteName@" valueBinding="txnOverwriteName@" checkedBinding="txnOverwriteState@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="ENABLED@webappMsg"/>
                      </uix:columnHeader>
                      <uix:checkBox shortDescBinding="ENABLED@webappMsg"
                                    nameBinding="txnMonitoringName@" valueBinding="txnMonitoringName@" checkedBinding="txnMonitoringState@"
                                    onClick="disableKey(this)"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="AVAILABILITY_TRANSACTION@webappMsg"/>
                      </uix:columnHeader>
                      <uix:checkBox shortDescBinding="AVAILABILITY_TRANSACTION@webappMsg"
                                    nameBinding="txnAvailabilityName@" valueBinding="txnAvailabilityName@" 
                                    disabledBinding="txnAvailabilityDisabled@" checkedBinding="txnAvailabilityState@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="MONITORING_SETTINGS@webappMsg"/>
                      </uix:columnHeader>
                      <uix:image shortDescBinding="MONITORING_SETTINGS@webappMsg" sourceBinding="txnSettingsViewIcon@" onClickBinding="txnOnClickMonSettings@"/>
                    </uix:column>
                  </uix:contents>
                </uix:table>
              </uix:contents>
            </uix:flowLayout>
          </uix:bottom>
        </uix:borderLayout>
      </uix:contents>
    </uix:header>
    <uix:header textBinding="BEACONS@webappMsg">
      <uix:styledText textBinding="BCNS_INSTR_TEXT_APPLY@webappMsg" styleClass="OraInstructionText" />
      <uix:contents>
        <uix:borderLayout>
          <uix:innerRight/>
          <uix:spacer width="1"/>
          <uix:bottom>
            <uix:flowLayout>
              <uix:contents>
                <uix:table summaryBinding="BCNS_INSTR_TEXT_APPLY@webappMsg" nameBinding="BEACON_TABLE_NAME" tableDataBinding="applyBeaconTable" alternateTextBinding="NO_BEACONS@webappMsg" width="80%">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:contents>
                    <uix:column> 
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="SELECT@commonResourceBundle"/>
                      </uix:columnHeader>
                      <uix:checkBox shortDescBinding="SELECT@commonResourceBundle"
                                    nameBinding="bcnIncludedName@" valueBinding="bcnIncludedName@" checkedBinding="bcnIncludedState@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="NAME_HDR@webappMsg"/>
                      </uix:columnHeader>
                      <uix:styledText textBinding="bcnName@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="AVAILABILITY_BEACON@webappMsg"/>
                      </uix:columnHeader>
                      <uix:checkBox shortDescBinding="AVAILABILITY_BEACON@webappMsg"
                                    nameBinding="bcnAvailabilityName@" valueBinding="bcnAvailabilityName@" checkedBinding="bcnAvailabilityState@"/>
                    </uix:column>
                  </uix:contents>
                </uix:table>
              </uix:contents>
            </uix:flowLayout>
          </uix:bottom>
        </uix:borderLayout>
      </uix:contents>
    </uix:header>
  </uix:dataScope>
</oem:pageSegment>
