<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:dataScope currentDataBinding="tmplData@servletRequest">
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      <uix:body>
        <uix:contents>
          <uix:form name="formName" method="GET" destination="createWebappTemplate">
            <uix:formValue nameBinding="PAGE_NAME" valueBinding="ADD_VARIABLE_PAGE_NAME"/>
            <uix:formValue nameBinding="RETURN_URL" valueBinding="returnURL"/>
            <uix:pageLayout>
              <%@ include file="/oemGlobal.jspf"%>
              <%@ include file="../../health/header.jsp"%>
              <uix:stackLayout>
                <uix:contents>
                  <uix:spacer height="5"/>
                  <uix:header textBinding="ADD_VARIABLE@webappMsg">
                    <uix:rowLayout hAlign="right">
                      <uix:contents>
                        <uix:submitButton name="event" shortDescBinding="CANCEL@commonResourceBundle" textBinding="CANCEL@commonResourceBundle" unvalidated="true" value="Cancel"/>
                        <uix:submitButton name="event" shortDescBinding="CONTINUE@commonResourceBundle" textBinding="CONTINUE@commonResourceBundle" value="OK"/>
                      </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout hAlign="center">
                      <uix:contents>
                        <uix:messageTextInput shortDescBinding="NEW_VARIABLE_NAME@webappMsg" name="variableName" required="yes" promptBinding="NEW_VARIABLE_NAME@webappMsg"/>
                      </uix:contents>
                    </uix:rowLayout>
                  </uix:header>
                </uix:contents>
              </uix:stackLayout>
              <uix:spacer height="40"/>
            </uix:pageLayout>
          </uix:form>
        </uix:contents>
      </uix:body>
    </uix:document>
  </uix:dataScope>
</uix:renderingContext>
