<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:dataScope currentDataBinding="tmplData@servletRequest">
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      <uix:body>
        <uix:contents>
          <uix:form name="formName" method="GET" destination="createWebappTemplate">
            <uix:formValue nameBinding="PAGE_NAME" valueBinding="REMOVE_VARIABLE_PAGE_NAME"/>
            <uix:formValue nameBinding="RETURN_URL" valueBinding="returnURL"/>
            <uix:pageLayout>
              <%@ include file="/oemGlobal.jspf"%>
              <%@ include file="../../health/header.jsp"%>
              <uix:stackLayout>
                <uix:contents>
                  <uix:spacer height="5"/>
                  <uix:header textBinding="REMOVE_CONFIRMATION_TITLE@webappMsg" messageType="confirmation">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:styledText textBinding="removeConfirmationMessage" styleClass="OraInstructionTextStrong"/>
                        <uix:spacer height="5"/>
                        <uix:rowLayout hAlign="right">
                          <uix:contents>
                            <uix:submitButton name="event" shortDescBinding="NO@commonResourceBundle" textBinding="NO@commonResourceBundle" value="Cancel"/>
                            <uix:submitButton name="event" shortDescBinding="YES@commonResourceBundle" textBinding="YES@commonResourceBundle" value="OK"/>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:spacer height="40"/>
                        <uix:header textBinding="VARIABLE_REFERENCES@webappMsg">
                          <uix:table summaryBinding="VARIABLE_REFERENCES@webappMsg" name="varLocsTable" tableDataBinding="variableLocations" width="80%" alternateTextBinding="unusedVariableMessage">
                            <uix:tableFormat tableBanding="rowBanding"/>
                            <uix:contents>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:text textBinding="SERVICE_TEST@webappMsg"/>
                                </uix:columnHeader>
                                <uix:styledText textBinding="testName@"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:text textBinding="EXEC_SEQ_HDR@webappMsg"/>
                                </uix:columnHeader>
                                <uix:styledText textBinding="stepName@"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:text textBinding="BEACON@webappMsg"/>
                                </uix:columnHeader>
                                <uix:styledText textBinding="beaconName@"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:text textBinding="PROPERTY@webappMsg"/>
                                </uix:columnHeader>
                                <uix:styledText textBinding="propertyDisplayName@"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:text textBinding="VALUE_HDR@webappMsg"/>
                                </uix:columnHeader>
                                <uix:styledText textBinding="propStringValue@"/>
                              </uix:column>
                            </uix:contents>
                          </uix:table>
                        </uix:header>
                        <uix:spacer height="40"/>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:header>
                </uix:contents>
              </uix:stackLayout>
            </uix:pageLayout>
          </uix:form>
        </uix:contents>
      </uix:body>
    </uix:document>
  </uix:dataScope>
</uix:renderingContext>
