<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:dataScope currentDataBinding="tmplData@servletRequest">
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      <uix:body>
        <uix:contents>
          <uix:form name="formName" method="GET" destination="createWebappTemplate">
            <uix:formValue nameBinding="PAGE_NAME" valueBinding="RENAME_VARIABLE_PAGE_NAME"/>
            <uix:formValue nameBinding="RETURN_URL" valueBinding="returnURL"/>
            <uix:pageLayout>
              <%@ include file="/oemGlobal.jspf"%>
              <%@ include file="../../health/header.jsp"%>
              <uix:stackLayout>
                <uix:contents>
                  <uix:spacer height="5"/>
                  <uix:header textBinding="RENAME_VARIABLE@webappMsg">
                    <uix:contents>
                      <uix:borderLayout>
                        <uix:right>
                          <uix:flowLayout>
                            <uix:contents>
                              <uix:submitButton name="event" shortDescBinding="CANCEL@commonResourceBundle" textBinding="CANCEL@commonResourceBundle" unvalidated="true" value="Cancel"/>
                              <uix:submitButton name="event" shortDescBinding="CONTINUE@commonResourceBundle" textBinding="CONTINUE@commonResourceBundle" value="OK"/>
                            </uix:contents>
                          </uix:flowLayout>
                        </uix:right>
                        <uix:left>
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:styledText textBinding="RENAME_REPLACES_REFERENCES@webappMsg" styleClass="OraInstructionText"/>
                              <uix:spacer height="10"/>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:left>
                        <uix:bottom>
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:spacer height="15"/>
                              <uix:labeledFieldLayout width="50%">
                                <uix:contents>
                                  <uix:styledText textBinding="OLD_NAME@webappMsg" styleClass="OraInstructionText"/>
                                  <uix:styledText textBinding="name@selectedVariable@" styleClass="OraInstructionTextStrong"/>
                                  <uix:messageTextInput shortDescBinding="NEW_NAME@webappMsg" promptBinding="NEW_NAME@webappMsg" name="variableName" required="yes" textBinding="name@selectedVariable@"/>
                                </uix:contents>
                              </uix:labeledFieldLayout>
                              <uix:spacer height="15"/>
                              <uix:header textBinding="VARIABLE_REFERENCES@webappMsg">
                                <uix:table summaryBinding="VARIABLE_REFERENCES@webappMsg" name="varLocsTable" tableDataBinding="variableLocations" width="80%" alternateTextBinding="unusedVariableMessage">
                                  <uix:tableFormat tableBanding="rowBanding"/>
                                  <uix:contents>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:text textBinding="SERVICE_TEST@webappMsg"/>
                                      </uix:columnHeader>
                                      <uix:styledText textBinding="testName@"/>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:text textBinding="EXEC_SEQ_HDR@webappMsg"/>
                                      </uix:columnHeader>
                                      <uix:styledText textBinding="stepName@"/>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:text textBinding="BEACON@webappMsg"/>
                                      </uix:columnHeader>
                                      <uix:styledText textBinding="beaconName@"/>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:text textBinding="PROPERTY@webappMsg"/>
                                      </uix:columnHeader>
                                      <uix:styledText textBinding="propertyDisplayName@"/>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:text textBinding="VALUE_HDR@webappMsg"/>
                                      </uix:columnHeader>
                                      <uix:styledText textBinding="propStringValue@"/>
                                    </uix:column>
                                  </uix:contents>
                                </uix:table>
                              </uix:header>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:bottom>
                      </uix:borderLayout>
                    </uix:contents>
                  </uix:header>
                </uix:contents>
              </uix:stackLayout>
              <uix:spacer height="40"/>
            </uix:pageLayout>
          </uix:form>
        </uix:contents>
      </uix:body>
    </uix:document>
  </uix:dataScope>
</uix:renderingContext>
