<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:dataScope currentDataBinding="tmplData@servletRequest">
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      <uix:body>
        <uix:contents>
          <uix:form name="formName" method="GET" destinationBinding="replaceTextPageUrl">
            <uix:formValue nameBinding="PAGE_NAME" valueBinding="REPLACE_VARIABLE_PAGE_NAME"/>
            <uix:formValue nameBinding="RETURN_URL" valueBinding="returnURL"/>
            <uix:pageLayout>
              <%@ include file="/oemGlobal.jspf"%>
              <%@ include file="../../health/header.jsp"%>
              <uix:messages>
                <uix:messageBox renderedBinding="renderReplaceTextErrorMessage@" messageBinding="replaceTextErrorMessage@" messageType="error"/>
              </uix:messages>
              <uix:stackLayout>
                <uix:contents>
                  <uix:spacer height="5"/>
                  <uix:header textBinding="REPLACE_TEXT_WITH_VARIABLE@webappMsg">
                    <uix:styledText textBinding="REPLACE_TEXT_INSTR@webappMsg" styleClass="OraInstructionText"/>
                    <uix:contents>
                      <uix:borderLayout>
                        <uix:right>
                          <uix:flowLayout>
                            <uix:contents>
                              <uix:submitButton name="event" shortDescBinding="CANCEL@commonResourceBundle" textBinding="CANCEL@commonResourceBundle" unvalidated="true" value="cancel"/>
                              <uix:submitButton name="event" shortDescBinding="CONTINUE@commonResourceBundle" textBinding="CONTINUE@commonResourceBundle" value="replace"/>
                            </uix:contents>
                          </uix:flowLayout>
                        </uix:right>
                        <uix:left>
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:spacer height="20"/>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:labeledFieldLayout width="100%">
                                    <uix:contents>
                                      <uix:styledText textBinding="VARIABLE@webappMsg" styleClass="OraInstructionText"/>
                                      <uix:styledText textBinding="name@selectedVariable@" styleClass="OraInstructionTextStrong"/>
                                      <uix:messageTextInput shortDescBinding="TEXT_TO_REPLACE@webappMsg" name="oldText" required="yes" promptBinding="TEXT_TO_REPLACE@webappMsg" textBinding="replacementText@"/>
                                    </uix:contents>
                                  </uix:labeledFieldLayout>
                                  <uix:spacer width="10"/>
                                  <uix:submitButton name="event" shortDescBinding="PREVIEW@webappMsg" textBinding="PREVIEW@webappMsg" value="preview"/>
                                </uix:contents>
                              </uix:rowLayout>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:left>
                        <uix:bottom>
                          <uix:header renderedBinding="replacementPreviewSet" textBinding="TEXT_REPLACEMENTS@webappMsg">
                            <uix:contents>
                              <uix:table summaryBinding="TEXT_REPLACEMENTS@webappMsg" renderedBinding="replacementPreviewSet" nameBinding="previewTable" tableDataBinding="replacementPreview" width="80%" alternateTextBinding="NO_MATCHES@webappMsg">
                                <uix:tableFormat tableBanding="rowBanding"/>
                                <uix:contents>
                                  <uix:column>
                                    <uix:columnHeader>
                                      <uix:text textBinding="SERVICE_TEST@webappMsg"/>
                                    </uix:columnHeader>
                                    <uix:styledText textBinding="testName@"/>
                                  </uix:column>
                                  <uix:column>
                                    <uix:columnHeader>
                                      <uix:text textBinding="EXEC_SEQ_HDR@webappMsg"/>
                                    </uix:columnHeader>
                                    <uix:styledText textBinding="stepName@"/>
                                  </uix:column>
                                  <uix:column>
                                    <uix:columnHeader>
                                      <uix:text textBinding="BEACON@webappMsg"/>
                                    </uix:columnHeader>
                                    <uix:styledText textBinding="beaconName@"/>
                                  </uix:column>
                                  <uix:column>
                                    <uix:columnHeader>
                                      <uix:text textBinding="PROPERTY@webappMsg"/>
                                    </uix:columnHeader>
                                    <uix:styledText textBinding="propertyDisplayName@"/>
                                  </uix:column>
                                  <uix:column>
                                    <uix:columnHeader>
                                      <uix:text textBinding="NEW_VALUE@webappMsg"/>
                                    </uix:columnHeader>
                                    <uix:styledText textBinding="newStringValue@"/>
                                  </uix:column>
                                </uix:contents>
                              </uix:table>
                            </uix:contents>
                          </uix:header>
                        </uix:bottom>
                        <uix:end>
                          <uix:flowLayout>
                            <uix:contents>
                              <uix:submitButton name="event" shortDescBinding="CANCEL@commonResourceBundle" textBinding="CANCEL@commonResourceBundle" value="cancel"/>
                              <uix:submitButton name="event" shortDescBinding="CONTINUE@commonResourceBundle" textBinding="CONTINUE@commonResourceBundle" value="replace"/>
                            </uix:contents>
                          </uix:flowLayout>
                        </uix:end>
                      </uix:borderLayout>
                    </uix:contents>
                  </uix:header>
                </uix:contents>
              </uix:stackLayout>
              <uix:spacer height="40"/>
            </uix:pageLayout>
          </uix:form>
        </uix:contents>
      </uix:body>
    </uix:document>
  </uix:dataScope>
</uix:renderingContext>
