<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.webapp.tmpl.data.WebappTemplateData"%>



<oem:pageSegment>
  <uix:dataScope currentDataBinding="tmplData@servletRequest">
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
    <uix:formValue nameBinding="REMOVE_BCN_VARIABLE"/>
    <uix:formValue nameBinding="REMOVE_TXN_VARIABLE"/>
    <uix:formValue nameBinding="EDIT_TXN_VARIABLE"/>
    <uix:formValue nameBinding="MON_SETTINGS_TXN_VARIABLE"/>
    <uix:formValue nameBinding="PAGE_NAME" valueBinding="CREATE_PAGE_NAME"/>
    <uix:header textBinding="VARIABLES@webappMsg">
      <uix:styledText textBinding="VARIABLES_INSTR_TEXT_EDIT@webappMsg" styleClass="OraInstructionText"/>
      <uix:contents>
        <uix:borderLayout>
          <uix:innerRight>
            <uix:flowLayout/>
          </uix:innerRight>
          <uix:spacer width="1"/>
          <uix:bottom>
            <uix:table summaryBinding="VARIABLES_INSTR_TEXT_EDIT@webappMsg" nameBinding="VARIABLE_TABLE_NAME" tableDataBinding="variableTable" alternateTextBinding="NO_VARIABLES@webappMsg" width="80%">
              <uix:tableFormat tableBanding="rowBanding"/>
              <uix:tableSelection>
                <uix:singleSelection selectedIndexBinding="selectedVariableIndex@tmplData@servletRequest" shortDescBinding="SELECT@commonResourceBundle">
                  <uix:contents>
                    <uix:submitButton shortDescBinding="REMOVE@commonResourceBundle" textBinding="REMOVE@commonResourceBundle" name="remove" valueBinding="VARIABLE_TABLE_NAME"/>
                    <uix:submitButton shortDescBinding="REPLACE_ALL@webappMsg" textBinding="REPLACE_ALL@webappMsg" name="replace" valueBinding="VARIABLE_TABLE_NAME"/>
                    <uix:submitButton shortDescBinding="RENAME@webappMsg"textBinding="RENAME@webappMsg" name="rename" valueBinding="VARIABLE_TABLE_NAME"/>
                  </uix:contents>
                </uix:singleSelection>
              </uix:tableSelection>
              <uix:tableActions>
                <uix:submitButton shortDescBinding="ADD@commonResourceBundle" textBinding="ADD@commonResourceBundle" name="add" valueBinding="VARIABLE_TABLE_NAME"/>
              </uix:tableActions>
              <uix:contents>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="NAME_HDR@webappMsg"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="variableName@"/>
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="VALUE_HDR@webappMsg"/>
                  </uix:columnHeader>
                  <uix:textInput shortDescBinding="VALUE_HDR@webappMsg" textBinding="variableValue@" nameBinding="variableFormName@" columns="80" secretBinding="isPassword@" noAutoCompleteBinding="isPassword@"/>
                </uix:column>
              </uix:contents>
            </uix:table>
          </uix:bottom>
        </uix:borderLayout>
      </uix:contents>
    </uix:header>
    <uix:header textBinding="SERVICE_TESTS@webappMsg">
      <uix:styledText textBinding="TRANSACTIONS_INSTR_TEXT_EDIT@webappMsg" styleClass="OraInstructionText"/>
      <uix:contents>
        <uix:borderLayout>
          <uix:innerRight/>
          <uix:spacer width="1"/>
          <uix:bottom>
            <uix:flowLayout>
              <uix:contents>
                <uix:table summaryBinding="TRANSACTIONS_INSTR_TEXT_EDIT@webappMsg" nameBinding="TRANSACTION_TABLE_NAME" tableDataBinding="transactionTable" alternateTextBinding="NO_TRANSACTIONS@webappMsg" width="80%">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:tableActions>
                    <uix:submitButton shortDescBinding="ADD_REMOVE@webappMsg" textBinding="ADD_REMOVE@webappMsg" name="add" valueBinding="TRANSACTION_TABLE_NAME"/>
                  </uix:tableActions>
                  <uix:contents>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="NAME_HDR@webappMsg"/>
                      </uix:columnHeader>
                      <uix:link textBinding="txnName@" onClickBinding="txnOnClickEdit@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="ENABLED@webappMsg"/>
                      </uix:columnHeader>
                      <uix:checkBox nameBinding="txnMonitoringName@" valueBinding="txnMonitoringName@" 
                                    checkedBinding="txnMonitoringState@" 
                                    shortDescBinding="ENABLED@webappMsg"
                                    onClick="disableKey(this)"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="AVAILABILITY_TRANSACTION@webappMsg"/>
                      </uix:columnHeader>
                      <uix:checkBox nameBinding="txnAvailabilityName@" valueBinding="txnAvailabilityName@" 
                                    shortDescBinding="AVAILABILITY_TRANSACTION@webappMsg"
                                    disabledBinding="txnAvailabilityDisabled@" checkedBinding="txnAvailabilityState@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="MONITORING_SETTINGS@webappMsg"/>
                      </uix:columnHeader>
                      <uix:image shortDescBinding="MONITORING_SETTINGS@webappMsg" sourceBinding="txnSettingsIcon@" onClickBinding="txnOnClickMonSettings@"/>
                    </uix:column>
                  </uix:contents>
                </uix:table>
                <uix:tip>
                  <uix:contents>
                    <uix:text textBinding="TXN_VAR_ADD_REMOVE_TIP@webappMsg"/>
                  </uix:contents>
                </uix:tip>
              </uix:contents>
            </uix:flowLayout>
          </uix:bottom>
        </uix:borderLayout>
      </uix:contents>
    </uix:header>
    <uix:header textBinding="BEACONS@webappMsg">
      <uix:styledText textBinding="BEACONS_INSTR_TEXT_EDIT@webappMsg" styleClass="OraInstructionText"/>
      <uix:contents>
        <uix:borderLayout>
          <uix:innerRight/>
          <uix:spacer width="1"/>
          <uix:bottom>
            <uix:flowLayout>
              <uix:contents>
                <uix:table summaryBinding="BEACONS_INSTR_TEXT_EDIT@webappMsg" nameBinding="BEACON_TABLE_NAME" tableDataBinding="beaconTable" alternateTextBinding="NO_BEACONS@webappMsg" width="80%">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:tableActions>
                    <uix:submitButton shortDescBinding="ADD_REMOVE@webappMsg" textBinding="ADD_REMOVE@webappMsg" name="add" valueBinding="BEACON_TABLE_NAME"/>
                  </uix:tableActions>
                  <uix:contents>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="NAME_HDR@webappMsg"/>
                      </uix:columnHeader>
                      <uix:styledText textBinding="bcnName@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="AVAILABILITY_BEACON@webappMsg"/>
                      </uix:columnHeader>
                      <uix:checkBox shortDescBinding="AVAILABILITY_BEACON@webappMsg" nameBinding="bcnAvailabilityName@" valueBinding="bcnAvailabilityName@" checkedBinding="bcnAvailabilityState@"/>
                    </uix:column>
                  </uix:contents>
                </uix:table>
              </uix:contents>
            </uix:flowLayout>
          </uix:bottom>
        </uix:borderLayout>
      </uix:contents>
    </uix:header>
  </uix:dataScope>
</oem:pageSegment>
