<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<oem:pageSegment>
  <uix:dataScope currentDataBinding="tmplData@servletRequest">
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
    <uix:bundle name="templBundle" class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
    <uix:formValue nameBinding="PAGE_NAME" valueBinding="APPLY_PAGE_NAME"/>
    <uix:header textBinding="SERVICE_TESTS@webappMsg">
      <uix:contents>
       <uix:rowLayout>
        <uix:styledText textBinding="SERVICE_TEST_CHANGES_DESCRIPTIVE_TEXT@templBundle"
                        styleClass="OraInstructionText"/>
       </uix:rowLayout>                
       <uix:rowLayout>
        <uix:spacer height="5"/>  
       </uix:rowLayout>
        <uix:borderLayout>
          <uix:spacer width="1"/>
          <uix:bottom>
            <uix:flowLayout>
              <uix:contents>
                <uix:table summaryBinding="TRANSACTIONS@webappMsg" nameBinding="TRANSACTION_TABLE_NAME" tableDataBinding="transactionTable" alternateTextBinding="NO_TRANSACTIONS@webappMsg" width="80%">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:contents>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="NAME_HDR@webappMsg"/>
                      </uix:columnHeader>
                      <uix:text textBinding="txnName@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="ENABLED@webappMsg"/>
                      </uix:columnHeader>
                      <uix:switcher childNameBinding="txnMonitoringState@">
                        <uix:case name="true">
                          <uix:image sourceBinding="chkImage@"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="AVAILABILITY_TRANSACTION@webappMsg"/>
                      </uix:columnHeader>
                      <uix:switcher childNameBinding="txnAvailabilityState@">
                        <uix:case name="true">
                          <uix:image sourceBinding="chkImage@"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="OVERWRITE_EXISTING@webappMsg"/>
                      </uix:columnHeader>
                      <uix:switcher childNameBinding="txnOverwriteState@">
                        <uix:case name="true">
                          <uix:image sourceBinding="chkImage@"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:column>
                  </uix:contents>
                </uix:table>
              </uix:contents>
            </uix:flowLayout>
          </uix:bottom>
        </uix:borderLayout>
      </uix:contents>
    </uix:header>
    <uix:header textBinding="BEACONS@webappMsg">
      <uix:contents>
        <uix:borderLayout>
          <uix:spacer width="1"/>
          <uix:bottom>
            <uix:flowLayout>
              <uix:contents>
                <uix:table summaryBinding="BEACONS@webappMsg" nameBinding="BEACON_TABLE_NAME" tableDataBinding="beaconTable" alternateTextBinding="NO_BEACONS@webappMsg" width="80%">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:contents>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="NAME_HDR@webappMsg"/>
                      </uix:columnHeader>
                      <uix:styledText textBinding="bcnName@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="AVAILABILITY_BEACON@webappMsg"/>
                      </uix:columnHeader>
                      <uix:switcher childNameBinding="bcnAvailabilityState@">
                        <uix:case name="true">
                          <uix:image sourceBinding="chkImage@"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:column>
                  </uix:contents>
                </uix:table>
              </uix:contents>
            </uix:flowLayout>
          </uix:bottom>
        </uix:borderLayout>
      </uix:contents>
    </uix:header>
  </uix:dataScope>
</oem:pageSegment>
