<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>

<oem:pageSegment>
  <uix:dataScope currentDataBinding="tmplData@servletRequest">
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
    <uix:formValue nameBinding="REMOVE_BCN_VARIABLE"/>
    <uix:formValue nameBinding="REMOVE_TXN_VARIABLE"/>
    <uix:formValue nameBinding="EDIT_TXN_VARIABLE"/>
    <uix:formValue nameBinding="MON_SETTINGS_TXN_VARIABLE"/>
    <uix:formValue nameBinding="PAGE_NAME" valueBinding="VIEW_PAGE_NAME"/>
    <uix:header textBinding="VARIABLES@webappMsg">
      <uix:styledText textBinding="VARIABLES_INSTR_TEXT_VIEW@webappMsg" styleClass="OraInstructionText"/>
      <uix:contents>
        <uix:table summaryBinding="VARIABLES_INSTR_TEXT_VIEW@webappMsg" nameBinding="VARIABLE_TABLE_NAME" tableDataBinding="variableTable" alternateTextBinding="NO_VARIABLES@webappMsg" width="80%">
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:contents>
            <uix:column>
              <uix:columnHeader>
                <uix:text textBinding="NAME_HDR@webappMsg"/>
              </uix:columnHeader>
              <uix:styledText textBinding="variableName@"/>
            </uix:column>
            <uix:column>
              <uix:columnHeader>
                <uix:text textBinding="VALUE_HDR@webappMsg"/>
              </uix:columnHeader>
              <uix:text textBinding="variableViewValue@"/>
            </uix:column>
          </uix:contents>
        </uix:table>
      </uix:contents>
    </uix:header>
    <uix:header textBinding="SERVICE_TESTS@webappMsg">
      <uix:styledText textBinding="TRANSACTIONS_INSTR_TEXT_VIEW@webappMsg" styleClass="OraInstructionText"/>
      <uix:contents>
        <uix:borderLayout>
          <uix:spacer width="1"/>
          <uix:bottom>
            <uix:flowLayout>
              <uix:contents>
                <uix:table summaryBinding="TRANSACTIONS_INSTR_TEXT_VIEW@webappMsg" nameBinding="TRANSACTION_TABLE_NAME" tableDataBinding="transactionTable" alternateTextBinding="NO_TRANSACTIONS@webappMsg" width="80%">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:contents>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="NAME_HDR@webappMsg"/>
                      </uix:columnHeader>
                      <uix:link textBinding="txnName@" onClickBinding="txnOnClickEdit@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="MONITORING@webappMsg"/>
                      </uix:columnHeader>
                      <uix:switcher childNameBinding="txnMonitoringState@">
                        <uix:case name="true">
                          <uix:image sourceBinding="chkImage@"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="AVAILABILITY_TRANSACTION@webappMsg"/>
                      </uix:columnHeader>
                      <uix:switcher childNameBinding="txnAvailabilityState@">
                        <uix:case name="true">
                          <uix:image sourceBinding="chkImage@"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="MONITORING_SETTINGS@webappMsg"/>
                      </uix:columnHeader>
                      <uix:image shortDescBinding="MONITORING_SETTINGS@webappMsg" sourceBinding="txnSettingsViewIcon@" onClickBinding="txnOnClickMonSettings@"/>
                    </uix:column>
                  </uix:contents>
                </uix:table>
              </uix:contents>
            </uix:flowLayout>
          </uix:bottom>
        </uix:borderLayout>
      </uix:contents>
    </uix:header>
    <uix:header textBinding="BEACONS@webappMsg">
      <uix:styledText textBinding="BEACONS_INSTR_TEXT_VIEW@webappMsg" styleClass="OraInstructionText"/>
      <uix:contents>
        <uix:borderLayout>
          <uix:spacer width="1"/>
          <uix:bottom>
            <uix:flowLayout>
              <uix:contents>
                <uix:table summaryBinding="BEACONS_INSTR_TEXT_VIEW@webappMsg" nameBinding="BEACON_TABLE_NAME" tableDataBinding="beaconTable" alternateTextBinding="NO_BEACONS@webappMsg" width="80%">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:contents>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="NAME_HDR@webappMsg"/>
                      </uix:columnHeader>
                      <uix:styledText textBinding="bcnName@"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:columnHeader>
                        <uix:text textBinding="AVAILABILITY_BEACON@webappMsg"/>
                      </uix:columnHeader>
                      <uix:switcher childNameBinding="bcnAvailabilityState@">
                        <uix:case name="true">
                          <uix:image sourceBinding="chkImage@"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:column>
                  </uix:contents>
                </uix:table>
              </uix:contents>
            </uix:flowLayout>
          </uix:bottom>
        </uix:borderLayout>
      </uix:contents>
    </uix:header>
  </uix:dataScope>
</oem:pageSegment>
