<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ page import='oracle.sysman.eml.gensvc.GenSvcUIConstants' %> 
<%@ page import='oracle.sysman.eml.mntr.Constants' %> 

<uix:buildTree nodeID="homePlugin">

<uix:dataScope currentDataBinding="componentData@servletRequest" >
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg" />
  <uix:bundle name="gensvcRB" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
<uix:stackLayout>
  <%@include file="webappTimeChoice.jspf" %>
  
  <uix:header textBinding="SYSTEM@gensvcRB">
    <uix:tableLayout borderWidth="0">
        <uix:rowLayout width="30%">
          <uix:cellFormat hAlign="left">
            <uix:flowLayout>
            <uix:styledText styleClass="OraDataText" textBinding="systemName" destinationBinding="systemLink" />
            <uix:spacer width="10"/>
            <uix:styledText styleClass="OraPromptText" textBinding="TOPOLOGY_LINK@gensvcRB" destinationBinding="topologyLink"/>
            </uix:flowLayout>
          </uix:cellFormat>
        </uix:rowLayout>
     </uix:tableLayout>
  </uix:header>  

  <uix:header textBinding="COMPONENT_SUMMARY@webappMsg" >
    <uix:stackLayout>
      <uix:rowLayout>
        <uix:form name="OneBigForm">
        <uix:checkBox checkedBinding="showKeyComponents" 
                      id="SHOW_ALL_COMPS" 
                      textBinding="SHOW_KEY_COMPS_ONLY@gensvcRB" 
                      name="SHOW_ALL_COMPS" 
                      styleClass="OraPromptText" 
                      onClick="submitForm('OneBigForm',0,{'event':'CHANGE_KEY_COMP'}); return false;" />
        </uix:form>
      </uix:rowLayout>
      <uix:spacer height="10"/>
      <uix:table name="componentTable" tableDataBinding="componentTableData" id="COMPS_TABLE" alternateTextBinding="NO_COMPONENTS@webappMsg" width="80%" summaryBinding="COMPONENT_SUMMARY@webappMsg"  blockSizeBinding="blockSize" valueBinding="tableValue" minValueBinding="minValue" maxValueBinding="maxValue">
        <uix:tableFormat tableBanding="rowBanding"/>

        <uix:contents>
          <uix:column>
            <uix:columnFormat width="25%"/>
            <uix:columnHeader> 
              <uix:sortableHeader value="targetName" sortableBinding="targetNameSortable" textBinding="COMPONENT_NAME@webappMsg" />
            </uix:columnHeader>
            <uix:link textBinding="targetName@" destinationBinding="targetNameDest@" />
          </uix:column>

          <uix:column>
            <uix:columnFormat width="25%"/>
            <uix:columnHeader> 
              <uix:sortableHeader value="targetType" sortableBinding="targetTypeSortable" textBinding="TYPE@webappMsg" /> 
            </uix:columnHeader>
            <uix:styledText textBinding="targetType@" />
          </uix:column>

          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader value="currentStatus" sortableBinding="currentStatusSortable" textBinding="CURRENT_STATUS@webappMsg" />
            </uix:columnHeader>
            <uix:columnFormat width="15%" columnDataFormat="iconButtonFormat" />
            <oem:license>
              <uix:image sourceBinding="currentStatus@" destinationBinding="currentStatusDest@" shortDescBinding="currentStatusDesc@" />
            </oem:license>
          </uix:column>

          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader value="alerts" sortableBinding="alertsSortable" textBinding="ALERTS@webappMsg" />
            </uix:columnHeader>
            <uix:columnFormat width="15%" columnDataFormat="numberFormat" />
            <uix:flowLayout>
              <oem:license>
                <uix:styledText textBinding="<%= Constants.WARNING_COUNT_NAME_KEY %>" inlineStyleBinding="warningStyle@" destinationBinding="<%= Constants.WARNING_LINK_KEY %>" shortDescBinding="<%= Constants.WARNING_DESC_KEY %>" />
              </oem:license>
                <uix:spacer width="5" />
              <oem:license>
                <uix:styledText textBinding="<%= Constants.CRITICAL_COUNT_NAME_KEY %>" inlineStyleBinding="criticalStyle@" destinationBinding="<%= Constants.CRITICAL_LINK_KEY %>" shortDescBinding="<%= Constants.CRITICAL_DESC_KEY %>" />
              </oem:license>
            </uix:flowLayout>
          </uix:column>

          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader value="policy" sortableBinding="policySortable" textBinding="POLICY_VIOLATIONS@gensvcRB" />
            </uix:columnHeader>
            <uix:columnFormat width="15%" columnDataFormat="numberFormat" />
            <uix:flowLayout>
              <oem:license>
                <uix:styledText textBinding="<%= Constants.POLICY_CRITICAL_COUNT_NAME_KEY %>" inlineStyleBinding="polCriticalStyle@" destinationBinding="<%= Constants.POLICY_CRITICAL_DEST_KEY %>" shortDescBinding="<%= Constants.POLICY_CRITICAL_DESC_KEY %>" />
              </oem:license>
                <uix:spacer width="5" />
              <oem:license>
                <uix:styledText textBinding="<%= Constants.POLICY_WARNING_COUNT_NAME_KEY %>" inlineStyleBinding="polWarningStyle@" destinationBinding="<%= Constants.POLICY_WARNING_DEST_KEY %>" shortDescBinding="<%= Constants.POLICY_WARNING_DESC_KEY %>" />
              </oem:license>
                <uix:spacer width="5" />
              <oem:license>
                <uix:styledText textBinding="<%= Constants.POLICY_INFORMATION_COUNT_NAME_KEY %>" inlineStyleBinding="polInfoStyle@" destinationBinding="<%= Constants.POLICY_INFORMATION_DEST_KEY %>" shortDescBinding="<%= Constants.POLICY_INFORMATION_DESC_KEY %>" />
              </oem:license>
            </uix:flowLayout>
          </uix:column>

        </uix:contents>
      </uix:table>

      <uix:spacer height="5" />

      <uix:rowLayout hAlign="left" >
        <uix:button textBinding="EDIT_WEBAPP_COMPONENTS@webappMsg" destinationBinding="editComponentsLink" />
      </uix:rowLayout>
    </uix:stackLayout>
  </uix:header>
  
<%-- Comment out the component performance segment
  
<uix:spacer height="40" />
  
<uix:form name="componentPerfForm" 
          method="GET" 
          destinationBinding="componentPerfFormDestination@servletRequest" >
  <uix:header textBinding="COMP_PERF_AND_AVAIL@webappMsg" >
    <uix:stackLayout>
      <uix:rowLayout vAlign="top" >                      
        <uix:dataScope currentDataBinding="componentPerfHdrData@servletRequest" >
	<uix:switcher childNameBinding="isMaxLegend@servletRequest">
	  <uix:case name="true">
 	   <uix:messageBox
              messageBinding="MAX_LEGEND@webappMsg"
                 messageType="info"/>
	  </uix:case>
         </uix:switcher>
	 <uix:spacer height="10" />
	 <uix:rowLayout> 
             < %--
             <uix:styledText textBinding="SHOW_PERF_FOR_TYPE@webappMsg" styleClass="OraPromptText" />            
             <uix:spacer width="5" />         
             <uix:choice id="memType" name="memType" 
                onChange="submitForm(componentPerfForm, false, {event:'viewType'})"
                selectedIndexBinding="targetTypeChoiceSelection" 
                required="yes" >
                <uix:contents childDataBinding="targetTypeChoiceData" >
                  <uix:option textBinding="textKey"
                            valueBinding="valueKey"/>
                </uix:contents>
             </uix:choice>	             
             <uix:spacer width="10" />	    
             <uix:styledText textBinding="ON_HOST@webappMsg" styleClass="OraPromptText" />	    
             <uix:spacer width="5" />
             <uix:choice id="memHost" name="memHost" 
                onChange="submitForm(componentPerfForm, false, {event:'viewHost'})"
                selectedIndexBinding="hostChoiceSelection" 
                required="yes" > 
                <uix:contents childDataBinding="hostChoiceData" >
                  <uix:option textBinding="textKey"
                            valueBinding="valueKey"/>
                </uix:contents>
             </uix:choice>
             --% >
             <uix:styledText textBinding="SHOW_PERF_FOR_TYPE@webappMsg" styleClass="OraPromptText" />            
             <uix:spacer width="5" />        
             <uix:choice id="memType" name="memType" 
                selectedIndexBinding="targetTypeChoiceSelection" 
                required="yes" >
                <uix:contents childDataBinding="targetTypeChoiceData" >
                  <uix:option textBinding="textKey"
                            valueBinding="valueKey"/>
                </uix:contents>
             </uix:choice>	             
             <uix:spacer width="10" />	    
             <uix:styledText textBinding="ON_HOST@webappMsg" styleClass="OraPromptText" />	    
             <uix:spacer width="5" />
             <uix:choice id="memHost" name="memHost" 
                selectedIndexBinding="hostChoiceSelection" 
                required="yes" >
                <uix:contents childDataBinding="hostChoiceData" >
                  <uix:option textBinding="textKey"
                            valueBinding="valueKey"/>
                </uix:contents>
             </uix:choice>
             <uix:spacer width="20" />
             <uix:submitButton name="event"
                textBinding="GO@commonResourceBundle" value="viewType"/>

         </uix:rowLayout>
        </uix:dataScope>
       </uix:rowLayout>

       <uix:spacer width="4"/>

        <%@ include file="webappCompPerf.jspf" %>
        
      </uix:stackLayout>
  </uix:header>
</uix:form>
--%>

</uix:stackLayout>

</uix:dataScope>
</uix:buildTree>

<%@ include file="/gensvc/view/gensvcViewTemplate.jspf" %>

<%--
<uix:buildTree nodeID="pagePlugin">
  <uix:dataScope currentDataBinding="componentsData@servletRequest" >
    <uix:flowLayout>
      <uix:stackLayout>     
         <uix:stackLayout>
          <uix:borderLayout>
            <uix:contents>
              <uix:spacer width="1"/>
            </uix:contents>
            <uix:innerRight>
              <uix:rowLayout>
                <uix:contents>
                  <uix:button textBinding="MANAGE_COMPONENTS@webappMsg"
                     destinationBinding="manageComponentsDest"/>
                </uix:contents>
              </uix:rowLayout>
            </uix:innerRight>
          </uix:borderLayout>

          <uix:spacer height="5"/>
          <oem:table name="SystemComponentsTable" 
               width="100%" dataSourceProp="compTableDataSource" 
               beanKey="componentsData"
               alternateTextBinding="alternativeText">
          </oem:table>           
         </uix:stackLayout>

        <uix:spacer height="10" />
        
        <uix:tip>
          <uix:contents>
            <uix:styledText textBinding="EDIT_WEBSITE_TIP@webappMsg" />
          </uix:contents> 
        </uix:tip>       
     </uix:stackLayout>

      </uix:header>
    </uix:flowLayout>
  </uix:dataScope>
</uix:buildTree>

<%@include  file="/gensvc/view/gensvcViewTemplate.jspf" %>
--%>
