<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page import='oracle.sysman.eml.webapp.WebappConstants'%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg" />

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %> 
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body>
      <uix:pageLayout>
        
        <%@include file="/oemGlobal.jspf" %>

        <uix:stackLayout>
         <uix:dataScope currentDataBinding="correlatePageData@servletRequest" >
          <uix:header textBinding="pageHeader" >        
        
            <%@include file="webappTimeChoice.jspf" %>
            
            <uix:styledText styleClass="OraPromptText" textBinding="selectTip@correlatePageData@servletRequest" /> 

            <uix:tableLayout >
              <uix:rowLayout>
                <uix:cellFormat width="25%" vAlign="top" hAlign="left" wrappingDisabled="true" >
                
                 <uix:dataScope currentDataBinding="correlatePageData@servletRequest" >
                  <uix:form name="correlateMetricForm" method="post" destinationBinding="currentUrl@servletRequest" >
                  <uix:stackLayout>
                    <uix:spacer height="20" />
                    <uix:contentContainer background="light" width="100%" textBinding="CORRELATE_METRICS@webappMsg">
                       <uix:stackLayout> 
                      
                      <uix:flowLayout>                 
                        <uix:messageChoice
                                    promptBinding="SHOW@webappMsg"
                                    onChange="submitForm(correlateMetricForm, false, {event:'catType'})"
                                    name="catType"
                                    selectedIndexBinding="catTypeIndex"
                                    renderedBinding="showDropdown">
                            <uix:contents childDataBinding="categoryChoiceData" >
                              <uix:option
                                  textBinding="<%=WebappConstants.TEXT_KEY%>"
                                  valueBinding="<%=WebappConstants.VALUE_KEY%>"/>
                            </uix:contents>
                        </uix:messageChoice>      
                      </uix:flowLayout>
                    <%-- Doesn't work, because can't nest <contents> in a list UINode
                      <uix:stackLayout>
                        <uix:contents childDataBinding="correlateMetricCategories" >
                          <uix:header textBinding="categoryText" />
                            <uix:contents childDataBinding="metricList" />
                              <uix:checkBox nameBinding="metricId" textBinding="metricLabel" checkedBinding="metricEnabled" />
                            </uix:contents>
                          </uix:header>
                        </uix:contents>
                      </uix:stackLayout>
                    --%>
                      <uix:include nodeBinding="correlateCategoriesList" />

                      <uix:spacer height="1" />
                      <uix:tableLayout width="100%" >
                        <uix:rowLayout hAlign="right">
                          <uix:cellFormat>
                            <uix:submitButton textBinding="CORRELATE@webappMsg" name="event" value="correlate" />
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                      
                      </uix:stackLayout>
                    </uix:contentContainer>

                   </uix:stackLayout>
                  </uix:form>
                 </uix:dataScope>
                </uix:cellFormat>
                
                <uix:cellFormat>
                  <uix:spacer width="2" />
                </uix:cellFormat>

                <uix:cellFormat width="75%" vAlign="top" hAlign="left" >
                  <uix:stackLayout>
                  
                    <uix:messageBox messageType="error" 
                      renderedBinding="showError@pageLevelError@servletRequest"
                      messageBinding="errorText@pageLevelError@servletRequest" />

                    <uix:dataScope currentDataBinding="correlateChartData@servletRequest" >
                      <%@ include file="webappCorrelateChart.jspf" %>                     
                    </uix:dataScope>
              
                    <%-- special case for component performance --%>
                    <uix:spacer height="10" />
                    <%-- <%@ include file="webappCompPerf.jspf" %> --%>
                    <%@ include file="webappCompAvail.jspf" %>                    

                    <uix:form name="metricDisplayForm" method="post" destinationBinding="currentUrl@servletRequest" >
                    <%-- not supported for 4.1 jonathan.riel  <uix:formValue name="splitCombine" /> --%>

                    <%-- include for each metric --%>
                    <%
                    oracle.sysman.eml.webapp.data.WebappCorrelatePageData pageData = 
                      (oracle.sysman.eml.webapp.data.WebappCorrelatePageData) request.getAttribute("correlatePageData");
                    if(pageData != null && pageData.getCorrelateMetricData() != null &&
                        pageData.getCorrelateMetricData().size() > 0)
                    {
                      int i=0;
                      for(java.util.Iterator metIter = pageData.getCorrelateMetricData().iterator(); metIter.hasNext(); i++)
                      {
                        oracle.sysman.eml.webapp.data.WebappCorrelateMetricData metData = 
                          (oracle.sysman.eml.webapp.data.WebappCorrelateMetricData) metIter.next();
                    %>
                    <uix:dataScope currentDataBinding="<%=metData.getDataBinding()%>" >
                     <uix:formValue nameBinding="id" />
                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:cellFormat vAlign="top" >
                           <uix:header textBinding="title" >
                            <uix:stackLayout>         
                              <%-- jriel: chart package doesn't draw multiple subcharts correctly 
                                          as of 08/22/03 - this needs to be fixed for split-combine to work
                              <uix:link textBinding="splitCombineLabel" renderedBinding="showSplitCombine"
                                    name="splitCombineLink" onClickBinding="onClickMethod" />
                              --%>
                              <uix:include nodeBinding="chartNode" />
                             </uix:stackLayout>
                           </uix:header>
                          </uix:cellFormat>
                          <uix:cellFormat vAlign="top" >
                            <uix:stackLayout>
                              <uix:spacer height="10" />
                              <uix:submitButton textBinding="REMOVE@webappMsg" nameBinding="id" value="REMOVE" /> 
                            </uix:stackLayout>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:dataScope>
                    <%
                      }
                    }
                    %>
                    
                   </uix:form>
                  </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>
           </uix:tableLayout>
        </uix:header>
        </uix:dataScope>
        </uix:stackLayout>

      </uix:pageLayout>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
