<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>
        <uix:dataScope currentDataBinding="urlComponentPerfData@servletRequest">
          <uix:contents>
            <uix:messageBox messageType="error" renderedBinding="showError@pageLevelError@servletRequest" messageBinding="errorText@pageLevelError@servletRequest"/>
            <uix:form name="componentDetailForm" method="post" destinationBinding="currentFilteredUrl@servletRequest">
              <uix:header textBinding="DATABASE_TARGET@webappMsg">
                <uix:stackLayout>
                  <uix:styledText textBinding="DATABASE_SELECT_TXT@webappMsg" styleClass="OraInstructionText"/>
                  <uix:rowLayout>
                    <uix:textInput name="srchFld" required="no" maximumLength="20" textBinding="searchString@sqlDBConnectData@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:submitButton textBinding="SEARCH@commonResourceBundle" name="event" value="doSearch"/>
                  </uix:rowLayout>
                  <uix:spacer height="40"/>
                  <uix:table id="dbTrgtTableId" alternateTextBinding="NO_TARGETS_FOUND@mntrResourceBundle" formSubmitted="true" width="100%" valueBinding="startValue@sqlDBConnectData@servletRequest" maxValueBinding="maxValue@sqlDBConnectData@servletRequest" blockSizeBinding="blockSize@sqlDBConnectData@servletRequest" tableDataBinding="dbTrgtTableData@sqlDBConnectData@servletRequest" columnFormatsBinding="columnFormats@sqlDBConnectData@servletRequest" columnHeaderDataBinding="columnHeaderData@sqlDBConnectData@servletRequest">
                    <uix:tableFormat tableBanding="rowBanding"/>
                    <uix:columnHeaderStamp>
                      <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                    </uix:columnHeaderStamp>
                    <uix:tableSelection>
                      <uix:singleSelection selectedIndex="0">
                        <uix:styledText textBinding="DB_SCHEMA_TXT@webappMsg" styleClass="OraPromptText" renderedBinding="isSchemaUnavail@sqlDBConnectData@servletRequest"/>
                        <uix:spacer width="10"/>
                        <uix:textInput name="schemaInput" required="no" maximumLength="20" textBinding="schemaName@sqlDBConnectData@servletRequest" renderedBinding="isSchemaUnavail@sqlDBConnectData@servletRequest"/>
                        <uix:submitButton textBinding="SELECT@commonResourceBundle" name="event" value="select"/>
                        <uix:submitButton textBinding="CANCEL@commonResourceBundle" name="event" value="cancel"/>
                      </uix:singleSelection>
                    </uix:tableSelection>
                    <uix:contents>
                      <uix:styledText textBinding="trgtname@"/>
                      <uix:styledText textBinding="trgttype@"/>
                      <uix:styledText textBinding="schema@"/>
                      <uix:formValue name="trgtname" valueBinding="trgtname@"/>
                      <uix:formValue name="trgttype" valueBinding="trgttype@"/>
                      <uix:formValue name="dbtype" valueBinding="dbtype@"/>
                    </uix:contents>
                  </uix:table>
                  <uix:tip textBinding="FIND_DB_TIP@webappMsg" />
                </uix:stackLayout>
              </uix:header>
            </uix:form>
          </uix:contents>
        </uix:dataScope>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
