<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg" />

<uix:document>
  <%@ include file="/enablePPR.jspf" %>
  <%@ include file="/oemTitle.jspf" %>
  <%@ include file="/oemNoscript.jspf" %> 

  <uix:body>
    <uix:pageLayout>
      <%@ include file="/oemGlobal.jspf" %>

      <uix:dataScope currentDataBinding="processingDetailsData@servletRequest" >        

          <uix:messageBox messageTypeBinding="errorType@pageLevel@servletRequest" 
            renderedBinding="showError@pageLevelError@servletRequest"
            messageBinding="errorText@pageLevelError@servletRequest" />

          <uix:messageBox messageType="info" 
              renderedBinding="showMaxRowsMessage"
              messageBinding="maxRowsMessage" />

          <uix:header textBinding="pageHeader@processingDetailsData@servletRequest" >                  
                <uix:rowLayout>
                  <uix:spacer width="10"/>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="REQUEST@webappMsg" styleClass="OraPromptText" />
                  </uix:cellFormat>
                  <uix:spacer width="10" />
                  <uix:cellFormat wrappingDisabled="true">
                    <uix:styledText textBinding="urlDisplayString@servletRequest" styleClass="OraDataText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                
                <uix:tableLayout>            
                   <uix:rowLayout>
                     <uix:cellFormat vAlign="top" width="66%" >

                        <uix:stackLayout>
                          <uix:tableLayout>
            
                            <uix:rowLayout hAlign="left" vAlign="top" >                                            
                              <uix:cellFormat vAlign="top">
                                <uix:stackLayout>
                                 <oem:chart titleBinding="PROCESSING_BREAKDOWN@webappMsg"
                                     chartType="barChart"
                                     titleVisible="false"
                                     width="350"
                                     height="40" 
                                     borderTop="5"
                                     legendVisible="false"
                                     stacked="true"
                                     orientation="horizontal"
                                     shadowEffect="3d"
                                     colorPaletteBinding="cigarCustomPalette"
                                     >
                                  <uix:contents>
                                    <oem:boundChartDataSource chartDataSourceBinding="urlResponseBarDataSource" />
                                    <oem:imageMap imageMapDataSourceBinding="urlResponseBarImageMap" /> 
                                    <oem:chartColumn displayLabel=" " sourceIndex="5" isKey="true" />
                                    <oem:chartColumn displayLabelBinding="AVG_SERVLET@webappMsg" sourceIndex="0" />
                                    <oem:chartColumn displayLabelBinding="AVG_JSP@webappMsg" sourceIndex="1" />
                                    <oem:chartColumn displayLabelBinding="AVG_JDBC@webappMsg" sourceIndex="2" />
                                    <oem:chartColumn displayLabelBinding="AVG_EJB@webappMsg" sourceIndex="3" />
                                    <oem:chartColumn displayLabelBinding="AVG_OTHER_TIME@webappMsg" sourceIndex="4" />
                                  </uix:contents>
                                </oem:chart>
                              </uix:stackLayout>
                            </uix:cellFormat>

                            <uix:spacer width="1" />

                            <uix:cellFormat vAlign="top">
                              <uix:tableLayout>

                                <uix:rowLayout>
                                 <uix:cellFormat hAlign="right">
                                    <uix:styledText textBinding="URL_HITS@webappMsg" styleClass="OraPromptText" />
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat wrappingDisabled="true">
                                    <uix:styledText styleClass="OraDataText" textBinding="hits" />
                                  </uix:cellFormat>
                                </uix:rowLayout>

                                <uix:rowLayout>
                                 <uix:cellFormat hAlign="right">
                                    <uix:styledText textBinding="AVG_PROCESSING_TIME@webappMsg" styleClass="OraPromptText" />
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat wrappingDisabled="true">
                                    <uix:styledText styleClass="OraDataText" textBinding="avgTime" />
                                  </uix:cellFormat>
                                </uix:rowLayout>
                              </uix:tableLayout>
                            </uix:cellFormat>

                          </uix:rowLayout>                  
                        </uix:tableLayout>

                        <uix:rowLayout>
                          <uix:include nodeBinding="barChartLegend" />
                        </uix:rowLayout>
                      </uix:stackLayout>
                  </uix:cellFormat>
  
                </uix:rowLayout>

                <uix:separator/>

                <%@include file="webappTimeChoice.jspf" %>
                
            </uix:tableLayout>
            
            <uix:hGrid id="processingDetails"
               width="100%"
               alternateTextBinding="ALL_TRANSACTIONS_ALT_TEXT@webappMsg"
               destinationBinding="destination"
               summary="Processing Details"
               columnFormatsBinding="columnFormats"
               columnHeaderDataBinding="columnHeaderData"
               treeDataBinding="processingDetailsData"
               proxyBinding="processingDetailsProxy@servletRequest">
             
               <uix:nodeStamp>
                <uix:column>
                 <uix:columnHeader>
                  <uix:styledText textBinding="keyHeader" />
                 </uix:columnHeader>
                 <uix:styledText textBinding="text" shortDescBinding="shortDesc" styleClassBinding="keyStyle" destinationBinding="destination" />
                </uix:column>
               </uix:nodeStamp>
             
               <uix:columnHeaderStamp>
                  <uix:text textBinding="text" />
               </uix:columnHeaderStamp>
                                       
               <uix:styledText textBinding="type" />
               <uix:styledText textBinding="rank" />
               <uix:styledText textBinding="componentTime" />
               <uix:styledText textBinding="subComponentTime" />
             </uix:hGrid>
           
           <%@include file="webappURLRelatedLinks.jspf" %>
           
        </uix:header>
       </uix:dataScope>     

      </uix:pageLayout>
    </uix:body>
  </uix:document>

</uix:renderingContext>

