<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page import='oracle.sysman.eml.webapp.WebappConstants'%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg" />

    <uix:document>
      <%@ include file="/enablePPR.jspf" %>
      <%@ include file="/oemTitle.jspf" %>
      <%@ include file="/oemNoscript.jspf" %>
      
      
      <uix:body>
        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

      <uix:dataScope currentDataBinding="urlComponentPerfData@servletRequest" >
      
      <uix:contents>

      <uix:messageBox messageType="error" 
        renderedBinding="showError@pageLevelError@servletRequest"
        messageBinding="errorText@pageLevelError@servletRequest" />
            
        <uix:header textBinding="pageHeader" >
          <uix:stackLayout>            
          
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:spacer width="10"/>
                <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="REQUEST@webappMsg" styleClass="OraPromptText" />
                </uix:cellFormat>
                <uix:spacer width="10" />
                <uix:cellFormat wrappingDisabled="true">
                  <uix:styledText textBinding="urlDisplayString@servletRequest" styleClass="OraDataText" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
               <uix:spacer width="10"/>
               <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="APPLICATION@webappMsg" styleClass="OraPromptText" />
                </uix:cellFormat>
                <uix:spacer width="8"/>
                <uix:cellFormat wrappingDisabled="true">
                  <uix:styledText styleClass="OraDataText" textBinding="application@urlComponent@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              
              <uix:rowLayout renderedBinding="showAdditionalContext" >
               <uix:spacer width="10"/>
               <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="additionalContextLabel" styleClass="OraPromptText" />
                </uix:cellFormat>
                <uix:spacer width="8"/>
                <uix:cellFormat wrappingDisabled="true">
                  <uix:styledText styleClass="OraDataText" textBinding="additionalContext" />
                </uix:cellFormat>
              </uix:rowLayout>
              
           <uix:form name="componentDetailForm" method="post" destinationBinding="currentFilteredUrl@servletRequest" >         
              <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="INVOCATION_CONTEXT@webappMsg" styleClass="OraPromptText" renderedBinding="singleInvocation" />
               </uix:cellFormat>
                <uix:spacer width="8"/>
                 
              <uix:cellFormat  hAlign="start">
                 <uix:styledText styleClass="OraDataText" textBinding="invocationContext" renderedBinding="singleInvocation" />
              </uix:cellFormat>
              <uix:cellFormat>
               <uix:contents>
                 <uix:messageChoice promptBinding="INVOCATION_CONTEXT@webappMsg"
                                    onChange="submitForm(componentDetailForm, false, {event:'invKeyPost'})"
                                    name="invKeyPost"
                                    selectedIndexBinding="invocationChoiceIndex"
                                    renderedBinding="multiInvocation">
                  <uix:contents childDataBinding="invocationChoiceData" >
                    <uix:option
                              textBinding="<%=WebappConstants.TEXT_KEY%>"
                              valueBinding="<%=WebappConstants.VALUE_KEY%>"/>
                  </uix:contents>
                 </uix:messageChoice>
               </uix:contents>
              </uix:cellFormat>
              </uix:rowLayout>
            </uix:form>

              <uix:rowLayout>
               <uix:spacer width="10"/>
               <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="CALL_RANK@webappMsg" styleClass="OraPromptText" />
                </uix:cellFormat>
                <uix:spacer width="8"/>
                <uix:cellFormat wrappingDisabled="true">
                  <uix:styledText styleClass="OraDataText" textBinding="rankString" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:separator/>

              <%@include file="webappTimeChoice.jspf" %>
              
             </uix:tableLayout>
            
            <uix:tableLayout>
              <uix:rowLayout>     
                <uix:cellFormat vAlign="top">       
                  <uix:header textBinding="processingBreakdownHeader" >
                    <uix:stackLayout>
                      <uix:styledText styleClass="OraPromptText" textBinding="processingDesc" />
                      <uix:dataScope currentDataBinding="correlateChartData@servletRequest" >
                        <%-- <%@ include file="webappCorrelateChart.jspf" %>     --%>                
                        <uix:include nodeBinding="chartNode" />
                      </uix:dataScope>
                    </uix:stackLayout>
                  </uix:header>
                </uix:cellFormat>

              </uix:rowLayout>
            </uix:tableLayout>
              
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat vAlign="top" width="66%" >

          <uix:header textBinding="processingChartTitle" >
            <uix:stackLayout>
              <uix:styledText styleClass="OraPromptText" textBinding="processingTimeDesc" />
              <uix:tableLayout>
            
              <uix:rowLayout hAlign="left" vAlign="top" >
                
                <uix:cellFormat width="20%">
                  <uix:stackLayout>
                   <oem:chart titleBinding="processingChartTitle"
                       chartType="pieChart"
                       titleVisible="false"
                       width="150"
                       height="150" 
                       pieValuesInLegend="value"
                       showSlicePercentLabels="true"
                       legendVisible="false"
                       legendPosition="east"
                       pieSliceColorsBinding="pieColors"
                       >
                    <uix:contents>
                      <oem:boundChartDataSource chartDataSourceBinding="urlResponsePieDataSource" />
                      <oem:imageMap imageMapDataSourceBinding="urlResponsePieImageMap" /> 
                      <oem:chartColumn                                   
                          isKey="true" 
                          displayLabel="Item"
                          sourceIndex="0"
                        />
                      <oem:chartColumn                                   
                          displayLabel="percentage"
                          sourceIndex="1"
                        />
                    </uix:contents>
                  </oem:chart>
                 </uix:stackLayout>
                </uix:cellFormat>

                <uix:cellFormat width="40%" >
                <uix:tableLayout>                

                  <uix:rowLayout>
                    <uix:spacer height="20" />
                    <uix:spacer height="20" />
                    <uix:spacer height="20" />
                    <uix:spacer height="20" />
                    <uix:spacer height="20" />
                  </uix:rowLayout>
       
                  <uix:rowLayout>
                   <uix:spacer width="10"/>
                   <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="hitsLabel" styleClass="OraPromptText" />
                    </uix:cellFormat>
                    <uix:spacer width="8"/>
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" textBinding="invocationsPerRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:spacer height="1" />
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                   <uix:spacer width="10"/>
                   <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="totalTimeLabel" styleClass="OraPromptText" />
                    </uix:cellFormat>
                    <uix:spacer width="8"/>
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" textBinding="totalTime" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:spacer height="1" />
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:spacer height="20" />
                    <uix:spacer height="20" />
                    <uix:spacer height="20" />
                    <uix:spacer height="20" />
                    <uix:spacer height="20" />
                  </uix:rowLayout>
                         
                  <uix:rowLayout>
                   <uix:image sourceBinding="componentChip" destinationBinding="componentDetailsLink" width="12" height="12" />
                   <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="componentTimeLabel" styleClass="OraPromptText" />
                    </uix:cellFormat>
                    <uix:spacer width="8"/>
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" textBinding="componentTime" destinationBinding="componentDetailsLink" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:spacer height="1" />
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                   <uix:image sourceBinding="subComponentChip" destinationBinding="subComponentDetailsLink" width="12" height="12" />
                   <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="subComponentTimeLabel" styleClass="OraPromptText" />
                    </uix:cellFormat>
                    <uix:spacer width="8"/>
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" textBinding="subComponentTime" destinationBinding="subComponentDetailsLink" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:spacer height="1" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                                    
                </uix:tableLayout>
                </uix:cellFormat>

                <uix:cellFormat hAlign="left" vAlign="top" width="40%" >
                  <uix:stackLayout>
                    <uix:spacer height="1" />
                      <uix:contentContainer width="100%" textBinding="ADVICE@webappMsg" renderedBinding="haveAdvice" >
                        <uix:contents>
                          <uix:stackLayout>
                            <uix:contents childDataBinding="detailsAdvice" >
                              <uix:styledText styleClass="OraInstructionText" textBinding="detailsAdviceItem" />
                              <uix:spacer height="5"/>
                            </uix:contents>
                          </uix:stackLayout>
                          <uix:link textBinding="detailsAdviceLinkText" destinationBinding="detailsAdviceLinkDestination" />
                        </uix:contents>
                      </uix:contentContainer>
                  </uix:stackLayout>             
                </uix:cellFormat>

              </uix:rowLayout>

            </uix:tableLayout>

            </uix:stackLayout>
          </uix:header>

          </uix:cellFormat>
  
          </uix:rowLayout>
          </uix:tableLayout>

          <uix:header textBinding="INVOCATION_PATHS@webappMsg" renderedBinding="showComponent" >
            <uix:stackLayout>
             <uix:switcher childNameBinding="singleInvocation">
              <uix:case name="true">    
               <uix:table id="invocationTableId" 
                  alternateTextBinding="NO_INVOCATIONS@webappMsg"
                  summaryBinding ="COMPONENT_PERF_INVOC_TABLE_SUMMARY@webappMsg"
                  destinationBinding="currentFilteredUrlWithOthers@servletRequest"                  
                  width="100%"
                  tableDataBinding="invocationTableData"
                  columnFormatsBinding="columnFormats"
                  columnHeaderDataBinding="columnHeaderData"
                  valueBinding="invocTableValue"
                  maxValueBinding="invocTableMaxValue"
                  blockSizeBinding="invocTableBlockSize" >
              
                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                </uix:columnHeaderStamp>
                 
                <uix:contents>
                  <uix:link textBinding="invocation@" destinationBinding="invocationDest@" shortDescBinding="invocationDesc@" />
                  <uix:styledText textBinding="hits@"/>
                    <%--
                  <uix:styledText textBinding="totalTime@"/>
                    --%>
                  <uix:styledText textBinding="exclusiveTime@"/>
                  <uix:styledText textBinding="calloutTime@"/>
                  <uix:include nodeBinding="cigar@" />      
                </uix:contents>
               </uix:table>
              </uix:case>  
              <uix:default>
               <uix:table id="invocationTableId" 
                  alternateTextBinding="NO_INVOCATIONS@webappMsg"
                  destinationBinding="currentFilteredUrlWithOthers@servletRequest"                  
                  width="100%"
                  tableDataBinding="invocationTableData"
                  columnFormatsBinding="columnFormats"
                  columnHeaderDataBinding="columnHeaderData"
                  valueBinding="invocTableValue"
                  maxValueBinding="invocTableMaxValue"
                  blockSizeBinding="invocTableBlockSize" >
              
                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                </uix:columnHeaderStamp>
                 
                <uix:contents>
                  <uix:styledText textBinding="pageno@"/>
                  <uix:link textBinding="invocation@" destinationBinding="invocationDest@" shortDescBinding="invocationDesc@" />
                  <uix:styledText textBinding="hits@"/>
                    <%--
                  <uix:styledText textBinding="totalTime@"/>
                    --%>
                  <uix:styledText textBinding="exclusiveTime@"/>
                  <uix:styledText textBinding="calloutTime@"/>
                  <uix:include nodeBinding="cigar@" />      
                </uix:contents>
               </uix:table>   
              </uix:default>
             </uix:switcher>
              
            
              <uix:spacer height="5" />

              <uix:rowLayout hAlign="right" >
                <uix:include nodeBinding="invocationTableLegend" />
              </uix:rowLayout>

            </uix:stackLayout>
          </uix:header>
        
          <uix:header textBinding="callsMadeHeader" renderedBinding="showInvocation" >
            <uix:stackLayout>
             <uix:switcher childNameBinding="JDBCConnCall">
              <uix:case name="true">
                <uix:table id="callsTableId" 
                    alternateTextBinding="NO_CALLS_MADE@webappMsg"
                    summaryBinding ="COMPONENT_PERF_CALLS_TABLE_SUMMARY@webappMsg"
                    destinationBinding="currentFilteredUrlWithOthers@servletRequest"
                    width="100%"
                    tableDataBinding="callsTableData"
                    columnFormatsBinding="callsColumnFormats"
                    columnHeaderDataBinding="callsColumnHeaderData"
                    valueBinding="callsTableValue"
                    maxValueBinding="callsTableMaxValue"
                    blockSizeBinding="callsTableBlockSize" >
                    
                  <uix:tableFormat tableBanding="rowBanding"/>
  
                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                  </uix:columnHeaderStamp>
  
                  <uix:contents>
                    <uix:link textBinding="itemName@" destinationBinding="itemDest@" shortDescBinding="itemDesc@" />
                    <uix:styledText textBinding="rank@" />
                    <uix:styledText textBinding="invocations@"/>
                    <uix:styledText textBinding="exclusiveTime@"/>
                    <uix:include nodeBinding="cigar@" />      
                    <uix:flowLayout renderedBinding="showDetails" >
                      <uix:image sourceBinding="detailsDesc@" destinationBinding="detailsDest@" />
                    </uix:flowLayout>
                  </uix:contents>
                </uix:table>
              </uix:case>
              <uix:default>
                <uix:table id="callsTableId" 
                    alternateTextBinding="NO_CALLS_MADE@webappMsg"
                    summaryBinding ="COMPONENT_PERF_CALLS_TABLE_SUMMARY@webappMsg"
                    destinationBinding="currentFilteredUrlWithOthers@servletRequest"
                    width="100%"
                    tableDataBinding="callsTableData"
                    columnFormatsBinding="callsColumnFormats"
                    columnHeaderDataBinding="callsColumnHeaderData"
                    valueBinding="callsTableValue"
                    maxValueBinding="callsTableMaxValue"
                    blockSizeBinding="callsTableBlockSize" >
                    
                  <uix:tableFormat tableBanding="rowBanding"/>
  
                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                  </uix:columnHeaderStamp>
  
                  <uix:contents>
                    <uix:link textBinding="itemName@" destinationBinding="itemDest@" shortDescBinding="itemDesc@" />
                    <uix:styledText textBinding="itemType@"/>
                    <uix:styledText textBinding="rank@" />
                    <uix:styledText textBinding="invocations@"/>
                    <uix:styledText textBinding="exclusiveTime@"/>
                    <uix:styledText textBinding="calloutTime@"/>
                    <uix:include nodeBinding="cigar@" />      
                    <uix:flowLayout renderedBinding="showDetails" >
                      <uix:image sourceBinding="detailsDesc@" destinationBinding="detailsDest@" />
                    </uix:flowLayout>
                  </uix:contents>
                </uix:table>              
              </uix:default>
             </uix:switcher>
            
              <uix:spacer height="5" />

              <uix:rowLayout hAlign="right" >
                <uix:include nodeBinding="callsTableLegend" />
              </uix:rowLayout>

            </uix:stackLayout>
          </uix:header>
        
            <%@include file="webappURLRelatedLinks.jspf" %>

          </uix:stackLayout>
          </uix:header> 

       </uix:contents>      
      </uix:dataScope>      
    </uix:pageLayout>
    </uix:body>
</uix:document>
</uix:renderingContext>

