<%--

/* $Header: webappURLConf.jsp 03-jun-2008.12:16:39 jashukla Exp $ */
/* Copyright (c) 2001, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     End to end configuration page.

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      jashukla 06/03/08 - Bug 7144619 remove internal identifiers
      yxie     09/12/06 - XbranchMerge yxie_bug-5521573 from main
      jureyes  08/10/06 - Backport jureyes_bug5186918 from main
      yxie     08/04/06 - XbranchMerge yxie_formsapp_regression from main
      yxie     07/12/06 - XbranchMerge yxie_forms-monitoring from main 
      jureyes  02/17/06 - Backport jureyes_bug-5005456 from main 
      yxie     09/07/06 - Fix bug 5521573
      jureyes  07/31/06 - Fix bug 5186918 (enable logging for 10.1.3.1 oc4js).
      yxie     02/22/06 - Add table for configuring Forms
      jureyes  01/31/06 - Fix bug 5005456 (disable selection in the table for 
                          10.1.3 OC4Js. 
      yxie     08/29/05 - fix bug 4574461
      jureyes  07/31/05 - Add table navigation to the confirmation page (bug 4521326). 
      yxie     07/18/05 - make form submission method post
      yxie     07/14/05 - fix bug 4490976
      eporter  06/07/05 - Bug 4415243: ADA compliance 
      jureyes  02/14/05 - 
      yxie     02/09/05 - add Type column to table
      yxie     01/20/05 - Fix Bug 3093533
      jureyes  01/10/05 - 
      yxie     11/05/04 - 
      afontana 02/24/04 - consult AGENT_GREY 
      jriel    10/13/03 - difft message if no data 
      jriel    10/15/03 - utf8 for jsp 
      jriel    08/20/03 - add config lead in 
      asawant  07/26/03 - asawant_e2e_config_030703
      asawant  07/25/03 - 
      asawant  07/04/03 - Creation.
 */

/**
 *  @version $Header: webappURLConf.jsp 03-jun-2008.12:16:39 jashukla Exp $
 *  @author  asawant
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page import='oracle.sysman.eml.ImageNames'%>
<%@ page import='oracle.sysman.eml.webapp.WebappConstants'%>
<%@ page import='oracle.sysman.eml.mntr.Constants'%>
<%@ page import='oracle.sysman.eml.webapp.data.WebappE2EConfig'%>
<%@ page import='oracle.sysman.eml.mntr.util.GenDataObjectList'%>
<%@ page import='oracle.cabo.ui.data.DictionaryData'%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="iasMsg" class="oracle.sysman.ias.oc4j.msg.OC4JMsg"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <uix:bundle name="cmnMsg" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrMsg" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="gensvcMsg" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
  <uix:bundle name="formsappMsg" class="oracle.sysman.resources.eml.formsapp.FormsappResourceBundle"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>
    
    <uix:body>

      <uix:pageLayout>

        <%@ include file="/oemGlobal.jspf" %>

        <uix:dataScope
            currentDataBinding="e2eConfig@servletRequest" >

							<uix:switcher childNameBinding="apacheRestarted@servletRequest">
								<uix:case name="true">
									<uix:messageBox messageType="confirmation" messageBinding="APACHE_RESTARTED_MSG@webappMsg"/>
								</uix:case>
							</uix:switcher>

    		      <uix:switcher childNameBinding="formsConfigCompleted@servletRequest">
		    			  <uix:case name="true">
				    		  <uix:messageBox messageType="confirmation" messageBinding="FORMS_EUM_CONFIG_COMPLETED_MSG@formsappMsg"/>
						    </uix:case>
					    </uix:switcher>

          <uix:header textBinding="header" >
            <uix:form name="e2eConfigForm" method="POST">
              <uix:switcher childNameBinding="needConf">

                <uix:case name="<%=Boolean.TRUE%>">
                  <%-- Confirmation Page --%>
                  <uix:stackLayout>

                    <uix:messageBox messageType="warn"
                        messageBinding="confConfigChange" />

                    <uix:spacer height="5"/>

                    <uix:table tableDataBinding="tableData" 
                               summaryBinding="header"
                               blockSizeBinding="confirmBlockSize"
                               valueBinding="tableValue"
                               minValueBinding="minValue"
                               maxValueBinding="maxValue"
                               width="100%">

                      <uix:tableFormat tableBanding="rowBanding"/>

                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding="NAME_HDR@webappMsg"/>
                        </uix:columnHeader>
                        <uix:styledText
                            textBinding="<%=WebappE2EConfig.TARGET_DISP%>"/>
                      </uix:column>

                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding="ACTION@webappMsg"/>
                        </uix:columnHeader>
                        <uix:styledText
                            textBinding="<%=WebappE2EConfig.ACTION_STR%>"/>
                      </uix:column>

                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding="INTERVAL@webappMsg"/>
                        </uix:columnHeader>
                        <uix:styledText
                            textBinding="<%=WebappE2EConfig.FREQ%>"/>
                      </uix:column>

                    </uix:table>

                    <uix:spacer height="5"/>

                    <uix:rowLayout hAlign="left">
                      <uix:submitButton name="event" value="confirm" textBinding="APPLY@webappMsg"/>
                      <uix:button textBinding="CANCEL_BTN_TEXT@webappMsg"
                          destinationBinding="cancelDest"/>
                    </uix:rowLayout>

                    <uix:formValue
                        name="<%=WebappE2EConfig.CONFIRMED%>"
                        value="<%=Boolean.TRUE%>"/>

                    <uix:spacer height="5"/>

                  </uix:stackLayout>
                </uix:case>

                <uix:default>
                  <%-- Table Page --%>
                  <uix:stackLayout>

                    <uix:rowLayout hAlign="right">
                      <uix:styledText textBinding="PAGE_REFRESHED@mntrMsg"
                          styleClass="OraTipText"/>
                      <uix:spacer width="5"/>
                      <uix:styledText textBinding="refreshTime"
                          styleClass="OraTipLabel"/>
                      <uix:spacer width="5"/>
                      <uix:button textBinding="REFRESH@sdkMsg"
                                  destinationBinding="reloadDest"/>
                      <uix:spacer width="5"/>
                      <uix:submitButton name="event" value="apply" textBinding="APPLY@webappMsg"/>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:spacer height="25"/>
                    </uix:rowLayout>

                    <uix:rowLayout width="100%">
                      <uix:switcher childNameBinding="ifError">
                        <uix:case name="<%=Boolean.TRUE%>">
                          <uix:stackLayout>
                            <uix:messageBox messageBinding="error"
                                messageType="error"/>
                            <uix:spacer height="10"/>
                          </uix:stackLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top">

                        <uix:tableLayout width="100%">

                          <uix:rowLayout>			
                            <uix:cellFormat width="100%">
                              <uix:switcher childNameBinding="isFormsApp">
						    		            <uix:case name="<%=Boolean.TRUE%>">
                                  <uix:switcher childNameBinding="compType">
      	    				    	          <uix:case name="oracle_webserver">
                                      <uix:header textBinding="FORMS_SERVER@formsappMsg">

                                        <uix:spacer height="5"/>
                                          <uix:table name="<%=WebappE2EConfig.FORMS_TABLE_NAME%>"
                                                     tableDataBinding="formsTableData"
                                                     formSubmitted="<%=Boolean.TRUE%>"
                                                     blockSizeBinding="formsBlockSize"
                                                     valueBinding="formsTableValue"
                                                     minValueBinding="formsMinValue"
                                                     maxValueBinding="formsMaxValue"
                                                     width="100%"
                                                     summaryBinding="FORMS_SERVER@formsappMsg">
                                            <uix:tableFormat tableBanding="rowBanding"/>
                                            <uix:tableSelection>
								                              <uix:singleSelection selectedIndex="0" shortDescBinding="<%=WebappE2EConfig.TARGET_DISP%>" disabledBinding="<%=WebappE2EConfig.DISABLED_BIND%>">
                                                <uix:button textBinding="configButtonTxt@e2eConfig@servletRequest" onClick="openFormsURLWindow()"/>
            								                  </uix:singleSelection>
						  	                            </uix:tableSelection>

                                            <uix:formValue name="<%=WebappE2EConfig.CONFIG_LINK%>"
                                                           valueBinding="<%=WebappE2EConfig.CONFIG_LINK%>"/>
                                            <uix:formValue name="<%=WebappE2EConfig.OPEN_NEW_WINDOW%>"
                                                           valueBinding="<%=WebappE2EConfig.OPEN_NEW_WINDOW%>"/>
                                            <uix:formValue name="<%=WebappE2EConfig.CONFIG_LINK_DISABLED%>"
                                                           valueBinding="<%=WebappE2EConfig.CONFIG_LINK_DISABLED%>"/>

                                            <uix:column>
                                              <uix:columnHeader>
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                  <uix:sortableHeader textBinding="NAME_HDR@webappMsg"
																												              sortableBinding="formsNameSortable"/>
                                    
                                              </uix:columnHeader>
                                              <uix:link textBinding="<%=WebappE2EConfig.TARGET_DISP%>"
                                                        destinationBinding="<%=WebappE2EConfig.TARGET_LINK%>"/>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnHeader>
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:sortableHeader textBinding="TYPE_HDR@webappMsg"/>                        
                                              </uix:columnHeader>
                                              <uix:link textBinding="<%=WebappE2EConfig.TARGET_TYPE_DISP%>"/>
                                            </uix:column>

                                            <uix:column>
                                              <uix:columnHeader>
                                                <uix:styledText textBinding="CURRENT_STATUS@webappMsg"/>
                                              </uix:columnHeader>
                                              <uix:columnFormat columnDataFormat="iconButtonFormat" width="10"/>
                                              <uix:rowLayout hAlign="center">
                                                <uix:image sourceBinding="<%=WebappE2EConfig.STATUS_ICON%>"
                                                           shortDescBinding="<%=WebappE2EConfig.STATUS_DESC%>"/>
                                              </uix:rowLayout>
                                            </uix:column>
                                          </uix:table>
                                      </uix:header>
    														    </uix:case>
                                  </uix:switcher>
				    				            </uix:case>
						    	            </uix:switcher>
                            </uix:cellFormat>
                          </uix:rowLayout>

                          <uix:rowLayout>
                            <uix:cellFormat width="100%">

										          <uix:header textBinding="tableHeader" >

                              <uix:spacer height="5"/>
                              <uix:table name="<%=WebappE2EConfig.TABLE_NAME%>"
                                  summaryBinding="tableHeader"
                                  tableDataBinding="tableData"
                                  formSubmitted="<%=Boolean.TRUE%>"
                                  alternateTextBinding="USE_ADD_RM@webappMsg"
                                  blockSizeBinding="blockSize"
                                  valueBinding="tableValue"
                                  minValueBinding="minValue"
                                  maxValueBinding="maxValue"
                                  width="100%">

                                <uix:tableFormat tableBanding="rowBanding"/>
							  
                                <uix:tableSelection>
								                 <uix:singleSelection selectedIndex="0" shortDescBinding="<%=WebappE2EConfig.TARGET_DISP%>" disabledBinding="<%=WebappE2EConfig.DISABLED_BIND%>">
                		              <uix:button textBinding="configButtonTxt@e2eConfig@servletRequest" onClick="openURLWindow()" disabledBinding="logButtonBind@e2eConfig@servletRequest" />

								                 </uix:singleSelection>
							                 </uix:tableSelection>
                                <%--
                                <uix:formValue
                                    name="<%=WebappE2EConfig.TARGET%>"
                                    valueBinding="<%=WebappE2EConfig.TARGET%>"/>
                                --%>

                                <uix:formValue
                                    name="<%=WebappE2EConfig.CONFIG_LINK%>"
                                    valueBinding="<%=WebappE2EConfig.CONFIG_LINK%>"/>
                                <uix:formValue
                                    name="<%=WebappE2EConfig.OPEN_NEW_WINDOW%>"
                                    valueBinding="<%=WebappE2EConfig.OPEN_NEW_WINDOW%>"/>

                                <uix:formValue
                                    name="<%=WebappE2EConfig.CONFIG_LINK_DISABLED%>"
                                    valueBinding="<%=WebappE2EConfig.CONFIG_LINK_DISABLED%>"/>

                                <uix:column>
                                  <uix:columnHeader>
                                    <uix:columnFormat columnDataFormat="textFormat" />
                                    <uix:sortableHeader textBinding="NAME_HDR@webappMsg"
																												sortableBinding="targetNameSortable" 
																												 />
                                    
                                  </uix:columnHeader>
                                  <uix:link
                                      textBinding="<%=WebappE2EConfig.TARGET_DISP%>"
                                      destinationBinding="<%=WebappE2EConfig.TARGET_LINK%>"/>
                                </uix:column>

                                <uix:column>
                                  <uix:columnHeader>
                                    <uix:styledText textBinding="TYPE_HDR@webappMsg"/>
                                  </uix:columnHeader>
                                  <uix:styledText textBinding="<%=WebappE2EConfig.TARGET_TYPE_DISP%>"/>
                               </uix:column>

                                <uix:column>
                                  <uix:columnHeader>
                                    <uix:styledText
                                        textBinding="AGENT_STAT@webappMsg"/>
                                  </uix:columnHeader>
                                  <uix:rowLayout hAlign="center">
                                    <uix:image sourceBinding="<%=WebappE2EConfig.STATUS_ICON%>"
                                               shortDescBinding="<%=WebappE2EConfig.STATUS_DESC%>"/>
                                  </uix:rowLayout>
                                </uix:column>

                                <uix:column>
                                  <uix:columnHeader>
                                    <uix:styledText textBinding="COLLECTION_ENABLED@webappMsg"/>
                                  </uix:columnHeader>
                                  <uix:rowLayout hAlign="center">
                                    <uix:checkBox name="<%=WebappE2EConfig.COLLECT%>"
                                        checkedBinding="<%=WebappE2EConfig.COLLECT%>"
                                        disabledBinding="<%=WebappE2EConfig.AGENT_GREY%>"
                                        shortDescBinding="COLLECTION_ENABLED@webappMsg"/>
                                  </uix:rowLayout>
                                </uix:column>

                                <uix:column>
                                  <uix:columnHeader>
                                    <uix:styledText textBinding="INTERVAL@webappMsg"/>
                                  </uix:columnHeader>
                                  <uix:rowLayout hAlign="center">
                                    <uix:textInput
                                        textBinding="<%=WebappE2EConfig.FREQ%>"
                                        columns="3" maximumLength="3"
                                        name="<%=WebappE2EConfig.FREQ%>"
                                        disabledBinding="<%=WebappE2EConfig.AGENT_GREY%>"
                                        shortDescBinding="INTERVAL@webappMsg"/>
                                  </uix:rowLayout>
                                </uix:column>

																<%--uix:column>
    		                        	<uix:columnHeader>			
																		<uix:switcher childNameBinding="compType">
      	    					            		<uix:case name="oracle_webserver">																
		    		      	                    <uix:styledText textBinding="INSTRUMENTATION@webappMsg"/>
																			</uix:case>
																			<uix:default>
																				<uix:styledText textBinding="LOGGING@webappMsg"/>
																			</uix:default>
																		</uix:switcher>
            		                  </uix:columnHeader>
                		              <uix:link textBinding="<%=WebappE2EConfig.CONFIG_LINK_TEXT%>"
                    					              destinationBinding="<%=WebappE2EConfig.CONFIG_LINK%>"
																						disabledBinding="<%=WebappE2EConfig.CONFIG_LINK_DISABLED%>"
                              					    targetFrameBinding="<%=WebappE2EConfig.CONFIG_LINK_TARGET_FRAME%>"/>
																</uix:column--%>


                              </uix:table>
                              <uix:rawText>
                                <script>
                                  function openURLWindow()
                                  {
                                     var proxy = new TableProxy('<%=WebappE2EConfig.TABLE_NAME%>');
                                     var row = proxy.getSelectedRow();
                                     var url = (document.getElementsByName('<%=WebappE2EConfig.TABLE_NAME%>' + ':' + '<%=WebappE2EConfig.CONFIG_LINK%>' + ':' + row))[0].value;
                                     var newWindow = (document.getElementsByName('<%=WebappE2EConfig.TABLE_NAME%>' + ':' + '<%=WebappE2EConfig.OPEN_NEW_WINDOW%>' + ':' + row))[0].value;
                                     var linkDisabled = (document.getElementsByName('<%=WebappE2EConfig.TABLE_NAME%>' + ':' + '<%=WebappE2EConfig.CONFIG_LINK_DISABLED%>' + ':' + row))[0].value;
                                     
                                     if (linkDisabled == 0 && newWindow == 1)
                                     {
					                               openWindow(window, url);
                                     } 
                                    else
                                    {
                                         submitForm('e2eConfigForm',true,{'event':'configure'});
                                    }
                                  }
                                  function openFormsURLWindow()
                                  {
                                     var proxy = new TableProxy('<%=WebappE2EConfig.FORMS_TABLE_NAME%>');
                                     var row = proxy.getSelectedRow();
                                     var url = (document.getElementsByName('<%=WebappE2EConfig.FORMS_TABLE_NAME%>' + ':' + '<%=WebappE2EConfig.CONFIG_LINK%>' + ':' + row))[0].value;
                                     var newWindow = (document.getElementsByName('<%=WebappE2EConfig.FORMS_TABLE_NAME%>' + ':' + '<%=WebappE2EConfig.OPEN_NEW_WINDOW%>' + ':' + row))[0].value;
                                     var linkDisabled = (document.getElementsByName('<%=WebappE2EConfig.FORMS_TABLE_NAME%>' + ':' + '<%=WebappE2EConfig.CONFIG_LINK_DISABLED%>' + ':' + row))[0].value;
                                     
                                     if (linkDisabled == 0 && newWindow == 1)
                                     {   
					                               openWindow(window, url);
                                     } 
                                     else
                                     {
                                         submitForm('e2eConfigForm',true,{'event':'configureForms'});
                                     }
                                  }
                                </script>
                              </uix:rawText>


                              <uix:spacer height="10"/>

                              <uix:rowLayout hAlign="left">
																<uix:styledText textBinding="RELATED_LINK@webappMsg" styleClass="OraDataText" />
                                <uix:spacer width="10" />
                                <uix:link textBinding="SYSTEM_CONFIGURATION@gensvcMsg"
                                    destinationBinding="webappCompLink"/>
                               </uix:rowLayout>

                             </uix:header>

                            </uix:cellFormat>
                          </uix:rowLayout>

                          <uix:rowLayout>
                            <uix:spacer height="10"/>
                          </uix:rowLayout>


	                        <uix:switcher childNameBinding="oneAgentDown">
                          	<uix:case name="<%=Boolean.TRUE%>">
		                          <uix:rowLayout>
    		                        <uix:tip>
        		                      <uix:contents>
            		                    <uix:styledText textBinding="CONFIGURE_TIP@webappMsg" />
		                              </uix:contents> 
    		                        </uix:tip>  
		                          </uix:rowLayout>
                            </uix:case>
                          </uix:switcher>
								          
											    <uix:rowLayout>
	                	       	<uix:spacer height="10"/>
                   		    </uix:rowLayout>

                          <uix:rowLayout>
                            <uix:tip>
                              <uix:contents>
                                <uix:styledText textBinding="configTip" />
                              </uix:contents> 
                            </uix:tip>  
                          </uix:rowLayout>
                          
											    <uix:rowLayout>
	                	       	<uix:spacer height="10"/>
                   		    </uix:rowLayout>

	                        <uix:switcher childNameBinding="compType">
                            <uix:case name="oracle_webserver">
                              <uix:switcher childNameBinding="isFormsApp">
	  					    		          <uix:case name="<%=Boolean.FALSE%>">
		                              <uix:rowLayout>
    		                            <uix:tip>
        		                          <uix:contents>
            		                        <uix:styledText textBinding="WEBSERVER_INSTRUMENT_TIP@webappMsg" />
		                                  </uix:contents> 
    		                            </uix:tip>  
		                              </uix:rowLayout>
                                </uix:case>
                              </uix:switcher>  
                            </uix:case>
                          </uix:switcher>  
                          
                          <uix:switcher childNameBinding="display1013Tip">  
                            <uix:case name="true">
                              <uix:rowLayout>
                                <uix:spacer height="10"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:tip>
                                  <uix:contents>
                                    <uix:styledText textBinding="oc4j1013Tip" />
                                  </uix:contents> 
                                </uix:tip>  
                              </uix:rowLayout>
                            </uix:case>
                          </uix:switcher>

                        </uix:tableLayout>
                      </uix:cellFormat>

                      <uix:spacer width="10"/>

                      <uix:cellFormat width="35%">
                        <uix:contentContainer width="100%"
                            textBinding="instructHeader">
                          <uix:styledText styleClass="OraInstructionText" textBinding="instructLeadIn" />
                          <uix:bulletedList>
                            <uix:contents childDataBinding="configSteps">
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="<%=WebappE2EConfig.LABEL%>"/>
                            </uix:contents>
                          </uix:bulletedList>
                        </uix:contentContainer/>
                      </uix:cellFormat>

                    </uix:rowLayout>

                  </uix:stackLayout>
                </uix:default>

              </uix:switcher>

              <uix:formValue
                  name="<%=WebappConstants.COMP_TYPE_PROPERTY%>"
                  valueBinding="compType"/>
              <%-- automatically added by EM's page handler
              <uix:formValue
                  name="<%=Constants.TARGET_PAGE_PROPERTY%>"
                  valueBinding="name"/>
              <uix:formValue
                  name="<%=Constants.TARGET_TYPE_PAGE_PROPERTY%>"
                  valueBinding="type"/>
              --%>

            </uix:form>
          </uix:header>
        </uix:dataScope>

      </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>
