<%@ page contentType="text/html; charset=UTF-8" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import='oracle.sysman.eml.webapp.eum.data.EUMConstants' %> 
<%@ page import='oracle.sysman.eml.mntr.user.UserMntrConstants' %> 
<%@ page import='oracle.sysman.eml.gensvc.GenSvcUIConstants' %> 

<%--
<uix:buildTree nodeID="preHeaderPlugin" >
  <% request.setAttribute("preHeaderPlugin", "true"); %>
  <%@include file="webappTimeChoice.jspf" %>
</uix:buildTree>
--%>

<jsp:useBean
		id="urlPerfData"
		scope="request"
		type="oracle.sysman.eml.webapp.data.WebappURLPerfData"/>

<uix:buildTree nodeID="homePlugin">
  <uix:dataScope currentDataBinding="urlPerfData@servletRequest" >
    <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg" />
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle" />
  <uix:bundle name="formsappMsg" class="oracle.sysman.resources.eml.formsapp.FormsappResourceBundle" />

    <uix:tableLayout>         
      <uix:rowLayout>
          <uix:stackLayout>
            <%@include file="webappTimeChoice.jspf" %>

					<uix:form name="AnalyzeForm2" method="post"
							  destinationBinding="analyzeLink@urlPerfData@servletRequest">
					  <uix:header textBinding="watchlistHeader@urlPerfData@servletRequest" >
						<uix:stackLayout>	
						  <uix:spacer height="5" />
						  <uix:styledText textBinding="watchlistDesc@urlPerfData@servletRequest" styleClass="OraPromptText" />
						  <uix:tableLayout width="100%">
							<uix:rowLayout hAlign="right" >
							  <uix:cellFormat>
								<uix:button textBinding="EDIT_WATCHLIST@webappMsg" destinationBinding="editWatchlistLink@servletRequest" />
							  </uix:cellFormat>
							</uix:rowLayout>
						  </uix:tableLayout>

						  <uix:spacer height="10" />

						  <uix:dataScope currentDataBinding="watchListUrlTable@urlPerfData@servletRequest" >
              <uix:switcher childNameBinding="isFormType@urlPerfData@servletRequest" >
                <uix:case name="true">
                  <uix:table id="watchListUrlTableId" 
                             alternateTextBinding="NO_FORMS_ACTIONS_WATCHLIST@formsappMsg"
                             width="100%"
									   				 destinationBinding="currentFilteredUrlWithBy@servletRequest"
                             tableDataBinding="urlTableData"
                             columnFormatsBinding="columnFormats"
                             columnHeaderDataBinding="columnHeaderData"
                             summaryBinding="FORMS_ACTIONS_WATCHLIST@formsappMsg">
																					
									  <%-- Embed java here for code simplicity since cannot put tableSelection in switcher by itself --%>
										<% if ( urlPerfData.getRenderAnalyze() != null && urlPerfData.getRenderAnalyze().equals("true") ) { %>	
                        <uix:tableSelection>
                          <uix:singleSelection selectedIndex="0" shortDescBinding="urlDesc@">
                            <uix:submitButton textBinding="ANALYZE_HDR@webappMsg" />
                          </uix:singleSelection>
                        </uix:tableSelection>
							      <% } %>

                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                  		<uix:sortableHeader textBinding="text"
									                        sortableBinding="sortable" />
           			   </uix:columnHeaderStamp>
                   <uix:contents>
                     <uix:link textBinding="url@"
                               destinationBinding="urlDest@"
                               shortDescBinding="urlDesc@" />
                     <uix:styledText textBinding="hits@"/>
                     <uix:styledText textBinding="processTime@"/>
                     <uix:styledText textBinding="selectColumn@" renderedBinding="showSelectColumn@"/>
                     <uix:styledText textBinding="database@" renderedBinding="showDBColumn"/>
							       <uix:dataScope>
											 <uix:contents>
		     								<uix:include nodeBinding="cigar@"/>
	  										<uix:spacer width="1"/>
							    			<uix:styledText textBinding="cigarText@" styleClass="oraInstructionText"/>
											</uix:contents>
										</uix:dataScope>
                   </uix:contents>
									  <% if ( urlPerfData.getRenderAnalyze() != null && urlPerfData.getRenderAnalyze().equals("true") ) { %>	
                     	<uix:formValue name="<%= EUMConstants.COMP_1 %>" valueBinding="analyzeCompKey@"/>
									  <% } %>
                 </uix:table>

               </uix:case>
               <uix:default>
							<uix:table id="watchListUrlTableId" 
								alternateTextBinding="NO_URL_WATCHLIST@webappMsg"
								width="100%"
								destinationBinding="currentFilteredUrlWithBy@servletRequest"
								tableDataBinding="urlTableData"
                summaryBinding="URL_WATCHLIST@webappMsg">

							  <uix:tableFormat tableBanding="rowBanding"/>

                <%-- Embed java here for code simplicity since cannot put tableSelection in switcher by itself --%>
								<% if ( urlPerfData.getRenderAnalyze() != null && urlPerfData.getRenderAnalyze().equals("true") ) { %>
							  <uix:tableSelection>
								<uix:singleSelection selectedIndex="0"  shortDescBinding="urlDesc@">
								  <uix:submitButton textBinding="ANALYZE_HDR@webappMsg"/>
								</uix:singleSelection>
							  </uix:tableSelection>
								<% } %>

							  <uix:contents>
                  <uix:column>
                    <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                    <uix:columnHeader>
											<uix:sortableHeader textBinding="urlColHdr@urlColumnHeaders@"
																					sortableBinding="urlColHdr@urlSortStates@" value="0"/>	
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:flowLayout>
                        <uix:contents>
                          <uix:include nodeBinding="visitUrlIcon@"/>
                          <uix:spacer width="1"/>
                          <uix:link textBinding="url@" 
                                    destinationBinding="urlDest@" 
                                    shortDescBinding="urlDesc@"/>
                        </uix:contents>
                      </uix:flowLayout>
                    </uix:contents>
                  </uix:column>
                  <uix:columnGroup>
                    <uix:columnHeader>
                      <uix:text textBinding="compLoadColGrpHdr@urlColumnHeaders@"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:column>
                        <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                        <uix:columnHeader>
													<uix:sortableHeader textBinding="compHitsColHdr@urlColumnHeaders@watchListUrlTable@urlPerfData@servletRequest" 
																							sortableBinding="compHitsColHdr@urlSortStates@watchListUrlTable@urlPerfData@servletRequest" 
																							value="1"/>
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:styledText textBinding="hits@"/>
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                        <uix:columnHeader>
													<uix:sortableHeader textBinding="compAvgTimeColHdr@urlColumnHeaders@watchListUrlTable@urlPerfData@servletRequest"
																							sortableBinding="compAvgTimeColHdr@urlSortStates@watchListUrlTable@urlPerfData@servletRequest" 
																							value="2"/>	
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:styledText textBinding="processTime@"/>
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                        <uix:columnHeader>
													<uix:sortableHeader textBinding="selectColHdr@urlColumnHeaders@watchListUrlTable@urlPerfData@servletRequest"
																							sortableBinding="selectColHdr@urlSortStates@watchListUrlTable@urlPerfData@servletRequest" 
																							value="3"/>	
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:styledText textBinding="selectColumn@" renderedBinding="showSelectColumn@"/>
                        </uix:contents>
                      </uix:column>
                    </uix:contents>
                  </uix:columnGroup>
                  <uix:columnGroup>
                    <uix:columnHeader>
                      <uix:text textBinding="incompLoadColGrpHdr@urlColumnHeaders@"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:column>
                        <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                        <uix:columnHeader>
													<uix:sortableHeader textBinding="incompHitsColHdr@urlColumnHeaders@watchListUrlTable@urlPerfData@servletRequest"
																							sortableBinding="incompHitsColHdr@urlSortStates@watchListUrlTable@urlPerfData@servletRequest" 
																							value="4"/>	
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:styledText textBinding="incompleteHits@"/>
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                        <uix:columnHeader>
													<uix:sortableHeader textBinding="incompAvgTimeColHdr@urlColumnHeaders@watchListUrlTable@urlPerfData@servletRequest"
																							sortableBinding="incompAvgTimeColHdr@urlSortStates@watchListUrlTable@urlPerfData@servletRequest" 
																							value="5"/>	
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:styledText textBinding="incompleteLoadsTime@"/>
                        </uix:contents>
                      </uix:column>
                    </uix:contents>
                  </uix:columnGroup>
                  <uix:column>
                    <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                    <uix:columnHeader>
                      <uix:text textBinding="cigarColHdr@urlColumnHeaders@"/>
                    </uix:columnHeader>
                    <uix:contents>
											<uix:dataScope>
												<uix:contents> 
		       			          <uix:include nodeBinding="cigar@"/>
													<uix:spacer width="1"/>
													<uix:styledText textBinding="cigarText@" styleClass="oraInstructionText"/>
												</uix:contents>
											</uix:dataScope>
 											<uix:spacer width="1"/>
											<uix:dataScope>
												<uix:contents> 
     							        <uix:include nodeBinding="incompleteLoadsCigar@"/>
													<uix:spacer width="1"/>
													<uix:styledText textBinding="incompleteCigarText@" styleClass="oraInstructionText"/>
												</uix:contents>
											</uix:dataScope>
                    </uix:contents>
                  </uix:column>

							  </uix:contents>
								<% if ( urlPerfData.getRenderAnalyze() != null && urlPerfData.getRenderAnalyze().equals("true") ) { %>	  	                 
									<uix:formValue name="<%= EUMConstants.COMP_1 %>" valueBinding="analyzeCompKey@"/>
								<% } %>
							</uix:table>
              </uix:default>
              </uix:switcher>

							<uix:spacer height="5" />
            	  <uix:rowLayout hAlign="right">
                  <uix:include nodeBinding="urlTableLegend@watchListUrlTable@urlPerfData@servletRequest"/>
                </uix:rowLayout>

						  </uix:dataScope>
						</uix:stackLayout>
					  </uix:header>
							<uix:spacer height="5" />
					  <uix:formValue 
						  name="<%= EUMConstants.COMP_AXIS_1 %>"
						  value="<%= EUMConstants.URL %>"/>
					</uix:form>
                <uix:dataScope currentDataBinding="endUserUrlTable@urlPerfData@servletRequest" >
                  <uix:contents>                      
                    <uix:switcher childNameBinding="endUserURLData">

                      <uix:case name="true">

                        <uix:rowLayout>
                          <uix:contents>   
                            <uix:cellFormat vAlign="top" hAlign="left"
                                width="66%" >
                              <uix:header textBinding="SLOWEST_RESPONSE_TIMES@webappMsg">
                                <uix:stackLayout>
																	<uix:spacer height="5"/>
																	<uix:styledText textBinding="SLOWEST_RESP_TIME_DESC@webappMsg" styleClass="OraPromptText" />
																	<uix:spacer height="10"/>
                                  <uix:form name="eumDetails" method="POST" destinationBinding="currentFilteredUrl@servletRequest" >
                                    <uix:tableLayout width="100%">
                                      <uix:rowLayout vAlign="center" >
                                        <uix:cellFormat hAlign="left" vAlign="center" >
 											<uix:messageChoice promptBinding="VIEW_BY@webappMsg" 
											   selectedValueBinding="selectedPropertyKey@urlPerfData@servletRequest"  
                         name="viewByAxis" onChange="submitForm(eumDetails, false, {event:'viewBy'})">
											  <uix:contents childDataBinding="viewByChoiceList@urlPerfData@servletRequest">
												<uix:option textBinding="text" valueBinding="value" renderedBinding="rendered"/>
											  </uix:contents>
                        <uix:end>
                                            <uix:button textBinding="SHOW_COMP_DETAIL_BTN_TEXT@@webappMsg" 
																												destinationBinding="viewByAxisMetricsLink@urlPerfData@servletRequest" />   
                        </uix:end>
											</uix:messageChoice>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="right" >
										<uix:switcher childNameBinding="selectedPropertyKey@urlPerfData@servletRequest">
											<uix:case name="webcache">
													<uix:spacer width="2" />
											</uix:case>
											<uix:default>        
                          <uix:messageTextInput name="eumMinHitsPost"
                                                promptBinding="MINIMUM_HITS@webappMsg"
                                                columns="3"
															                  textBinding="minHits" >     
                            <uix:onSubmitValidater>
                              <uix:decimal/>
                            </uix:onSubmitValidater>
													<uix:end>
												    <uix:formValue name="event" value="eumMinHits"/>
													  <uix:submitButton name="event"
																  textBinding="GO@commonResourceBundle" value="minHits"/>  
                          </uix:end>
                          </uix:messageTextInput>
											</uix:default>
										</uix:switcher> 
                                        </uix:cellFormat>
                                      </uix:rowLayout>
                                    </uix:tableLayout>
                                  </uix:form>

                                  <uix:spacer height="2" />
                              <uix:form name="AnalyzeForm1" method="post"
                                      destinationBinding="analyzeLink@urlPerfData@servletRequest">
                                  <uix:switcher childNameBinding="emptyTableReason">
                                  <uix:case name="false">
                                  
                                    <uix:switcher childNameBinding="isUrlSelected@urlPerfData@servletRequest" 
																									defaultCase="true">
                                  <uix:case name="false">
                                  <uix:table id="endUserUrlTableId" 
                                      alternateTextBinding="NO_END_USER_DATA@webappMsg"
                                      width="100%"
																			destinationBinding="currentFilteredUrlWithBy@servletRequest"
                                      tableDataBinding="urlTableData"
                                      columnFormatsBinding="columnFormats"
                                      columnHeaderDataBinding="columnHeaderData"
                                      summaryBinding="SLOWEST_RESPONSE_TIMES@webappMsg">
																					
																			<%-- Embed java here for code simplicity since cannot put tableSelection in switcher by itself --%>
																			<% if ( urlPerfData.getRenderAnalyze() != null && urlPerfData.getRenderAnalyze().equals("true") ) { %>	
                                      <uix:tableSelection>
                                        <uix:singleSelection selectedIndex="0"
                                                             shortDescBinding="urlDesc@">
                                          <uix:submitButton textBinding="ANALYZE_HDR@webappMsg" />
                                         </uix:singleSelection>
                                      </uix:tableSelection>
																			<% } %>

                                    <uix:tableFormat tableBanding="rowBanding"/>
									                  <uix:columnHeaderStamp>
                  									  <uix:sortableHeader textBinding="text"
																	                        sortableBinding="sortable" />
               									    </uix:columnHeaderStamp>

                                    <uix:contents>
                                        <uix:link textBinding="url@"
                                            destinationBinding="urlDest@"
                                            shortDescBinding="urlDesc@" />
                                      <uix:styledText textBinding="hits@"/>
                                      <uix:styledText textBinding="processTime@"/>
                                      <uix:styledText textBinding="selectColumn@" renderedBinding="showSelectColumn@"/>
                                      <uix:styledText textBinding="database@" renderedBinding="showDBColumn"/>
																			<uix:dataScope>
																				<uix:contents>
		                      								<uix:include nodeBinding="cigar@"/>
																					<uix:spacer width="1"/>
																					<uix:styledText textBinding="cigarText@" styleClass="oraInstructionText"/>
																				</uix:contents>
																			</uix:dataScope>
                                    </uix:contents>
																			<% if ( urlPerfData.getRenderAnalyze() != null && urlPerfData.getRenderAnalyze().equals("true") ) { %>	
                                      	<uix:formValue name="<%= EUMConstants.COMP_1 %>" valueBinding="analyzeCompKey@"/>
																			<% } %>
                                  </uix:table>
																	</uix:case>
																	
																	<uix:case name="true">

                                  <uix:table id="endUserUrlTableId" 
                                      alternateTextBinding="NO_END_USER_DATA@webappMsg"
                                      width="100%"
                                      destinationBinding="currentFilteredUrlWithBy@servletRequest"
                                      tableDataBinding="urlTableData"
                                      summaryBinding="SLOWEST_RESPONSE_TIMES@webappMsg">

                                      <%-- Embed java here for code simplicity since cannot put tableSelection in switcher by itself --%>
																			<% if ( urlPerfData.getRenderAnalyze() != null && urlPerfData.getRenderAnalyze().equals("true") ) { %>	
                                      <uix:tableSelection>
                                        <uix:singleSelection selectedIndex="0"
                                                             shortDescBinding="urlDesc@">
                                          <uix:submitButton textBinding="ANALYZE_HDR@webappMsg" />
                                         </uix:singleSelection>
                                      </uix:tableSelection>
																			<% } %>

                                    <uix:tableFormat tableBanding="rowBanding"/>

															  <uix:contents>
                                <uix:column>
                                  <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                  <uix:columnHeader>
																		<uix:sortableHeader textBinding="urlColHdr@urlColumnHeaders@"
																												sortableBinding="urlColHdr@urlSortStates@" value="0"/>	
                                   </uix:columnHeader>
                                  <uix:contents>
                                    <uix:flowLayout>
                                      <uix:contents>
                                        <uix:include nodeBinding="visitUrlIcon@"/>
                                        <uix:spacer width="1"/>
                                        <uix:link textBinding="url@" 
																									destinationBinding="urlDest@" 
																									shortDescBinding="urlDesc@"/>
                                      </uix:contents>
                                    </uix:flowLayout>
                                  </uix:contents>
                                </uix:column>
                                <uix:columnGroup>
                                  <uix:columnHeader>
                                    <uix:text textBinding="compLoadColGrpHdr@urlColumnHeaders@"/>
                                  </uix:columnHeader>
                                  <uix:contents>
                                    <uix:column>
                                      <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                      <uix:columnHeader>
																				<uix:sortableHeader textBinding="compHitsColHdr@urlColumnHeaders@endUserUrlTable@urlPerfData@servletRequest"
																														sortableBinding="compHitsColHdr@urlSortStates@endUserUrlTable@urlPerfData@servletRequest" 
																														value="1"/>	
                                      </uix:columnHeader>
                                      <uix:contents>
                                        <uix:styledText textBinding="hits@"/>
                                      </uix:contents>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                      <uix:columnHeader>
																				<uix:sortableHeader textBinding="compAvgTimeColHdr@urlColumnHeaders@endUserUrlTable@urlPerfData@servletRequest"
																														sortableBinding="compAvgTimeColHdr@urlSortStates@endUserUrlTable@urlPerfData@servletRequest" value="2"/>	
                                      </uix:columnHeader>
                                      <uix:contents>
                                        <uix:styledText textBinding="processTime@"/>
                                      </uix:contents>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                      <uix:columnHeader>
																				<uix:sortableHeader textBinding="selectColHdr@urlColumnHeaders@endUserUrlTable@urlPerfData@servletRequest"
																														sortableBinding="selectColHdr@urlSortStates@endUserUrlTable@urlPerfData@servletRequest" value="3"/>	
                                      </uix:columnHeader>
                                      <uix:contents>
                                        <uix:styledText textBinding="selectColumn@" renderedBinding="showSelectColumn@"/>
                                      </uix:contents>
                                    </uix:column>
                                  </uix:contents>
                                </uix:columnGroup>
                                <uix:columnGroup>
                                  <uix:columnHeader>
                                    <uix:text textBinding="incompLoadColGrpHdr@urlColumnHeaders@"/>
                                  </uix:columnHeader>
                                  <uix:contents>
                                    <uix:column>
                                      <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                      <uix:columnHeader>
																				<uix:sortableHeader textBinding="incompHitsColHdr@urlColumnHeaders@endUserUrlTable@urlPerfData@servletRequest"
																														sortableBinding="incompHitsColHdr@urlSortStates@endUserUrlTable@urlPerfData@servletRequest" value="4"/>	
                                      </uix:columnHeader>
                                      <uix:contents>
                                        <uix:styledText textBinding="incompleteHits@"/>
                                      </uix:contents>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                      <uix:columnHeader>
																				<uix:sortableHeader textBinding="incompAvgTimeColHdr@urlColumnHeaders@endUserUrlTable@urlPerfData@servletRequest"
																														sortableBinding="incompAvgTimeColHdr@urlSortStates@endUserUrlTable@urlPerfData@servletRequest" value="5"/>	
                                      </uix:columnHeader>
                                      <uix:contents>
                                        <uix:styledText textBinding="incompleteLoadsTime@"/>
                                      </uix:contents>
                                    </uix:column>
                                  </uix:contents>
                                </uix:columnGroup>
                                <uix:column>
                                  <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                                  <uix:columnHeader>
                                    <uix:text textBinding="cigarColHdr@urlColumnHeaders@"/>
                                  </uix:columnHeader>
                                  <uix:contents>
																		<uix:dataScope>
																			<uix:contents> 
		            							          <uix:include nodeBinding="cigar@"/>
																				<uix:spacer width="1"/>
																				<uix:styledText textBinding="cigarText@" styleClass="oraInstructionText"/>
																			</uix:contents>
																		</uix:dataScope>
  																	<uix:spacer width="1"/>
																		<uix:dataScope>
																			<uix:contents> 
    	          							        <uix:include nodeBinding="incompleteLoadsCigar@"/>
																			<uix:spacer width="1"/>
																			<uix:styledText textBinding="incompleteCigarText@" styleClass="oraInstructionText"/>
																			</uix:contents>
																		</uix:dataScope>
                                  </uix:contents>
                                </uix:column>
														  </uix:contents>
																<% if ( urlPerfData.getRenderAnalyze() != null && urlPerfData.getRenderAnalyze().equals("true") ) { %>	
  	                             	<uix:formValue name="<%= EUMConstants.COMP_1 %>" valueBinding="analyzeCompKey@"/>
																<% } %>
															</uix:table>
														</uix:case>
														</uix:switcher>

                                  </uix:case>
                                  <uix:case name="minHits">
                                  <uix:stackLayout>
                                              <uix:spacer height="5"/>
                          <uix:contentContainer width="100%"
                              textBinding="END_USER_DATA_AVAILABLE@webappMsg" >
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="EUM_DATA_FILTERED_OUT@webappMsg"/>
                              <uix:spacer height="5"/>
                            </uix:contents>
                          </uix:contentContainer/> 
                               </uix:stackLayout>             

                                  </uix:case>
                                  <uix:case name="noRegions">
                                  <uix:stackLayout>
                                              <uix:spacer height="5"/>
                          <uix:contentContainer width="100%"
                              textBinding="END_USER_DATA_AVAILABLE@webappMsg" >
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="EUM_NO_REGIONS@webappMsg"/>
                              <uix:spacer height="5"/>
                              <uix:link styleClass="OraInstructionText"
                                  textBinding="MANAGE_REGIONS@webappMsg"
                                  destinationBinding="manageRegionsDest"/>
                            </uix:contents>
                          </uix:contentContainer/> 
                               </uix:stackLayout>             

                                  </uix:case>
                                  </uix:switcher>
 
                                <uix:formValue 
                                    name="<%= EUMConstants.COMP_AXIS_1 %>"
                                    valueBinding="selectedPropertyKey@urlPerfData@servletRequest"/>
                              </uix:form>

                                  <uix:spacer height="5" />
            	  <uix:rowLayout hAlign="right">
                  <uix:include nodeBinding="urlTableLegend"/>
                </uix:rowLayout>
                <uix:switcher childNameBinding="isFormType@urlPerfData@servletRequest" >
                  <uix:case name="false">
                    <uix:switcher childNameBinding="axis">
                      <uix:case name="<%= UserMntrConstants.URL_OBJ_TYPE %>">
                        <uix:stackLayout>
								          <uix:spacer height="30"/>
   		                    <uix:tip>
        		                <uix:contents>
            		              <uix:styledText textBinding="MINIMUM_SAMPLES_TIP@webappMsg" />
  		                      </uix:contents> 
      		                </uix:tip> 
                        </uix:stackLayout>
                      </uix:case>
                    </uix:switcher>
                  </uix:case>
                </uix:switcher>
                
  
                                  <%--
                                  <uix:spacer height="1" />
                                  <uix:button textBinding="SHOW_ALL@WebappMsgBundle@servletRequest" destinationBinding="showAllUrls@servletRequest" />
                                  --%>

                                </uix:stackLayout>

                                </uix:header>                   

                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        
                      </uix:case>
                    
                      <uix:case name="false">
                        <uix:stackLayout>
                          <uix:spacer height="5"/>
                          <uix:contentContainer width="100%"
                              textBinding="END_USER_DATA_UNAVAILABLE@webappMsg" >
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="noEndUserURLDataMessage"/>
                              <uix:spacer height="5"/>
                              <uix:link styleClass="OraInstructionText"
                                  textBinding="MANAGE_WEBAPP_WEBSERVER@webappMsg"
                                  destinationBinding="confWebcacheDest"/>
                            </uix:contents>
                          </uix:contentContainer/>
                        </uix:stackLayout>
                      </uix:case>

                      <uix:default> <%-- <uix:case name="error"> --%>
                        <uix:stackLayout>
                          <uix:spacer height="5"/>
                          <uix:messageBox
                            messageBinding="noEndUserURLDataMessage"
                            messageType="info"
                            shortDescBinding="noEndUserURLDataMessage"
                            textBinding="END_USER_DATA_UNAVAILABLE@webappMsg"/>
                        </uix:stackLayout>
                      </uix:default>

                    </uix:switcher>
                  </uix:contents>        
                </uix:dataScope>
							  <uix:spacer height="15" />  
                <uix:dataScope currentDataBinding="urlPerfData@servletRequest" >
                  <uix:switcher childNameBinding="showUnprocessedHits">
                    <uix:case name="true">
                      <uix:header textBinding="UNPROCESSED_SAMPLES@webappMsg">
											<uix:spacer height="5" />
											  <uix:tableLayout>
												<uix:rowLayout>
												<uix:styledText textBinding="UNPROCESSED_SAMPLES_DESC@webappMsg" styleClass="OraPromptText" />
												</uix:rowLayout>
                        <uix:rowLayout>
												<uix:spacer height="10" />
												</uix:rowLayout>
                        <uix:rowLayout width="100%">
                          <uix:form name="unprocessedHits" method="POST">
                            <uix:styledText textBinding="NUM_UNPROCESSED_SAMPLES@webappMsg" styleClass="OraPromptText"/>
                            <uix:spacer width="6"/>
                            <uix:styledText textBinding="numUnprocessedHits" styleClass="OraDataText"/>
														<uix:spacer width="20"/>
                                <uix:submitButton name="event"
                                                  textBinding="PROCESS_NOW@webappMsg"
                                                  value="processNow"/>  
                          </uix:form>
                        </uix:rowLayout>
												</uix:tableLayout>
                        <uix:switcher childNameBinding="bootstrapErrorOccured">
                          <uix:case name="true">    
														<uix:tableLayout>
                            <uix:rowLayout width="100%">
                              <uix:messageStyledText messageType="error" textBinding="bootstrapErrorMsg" styleClass="OraErrorText"/>
                            </uix:rowLayout>
														</uix:tableLayout>
                          </uix:case>
                        </uix:switcher>
                      </uix:header>     
                    </uix:case>
                  </uix:switcher>
                </uix:dataScope>  
    
                <uix:dataScope currentDataBinding="watchListUrlTable@urlPerfData@servletRequest" > 
                  <uix:header textBinding="RELATED_LINKS_HEADER@webappMsg">
                    <uix:tableLayout cellSpacing="2" width="100%">
                      <uix:contents>
                      <uix:cellFormat width="33%">
                        <uix:link textBinding="MANAGE_WEBAPP_WEBSERVER@WebappMsgBundle@servletRequest" 
																												destinationBinding="confWebcacheDest" /> 
                      </uix:cellFormat>
                      <uix:cellFormat width="33%">
                        <uix:link textBinding="EUM_ADVANCED_ANALYSIS@webappMsg" 
																												destinationBinding="advancedAnalysisDest" /> 
                      </uix:cellFormat>
                      <uix:cellFormat width="33%">
                        <uix:switcher childNameBinding="axis">
                          <uix:case name="<%= UserMntrConstants.REGION_OBJ_TYPE %>">
                            <uix:link textBinding="MANAGE_REGIONS@webappMsg" destinationBinding="editRegionsLink@servletRequest" />
                          </uix:case>
                        </uix:switcher>
                      </uix:cellFormat>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:header>
                </uix:dataScope>
						  <uix:spacer height="20" />      
          </uix:stackLayout>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</uix:buildTree>

<%@include file="/gensvc/view/gensvcViewTemplate.jspf" %>

