<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg" />

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %> 
    <%@ include file="/oemNoscript.jspf" %>
    
    
    <uix:body>
      <uix:pageLayout>

        <%@ include file="/oemGlobal.jspf" %>
        
        <uix:dataScope currentDataBinding="urlPerfDetailsData@servletRequest" >      
          <uix:contents>          
            <uix:messageBox messageType="error" 
              renderedBinding="showError@pageLevelError@servletRequest"
              messageBinding="errorText@pageLevelError@servletRequest" />
            
            <uix:header textBinding="pageHeader" >
              <uix:stackLayout>
                <uix:tableLayout>
                  <uix:rowLayout hAlign="left">
                    <uix:cellFormat>
                      <uix:rowLayout>
                        <uix:spacer width="10" />
                        <uix:cellFormat hAlign="right" >
                          <uix:styledText textBinding="REQUEST@webappMsg" styleClass="OraPromptText" />
                        </uix:cellFormat>
                        <uix:spacer width="10" />
                        <uix:cellFormat wrappingDisabled="true">
                          <uix:styledText textBinding="urlDisplayString@servletRequest" styleClass="OraDataText" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:separator/>
                  
                  <%@include file="webappTimeChoice.jspf" %> 
                  
                  <uix:rowLayout hAlign="left">
                    <uix:cellFormat vAlign="top" >
                      <uix:header textBinding="processingChartTitle" >
                        <uix:stackLayout>
                          <uix:switcher childNameBinding="urlHistoryAvailable">

                            <uix:case name="true">
                              <uix:stackLayout>
                                <uix:styledText styleClass="OraPromptText" textBinding="processingDesc" />
                                
                                <uix:dataScope currentDataBinding="correlateChartData@servletRequest" >
                                  <%-- <%@ include file="webappCorrelateChart.jspf" %>     --%>                
                                  <uix:include nodeBinding="chartNode" />
                                </uix:dataScope>
                                
                              </uix:stackLayout>
                            </uix:case>

                            <uix:case name="false">
                              <uix:messageBox messageBinding="NO_URL_HISTORY_LONG@webappMsg"
                                            messageType="info"
                                            shortDescBinding="NO_URL_HISTORY_SHORT@webappMsg" >
                            </uix:messageBox>
                          </uix:case>
                        </uix:switcher>            
                      </uix:stackLayout>
                    </uix:header>
                  </uix:cellFormat>
                </uix:rowLayout>
              
                <uix:form name="respDetails" method="GET" destinationBinding="currentFilteredUrl@servletRequest" >
                  <uix:rowLayout>
                    <uix:cellFormat vAlign="top" width="100%" > 

                      <uix:header textBinding="processingBreakdownHeader" >
                        <uix:stackLayout>
                          <uix:styledText styleClass="OraPromptText" textBinding="processingTimeDesc" />

                          <uix:tableLayout>
            
                            <uix:rowLayout hAlign="left" vAlign="top" >                
                              <uix:cellFormat vAlign="top" >
                                <uix:stackLayout>
                                 <oem:chart titleBinding="PROCESSING_TIME_BREAKDOWN@webappMsg"
                                     chartType="pieChart"
                                     titleVisible="false"
                                     width="175"
                                     height="175" 
                                     pieValuesInLegend="value"
                                     showSlicePercentLabels="true"
                                     legendVisible="false"
                                     legendPosition="east"
                                     pieSliceColorsBinding="palette"
                                     >
                                  <uix:contents>
                                    <oem:boundChartDataSource chartDataSourceBinding="urlResponsePieDataSource" />
                                    <oem:imageMap imageMapDataSourceBinding="urlResponsePieImageMap" /> 
                                    <oem:chartColumn                                   
                                        isKey="true" 
                                        displayLabel="Item"
                                        sourceIndex="0"
                                      />
                                    <oem:chartColumn                                   
                                        displayLabel="percentage"
                                        sourceIndex="1"
                                      />
                                  </uix:contents>
                                </oem:chart>
                              </uix:stackLayout>
                            </uix:cellFormat>

                            <uix:cellFormat>
                              <uix:spacer width="1" />
                            </uix:cellFormat>                

                            <uix:cellFormat vAlign="top">
                              <uix:tableLayout>                

                                <uix:rowLayout>
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                </uix:rowLayout>
       
                                <uix:rowLayout>
                                 <uix:spacer width="10"/>
                                 <uix:cellFormat hAlign="right">
                                    <uix:styledText textBinding="AVG_PROCESSING_TIME@webappMsg" styleClass="OraPromptText" />
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat wrappingDisabled="true">
                                    <uix:styledText styleClass="OraDataText" textBinding="avgTime" destinationBinding="anyDetailsLink" />
                                  </uix:cellFormat>
                                  <uix:cellFormat>
                                    <uix:spacer height="1" />
                                  </uix:cellFormat>
                                </uix:rowLayout>
                  
                                <uix:rowLayout>
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                </uix:rowLayout>
                         
                                <%
                                  oracle.sysman.eml.webapp.data.WebappURLPerfDetailsData perfData = 
                                    (oracle.sysman.eml.webapp.data.WebappURLPerfDetailsData) request.getAttribute("urlPerfDetailsData");
                                  oracle.sysman.eml.webapp.data.URLPerfItemDetail[] items = 
                                    perfData.getPerfDetails().getComponentData();
                                  for(int i=0; i<items.length; i++)
                                  {
                                %>
                                    <uix:rowLayout>
                                     <uix:image source="<%=items[i].getChip()%>" destination="<%=items[i].getDrilldown()%>" width="12" height="12" />
                                     <uix:cellFormat hAlign="right">
                                        <uix:styledText text="<%=items[i].getLabel()%>" styleClass="OraPromptText" />
                                      </uix:cellFormat>
                                      <uix:spacer width="8"/>
                                      <uix:cellFormat wrappingDisabled="true">
                                        <uix:styledText styleClass="OraDataText" text="<%=items[i].getValue()%>" destination="<%=items[i].getDrilldown()%>" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                                <%
                                  }                                                                      
                                %>
                                                                
                              </uix:tableLayout>
                            </uix:cellFormat>

                            <uix:cellFormat>
                              <uix:spacer width="2" />
                            </uix:cellFormat>                
              
                            <uix:cellFormat vAlign="top">
                              <uix:tableLayout>                

                                <uix:rowLayout>
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                </uix:rowLayout>
       
                                <uix:rowLayout>
                                 <uix:cellFormat hAlign="right">
                                    <uix:styledText textBinding="URL_HITS@webappMsg" styleClass="OraPromptText" />
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat wrappingDisabled="true">
                                    <uix:styledText styleClass="OraDataText" textBinding="hits" />
                                  </uix:cellFormat>
                                  <uix:cellFormat>
                                    <uix:spacer height="1" />
                                  </uix:cellFormat>
                                </uix:rowLayout>
                  
                                <uix:rowLayout>
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                  <uix:spacer height="20" />
                                </uix:rowLayout>
                         
                                <%
                                  oracle.sysman.eml.webapp.data.WebappURLPerfDetailsData perfData = 
                                    (oracle.sysman.eml.webapp.data.WebappURLPerfDetailsData) request.getAttribute("urlPerfDetailsData");
                                  oracle.sysman.eml.webapp.data.URLPerfItemDetail[] items = 
                                    perfData.getPerfDetails().getComponentData();
                                  for(int i=0; i<items.length; i++)
                                  {
                                %>
                                    <uix:rowLayout>
                                     <uix:cellFormat hAlign="right">
                                        <uix:styledText text="<%=items[i].getCountLabel()%>" styleClass="OraPromptText" />
                                      </uix:cellFormat>
                                      <uix:spacer width="8"/>
                                      <uix:cellFormat wrappingDisabled="true">
                                        <uix:styledText styleClass="OraDataText" text="<%=items[i].getCount()%>" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                                <%
                                  }                                                                      
                                %>
                                                                    
                              </uix:tableLayout>
                            </uix:cellFormat>

                          </uix:rowLayout>                  
                        </uix:tableLayout>

                        <uix:spacer height="1" />

                        <uix:rowLayout>
                          <uix:cellFormat width="50%">
                            <uix:tip>
                              <uix:contents>
                                <uix:styledText textBinding="CLICK_SLICE_TIP@webappMsg" />
                              </uix:contents> 
                            </uix:tip>  
                          </uix:cellFormat>

                        </uix:rowLayout>
                       
                      </uix:stackLayout>
                    </uix:header>
                  </uix:cellFormat>
  
                </uix:rowLayout>
              </uix:form>
            </uix:tableLayout>            

            <%@include file="webappURLRelatedLinks.jspf" %>

          </uix:stackLayout>
        </uix:header>        
      </uix:contents>      
    </uix:dataScope>      
  </uix:pageLayout>
</uix:body>
</uix:document>
</uix:renderingContext>

