<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page import='oracle.sysman.eml.webapp.WebappConstants'%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg" />

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %> 

    <uix:body>
      <uix:pageLayout>

        <%@ include file="/oemGlobal.jspf" %>

        <uix:dataScope currentDataBinding="urlPerfDetailsData@servletRequest" >      
          <uix:contents>
            <uix:messageBox messageType="error" 
              renderedBinding="showError@pageLevelError@servletRequest"
              messageBinding="errorText@pageLevelError@servletRequest" />

            <uix:messageBox messageType="info" 
              renderedBinding="showMaxRowsMessage"
              messageBinding="maxRowsMessage" />

            <uix:header textBinding="pageHeader" >
              <uix:stackLayout>
                  
                <uix:rowLayout>
                  <uix:spacer width="10"/>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="REQUEST@webappMsg" styleClass="OraPromptText" />
                  </uix:cellFormat>
                  <uix:spacer width="10" />
                  <uix:cellFormat wrappingDisabled="true">
                    <uix:styledText textBinding="urlDisplayString@servletRequest" styleClass="OraDataText" />
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:tableLayout>            
                   <uix:rowLayout>
                     <uix:cellFormat vAlign="top" width="66%" >

                        <uix:stackLayout>
                          <uix:tableLayout>
            
                            <uix:rowLayout hAlign="left" vAlign="top" >                                            
                              <uix:cellFormat vAlign="top">
                                <uix:stackLayout>
                                 <oem:chart titleBinding="PROCESSING_BREAKDOWN@webappMsg"
                                     chartType="barChart"
                                     titleVisible="false"
                                     width="350"
                                     height="40" 
                                     borderTop="5"
                                     legendVisible="false"
                                     stacked="true"
                                     orientation="horizontal"
                                     shadowEffect="3d"
                                     colorPaletteBinding="palette"
                                     >
                                  <uix:contents>
                                    <oem:boundChartDataSource chartDataSourceBinding="urlResponseBarDataSource" />
                                    <oem:imageMap imageMapDataSourceBinding="urlResponseBarImageMap" /> 
                                    <oem:chartColumn displayLabel=" " sourceIndex="5" isKey="true" />
                                    <oem:chartColumn displayLabelBinding="AVG_SERVLET@webappMsg" sourceIndex="0" />
                                    <oem:chartColumn displayLabelBinding="AVG_JSP@webappMsg" sourceIndex="1" />
                                    <oem:chartColumn displayLabelBinding="AVG_JDBC@webappMsg" sourceIndex="2" />
                                    <oem:chartColumn displayLabelBinding="AVG_EJB@webappMsg" sourceIndex="3" />
                                    <oem:chartColumn displayLabelBinding="AVG_OTHER_TIME@webappMsg" sourceIndex="4" />
                                  </uix:contents>
                                </oem:chart>
                              </uix:stackLayout>
                            </uix:cellFormat>

                            <uix:spacer width="1" />

                            <uix:cellFormat vAlign="top">
                              <uix:tableLayout>
                                <uix:rowLayout>
                                 <uix:cellFormat hAlign="right">
                                    <uix:styledText textBinding="URL_HITS@webappMsg" styleClass="OraPromptText" />
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat wrappingDisabled="true">
                                    <uix:styledText styleClass="OraDataText" textBinding="hits" />
                                  </uix:cellFormat>
                                </uix:rowLayout>

                                <uix:rowLayout>
                                 <uix:cellFormat hAlign="right">
                                    <uix:styledText textBinding="AVG_PROCESSING_TIME@webappMsg" styleClass="OraPromptText" />
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                  <uix:cellFormat wrappingDisabled="true">
                                    <uix:styledText styleClass="OraDataText" textBinding="avgTime" />
                                  </uix:cellFormat>
                                </uix:rowLayout>
                              </uix:tableLayout>
                            </uix:cellFormat>

                          </uix:rowLayout>                  
                        </uix:tableLayout>

                        <uix:rowLayout>
                          <uix:include nodeBinding="barChartLegend" />
                        </uix:rowLayout>
                      </uix:stackLayout>
                  </uix:cellFormat>
  
                </uix:rowLayout>

                <uix:separator/>
                
                <%@include file="webappTimeChoice.jspf" %>

                <uix:spacer height="2" />
                
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:form name="respDetails" method="post" destinationBinding="currentUrl@servletRequest" >
                      <uix:cellFormat hAlign="right" >
                        <uix:flowLayout>
                        
                          <uix:messageChoice
                              promptBinding="SHOW_PERFORMANCE_OF@webappMsg"
                              onChange="submitForm(respDetails, false, {event:'detailByPost'})" 
                              name="detailByPost"
                              selectedIndexBinding="componentChoiceSelection" >
                              <uix:contents childDataBinding="componentChoiceData" >
                                <uix:option
                                  textBinding="<%=WebappConstants.TEXT_KEY%>"
                                  valueBinding="<%=WebappConstants.VALUE_KEY%>"/>
                              </uix:contents>
                          </uix:messageChoice>
                        </uix:flowLayout>
                      </uix:cellFormat>
                    </uix:form>
                  </uix:rowLayout>
                </uix:tableLayout>
            </uix:tableLayout>

         <uix:form name="selectDataSourceForm" method="post" destinationBinding="currentUrl@servletRequest" >
          <uix:header textBinding="connectionsHeader" renderedBinding="isJdbcDetailBy" >
            <uix:stackLayout>
              <uix:tableLayout>
                <uix:rowLayout renderedBinding="haveConnectionsSummary" >
                  <uix:cellFormat vAlign="top">
                    <uix:include nodeBinding="connectionsSummarySection" />
                  </uix:cellFormat>
                        
                  <uix:cellFormat hAlign="right">
                    <uix:tableLayout width="100%" >
                    </uix:tableLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
                    
              <uix:spacer height="5" />
                      
              <uix:table id="connectionsTableId" 
                  alternateTextBinding="NO_JDBC_CONNECTIONS@webappMsg"
                  summaryBinding="URL_LIST_CONNECTIONS_TABLE_SUMMARY@webappMsg"
                  width="100%"
                  destinationBinding="currentUrl@servletRequest"
                  tableDataBinding="connectionsTableData"
                  columnFormatsBinding="connectionsColumnFormats"
                  columnHeaderDataBinding="connectionsColumnHeaderData">

                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="selected@" shortDescBinding="selected@" >
                    <uix:submitButton textBinding="SHOW_SQL_STATEMENTS@webappMsg"/>
                  </uix:multipleSelection>
                </uix:tableSelection>
                    
                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                </uix:columnHeaderStamp>

                <uix:contents>
                  <uix:link textBinding="itemDesc@" destinationBinding="itemDest@" shortDescBinding="itemDesc@" />
                  <uix:styledText textBinding="schema@"/>
                  <uix:styledText textBinding="rank@" />
                  <uix:styledText textBinding="invocations@"/>
                  <uix:styledText textBinding="exclusiveTime@"/>
                  <uix:styledText textBinding="calloutTime@"/>
                  <uix:formValue name="dataSource" valueBinding="itemName@"/>
                </uix:contents>
              </uix:table>
                
              <uix:spacer height="10" />
            </uix:stackLayout>
            </uix:header>
          </uix:form>

            <uix:header textBinding="detailsHeader" renderedBinding="haveDetails" >
             <uix:stackLayout>
              <uix:tableLayout>
                <uix:rowLayout vAlign="top">                            
                  <uix:cellFormat width="100%" vAlign="top"> 
                    <uix:stackLayout>      
                      <uix:tableLayout>
                        <uix:rowLayout renderedBinding="haveSummary" >
                          <uix:cellFormat vAlign="top">
                            <uix:include nodeBinding="summarySection" />
                          </uix:cellFormat>
                        
                          <uix:cellFormat hAlign="right">
                            <uix:tableLayout width="100%" >
                            </uix:tableLayout>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    
                      <uix:spacer height="5" />
                      
                      <uix:stackLayout>
                       <uix:switcher childNameBinding="isJdbcDetailBy">
                        
                        <uix:case name="true">
                          <uix:table id="detailsTableId" 
                              alternateTextBinding="NO_INVOCATIONS@webappMsg"
                              summaryBinding="URL_LIST_DETAILS_TABLE_SUMMARY@webappMsg"
                              width="100%"
                              destinationBinding="currentUrl@servletRequest"
                              tableDataBinding="detailsTableData"
                              columnFormatsBinding="columnFormats"
                              columnHeaderDataBinding="columnHeaderData"
                              valueBinding="detailsTableValue"
                              maxValueBinding="detailsTableMaxValue"
                              blockSizeBinding="detailsTableBlockSize" >
                              
                              <uix:tableFormat tableBanding="rowBanding"/>
  
                              <uix:columnHeaderStamp>
                                <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                              </uix:columnHeaderStamp>
                            
                              <uix:contents>
                                <uix:link textBinding="itemName@" destinationBinding="itemDest@" shortDescBinding="itemDesc@" />
                                <uix:styledText textBinding="shortItemDataSource@" /> 
                                <uix:styledText textBinding="schema@"/>
                                <uix:styledText textBinding="rank@" />
                                <uix:styledText textBinding="invocations@"/>
                                <uix:styledText textBinding="exclusiveTime@"/>
                              </uix:contents> 
                              
                              <uix:column renderedBinding="showSqlDetailsLink">
								<uix:columnHeader>
								  <uix:sortableHeader textBinding="text" sortable="no" />
								</uix:columnHeader>
								<uix:contents>
                                  <uix:image sourceBinding="detailsDesc@" destinationBinding="detailsDest@" />
								</uix:contents>
							  </uix:column>
                              
                          </uix:table>
                        </uix:case>
                        <uix:default>
                          <uix:table id="detailsTableId" 
                              alternateTextBinding="NO_INVOCATIONS@webappMsg"
                              summaryBinding="URL_LIST_DETAILS_TABLE_SUMMARY@webappMsg"
                              width="100%"
                              destinationBinding="currentUrl@servletRequest"
                              tableDataBinding="detailsTableData"
                              columnFormatsBinding="columnFormats"
                              columnHeaderDataBinding="columnHeaderData"
                              valueBinding="detailsTableValue"
                              maxValueBinding="detailsTableMaxValue"
                              blockSizeBinding="detailsTableBlockSize" >
  
                              <uix:tableFormat tableBanding="rowBanding"/>
  
                              <uix:columnHeaderStamp>
                                <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                              </uix:columnHeaderStamp>
                            
                              <uix:contents>
                                <uix:link textBinding="itemName@" destinationBinding="itemDest@" shortDescBinding="itemDesc@" />
                                <uix:styledText textBinding="itemType@"/>
                                <uix:styledText textBinding="rank@" />
                                <uix:styledText textBinding="invocations@"/>
                                <uix:styledText textBinding="exclusiveTime@"/>
                                <uix:styledText textBinding="calloutTime@"/>
                                <uix:include nodeBinding="cigar@" />                                     
                              </uix:contents>   
                              
                              <uix:column renderedBinding="showSqlDetailsLink">
								<uix:columnHeader>
                                  <uix:sortableHeader textBinding="text" sortable="no" />
								</uix:columnHeader>
								<uix:contents>
								  <uix:image sourceBinding="detailsDesc@" destinationBinding="detailsDest@" />
								</uix:contents>
							  </uix:column>
                              
                          </uix:table>                       
                        </uix:default>
                       </uix:switcher>
                      
                       <uix:spacer height="5" />

                       <uix:rowLayout hAlign="right" renderedBinding="showCalloutDetails" >
                         <uix:include nodeBinding="detailsTableLegend" />
                       </uix:rowLayout>
                      </uix:stackLayout>
                      
                    </uix:stackLayout>
                  </uix:cellFormat>
                
                  <uix:cellFormat>
                      <uix:spacer width="1" />
                  </uix:cellFormat>                

                </uix:rowLayout>
              </uix:tableLayout>
             </uix:stackLayout>
            </uix:header>

            <%@include file="webappURLRelatedLinks.jspf" %>

          </uix:stackLayout>
        </uix:header>        
      </uix:contents>      
    </uix:dataScope>      
  </uix:pageLayout>
</uix:body>
</uix:document>
</uix:renderingContext>

