<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page import='oracle.sysman.eml.webapp.WebappConstants'%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg" />

    <uix:document>
      <%@ include file="/enablePPR.jspf" %>
      <%@ include file="/oemTitle.jspf" %>
      <%@ include file="/oemNoscript.jspf" %> 
      
      <uix:body>
        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:dataScope currentDataBinding="urlComponentPerfData@servletRequest" >
      
            <uix:contents>
              
              <uix:messageBox messageType="error" 
                renderedBinding="showError@pageLevelError@servletRequest"
                messageBinding="errorText@pageLevelError@servletRequest" />
            
              <uix:header textBinding="pageHeader" >
                <uix:stackLayout>
                
                    <uix:rowLayout width="100%">
		      <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0">
                        <uix:styledText textBinding="REQUEST@webappMsg" styleClass="OraPromptText" />
                        <uix:styledText textBinding="urlDisplayString@servletRequest" styleClass="OraDataText" />
                        <uix:styledText textBinding="DATA_SOURCE@webappMsg" styleClass="OraPromptText" />
                        <uix:styledText styleClass="OraDataText" 
                                        shortDescBinding="connectString@urlComponent@servletRequest" 
                                        destinationBinding="databaseHome@urlComponent@servletRequest" 
                                        textBinding="connectString@urlComponent@servletRequest" />
                        <uix:styledText textBinding="SCHEMA@webappMsg" styleClass="OraPromptText" />
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="schema@urlComponent@servletRequest" />
		      </uix:labeledFieldLayout>
                    </uix:rowLayout>

                    <%--
                    <uix:rowLayout>
                     <uix:spacer width="10"/>
                     <uix:cellFormat hAlign="right">
                        <uix:styledText textBinding="INVOCATION_CONTEXT@webappMsg" styleClass="OraPromptText" />
                      </uix:cellFormat>
                      <uix:spacer width="8"/>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:styledText styleClass="OraDataText" textBinding="invocationContext" />
                      </uix:cellFormat>
                    </uix:rowLayout>
                    --%>
                    
                    <uix:rowLayout width="100%">                    
                     <uix:hideShowHeader textBinding="FULL_SQL_TEXT@webappMsg" 
                                    formSubmitted="true"
                                    formName="componentDetailForm"
                                    id='sqlHideId'
                                    disclosedBinding="hideShow@urlComponentPerfData@servletRequest" >
                     <uix:stackLayout>

                      <uix:textInput 
                        columnsBinding="fullDisplayColumns@urlComponent@servletRequest" 
                        rows="5" 
                        readOnly="true" 
                        textBinding="formattedSqlText@urlComponent@servletRequest" />

                    <%-- no SQL drilldown into DB for 4.1
                    <oem:license>
                    <uix:link textBinding="SQL_STATEMENT_ANALYSIS@webappMsg" destinationBinding="sqlAnalysisLink" renderedBinding="showAnalaysis" />
                  </oem:license>
                  <oem:license>
                    <uix:link textBinding="SQL_STATEMENT_ANALYSIS@webappMsg" destinationBinding="sqlAnalysisLink" />
                  </oem:license>
                    --%>

                      </uix:stackLayout>
                    </uix:hideShowHeader>  
                    </uix:rowLayout>                    

              <uix:tableLayout>
               <%@include file="webappTimeChoice.jspf" %>

               <uix:form name="componentDetailForm" method="post" destinationBinding="currentFilteredUrl@servletRequest" >         


                   <uix:rowLayout>                    
                   <uix:spacer width="15"/>
                   <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="CALL_RANK@webappMsg" styleClass="OraPromptText" />
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" textBinding="rankString" />
                      </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                   <uix:spacer width="1"/>
                   <uix:cellFormat hAlign="right">
              <uix:header textBinding="INVOCATION_PATHS@webappMsg"> <%-- renderedBinding="showComponent" --%>
                <uix:stackLayout>
                  <uix:switcher childNameBinding="tableSelected"> 
                     <uix:case name="<%=WebappConstants.SINGLE_INVOC_CALLOUT%>" > 
                        <uix:table id="invocationTableId" 
                            alternateTextBinding="NO_INVOCATIONS@webappMsg"
                            summaryBinding="SQL_PERF_INVOC_TABLE_SUMMARY@webappMsg"
                            width="100%"
                            formSubmitted="true"   
                            tableDataBinding="invocationTableData"
                            columnFormatsBinding="columnFormats"
                            columnHeaderDataBinding="columnHeaderData">
      
                          <uix:tableFormat tableBanding="rowBanding"/>
      
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                          </uix:columnHeaderStamp>
      
                          <uix:contents>
                            <uix:link textBinding="invocation@" destinationBinding="invocationDest@" shortDescBinding="invocationDesc@" />
                            <uix:styledText textBinding="hits@"/>
                              <%--
                            <uix:styledText textBinding="totalTime@"/>
                              --%>
                            <uix:styledText textBinding="exclusiveTime@"/>
                            <uix:styledText textBinding="calloutTime@"/>
                            <uix:include nodeBinding="cigar@" />      
                          </uix:contents>
                        </uix:table>
                    </uix:case> 
                    <uix:case name="<%=WebappConstants.SINGLE_INVOC_NO_CALLOUT%>" > 
                        <uix:table id="invocationTableId" 
                            alternateTextBinding="NO_INVOCATIONS@webappMsg"
                            summaryBinding ="SQL_PERF_INVOC_TABLE_SUMMARY@webappMsg"
                            width="100%"
                            formSubmitted="true"
                            tableDataBinding="invocationTableData"
                            columnFormatsBinding="columnFormats"
                            columnHeaderDataBinding="columnHeaderData">
      
                          <uix:tableFormat tableBanding="rowBanding"/>
      
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                          </uix:columnHeaderStamp>
      
                          <uix:contents>
                            <uix:link textBinding="invocation@" destinationBinding="invocationDest@" shortDescBinding="invocationDesc@" />
                            <uix:styledText textBinding="hits@"/>
                              <%--
                            <uix:styledText textBinding="totalTime@"/>
                              --%>
                            <uix:styledText textBinding="exclusiveTime@"/>
                            <uix:include nodeBinding="cigar@" />      
                          </uix:contents>
                        </uix:table>
                    </uix:case>                  
                    <uix:case name="<%=WebappConstants.MULTI_INVOC_CALLOUT%>" >
                        <uix:table id="invocationTableId" 
                            alternateTextBinding="NO_INVOCATIONS@webappMsg"
                            summaryBinding="SQL_PERF_INVOC_TABLE_SUMMARY@webappMsg"
                            width="100%"
                            formSubmitted="true"   
                            tableDataBinding="invocationTableData"
                            columnFormatsBinding="columnFormats"
                            columnHeaderDataBinding="columnHeaderData">
      
                          <uix:tableFormat tableBanding="rowBanding"/>
      
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                          </uix:columnHeaderStamp>
      
                          <uix:contents>                            
                            <uix:styledText textBinding="pageno@"/>
                            <uix:link textBinding="invocation@" destinationBinding="invocationDest@" shortDescBinding="invocationDesc@" />
                            <uix:styledText textBinding="hits@"/>
                              <%--
                            <uix:styledText textBinding="totalTime@"/>
                              --%>
                            <uix:styledText textBinding="exclusiveTime@"/>
                            <uix:include nodeBinding="cigar@" />      
                          </uix:contents>
                        </uix:table>
                    </uix:case> 
                    <uix:case name="<%=WebappConstants.MULTI_INVOC_NO_CALLOUT%>" > 
                        <uix:table id="invocationTableId" 
                            alternateTextBinding="NO_INVOCATIONS@webappMsg"
                            summaryBinding ="SQL_PERF_INVOC_TABLE_SUMMARY@webappMsg"
                            width="100%"
                            formSubmitted="true"
                            tableDataBinding="invocationTableData"
                            columnFormatsBinding="columnFormats"
                            columnHeaderDataBinding="columnHeaderData">
      
                          <uix:tableFormat tableBanding="rowBanding"/>
      
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                          </uix:columnHeaderStamp>
      
                          <uix:contents>
                            <uix:styledText textBinding="pageno@"/>
                            <uix:link textBinding="invocation@" destinationBinding="invocationDest@" shortDescBinding="invocationDesc@" />
                            <uix:styledText textBinding="hits@"/>
                              <%--
                            <uix:styledText textBinding="totalTime@"/>
                              --%>
                            <uix:styledText textBinding="exclusiveTime@"/>
                            <uix:include nodeBinding="cigar@" />      
                          </uix:contents>
                        </uix:table>
                    </uix:case> 
                  </uix:switcher>

                  <uix:spacer height="5" />

                  <uix:rowLayout hAlign="right" >
                    <uix:include nodeBinding="invocationTableLegend" />
                  </uix:rowLayout>

                </uix:stackLayout>
              </uix:header>
                   </uix:cellFormat >
                  </uix:rowLayout>
              <uix:header textBinding="INVOCATION_PATHS_DTLS@webappMsg"> 
                  <uix:rowLayout>
                    <uix:spacer width="20"/>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messageChoice
                          promptBinding="INVOCATION_CONTEXT@webappMsg"
                          onChange="submitForm(componentDetailForm, false, {event:'invKeyPost'})"
                          name="invKeyPost"
                          selectedIndexBinding="invocationChoiceIndex" 
                          renderedBinding="multiInvocation" >
                        <uix:contents childDataBinding="invocationChoiceData" >
                          <uix:option
                              textBinding="<%=WebappConstants.TEXT_KEY%>"
                              valueBinding="<%=WebappConstants.VALUE_KEY%>"/>
                        </uix:contents>
                      </uix:messageChoice>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer width="20"/>
                    <uix:cellFormat wrappingDisabled="true">
                       <uix:flowLayout>
                         <%--uix:styledText styleClass="OraDataText" textBinding="invocationContext" renderedBinding="singleInvocation" /--%>
                      </uix:flowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>                    
              </uix:header>
              </uix:form>
              </uix:tableLayout>
                  <uix:separator/>

                  <uix:tableLayout>
                    <uix:rowLayout>     

                      <uix:cellFormat vAlign="top">       
                        <uix:header textBinding="processingBreakdownHeader" >
                          <uix:stackLayout>
                            <uix:styledText styleClass="OraPromptText" textBinding="processingDesc" />
                            <uix:dataScope currentDataBinding="correlateChartData@servletRequest" >
                              <%-- <%@ include file="webappCorrelateChart.jspf" %>     --%>                
                              <uix:include nodeBinding="sqlChartNode" />
                            </uix:dataScope>
                          </uix:stackLayout>
                        </uix:header>
                      </uix:cellFormat>

                    </uix:rowLayout>
                  </uix:tableLayout>
                            
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" >

                      <uix:header textBinding="processingChartTitle" >
                        <uix:stackLayout>
                          <uix:styledText styleClass="OraPromptText" textBinding="processingTimeDesc" />
                          
                            <uix:tableLayout>            
                              <uix:rowLayout hAlign="left" vAlign="top" >

                                <uix:cellFormat width="20%">
                                  <uix:stackLayout>
                                   <oem:chart titleBinding="processingChartTitle"
                                       chartType="pieChart"
                                       titleVisible="false"
                                       width="160"
                                       height="160" 
                                       pieValuesInLegend="value"
                                       showSlicePercentLabels="true"
                                       legendVisible="false"
                                       legendPosition="east"
                                       pieSliceColorsBinding="sqlPieColors"
                                       >
                                    <uix:contents>
                                      <oem:boundChartDataSource chartDataSourceBinding="urlResponsePieDataSource" />
                                      <oem:imageMap imageMapDataSourceBinding="urlResponsePieImageMap" /> 
                                      <oem:chartColumn                                   
                                          isKey="true" 
                                          displayLabel="Item"
                                          sourceIndex="0"
                                        />
                                      <oem:chartColumn                                   
                                          displayLabel="percentage"
                                          sourceIndex="1"
                                        />
                                    </uix:contents>
                                  </oem:chart>
                                 </uix:stackLayout>
                                </uix:cellFormat>

                                <uix:cellFormat width="30%" >
                                  <uix:tableLayout>                

                                    <uix:rowLayout>
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                    </uix:rowLayout>
       
                                    <uix:rowLayout>
                                      <uix:spacer width="10"/>
                                      <uix:cellFormat hAlign="right">
                                        <uix:styledText textBinding="hitsLabel" styleClass="OraPromptText" />
                                      </uix:cellFormat>
                                      <uix:spacer width="8"/>
                                      <uix:cellFormat wrappingDisabled="true">
                                        <uix:styledText styleClass="OraDataText" textBinding="invocationsPerRequest" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                      <uix:spacer width="10"/>
                                      <uix:cellFormat hAlign="right">
                                        <uix:styledText textBinding="totalTimeLabel" styleClass="OraPromptText" />
                                      </uix:cellFormat>
                                      <uix:spacer width="8"/>
                                      <uix:cellFormat wrappingDisabled="true">
                                        <uix:styledText styleClass="OraDataText" textBinding="totalTimePerRequest" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                    </uix:rowLayout>
                         
                                    <uix:rowLayout>
                                     <uix:image sourceBinding="execChip" destinationBinding="execDetailsLink" width="12" height="12" />
                                     <uix:cellFormat hAlign="right">
                                        <uix:styledText textBinding="execTimeLabel" styleClass="OraPromptText" />
                                      </uix:cellFormat>
                                      <uix:spacer width="8"/>
                                      <uix:cellFormat wrappingDisabled="true">
                                        <uix:styledText styleClass="OraDataText" textBinding="execTime" destinationBinding="execDetailsLink" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                     <uix:image sourceBinding="fetchChip" destinationBinding="fetchDetailsLink" width="12" height="12" />
                                     <uix:cellFormat hAlign="right">
                                        <uix:styledText textBinding="fetchTimeLabel" styleClass="OraPromptText" />
                                      </uix:cellFormat>
                                      <uix:spacer width="8"/>
                                      <uix:cellFormat wrappingDisabled="true">
                                        <uix:styledText styleClass="OraDataText" textBinding="fetchTime" destinationBinding="fetchDetailsLink" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                                    
                                    <uix:rowLayout>
                                     <uix:image sourceBinding="otherChip" destinationBinding="otherDetailsLink" width="12" height="12" />
                                     <uix:cellFormat hAlign="right">
                                        <uix:styledText textBinding="otherTimeLabel" styleClass="OraPromptText" />
                                      </uix:cellFormat>
                                      <uix:spacer width="8"/>
                                      <uix:cellFormat wrappingDisabled="true">
                                        <uix:styledText styleClass="OraDataText" textBinding="otherTime" destinationBinding="otherDetailsLink" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                      <uix:spacer height="15" />
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                     <uix:spacer width="10"/>
                                     <uix:cellFormat hAlign="right">
                                        <uix:styledText textBinding="EXEC_PER_REQUEST@webappMsg" styleClass="OraPromptText" />
                                      </uix:cellFormat>
                                      <uix:spacer width="8"/>
                                      <uix:cellFormat wrappingDisabled="true">
                                        <uix:styledText styleClass="OraDataText" textBinding="execCount" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                     <uix:spacer width="10"/>
                                     <uix:cellFormat hAlign="right">
                                        <uix:styledText textBinding="FETCH_PER_REQUEST@webappMsg" styleClass="OraPromptText" />
                                      </uix:cellFormat>
                                      <uix:spacer width="8"/>
                                      <uix:cellFormat wrappingDisabled="true">
                                        <uix:styledText styleClass="OraDataText" textBinding="fetchCount" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                      <uix:cellFormat>
                                        <uix:spacer height="1" />
                                      </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      <uix:spacer width="8"/>
                                      <uix:cellFormat wrappingDisabled="true">
                                        <oem:license>
                                          <uix:link textBinding="SQL_STATEMENT_ANALYSIS@webappMsg" 
                                            destinationBinding="sqlAnalysisLink" 
                                            renderedBinding="showAnalaysis" />
                                        </oem:license>
                                      </uix:cellFormat>
                                    </uix:rowLayout>

                                  </uix:tableLayout>
                                </uix:cellFormat>

                                <uix:cellFormat hAlign="left" vAlign="top" width="70%" >
                                  <uix:stackLayout>
                                    <uix:spacer height="1" />
                                    <uix:contentContainer width="100%" textBinding="ADVICE@webappMsg" renderedBinding="haveAdvice" >
                                      <uix:contents>
                                        <uix:stackLayout>
                                          <uix:contents childDataBinding="detailsAdvice" >
                                            <uix:styledText styleClass="OraInstructionText" textBinding="detailsAdviceItem" />
                                            <uix:spacer height="5"/>
                                          </uix:contents>
                                        </uix:stackLayout>
                                        <uix:link textBinding="detailsAdviceLinkText" destinationBinding="detailsAdviceLinkDestination" />
                                      </uix:contents>
                                    </uix:contentContainer>
                                  </uix:stackLayout>             
                                </uix:cellFormat>
                            </uix:rowLayout>
                          </uix:tableLayout>

                        </uix:stackLayout>
                      </uix:header>

                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

                    <%-- no SQL drilldown into DB for 4.1
                <uix:header textBinding="FULL_SQL_TEXT@webappMsg" >
                  <uix:stackLayout>

                    <uix:spacer height="10" />

                    <uix:textInput 
                        columnsBinding="fullDisplayColumns@urlComponent@servletRequest" 
                        rows="5" 
                        readOnly="true" 
                        textBinding="formattedSqlText@urlComponent@servletRequest" />

                    <uix:spacer height="10" />

                    <uix:link textBinding="SQL_STATEMENT_ANALYSIS@webappMsg" destinationBinding="sqlAnalysisLink" />

                  </uix:stackLayout>
                </uix:header>  
                    --%>

              
          <%-- no invocations from SQL (unless we add PL/SQL procedure to SQL tracking        
              <uix:header textBinding="CALLS_MADE@webappMsg" renderedBinding="showInvocation" >
                <uix:stackLayout>
                  <uix:table id="callsTableId" 
                      alternateTextBinding="NO_CALLS_MADE@webappMsg" 
                      summaryBinding ="SQL_PERF_CALLS_TABLE_SUMMARY@webappMsg"
                      width="100%"
                      tableDataBinding="callsTableData"
                      columnFormatsBinding="callsColumnFormats"
                      columnHeaderDataBinding="callsColumnHeaderData">

                    <uix:tableFormat tableBanding="rowBanding"/>

                    <uix:columnHeaderStamp>
                      <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                    </uix:columnHeaderStamp>

                    <uix:contents>
                      <uix:link textBinding="itemName@" destinationBinding="itemDest@" shortDescBinding="itemDesc@" />
                      <uix:styledText textBinding="itemType@"/>
                      <uix:styledText textBinding="rank@" />
                      <uix:styledText textBinding="invocations@"/>
                      <uix:styledText textBinding="exclusiveTime@"/>
                      <uix:styledText textBinding="calloutTime@"/>
                      <uix:include nodeBinding="cigar@" />      
                    </uix:contents>
                  </uix:table>
            
                  <uix:spacer height="5" />

                  <uix:rowLayout hAlign="right" >
                    <uix:include nodeBinding="callsTableLegend" />
                  </uix:rowLayout>

                </uix:stackLayout>
              </uix:header>
        --%>
              <%@include file="webappURLRelatedLinks.jspf" %>

              </uix:stackLayout>
            </uix:header>        
          </uix:contents>      

        </uix:dataScope>      
      </uix:pageLayout>   
    </uix:body>
  </uix:document>
</uix:renderingContext>

