Rem  Copyright (c) Oracle Corporation 2006 - 2008. All Rights Reserved.
Rem
Rem    NAME
Rem      apex_install_data.sql
Rem
Rem    DESCRIPTION
Rem      Insert data into tables during APEX installation
Rem
Rem    MODIFIED     (MM/DD/YYYY)
Rem      jkallman    01/23/2007 - Created (moved insert statements from tab.sql)
Rem      mhichwa     01/29/2007 - 32 by 32 images were flagged as 64 in wwv_flow_standard_icons inserts
Rem      mhichwa     01/29/2007 - Added delete of rows in wwv_flow_standard_icons so this script can be re-run any number of times, also consistent with other loads
Rem      mhichwa     01/31/2007 - Added Additional Images 64 and 32
Rem      jkallman    02/02/2007 - Corrected file extensions for icons
Rem      jkallman    02/06/2007 - Added delete from wwv_flow_charsets
Rem      jkallman    02/09/2007 - Added values to wwv_flow_translatable_cols$ for region print (142 - 144)
Rem      jkallman    02/15/2007 - Remove STEP_SUB_TITLE from wwv_flow_translatable_cols$ (Bug 5885151)
Rem      sbkenned    02/15/2007 - Fixed creation of wwv_flow_standard_icons, change_storage was incorrect (bug 5886020)
Rem      mhichwa     03/02/2007 - Added delete from wwv_flow_standard_css to ensure we do not get duplicate rows bug 5886061
Rem      mhichwa     03/02/2007 - Added delete from wwv_flow_standard_js for consistency.  First delete, then insert. bug 5886061
Rem      jkallman    11/26/2007 - Added worksheet columns to wwv_flow_translatable_cols$
Rem      mhichwa     11/27/2007 - Added additional images developed by msewtz
Rem      mhichwa     12/05/2007 - Added 20x20 images for use with image reporting
Rem      mhichwa     12/06/2007 - Added alarm_bell_wbg_64x64.png
Rem      mhichwa     12/17/2007 - Added standard 140x90 icons
Rem      jkallman    12/18/2007 - Added wwv_flow_worksheets.search_button_label to wwv_flow_translatable_cols$
Rem      mhichwa     12/19/2007 - Added compass_64.gif
Rem      mhichwa     02/01/2008 - Added temperature_bx_128x128.png census_bx_128x128.png
Rem      msewtz      02/02/2008 - Added 9 additional 128x128 images
Rem      msewtz      02/04/2008 - Added 3 additional 128x128 images
Rem      mhichwa     02/20/2008 - Addeded missing users_bx_128x128.png image
Rem      mhichwa     02/20/2008 - Exposed additional artwork
Rem      mhichwa     02/22/2008 - Added 16x16 images in support of theme20 and general use
Rem      jkallman    09/04/2008 - Added translatable columns 156 through 172
Rem      jkallman    09/04/2008 - Added Western European ISO-8859-15 to list of character sets (Bug 7345137)
Rem      jkallman    09/30/2008 - Added UTF-16 LE and BE character sets to wwv_flow_charsets
Rem      jkallman    10/29/2008 - Added translable columns 173 through 223
Rem      jkallman    11/11/2008 - Added translatable columns 224 through 233



set define '^'
prompt ...Application Express installation data



prompt
prompt ...insert into alt_config_pick
prompt

delete from  wwv_flow_alt_config_pick;
insert into  wwv_flow_alt_config_pick values (1,'WWV_FLOWS.HOME_LINK','Flow: Flow Home Link (text)');
insert into  wwv_flow_alt_config_pick values (2,'WWV_FLOWS.PUBLIC_URL_PREFIX','Flow: Public URL Prefix (text)');
insert into  wwv_flow_alt_config_pick values (3,'WWV_FLOWS.DBAUTH_URL_PREFIX','Flow: Authenticated URL Prefix (text)');
insert into  wwv_flow_alt_config_pick values (4,'WWV_FLOWS.AUTHENTICATION','Flow: Authentication DATABASE/COOKIE/...');
insert into  wwv_flow_alt_config_pick values (5,'WWV_FLOWS.PROXY_SERVER','Flow: Proxy Server (text)');
insert into  wwv_flow_alt_config_pick values (6,'WWV_FLOWS.LOGIN_URL','Flow: Login URL (text)');
insert into  wwv_flow_alt_config_pick values (7,'WWV_FLOWS.LOGOUT_URL','Flow: Logout URL (text)');
insert into  wwv_flow_alt_config_pick values (8,'WWV_FLOWS.DEFAULT_PAGE_TEMPLATE','Flow: Default Page Template ID (number)');
insert into  wwv_flow_alt_config_pick values (9,'WWV_FLOW_PATCHES.PATCH_STATUS','BuildOpt: Build Option INCLUDE/EXCLUDE');
insert into  wwv_flow_alt_config_pick values (10,'WWV_FLOWS.FLOW_STATUS','Flow: Flows Status AVAILABLE/UNAVAILABE/...');
insert into  wwv_flow_alt_config_pick values (11,'WWV_FLOWS.SUBSTITUTION_STRING_01','Flow: substitution string 01');
insert into  wwv_flow_alt_config_pick values (12,'WWV_FLOWS.SUBSTITUTION_VALUE_01', 'Flow: substitution value 01');
insert into  wwv_flow_alt_config_pick values (13,'WWV_FLOWS.SUBSTITUTION_STRING_02','Flow: substitution string 02');
insert into  wwv_flow_alt_config_pick values (14,'WWV_FLOWS.SUBSTITUTION_VALUE_02', 'Flow: substitution value 02');
insert into  wwv_flow_alt_config_pick values (15,'WWV_FLOWS.SUBSTITUTION_STRING_03','Flow: substitution string 03');
insert into  wwv_flow_alt_config_pick values (16,'WWV_FLOWS.SUBSTITUTION_VALUE_03', 'Flow: substitution value 03');
insert into  wwv_flow_alt_config_pick values (17,'WWV_FLOWS.SUBSTITUTION_STRING_04','Flow: substitution string 04');
insert into  wwv_flow_alt_config_pick values (18,'WWV_FLOWS.SUBSTITUTION_VALUE_04', 'Flow: substitution value 04');
insert into  wwv_flow_alt_config_pick values (19,'WWV_FLOWS.SUBSTITUTION_STRING_05','Flow: substitution string 05');
insert into  wwv_flow_alt_config_pick values (20,'WWV_FLOWS.SUBSTITUTION_VALUE_05', 'Flow: substitution value 05');
insert into  wwv_flow_alt_config_pick values (21,'WWV_FLOWS.SUBSTITUTION_STRING_06','Flow: substitution string 06');
insert into  wwv_flow_alt_config_pick values (22,'WWV_FLOWS.SUBSTITUTION_VALUE_06', 'Flow: substitution value 06');
insert into  wwv_flow_alt_config_pick values (23,'WWV_FLOWS.SUBSTITUTION_STRING_07','Flow: substitution string 07');
insert into  wwv_flow_alt_config_pick values (24,'WWV_FLOWS.SUBSTITUTION_VALUE_07', 'Flow: substitution value 07');
insert into  wwv_flow_alt_config_pick values (25,'WWV_FLOWS.SUBSTITUTION_STRING_08','Flow: substitution string 08');
insert into  wwv_flow_alt_config_pick values (26,'WWV_FLOWS.SUBSTITUTION_VALUE_08', 'Flow: substitution value 08');
insert into  wwv_flow_alt_config_pick values (27,'WWV_FLOWS.PUBLIC_USER', 'Flow: Application Public User (Oracle Schema)');
insert into  wwv_flow_alt_config_pick values (28,'WWV_FLOWS.WEBDB_LOGGING', 'Flow: Logging YES/NO');
insert into  wwv_flow_alt_config_pick values (29,'WWV_FLOWS.OWNER', 'Flow: Application Owner (Oracle Schema)');
insert into  wwv_flow_alt_config_pick values (31,'WWV_FLOWS.SECURITY_SCHEME', 'Flow: Security Scheme ID (number)');
insert into  wwv_flow_alt_config_pick values (32,'WWV_FLOWS.APPLICATION_TAB_SET', 'Flow: Application TabSet ID (number)');
insert into  wwv_flow_alt_config_pick values (33,'WWV_FLOWS.ROW_TEMPLATE1','Flow: Row Template 1');
insert into  wwv_flow_alt_config_pick values (34,'WWV_FLOWS.ROW_TEMPLATE2','Flow: Row Template 2');
insert into  wwv_flow_alt_config_pick values (35,'WWV_FLOWS.ROW_TEMPLATE3','Flow: Row Template 3');
insert into  wwv_flow_alt_config_pick values (36,'WWV_FLOWS.ROW_TEMPLATE4','Flow: Row Template 4');
insert into  wwv_flow_alt_config_pick values (37,'WWV_FLOWS.ROW_TEMPLATE_BEFORE_ROWS','Flow: Row Template before rows');
insert into  wwv_flow_alt_config_pick values (38,'WWV_FLOWS.ROW_TEMPLATE_AFTER_ROWS','Flow: Row Template after rows');

commit;


prompt
prompt ...insert into wwv_flow_translatable_cols$
prompt

delete from wwv_flow_translatable_cols$;

insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (2,'WWV_FLOW_ICON_BAR','ICON_IMAGE_ALT','ID','FLOW_ID','','VARCHAR2','N','Navigation Bar Icon Text.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (2.1,'WWV_FLOW_ICON_BAR','ICON_SUBTEXT','ID','FLOW_ID','','VARCHAR2','N','Icon SubText Look1.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (2.2,'WWV_FLOW_ICON_BAR','ICON_SUBTEXT2','ID','FLOW_ID','','VARCHAR2','N','Icon SubText Look2.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (2.3,'WWV_FLOW_ICON_BAR','ICON_SUBTEXT3','ID','FLOW_ID','','VARCHAR2','N','Icon SubText Look3.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (1.1,'WWV_FLOW_TOPLEVEL_TABS','TAB_TEXT','ID','FLOW_ID','','VARCHAR2','N','Top Level Tab Name.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (3,'WWV_FLOW_PROCESSING','PROCESS_ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Flow Process Error Message.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (4,'WWV_FLOW_TABS','TAB_TEXT','ID','FLOW_ID','','VARCHAR2','N','Tab Text.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (5,'WWV_FLOW_STEPS','NAME','ID','FLOW_ID','ID','VARCHAR2','N','Page Name.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (6,'WWV_FLOW_STEPS','STEP_TITLE','ID','FLOW_ID','ID','VARCHAR2','N','Page Title.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (8,'WWV_FLOW_STEPS','WELCOME_TEXT','ID','FLOW_ID','ID','VARCHAR2','N','Page Header Text.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (9,'WWV_FLOW_STEPS','BOX_WELCOME_TEXT','ID','FLOW_ID','ID','VARCHAR2','N','Page Body Header Text.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (10,'WWV_FLOW_STEPS','BOX_FOOTER_TEXT','ID','FLOW_ID','ID','VARCHAR2','N','Page Body Footer Text.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (11,'WWV_FLOW_STEPS','FOOTER_TEXT','ID','FLOW_ID','ID','VARCHAR2','N','Page Footer Text.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (12,'WWV_FLOW_STEPS','HELP_TEXT','ID','FLOW_ID','ID','CLOB','N','Page Help Text.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (13,'WWV_FLOW_STEP_BUTTONS','BUTTON_IMAGE_ALT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Button Text.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (14,'WWV_FLOW_STEP_ITEMS','PROMPT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Item Prompt.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (16,'WWV_FLOW_STEP_VALIDATIONS','ERROR_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Validation ErrMsg.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (17,'WWV_FLOW_STEP_PROCESSING','PROCESS_ERROR_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2',
    'N','Page Process ErrMsg.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (18,'WWV_FLOW_STEP_PROCESSING','PROCESS_SUCCESS_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2',
    'N','Page Process Success Message.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (19,'WWV_FLOW_PAGE_PLUG_TEMPLATES','TEMPLATE','ID','FLOW_ID','','CLOB',
    'Y','Region template, typically does not include translatable text.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (20,'WWV_FLOW_PAGE_PLUGS','PLUG_NAME','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'Y','Region name');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (21,'WWV_FLOW_PAGE_PLUGS','PLUG_SOURCE','ID','FLOW_ID','PAGE_ID','CLOB',
    'N','Region source');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (23,'WWV_FLOW_TEMPLATES','HEADER_TEMPLATE','ID','FLOW_ID','','CLOB',
    'Y','Page Header Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (24,'WWV_FLOW_TEMPLATES','FOOTER_TEMPLATE','ID','FLOW_ID','','CLOB',
    'Y','Page Footer Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (25,'WWV_FLOW_TEMPLATES','BOX','ID','FLOW_ID','','CLOB',
    'Y','Page Body Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (26,'WWV_FLOW_PAGE_PLUGS','PLUG_HEADER','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Region header');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (27,'WWV_FLOW_PAGE_PLUGS','PLUG_FOOTER','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Region footer');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (28,'WWV_FLOW_LIST_ITEMS','LIST_ITEM_LINK_TEXT','ID','FLOW_ID','','VARCHAR2',
    'N','List Item Display Text');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (29,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE1','ID','FLOW_ID','','CLOB',
    'Y','Row Template 1');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (30,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE2','ID','FLOW_ID','','CLOB',
    'Y','Row Template 2');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (31,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE3','ID','FLOW_ID','','CLOB',
    'Y','Row Template 3');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (32,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE4','ID','FLOW_ID','','CLOB',
    'Y','Row Template 4');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (34,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_BEFORE_ROWS','ID','FLOW_ID','','VARCHAR2',
    'Y','Report Template Before Rows');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (35,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_AFTER_ROWS','ID','FLOW_ID','','VARCHAR2',
    'Y','Report Template After Rows');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (36,'WWV_FLOW_PAGE_PLUGS','PLUG_QUERY_NO_DATA_FOUND','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','No Data Found Message For Regions');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (37,'WWV_FLOW_FIELD_TEMPLATES','TEMPLATE_BODY1','ID','FLOW_ID','','VARCHAR2',
    'Y','Before Label, typically does not include translatable text');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (38,'WWV_FLOW_FIELD_TEMPLATES','TEMPLATE_BODY2','ID','FLOW_ID','','VARCHAR2',
    'Y','After Label, typically does not include translatable text');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (39,'WWV_FLOW_FIELD_TEMPLATES','ON_ERROR_BEFORE_LABEL','ID','FLOW_ID','','VARCHAR2',
    'Y','On Error Before Label, typically does not include translatable text');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (40,'WWV_FLOW_FIELD_TEMPLATES','ON_ERROR_AFTER_LABEL','ID','FLOW_ID','','VARCHAR2',
    'Y','On Error After Label, typically does not include translatable text');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (41,'WWV_FLOW_PAGE_PLUGS','CSV_OUTPUT_LINK_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Link text the user will see when the report region is displayed in CSV format');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (42,'WWV_FLOW_PAGE_PLUGS','REPORT_TOTAL_TEXT_FORMAT','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Text to display when printing report sums');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (43,'WWV_FLOW_PAGE_PLUGS','BREAK_COLUMN_TEXT_FORMAT','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Heading template for repeating headings');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (44,'WWV_FLOW_ROW_TEMPLATES','COLUMN_HEADING_TEMPLATE','ID','FLOW_ID','','VARCHAR2',
    'Y','Column Heading Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (45,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_BEFORE_FIRST','ID','FLOW_ID','','VARCHAR2',
    'Y','Report Template Before First Row');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (46,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_AFTER_LAST','ID','FLOW_ID','','VARCHAR2',
    'Y','Report Template After Last Row');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (47,'WWV_FLOW_ROW_TEMPLATES','PAGINATION_TEMPLATE','ID','FLOW_ID','','VARCHAR2',
    'Y','Pagination Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (48,'WWV_FLOW_ROW_TEMPLATES','NEXT_PAGE_TEMPLATE','ID','FLOW_ID','','VARCHAR2',
    'Y','Next Page Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (49,'WWV_FLOW_ROW_TEMPLATES','PREVIOUS_PAGE_TEMPLATE','ID','FLOW_ID','','VARCHAR2',
    'Y','Previous Page Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (50,'WWV_FLOW_ROW_TEMPLATES','NEXT_SET_TEMPLATE','ID','FLOW_ID','','VARCHAR2',
    'Y','Next Set Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (51,'WWV_FLOW_ROW_TEMPLATES','PREVIOUS_SET_TEMPLATE','ID','FLOW_ID','','VARCHAR2',
    'Y','Previous Set Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (52,'WWV_FLOW_BUTTON_TEMPLATES','TEMPLATE','ID','FLOW_ID','','CLOB','Y','Button Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (53,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_CURRENT','ID','FLOW_ID','','CLOB',
    'Y','Template when list item is current');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (54,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_NONCURRENT','ID','FLOW_ID','','CLOB',
    'Y','Template when list item is not current');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (55,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_BEFORE_ROWS','ID','FLOW_ID','','VARCHAR2',
    'Y','Appears before list template items');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (56,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_AFTER_ROWS','ID','FLOW_ID','','VARCHAR2',
    'Y','Appears after list template items');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (57,'WWV_FLOW_MENU_TEMPLATES','BEFORE_FIRST','ID','FLOW_ID','','VARCHAR2',
    'Y','Appears before menu items');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (58,'WWV_FLOW_MENU_TEMPLATES','CURRENT_PAGE_OPTION','ID','FLOW_ID','','VARCHAR2',
    'Y','Template when menu item is current');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (59,'WWV_FLOW_MENU_TEMPLATES','NON_CURRENT_PAGE_OPTION','ID','FLOW_ID','','VARCHAR2',
    'Y','Template when menu item is not current');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (60,'WWV_FLOW_MENU_TEMPLATES','MENU_LINK_ATTRIBUTES','ID','FLOW_ID','','VARCHAR2',
    'Y','The attributes of the link, such as class or id');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (61,'WWV_FLOW_MENU_TEMPLATES','BETWEEN_LEVELS','ID','FLOW_ID','','VARCHAR2',
    'Y','Appears between menu items');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (62,'WWV_FLOW_MENU_TEMPLATES','AFTER_LAST','ID','FLOW_ID','','VARCHAR2',
    'Y','Appears after the last menu item');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (63,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_TITLE','ID','FLOW_ID','','VARCHAR2',
    'N','Title of page');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (64,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_HTML_HEAD','ID','FLOW_ID','','VARCHAR2',
    'Y','HTML <head> of the popup page');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (65,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_BODY_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','Attributes listed in the <body> tag');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (66,'WWV_FLOW_POPUP_LOV_TEMPLATE','BEFORE_FIELD_TEXT','ID','FLOW_ID','','VARCHAR2',
    'N','Text that appears before the search field');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (67,'WWV_FLOW_POPUP_LOV_TEMPLATE','AFTER_FIELD_TEXT','ID','FLOW_ID','','VARCHAR2',
    'N','Text that appears after the search field');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (68,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_HEADING_TEXT','ID','FLOW_ID','','VARCHAR2',
    'Y','Text that appears at the top of the popup page');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (69,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_FOOTER_TEXT','ID','FLOW_ID','','VARCHAR2',
    'Y','Text that appears at the bottom of the popup page');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (70,'WWV_FLOW_POPUP_LOV_TEMPLATE','BEFORE_RESULT_SET','ID','FLOW_ID','','VARCHAR2',
    'N','Text that appears before choices');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (71,'WWV_FLOW_POPUP_LOV_TEMPLATE','AFTER_RESULT_SET','ID','FLOW_ID','','VARCHAR2',
    'N','Text that appears after choices');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (72,'WWV_FLOW_POPUP_LOV_TEMPLATE','FIND_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2',
    'N','Text that appears on the search button');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (73,'WWV_FLOW_POPUP_LOV_TEMPLATE','CLOSE_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2',
    'N','Text that appears on the close button');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (74,'WWV_FLOW_POPUP_LOV_TEMPLATE','NEXT_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2',
    'N','Text that appears on the next button');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (75,'WWV_FLOW_POPUP_LOV_TEMPLATE','PREV_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2',
    'N','Text that appears on the previous button');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (76,'WWV_FLOW_POPUP_LOV_TEMPLATE','WHEN_NO_DATA_FOUND_MESSAGE','ID','FLOW_ID','','VARCHAR2',
    'N','Text that appears when search returns 0 results');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (77,'WWV_FLOW_POPUP_LOV_TEMPLATE','BEFORE_FIRST_FETCH_MESSAGE','ID','FLOW_ID','','VARCHAR2',
    'N','Text that appears before first time search button is pressed');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (78,'WWV_FLOW_STEP_ITEMS','POST_ELEMENT_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2',
    'N','Text that is displayed following the display of a form element');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (79,'WWV_FLOW_SHORTCUTS','SHORTCUT','ID','FLOW_ID','','CLOB',
    'N','Shortcut is shared static or dynamic HTML');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (80,'WWV_FLOWS','SUBSTITUTION_VALUE_01','ID','ID','','VARCHAR2',
    'N','Flow substitution string 01');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (81,'WWV_FLOWS','SUBSTITUTION_VALUE_02','ID','ID','','VARCHAR2',
    'N','Flow substitution string 02');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (82,'WWV_FLOWS','SUBSTITUTION_VALUE_03','ID','ID','','VARCHAR2',
    'N','Flow substitution string 03');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (83,'WWV_FLOWS','SUBSTITUTION_VALUE_04','ID','ID','','VARCHAR2',
    'N','Flow substitution string 04');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (84,'WWV_FLOWS','SUBSTITUTION_VALUE_05','ID','ID','','VARCHAR2',
    'N','Flow substitution string 05');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (85,'WWV_FLOWS','SUBSTITUTION_VALUE_06','ID','ID','','VARCHAR2',
    'N','Flow substitution string 06');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (86,'WWV_FLOWS','SUBSTITUTION_VALUE_07','ID','ID','','VARCHAR2',
    'N','Flow substitution string 07');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (87,'WWV_FLOWS','SUBSTITUTION_VALUE_08','ID','ID','','VARCHAR2',
    'N','Flow substitution string 08');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (88,'WWV_FLOWS','SUBSTITUTION_VALUE_09','ID','ID','','VARCHAR2',
    'N','Flow substitution string 09');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (89,'WWV_FLOWS','SUBSTITUTION_VALUE_10','ID','ID','','VARCHAR2',
    'N','Flow substitution string 10');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (90,'WWV_FLOWS','SUBSTITUTION_VALUE_11','ID','ID','','VARCHAR2',
    'N','Flow substitution string 11');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (91,'WWV_FLOWS','SUBSTITUTION_VALUE_12','ID','ID','','VARCHAR2',
    'N','Flow substitution string 12');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (92,'WWV_FLOWS','SUBSTITUTION_VALUE_13','ID','ID','','VARCHAR2',
    'N','Flow substitution string 13');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (93,'WWV_FLOWS','SUBSTITUTION_VALUE_14','ID','ID','','VARCHAR2',
    'N','Flow substitution string 14');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (94,'WWV_FLOWS','SUBSTITUTION_VALUE_15','ID','ID','','VARCHAR2',
    'N','Flow substitution string 15');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (95,'WWV_FLOWS','SUBSTITUTION_VALUE_16','ID','ID','','VARCHAR2',
    'N','Flow substitution string 16');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (96,'WWV_FLOWS','SUBSTITUTION_VALUE_17','ID','ID','','VARCHAR2',
    'N','Flow substitution string 17');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (97,'WWV_FLOWS','SUBSTITUTION_VALUE_18','ID','ID','','VARCHAR2',
    'N','Flow substitution string 18');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (98,'WWV_FLOWS','SUBSTITUTION_VALUE_19','ID','ID','','VARCHAR2',
    'N','Flow substitution string 19');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (99,'WWV_FLOWS','SUBSTITUTION_VALUE_20','ID','ID','','VARCHAR2',
    'N','Flow substitution string 20');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (100,'WWV_FLOW_MENU_OPTIONS','SHORT_NAME','ID','FLOW_ID','','VARCHAR2',
    'N','Shortcut short name');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (101,'WWV_FLOW_MENU_OPTIONS','LONG_NAME','ID','FLOW_ID','','VARCHAR2',
    'N','Shortcut long name');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (102,'WWV_FLOW_PAGE_PLUGS','PLUG_QUERY_MORE_DATA','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','More Data found message');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (103,'WWV_FLOW_LIST_OF_VALUES_DATA','LOV_DISP_VALUE','ID','FLOW_ID','','VARCHAR2',
    'N','List of values display value');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (104,'WWV_FLOW_CUSTOM_AUTH_SETUPS','ATTRIBUTE_03','ID','FLOW_ID','','VARCHAR2',
    'N','Login help text for the built-in login page');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (105,'WWV_FLOW_STEP_ITEMS','LOV_NULL_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Value displayed when null selected in LOV');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (106,'WWV_FLOW_REGION_REPORT_COLUMN','COLUMN_HEADING','ID','FLOW_ID','','VARCHAR2',
    'N','Report column heading');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (107,'WWV_FLOW_REGION_REPORT_COLUMN','COLUMN_LINKTEXT','ID','FLOW_ID','','VARCHAR2',
    'N','Text to display inside of HTML anchor in report');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (108,'WWV_FLOW_REGION_REPORT_COLUMN','COLUMN_HTML_EXPRESSION','ID','FLOW_ID','','VARCHAR2',
    'N','HTML expression');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (109,'WWV_FLOW_REGION_REPORT_COLUMN','LOV_NULL_TEXT','ID','FLOW_ID','','VARCHAR2',
    'N','Value displayed when null selected from LOV');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (110,'WWV_FLOW_PAGE_PLUGS','PLUG_CUSTOMIZED_NAME','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Customizable region name');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (111,'WWV_FLOW_STEP_ITEM_HELP','HELP_TEXT','FLOW_ITEM_ID','FLOW_ID','','VARCHAR2',
    'N','Item level help text');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (112,'WWV_FLOW_POPUP_LOV_TEMPLATE','RESULT_ROW_X_OF_Y','ID','FLOW_ID','','VARCHAR2',
    'N','Set pagination text');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (113,'WWV_FLOW_SHORTCUTS','ERROR_TEXT','ID','FLOW_ID','','VARCHAR2',
    'N','Shortcut is shared static or dynamic HTML');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (114,'WWV_FLOW_LIST_TEMPLATES','BETWEEN_ITEMS','ID','FLOW_ID','','VARCHAR2',
    'Y','Appears between list template items');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (115,'WWV_FLOW_LIST_TEMPLATES','BEFORE_SUB_LIST','ID','FLOW_ID','','VARCHAR2',
    'Y','Appears before list template sub list items');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (116,'WWV_FLOW_LIST_TEMPLATES','AFTER_SUB_LIST','ID','FLOW_ID','','VARCHAR2',
    'Y','Appears after list template sub list items');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (117,'WWV_FLOW_LIST_TEMPLATES','BETWEEN_SUB_LIST_ITEMS','ID','FLOW_ID','','VARCHAR2',
    'Y','Appears between list template sub list items');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (118,'WWV_FLOW_LIST_TEMPLATES','SUB_LIST_ITEM_CURRENT','ID','FLOW_ID','','CLOB',
    'Y','Appears as current list template sub list item');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (119,'WWV_FLOW_LIST_TEMPLATES','SUB_LIST_ITEM_NONCURRENT','ID','FLOW_ID','','CLOB',
    'Y','Appears as noncurrent list template sub list item');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (120,'WWV_FLOW_LIST_TEMPLATES','ITEM_TEMPLATE_CURR_W_CHILD','ID','FLOW_ID','','CLOB',
    'Y','Template for current list item with child');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (121,'WWV_FLOW_LIST_TEMPLATES','ITEM_TEMPLATE_NONCURR_W_CHILD','ID','FLOW_ID','','CLOB',
    'Y','Template for non-current list item with child');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (122,'WWV_FLOW_LIST_TEMPLATES','SUB_TEMPLATE_CURR_W_CHILD','ID','FLOW_ID','','CLOB',
    'Y','Sub template for current list item with child');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (123,'WWV_FLOW_LIST_TEMPLATES','SUB_TEMPLATE_NONCURR_W_CHILD','ID','FLOW_ID','','CLOB',
    'Y','Sub template for non-current list item with child');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (124,'WWV_FLOW_COMPUTATIONS','COMPUTATION_ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2',
    'N','Application computation error message');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (125,'WWV_FLOW_STEP_COMPUTATIONS','COMPUTATION_ERROR_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2',
    'N','Page computation error message');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (126,'WWV_FLOW_STEP_ITEMS','PRE_ELEMENT_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2',
    'N','Text that is displayed before the display of a form element');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (127,'WWV_FLOW_FLASH_CHARTS','CHART_TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Flash chart title');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (128,'WWV_FLOW_FLASH_CHARTS','X_AXIS_TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','X Axis title');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (129,'WWV_FLOW_FLASH_CHARTS','X_AXIS_PREFIX','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','X Axis prefix');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (130,'WWV_FLOW_FLASH_CHARTS','X_AXIS_POSTFIX','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','X Axis postfix');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (131,'WWV_FLOW_FLASH_CHARTS','Y_AXIS_TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Y Axis title');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (132,'WWV_FLOW_FLASH_CHARTS','Y_AXIS_PREFIX','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Y Axis prefix');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (133,'WWV_FLOW_FLASH_CHARTS','Y_AXIS_POSTFIX','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Y Axis postfix');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (134,'WWV_FLOW_FLASH_CHARTS','CHART_XML','ID','FLOW_ID','PAGE_ID','CLOB',
    'N','Custom Flash chart XML');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (135,'WWV_FLOW_FLASH_CHARTS','ATTRIBUTE_01','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Flash chart attribute 01');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (136,'WWV_FLOW_FLASH_CHARTS','ATTRIBUTE_02','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Flash chart attribute 02');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (137,'WWV_FLOW_FLASH_CHARTS','ATTRIBUTE_03','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Flash chart attribute 03');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (138,'WWV_FLOW_FLASH_CHARTS','ATTRIBUTE_04','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Flash chart attribute 04');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (139,'WWV_FLOW_FLASH_CHARTS','ATTRIBUTE_05','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Flash chart attribute 05');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (140,'WWV_FLOW_FLASH_CHART_SERIES','SERIES_NAME','ID','FLOW_ID','','VARCHAR2',
    'N','Flash chart series name');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (141,'WWV_FLOW_FLASH_CHART_SERIES','SERIES_QUERY_NO_DATA_FOUND','ID','FLOW_ID','','VARCHAR2',
    'N','Flash chart query no data found message');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (142,'WWV_FLOW_PAGE_PLUGS','PRN_OUTPUT_LINK_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Link label name for region printing');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (143,'WWV_FLOW_PAGE_PLUGS','PRN_PAGE_HEADER','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Region printing report header');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (144,'WWV_FLOW_PAGE_PLUGS','PRN_PAGE_FOOTER','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Region printing report footer');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (145,'WWV_FLOW_WORKSHEETS','DESCRIPTION','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Worksheet description');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (146,'WWV_FLOW_WORKSHEETS','MAX_ROW_COUNT_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Message displayed when showing the maximum number of rows in a worksheet');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (147,'WWV_FLOW_WORKSHEETS','NO_DATA_FOUND_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Message displayed when no data found in a worksheet');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (148,'WWV_FLOW_WORKSHEET_COLUMNS','COLUMN_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Worksheet column label');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (149,'WWV_FLOW_WORKSHEET_COLUMNS','REPORT_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Worksheet report label');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (150,'WWV_FLOW_WORKSHEET_COLUMNS','COLUMN_HTML_EXPRESSION','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Worksheet column HTML expression');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (151,'WWV_FLOW_WORKSHEET_COLUMNS','COLUMN_LINKTEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Worksheet column link text');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (152,'WWV_FLOW_WORKSHEET_COLUMNS','HELP_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Worksheet column help text');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (153,'WWV_FLOW_WORKSHEET_COL_GROUPS','NAME','ID','FLOW_ID','','VARCHAR2',
    'N','Worksheet column group name');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (154,'WWV_FLOW_WORKSHEET_COL_GROUPS','DESCRIPTION','ID','FLOW_ID','','VARCHAR2',
    'N','Worksheet column group description');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (155,'WWV_FLOW_WORKSHEETS','SEARCH_BUTTON_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2',
    'N','Label of search button in Interactive Report.');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (156,'WWV_FLOW_TEMPLATES','BODY_TITLE','ID','FLOW_ID','','VARCHAR2',
    'Y','Body Title');    
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (157,'WWV_FLOW_TEMPLATES','CURRENT_IMAGE_TAB','ID','FLOW_ID','','VARCHAR2',
    'Y','Current Image Tab');    
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (158,'WWV_FLOW_TEMPLATES','CURRENT_TAB','ID','FLOW_ID','','VARCHAR2',
    'Y','Current Tab');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (159,'WWV_FLOW_TEMPLATES','CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','Current Tab Font Attributes');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (160,'WWV_FLOW_TEMPLATES','ERROR_PAGE_TEMPLATE','ID','FLOW_ID','','VARCHAR2',
    'Y','Error Page Template');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (161,'WWV_FLOW_TEMPLATES','MESSAGE','ID','FLOW_ID','','VARCHAR2',
    'Y','Notification');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (162,'WWV_FLOW_TEMPLATES','NAVBAR_ENTRY','ID','FLOW_ID','','VARCHAR2',
    'Y','Navigation Bar Entry');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (163,'WWV_FLOW_TEMPLATES','NAVIGATION_BAR','ID','FLOW_ID','','VARCHAR2',
    'Y','Navigation Bar');
    insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (164,'WWV_FLOW_TEMPLATES','NON_CURRENT_IMAGE_TAB','ID','FLOW_ID','','VARCHAR2',
    'Y','Non Current Image Tab');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (165,'WWV_FLOW_TEMPLATES','NON_CURRENT_TAB','ID','FLOW_ID','','VARCHAR2',
    'Y','Non Current Standard Tab');    
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (166,'WWV_FLOW_TEMPLATES','NON_CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','Non Current Tab Font Attributes');    
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (167,'WWV_FLOW_TEMPLATES','REGION_TABLE_CATTRIBUTES','ID','FLOW_ID','','VARCHAR2',
    'Y','Region Table Attributes');    
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (168,'WWV_FLOW_TEMPLATES','SUCCESS_MESSAGE','ID','FLOW_ID','','VARCHAR2',
    'Y','Success Message');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (169,'WWV_FLOW_TEMPLATES','TOP_CURRENT_TAB','ID','FLOW_ID','','VARCHAR2',
    'Y','Current Parent Tab');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (170,'WWV_FLOW_TEMPLATES','TOP_CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','Parent Current Tab Font Attributes');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (171,'WWV_FLOW_TEMPLATES','TOP_NON_CURRENT_TAB','ID','FLOW_ID','','VARCHAR2',
    'Y','Non Current Parent Tab');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (172,'WWV_FLOW_TEMPLATES','TOP_NON_CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','Parent Non Current Tab Font Attributes');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (173,'WWV_FLOW_CAL_TEMPLATES','DAILY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (174,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_OF_WEEK_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (175,'WWV_FLOW_CAL_TEMPLATES','DAILY_MONTH_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (176,'WWV_FLOW_CAL_TEMPLATES','DAILY_MONTH_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (177,'WWV_FLOW_CAL_TEMPLATES','DAILY_MONTH_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (178,'WWV_FLOW_CAL_TEMPLATES','DAILY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (179,'WWV_FLOW_CAL_TEMPLATES','DAILY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (180,'WWV_FLOW_CAL_TEMPLATES','DAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (181,'WWV_FLOW_CAL_TEMPLATES','DAY_OF_WEEK_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (182,'WWV_FLOW_CAL_TEMPLATES','DAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (183,'WWV_FLOW_CAL_TEMPLATES','DAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (184,'WWV_FLOW_CAL_TEMPLATES','MONTH_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (185,'WWV_FLOW_CAL_TEMPLATES','MONTH_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (186,'WWV_FLOW_CAL_TEMPLATES','MONTH_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (187,'WWV_FLOW_CAL_TEMPLATES','NONDAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (188,'WWV_FLOW_CAL_TEMPLATES','NONDAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (189,'WWV_FLOW_CAL_TEMPLATES','NONDAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (190,'WWV_FLOW_CAL_TEMPLATES','TODAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (191,'WWV_FLOW_CAL_TEMPLATES','WEEKEND_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (192,'WWV_FLOW_CAL_TEMPLATES','WEEKEND_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (193,'WWV_FLOW_CAL_TEMPLATES','WEEKEND_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (194,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (195,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_OF_WEEK_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (196,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (197,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (198,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_HOUR_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (199,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_HOUR_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (200,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_MONTH_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (201,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_MONTH_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (202,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TIME_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (203,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TIME_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (204,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TIME_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (205,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (206,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TODAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (207,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_WEEKEND_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (208,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_WEEKEND_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (209,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_WEEKEND_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (210,'WWV_FLOW_CAL_TEMPLATES','WEEK_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (211,'WWV_FLOW_CAL_TEMPLATES','WEEK_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (212,'WWV_FLOW_PAGE_PLUG_TEMPLATES','TEMPLATE2','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (213,'WWV_FLOW_POPUP_LOV_TEMPLATE','CLOSE_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (214,'WWV_FLOW_POPUP_LOV_TEMPLATE','FILTER_TEXT_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (215,'WWV_FLOW_POPUP_LOV_TEMPLATE','FIND_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (216,'WWV_FLOW_POPUP_LOV_TEMPLATE','NEXT_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (217,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (218,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON2','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (219,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (220,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON_ATTR2','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (221,'WWV_FLOW_POPUP_LOV_TEMPLATE','PREV_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (222,'WWV_FLOW_ROW_TEMPLATES','AFTER_COLUMN_HEADING','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (223,'WWV_FLOW_ROW_TEMPLATES','BEFORE_COLUMN_HEADING','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (224,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (225,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (226,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (227,'WWV_FLOW_CAL_TEMPLATES','DAILY_HOUR_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (228,'WWV_FLOW_CAL_TEMPLATES','DAILY_HOUR_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (229,'WWV_FLOW_CAL_TEMPLATES','DAILY_TIME_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (230,'WWV_FLOW_CAL_TEMPLATES','DAILY_TIME_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (231,'WWV_FLOW_CAL_TEMPLATES','DAILY_TIME_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (232,'WWV_FLOW_CAL_TEMPLATES','DAILY_TODAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');
insert into wwv_flow_translatable_cols$
    (id, table_name, column_name, table_pk, flow_id_column, page_id_column, datatype,
     template_translatable, column_description )
    values
    (233,'WWV_FLOW_CAL_TEMPLATES','WEEK_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2',
    'Y','');        


commit;



prompt 
prompt ...insert into wwv_flow_developer_roles
prompt 

delete from wwv_flow_developer_roles;
insert into wwv_flow_developer_roles values ('ADMIN','Ability to manage flow developer privileges');
insert into wwv_flow_developer_roles values ('EDIT','Ability change all attributes of specified flow(s)');
insert into wwv_flow_developer_roles values ('HELP','Ability edit help page for a given company');
insert into wwv_flow_developer_roles values ('BROWSE','Access to Oracle data dictionary browser');
insert into wwv_flow_developer_roles values ('CREATE','Ability to create new flows');
insert into wwv_flow_developer_roles values ('MONITOR','Ability to monitor flow activity');
insert into wwv_flow_developer_roles values ('DB_MONITOR','Ability to monitor Oracle database attributes');
insert into wwv_flow_developer_roles values ('SQL','Ability to issues SQL statements');
insert into wwv_flow_developer_roles values ('USER_MANAGER','Manage user accounts for cookie based authentication');
commit;


prompt
prompt ...insert into wwv_flow_sw_sqlplus_cmd
prompt 

delete wwv_flow_sw_sqlplus_cmd
/

insert into wwv_flow_sw_sqlplus_cmd
values('PROMPT')
/
insert into wwv_flow_sw_sqlplus_cmd
values('SET')
/
insert into wwv_flow_sw_sqlplus_cmd
values('SPOOL')
/
insert into wwv_flow_sw_sqlplus_cmd
values('SHOW')
/
insert into wwv_flow_sw_sqlplus_cmd
values('REM')
/
insert into wwv_flow_sw_sqlplus_cmd
values('/')
/
insert into wwv_flow_sw_sqlplus_cmd
values('@@')
/
insert into wwv_flow_sw_sqlplus_cmd
values('WHENEVER')
/
commit
/


prompt
prompt ...insert into wwv_flow_sw_main_keywords
prompt

delete from wwv_flow_sw_main_keywords;
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (1, 'REM',           4 /* G_C_SQLPLUS */,        22 /* G_S_COMMENT_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (2, 'INSERT',        2 /* G_C_SQL */,            48 /* G_S_INSERT */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (3, 'CREATE',       10 /* G_C_UNKNOWN_CREATE */,  1 /* G_S_UNKNOWN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (4, 'DROP',          2 /* G_C_SQL */,            35 /* G_S_DROP */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (5, 'GRANT',         2 /* G_C_SQL */,            43 /* G_S_GRANT */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (6, 'ALTER',         2 /* G_C_SQL */,             3 /* G_S_ALTER */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (7, 'SELECT',        2 /* G_C_SQL */,            72 /* G_S_SELECT */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (8, 'UPDATE',        2 /* G_C_SQL */,            88 /* G_S_UPDATE */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (9, 'BEGIN',         3 /* G_C_PLSQL */,          12 /* G_S_BEGIN */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (10, 'DECLARE',       3 /* G_C_PLSQL */,          28 /* G_S_DECLARE */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (11, 'DELETE',        2 /* G_C_SQL */,            31 /* G_S_DELETE */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (12, 'COL',           4 /* G_C_SQLPLUS */,        19 /* G_S_COLUMN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (13, 'COLU',          4 /* G_C_SQLPLUS */,        19 /* G_S_COLUMN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (14, 'COLUM',         4 /* G_C_SQLPLUS */,        19 /* G_S_COLUMN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (15, 'COLUMN',        4 /* G_C_SQLPLUS */,        19 /* G_S_COLUMN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (16, 'SET',           9 /* G_C_UNKNOWN_SET */,     1 /* G_S_UNKNOWN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (17, 'VAR',           4 /* G_C_SQLPLUS */,        90 /* G_S_VARIABLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (18, 'VARI',          4 /* G_C_SQLPLUS */,        90 /* G_S_VARIABLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (19, 'VARIA',         4 /* G_C_SQLPLUS */,        90 /* G_S_VARIABLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (20, 'VARIAB',        4 /* G_C_SQLPLUS */,        90 /* G_S_VARIABLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (21, 'VARIABL',       4 /* G_C_SQLPLUS */,        90 /* G_S_VARIABLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (22, 'VARIABLE',      4 /* G_C_SQLPLUS */,        90 /* G_S_VARIABLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (23, 'PRO',           4 /* G_C_SQLPLUS */,        59 /* G_S_PROMPT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (24, 'PROM',          4 /* G_C_SQLPLUS */,        59 /* G_S_PROMPT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (25, 'PROMP',         4 /* G_C_SQLPLUS */,        59 /* G_S_PROMPT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (26, 'PROMPT',        4 /* G_C_SQLPLUS */,        59 /* G_S_PROMPT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (27, 'EXEC',          4 /* G_C_SQLPLUS */,        37 /* G_S_EXECUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (28, 'EXECU',         4 /* G_C_SQLPLUS */,        37 /* G_S_EXECUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (29, 'EXECUT',        4 /* G_C_SQLPLUS */,        37 /* G_S_EXECUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (30, 'EXECUTE',       4 /* G_C_SQLPLUS */,        37 /* G_S_EXECUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (31, 'SHO',           4 /* G_C_SQLPLUS */,        75 /* G_S_SHOW */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (32, 'SHOW',          4 /* G_C_SQLPLUS */,        75 /* G_S_SHOW */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (33, 'WHENEVER',      4 /* G_C_SQLPLUS */,        91 /* G_S_WHENEVER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (34, 'SPO',           4 /* G_C_SQLPLUS */,        78 /* G_S_SPOOL */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (35, 'SPOO',          4 /* G_C_SQLPLUS */,        78 /* G_S_SPOOL */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (36, 'SPOOL',         4 /* G_C_SQLPLUS */,        78 /* G_S_SPOOL */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (37, 'DEF',           4 /* G_C_SQLPLUS */,        29 /* G_S_DEFINE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (38, 'DEFI',          4 /* G_C_SQLPLUS */,        29 /* G_S_DEFINE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (39, 'DEFIN',         4 /* G_C_SQLPLUS */,        29 /* G_S_DEFINE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (40, 'DEFINE',        4 /* G_C_SQLPLUS */,        29 /* G_S_DEFINE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (41, 'STA',           4 /* G_C_SQLPLUS */,        81 /* G_S_START */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (42, 'STAR',          4 /* G_C_SQLPLUS */,        81 /* G_S_START */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (43, 'START',         4 /* G_C_SQLPLUS */,        81 /* G_S_START */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (44, 'BRE',           4 /* G_C_SQLPLUS */,        14 /* G_S_BREAK */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (45, 'BREA',          4 /* G_C_SQLPLUS */,        14 /* G_S_BREAK */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (46, 'BREAK',         4 /* G_C_SQLPLUS */,        14 /* G_S_BREAK */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (47, 'COMP',          4 /* G_C_SQLPLUS */,        23 /* G_S_COMPUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (48, 'COMPU',         4 /* G_C_SQLPLUS */,        23 /* G_S_COMPUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (49, 'COMPUT',        4 /* G_C_SQLPLUS */,        23 /* G_S_COMPUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (50, 'COMPUTE',       4 /* G_C_SQLPLUS */,        23 /* G_S_COMPUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (51, 'CONN',          4 /* G_C_SQLPLUS */,        24 /* G_S_CONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (52, 'CONNE',         4 /* G_C_SQLPLUS */,        24 /* G_S_CONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (53, 'CONNEC',        4 /* G_C_SQLPLUS */,        24 /* G_S_CONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (54, 'CONNECT',       4 /* G_C_SQLPLUS */,        24 /* G_S_CONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (55, 'EXIT',          4 /* G_C_SQLPLUS */,        39 /* G_S_EXIT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (56, 'QUIT',          4 /* G_C_SQLPLUS */,        61 /* G_S_QUIT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (57, 'DESC',          4 /* G_C_SQLPLUS */,        32 /* G_S_DESCRIBE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (58, 'DESCR',         4 /* G_C_SQLPLUS */,        32 /* G_S_DESCRIBE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (59, 'DESCRI',        4 /* G_C_SQLPLUS */,        32 /* G_S_DESCRIBE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (60, 'DESCRIB',       4 /* G_C_SQLPLUS */,        32 /* G_S_DESCRIBE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (61, 'DESCRIBE',      4 /* G_C_SQLPLUS */,        32 /* G_S_DESCRIBE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (62, 'FLASHBACK',     2 /* G_C_SQL */,            41 /* G_S_FLASHBACK */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (63, 'COMMIT',        2 /* G_C_SQL */,            21 /* G_S_COMMIT */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (64, 'ROLLBACK',      2 /* G_C_SQL */,            68 /* G_S_ROLLBACK_SQL */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (65, 'CALL',          2 /* G_C_SQL */,            16 /* G_S_CALL */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (66, 'LOCK',          2 /* G_C_SQL */,            50 /* G_S_LOCK */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (67, 'MERGE',         2 /* G_C_SQL */,            51 /* G_S_MERGE */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (68, 'PURGE',         2 /* G_C_SQL */,            60 /* G_S_PURGE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (69, 'EXPLAIN',       2 /* G_C_SQL */,            40 /* G_S_EXPLAIN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (70, 'ANALYZE',       2 /* G_C_SQL */,             4 /* G_S_ANALYZE */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (71, 'VALIDATE',      2 /* G_C_SQL */,            89 /* G_S_VALIDATE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (72, 'TRUNCATE',      2 /* G_C_SQL */,            85 /* G_S_TRUNCATE */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (73, 'WITH',          2 /* G_C_SQL */,            92 /* G_S_WITH */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (74, 'REVOKE',        2 /* G_C_SQL */,            66 /* G_S_REVOKE */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (75, 'RENAME',        2 /* G_C_SQL */,            63 /* G_S_RENAME */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (76, 'SAVEPOINT',     2 /* G_C_SQL */,            71 /* G_S_SAVEPOINT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (77, 'AUDIT',         2 /* G_C_SQL */,            11 /* G_S_AUDIT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (78, 'NOAUDIT',       2 /* G_C_SQL */,            53 /* G_S_NOAUDIT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (79, 'ASSOCIATE',     2 /* G_C_SQL */,             7 /* G_S_ASSOCIATE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (80, 'DISASSOCIATE',  2 /* G_C_SQL */,            33 /* G_S_DISASSOCIATE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (81, 'EXPAND',        2 /* G_C_SQL */,            38 /* G_S_EXPAND */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (82, 'COMMENT',       2 /* G_C_SQL */,            20 /* G_S_COMMENT_SQL */,  'Y');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (83, 'XQUERY',        3 /* G_C_PLSQL */,          93 /* G_S_XQUERY */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (84, 'COPY',          4 /* G_C_SQLPLUS */,        25 /* G_S_COPY */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (85, 'DISC',          4 /* G_C_SQLPLUS */,        34 /* G_S_DISCONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (86, 'DISCO',         4 /* G_C_SQLPLUS */,        34 /* G_S_DISCONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (87, 'DISCON',        4 /* G_C_SQLPLUS */,        34 /* G_S_DISCONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (88, 'DISCONN',       4 /* G_C_SQLPLUS */,        34 /* G_S_DISCONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (89, 'DISCONNE',      4 /* G_C_SQLPLUS */,        34 /* G_S_DISCONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (90, 'DISCONNEC',     4 /* G_C_SQLPLUS */,        34 /* G_S_DISCONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (91, 'DISCONNECT',    4 /* G_C_SQLPLUS */,        34 /* G_S_DISCONNECT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (92, 'TIMI',          4 /* G_C_SQLPLUS */,        84 /* G_S_TIMING */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (93, 'TIMIN',         4 /* G_C_SQLPLUS */,        84 /* G_S_TIMING */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (94, 'TIMING',        4 /* G_C_SQLPLUS */,        84 /* G_S_TIMING */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (95, 'GET',           4 /* G_C_SQLPLUS */,        42 /* G_S_GET */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (96, 'HELP',          4 /* G_C_SQLPLUS */,        46 /* G_S_HELP */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (97, 'PRINT',         4 /* G_C_SQLPLUS */,        58 /* G_S_PRINT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (98, 'UNDEF',         4 /* G_C_SQLPLUS */,        87 /* G_S_UNDEFINE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (99, 'UNDEFI',        4 /* G_C_SQLPLUS */,        87 /* G_S_UNDEFINE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (100, 'UNDEFIN',       4 /* G_C_SQLPLUS */,        87 /* G_S_UNDEFINE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (101, 'UNDEFINE',      4 /* G_C_SQLPLUS */,        87 /* G_S_UNDEFINE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (102, 'TTI',           4 /* G_C_SQLPLUS */,        86 /* G_S_TTITLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (103, 'TTIT',          4 /* G_C_SQLPLUS */,        86 /* G_S_TTITLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (104, 'TTITL',         4 /* G_C_SQLPLUS */,        86 /* G_S_TTITLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (105, 'TTITLE',        4 /* G_C_SQLPLUS */,        86 /* G_S_TTITLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (106, 'BTI',           4 /* G_C_SQLPLUS */,        15 /* G_S_BTITLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (107, 'BTIT',          4 /* G_C_SQLPLUS */,        15 /* G_S_BTITLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (108, 'BTITL',         4 /* G_C_SQLPLUS */,        15 /* G_S_BTITLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (109, 'BTITLE',        4 /* G_C_SQLPLUS */,        15 /* G_S_BTITLE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (110, 'REPF',          4 /* G_C_SQLPLUS */,        64 /* G_S_REPFOOTER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (111, 'REPFO',         4 /* G_C_SQLPLUS */,        64 /* G_S_REPFOOTER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (112, 'REPFOO',        4 /* G_C_SQLPLUS */,        64 /* G_S_REPFOOTER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (113, 'REPFOOT',       4 /* G_C_SQLPLUS */,        64 /* G_S_REPFOOTER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (114, 'REPFOOTE',      4 /* G_C_SQLPLUS */,        64 /* G_S_REPFOOTER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (115, 'REPFOOTER',     4 /* G_C_SQLPLUS */,        64 /* G_S_REPFOOTER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (116, 'REPH',          4 /* G_C_SQLPLUS */,        65 /* G_S_REPHEADER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (117, 'REPHE',         4 /* G_C_SQLPLUS */,        65 /* G_S_REPHEADER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (118, 'REPHEA',        4 /* G_C_SQLPLUS */,        65 /* G_S_REPHEADER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (119, 'REPHEAD',       4 /* G_C_SQLPLUS */,        65 /* G_S_REPHEADER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (120, 'REPHEADE',      4 /* G_C_SQLPLUS */,        65 /* G_S_REPHEADER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (121, 'REPHEADER',     4 /* G_C_SQLPLUS */,        65 /* G_S_REPHEADER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (122, 'ATTR',          4 /* G_C_SQLPLUS */,        10 /* G_S_ATTRIBUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (123, 'ATTRI',         4 /* G_C_SQLPLUS */,        10 /* G_S_ATTRIBUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (124, 'ATTRIB',        4 /* G_C_SQLPLUS */,        10 /* G_S_ATTRIBUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (125, 'ATTRIBU',       4 /* G_C_SQLPLUS */,        10 /* G_S_ATTRIBUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (126, 'ATTRIBUT',      4 /* G_C_SQLPLUS */,        10 /* G_S_ATTRIBUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (127, 'ATTRIBUTE',     4 /* G_C_SQLPLUS */,        10 /* G_S_ATTRIBUTE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (128, 'STORE',         4 /* G_C_SQLPLUS */,        83 /* G_S_STORE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (129, 'R',             4 /* G_C_SQLPLUS */,        69 /* G_S_RUN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (130, 'RU',            4 /* G_C_SQLPLUS */,        69 /* G_S_RUN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (131, 'RUN',           4 /* G_C_SQLPLUS */,        69 /* G_S_RUN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (132, 'SAV',           4 /* G_C_SQLPLUS */,        70 /* G_S_SAVE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (133, 'SAVE',          4 /* G_C_SQLPLUS */,        70 /* G_S_SAVE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (134, 'ORADEBUG',      4 /* G_C_SQLPLUS */,        54 /* G_S_ORADEBUG */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (135, 'PASSW',         4 /* G_C_SQLPLUS */,        55 /* G_S_PASSWORD */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (136, 'PASSWO',        4 /* G_C_SQLPLUS */,        55 /* G_S_PASSWORD */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (137, 'PASSWOR',       4 /* G_C_SQLPLUS */,        55 /* G_S_PASSWORD */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (138, 'PASSWORD',      4 /* G_C_SQLPLUS */,        55 /* G_S_PASSWORD */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (139, 'PAU',           4 /* G_C_SQLPLUS */,        56 /* G_S_PAUSE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (140, 'PAUS',          4 /* G_C_SQLPLUS */,        56 /* G_S_PAUSE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (141, 'PAUSE',         4 /* G_C_SQLPLUS */,        56 /* G_S_PAUSE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (142, 'REMA',          4 /* G_C_SQLPLUS */,        22 /* G_S_COMMENT_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (143, 'REMAR',         4 /* G_C_SQLPLUS */,        22 /* G_S_COMMENT_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (144, 'REMARK',        4 /* G_C_SQLPLUS */,        22 /* G_S_COMMENT_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (145, 'HO',            4 /* G_C_SQLPLUS */,        44 /* G_S_HOST */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (146, 'HOS',           4 /* G_C_SQLPLUS */,        44 /* G_S_HOST */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (147, 'HOST',          4 /* G_C_SQLPLUS */,        44 /* G_S_HOST */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (148, 'ACC',           4 /* G_C_SQLPLUS */,         2 /* G_S_ACCEPT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (149, 'ACCE',          4 /* G_C_SQLPLUS */,         2 /* G_S_ACCEPT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (150, 'ACCEP',         4 /* G_C_SQLPLUS */,         2 /* G_S_ACCEPT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (151, 'ACCEPT',        4 /* G_C_SQLPLUS */,         2 /* G_S_ACCEPT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (152, 'ED',            4 /* G_C_SQLPLUS */,        36 /* G_S_EDIT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (153, 'EDI',           4 /* G_C_SQLPLUS */,        36 /* G_S_EDIT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (154, 'EDIT',          4 /* G_C_SQLPLUS */,        36 /* G_S_EDIT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (155, 'A',             4 /* G_C_SQLPLUS */,         5 /* G_S_APPEND */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (156, 'AP',            4 /* G_C_SQLPLUS */,         5 /* G_S_APPEND */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (157, 'APP',           4 /* G_C_SQLPLUS */,         5 /* G_S_APPEND */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (158, 'APPE',          4 /* G_C_SQLPLUS */,         5 /* G_S_APPEND */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (159, 'APPEN',         4 /* G_C_SQLPLUS */,         5 /* G_S_APPEND */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (160, 'APPEND',        4 /* G_C_SQLPLUS */,         5 /* G_S_APPEND */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (161, 'C',             4 /* G_C_SQLPLUS */,        17 /* G_S_CHANGE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (162, 'CH',            4 /* G_C_SQLPLUS */,        17 /* G_S_CHANGE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (163, 'CHA',           4 /* G_C_SQLPLUS */,        17 /* G_S_CHANGE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (164, 'CHAN',          4 /* G_C_SQLPLUS */,        17 /* G_S_CHANGE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (165, 'CHANG',         4 /* G_C_SQLPLUS */,        17 /* G_S_CHANGE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (166, 'CHANGE',        4 /* G_C_SQLPLUS */,        17 /* G_S_CHANGE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (167, 'CL',            4 /* G_C_SQLPLUS */,        18 /* G_S_CLEAR */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (168, 'CLE',           4 /* G_C_SQLPLUS */,        18 /* G_S_CLEAR */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (169, 'CLEA',          4 /* G_C_SQLPLUS */,        18 /* G_S_CLEAR */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (170, 'CLEAR',         4 /* G_C_SQLPLUS */,        18 /* G_S_CLEAR */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (171, 'I',             4 /* G_C_SQLPLUS */,        47 /* G_S_INPUT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (172, 'IN',            4 /* G_C_SQLPLUS */,        47 /* G_S_INPUT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (173, 'INP',           4 /* G_C_SQLPLUS */,        47 /* G_S_INPUT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (174, 'INPU',          4 /* G_C_SQLPLUS */,        47 /* G_S_INPUT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (175, 'INPUT',         4 /* G_C_SQLPLUS */,        47 /* G_S_INPUT */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (176, 'L',             4 /* G_C_SQLPLUS */,        49 /* G_S_LIST */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (177, 'LI',            4 /* G_C_SQLPLUS */,        49 /* G_S_LIST */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (178, 'LIS',           4 /* G_C_SQLPLUS */,        49 /* G_S_LIST */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (179, 'LIST',          4 /* G_C_SQLPLUS */,        49 /* G_S_LIST */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (180, 'DEL',           4 /* G_C_SQLPLUS */,        30 /* G_S_DEL_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (181, 'ARCHIVE',       4 /* G_C_SQLPLUS */,         6 /* G_S_ARCHIVE */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (182, 'SHU',           4 /* G_C_SQLPLUS */,        76 /* G_S_SHUTDOWN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (183, 'SHUT',          4 /* G_C_SQLPLUS */,        76 /* G_S_SHUTDOWN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (184, 'SHUTD',         4 /* G_C_SQLPLUS */,        76 /* G_S_SHUTDOWN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (185, 'SHUTDOW',       4 /* G_C_SQLPLUS */,        76 /* G_S_SHUTDOWN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (186, 'SHUTDOWN',      4 /* G_C_SQLPLUS */,        76 /* G_S_SHUTDOWN */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (187, 'STARTUP',       4 /* G_C_SQLPLUS */,        82 /* G_S_STARTUP */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (188, 'RECOVER',       4 /* G_C_SQLPLUS */,        62 /* G_S_RECOVER */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (189, 'DOC',           8 /* G_C_OLDCOMMENT */,     22 /* G_S_COMMENT_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (190, 'DOCU',          8 /* G_C_OLDCOMMENT */,     22 /* G_S_COMMENT_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (191, 'DOCUM',         8 /* G_C_OLDCOMMENT */,     22 /* G_S_COMMENT_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (192, 'DOCUME',        8 /* G_C_OLDCOMMENT */,     22 /* G_S_COMMENT_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (193, 'DOCUMEN',       8 /* G_C_OLDCOMMENT */,     22 /* G_S_COMMENT_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (194, 'DOCUMENT',      8 /* G_C_OLDCOMMENT */,     22 /* G_S_COMMENT_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (195, 'ROLL',          4 /* G_C_SQLPLUS */,        67 /* G_S_ROLLBACK_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (196, 'ROLLB',         4 /* G_C_SQLPLUS */,        67 /* G_S_ROLLBACK_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (197, 'ROLLBA',        4 /* G_C_SQLPLUS */,        67 /* G_S_ROLLBACK_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (198, 'ROLLBAC',       4 /* G_C_SQLPLUS */,        67 /* G_S_ROLLBACK_PLUS */,  'N');
insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (199, 'NEWPAGE',       4 /* G_C_SQLPLUS */,        52 /* G_S_NEWPAGE */,  'N');
commit;


prompt
prompt ...insert into wwv_flow_sw_create_keywords
prompt

delete from wwv_flow_sw_create_keywords;
insert into wwv_flow_sw_create_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (1, 'JAVA',        3 /* G_C_PLSQL */,          27 /* G_S_CREATE_PLSQL */,  'Y');
insert into wwv_flow_sw_create_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (2, 'NOFORCE',     3 /* G_C_PLSQL */,          27 /* G_S_CREATE_PLSQL */,  'Y');
insert into wwv_flow_sw_create_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (3, 'AND',         3 /* G_C_PLSQL */,          27 /* G_S_CREATE_PLSQL */,  'Y');
insert into wwv_flow_sw_create_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (4, 'OR',          3 /* G_C_PLSQL */,          27 /* G_S_CREATE_PLSQL */,  'Y');
insert into wwv_flow_sw_create_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (5, 'FUNCTION',    3 /* G_C_PLSQL */,          27 /* G_S_CREATE_PLSQL */,  'Y');
insert into wwv_flow_sw_create_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (6, 'LIBRARY',     3 /* G_C_PLSQL */,          27 /* G_S_CREATE_PLSQL */,  'Y');
insert into wwv_flow_sw_create_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (7, 'PACKAGE',     3 /* G_C_PLSQL */,          27 /* G_S_CREATE_PLSQL */,  'Y');
insert into wwv_flow_sw_create_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (8, 'PROCEDURE',   3 /* G_C_PLSQL */,          27 /* G_S_CREATE_PLSQL */,  'Y');
insert into wwv_flow_sw_create_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (9, 'TRIGGER',     3 /* G_C_PLSQL */,          27 /* G_S_CREATE_PLSQL */,  'Y');
insert into wwv_flow_sw_create_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (10, 'TYPE',        3 /* G_C_PLSQL */,          27 /* G_S_CREATE_PLSQL */, 'Y');
commit;


prompt
prompt ...insert into wwv_flow_sw_set_keywords
prompt

delete from wwv_flow_sw_set_keywords;
insert into wwv_flow_sw_set_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (1, 'CONSTRAINTS',    2 /* G_C_SQL */,            74 /* G_S_SET_SQL */,  'N');
insert into wwv_flow_sw_set_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (2, 'CONSTRAINT',     2 /* G_C_SQL */,            74 /* G_S_SET_SQL */,  'N');
insert into wwv_flow_sw_set_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (3, 'ROLE',           2 /* G_C_SQL */,            74 /* G_S_SET_SQL */,  'N');
insert into wwv_flow_sw_set_keywords (id, keyword, stmt_class, stmt_id, isrunnable) values (4, 'TRANSACTION',    2 /* G_C_SQL */,            74 /* G_S_SET_SQL */,  'N');

commit;



prompt
prompt ...insert into wwv_flow_charsets
prompt

delete from wwv_flow_charsets;
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(1,'Arabic ISO-8859-6','iso-8859-6','AR8ISO8859P6');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(2, 'Arabic Windows 1256','windows-1256','AR8MSWIN1256');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(3, 'Chinese Big5','big5','ZHT16MSWIN950');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(4, 'Chinese GBK','gbk','ZHS16GBK');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(5, 'Cyrilic ISO-8859-5','iso-8859-5','CL8ISO8859P5');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(6, 'Cyrilic KOI8-R','koi8-r','CL8KOI8R');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(7, 'Cyrilic KOI8-U','koi8-u','CL8KOI8U');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(8, 'Cyrilic Windows 1251','windows-1251','CL8MSWIN1251');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(9, 'Eastern European ISO-8859-2','iso-8859-2','EE8ISO8859P2');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(10, 'Eastern European Windows 1250','windows-1250','EE8MSWIN1250');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(11, 'Greek ISO-8859-7','iso-8859-7','EL8ISO8859P7');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(12, 'Greek Windows 1253','windows-1253','EL8MSWIN1253');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(13, 'Hebrew ISO-8859-8-i','iso-8859-8-i','IW8ISO8859P8');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(14, 'Hebrew Windows 1255','windows-1255','IW8MSWIN1255');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(15, 'Japanese EUC','euc-jp','JA16EUC');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(16, 'Japanese Shift JIS','shift_jis','JA16SJIS');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(17, 'Korean EUC','euc-kr','KO16MSWIN949');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(18, 'Northern European ISO-8859-4','iso-8859-4','NEE8ISO8859P4');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(19, 'Northern European Windows 1257','windows-1257','BLT8MSWIN1257');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(20, 'Southern European ISO-8859-3','iso-8859-3','SE8ISO8859P3');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(21, 'Thai TIS-620','tis-620','TH8TISASCII');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(22, 'Turkish ISO-8859-9','iso-8859-9','WE8ISO8859P9');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(23, 'Turkish Windows 1254','windows-1254','TR8MSWIN1254');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(24, 'Unicode UTF-8','utf-8','AL32UTF8');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(25, 'Unicode UTF-16 Big Endian','utf-16be','AL16UTF16');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(26, 'Unicode UTF-16 Little Endian','utf-16le','AL16UTF16LE');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(27, 'Vietnamese Windows 1258','windows-1258','VN8MSWIN1258');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(28, 'Western European ISO-8859-1','iso-8859-1','WE8ISO8859P1');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(29, 'Western European ISO-8859-15','iso-8859-15','WE8ISO8859P15');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(30, 'Western European Windows 1252','windows-1252','WE8MSWIN1252');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(31, 'Chinese EUC','euc-tw','ZHT32EUC');
insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset) values(32, 'US-ASCII','us-ascii','US7ASCII');
commit;


prompt
prompt ...insert into wwv_flow_standard_icons
prompt

delete from wwv_flow_standard_icons;

-- apex 3.1 16x16 images
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('blue_function_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('blue_folder_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('blue_info_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('edit_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('check2_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('attach_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('Fndtre_info_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('go_button_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('hs_infohidden_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('icon_button_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('icon_comp_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('icon_item_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('icon_page_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('icon_process_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('icon_region_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('icon_validation_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('idle_session_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('i_status_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('i_status_gray_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('inline_error_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('jtfuhide_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('jtfunexe_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('jtfupree_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('jtfushow_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('locks_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('long_trans_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pkt_stats_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pkt_studygu_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pobcol_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pobrow_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('icon_status_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('icon_status2_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('icon_status_red_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('rup_minus_dgray_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('rup_plus_dgray_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('small_chart_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wwv_smprt_16x16.gif',16);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pencil16x16.gif',16);

-- apex 3.1 140x90 images
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_blank_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_multiple_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_classic_report_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_flash_chart_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_calendar_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_access_ctrl_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_interactive_report_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_webservices_report_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_ez_report_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_tree_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_svg_chart_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_html_chart_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_help_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_plsql_140x90.gif',140);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wiz_ez_calendar_140x90.gif',140);


-- apex 3.1 128x128 images

insert into wwv_flow_standard_icons(icon_name,icon_size) values ('app_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('biz_users_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('bug_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('convert_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('doc_library_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('eba_tube_featured_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('issue_tracker_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('movie_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('page_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('ws_from_database.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('ws_from_scratch.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('ws_from_template.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('blank_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('home_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('mail_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('globe_americas_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('recycle_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('bug_report_bx_128x128.png',128);

insert into wwv_flow_standard_icons(icon_name,icon_size) values ('users_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wizreport_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('paintbrush_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('report_w_globe_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('interactive_report_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('barchart_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('clusterchart_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('chart_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('monitor_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('db_grey_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('barchart2_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('clusterchart2_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('wizard_bx_128x128.png',128);

insert into wwv_flow_standard_icons(icon_name,icon_size) values ('temperature_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('census_bx_128x128.png',128);

insert into wwv_flow_standard_icons(icon_name,icon_size) values ('modern_printer_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('navigation_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('gear_bx_128x128.png',128);

insert into wwv_flow_standard_icons(icon_name,icon_size) values ('law_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('buildings_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('address_book_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('addresses_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('biz_user_green_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('biz_user_red_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('biz_user_yellow_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('brush_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('calendar_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('camera_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('computer_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('dashboard_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('database_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('db_blue_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('discussion_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('display_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('download_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('eba_admin_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('eba_artwork_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('eba_checklist_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('eba_sales_products_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('eba_software_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('eba_timesheets_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('edit_bx_128x28.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('filmroll_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('flashlight_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('folder_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('generate_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('globe_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('lightbulb_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('openbook_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pencil_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('piechart_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('podcase_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('printer_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('report_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('shapes_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('shoppingcart_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('student_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('upload_bx_128x128.png',128);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('faces128.png',128);

-- apex 3.1 64x64 images
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('address_book_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('addresses_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('flashlight_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pencil_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('camera_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('buildings_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('eba_software_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('eba_timesheets_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('filmroll_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('instructor_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('generate_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('law_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('discussion_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('trash_empty_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('shoppingcart_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('alarm_bell_wbg_64x64.png',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('compass_64.gif',64);


-- apex 3.0 64x64 images
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('users_business_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('application_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('bug_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('calendar_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('client_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('db_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('key_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('disk_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('draw_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('edit_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('folder_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('globe_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('lightbulb_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('chart_line_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('lock_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('navigation_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('package_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('page_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pdf_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('chart_pie_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pin_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('search_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('server_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('shapes_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('spreadsheet_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('users_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('clipboard_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('info_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('prod_apex_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('download_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('memo_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('phone_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('todo_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('mail_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('prod_sqldev_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('news_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('bboard_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('books_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('chart_bar_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('trafficlight_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('folder_yellow_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('report_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('tabform_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('form_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('tree_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('dynamic_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('home_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('login_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('calendar_page_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('chart_page_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('global_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('navigation_page_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('form_proc_page_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('form_wiz_page_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('files_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('ui_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('printer_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('logic_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('trash_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('supporting_obj_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('blank_app_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('browse_db_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('manage_service_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('change_storage_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('dbshare_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('db_tools_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('user_red_64.gif',64);                    
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('user_yellow_64.gif',64);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('user_green_64.gif',64);


-- apex 3.1 32x32
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('trash_empty_32.gif',32); 

-- apex 3.0 32x32
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('users_business_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('application_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('bug_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('calendar_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('client_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('db_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('key_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('disk_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('draw_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('edit_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('folder_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('globe_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('lightbulb_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('chart_line_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('lock_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('navigation_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('package_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('page_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pdf_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('chart_pie_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pin_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('search_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('server_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('shapes_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('spreadsheet_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('users_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('clipboard_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('info_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('prod_apex_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('download_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('memo_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('phone_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('todo_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('mail_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('prod_sqldev_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('news_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('bboard_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('books_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('chart_bar_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('trafficlight_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('folder_yellow_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('report_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('tabform_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('form_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('tree_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('dynamic_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('home_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('login_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('calendar_page_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('chart_page_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('global_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('navigation_page_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('form_proc_page_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('form_wiz_page_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('files_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('ui_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('printer_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('logic_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('trash_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('supporting_obj_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('blank_app_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('browse_db_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('manage_service_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('change_storage_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('dbshare_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('db_tools_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('user_red_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('user_yellow_32.gif',32);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('user_green_32.gif',32);
commit;

-- apex 3.1 20x20   

insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_all_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_arrows_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_boxes_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_branch_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_breadcrumb_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_build_options_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_button_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_computation_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_condition_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_css_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_door_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_files_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_globalization_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_images_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_item_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_list_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_lov_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_messages_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_nav_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_page_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_print_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_process_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_region_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_security_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_security_attr_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_session_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_shortcuts_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_tab_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_template_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_theme_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_translate_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_tree_20.png',20);
insert into wwv_flow_standard_icons(icon_name,icon_size) values ('pt_validation_20.png',20);
commit;





prompt
prompt ...insert into wwv_flow_standard_css
prompt
delete from wwv_flow_standard_css;
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('fielddatabold','.fielddatabold{font-size:10pt; font-weight: bold; color:#000000;}','class="fielddatabold"',null,'ABSOLUTE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('fielddata','.fielddata{font-size:10pt; color:#000000;}','class="fielddata"',null,'ABSOLUTE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('fielddatasmall','.fielddatasmall{font-size:8pt; color:#000000;}','class="fielddatasmall"',null,'ABSOLUTE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('tiny','.tiny {font-size: 7.5pt;}','class="tiny"',null,'ABSOLUTE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('code','.code{font-size:10pt;font-family:"courier new",monospaced;}','class="code"',null,'ABSOLUTE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('black80','.black80{font-size:80%;color:black;}','class="black80"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('black150','.black150{font-size:150%;color:black;}','class="black150"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('black140','.black140{font-size:140%;color:black;}','class="black140"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('black130','.black130{font-size:130%;color:black;}','class="black130"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('black120','.black120{font-size:120%;color:black;}','class="black120"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('black110','.black110{font-size:110%;color:black;}','class="black110"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('black100','.black100{font-size:100%;color:black;}','class="black100"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('black95','.black95{font-size:95%;color:black;}','class="black95"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('black90','.black90{font-size:90%;color:black;}','class="black90"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('black85','.black85{font-size:85%;color:black;}','class="black85"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('white80','.white80{font-size:80%;color:white;}','class="white80"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('white85','.white85{font-size:85%;color:white;}','class="white85"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('white90','.white90{font-size:90%;color:white;}','class="white90"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('white95','.white95{font-size:95%;color:white;}','class="white95"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('white100','.white100{font-size:100%;color:white;}','class="white100"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('white110','.white110{font-size:110%;color:white;}','class="white110"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('white120','.white120{font-size:120%;color:white;}','class="white120"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('white130','.white130{font-size:130%;color:white;}','class="white130"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('white140','.white140{font-size:140%;color:white;}','class="white140"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('white150','.white150{font-size:150%;color:white;}','class="white150"',null,'RELATIVE SIZES');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('a.noline','a.noline:link{text-decoration:none;}
a.noline:visited{text-decoration:none;}','class="noline"',null,'ANCHOR TAGS');
insert into wwv_flow_standard_css (class_name,definition,example_01,example_02,class_category) values ('a.itemLabel','a.itemLabel{color:black;font-size:10pt;}
a.itemLabel:link{text-decoration:none;color:black;}
a.itemLabel:visited{text-decoration:none;color:black;}
a.itemLabel:hover{text-decoration:underline;}
','class="itemLabel"',null,'ANCHOR TAGS');
commit;


prompt
prompt ...insert into wwv_flow_standard_js
prompt
delete from wwv_flow_standard_js;
insert into wwv_flow_standard_js (javascript_name,javascript_syntax,example_01,example_02,example_03) values ('popupURL','popupURL(''URL'');','popupURL(''http://www.oracle.com'');',null,null);
insert into wwv_flow_standard_js (javascript_name,javascript_syntax,example_01,example_02,example_03) values ('doSubmit','doSubmit(''REQUEST'');','doSubmit(''my_request'');',null,null);
commit;



prompt
prompt ...wwv_flow_languages
prompt


delete from wwv_flow_languages;

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (1, 'af', null, 'Afrikaans', 'ENGLISH', 'SOUTH AFRICA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (2, 'ar', null, 'Arabic', 'ARABIC', 'UNITED ARAB EMIRATES', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (3, 'ar-ae', null, 'Arabic (U.A.E.)', 'ARABIC', 'UNITED ARAB EMIRATES', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (4, 'ar-bh', null, 'Arabic (Bahrain)', 'ARABIC', 'BAHRAIN', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (5, 'ar-dz', null, 'Arabic (Algeria)', 'ARABIC', 'ALGERIA', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (6, 'ar-eg', null, 'Arabic (Egypt)', 'EGYPTIAN', 'EGYPT', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (7, 'ar-iq', null, 'Arabic (Iraq)', 'ARABIC', 'IRAQ', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (8, 'ar-jo', null, 'Arabic (Jordan)', 'ARABIC', 'JORDAN', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (9, 'ar-kw', null, 'Arabic (Kuwait)', 'ARABIC', 'KUWAIT', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (10, 'ar-lb', null, 'Arabic (Lebanon)', 'ARABIC', 'LEBANON', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (11, 'ar-ly', null, 'Arabic (Libya)', 'ARABIC', 'LIBYA', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (12, 'ar-ma', null, 'Arabic (Morocco)', 'ARABIC', 'MOROCCO', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (13, 'ar-om', null, 'Arabic (Oman)', 'ARABIC', 'OMAN', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (14, 'ar-qa', null, 'Arabic (Qatar)', 'ARABIC', 'QATAR', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (15, 'ar-sa', null, 'Arabic (Saudi Arabia)', 'ARABIC', 'SAUDI ARABIA', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (16, 'ar-sy', null, 'Arabic (Syria)', 'ARABIC', 'SYRIA', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (17, 'ar-tn', null, 'Arabic (Tunisia)', 'ARABIC', 'TUNISIA', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (18, 'ar-ye', null, 'Arabic (Yemen)', 'ARABIC', 'YEMEN', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (19, 'as', null, 'Assamese', 'ASSAMESE', 'INDIA', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (20, 'be', null, 'Belarusian', 'RUSSIAN', 'RUSSIA', null, 'CL8MSWIN1251');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (21, 'bg', null, 'Bulgarian', 'BULGARIAN', 'BULGARIA', null, 'CL8MSWIN1251');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (22, 'bn', null, 'Bengali', 'BANGLA', 'BANGLADESH', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (23, 'ca', null, 'Catalan', 'CATALAN', 'CATALONIA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (24, 'cs', null, 'Czech', 'CZECH', 'CZECH REPUBLIC', null, 'EE8MSWIN1250');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (25, 'da', null, 'Danish', 'DANISH', 'DENMARK', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (26, 'de', null, 'German (Germany)', 'GERMAN', 'GERMANY', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (27, 'de-at', null, 'German (Austria)', 'GERMAN', 'AUSTRIA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (28, 'de-ch', null, 'German (Switzerland)', 'GERMAN', 'SWITZERLAND', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (29, 'de-li', null, 'German (Liechtenstein)', 'GERMAN', 'GERMANY', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (30, 'de-lu', null, 'German (Luxemgourg)', 'GERMAN', 'LUXEMBOURG', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (31, 'el', null, 'Greek', 'GREEK', 'GREECE', null, 'EL8MSWIN1253');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (32, 'en', null, 'English', 'AMERICAN', 'AMERICA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (33, 'en-au', null, 'English (Australia)', 'ENGLISH', 'AUSTRALIA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (34, 'en-bz', null, 'English (Belize)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (35, 'en-ca', null, 'English (Canada)', 'ENGLISH', 'CANADA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (36, 'en-gb', null, 'English (United Kingdom)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (37, 'en-ie', null, 'English (Ireland)', 'ENGLISH', 'IRELAND', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (38, 'en-jm', null, 'English (Jamaica)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (39, 'en-nz', null, 'English (New Zealand)', 'ENGLISH', 'NEW ZEALAND', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (40, 'en-ph', null, 'English (Philippines)', 'ENGLISH', 'PHILIPPINES', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (41, 'en-tt', null, 'English (Trinidad)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (42, 'en-us', null, 'English (United States)', 'AMERICAN', 'AMERICA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (43, 'en-za', null, 'English (South Africa)', 'ENGLISH', 'SOUTH AFRICA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (44, 'en-zw', null, 'English (Zimbabwe)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (45, 'es', null, 'Spanish (Traditional Sort)', 'SPANISH', 'SPAIN', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (46, 'es-ar', null, 'Spanish (Argentina)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (47, 'es-bo', null, 'Spanish (Bolivia)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (48, 'es-cl', null, 'Spanish (Chile)', 'LATIN AMERICAN SPANISH', 'CHILE', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (49, 'es-co', null, 'Spanish (Columbia)', 'LATIN AMERICAN SPANISH', 'COLOMBIA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (50, 'es-cr', null, 'Spanish (Costa Rica)', 'LATIN AMERICAN SPANISH', 'COSTA RICA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (51, 'es-do', null, 'Spanish (Dominican Republic)', 'LATIN AMERICAN SPANISH', 'PUERTO RICO', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (52, 'es-ec', null, 'Spanish (Ecudor)', 'LATIN AMERICAN SPANISH', 'ECUADOR', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (53, 'es-gt', null, 'Spanish (Guatemala)', 'LATIN AMERICAN SPANISH', 'GUATEMALA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (54, 'es-hn', null, 'Spanish (Honduras)', 'LATIN AMERICAN SPANISH', 'GUATEMALA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (55, 'es-mx', null, 'Spanish (Mexico)', 'MEXICAN SPANISH', 'MEXICO', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (56, 'es-ni', null, 'Spanish (Nicaragua)', 'LATIN AMERICAN SPANISH', 'NICARAGUA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (57, 'es-pa', null, 'Spanish (Panama)', 'LATIN AMERICAN SPANISH', 'PANAMA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (58, 'es-pe', null, 'Spanish (Peru)', 'LATIN AMERICAN SPANISH', 'PERU', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (59, 'es-pr', null, 'Spanish (Peurto Rico)', 'LATIN AMERICAN SPANISH', 'PUERTO RICO', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (60, 'es-py', null, 'Spanish (Paraguay)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (61, 'es-sv', null, 'Spanish (El Salvador)', 'LATIN AMERICAN SPANISH', 'EL SALVADOR', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (62, 'es-us', null, 'Spanish (United States)', 'LATIN AMERICAN SPANISH', 'AMERICA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (63, 'es-uy', null, 'Spanish (Uruguay)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (64, 'es-ve', null, 'Spanish (Venezuela)', 'LATIN AMERICAN SPANISH', 'VENEZUELA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (65, 'et', null, 'Estonian', 'ESTONIAN', 'ESTONIA', null, 'BLT8MSWIN1257');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (66, 'eu', null, 'Basque', 'FRENCH', 'FRANCE', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (67, 'fa', null, 'Farsi', 'ENGLISH', 'UNITED KINGDOM', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (68, 'fi', null, 'Finnish', 'FINNISH', 'FINLAND', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (69, 'fo', null, 'Faeroese', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (70, 'fr', null, 'French (France)', 'FRENCH', 'FRANCE', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (71, 'fr-be', null, 'French (Belgium)', 'FRENCH', 'BELGIUM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (72, 'fr-ca', null, 'French (Canada)', 'CANADIAN FRENCH', 'CANADA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (73, 'fr-ch', null, 'Fench (Switzerland)', 'FRENCH', 'SWITZERLAND', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (74, 'fr-lu', null, 'French (Luxembourg)', 'FRENCH', 'LUXEMBOURG', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (75, 'fr-mc', null, 'French (Monaco)', 'FRENCH', 'FRANCE', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (76, 'gd', null, 'Gaelic', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (77, 'gl', null, 'Galician', 'SPANISH', 'SPAIN', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (78, 'gu', null, 'Gujarati', 'GUJARATI', 'INDIA', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (79, 'he', null, 'Hebrew', 'HEBREW', 'ISRAEL', null, 'IW8MSWIN1255');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (80, 'hi', null, 'Hindi', 'HINDI', 'INDIA', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (81, 'hr', null, 'Croatian', 'CROATIAN', 'CROATIA', null, 'EE8MSWIN1250');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (82, 'hu', null, 'Hungarian', 'HUNGARIAN', 'HUNGARY', null, 'EE8MSWIN1250');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (83, 'id', null, 'Indonesian', 'INDONESIAN', 'INDONESIA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (84, 'is', null, 'Icelandic', 'ICELANDIC', 'ICELAND', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (85, 'it', null, 'Italian (Italy)', 'ITALIAN', 'ITALY', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (86, 'it-ch', null, 'Italian (Switzerland)', 'ITALIAN', 'SWITZERLAND', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (87, 'ja', null, 'Japanese', 'JAPANESE', 'JAPAN', null, 'JA16SJIS');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (88, 'kk', null, 'Kazakh', 'CYRILLIC KAZAKH', 'KAZAKHSTAN', null, 'CL8MSWIN1251');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (89, 'kn', null, 'Kannada', 'KANNADA', 'INDIA', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (90, 'ko', null, 'Korean', 'KOREAN', 'KOREA', null, 'KO16MSWIN949');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (91, 'kok', null, 'Konkani', 'KOREAN', 'KOREA', null, 'KO16MSWIN949');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (92, 'kz', null, 'Kyrgyz', 'RUSSIAN', 'RUSSIA', null, 'CL8MSWIN1251');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (93, 'lt', null, 'Lithuanian', 'LITHUANIAN', 'LITHUANIA', null, 'BLT8MSWIN1257');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (94, 'lv', null, 'Latvian', 'LATVIAN', 'LATVIA', null, 'BLT8MSWIN1257');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (95, 'mk', null, 'FYRO Macedonian', 'MACEDONIAN', 'FYR MACEDONIA', null, 'CL8MSWIN1251');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (96, 'ml', null, 'Malayalam', 'MALAYALAM', 'INDIA', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (97, 'mr', null, 'Marathi', 'MARATHI', 'INDIA', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (98, 'ms', null, 'Malay (Malaysia)', 'MALAY', 'MALAYSIA', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (99, 'mt', null, 'Maltese', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (100, 'nb-no', null, 'Norwegian (Bokmal)', 'NORWEGIAN', 'NORWAY', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (101, 'ne', null, 'Nepali (India)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (102, 'nl', null, 'Dutch (Netherlands)', 'DUTCH', 'THE NETHERLANDS', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (103, 'nl-be', null, 'Dutch (Belgium)', 'DUTCH', 'BELGIUM', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (104, 'nn-no', null, 'Norwegian (Nynorsk)', 'NORWEGIAN', 'NORWAY', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (105, 'no', null, 'Norwegian (Bokmal)', 'NORWEGIAN', 'NORWAY', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (106, 'or', null, 'Oriya', 'ORIYA', 'INDIA', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (107, 'pa', null, 'Punjabi', 'PUNJABI', 'INDIA', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (108, 'pl', null, 'Polish', 'POLISH', 'POLAND', null, 'EE8MSWIN1250');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (109, 'pt', null, 'Portuguese (Portugal)', 'PORTUGUESE', 'PORTUGAL', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (110, 'pt-br', null, 'Portuguese (Brazil)', 'BRAZILIAN PORTUGUESE', 'BRAZIL', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (111, 'ro', null, 'Romanian', 'ROMANIAN', 'ROMANIA', null, 'EE8MSWIN1250');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (112, 'ru', null, 'Russian', 'RUSSIAN', 'RUSSIA', null, 'CL8MSWIN1251');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (113, 'ru-md', null, 'Russian (Moldova)', 'RUSSIAN', 'RUSSIA', null, 'CL8MSWIN1251');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (114, 'sk', null, 'Slovak', 'SLOVAK', 'SLOVAKIA', null, 'EE8MSWIN1250');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (115, 'sl', null, 'Slovenian', 'SLOVENIAN', 'SLOVENIA', null, 'EE8MSWIN1250');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (116, 'sr', null, 'Serbian', 'CYRILLIC SERBIAN', 'SERBIA AND MONTENEGRO', null, 'CL8MSWIN1251');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (117, 'sv', null, 'Swedish', 'SWEDISH', 'SWEDEN', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (118, 'sv-fi', null, 'Swedish (Finland)', 'SWEDISH', 'FINLAND', null, 'WE8MSWIN1252');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (119, 'ta', null, 'Tamil', 'TAMIL', 'INDIA', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (120, 'te', null, 'Telugu', 'TELUGU', 'INDIA', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (121, 'th', null, 'Thai', 'THAI', 'THAILAND', null, 'TH8TISASCII');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (122, 'tr', null, 'Turkish', 'TURKISH', 'TURKEY', null, 'TR8MSWIN1254');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (123, 'uk', null, 'Ukrainian', 'UKRAINIAN', 'UKRAINE', null, 'CL8MSWIN1251');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (124, 'ur', null, 'Urdu', 'ENGLISH', 'UNITED KINGDOM', null, 'AR8MSWIN1256');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (125, 'uz', null, 'Uzbek', 'LATIN UZBEK', 'UZBEKISTAN', null, 'AL32UTF8');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (126, 'vi', null, 'Vietnamese', 'VIETNAMESE', 'VIETNAM', null, 'VN8MSWIN1258');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (127, 'zh', null, 'Chinese', 'SIMPLIFIED CHINESE', 'CHINA', null, 'ZHS16GBK');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (128, 'zh-cn', null, 'Chinese (China)', 'SIMPLIFIED CHINESE', 'CHINA', null, 'ZHS16GBK');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (129, 'zh-hk', null, 'Chinese (Hong Kong SAR)', 'TRADITIONAL CHINESE', 'HONG KONG', null, 'ZHT16MSWIN950');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (130, 'zh-mo', null, 'Chinese (Macau SAR)', 'TRADITIONAL CHINESE', 'HONG KONG', null, 'ZHT16MSWIN950');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (131, 'zh-sg', null, 'Chinese (Singapore)', 'SIMPLIFIED CHINESE', 'SINGAPORE', null, 'ZHS16GBK');

insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset)
 values (132, 'zh-tw', null, 'Chinese (Taiwan)', 'TRADITIONAL CHINESE', 'TAIWAN', null, 'ZHT16MSWIN950');
 
commit;

