Rem  Copyright (c) Oracle Corporation 2006 - 2009. All Rights Reserved.
Rem
Rem    NAME
Rem      apex_views.sql
Rem
Rem    DESCRIPTION
Rem      data dictionary views of Oracle APEX meta data
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem    mhichwa     06/22/2006 - Created
Rem    mhichwa     06/26/2006 - Improved
Rem    mhichwa     06/26/2006 - Added public synonyms and improved where clause
Rem    mhichwa     06/27/2006 - Added views
Rem    mhichwa     06/28/2006 - decoded internal data representations into readable values
Rem    mhichwa     06/29/2006 - Added dictionary comments
Rem    mhichwa     06/29/2006 - Added template dictionary views
Rem    mhichwa     06/30/2006 - Added workspace views
Rem    mhichwa     06/30/2006 - Improved definition of regions and buttons added apex_workspace_files and branches
Rem    mhichwa     07/01/2006 - Added dictionary comments and apex_workspace_sql_scripts view
Rem    mhichwa     07/02/2006 - Added and improved dictionary comments
Rem    mhichwa     07/03/2006 - Added list entries view and improved apex_dictionary
Rem    mhichwa     07/03/2006 - Added supporting object views
Rem    mhichwa     07/04/2006 - Added additional comments
Rem    mhichwa     07/05/2006 - Added additional comments
Rem    mhichwa     07/06/2006 - Added comments, refined queries
Rem    mhichwa     07/07/2006 - Added comments, refined queries
Rem    mhichwa     07/09/2006 - Added comments, refined queries
Rem    jkallman    07/10/2006 - Add proper define character
Rem    msewtz      07/13/2006 - Added missing comments
Rem    jstraub     08/11/2006 - Added views for clickthru logs, bug 5439502
Rem    sspadafo    08/26/2006 - Fixed decode for named_list_of_values in apex_application_page_rpt_cols (Bug 5494575)
Rem    madelfio    08/29/2006 - Fixed spelling errors (Bug 5499606)
Rem    jstraub     08/30/2006 - Removed apex_clicks and augmented apex_workspace_clicks to constrain by SGID
Rem    madelfio    08/30/2006 - Fixed spelling errors (Bug 5499606)
Rem    jkallman    09/29/2006 - Updated schema references to FLOWS_030000
Rem    mhichwa     12/04/2006 - Added signature column
Rem    mhichwa     12/04/2006 - Validations view now returns associated item name and not item id
Rem    mhichwa     12/05/2006 - Fix bug in page_regions view that does not properly report FUNCTION_RETURNING_SQL_QUERY
Rem    mhichwa     12/06/2006 - Added view apex_component_signatures
Rem    jkallman    12/12/2006 - Change apex_component_signatures so it compiles
Rem    mhichwa     12/13/2006 - Added additional component signature columns
Rem    mhichwa     12/13/2006 - removed trailing space from hidden
Rem    mhichwa     12/28/2006 - Added apex_developer_audit_log
Rem    mhichwa     01/02/2007 - Added support for pre_element_text
Rem    mhichwa     01/02/2007 - Added region_id foreign key in apex_application_page_items view per otn forum request
Rem    mhichwa     01/02/2007 - Added region_id foreign key in apex_application_page_buttons view per otn forum request
Rem    mhichwa     01/02/2007 - Added support for regions from cache
Rem    mhichwa     01/02/2007 - apex_application_computations exposed build_option, fixed authorization scheme column
Rem    mhichwa     01/02/2007 - apex_application_processes fixed lookup on build_option
Rem    mhichwa     01/02/2007 - added apex_application_page_items.ITEM_LABEL_TEMPLATE_ID
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_page_items, apex_application_pages, apex_applications
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_page_regions
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_page_rpt_cols, apex_application_page_proc, apex_application_page_comp,
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_page_branches, apex_application_page_val, apex_application_page_buttons,
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to view apex_application_tabs, apex_application_parent_tabs, apex_application_processes
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_computations, apex_application_nav_bar, apex_application_bc_entries
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_list_entries
Rem    mhichwa     01/02/2007 - added build_option_id to apex_application_page_regions
Rem    mhichwa     01/02/2007 - added support for region_caching, timeout_cache_after, cache_when, cache_when_expression_1, cache_when_expression_2
Rem    mhichwa     01/02/2007 - added item_help_text to apex_application_page_items, fixed decode of checkbox display_as column as well
Rem    mhichwa     01/02/2007 - added page_group and page_group_id to apex_application_pages view
Rem    mhichwa     01/05/2007 - improved description of template tables
Rem    jkallman    01/11/2007 - Remove extraneous lines from apex_component_signatures
Rem    cbcho       01/18/2007 - Added POPUP_ICON2,POPUP_ICON_ATTR2 in apex_application_temp_popuplov
Rem    cbcho       01/23/2007 - Added apex_application_page_flash_ch and apex_application_page_flash_s
Rem    mhichwa     01/24/2007 - Added view apex_workspace_access_log, none public
Rem    mhichwa     01/26/2007 - Added view apex_developer_activity_log
Rem    mhichwa     01/29/2007 - Added missing grant select on apex_developer_activity_log to public
Rem    cbcho       02/02/2007 - Added new columns for apex_application_page_flash_ch
Rem    mhichwa     02/02/2007 - Added think time to activity log as well as seconds ago
Rem    cbcho       02/02/2007 - Added new columns to apex_application_page_flash_ch
Rem    mhichwa     02/05/2007 - Added view apex_application_page_groups
Rem    jstraub     02/05/2007 - Added daily_month_title_format to apex_application_temp_calendar
Rem    jstraub     02/06/2007 - Added the rest of new columns to apex_application_temp_calendar
Rem    mhichwa     02/06/2007 - Added apex_application_page_rpt to expose new region printing attributes
Rem    mhichwa     02/07/2007 - Modified apex_dictionary to accomidate new views
Rem    mhichwa     02/07/2007 - Added report column comment attribute to view per user request
Rem    mhichwa     02/09/2007 - Added report header and footer to region view
Rem    jstraub     02/15/2007 - Added region_position_code to apex_application_page_regions (Bug 5879351)
Rem    sspadafo    02/18/2007 - Change views to recognize negative form of build options
Rem    sspadafo    02/18/2007 - Changed a couple references to REQUIRED_PATCH to SECURITY_SCHEME
Rem    sspadafo    02/18/2007 - Changed 3 occurrences of "chucksum" to "checksum"
Rem    mhichwa     02/19/2007 - Added comments on component signature columns
Rem    mhichwa     02/20/2007 - Added cached pages and cached regions counts to apex_applictions view
Rem    mhichwa     02/20/2007 - Added missing columns to apex_application_pages
Rem    mhichwa     02/20/2007 - Added referenced owner, table and column to APEX_APPLICATION_PAGE_RPT_COLS view
Rem    mhichwa     02/23/2007 - Added view apex_application_caching view
Rem    mhichwa     02/23/2007 - Added comment for apex_application_caching.page_id column
Rem    mhichwa     02/23/2007 - Improved reporting of page zero region caching in apex_application_caching view
Rem    mhichwa     02/26/2007 - Improved apex_application_auth, added apex_application_substitutions
Rem    mhichwa     02/26/2007 - Improved apex_application_authorization, apex_application_lovs, apex_application_nav_bar
Rem    mhichwa     02/26/2007 - Improved apex_application_page_buttons
Rem    mhichwa     02/28/2007 - Added component_signature column apex_application_page_comp
Rem    mhichwa     02/28/2007 - Added 30 display types to apex_application_page_items
Rem    mhichwa     02/28/2007 - Added when_button_pressed_id column to facilitate joins to buttons table in APEX_APPLICATION_PAGE_PROC
Rem    mhichwa     02/28/2007 - APEX_APPLICATION_PAGE_REGIONS added customization, customization_name, list_template_override_id, HTML_table_cell_attributes
Rem    mhichwa     02/28/2007 - Unioned apex_application_page_comp into component_signatures view
Rem    mhichwa     03/02/2007 - Added last_purged_session column to apex_workspaces view to report last session information bug 5912733
Rem    mhichwa     03/09/2007 - Exposed MultiColumn_Region_Table_Attr column in APEX_APPLICATION_TEMP_PAGE view, bug 5920988
Rem    mhichwa     03/09/2007 - Fixed bug in apex_application_computations with null of c.SECURITY_SCHEME not required patch.  Bug 5920988
Rem    mhichwa     03/15/2007 - Exposed static_id column in apex_application_page_regions, this is wwv_flow_page_plugs.region_name, bug 5936078
Rem    mhichwa     03/15/2007 - Exposed max_dynamic_report_cols in apex_application_page_regions, bug 5936078
Rem    mhichwa     03/15/2007 - Exposed report_column_source_type in apex_application_page_regions, bug 5936078
Rem    mhichwa     03/15/2007 - Exposed PLUG_QUERY_HEADINGS_TYPE in apex_application_page_regions, bug 5936078
Rem    mhichwa     03/15/2007 - Exposed break_display_text in apex_application_page_regions, bug 5936078
Rem    mhichwa     05/01/2007 - 5936078 Added apex_application_page_regions.breadcrumb_template and apex_application_page_regions.breadcrumb_template_id
Rem    mhichwa     05/01/2007 - 5936078 Added  report_template_id
Rem    mhichwa     05/02/2007 - 5936078 Added page function to apex_application_pages view
Rem    mhichwa     05/02/2007 - 5936078 Properly compute number of items and buttons in apex_application_pages view
Rem    mhichwa     05/02/2007 - 5936078 Added list entries column to apex_application_lists view
Rem    mhichwa     05/02/2007 - 5936078 Properly report authentication scheme in the apex_applictions view
Rem    mhichwa     05/02/2007 - 5936078 Added workspace id to apex applications view to facilitate joins with workspace view
Rem    mhichwa     05/02/2007 - 5936078 Added workspace id to apex_workspace_activity_log
Rem    jstraub     05/04/2007 - 6034426 Added apex_release
Rem    jstraub     05/08/2007 - Added api_compatibility and patch_applied to apex_release
Rem    mhichwa     05/09/2007 - Reworked view apex_workspace_files to have it properly return file names and work from SQL Developer
Rem    mhichwa     05/09/2007 - Removed extra sub query from apex_workspace_files
Rem    mhichwa     05/18/2007 - Extended where clause on most views
Rem    mhichwa     05/25/2007 - Changed application_comment_id to application_computation_id (bug 6075191)
Rem    mhichwa     05/31/2007 - Changed apex_workspace_schemas view to use nvl 0, and not nvl _ to avoid an invalid number error from sql dev (bug 6085543)
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_applications
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_workspace_schemas
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_workspace_sessions
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_workspace_apex_users
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_pages
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_groups
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_items
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_get_pg_tname
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_db_items
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_regions
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_rpt
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_rpt_cols
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_proc
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_comp
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_branches
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_buttons
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_build_options
Rem    madelfio    06/05/2007 - Added columns for upgrade scripts to apex_application_supp_objects and apex_application_supp_obj_scr (Bug 6114786)
Rem    mhichwa     06/13/2007 - bug 6130280 Use 0 not '_' in nvl calls in apex_workspaces and other views to prevent invalid number oracle error
Rem    sspadafo    06/29/2007 - Fixed transposed column names of last_updated_by/last_updated_on in apex_application_translations and apex_application_trees
Rem    sspadafo    06/30/2007 - Revised comment on table apex_workspace_files
Rem    jkallman    08/02/2007 - Change FLOWS_030000 references to FLOWS_030100
Rem    madelfio    08/16/2007 - Added views for apex worksheets
Rem    jstraub     08/23/2007 - Added apex_appliation_page_wsrcat
Rem    jstraub     08/24/2007 - Fixed apex_appliation_page_wsrcat
Rem    jstraub     08/27/2007 - Added parent_category_id to apex_appliation_page_wsrcat, removed parent_category
Rem    jstraub     08/28/2007 - Added category_id to apex_application_page_wsrpts
Rem    madelfio    09/05/2007 - Removed bad filter in apex_appliation_page_wsrpts definition
Rem    jstraub     10/09/2007 - Added description to apex_application_page_wsrpts
Rem    mhichwa     10/16/2007 - Added support for item_is_not_numeric condition type
Rem    jkallman    10/16/2007 - Added media_type to apex_applications and apex_application_pages
Rem    mhichwa     10/24/2007 - Added application_group and application_group_id columns to apex_applications view
Rem    mhichwa     10/24/2007 - Added apex_application_groups view
Rem    madelfio    11/01/2007 - Added apex_application_page_wsrpts.display_sequence
Rem    jkallman    11/19/2007 - Added date_format to apex_applications
Rem    mhichwa     11/20/2007 - Removed where clause on apex_applications to show run only applications
Rem    jkallman    11/20/2007 - Added PICK_DATE_USING_APP_DATE_FORMAT to apex_application_page_items
Rem    mhichwa     11/28/2007 - Added runtime_where_clause to page_proc view, and theme_description to theme view
Rem    mhichwa     11/29/2007 - fixed bug in apex_applications view
Rem    mhichwa     11/30/2007 - Added 'P','Partial Page' to activity log decode
Rem    sspadafo    12/01/2007 - Added 'HIDDEN_PROTECTED' to item type decodes
Rem    jstraub     12/03/2007 - Added ajax_enabled to apex_application_page_regions
Rem    jstraub     12/03/2007 - Added before_column_heading and after_column_heading to apex_application_temp_report
Rem    mhichwa     12/05/2007 - Added support for logging of page processing
Rem    jstraub     12/10/2007 - Added prn_print_server_overwrite to apex_application_page_rpt
Rem    mhichwa     12/10/2007 - Removed box_footer_text body_footer page attribute from apex_appliation_pages view
Rem    mhichwa     12/11/2007 - Added support for the region attributes substitution string
Rem    jstraub     12/12/2007 - Added prn_content_disposition, prn_document_header, prn_units to apex_application_page_rpt
Rem    mhichwa     01/04/2008 - Rename apex_worksheet_columns to apex_appliation_page_wsrptc
Rem    mhichwa     01/04/2008 - Rename apex_worksheet_rpts to apex_appliation_page_wsrpts
Rem    mhichwa     01/04/2008 - Rename apex_worksheet_categories to apex_appliation_page_wsrcat
Rem    mhichwa     01/04/2008 - Renamed IR column worksheet_id to interactive_report_id
Rem    mhichwa     01/07/2008 - Added INCLUDE_APEX_CSS_JS_YN column bug 6706084
Rem    hfarrell    01/11/2008 - Added Migration Project views from mig_views.sql with naming convention APEX_MIGRATION_object
Rem    jkallman    01/11/2008 - Corrected typos in views APEX_APPLICATION_PAGE_WSRPTC and APEX_APPLICATION_PAGE_WSRCAT
Rem    jkallman    01/11/2008 - Remove migration views
Rem    sbkenned    01/16/2008 - added APEX_UI_DEFAULTS_TABLES, APEX_UI_DEFAULTS_COLUMNS, and APEX_UI_DEFAULTS_LOV_DATA
Rem    sbkenned    01/16/2008 - fixed APEX_APPLICATION_GROUPS (bug 6752552)
Rem    madelfio    01/18/2008 - Added page_id to apex_application_page_wsrpts
Rem    madelfio    01/24/2008 - Added/updated interactive report views
Rem    madelfio    01/25/2008 - Added/updated interactive report views
Rem    mhichwa     02/15/2008 - Changed apex_application_pages to lookup page auth scheme name
Rem    madelfio    02/15/2008 - Added component signatures for _IR views (bug 6792835)
Rem    jkallman    02/21/2008 - Moved interactive reports views before component signature views
Rem    madelfio    02/21/2008 - Fixed issues with interactive reports in APEX views (bug 6835427)
Rem    cbcho       04/09/2008 - Added apex_themes (bug 6934007)
Rem    mhichwa     04/10/2008 - Added apex_application_temp_report.template_id column (bug 6952089)
Rem    jkallman    05/16/2008 - Change apex_ui views to create or replace, to make apex_views rereunnable
Rem    cbcho       05/21/2008 - Added inclusion of apex_themes in apex_dictionary (bug 7111415)
Rem    sspadafo    08/06/2008 - Added check_id to apex_application_supp_obj_chck. Added column comment also. (Bug 7120472)
Rem    sspadafo    08/06/2008 - Changed apex_application_supp_obj_scr to return i.id as supporting_object_script_id (Bug 7120472)
Rem    sspadafo    08/06/2008 - Adjustments to apex_dictionary to correct child-parent associations (Bug 7043109)
Rem    sspadafo    08/13/2008 - Adjustment to apex_dictionary to add missing trailing slashes and to make apex_application_page_regions the parent of apex_application_page_ir (Bug 7043109)
Rem    jkallman    09/09/2008 - Change FLOWS_030100 references to APEX_030200
Rem    jstraub     12/17/2008 - Added form_autocomplete to apex_application_pages
Rem    jkallman    12/18/2008 - Added application_info to apex_workspace_activity_log
Rem    sspadafo    12/26/2008 - Added support for encryption in apex_application_page_items
Rem    jstraub     12/29/2008 - Added PASSWORD DNSS to apex_application_page_items
Rem    sspadafo    01/03/2009 - Added use_secure_cookie_yn to apex_application_auth
Rem    mhichwa     01/06/2009 - corrected decode for item types _DNSS
Rem    mhichwa     01/06/2009 - fixed  page_requires_Authentication column
Rem    sspadafo    01/09/2009 - Added save_state_before_branch_yn to apex_application_page_branches
Rem    sspadafo    01/09/2009 - Fixed component_signature for page_is_public_yn in apex_application_pages
Rem    sspadafo    01/09/2009 - Added session timeout columns to apex_applications
Rem    sspadafo    01/12/2009 - Fixed comments on session timeout columns in apex_applications and save_state_before_branch in apex_application_page_branches
Rem    mhichwa     02/04/2009 - Changed comment
Rem    jkallman    05/06/2009 - Added column column_expr to apex_application_page_ir_col (Bug 8494970)
Rem    sspadafo    05/12/2009 - Changed several views to correct build option error (Bug 8512898)
Rem    jkallman    05/15/2009 - Remove restriction on viewing components within translated applications (merged MHichwa changes from 4.0 branch)
Rem    jkallman    05/15/2009 - Correct apex_application_trans_map to join to wwv_flows


set define '^'

prompt creating apex dictionary views


--------------------------------------------
-- W O R K S P A C E S
--
prompt ...apex_workspace views

create or replace view apex_workspaces as
select
    w.short_name                                        workspace,
    --w.FIRST_SCHEMA_PROVISIONED                          first_schema_provisioned,
    --
    count(distinct s.schema)                            schemas,
    max(w.LAST_LOGIN)                                   last_purged_session,
    --
    (select count(*)
     from wwv_flow_sessions$
     where security_group_id =
           w.PROVISIONING_COMPANY_ID)                   sessions,
    --
    (select count(*)
     from   wwv_flows
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  applications,
    --
    (select count(*)
     from   wwv_flow_steps
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  application_pages,
    --
    (select count(*)
     from   wwv_flow_fnd_user
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  apex_users,
    --
    (select count(*)
     from wwv_flow_developers d, wwv_flow_fnd_user u
     where (instr(nvl(d.developer_role,'x'),'EDIT') > 0 or
            instr(nvl(d.developer_role,'x'),'ADMIN') > 0 ) and
           d.security_group_id = w.PROVISIONING_COMPANY_ID and
           u.security_group_id = w.PROVISIONING_COMPANY_ID and
           d.userid = u.user_name)
                                                        apex_developers,
    --
    (select count(*)
     from   wwv_flow_developers d, wwv_flow_fnd_user u
     where  instr(nvl(d.developer_role,'x'),'ADMIN') > 0  and
           d.security_group_id = w.PROVISIONING_COMPANY_ID and
           u.security_group_id = w.PROVISIONING_COMPANY_ID and
           d.userid = u.user_name)
                                                        apex_workspace_administrators,
    --
    (select count(*)
     from    WWV_FLOW_FILE_OBJECTS$
     where   security_group_id =
            w.PROVISIONING_COMPANY_ID and
            to_char(deleted_as_of,
            'MM.DD.YYYY') = '01.01.0001')               files,
    --
    (select count(*)
     from    WWV_FLOW_FILE_OBJECTS$
     where   security_group_id =
            w.PROVISIONING_COMPANY_ID and
            FILE_TYPE = 'SCRIPT' and
            to_char(deleted_as_of,
            'MM.DD.YYYY') = '01.01.0001')               sql_scripts,
    --
    (select count(*)
     from   WWV_FLOW_MESSAGES$
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  translation_messages,
    --
    (select sum(doc_size)
     from    WWV_FLOW_FILE_OBJECTS$
     where   security_group_id =
            w.PROVISIONING_COMPANY_ID)                  file_storage,
    --
    (select max(time_stamp)
     from   wwv_flow_activity_log
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  last_logged_page_view,
     --
     (select count(*)
     from   wwv_flow_activity_log
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID and
            TIME_STAMP > sysdate - 14)                  page_views,
     --
     w.PROVISIONING_COMPANY_ID                          workspace_id
from
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
group by  w.PROVISIONING_COMPANY_ID, w.short_name, w.FIRST_SCHEMA_PROVISIONED
/

comment on table  apex_workspaces                                is 'Available Application Express (Apex) workspaces';
comment on column apex_workspaces.workspace_id                   is 'Primary key that identifies the workspace';
comment on column apex_workspaces.workspace                      is 'A work area mapped to one or more database schemas';
comment on column apex_workspaces.schemas                        is 'Number of database schemas currently mapped to this workspace';
comment on column apex_workspaces.workspace                      is 'A work area mapped to one or more database schemas';
comment on column apex_workspaces.last_purged_session            is 'Creation date of the most recently purged session.  Used to track last login for workspaces who no longer have entries in the activity log.';
comment on column apex_workspaces.sessions                       is 'Number of non-purged Apex sessions';
comment on column apex_workspaces.applications                   is 'Number of applications created in this workspace';
comment on column apex_workspaces.application_pages              is 'Number of application pages created in this workspace';
comment on column apex_workspaces.apex_users                     is 'Number of Apex users created in this workspace';
comment on column apex_workspaces.apex_developers                is 'Number of Apex users with developer privilege';
comment on column apex_workspaces.apex_workspace_administrators  is 'Number of Apex users with workspace administrator privilege';
comment on column apex_workspaces.files                          is 'Number of Apex files associated with the workspace';
comment on column apex_workspaces.sql_scripts                    is 'Number of Apex SQL Scripts associated with the workspace';
comment on column apex_workspaces.translation_messages           is 'Number of translatable and translated messages within the workspace';
comment on column apex_workspaces.file_storage                   is 'Size in bytes of all files associated with the workspace';
comment on column apex_workspaces.last_logged_page_view          is 'Date of most recent page view from the Apex activity log';
comment on column apex_workspaces.page_views                     is 'Count of page views recorded for this workspace in the Apex activity log for the last 2 weeks';
grant select on   apex_workspaces to public;



create or replace view apex_workspace_files
as
select
    w.PROVISIONING_COMPANY_ID                           workspace_id,
    w.short_name                                        workspace_name,
    files.id                                            file_id,
    files.flow_id                                       application_id,
    f.name                                              application_name,
    nvl(files.title,files.filename)                     file_name,
    files.mime_type                                     mime_type,
    files.doc_size                                      file_size,
    files.created_by                                    created_by,
    (select max(email_address)
    from wwv_flow_fnd_user
    where security_group_id = w.PROVISIONING_COMPANY_ID
    and user_name=files.created_by)                     email,
    files.created_on                                    created_on,
    decode(files.file_type,
      'FLOW_EXPORT','Application Export',
      'IMAGE_EXPORT','Text Image Export',
      'PAGE_EXPORT','Application Page Export',
      'SCRIPT','SQL Script',
      'THEME','User Interface Theme Export',
      'XLIFF','XLIFF Application Translation Export',
      files.file_type)                                  file_type,
    files.blob_content                                  document
from WWV_FLOW_FILE_OBJECTS$ files,
     wwv_flows f,
     wwv_flow_company_schemas s,
     wwv_flow_companies w,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      (s.schema = f.owner or f.owner is null) and
      to_char(deleted_as_of,'MM.DD.YYYY') = '01.01.0001' and
      files.flow_id = f.id(+) and
      files.security_group_id = w.PROVISIONING_COMPANY_ID and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY' or f.name is null) and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_workspace_files                     is 'Identifies uploaded files belonging to the workspace in the modplsql or EPG documents table';
comment on column apex_workspace_files.workspace_id        is 'Primary key that identifies the workspace';
comment on column apex_workspace_files.workspace_name      is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_files.file_id             is 'Primary key that identifies the file';
comment on column apex_workspace_files.application_id      is 'Application Primary Key, Unique over all workspaces';
comment on column apex_workspace_files.application_name    is 'Identifies the application';
comment on column apex_workspace_files.created_by          is 'Name of the Apex user who created the file';
comment on column apex_workspace_files.email               is 'Email address that corresponds to the Apex user name';
comment on column apex_workspace_files.created_on          is 'Date the file was created';
comment on column apex_workspace_files.file_name           is 'Name of the file stored in a database BLOB';
comment on column apex_workspace_files.mime_type           is 'Mime type of the file used when fetching the file over the web';
comment on column apex_workspace_files.DOCUMENT            is 'The file';
comment on column apex_workspace_files.FILE_SIZE           is 'Size of the file';
comment on column apex_workspace_files.CREATED_BY          is 'Identifies the Apex User Name who created the file';
comment on column apex_workspace_files.CREATED_ON          is 'Identifies the date the file was loaded into the database BLOB';
comment on column apex_workspace_files.FILE_TYPE           is 'Identifies the Apex file type if available';
grant select on   apex_workspace_files to public;



create or replace view apex_workspace_sql_scripts
as
select
    w.PROVISIONING_COMPANY_ID   workspace_id,
    w.short_name                workspace_name,
    f.filename                  sql_script_name,
    (select max(email_address)
    from wwv_flow_fnd_user
    where security_group_id = w.PROVISIONING_COMPANY_ID
    and user_name=f.created_by) email,
    --
    --f.title                     file_name,
    f.mime_type                 mime_type,
    f.doc_size                  file_size,
    f.created_by                owner,
    f.blob_content              sql_script
from
    wwv_flow_file_objects$ f,
    wwv_flow_companies w
where
    f.security_group_id = w.PROVISIONING_COMPANY_ID and
    to_char(f.deleted_as_of,'MM.DD.YYYY') = '01.01.0001' and
    f.file_type = 'SCRIPT' and
    w.PROVISIONING_COMPANY_ID in (
       select security_group_id
       from   wwv_flow_company_schemas s,
              (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
       where  (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200') or d.sgid = s.security_group_id) ) and
    (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/


comment on table  apex_workspace_sql_scripts                     is 'Identifies SQL Scripts used to execute SQL and PL/SQL commands';
comment on column apex_workspace_sql_scripts.workspace_id        is 'Primary key that identifies the workspace';
comment on column apex_workspace_sql_scripts.workspace_name      is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_sql_scripts.sql_script_name     is 'Identifies name of the SQL Script';
comment on column apex_workspace_sql_scripts.EMAIL               is 'Identifies email address that corresponds to the Apex User Name who owns the SQL Script';
comment on column apex_workspace_sql_scripts.MIME_TYPE           is 'Mime type associated with the file';
comment on column apex_workspace_sql_scripts.FILE_SIZE           is 'Size of the file in the BLOB';
comment on column apex_workspace_sql_scripts.OWNER               is 'Identifies the Apex User Name who crated and owns the SQL Script';
comment on column apex_workspace_sql_scripts.SQL_SCRIPT          is 'The SQL Script file';
grant select on   apex_workspace_sql_scripts to public;



create or replace view apex_workspace_sessions as
select
    w.workspace_id                                      workspace_id,
    w.workspace_name                                    workspace_name,
    s.id                                                apex_session_id,
    s.cookie                                            user_name,
    s.created_on                                        session_created
from
    wwv_flow_sessions$ s,
(
select
    w.PROVISIONING_COMPANY_ID                           workspace_id,
    w.short_name                                        workspace_name,
    w.FIRST_SCHEMA_PROVISIONED                          first_schema_provisioned
from
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
group by  w.PROVISIONING_COMPANY_ID, w.short_name, w.FIRST_SCHEMA_PROVISIONED
) w
where s.SECURITY_GROUP_ID = w.workspace_id
/


comment on table  apex_workspace_sessions                    is 'Application Express (Apex) sessions by workspace and Apex user';
comment on column apex_workspace_sessions.workspace_id       is 'Primary key that identifies the workspace';
comment on column apex_workspace_sessions.workspace_name     is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_sessions.apex_session_id    is 'Primary key of the apex session';
comment on column apex_workspace_sessions.user_name          is 'Name of the authenticated or public user';
comment on column apex_workspace_sessions.session_created    is 'Date the Apex session was created';
grant select on apex_workspace_sessions to public;



create or replace view apex_workspace_apex_users as
select
    workspace_id,
    workspace_name,
    first_schema_provisioned,
    user_name,
    email,
    date_created,
    date_last_updated,
    available_schemas,
    substr(decode(instr(nvl(role_privs,'x'),'ADMIN'),0,'No','Yes'),1,3)  is_admin,
    substr(decode(instr(nvl(role_privs,'x'),'EDIT'),0,'No','Yes'),1,3)   is_application_developer
from (
select
    w.PROVISIONING_COMPANY_ID                                         workspace_id,
    w.short_name                                                      workspace_name,
    w.FIRST_SCHEMA_PROVISIONED                                        first_schema_provisioned,
    u.user_name                                                       user_name,
    u.EMAIL_address                                                   email,
    u.CREATION_DATE                                                   date_created,
    u.LAST_UPDATE_DATE                                                date_last_updated,
    count(distinct s.schema)                                          available_schemas,
    (select developer_role
     from wwv_flow_developers
     where userid = u.user_name and
           security_group_id = w.PROVISIONING_COMPANY_ID)
                                                                      role_privs
from
     wwv_flow_fnd_user u,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      u.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = u.security_group_id and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
group by  w.PROVISIONING_COMPANY_ID, w.short_name, w.FIRST_SCHEMA_PROVISIONED, u.user_name, u.EMAIL_address, u.CREATION_DATE, u.LAST_UPDATE_DATE
) ilv
/

comment on table  apex_workspace_apex_users                          is 'Application Express (Apex) users';
comment on column apex_workspace_apex_users.workspace_id             is 'Primary key that identifies the workspace';
comment on column apex_workspace_apex_users.workspace_name           is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_apex_users.first_schema_provisioned is 'The associated database schema identified when this workspace was created';
comment on column apex_workspace_apex_users.user_name                is 'The Apex user name used to authenticate to an Apex web page or Apex application';
comment on column apex_workspace_apex_users.email                    is 'The email associated with this Apex user';
comment on column apex_workspace_apex_users.date_created             is 'The date the Apex user was created';
comment on column apex_workspace_apex_users.date_last_updated        is 'The date the Apex user definition was last updated';
comment on column apex_workspace_apex_users.available_schemas        is 'The number of database schemas available to the workspace developer';
comment on column apex_workspace_apex_users.is_admin                 is 'Identifies if the Apex user has Apex workspace administration privilege';
comment on column apex_workspace_apex_users.is_application_developer is 'Identifies if the Apex user has Apex application development privilege';
grant select on apex_workspace_apex_users to public;



create or replace view apex_workspace_developers as
select *
from apex_workspace_apex_users
where is_application_developer = 'Yes'
/

comment on table  apex_workspace_developers                          is 'Application Express (Apex) developers, Apex users with privilege to develop applications';
comment on column apex_workspace_developers.workspace_id             is 'Primary key that identifies the workspace';
comment on column apex_workspace_developers.workspace_name           is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_developers.first_schema_provisioned is 'The associated database schema identified when this workspace was created';
comment on column apex_workspace_developers.user_name                is 'The Apex user name used to authenticate to an Apex web page or Apex application';
comment on column apex_workspace_developers.email                    is 'The email associated with this Apex user';
comment on column apex_workspace_developers.date_created             is 'The date the Apex user was created';
comment on column apex_workspace_developers.date_last_updated        is 'The date the Apex user definition was last updated';
comment on column apex_workspace_developers.available_schemas        is 'The number of database schemas available to the workspace developer';
comment on column apex_workspace_developers.is_admin                 is 'Identifies if the Apex user has Apex workspace administration privilege';
comment on column apex_workspace_developers.is_application_developer is 'Identifies if the Apex user has Apex application development privilege';
grant select on   apex_workspace_developers to public;




create or replace view apex_workspace_schemas as
select
    w.PROVISIONING_COMPANY_ID                           workspace_id,
    w.short_name                                        workspace_name,
    w.FIRST_SCHEMA_PROVISIONED                          first_schema_provisioned,
    s.schema                                            schema,
    (select created
     from   all_users
     where  username = s.schema)                        schema_created,
    (select count(*)
     from wwv_flows
     where security_group_id=w.PROVISIONING_COMPANY_ID
      and s.schema = owner)                             applications
from wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where
     (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_workspace_schemas                          is 'Database Schemas mapped to Apex workspaces';
comment on column apex_workspace_schemas.workspace_id             is 'Primary key that identifies the workspace';
comment on column apex_workspace_schemas.workspace_name           is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_schemas.first_schema_provisioned is 'The associated database schema identified when this workspace was created';
comment on column apex_workspace_schemas.schema                   is 'Database schema name mapped to workspace';
comment on column apex_workspace_schemas.schema_created           is 'Identifies the date that the database schema was created';
comment on column apex_workspace_schemas.applications             is 'Number of applications within the current workspace and schema';

grant select on apex_workspace_schemas to public
/

--------------------------------------------
-- A P P L I C A T I O N S
-- 4001
prompt ...apex_applications

create or replace view apex_applications as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    f.ALIAS                          alias,
    f.OWNER                          owner,
    (select group_name from wwv_flow_application_groups where id = f.group_id) application_group,
    group_id                         application_group_id,
    f.HOME_LINK                      home_link,
    (select name
     from wwv_flow_templates
     where id = f.DEFAULT_PAGE_TEMPLATE)
                                     page_template,
    (select name
     from wwv_flow_templates
     where id = f.ERROR_TEMPLATE)    error_page_template,
    decode(upper(f.WEBDB_LOGGING),
        'YES','Yes',
        'NO','No',f.WEBDB_LOGGING)   logging,
    f.FLOW_LANGUAGE                  application_primary_language,
    f.FLOW_LANGUAGE_DERIVED_FROM     language_derived_from,
    f.date_format                    date_format,
    f.FLOW_IMAGE_PREFIX              image_prefix,
    decode(f.AUTHENTICATION,
        'CUSTOM2','Authentication Scheme',
        'COOKIE', 'APEX Authentication',
        f.AUTHENTICATION)            authentication_scheme_type,
    f.LOGIN_URL                      login_url,
    f.LOGOUT_URL                     logout_url,
    decode(substr(f.LOGO_IMAGE,1,5),
       'TEXT:','Text Logo',
       'Image Logo')                 logo_type,
    f.LOGO_IMAGE                     logo,
    f.LOGO_IMAGE_ATTRIBUTES          logo_attributes,
    --f.PUBLIC_URL_PREFIX              public_url_prefix,
    f.PUBLIC_USER                    public_user,
    --f.DBAUTH_URL_PREFIX              db_auth_url_prefix,
    f.PROXY_SERVER                   proxy_server,
    f.media_type                     media_type,
    --
    (select max(ss.name) n from wwv_flow_custom_auth_setups ss where flow_id = f.id and instr(f.CUSTOM_AUTHENTICATION_PROCESS,to_char(id)) > 0)
                                       authentication_scheme,
    --f.CUSTOM_AUTHENTICATION_PAGE     custom_auth_page,
    --f.CUSTOM_AUTH_LOGIN_URL          custom_auth_login_url,
    f.FLOW_VERSION                     version,
    decode(f.FLOW_STATUS,
        'AVAILABLE','Available',
        'AVAILABLE_W_EDIT_LINK','Available with Edit Links',
        'DEVELOPERS_ONLY','Available to Developers Only',
        'RESTRICTED_ACCESS','Restricted Access',
        'UNAVAILABLE','Unavailable',
        'UNAVAILABLE_PLSQL','Unavailable (Status Shown with PL/SQL)',
        'UNAVAILABLE_URL','Unavailable (Redirect to URL)',
        f.flow_status)               availability_status,
    f.FLOW_UNAVAILABLE_TEXT          unavailable_text,
    f.RESTRICT_TO_USER_LIST          restrict_to_user,
    decode(f.APPLICATION_TAB_SET,
        1,'Allowed',0,'Not Allowed',
        'Allowed')                   debugging,
    decode(f.EXACT_SUBSTITUTIONS_ONLY,
       'N','No','Y','Yes',
       f.EXACT_SUBSTITUTIONS_ONLY)   exact_substitutions,
    decode(f.BUILD_STATUS,
       'RUN_ONLY','Run Only',
       'RUN_AND_BUILD','Run and Develop',
       f.BUILD_STATUS)               build_status,
    f.VPD                            vpd,
    --
    decode(substr(f.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(f.SECURITY_SCHEME,'!')
     and    flow_id = f.id),
     f.SECURITY_SCHEME)              authorization_scheme,
    f.security_scheme                authorization_scheme_id,
    --f.REJOIN_EXISTING_SESSIONS       rejoin_sessions,
    f.LAST_UPDATED_BY                last_updated_by,
    f.LAST_UPDATED_ON                last_updated_on,
    f.THEME_ID                       theme_number,
    f.GLOBAL_NOTIFICATION            global_notification,
    decode(f.PAGE_PROTECTION_ENABLED_Y_N,
      'Y','Enabled',
      'N','Disabled',
      'Disabled')                    Session_State_Protection,
    MAX_SESSION_LENGTH_SEC           Maximum_Session_Life_Seconds,
    ON_MAX_SESSION_TIMEOUT_URL       Session_Lifetime_Exceeded_URL,
    MAX_SESSION_IDLE_SEC             Maximum_Session_Idle_Seconds,
    ON_MAX_IDLE_TIMEOUT_URL          Session_Idle_Time_Exceeded_URL,
    -- sub components
    (select count(*) from wwv_flow_steps where flow_id = f.id)               pages,
    (select count(*) from wwv_flow_tabs where flow_id = f.id)                tabs,
    (select count(*) from wwv_flow_toplevel_tabs where flow_id = f.id)       parent_tabs,
    (select count(*) from wwv_flow_items where flow_id = f.id)               application_items,
    (select count(*) from wwv_flow_processing where flow_id = f.id)          application_processes,
    (select count(*) from wwv_flow_computations where flow_id = f.id)        application_computations,
    (select count(*) from wwv_flow_shortcuts where flow_id = f.id)           shortcuts,
    (select count(*) from wwv_flow_shared_web_services where flow_id = f.id) web_services,
    (select count(*) from wwv_flow_trees where flow_id = f.id)               trees,
    (select count(*) from wwv_flow_patches where flow_id = f.id)             build_options,
    (select count(*) from wwv_flow_menus where flow_id = f.id)               breadcrumbs,
    (select count(*) from wwv_flow_icon_bar where flow_id = f.id)            nav_bar_entries,
    (select count(*) from wwv_flow_lists where flow_id = f.id)               lists,
    (select count(*) from wwv_flow_lists_of_values$ where flow_id = f.id)    lists_of_values,
    (select count(*) from wwv_flow_themes where flow_id = f.id)              themes,
    (select count(*) from wwv_flow_custom_auth_setups where flow_id = f.id)  authentication_schemes,
    (select count(*) from WWV_FLOW_SECURITY_SCHEMES where flow_id = f.id)    authorization_schemes,
    (select count(*) from WWV_FLOW_MESSAGES$ where flow_id = f.id)           translation_messages,
    (select count(*) from wwv_flow_install_scripts where flow_id = f.id)     installation_scripts,
    (select count(*) from WWV_FLOW_STEPS where flow_id = f.id and CACHE_PAGE_YN = 'Y') cached_pages,
    (select count(*) from WWV_FLOW_PAGE_PLUGS where flow_id = f.id and PLUG_CACHING in ('CACHED','CACHED_BY_USER')) cached_regions,
    --
    'a='||f.ALIAS
    ||' o='||f.OWNER
    ||' h='||substr(f.HOME_LINK,1,20)||length(f.home_link)
    ||' t='||(select name
     from wwv_flow_templates
     where id = f.DEFAULT_PAGE_TEMPLATE)
    ||' l='||decode(upper(f.WEBDB_LOGGING),'YES','Yes','NO','No',f.WEBDB_LOGGING)
    ||' l='||f.FLOW_LANGUAGE||' '||f.FLOW_LANGUAGE_DERIVED_FROM
    ||' i='||substr(f.FLOW_IMAGE_PREFIX,1,20)||length(f.FLOW_IMAGE_PREFIX)
    ||' a='||substr(f.AUTHENTICATION,1,20)||length(f.AUTHENTICATION)
    ||' l='||substr(f.LOGIN_URL,1,20)||length(f.LOGIN_URL)
    ||' l='||substr(f.LOGOUT_URL,1,20)||length(f.LOGOUT_URL)
    ||' l='||decode(substr(f.LOGO_IMAGE,1,5),
       'TEXT:','TextLogo',
       'Image Logo')
    ||','||substr(f.LOGO_IMAGE,1,20)||length(f.LOGO_IMAGE)
    ||','||substr(f.LOGO_IMAGE_ATTRIBUTES,1,20)||length(f.LOGO_IMAGE_ATTRIBUTES)
    ||' p='||f.PUBLIC_USER
    ||' p='||substr(f.PROXY_SERVER,1,20)||length(f.PROXY_SERVER)
    ||' v='||f.FLOW_VERSION
    ||' s='||decode(f.FLOW_STATUS,
        'AVAILABLE','Available',
        'AVAILABLE_W_EDIT_LINK','AvailwEL',
        'DEVELOPERS_ONLY','DevOnly',
        'RESTRICTED_ACCESS','Rests',
        'UNAVAILABLE','Unavail',
        'UNAVAILABLE_PLSQL','UnavailPL/SQL)',
        'UNAVAILABLE_URL','UnavailableRedir',
        f.flow_status)
    ||' u='||substr(f.FLOW_UNAVAILABLE_TEXT,1,20)||length(f.FLOW_UNAVAILABLE_TEXT)
    ||' r='||substr(f.RESTRICT_TO_USER_LIST,1,20)||length(f.RESTRICT_TO_USER_LIST)
    ||' d='||decode(f.APPLICATION_TAB_SET,
        1,'Allowed',0,'!Allowed',
        'Allowed')
    ||' s='||decode(f.EXACT_SUBSTITUTIONS_ONLY,
       'N','No','Y','Yes',
       f.EXACT_SUBSTITUTIONS_ONLY)
    ||' s='||decode(f.BUILD_STATUS,
       'RUN_ONLY','Run Only',
       'RUN_AND_BUILD','Run+Dev',
       f.BUILD_STATUS)
    ||' v='||substr(f.VPD,1,20)||length(f.vpd)
    ||' a='||decode(substr(f.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(f.SECURITY_SCHEME,'!')
     and    flow_id = f.id),
     f.SECURITY_SCHEME)
    ||' t='||f.THEME_ID
    ||' gn='||substr(f.GLOBAL_NOTIFICATION,1,20)||length(f.GLOBAL_NOTIFICATION)
    ||' pp='||decode(f.PAGE_PROTECTION_ENABLED_Y_N,'Y','Enabled','N','Disabled','Disabled')
    ||' timeout='||MAX_SESSION_LENGTH_SEC||'.'||ON_MAX_SESSION_TIMEOUT_URL||'.'||MAX_SESSION_IDLE_SEC||'.'||ON_MAX_IDLE_TIMEOUT_URL    
    component_signature,
    f.security_group_id workspace_id
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      /* keep this not exists */
      not exists (
        select 1 from wwv_flow_language_map m
        where m.translation_flow_id = f.id) and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/



comment on table  apex_applications                              is 'Applications defined in the current workspace or database user.';
comment on column apex_applications.workspace                    is 'A work area mapped to one or more database schemas';
comment on column apex_applications.application_id               is 'Application Primary Key, Unique over all workspaces';
comment on column apex_applications.application_name             is 'Identifies the application';
comment on column apex_applications.application_group            is 'Identifies the name of the application group this application is associated with';
comment on column apex_applications.application_group_id         is 'Identifies the ID of the application group this application is associated with';
comment on column apex_applications.alias                        is 'Assigns an alternate alphanumeric application identifier';
comment on column apex_applications.owner                        is 'Identifies the database schema that this application will parse SQL and PL/SQL statements as';
comment on column apex_applications.home_link                    is 'URL used to navigate to the home page of the application';
comment on column apex_applications.page_template                is 'The default page template for displaying pages, may be overridden at the page level';
comment on column apex_applications.logging                      is 'Determines whether or not user activity is recorded in the activity log';
comment on column apex_applications.application_primary_language is 'Identifies the language in which an application is developed';
comment on column apex_applications.language_derived_from        is 'For use when translating an application; specifies how Apex determines or derives the application language';
comment on column apex_applications.date_format                  is 'Application default date format.  Will set NLS_DATE_FORMAT prior to showing or posting a page';
comment on column apex_applications.image_prefix                 is 'Determines the virtual path the Web server uses to point to the images directory distributed with Apex';
comment on column apex_applications.authentication_scheme        is 'Identifies the current authentication method used by this application. The purpose of authentication is to determine the application users identity';

comment on column apex_applications.authentication_scheme_type   is 'Identifies the type of authentication, sheme based or APEX internal based';

comment on column apex_applications.login_url                    is 'When running this application redirect to this URL';
comment on column apex_applications.logout_url                   is 'Used as the LOGOUT_URL substitution string and identifies a URL to redirect to when the user wishes to logout of the application';
comment on column apex_applications.logo_type                    is 'Identifies the logo as text or an image';
comment on column apex_applications.logo                         is 'Used as the LOGO substitution string, declarative name of the application which can be referenced from page templates';
comment on column apex_applications.logo_attributes              is 'Attributes used to display the logo.  HTML SPAN tag attributes for text logos and HTML IMG tag attributes for logos that are images.';
comment on column apex_applications.public_user                  is 'If the APP_USER equals this database schema name then the user is considered a public or unauthenticated user.  Based on this declarative IS_PUBLIC_USER conditions are determined.';
comment on column apex_applications.proxy_server                 is 'Use this proxy server when a proxy server is needed';
comment on column apex_applications.media_type                   is 'Application-level Internet media type, used in the Content-Type HTTP header';
comment on column apex_applications.VERSION                      is 'Includes the application''s version number on a page';
comment on column apex_applications.AVAILABILITY_STATUS          is 'Specifies whether or not the application is available or unavailable for use';
comment on column apex_applications.UNAVAILABLE_TEXT             is 'This attribute in conjunction with the Availability Status.  Identifies the text to display when the application is not available';
comment on column apex_applications.RESTRICT_TO_USER             is 'Use this attribute in conjunction with the Availability Status "Restricted Access". Only the users listed in this attribute can run the application.';
comment on column apex_applications.DEBUGGING                    is 'Determines whether pages may be display in debug mode.  Debugging is typically on for development and turned off for production.';
comment on column apex_applications.EXACT_SUBSTITUTIONS          is 'Determines if text substitutions require a trailing dot.  This values should always be Yes.  Provided for compatibility with preproduction releases.';
comment on column apex_applications.BUILD_STATUS                 is 'Determines if the application is available for development.  Production applications can be set to "Run Only" which will cause the application to appear in the Apex Application Builder.';
comment on column apex_applications.VPD                          is 'Identifies PL/SQL that is dynamically executed immediately after the user is authenticated and before any application logic is processed.  This attribute can assign security policies to restrict access to database tables and views.';
comment on column apex_applications.AUTHORIZATION_SCHEME         is 'Identifies an Authorization Scheme that will be applied to all pages of the application';
comment on column apex_applications.AUTHORIZATION_SCHEME_ID      is 'Identifies an Authorization Scheme foreign key';
comment on column apex_applications.THEME_NUMBER                 is 'Identifies the applications current user interface theme';
comment on column apex_applications.GLOBAL_NOTIFICATION          is 'This text is displayed on every page of the application that uses a page template with the #GLOBAL_NOTIFICATION# substitution string';
comment on column apex_applications.Session_State_Protection     is 'Enabling Session State Protection can prevent hackers from tampering with URLs within your application.  When enabled pages and items can be set to require checksums to validate inputs.';
comment on column apex_applications.last_updated_by              is 'Apex developer who made last update';
comment on column apex_applications.last_updated_on              is 'Date of last update';
comment on column apex_applications.pages                        is 'Count of subordinate objects';
comment on column apex_applications.tabs                         is 'Count of subordinate objects';
comment on column apex_applications.parent_tabs                  is 'Count of subordinate objects';
comment on column apex_applications.application_items            is 'Count of subordinate objects';
comment on column apex_applications.application_processes        is 'Count of subordinate objects';
comment on column apex_applications.application_computations     is 'Count of subordinate objects';
comment on column apex_applications.shortcuts                    is 'Count of subordinate objects';
comment on column apex_applications.web_services                 is 'Count of subordinate objects';
comment on column apex_applications.trees                        is 'Count of subordinate objects';
comment on column apex_applications.build_options                is 'Count of subordinate objects';
comment on column apex_applications.breadcrumbs                  is 'Count of subordinate objects';
comment on column apex_applications.nav_bar_entries              is 'Count of subordinate objects';
comment on column apex_applications.lists                        is 'Count of subordinate objects';
comment on column apex_applications.lists_of_values              is 'Count of subordinate objects';
comment on column apex_applications.themes                       is 'Count of subordinate objects';
comment on column apex_applications.authentication_schemes       is 'Count of subordinate objects';
comment on column apex_applications.authorization_schemes        is 'Count of subordinate objects';
comment on column apex_applications.translation_messages         is 'Count of subordinate objects';
comment on column apex_applications.installation_scripts         is 'Count of subordinate objects';
comment on column apex_applications.cached_pages                 is 'Count of pages in this application that are defined as cachable';
comment on column apex_applications.cached_regions               is 'Count of page regions in this application that are defined as cachable';
comment on column apex_applications.component_signature          is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_applications.error_page_template          is 'Display unexpected errors on an error page using this page template.';
comment on column apex_applications.workspace_id                 is 'Primary Key of the Workspace';
comment on column apex_applications.Maximum_Session_Life_Seconds is 'Maximum lifetime of session in seconds';
comment on column apex_applications.Session_Lifetime_Exceeded_URL is 'Go to URL when session lifetime exceeded';
comment on column apex_applications.Maximum_Session_Idle_Seconds is 'Maximum session idle time in seconds';
comment on column apex_applications.Session_Idle_Time_Exceeded_URL is 'Go to URL when session idle time exceeded';  
	

grant select on   apex_applications to public;


create or replace view apex_application_trans_map
as
select
    w.short_name                     workspace,
    m.ID                             map_id, 
    m.primary_language_flow_id       primary_application_id, 
    f.name                           primary_application_name,
    m.translation_flow_id            translated_application_id, 
    m.translation_flow_language_code translated_app_language, 
    m.translation_image_directory    translated_appl_img_dir, 
    m.translation_comments           translation_comments,
    m.MAP_COMMENTS                   translation_map_comments,
    m.LAST_UPDATED_BY,   
    m.LAST_UPDATED_ON
from 
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     WWV_FLOW_LANGUAGE_MAP m,
     wwv_flows f,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      w.PROVISIONING_COMPANY_ID != 0  and
      w.PROVISIONING_COMPANY_ID = m.security_group_id and
      f.owner = s.schema and
      f.id = m.primary_language_flow_id
/

comment on table  apex_application_trans_map                           is 'Application Groups defined per workspace.  Applications can be associated with an application group.';
comment on column apex_application_trans_map.workspace                 is 'A work area mapped to one or more database schemas';
comment on column apex_application_trans_map.map_id                    is 'Unique ID that identifies this translation mapping';
comment on column apex_application_trans_map.primary_application_id    is 'Unique ID of the application that is the target of the translation';
comment on column apex_application_trans_map.primary_application_name  is 'Name of the application that is the target of the translation';
comment on column apex_application_trans_map.translated_application_id is 'Unique ID of the translated application';
comment on column apex_application_trans_map.translated_app_language   is 'Language code, for example "fr" or "pt-br"';
comment on column apex_application_trans_map.translated_appl_img_dir   is 'Optional directory of translated images';
comment on column apex_application_trans_map.translation_comments      is 'Comments associated with this translation';
comment on column apex_application_trans_map.translation_map_comments  is 'Comments associated with this mapping';
comment on column apex_application_trans_map.LAST_UPDATED_BY           is 'Last user to update this translation mapping';
comment on column apex_application_trans_map.LAST_UPDATED_ON           is 'Date of last update to this translation mapping';



grant select on   apex_application_trans_map to public;




create or replace view apex_application_groups as
select
    w.short_name                 workspace,
    g.ID                         application_group_id,
    g.group_name                 group_name,
    g.group_comment              group_comment,
    w.PROVISIONING_COMPANY_ID    workspace_id
from
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     wwv_flow_application_groups g,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10) and
      w.PROVISIONING_COMPANY_ID = g.security_group_id
group by  w.PROVISIONING_COMPANY_ID, w.short_name, w.FIRST_SCHEMA_PROVISIONED,g.id, g.group_name, g.group_comment
/

comment on table  apex_application_groups                        is 'Application Groups defined per workspace.  Applications can be associated with an application group.';
comment on column apex_application_groups.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_groups.application_group_id   is 'Unique ID that identifies this application group';
comment on column apex_application_groups.group_name             is 'Identifies the application group';
comment on column apex_application_groups.group_comment          is 'Identifies comments for a given application group';
comment on column apex_application_groups.application_group_id   is 'Identifies the ID of the application group this application is associated with';

grant select on   apex_application_groups to public;











create or replace view apex_application_substitutions as
select w.short_name             workspace,
       f.ID                     application_id,
       f.NAME                   application_name,
       f.SUBSTITUTION_STRING_01 substitution_string,
       f.SUBSTITUTION_VALUE_01  substitution_value
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      f.SUBSTITUTION_STRING_01 is not null
union all
select w.short_name             workspace,
       f.ID                     application_id,
       f.NAME                   application_name,
       f.SUBSTITUTION_STRING_02 substitution_string,
       f.SUBSTITUTION_VALUE_02  substitution_value
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      f.SUBSTITUTION_STRING_02 is not null
union all
select w.short_name             workspace,
       f.ID                     application_id,
       f.NAME                   application_name,
       f.SUBSTITUTION_STRING_03 substitution_string,
       f.SUBSTITUTION_VALUE_03  substitution_value
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      f.SUBSTITUTION_STRING_03 is not null
union all
select w.short_name             workspace,
       f.ID                     application_id,
       f.NAME                   application_name,
       f.SUBSTITUTION_STRING_04 substitution_string,
       f.SUBSTITUTION_VALUE_04  substitution_value
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      f.SUBSTITUTION_STRING_04 is not null
union all
select w.short_name             workspace,
       f.ID                     application_id,
       f.NAME                   application_name,
       f.SUBSTITUTION_STRING_05 substitution_string,
       f.SUBSTITUTION_VALUE_05  substitution_value
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      f.SUBSTITUTION_STRING_05 is not null
union all
select w.short_name             workspace,
       f.ID                     application_id,
       f.NAME                   application_name,
       f.SUBSTITUTION_STRING_06 substitution_string,
       f.SUBSTITUTION_VALUE_06  substitution_value
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      f.SUBSTITUTION_STRING_06 is not null
union all
select w.short_name             workspace,
       f.ID                     application_id,
       f.NAME                   application_name,
       f.SUBSTITUTION_STRING_07 substitution_string,
       f.SUBSTITUTION_VALUE_07  substitution_value
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      f.SUBSTITUTION_STRING_07 is not null
union all
select w.short_name             workspace,
       f.ID                     application_id,
       f.NAME                   application_name,
       f.SUBSTITUTION_STRING_08 substitution_string,
       f.SUBSTITUTION_VALUE_08  substitution_value
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      f.SUBSTITUTION_STRING_08 is not null
union all
select w.short_name             workspace,
       f.ID                     application_id,
       f.NAME                   application_name,
       f.SUBSTITUTION_STRING_09 substitution_string,
       f.SUBSTITUTION_VALUE_09  substitution_value
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      f.SUBSTITUTION_STRING_09 is not null
union all
select w.short_name             workspace,
       f.ID                     application_id,
       f.NAME                   application_name,
       f.SUBSTITUTION_STRING_10 substitution_string,
       f.SUBSTITUTION_VALUE_10  substitution_value
from wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      f.SUBSTITUTION_STRING_10 is not null
/

comment on table  apex_application_substitutions                     is 'Application level definitions of substitution strings.';
comment on column apex_application_substitutions.workspace           is 'A work area mapped to one or more database schemas';
comment on column apex_application_substitutions.application_id      is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_substitutions.application_name    is 'Identifies the application';
comment on column apex_application_substitutions.substitution_string is 'Name of substitution string';
comment on column apex_application_substitutions.substitution_value  is 'Value of substitution string';
grant select on   apex_application_substitutions to public
/



create or replace view apex_application_caching as
select
    w.short_name                                        workspace,
    f.ID                                                application_id,
    f.NAME                                              application_name,
    decode(c.region_id,null,c.PAGE_ID,
    (select page_id from wwv_flow_page_plugs
     where id = c.region_id and flow_id = c.flow_id))   page_id,
    (select name
     from wwv_flow_steps
     where id in
     decode(c.region_id,null,c.PAGE_ID,
    (select page_id from wwv_flow_page_plugs
     where id = c.region_id and flow_id = c.flow_id))
      and  flow_id = f.id)                              page_name,
    decode(decode(chart_region_id,null,
    'X','Chart Region Cache'),'X',
    decode(region_id,null,'Page Cache','Region Cache')) cache_type,
    c.LANGUAGE                                          language,
    c.USER_NAME                                         caching_user,
    dbms_lob.getlength(c.PAGE_TEXT)                     cache_size,
    decode(region_id,null,null,
    (select plug_name
     from wwv_flow_page_plugs
     where id = c.region_id and flow_id = f.id))        region_name,
    c.CACHED_ON                                         cached_on,
    decode(region_id,null,
    (select cache_timeout_seconds
     from wwv_flow_steps
     where flow_id = f.id and id = c.page_id),
    (select PLUG_CACHING_MAX_AGE_IN_SEC
     from wwv_flow_page_plugs
     where id = c.region_id))                           cached_for_seconds,
    --
    round((sysdate - c.cached_on) * 3600 * 24,0)        age_in_seconds,
    --
    decode(region_id,null,
    (select cache_timeout_seconds -
             round((sysdate - c.cached_on)
             * 3600 * 24,0) a
     from wwv_flow_steps
     where flow_id = f.id and id = c.page_id),
    (select PLUG_CACHING_MAX_AGE_IN_SEC -
            round((sysdate - c.cached_on)
            * 3600 * 24,0) a
     from wwv_flow_page_plugs
     where id = c.region_id))                           timeout_in_seconds,
    c.REGION_ID                                         region_id,
    c.SECURITY_GROUP_ID                                 workspace_id
from
     wwv_flow_page_cache c,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      c.flow_id = f.id and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_caching                     is 'Applications defined in the current workspace or database user.';
comment on column apex_application_caching.workspace           is 'A work area mapped to one or more database schemas';
comment on column apex_application_caching.application_id      is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_caching.application_name    is 'Identifies the application';
comment on column apex_application_caching.page_name           is 'Identifies page name';
comment on column apex_application_caching.page_id             is 'Identifies page number';
comment on column apex_application_caching.cache_type          is 'Cache type, Page, Region, or Chart Region';
comment on column apex_application_caching.language            is 'Language of Cache';
comment on column apex_application_caching.caching_user        is 'User who caused the page or region to be cached';
comment on column apex_application_caching.cache_size          is 'Size of the cache, sum this column to see full cache size';
comment on column apex_application_caching.region_name         is 'Identifies region name, null for page caches';
comment on column apex_application_caching.cached_on           is 'Date cache was created';
comment on column apex_application_caching.cached_for_seconds  is 'Iimeout in seconds identified in page or region caching meta data';
comment on column apex_application_caching.age_in_seconds      is 'Seconds elapsed since cache was created';
comment on column apex_application_caching.timeout_in_seconds  is 'Seconds until cache will expire.  Negitive values indicate an expired cache';
comment on column apex_application_caching.region_id           is 'Corresponding primary key of region';
comment on column apex_application_caching.workspace_id        is 'Corresponding primary key of workspace';
grant select on   apex_application_caching to public;


create or replace view apex_standard_conditions
as
          select 'EXISTS' d,'Exists (SQL query returns at least one row)'r from dual
union all select 'NOT_EXISTS' d,'NOT Exists (SQL query returns no rows)'r from dual
union all select 'SQL_EXPRESSION' d,'SQL Expression'r from dual
union all select 'PLSQL_EXPRESSION' d,'PL/SQL Expression'r from dual
union all select 'FUNCTION_BODY' d,'PL/SQL Function Body Returning a Boolean'r from dual
union all select 'REQUEST_EQUALS_CONDITION' d,'Request = Expression 1'r from dual
union all select 'REQUEST_NOT_EQUAL_CONDITION' d,'Request != Expression 1'r from dual
union all select 'REQUEST_IN_CONDITION' d,'Request Is Contained within Expression 1'r from dual
union all select 'REQUEST_NOT_IN_CONDITION' d,'Request Is NOT Contained within Expression 1'r from dual
union all select 'VAL_OF_ITEM_IN_COND_EQ_COND2' d,'Value of Item in Expression 1 = Expression 2'r from dual
union all select 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2' d,'Value of Item in Expression 1 != Expression 2'r from dual
union all select 'ITEM_IS_NULL' d,'Value of Item in Expression 1 Is NULL'r from dual
union all select 'ITEM_IS_NOT_NULL' d,'Value of Item in Expression 1 Is NOT NULL'r from dual
union all select 'ITEM_IS_ZERO' d,'Value of Item in Expression 1 = Zero'r from dual
union all select 'ITEM_IS_NOT_ZERO' d,'Value of Item in Expression 1 != Zero'r from dual
union all select 'ITEM_IS_NULL_OR_ZERO' d,'Value of Item in Expression 1 Is NULL or Zero'r from dual
union all select 'ITEM_NOT_NULL_OR_ZERO' d,'Value of Item in Expression 1 Is NOT null and the Item Is NOT Zero'r from dual
union all select 'ITEM_CONTAINS_NO_SPACES' d,'Value of Item in Expression 1 Contains No Spaces'r from dual
union all select 'ITEM_IS_NUMERIC' d,'Value of Item in Expression 1 Is Numeric' r from dual
union all select 'ITEM_IS_NOT_NUMERIC' d,'Value of Item in Expression 1 Is Not Numeric' r from dual
union all select 'ITEM_IS_ALPHANUMERIC' d,'Value of Item in Expression 1 Is Alphanumeric'r from dual
union all select 'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST' d,'Value of Item in Expression 1 Is Contained within Colon Delimited List in Expression 2'r from dual
union all select 'VALUE_OF_ITEM_IN_CONDITION_NOT_IN_COLON_DELIMITED_LIST' d,'Value of Item in Expression 1 Is NOT Contained within Colon Delimited List in Expression 2'r from dual
union all select 'USER_PREF_IN_COND_EQ_COND2' d,'Value of User Preference in Expression 1 = Expression 2'r from dual
union all select 'USER_PREF_IN_COND_NOT_EQ_COND2' d,'Value of User Preference in Expression 1 != Expression 2'r from dual
union all select 'CURRENT_PAGE_EQUALS_CONDITION' d,'Current page = Expression 1'r from dual
union all select 'CURRENT_PAGE_NOT_EQUAL_CONDITION' d,'Current page != Expression 1'r from dual
union all select 'CURRENT_PAGE_IN_CONDITION' d,'Current Page Is Contained Within Expression 1 (comma delimited list of pages)'r from dual
union all select 'CURRENT_PAGE_NOT_IN_CONDITION' d,'Current Page Is NOT in Expression 1 (comma delimited list of pages)'r from dual
union all select 'WHEN_THIS_PAGE_SUBMITTED' d,'Current Page = Page Submitted (this page was posted)'r from dual
union all select 'WHEN_THIS_PAGE_NOT_SUBMITTED' d,'Current Page != Page Submitted (this page was not the page posted)'r from dual
union all select 'PAGE_IS_IN_PRINTER_FRIENDLY_MODE' d,'Current Page Is in Printer Friendly Mode'r from dual
union all select 'PAGE_IS_NOT_IN_PRINTER_FRIENDLY_MODE' d,'Current page is NOT in Printer Friendly Mode'r from dual
union all select 'CONDITION1_IN_VALUE_OF_ITEM_IN_CONDITION2' d,'Text in Expression 1 Is Contained in Value of Item in Expression 2'r from dual
union all select 'DISPLAY_COND_IN_COND_TEXT' d,'Text in Expression 1 Is Contained within the Text in Expression 2'r from dual
union all select 'DISPLAY_COND_NOT_IN_COND_TEXT' d,'Text in Expression 1 Is NOT Contained within the Text in Expression 2'r from dual
union all select 'DISPLAY_COND_EQUAL_COND_TEXT' d,'Text in Expression 1 = Expression 2 (includes ITEM substitutions)'r from dual
union all select 'DISP_COND_NOT_EQUAL_COND_TEXT' d,'Text in Expression 1 != Expression 2 (includes ITEM substitutions)'r from dual
union all select 'USER_IS_NOT_PUBLIC_USER' d,'User is Authenticated  (not public)'r from dual
union all select 'USER_IS_PUBLIC_USER' d,'User is the Public User (user has not authenticated)'r from dual
union all select 'DISPLAYING_INLINE_VALIDATION_ERRORS' d,'Inline Validation Errors Displayed'r from dual
union all select 'NOT_DISPLAYING_INLINE_VALIDATION_ERRORS' d,'No Inline Validation Errors Displayed'r from dual
union all select 'MAX_ROWS_LT_ROWS_FETCHED' d,'SQL Reports (OK to show the forward button)'r from dual
union all select 'MIN_ROW_GT_THAN_ONE' d,'SQL Reports (OK to show the back button)'r from dual
union all select 'BROWSER_IS_NSCP' d,'Client Browser: Mozilla, Netscape 6.x/7x or higher'r from dual
union all select 'BROWSER_IS_MSIE' d,'Client Browser: Microsoft Internet Explorer 5.5, 6.0 or higher'r from dual
union all select 'BROWSER_IS_MSIE_OR_NSCP' d,'Client Browser: XHTML / CSS capable browser (NS 6.x,7x, Mozilla, IE 5.5, 6.0 or higher)'r from dual
union all select 'BROWSER_IS_OTHER' d,'Client Browser: Other browsers (or older version)'r from dual
union all select 'CURRENT_LANG_IN_COND1' d,'Current Language Is Contained within Expression 1'r from dual
union all select 'CURRENT_LANG_NOT_IN_COND1' d,'Current Language Is NOT Contained within Expression 1'r from dual
union all select 'CURRENT_LANG_NOT_EQ_COND1' d,'Current Language != Expression 1'r from dual
union all select 'CURRENT_LANG_EQ_COND1' d,'Current Language = Expression 1'r from dual
union all select 'DAD_NAME_EQ_CONDITION' d,'When CGI_ENV DAD_NAME = Expression 1'r from dual
union all select 'DAD_NAME_NOT_EQ_CONDITION' d,'When CGI_ENV DAD_NAME != Expression 1'r from dual
union all select 'SERVER_NAME_EQ_CONDITION' d,'When CGI_ENV SERVER_NAME = Expression 1'r from dual
union all select 'SERVER_NAME_NOT_EQ_CONDITION' d,'When CGI_ENV SERVER_NAME != Expression 1'r from dual
union all select 'HTTP_HOST_EQ_CONDITION' d,'When CGI_ENV HTTP_HOST = Expression 1'r from dual
union all select 'HTTP_HOST_NOT_EQ_CONDITION' d,'When CGI_ENV HTTP_HOST != Expression 1'r from dual
union all select 'NEVER' d,'Never'r from dual
union all select 'ALWAYS' d,'Always'r from dual ;



--------------------------------------------
-- A P P L I C A T I O N   P A G E S
-- 4301

prompt ...apex_application_pages

create or replace view apex_application_pages
as
select
    w.short_name                          workspace,
    p.flow_id                             application_id,
    f.name                                application_name,
    --
    p.id                                  page_id,
    p.name                                page_name,
    p.STEP_TITLE                          page_title,
    p.media_type                          media_type,
    p.TAB_SET                             tab_set,
    p.ALIAS                               page_alias,
    decode(substr(p.PAGE_COMPONENT_MAP,1,2),
         '01','Tabular Form',
         '02','Form',
         '03','Report',
         '04','Chart',
         '05','Web Service',
         '06','Navigation Page',
         '07','Tree',
         '08','Calendar',
         '09','URL',
         '10','Dynamic HTML',
         '11','Static HTML',
         '12','Login',
         '13','Home',
         '14','Page Zero',
         '15','Empty Page',
         '16','Dynamic Form',
         '17','Wizard Form',
         'Unknown')                       page_function,
    decode(
      p.ALLOW_DUPLICATE_SUBMISSIONS,
      'N','No','Y','Yes',null,'Yes',
      p.ALLOW_DUPLICATE_SUBMISSIONS)      allow_duplicate_submissions,
    --
    decode(INCLUDE_APEX_CSS_JS_YN,null,'Yes','Y','Yes','N','No','Unknown') INCLUDE_APEX_CSS_JS_YN,
    --
    decode(p.FIRST_ITEM,
      'AUTO_FIRST_ITEM','First Item on Page',
      'NO_FIRST_ITEM','Do not focus cursor',
      p.FIRST_ITEM)                       focus_cursor,
    p.WELCOME_TEXT                        Header_Text,
    p.BOX_WELCOME_TEXT                    Body_Header,
    --p.BOX_FOOTER_TEXT                     Body_footer,
    p.FOOTER_TEXT                         Footer_Text,
    p.HELP_TEXT                           help_text,
    (select name
     from wwv_flow_templates
     where id = p.STEP_TEMPLATE)          page_template,
     --
    decode(substr(p.REQUIRED_ROLE,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(p.REQUIRED_ROLE,'!')
     and    flow_id = f.id),
     p.REQUIRED_ROLE)                     authorization_scheme,
    p.required_role                       authorization_scheme_id,
     --
    (select case when p.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(p.REQUIRED_PATCH))         build_option,
    p.HTML_PAGE_HEADER                    page_html_header,
    p.HTML_PAGE_ONLOAD                    page_html_onload,
    --sec
    decode(p.PAGE_IS_PUBLIC_Y_N,
      'N','Yes','Y','No','Yes')            page_requires_Authentication,
    decode(nvl(p.PROTECTION_LEVEL,'N'),
       'N','Unrestricted',
       'C','Arguments Must Have Checksum',
       'U','No Arguments Allowed',
       'D','No URL Access',
       p.PROTECTION_LEVEL )               page_access_protection,
    --
    (select count(*) from wwv_flow_page_plugs where flow_id = f.id and page_id = p.id) regions,
    (select count(*) from wwv_flow_step_items ii where flow_id = f.id and flow_step_id = p.id and nvl(ii.display_as,'x') != 'BUTTON') items,
    (select count(*) from wwv_flow_step_buttons where flow_id = f.id and flow_step_id = p.id) +
    (select count(*) from wwv_flow_step_items ii where flow_id = f.id and flow_step_id = p.id and nvl(ii.display_as,'x') = 'BUTTON') buttons,
    (select count(*) from wwv_flow_step_computations where flow_id = f.id and flow_step_id = p.id) computations,
    (select count(*) from wwv_flow_step_validations where flow_id = f.id and flow_step_id = p.id) validations,
    (select count(*) from wwv_flow_step_processing where flow_id = f.id and flow_step_id = p.id) processes,
    (select count(*) from wwv_flow_step_branches where flow_id = f.id and flow_step_id = p.id) branches,
    (select count(*) from wwv_flow_region_report_column where flow_id = f.id and region_id in (select id from wwv_flow_page_plugs where flow_id = f.id and page_id = p.id)) report_columns,
    --
    (select 	GROUP_NAME
     from     wwv_flow_page_groups
     where    id = p.group_id and
              flow_id = p.flow_id)        page_group,
    p.group_id                            page_group_id,
    --
    ON_DUP_SUBMISSION_GOTO_URL            ,
    ERROR_NOTIFICATION_TEXT               ,
    decode(autocomplete_on_off,null,'On','ON','On','OFF','Off') form_autocomplete,
    decode(CACHE_PAGE_YN,null,'No','N','No','Y','Yes',cache_page_yn) cached,
    CACHE_TIMEOUT_SECONDS                 cache_timeout_seconds,
    decode(CACHE_BY_USER_YN,null,'No','N','No','Y','Yes',cache_by_user_yn) cached_by_user,
    CACHE_WHEN_CONDITION_TYPE             cache_condition_type,
    CACHE_WHEN_CONDITION_E1               cache_condition_exp_1,
    CACHE_WHEN_CONDITION_E2               cache_condition_exp_2,
    page_comment                          page_comment,
    (select count(*) from WWV_FLOW_PAGE_PLUGS where flow_id = f.id and page_id = p.id and PLUG_CACHING in ('CACHED','CACHED_BY_USER'))  cached_regions,
    --
    p.LAST_UPDATED_BY                     last_updated_by,
    p.LAST_UPDATED_ON                     last_updated_on,
    --
    lpad(p.id,5,'00000')
    ||p.step_title||
    ',tabset='||p.tab_set
    ||' help='||dbms_lob.getlength(p.HELP_TEXT)||
    decode(p.BOX_WELCOME_TEXT,null,null,'bodyhead='||length(p.BOX_WELCOME_TEXT))||
    decode(p.ALIAS,null,null,' alias='||p.ALIAS)||
    (select name from wwv_flow_templates where id = p.STEP_TEMPLATE)||
    --mh bug
    --nvl((select name from wwv_flow_security_schemes where to_char(id) = ltrim(p.REQUIRED_ROLE,'!') and flow_id = f.id),p.REQUIRED_ROLE)||
    nvl((select name from wwv_flow_security_schemes where to_char(id) = ltrim(p.REQUIRED_ROLE,'!') and flow_id = f.id),
    decode(substr(p.REQUIRED_ROLE,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(p.REQUIRED_ROLE,'!')
     and    flow_id = f.id),
     p.REQUIRED_ROLE)
    )||
    --
    (select PATCH_NAME from wwv_flow_patches where id =abs(p.REQUIRED_PATCH))||
    decode(p.FIRST_ITEM,'AUTO_FIRST_ITEM','First Item on Page','NO_FIRST_ITEM','Do not focus cursor',p.FIRST_ITEM)||
    decode(p.WELCOME_TEXT,null,null,'head='||length(p.WELCOME_TEXT))||
    decode(p.FOOTER_TEXT,null,null,',foot='||length(FOOTER_TEXT))||
    ',PgAuth='||decode(p.PAGE_IS_PUBLIC_Y_N,'N','Yes','Y','No','Yes')||
    ','||decode(nvl(p.PROTECTION_LEVEL,'N'),
       'N','Unrestricted',
       'C','Arguments Must Have Checksum',
       'U','No Arguments Allowed',
       'D','No URL Access',
       p.PROTECTION_LEVEL )||
     ',onload='||length(p.HTML_PAGE_ONLOAD)||
     ',hh='||nvl(length(p.HTML_PAGE_HEADER),0)
     component_signature
from wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_company_schemas s,
     wwv_flow_companies w,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.id = p.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/


comment on table apex_application_pages                               is 'A Page definition is the basic building block of page. Page components including regions, items, buttons, computations, branches, validations, and processes further define the definition of a page.';
comment on column apex_application_pages.workspace                    is 'A work area mapped to one or more database schemas';
comment on column apex_application_pages.application_id               is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_pages.application_name             is 'Identifies the application';
comment on column apex_application_pages.page_id                      is 'Identifies the page.  The primary key of a page is the combination of the Application ID and the Page ID.';
comment on column apex_application_pages.page_name                    is 'Identifies a page within an application';
comment on column apex_application_pages.page_title                   is 'Used by page templates to display the HTML title tag';
comment on column apex_application_pages.media_type                   is 'Page-level Internet media type, used in the Content-Type HTTP header';
comment on column apex_application_pages.TAB_SET                      is 'Identifies the standard Tab Set to be used for this page. A Tab Set is a collection of tabs, the current tab is a property of the tab and is identified by page ID.';

comment on column apex_application_pages.INCLUDE_APEX_CSS_JS_YN       is 'Determines if Oracle APEX will automatically include APEX standard CSS and JS in the page hearder.  Typical value is Yes';

comment on column apex_application_pages.PAGE_ALIAS                   is 'An alphanumeric identifier which can be used as a more readable identifier then the page ID.';
comment on column apex_application_pages.ALLOW_DUPLICATE_SUBMISSIONS  is 'Determines if a rendered page may be posted more then once, for example by pressing reload.  Defaults to Yes.';
comment on column apex_application_pages.focus_cursor                 is 'Specifies if Apex should automatically focus the cursor in the first field on page load';
comment on column apex_application_pages.HEADER_TEXT                  is 'Text or HTML that will appear immediately following the Page Template Header and before the Page Template Body content.';
comment on column apex_application_pages.BODY_HEADER                  is 'Text or HTML that will appear before the Page Template #BOX_BODY# substitution string';

comment on column apex_application_pages.FOOTER_TEXT                  is 'Text or HTML that will appear before the Page Template Footer and after the Page Template Body content.';
comment on column apex_application_pages.HELP_TEXT                    is 'Page help text';
comment on column apex_application_pages.PAGE_TEMPLATE                is 'Identifies the page template, if no page template is specified the application default page template will be used';
comment on column apex_application_pages.AUTHORIZATION_SCHEME         is 'An authorization scheme must evaluate to TRUE in order for this page to be displayed';
comment on column apex_application_pages.AUTHORIZATION_SCHEME_ID      is 'Foreign Key';
comment on column apex_application_pages.BUILD_OPTION                 is 'Page will only be displayed if no Build Option is specified or if the Build Options is enabled';
comment on column apex_application_pages.PAGE_HTML_HEADER             is 'Identifies text that replaces the #HEAD# substitution string in the Page Template';
comment on column apex_application_pages.PAGE_HTML_ONLOAD             is 'Identifies JavaScript or text to be substituted in for the Page Template #ONLOAD# substitution string';
comment on column apex_application_pages.PAGE_REQUIRES_AUTHENTICATION is 'Specifies whether this page has been defined as "Public" or requires authentication';
comment on column apex_application_pages.PAGE_ACCESS_PROTECTION       is 'Identifies the Page Access Protection level which is used to restrict the setting of session state or to require checksums to pass session state';
comment on column apex_application_pages.REGIONS                      is 'Number of regions defined for this page';
comment on column apex_application_pages.ITEMS                        is 'Number of items defined for this page';
comment on column apex_application_pages.BUTTONS                      is 'Number of buttons defined for this page';
comment on column apex_application_pages.COMPUTATIONS                 is 'Number of computations defined for this page';
comment on column apex_application_pages.VALIDATIONS                  is 'Number of validations defined for this page';
comment on column apex_application_pages.PROCESSES                    is 'Number of processes defined for this page';
comment on column apex_application_pages.BRANCHES                     is 'Number of branches defined for this page';
comment on column apex_application_pages.report_columns               is 'Number of report columns defined for this page';
comment on column apex_application_pages.page_group                   is 'Identifies assigned page group';
comment on column apex_application_pages.page_group_id                is 'Foreign Key';
comment on column apex_application_pages.last_updated_by              is 'Apex developer who made last update';
comment on column apex_application_pages.last_updated_on              is 'Date of last update';

comment on column apex_application_pages.component_signature          is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_application_pages.ON_DUP_SUBMISSION_GOTO_URL   is 'Application Express displays an error message and a link to this URL to continue with the application';
comment on column apex_application_pages.ERROR_NOTIFICATION_TEXT      is 'Enter the error message displayed when an error occurs on this page. The error message will be substituted for #NOTIFICATION_MESSAGE# in the page template.';
comment on column apex_application_pages.form_autocomplete            is 'Whether or not to enable autocomplete for forms';
comment on column apex_application_pages.cached                       is 'Whether or not to enable page caching';
comment on column apex_application_pages.cache_timeout_seconds        is 'Amount of time for which a cached page is valid.';
comment on column apex_application_pages.cached_by_user               is 'Cached by user yes or no';
comment on column apex_application_pages.cache_condition_type         is 'If the condition returns true, the page is displayed from cache.';
comment on column apex_application_pages.cache_condition_exp_1        is 'Cache condition expression 1';
comment on column apex_application_pages.cache_condition_exp_2        is 'Cache condition expression 2';
comment on column apex_application_pages.page_comment                 is 'Page comment';
comment on column apex_application_pages.page_function                is 'Primary function of the page based using a best guess method.';


grant select on   apex_application_pages to public;


create or replace view apex_application_page_groups
as
select
    w.short_name                          workspace,
    g.flow_id                             application_id,
    f.name                                application_name,
    g.group_name                          page_group_name,
    g.group_desc                          page_group_description,
    g.id                                  group_id
from wwv_flow_page_groups g,
     wwv_flows f,
     wwv_flow_company_schemas s,
     wwv_flow_companies w,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = g.security_group_id and
      f.id = g.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table apex_application_page_groups                          is 'Identifies page groups';
comment on column apex_application_page_groups.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_groups.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_groups.application_name        is 'Identifies the application';
comment on column apex_application_page_groups.page_group_name         is 'page group name';
comment on column apex_application_page_groups.page_group_description  is 'Page group description';
comment on column apex_application_page_groups.group_id                is 'Unique numeric identifier';
grant select on apex_application_page_groups to public;

-----------------------------------------------
-- A P P L I C A T I O N   P A G E   I T E M S
-- 4311
prompt ...apex_application_page_items


create or replace view apex_application_page_items
as
select
    w.short_name                    workspace,
    p.flow_id                       application_id,
    f.name                          application_name,
    p.id                            page_id,
    p.name                          page_name,
    --
    i.name                          item_name,
    decode(i.display_as,
    'PICK_DATE_USING_APP_DATE_FORMAT','Date Picker using Application Date Format',
    'PICK_DATE_USING_APP_FORMAT_MASK','Date Picker using application format mask',
    'PICK_DATE_USING_FORMAT_MASK','Date Picker using item format mask',
    'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH', 'Date Picker (DD-MM-YYYY HH24:MI)',
    'PICK_DATE_DD_MM_YYYY_HH_MI_DASH','Date Picker (DD-MM-YYYY HH:MI)',
    'PICK_DATE_DD_MM_YYYY_DASH','Date Picker (DD-MM-YYYY)',
    'PICK_DATE_DD_MON_RR_HH24_MI', 'Date Picker (DD-MON-RR HH24:MI)',
    'PICK_DATE_DD_MON_RR_HH_MI','Date Picker (DD-MON-RR HH:MI)',
    'PICK_DATE_DD_MON_RR','Date Picker (DD-MON-RR)',
    'PICK_DATE_DD_MON_YY_HH24_MI','Date Picker (DD-MON-YY HH24:MI)',
    'PICK_DATE_DD_MON_YY_HH_MI','Date Picker (DD-MON-YY HH:MI)',
    'PICK_DATE_DD_MON_YY','Date Picker (DD-MON-YY)',
    'PICK_DATE_DD_MON_YYYY_HH24_MI','Date Picker (DD-MON-YYYY HH24:MI)',
    'PICK_DATE_DD_MON_YYYY_HH_MI','Date Picker (DD-MON-YYYY HH:MI)',
    'PICK_DATE_DD_MON_YYYY','Date Picker (DD-MON-YYYY)',
    'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT','Date Picker (DD.MM.YYYY HH24:MI)',
    'PICK_DATE_DD_MM_YYYY_HH_MI_DOT','Date Picker (DD.MM.YYYY HH:MI)',
    'PICK_DATE_DD_MM_YYYY_DOT','Date Picker (DD.MM.YYYY)',
    'PICK_DATE_DD_MM_YYYY_HH24_MI','Date Picker (DD/MM/YYYY HH24:MI)',
    'PICK_DATE_DD_MM_YYYY_HH_MI','Date Picker (DD/MM/YYYY HH:MI)',
    'PICK_DATE_DD_MM_YYYY','Date Picker (DD/MM/YYYY)',
    'PICK_DATE_MM_DD_YYYY_HH24_MI','Date Picker (MM/DD/YYYY HH24:MI)',
    'PICK_DATE_MM_DD_YYYY_HH_MI','Date Picker (MM/DD/YYYY HH:MI)',
    'PICK_DATE_MM_DD_YYYY','Date Picker (MM/DD/YYYY)',
    'PICK_DATE_RR_MON_DD_HH24_MI','Date Picker (RR-MON-DD HH24:MI)',
    'PICK_DATE_RR_MON_DD_HH_MI','Date Picker (RR-MON-DD HH:MI)',
    'PICK_DATE_RR_MON_DD','Date Picker (RR-MON-DD)',
    'PICK_DATE_YYYY_MM_DD_HH24_MI','Date Picker (YYYY-MM-DD HH24:MI)',
    'PICK_DATE_YYYY_MM_DD_HH_MI','Date Picker (YYYY-MM-DD HH:MI)',
    'PICK_DATE_YYYY_MM_DD','Date Picker (YYYY-MM-DD)',
    'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT','Date Picker (YYYY.DD.MM HH24:MI)',
    'PICK_DATE_YYYY_DD_MM_HH_MI_DOT','Date Picker (YYYY.DD.MM HH:MI)',
    'PICK_DATE_YYYY_DD_MM_DOT','Date Picker (YYYY.DD.MM)',
    'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH','Date Picker (YYYY/MM/DD HH24:MI)',
    'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH','Date Picker (YYYY/MM/DD HH:MI)',
    'PICK_DATE_YYYY_MM_DD_SLASH','Date Picker (YYYY/MM/DD)',
    'PICK_DATE_USING_FLOW_FORMAT_MASK','Date Picker (use application format mask)',
    'DISPLAY_ONLY_LOV','Display as Text (based on LOV, does not save state)',
    'DISPLAY_AND_SAVE_LOV','Display as Text (based on LOV, saves state)',
    'DISPLAY_ONLY_PLSQL','Display as Text (based on PLSQL, does not save state)',
    'DISPLAY_ONLY_HTML','Display as Text (does not save state)',
    'DISPLAY_ONLY_ESCAPE_SC','Display as Text (escape special characters, does not save state)',
    'DISPLAY_AND_SAVE','Display as Text (saves state)',
    'FILE' ,'File Browse...',
    'HIDDEN','Hidden',
    'HIDDEN_PROTECTED','Hidden and Protected',
    'LIST_MGR_VIEW','List Manager (View Only)',
    'LIST_MGR','List Manager (based on Popup LOV)',
    'LIST_MGR2','List Manager (based on Popup LOV, no fetch)',
    'LIST_MGR3','List Manager (based on Popup LOV, preserves case)',
    'MULTIPLESELECT','Multiselect List',
    'PASSWORD','Password (saves state)',
    'PASSWORD_WITH_ENTER_SUBMIT','Password (submits when Enter pressed, saves state)',
    'PASSWORD_DNSS','Password (does not save state)',
    'PASSWORD_WITH_SUBMIT_DNSS','Password (submits when Enter pressed, does not save state)',
    'POPUP_KEY_LOV','Popup Key LOV (Displays description, returns key value)',
    'POPUP_KEY_LOV_NOFETCH','Popup Key LOV No Fetch (Displays description, returns key value without pre-fetch)',
    'POPUP_FILTER','Popup LOV (fetches first rowset and filters)',
    'POPUP','Popup LOV (fetches first rowset)',
    'POPUP2','Popup LOV (no fetch)',
    'RADIOGROUP','Radiogroup',
    'RADIOGROUP_WITH_SUBMIT','Radiogroup (with Submit)',
    'RADIOGROUP_WITH_REDIRECT','Radiogroup with Redirect',
    'COMBOBOX','Select List',
    'COMBOBOX_WITH_URL_REDIRECT','Select List Returning URL redirect',
    'COMBOBOX_WITH_BRANCH_TO_PAGE','Select List with Branch to Page',
    'SHOW_AS_SL_WITH_POPUP','Select List with POPUP LOV',
    'COMBOBOX_WITH_JS_REDIRECT','Select List with Redirect',
    'COMBOBOX_WITH_SUBMIT','Select List with Submit',
    'STOP_AND_START_HTML_TABLE','Stop and Start HTML Table (Displays label only)',
    'TEXT','Text Field',
    'TEXT_DISABLED','Text Field (Disabled, does not save state)',
    'TEXT_DISABLED_AND_SAVE','Text Field (Disabled, saves state)',
    'TEXT_WITH_ENTER_SUBMIT','Text Field (always submits page when Enter pressed)',
    'TEXT_WITH_CALCULATOR','Text Field with Calculator Popup',
    'TEXTAREA','Textarea',
    'TEXTAREA-AUTO-HEIGHT','Textarea (auto-height)',
    'TEXTAREA_CHAR_COUNT','Textarea with Character Counter',
    'TEXTAREA_CHAR_COUNT_SPELL','Textarea with Character Counter Spellcheck',
    'TEXTAREA_WITH_CONTROLS','Textarea with HTML Editor',
    'TEXTAREA_WITH_SPELL_CHECK','Textarea with Spell Checker',
    'CHECKBOX','Checkbox',
    'POPUP_COLOR','Popup Color Picker',
    'TEXTAREA_WITH_HTML_EDITOR_BASIC','Basic HTML Editor',
    'TEXTAREA_WITH_HTML_EDITOR_STANDARD','Standard HTML Editor',
    'SHUTTLE','Shuttle',
    i.display_as)                   display_as,
    decode(i.DATA_TYPE,
       'NUMBER','Numbers Only',
       'VARCHAR','Varchar',
       i.DATA_TYPE)                 item_data_type,
       --
    i.ITEM_SEQUENCE                 display_sequence,
    (select plug_name
     from wwv_flow_page_plugs
     where id = i.ITEM_PLUG_ID)     region,
    i.item_plug_id                  region_id,
    --
    decode(
      i.USE_CACHE_BEFORE_DEFAULT,
      'NO','Always, replacing any existing value in session state',
      'YES','Only when current value in session state is null',
      i.USE_CACHE_BEFORE_DEFAULT)   source_used,
    i.ITEM_DEFAULT                  item_default,
    i.ITEM_DEFAULT_TYPE             item_default_type,
    --
    i.PROMPT                        label,
    i.PRE_ELEMENT_TEXT              pre_element_text,
    i.POST_ELEMENT_TEXT             post_element_text,
    i.FORMAT_MASK                   format_mask,
    (select template_name
     from   wwv_flow_field_templates
     where  id = to_char(i.ITEM_FIELD_TEMPLATE)
     and    flow_id = f.id)         item_label_template,
    i.ITEM_FIELD_TEMPLATE           item_label_template_id,
    i.SOURCE                        item_source,
    decode(i.SOURCE_TYPE,
      'ALWAYS_NULL','Always Null',
      'STATIC','Static Assignment (value equals source attribute)',
      'QUERY','SQL Query',
      'ITEM','Item (application or page item name)',
      'FUNCTION','PL/SQL Expression or Function',
      'FUNCTION_BODY','PL/SQL Function Body',
      'DB_COLUMN','Database Column',
      'PREFERENCE','Preference',
      'PLSQL_ANONYMOUS_BLOCK','PL/SQL Anonymous Block',
      i.SOURCE_TYPE)                item_source_type,
    decode(i.encrypt_session_state_yn,'Y','Yes','No') encrypt_session_state,
    i.SOURCE_POST_COMPUTATION       source_post_computation,
    -- read only conditionality
    nvl((select r from apex_standard_conditions where d = i.READ_ONLY_WHEN_TYPE),i.READ_ONLY_WHEN_TYPE)
                                    read_only_condition_type,
    i.READ_ONLY_WHEN                read_only_condition_exp1,
    i.READ_ONLY_WHEN2               read_only_condition_exp2,
    i.READ_ONLY_DISP_ATTR           read_only_display_attr,
    --
    i.NAMED_LOV                     lov_named_lov,
    i.LOV                           lov_definition,
    i.LOV_COLUMNS                   lov_columns,
    decode(i.LOV_DISPLAY_EXTRA,
      'NO','No',
      'YES','Yes',
      i.LOV_DISPLAY_EXTRA)          lov_display_extra,
    decode(i.LOV_DISPLAY_NULL,
      'NO','No',
      'YES','Yes',
      i.LOV_DISPLAY_NULL)           lov_display_null,
    i.LOV_NULL_TEXT                 lov_null_text,
    i.LOV_NULL_VALUE                lov_null_value,
    decode(i.LOV_TRANSLATED,
      'N','No','Y','Yes',
      i.LOV_TRANSLATED)             lov_query_result_translated,
    --
    i.csize                         item_element_width,
    i.cmaxlength                    item_element_max_length,
    i.cheight                       item_element_height,
    --
    i.cattributes                   html_table_cell_attr_label,
    i.cattributes_element           html_table_cell_attr_element,
    i.tag_attributes                html_form_element_attributes,
    i.tag_attributes2               form_element_option_attributes,
    --
    i.button_image                  item_button_image,
    i.button_image_attr             item_button_image_attributes,
    --
    decode(i.BEGIN_ON_NEW_LINE,
      'NO','No','YES','Yes',
      i.BEGIN_ON_NEW_LINE)          begins_on_new_row,
    decode(i.BEGIN_ON_NEW_FIELD,
      'NO','No','YES','Yes',
      i.BEGIN_ON_NEW_FIELD)         begins_on_new_cell,
    i.COLSPAN                       column_span,
    i.ROWSPAN                       row_span,
    --
    decode(i.LABEL_ALIGNMENT,
      'ABOVE',         'Above',
      'BELOW',         'Below',
      'CENTER',        'Center',
      'CENTER-BOTTOM', 'Bottom center',
      'CENTER-CENTER', 'Center center',
      'CENTER-TOP',    'Top center',
      'LEFT',          'Left',
      'LEFT-BOTTOM',   'Bottom left',
      'LEFT-CENTER',   'Center left',
      'LEFT-TOP',      'Top left',
      'RIGHT',         'Right',
      'RIGHT-BOTTOM',  'Bottom right',
      'RIGHT-CENTER',  'Center right',
      'RIGHT-TOP',     'Top right',
      i.LABEL_ALIGNMENT)            label_alignment,
    decode(i.FIELD_ALIGNMENT,
      'CENTER',       'Center',
      'CENTER-BOTTOM','Center bottom',
      'CENTER-CENTER','Center center',
      'CENTER-TOP',   'Center top',
      'LEFT',         'Left',
      'LEFT-BOTTOM',  'Left bottom',
      'LEFT-CENTER',  'Left center',
      'LEFT-TOP',     'Left top',
      'RIGHT',        'Right',
      'RIGHT-BOTTOM', 'Right bottom',
      'RIGHT-CENTER', 'Right center',
      'RIGHT-TOP',    'Right top',
      i.FIELD_ALIGNMENT)            item_alignment,
    --
    --i.FIELD_TEMPLATE,
    --
    nvl((select r from apex_standard_conditions where d = i.DISPLAY_WHEN_TYPE),i.DISPLAY_WHEN_TYPE)
                                    condition_type,
    i.DISPLAY_WHEN                  condition_expression1,
    i.DISPLAY_WHEN2                 condition_expression2,
    --
    decode(i.IS_PERSISTENT,
       'Y','Per Session',
       'U','Per User',
       'N','Do Not Save Session State',
       i.IS_PERSISTENT)             maintain_session_state,
    decode(nvl(i.PROTECTION_LEVEL,'N'),
       'N','Unrestricted',
       'C','Arguments Must Have Checksum',
       'U','No Arguments Allowed',
       'D','No URL Access',
       'S','Checksum Required - Session Level',
       'I','Restricted - May not be set from browser',
       'B','Checksum Required - Application Level',
       'P','Checksum Required - User Level',
       i.PROTECTION_LEVEL)          item_protection_level,
    --i.ESCAPE_ON_HTTP_INPUT
    --
    decode(substr(i.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(i.SECURITY_SCHEME,'!')
     and    flow_id = f.id),
     i.SECURITY_SCHEME)             authorization_scheme,
    i.security_scheme               authorization_scheme_id,
    (select case when i.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(i.REQUIRED_PATCH))   build_option,
    i.REQUIRED_PATCH                build_option_id,
    --
    (select max(help_text) h
    from wwv_flow_step_item_help
    where FLOW_ITEM_ID = i.id)      item_help_text,
    --
    i.LAST_UPDATED_BY               last_updated_by,
    i.LAST_UPDATED_ON               last_updated_on,
    i.ITEM_COMMENT                  component_comment,
    i.id                            item_id,
    --
    i.name
    ||' da='||i.display_as
    ||decode(i.DATA_TYPE,'NUMBER','NOnly','VARCHAR','V',i.DATA_TYPE)
    ||',seq='||lpad(i.ITEM_SEQUENCE,5,'00000')
    ||',r='||(select plug_name from wwv_flow_page_plugs where id=i.ITEM_PLUG_ID)
    ||',c='||decode(i.USE_CACHE_BEFORE_DEFAULT,'NO','Always','YES','Only null',i.USE_CACHE_BEFORE_DEFAULT)
    ||',d='||substr(i.ITEM_DEFAULT,1,20)||length(i.ITEM_DEFAULT)||i.ITEM_DEFAULT_TYPE
    ||',l='||substr(i.PROMPT,1,20)||length(i.prompt)
    ||substr(i.PRE_ELEMENT_TEXT,1,10)||length(i.PRE_ELEMENT_TEXT)
    ||substr(i.POST_ELEMENT_TEXT,1,10)||length(i.POST_ELEMENT_TEXT)
    ||',m='||i.FORMAT_MASK
    ||'t='||(select template_name from   wwv_flow_field_templates where  id = to_char(i.ITEM_FIELD_TEMPLATE) and flow_id = f.id)
    ||'s='||substr(i.SOURCE,1,30)||length(i.source)
    ||decode(i.SOURCE_TYPE,
      'ALWAYS_NULL','Always Null',
      'STATIC','StaticAs',
      'QUERY','SQLQuery',
      'ITEM','Item ',
      'FUNCTION','PL/SQL',
      'FUNCTION_BODY','PL/SQLFunctionBody',
      'DB_COLUMN','DBColumn',
      'PREFERENCE','Pref',
      'PLSQL_ANONYMOUS_BLOCK','PL/SQLAnBl',
      i.SOURCE_TYPE)
    ||length(i.SOURCE_POST_COMPUTATION)
    ||' ro='||nvl((select r from apex_standard_conditions where d = i.READ_ONLY_WHEN_TYPE),i.READ_ONLY_WHEN_TYPE)
    ||length(i.READ_ONLY_WHEN)
    ||length(i.READ_ONLY_WHEN2)
    ||length(i.READ_ONLY_DISP_ATTR)
    ||',lov='||i.NAMED_LOV
    ||decode(i.named_lov,null,null,length(i.LOV))
    ||i.LOV_COLUMNS
    ||decode(i.LOV_DISPLAY_EXTRA,
      'NO','No',
      'YES','Yes',
      i.LOV_DISPLAY_EXTRA)
    ||decode(i.LOV_DISPLAY_NULL,
      'NO','No',
      'YES','Yes',
      i.LOV_DISPLAY_NULL)
    ||substr(LOV_NULL_TEXT,1,20)||length(LOV_NULL_TEXT)
    ||i.LOV_NULL_VALUE
    ||',t='||decode(i.LOV_TRANSLATED,'N','No','Y','Yes',i.LOV_TRANSLATED)
    ||',s='||i.csize||i.cmaxlength||i.cheight
    ||',a='||substr(i.cattributes,1,10)||length(i.cattributes)
    ||length(i.cattributes_element)
    ||length(i.tag_attributes)
    ||length(i.tag_attributes2)
    ||',b='||length(i.button_image)||length(i.button_image_attr)
    ||',disp='||decode(i.BEGIN_ON_NEW_LINE,
      'NO','No','YES','Yes',
      i.BEGIN_ON_NEW_LINE)||decode(i.BEGIN_ON_NEW_FIELD,
      'NO','No','YES','Yes',
      i.BEGIN_ON_NEW_FIELD)||i.COLSPAN||i.ROWSPAN
    ||' l='||decode(i.LABEL_ALIGNMENT,
      'ABOVE',         'Above',
      'BELOW',         'Below',
      'CENTER',        'Center',
      'CENTER-BOTTOM', 'Bottom center',
      'CENTER-CENTER', 'Center center',
      'CENTER-TOP',    'Top center',
      'LEFT',          'Left',
      'LEFT-BOTTOM',   'Bottom left',
      'LEFT-CENTER',   'Center left',
      'LEFT-TOP',      'Top left',
      'RIGHT',         'Right',
      'RIGHT-BOTTOM',  'Bottom right',
      'RIGHT-CENTER',  'Center right',
      'RIGHT-TOP',     'Top right',
      i.LABEL_ALIGNMENT)||decode(i.FIELD_ALIGNMENT,
      'CENTER',       'Center',
      'CENTER-BOTTOM','Center bottom',
      'CENTER-CENTER','Center center',
      'CENTER-TOP',   'Center top',
      'LEFT',         'Left',
      'LEFT-BOTTOM',  'Left bottom',
      'LEFT-CENTER',  'Left center',
      'LEFT-TOP',     'Left top',
      'RIGHT',        'Right',
      'RIGHT-BOTTOM', 'Right bottom',
      'RIGHT-CENTER', 'Right center',
      'RIGHT-TOP',    'Right top',
      i.FIELD_ALIGNMENT)
    ||',c='||i.DISPLAY_WHEN_TYPE||substr(i.DISPLAY_WHEN,1,20)||length(i.DISPLAY_WHEN)||length(i.DISPLAY_WHEN2)
    ||decode(i.IS_PERSISTENT,
       'Y','PerSes',
       'U','PerU',
       'N','Do Not Save SesSt',
       i.IS_PERSISTENT)||
    decode(nvl(i.PROTECTION_LEVEL,'N'),
       'N','Unrest',
       'C','Arg Must Have Cs',
       'U','No Arguments Allowed',
       'D','No URL Access',
       'S','Cs Required - Session Level',
       'I','Restricted - May not be set from browser',
       'B','Cs Req-AL',
       'P','Cs Req-UL',
       i.PROTECTION_LEVEL)
    ||decode(substr(i.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(i.SECURITY_SCHEME,'!')
     and    flow_id = f.id),
     i.SECURITY_SCHEME)
     ||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(i.REQUIRED_PATCH))
    component_signature
from wwv_flow_step_items i,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.id = p.flow_id and
      f.id = i.flow_id and
      p.id = i.flow_step_id and
      nvl(i.display_as,'x') != 'BUTTON' and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/


comment on table  apex_application_page_items                   is 'Identifies Page Items which are used to render HTML form content.  Items automatically maintain session state which can be accessed using bind variables or substitution stings.';
comment on column apex_application_page_items.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_items.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_items.application_name  is 'Identifies the application';
comment on column apex_application_page_items.page_id           is 'Identifies the application';
comment on column apex_application_page_items.page_name         is 'Identifies a page within an application';
comment on column apex_application_page_items.item_name         is 'Identifies a page item and is used to maintain session state.  Value may be referenced as a SQL bind variable or using Apex substitution string syntax.';
comment on column apex_application_page_items.display_as        is 'Identifies how the item will be displayed in the HTML page';
comment on column apex_application_page_items.item_data_type    is 'Typically VARCHAR but may be set to NUMBER to restrict values to only numbers';
comment on column apex_application_page_items.DISPLAY_SEQUENCE  is 'Identifies the sequence the page item will be displayed within a region';
comment on column apex_application_page_items.REGION            is 'Identifies the region in which the item will be displayed';
comment on column apex_application_page_items.REGION_ID         is 'Identifies the foreign key to the apex_application_page_regions view';
comment on column apex_application_page_items.SOURCE_USED       is 'Identifies how the source of the item value is determined.  The item can be set by the source value on each view only when the session state for the item is null.';
comment on column apex_application_page_items.ITEM_DEFAULT      is 'When the item has no source or session state, use this default value';
comment on column apex_application_page_items.ITEM_DEFAULT_TYPE is 'Identifies how the Item Default is set, based on a dynamic computation or a static assignment';
comment on column apex_application_page_items.LABEL             is 'Identifies the item label';
comment on column apex_application_page_items.PRE_ELEMENT_TEXT is 'Identifies text placed before the item.';
comment on column apex_application_page_items.POST_ELEMENT_TEXT is 'Identifies text placed after the item.';
comment on column apex_application_page_items.FORMAT_MASK       is 'Identifies a format mask which can be used to format numeric or date values';
comment on column apex_application_page_items.ITEM_LABEL_TEMPLATE is 'Identifies the template used to display the item label';
comment on column apex_application_page_items.ITEM_LABEL_TEMPLATE_ID is 'Identifies the template ID foreign key';
comment on column apex_application_page_items.ITEM_SOURCE       is 'Identifies the items value.  Reference the Source Used and Item Source Type attributes.';
comment on column apex_application_page_items.ITEM_SOURCE_TYPE  is 'Identifies how the item source is determined, for example from a Database Column, Static assignment, or a Query or PL/SQL expression.';
comment on column apex_application_page_items.SOURCE_POST_COMPUTATION  is 'After determining the Item Source value apply this computation';
comment on column apex_application_page_items.READ_ONLY_CONDITION_TYPE is 'Identifies the condition type when the item will be rendered read only';
comment on column apex_application_page_items.READ_ONLY_CONDITION_EXP1 is 'Identifies the condition that determines if the item will be rendered read only';
comment on column apex_application_page_items.READ_ONLY_CONDITION_EXP2 is 'Identifies the condition that determines if the item will be rendered read only';
comment on column apex_application_page_items.READ_ONLY_DISPLAY_ATTR is 'Identifies the HTML SPAN tag attributes when rendering the item read only';
comment on column apex_application_page_items.LOV_NAMED_LOV is 'Identifies the List of Values to be used to render this domain of values for this item';
comment on column apex_application_page_items.LOV_DEFINITION is 'Identifies the List of Values used as the domain of values for this item';
comment on column apex_application_page_items.LOV_COLUMNS is 'Identifies how many columns will be used to display List of Values elements, used for checkboxes and radio groups.';
comment on column apex_application_page_items.LOV_DISPLAY_EXTRA is 'When an items values is not included in the domain of the List of Values, display the value of the item';
comment on column apex_application_page_items.LOV_DISPLAY_NULL is 'Yes or No, identifies if a null value option is to be provided';
comment on column apex_application_page_items.LOV_NULL_TEXT is 'Identifies the text to be displayed to the end user for a null value';
comment on column apex_application_page_items.LOV_NULL_VALUE is 'Identifies the value to be used to identify a null value for the item';
comment on column apex_application_page_items.LOV_QUERY_RESULT_TRANSLATED is 'Yes or No identifies if List of Values elements will be checked for dynamic translation';
comment on column apex_application_page_items.ITEM_ELEMENT_WIDTH is 'Identifies the width of the item element';
comment on column apex_application_page_items.ITEM_ELEMENT_MAX_LENGTH is 'Identifies the maximum length of the item element';
comment on column apex_application_page_items.ITEM_ELEMENT_HEIGHT is 'Identifies the height of the item element for item display types that use a height';

comment on column apex_application_page_items.HTML_TABLE_CELL_ATTR_LABEL     is 'Identifies HTML table cell label attributes';
comment on column apex_application_page_items.HTML_TABLE_CELL_ATTR_ELEMENT   is 'Identifies HTML table cell element attributes';
comment on column apex_application_page_items.HTML_FORM_ELEMENT_ATTRIBUTES   is 'Identifies HTML table form element attributes';
comment on column apex_application_page_items.FORM_ELEMENT_OPTION_ATTRIBUTES is 'Identifies HTML table form element option attributes';

comment on column apex_application_page_items.ITEM_BUTTON_IMAGE              is 'For buttons displayed among items, the name of a button image';
comment on column apex_application_page_items.ITEM_BUTTON_IMAGE_ATTRIBUTES   is 'For buttons displayed among items, the name of a button HTML IMG tag attributes';

comment on column apex_application_page_items.BEGINS_ON_NEW_ROW             is 'Identifies if the rendering of items begins on a new HTML table row';
comment on column apex_application_page_items.BEGINS_ON_NEW_CELL            is 'Identifies if the rendering of items begins on a new HTML table cell';
comment on column apex_application_page_items.COLUMN_SPAN                   is 'Identifies the HTML table TD tag COLSPAN value';
comment on column apex_application_page_items.ROW_SPAN                      is 'Identifies the HTML table TD tag ROWSPAN value';

comment on column apex_application_page_items.LABEL_ALIGNMENT is 'Identifies the alignment of the Item Label';
comment on column apex_application_page_items.ITEM_ALIGNMENT  is 'Identifies the alignment of the Item Form Element';

comment on column apex_application_page_items.CONDITION_TYPE        is 'Identifies a condition that must be met in order for this item to be displayed';
comment on column apex_application_page_items.CONDITION_EXPRESSION1 is 'Identifies the item display condition';
comment on column apex_application_page_items.CONDITION_EXPRESSION2 is 'Identifies the item display condition';

comment on column apex_application_page_items.MAINTAIN_SESSION_STATE is 'Identifies the method used to maintain session state, per session, per user, or not maintained';

comment on column apex_application_page_items.ITEM_PROTECTION_LEVEL is 'If Session State Protection is enabled, identifies if a checksum will be required to change an items session state via the URL or POSTDATA.';
comment on column apex_application_page_items.AUTHORIZATION_SCHEME  is 'Identifies the authorization scheme which must evaluate to TRUE in order for this component to be rendered';
comment on column apex_application_page_items.AUTHORIZATION_SCHEME_ID      is 'Foreign Key';
comment on column apex_application_page_items.BUILD_OPTION          is 'Item will be displayed if the Build Option is enabled';
comment on column apex_application_page_items.COMPONENT_COMMENT     is 'Identifies a developer comment for this item';
comment on column apex_application_page_items.ITEM_ID               is 'Primary key of this component';
comment on column apex_application_page_items.last_updated_by   is 'Apex developer who made last update';
comment on column apex_application_page_items.last_updated_on   is 'Date of last update';
comment on column apex_application_page_items.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';


comment on column apex_application_page_items.encrypt_session_state is 'If Yes values of session state written to APEX session state tables is encrypted.  Decryption is automatic.';

grant select on apex_application_page_items to public;



create or replace function apex_application_get_pg_tname (
    p_application_id   in number,
    p_page_id  in number)
    return varchar2
is
    r varchar2(255) := null;
begin
    for c1 in (
       select process_sql_clob
       from   wwv_flow_step_processing p,
              wwv_flows f,
              wwv_flow_companies w,
              (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
       where  (f.owner = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = f.security_group_id) and
              f.security_group_id = w.PROVISIONING_COMPANY_ID and
              f.security_group_id = p.security_group_id and
              f.id = p.flow_id and
              p.flow_id = p_application_id and
              p.flow_step_id = p_page_id and
              p.PROCESS_TYPE = 'DML_FETCH_ROW'
              ) loop
       r := dbms_lob.substr(c1.process_sql_clob,255,1);
       r := substr(r,instr(r,':')+1);
       r := substr(r,1,instr(r,':')-1);
       exit;
    end loop;
    return r;
end;
/


create or replace view apex_application_page_db_items
as
select
    w.short_name                    workspace,
    p.flow_id                       application_id,
    f.name                          application_name,
    p.id                            page_id,
    p.name                          page_name,
    (select plug_name
     from wwv_flow_page_plugs
     where id = i.ITEM_PLUG_ID)     region,
    --
    i.name                          item_name,
    i.display_as                    display_as,
    i.ITEM_SEQUENCE                 display_sequence,
    --
    i.PROMPT                        item_label,
    i.SOURCE                        db_column_name,
    apex_application_get_pg_tname(
    p.flow_id,p.id)                 db_table_name,
    h.help_text                     help_text,
    i.id                            item_id
from wwv_flow_step_items i,
     wwv_flow_step_item_help h,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      i.id = h.flow_item_id (+) and
      f.id = p.flow_id and
      f.id = i.flow_id and
      p.id = i.flow_step_id and
      nvl(i.display_as,'x') != 'BUTTON' and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      i.source_type = 'DB_COLUMN' and
      w.PROVISIONING_COMPANY_ID != 0
/

comment on table  apex_application_page_db_items                   is 'Identifies Page Items which are associated with Database Table Columns.  This view represents a subset of the items in the APEX_APPLICATION_PAGE_ITEMS view.';
comment on column apex_application_page_db_items.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_db_items.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_db_items.application_name  is 'Identifies the application';
comment on column apex_application_page_db_items.page_id           is 'Identifies the application';
comment on column apex_application_page_db_items.page_name         is 'Identifies a page within an application';
comment on column apex_application_page_db_items.item_name         is 'Apex page item name';
comment on column apex_application_page_db_items.DISPLAY_AS        is 'Identifies how the item will be displayed in the HTML page';
comment on column apex_application_page_db_items.DISPLAY_SEQUENCE  is 'Identifies the sequence the page item will be displayed within a region';
comment on column apex_application_page_db_items.REGION            is 'Identifies the region in which the item will be displayed';
comment on column apex_application_page_db_items.ITEM_LABEL        is 'Identifies the item label';
comment on column apex_application_page_db_items.DB_COLUMN_NAME    is 'Identifies the item source database column name';
comment on column apex_application_page_db_items.DB_TABLE_NAME     is 'Identifies the item source database table name';
comment on column apex_application_page_db_items.HELP_TEXT         is 'Identifies the help text for the page item';
comment on column apex_application_page_db_items.ITEM_ID           is 'Primary key of this component';
grant select on apex_application_page_db_items to public;


---------------------------------------------------
-- A P P L I C A T I O N   P A G E   R E G I O N S
-- 4651

prompt ...apex_application_page_regions

create or replace view apex_application_page_regions
as
select
    w.short_name                         workspace,
    p.flow_id                            application_id,
    f.name                               application_name,
    p.id                                 page_id,
    p.name                               page_name,
    --
    r.plug_name                          region_name,
    nvl(decode(nvl(r.PLUG_TEMPLATE,0),0,
     'No Template',
     (select PAGE_PLUG_TEMPLATE_NAME
     from wwv_flow_page_plug_templates
     where id = r.PLUG_TEMPLATE)),'No Template') template,
    r.PLUG_TEMPLATE                      template_id,
    r.region_name                        static_id,
    r.PLUG_DISPLAY_SEQUENCE              display_sequence,
    r.REGION_ATTRIBUTES_SUBSTITUTION     REGION_ATTRIBUTES_SUBSTITUTION,
    r.PLUG_DISPLAY_COLUMN                display_column,
    decode(r.PLUG_DISPLAY_POINT,
       'AFTER_HEADER',       'After Header',
       'BEFORE_BOX_BODY',    'Page Template Body (1. items below region content)',
       'BEFORE_SHOW_ITEMS',  'Page Template Body (2. items below region content)',
       'AFTER_SHOW_ITEMS',   'Page Template Body (3. items above region content)',
       'BEFORE_FOOTER',      'Before Footer',
       'REGION_POSITION_01', 'Page Template Region Position 1',
       'REGION_POSITION_02', 'Page Template Region Position 2',
       'REGION_POSITION_03', 'Page Template Region Position 3',
       'REGION_POSITION_04', 'Page Template Region Position 4',
       'REGION_POSITION_05', 'Page Template Region Position 5',
       'REGION_POSITION_06', 'Page Template Region Position 6',
       'REGION_POSITION_07', 'Page Template Region Position 7',
       'REGION_POSITION_08', 'Page Template Region Position 8',
       r.PLUG_DISPLAY_POINT)
                                         display_position,
    r.plug_display_point                 display_position_code,
    --
    r.PLUG_SOURCE                        region_source,
    (select name
    from   wwv_flow_menu_templates
    where  id = to_char(r.MENU_TEMPLATE_ID)
    and    flow_id = f.id)                 breadcrumb_template,
    r.MENU_TEMPLATE_ID                     breadcrumb_template_id,
    --
    (select list_template_name
    from wwv_flow_list_templates
    where id = r.LIST_TEMPLATE_ID)         list_template_override,
    r.LIST_TEMPLATE_ID                     list_template_override_id,
    --
    decode(r.PLUG_SOURCE_TYPE,
        'PLSQL_PROCEDURE','PL/SQL',
        'SIMPLE_CHART','HTML Chart',
        'SQL_QUERY','Report',
        'DYNAMIC_QUERY','Interactive Report',
        'STATIC_TEXT','HTML/Text',
        'STATIC_TEXT_ESCAPE_SC','HTML/Text (escape special characters)',
        'STATIC_TEXT_WITH_SHORTCUTS','HTML/Text (with shortcuts)',
        'STRUCTURED_QUERY','Report',
        'FUNCTION_RETURNING_SQL_QUERY','Report',
        'SVG_CHART','SVG Chart',
        'TREE','Tree',
        'UPDATABLE_SQL_QUERY','Tabular Form',
        'URL','URL',
        decode(substr(r.PLUG_SOURCE_TYPE,1,1),'M','Breadcrumb','List'))
                                         source_type,
    --
    r.PLUG_DISPLAY_ERROR_MESSAGE         on_error_message,
    --
    decode(substr(r.PLUG_REQUIRED_ROLE,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(r.PLUG_REQUIRED_ROLE,'!')
     and    flow_id = f.id),
     r.PLUG_REQUIRED_ROLE)               authorization_scheme,
    r.PLUG_REQUIRED_ROLE                 authorization_scheme_id,
    nvl((select r from apex_standard_conditions where d = r.PLUG_DISPLAY_CONDITION_TYPE),r.PLUG_DISPLAY_CONDITION_TYPE)
                                         condition_type,
    r.PLUG_DISPLAY_WHEN_CONDITION        condition_expression1,
    r.PLUG_DISPLAY_WHEN_COND2            condition_expression2,
    --
    r.PLUG_HEADER                        region_header_text,
    r.PLUG_FOOTER                        region_footer_text,
    (select row_template_name from wwv_flow_row_templates where id = r.PLUG_QUERY_ROW_TEMPLATE)
                                         report_template,
    r.PLUG_QUERY_ROW_TEMPLATE            report_template_id,
    r.PLUG_QUERY_HEADINGS                report_column_headings,
    r.PLUG_QUERY_HEADINGS_TYPE           headings_type,
    r.PLUG_QUERY_NUM_ROWS                maximum_rows_to_query,
    decode(r.PLUG_QUERY_NUM_ROWS_TYPE,
       'ROWS_X_TO_Y_OF_Z','Row Ranges X to Y of Z (no pagination)',
       'ROWS_X_TO_Y','Row Ranges X to Y (no pagination)',
       'SEARCH_ENGINE','Search Engine 1,2,3,4 (set based pagination)',
       'COMPUTED_BUT_NOT_DISPLAYED','Use Externally Created Pagination Buttons',
       'ROW_RANGES','Row Ranges 1-15 16-30 (with set pagination)',
       'ROW_RANGES_IN_SELECT_LIST','Row Ranges 1-15 16-30 in select list (with pagination)',
       'ROW_RANGES_WITH_LINKS','Row Ranges X to Y of Z (with pagination)',
       'NEXT_PREVIOUS_LINKS','Row Ranges X to Y (with next and previous links)',
       r.PLUG_QUERY_NUM_ROWS_TYPE)       pagination_scheme,
    decode(r.PAGINATION_DISPLAY_POSITION,
      'BOTTOM_LEFT','Bottom - Left',
      'BOTTOM_RIGHT','Bottom - Right',
      'TOP_LEFT','Top - Left',
      'TOP_RIGHT','Top - Right',
      'TOP_AND_BOTTOM_LEFT','Top and Bottom - Left',
      'TOP_AND_BOTTOM_RIGHT','Top and Bottom - Right',
      r.PAGINATION_DISPLAY_POSITION)     pagination_display_position,
    decode(r.ajax_enabled,'Y','Yes','N','No',r.ajax_enabled) ajax_enabled,
    r.PLUG_QUERY_NUM_ROWS_ITEM           number_of_rows_item,
    r.PLUG_QUERY_NO_DATA_FOUND           no_data_found_message,
    r.PLUG_QUERY_MORE_DATA               more_data_found_message,
    r.PLUG_QUERY_ROW_COUNT_MAX           maximum_row_count,
    --r.PLUG_QUERY_FORMAT_OUT              query_format_out,
    r.PLUG_QUERY_SHOW_NULLS_AS           report_null_values_as,
    --r.PLUG_QUERY_COL_ALLIGNMENTS         ,
    r.PLUG_QUERY_BREAK_COLS              breaks,
    --r.PLUG_QUERY_SUM_COLS                ,
    --r.PLUG_QUERY_NUMBER_FORMATS          ,
    --r.PLUG_QUERY_TABLE_BORDER            ,
    --r.PLUG_QUERY_HIT_HIGHLIGHTING        ,
    r.PLUG_QUERY_ASC_IMAGE               ascending_image,
    r.PLUG_QUERY_ASC_IMAGE_ATTR          ascending_image_attributes,
    r.PLUG_QUERY_DESC_IMAGE              descending_image,
    r.PLUG_QUERY_DESC_IMAGE_ATTR         descending_image_attributes,
    r.PLUG_QUERY_EXP_FILENAME            filename,
    r.PLUG_QUERY_EXP_SEPARATOR           separator,
    r.PLUG_QUERY_EXP_ENCLOSED_BY         enclosed_by,
    decode(r.PLUG_QUERY_STRIP_HTML,
      'Y','Yes',
      'N','No',
      r.PLUG_QUERY_STRIP_HTML)           strip_html,
    r.PLUG_QUERY_OPTIONS                 report_column_source_type,
    r.PLUG_QUERY_MAX_COLUMNS             max_dynamic_report_cols,
    r.PLUG_COLUMN_WIDTH                  HTML_table_cell_attributes,
    decode(r.PLUG_CUSTOMIZED,
       null,'None',
       '2','Customizable and Not Shown By Default',
       '1','Customizable and Shown By Default',
       '0','Not Customizable By End Users',
       r.PLUG_CUSTOMIZED)                 customization,
    r.PLUG_CUSTOMIZED_NAME                customization_name,
    --r.PLUG_OVERRIDE_REG_POS              ,
    (select case when r.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id=abs(r.REQUIRED_PATCH) )         build_option,
    r.required_patch                     build_option_id,
    --
    --r.PLUG_URL_TEXT_BEGIN                ,
    --r.PLUG_URL_TEXT_END                  ,
    --
    -- region caching
    --
    nvl(decode(r.PLUG_CACHING,
    'CACHED','Cached',
    'CACHED_BY_USER','Cached by User',
    'NOT_CACHED','Not Cached',
    null,'Not Cached'),'Not Cached')     region_caching,
    --r.PLUG_CACHING_SESSION_STATE         ,
    r.PLUG_CACHING_MAX_AGE_IN_SEC        timeout_cache_after,
    r.PLUG_CACHE_WHEN                    cache_when,
    r.PLUG_CACHE_EXPRESSION1             cache_when_expression_1,
    r.PLUG_CACHE_EXPRESSION2             cache_when_expression_2,
    --r.PLUG_IGNORE_PAGINATION             ,
    --r.PLUG_CHART_FONT_SIZE               ,
    --r.PLUG_CHART_MAX_ROWS                ,
    --r.PLUG_CHART_NUM_MASK                ,
    --r.PLUG_CHART_SCALE                   ,
    --r.PLUG_CHART_AXIS                    ,
    --r.PLUG_CHART_SHOW_SUMMARY            ,
    r.REPORT_TOTAL_TEXT_FORMAT           sum_display_text,
    r.BREAK_COLUMN_TEXT_FORMAT           break_display_text,
    r.BREAK_BEFORE_ROW                   before_break_display_text,
    r.BREAK_GENERIC_COLUMN               break_column_display_text,
    r.BREAK_AFTER_ROW                    after_break_display_text,
    decode(
       r.BREAK_TYPE_FLAG,
       'REPEAT_HEADINGS_ON_BREAK_1','Repeat Headings on Break',
       'DEFAULT_BREAK_FORMATTING','Default Break Formatting',
       r.BREAK_TYPE_FLAG)                break_display_flag,
    r.BREAK_REPEAT_HEADING_FORMAT        repeat_heading_break_format,
    decode(r.CSV_OUTPUT,
    'Y','Yes','N','No',r.CSV_OUTPUT)     enable_csv_output,
    r.CSV_OUTPUT_LINK_TEXT               csv_link_label,
    r.PRINT_URL                          URL,
    r.PRINT_URL_LABEL                    link_label,
    decode(r.TRANSLATE_TITLE,
    'Y','Yes','N','No','Yes')            translate_region_title,
    --
    r.LAST_UPDATED_BY                    last_updated_by,
    r.LAST_UPDATED_ON                    last_updated_on,
    r.PLUG_COMMENT                       component_comment,
    r.id                                 region_id,
    --
    (select count(*) from wwv_flow_step_items where r.id = ITEM_PLUG_ID and r.flow_id = flow_id and nvl(display_as,'x') != 'BUTTON') items,
    ((select count(*) from wwv_flow_step_items where r.id = ITEM_PLUG_ID and r.flow_id = flow_id and nvl(display_as,'x') = 'BUTTON') +
     (select count(*) from wwv_flow_step_buttons where r.id = button_plug_id and r.flow_id = flow_id)) buttons,
     --
     region_name||'.'||
     lpad(r.plug_display_sequence,5,'00000')
     ||',c='||r.PLUG_DISPLAY_column
     ||',temp='||nvl(decode(nvl(r.PLUG_TEMPLATE,0),0,'No Template',(select PAGE_PLUG_TEMPLATE_NAME from wwv_flow_page_plug_templates where id = r.PLUG_TEMPLATE)),'No Template')
     ||',pos='||decode(r.PLUG_DISPLAY_POINT,
       'AFTER_HEADER',       'After Header',
       'BEFORE_BOX_BODY',    'Page Template Body (1. items below region content)',
       'BEFORE_SHOW_ITEMS',  'Page Template Body (2. items below region content)',
       'AFTER_SHOW_ITEMS',   'Page Template Body (3. items above region content)',
       'BEFORE_FOOTER',      'Before Footer',
       'REGION_POSITION_01', 'Page Template Region Position 1',
       'REGION_POSITION_02', 'Page Template Region Position 2',
       'REGION_POSITION_03', 'Page Template Region Position 3',
       'REGION_POSITION_04', 'Page Template Region Position 4',
       'REGION_POSITION_05', 'Page Template Region Position 5',
       'REGION_POSITION_06', 'Page Template Region Position 6',
       'REGION_POSITION_07', 'Page Template Region Position 7',
       'REGION_POSITION_08', 'Page Template Region Position 8',
       r.PLUG_DISPLAY_POINT)
     ||',src='||decode(translate(dbms_lob.substr(r.PLUG_SOURCE,1,1),'M0123456789.','000000000000'),'0','Ref',dbms_lob.substr(r.PLUG_SOURCE,30,1)||'.'||dbms_lob.getlength(r.PLUG_SOURCE))
     ||(select ',bo='||PATCH_NAME b from wwv_flow_patches where id=abs(r.REQUIRED_PATCH))
     ||decode(r.PLUG_DISPLAY_ERROR_MESSAGE,null,null,',ErrMsg='||length(r.PLUG_DISPLAY_ERROR_MESSAGE))
     ||nvl((select ',auth='||name n from wwv_flow_security_schemes where to_char(id) = ltrim(r.PLUG_REQUIRED_ROLE,'!') and flow_id = f.id),r.PLUG_REQUIRED_ROLE)
     ||decode(r.PAGINATION_DISPLAY_POSITION,
      'BOTTOM_LEFT','Bottom-L',
      'BOTTOM_RIGHT','Bottom-R',
      'TOP_LEFT','Top-L',
      'TOP_RIGHT','Top-R',
      'TOP_AND_BOTTOM_LEFT','Top+Bottom-L',
      'TOP_AND_BOTTOM_RIGHT','Top+Bottom-R',
      r.PAGINATION_DISPLAY_POSITION)
      ||r.PLUG_QUERY_NUM_ROWS_TYPE
      ||r.PLUG_DISPLAY_CONDITION_TYPE
      ||substr(r.PLUG_DISPLAY_WHEN_CONDITION,1,20)||'.'||length(r.PLUG_DISPLAY_WHEN_CONDITION)
      ||substr(r.PLUG_DISPLAY_WHEN_COND2,1,20)||'.'||length(r.PLUG_DISPLAY_WHEN_COND2)
      ||decode(
       r.BREAK_TYPE_FLAG,
       'REPEAT_HEADINGS_ON_BREAK_1','RepHead on Br',
       'DEFAULT_BREAK_FORMATTING','DefBreakFor',
       r.BREAK_TYPE_FLAG)
      ||decode(r.CSV_OUTPUT,'Y','Yes','N','No',r.CSV_OUTPUT)
      ||(select ',rtmp='||row_template_name t from wwv_flow_row_templates where id = r.PLUG_QUERY_ROW_TEMPLATE)
      ||decode(r.PLUG_QUERY_NUM_ROWS,null,null,'mr='||r.PLUG_QUERY_NUM_ROWS)
      ||r.BREAK_REPEAT_HEADING_FORMAT
      ||r.CSV_OUTPUT_LINK_TEXT
      ||substr(r.PRINT_URL,1,10)||length(r.PRINT_URL)
      ||length(PRINT_URL_LABEL)
      ||decode(r.TRANSLATE_TITLE,'Y','Yes','N','No','Yes')||
      length(PLUG_HEADER)||length(PLUG_FOOTER)
      ||r.PLUG_CUSTOMIZED
      ||length(r.PLUG_COLUMN_WIDTH)
      ||substr(r.region_name,1,15)
      ||length(REGION_ATTRIBUTES_SUBSTITUTION)
     component_signature
from wwv_flow_page_plugs r,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.id = p.flow_id and
      f.id = r.flow_id and
      p.id = r.page_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/



comment on table  apex_application_page_regions                               is 'Identifies a content container associated with a Page and displayed within a position defined by the Page Template';
comment on column apex_application_page_regions.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_regions.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_regions.application_name              is 'Identifies the application';
comment on column apex_application_page_regions.page_id                       is 'Identifies the application';
comment on column apex_application_page_regions.page_name                     is 'Identifies a page within an application';
comment on column apex_application_page_regions.REGION_NAME                   is 'Identifies the Region Name.  The display of the region name is controlled by the Region Template substitution string TITLE.';
comment on column apex_application_page_regions.TEMPLATE                      is 'Identifies the template used to display the region';
comment on column apex_application_page_regions.TEMPLATE_ID                   is 'Foreign Key';
comment on column apex_application_page_regions.DISPLAY_SEQUENCE              is 'Identifies the Display Sequence of the Region within each Display Position';
comment on column apex_application_page_regions.REGION_ATTRIBUTES_SUBSTITUTION is 'Identifies text to be substituted by the region template #REGION_ATTRIBUTES# substituion string';
comment on column apex_application_page_regions.DISPLAY_COLUMN                is 'Identifies the column used to display the region, allows regions to be positioned in a second column within a single Display Position.';
comment on column apex_application_page_regions.DISPLAY_POSITION              is 'Identifies the position within the Page Template that the Region will be displayed';
comment on column apex_application_page_regions.DISPLAY_POSITION_CODE         is 'Identifies the coded value of the position within the Page Template that the Region will be displayed';
comment on column apex_application_page_regions.REGION_SOURCE                 is 'Identifies the source of the region, reference Region Source Type';
comment on column apex_application_page_regions.LIST_TEMPLATE_OVERRIDE        is 'Identifies the List Template to be used to display regions of type List.  By default the List Template is defined in the List definition, if a value is specified in this attribute, this template will be used to render the List.';
comment on column apex_application_page_regions.SOURCE_TYPE                   is 'Identifies how Apex will interpret the Region Source';
comment on column apex_application_page_regions.ON_ERROR_MESSAGE              is 'Identifies the error text to be displayed when the display of a region results in an error';
comment on column apex_application_page_regions.AUTHORIZATION_SCHEME          is 'An authorization scheme must evaluate to TRUE in order for this component to be displayed';
comment on column apex_application_page_regions.AUTHORIZATION_SCHEME_ID       is 'Foreign Key';
comment on column apex_application_page_regions.CONDITION_TYPE                is 'Identifies the condition type used to conditionally display the region';
comment on column apex_application_page_regions.CONDITION_EXPRESSION1         is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_regions.CONDITION_EXPRESSION2         is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_regions.REPORT_TEMPLATE               is 'Report templates provide control over the results of a row from your SQL query';
comment on column apex_application_page_regions.MAXIMUM_ROWS_TO_QUERY         is 'Specifies the maximum rows that can be retuned by a given query.  Avoids attempting to send millions of rows to a web browser.';
comment on column apex_application_page_regions.PAGINATION_SCHEME             is 'Pagination provides the user with information about the number of rows and the current position within the result set. Pagination also defines the style of links or buttons that are used to navigate to the next or previous page.';
comment on column apex_application_page_regions.PAGINATION_DISPLAY_POSITION   is 'Pagination can be displayed on the left side, right side, at the bottom, or above the report.';
comment on column apex_application_page_regions.AJAX_ENABLED                  is 'Specifies if the region is ajax enabled.';
comment on column apex_application_page_regions.NUMBER_OF_ROWS_ITEM           is 'Defines the maximum number of rows to display per page.';
comment on column apex_application_page_regions.NO_DATA_FOUND_MESSAGE         is 'Defines the text message that displays when the query does not return any rows.';
comment on column apex_application_page_regions.MORE_DATA_FOUND_MESSAGE       is 'Defines the text message that displays when more rows exist.';
comment on column apex_application_page_regions.MAXIMUM_ROW_COUNT             is 'Defines the maximum number of rows to query, relevant for pagination schemes which display "Rows X - Y of Z".  Counting fewer rows can improve performance and counting thousands of rows can degrade performance.';
comment on column apex_application_page_regions.REPORT_NULL_VALUES_AS         is 'Identifies the text to display for null columns. The default value is "(null)".';
comment on column apex_application_page_regions.BREAKS                        is 'Identifies how breaks should be formatted.';
comment on column apex_application_page_regions.ASCENDING_IMAGE               is 'Defines the image shown in report headings to sort column values in ascending order.';
comment on column apex_application_page_regions.ASCENDING_IMAGE_ATTRIBUTES    is 'Image attributes for sort images used to define attributes such width and height of image.';
comment on column apex_application_page_regions.DESCENDING_IMAGE              is 'Defines the image shown in report headings to sort column values in descending order.';
comment on column apex_application_page_regions.DESCENDING_IMAGE_ATTRIBUTES   is 'Image attributes for sort images used to define attributes such width and height of image.';
comment on column apex_application_page_regions.FILENAME                      is 'Specify a name for the export file. If no name is specified, the region name is used followed by the extension .csv.';
comment on column apex_application_page_regions.SEPARATOR                     is 'Identifies a column separator. If no value is entered, a comma or semicolon is used depending on your current NLS settings.';
comment on column apex_application_page_regions.ENCLOSED_BY                   is 'Identifies a delimiter character. This character is used to delineate the starting and ending boundary of a data value. Default delimiter is double quotes.';

comment on column apex_application_page_regions.static_id                     is 'Reference this value using the substitution string #REGION_STATIC_ID#';
comment on column apex_application_page_regions.headings_type                 is 'Identifies the how report column headings are computed';
comment on column apex_application_page_regions.report_column_headings        is 'Report column heading override, can be used to define dynamic report column headings';
comment on column apex_application_page_regions.customization                 is 'Identifies level of customization support for this page region';
comment on column apex_application_page_regions.customization_name            is 'Name of region to show in popup customization window';
comment on column apex_application_page_regions.list_template_override_id     is 'Foreign key of list template override';
comment on column apex_application_page_regions.HTML_table_cell_attributes    is 'When generating HTML to display items use these HTML table cell attributes';

comment on column apex_application_page_regions.max_dynamic_report_cols       is 'Maximum number of dynamic report columns';
comment on column apex_application_page_regions.report_column_source_type     is 'Determines how report columns will be computed, values include DERIVED_REPORT_COLUMNS and GENERIC_REPORT_COLUMNS';
comment on column apex_application_page_regions.break_display_text            is 'Text displayed on control breaks';
comment on column apex_application_page_regions.STRIP_HTML                    is 'Specifies whether or not to remove HTML tags from the original column values for HTML expressions, column links and report data exported as CSV files.';
comment on column apex_application_page_regions.BUILD_OPTION                  is 'Region will be displayed if the Build Option is enabled';
comment on column apex_application_page_regions.BUILD_OPTION_ID               is 'Foreign Key';
comment on column apex_application_page_regions.SUM_DISPLAY_TEXT              is 'Display this text when printing report sums';
comment on column apex_application_page_regions.BEFORE_BREAK_DISPLAY_TEXT     is 'Defines the text that displays before break columns when displaying a break row.';
comment on column apex_application_page_regions.BREAK_COLUMN_DISPLAY_TEXT     is 'Defines the column template to use when displaying a column break. Use #COLUMN_VALUE# substitutions.';
comment on column apex_application_page_regions.AFTER_BREAK_DISPLAY_TEXT      is 'Defines the text that displays after break columns when displaying a break row.';
comment on column apex_application_page_regions.REPEAT_HEADING_BREAK_FORMAT   is 'Defines the heading template for repeating headings on column 1. Use #COLUMN_VALUE# substitutions.';
comment on column apex_application_page_regions.ENABLE_CSV_OUTPUT             is 'Enables the query results to be spooled to a CSV file. To enable this option, you must use a report template with a #CSV_LINK# substitution string and set this option to YES.';
comment on column apex_application_page_regions.CSV_LINK_LABEL                is 'Specifies the text for the link which will invoke the CSV download.';
comment on column apex_application_page_regions.URL                           is 'Specifies the URL to a server for post processing of a report. See documentation for instructions.';
comment on column apex_application_page_regions.LINK_LABEL                    is 'Specifies the text for the link which will invoke the external processing engine.';
comment on column apex_application_page_regions.TRANSLATE_REGION_TITLE        is 'Identifies if this region title should be a candidate for translation or not (Yes or No)';
comment on column apex_application_page_regions.break_display_flag            is 'Identify how you would like your breaks to be displayed';
comment on column apex_application_page_regions.COMPONENT_COMMENT             is 'Developer comment';
comment on column apex_application_page_regions.REGION_ID                     is 'Primary Key of this Region';
comment on column apex_application_page_regions.ITEMS                         is 'Count of Items corresponding to this region';
comment on column apex_application_page_regions.BUTTONS                       is 'Count of Buttons corresponding to this region';
comment on column apex_application_page_regions.last_updated_by               is 'Apex developer who made last update';
comment on column apex_application_page_regions.last_updated_on               is 'Date of last update';
comment on column apex_application_page_regions.region_caching                is 'Identifies caching method';
comment on column apex_application_page_regions.timeout_cache_after           is 'Identify how long a cached region will remain valid in seconds';
comment on column apex_application_page_regions.cache_when                    is 'Identifies a condition must be true for the region to be cached or to render from cache';
comment on column apex_application_page_regions.cache_when_expression_1       is 'Identifies expression corresponding to Cache When condition';
comment on column apex_application_page_regions.cache_when_expression_2       is 'Identifies expression corresponding to Cache When condition';
comment on column apex_application_page_regions.component_signature           is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_application_page_regions.breadcrumb_template           is 'Identifies breadcrumb template';
comment on column apex_application_page_regions.breadcrumb_template_id        is 'Identifies breadcrumb template ID';
comment on column apex_application_page_regions.report_template_id            is 'Identifies report template ID';

grant select on   apex_application_page_regions to public;


create or replace view apex_application_page_rpt
as
select
    w.short_name                         workspace,
    p.flow_id                            application_id,
    f.name                               application_name,
    p.id                                 page_id,
    p.name                               page_name,
    --
    r.plug_name                          region_name,
    decode(r.PLUG_SOURCE_TYPE,
        'SQL_QUERY','Report',
        'STRUCTURED_QUERY','Report',
        'FUNCTION_RETURNING_SQL_QUERY','Report',
        'UPDATABLE_SQL_QUERY','Tabular Form') source_type,
    PRN_BODY_BG_COLOR                         body_background_color,
    PRN_BODY_FONT_COLOR                       body_font_color,
    PRN_BODY_FONT_FAMILY                      body_font_family,
    PRN_BODY_FONT_SIZE                        body_font_size,
    PRN_BODY_FONT_WEIGHT                      body_font_weight,
    PRN_BORDER_COLOR                          border_color,
    PRN_BORDER_WIDTH                          border_width,
    PRN_FORMAT                                format,
    PRN_FORMAT_ITEM                           format_item,
    PRN_PAGE_HEADER                           page_header,
    PRN_PAGE_HEADER_ALIGNMENT                 page_header_alignment,
    PRN_PAGE_HEADER_FONT_COLOR                page_header_font_color,
    PRN_PAGE_HEADER_FONT_FAMILY               page_header_font_family,
    PRN_PAGE_HEADER_FONT_SIZE                 page_header_font_size,
    PRN_PAGE_HEADER_FONT_WEIGHT               page_header_font_weight,
    PRN_HEADER_BG_COLOR                       header_background_color,
    PRN_HEADER_FONT_COLOR                     header_font_color,
    PRN_HEADER_FONT_FAMILY                    header_font_family,
    PRN_HEADER_FONT_SIZE                      header_font_size,
    PRN_HEADER_FONT_WEIGHT                    header_font_weight,
    PRN_HEIGHT                                height,
    PRN_ORIENTATION                           orientation,
    PRN_OUTPUT                                output,
    prn_print_server_overwrite                print_server_override,
    PRN_OUTPUT_FILE_NAME                      output_file_name,
    prn_content_disposition                   content_disposition,
    prn_document_header                       document_header,
    PRN_OUTPUT_LINK_TEXT                      output_link_text,
    PRN_OUTPUT_SHOW_LINK                      show_output_link,
    PRN_PAGE_FOOTER                           footer,
    PRN_PAGE_FOOTER_ALIGNMENT                 footer_alignment,
    PRN_PAGE_FOOTER_FONT_COLOR                footer_font_color,
    PRN_PAGE_FOOTER_FONT_FAMILY               footer_font_family,
    PRN_PAGE_FOOTER_FONT_SIZE                 footer_font_size,
    PRN_PAGE_FOOTER_FONT_WEIGHT               footer_font_weight,
    --
    PRN_PAPER_SIZE                            paper_size,
    PRN_TEMPLATE_ID                           template_id,
    PRN_UNITS                                 paper_size_units,
    prn_width_units                           paper_size_width_units,
    PRN_WIDTH                                 paper_size_width,
    --
    r.LAST_UPDATED_BY                    last_updated_by,
    r.LAST_UPDATED_ON                    last_updated_on,
    r.PLUG_COMMENT                       component_comment,
    r.id                                 region_id,
    --
     region_name||'.'
     ||PRN_BODY_BG_COLOR
     ||PRN_BODY_FONT_COLOR
     ||PRN_BODY_FONT_FAMILY
     ||PRN_BODY_FONT_SIZE
     ||PRN_BODY_FONT_WEIGHT
     ||PRN_BORDER_COLOR
     ||PRN_BORDER_WIDTH
     ||length(PRN_FORMAT)
     ||PRN_FORMAT_ITEM
     ||length(PRN_PAGE_HEADER)
     ||PRN_PAGE_HEADER_ALIGNMENT
     ||PRN_PAGE_HEADER_FONT_COLOR
     ||PRN_PAGE_HEADER_FONT_FAMILY
     ||PRN_PAGE_HEADER_FONT_SIZE
     ||PRN_PAGE_HEADER_FONT_WEIGHT
     ||PRN_HEADER_BG_COLOR
     ||PRN_HEADER_FONT_COLOR
     ||PRN_HEADER_FONT_FAMILY
     ||PRN_HEADER_FONT_SIZE
     ||PRN_HEADER_FONT_WEIGHT
     ||PRN_HEIGHT
     ||PRN_ORIENTATION
     ||PRN_OUTPUT
     ||PRN_OUTPUT_FILE_NAME
     ||PRN_CONTENT_DISPOSITION
     ||PRN_DOCUMENT_HEADER
     ||PRN_UNITS
     ||PRN_OUTPUT_LINK_TEXT
     ||PRN_OUTPUT_SHOW_LINK
     ||length(PRN_PAGE_FOOTER)
     ||PRN_PAGE_FOOTER_ALIGNMENT
     ||PRN_PAGE_FOOTER_FONT_COLOR
     ||PRN_PAGE_FOOTER_FONT_FAMILY
     ||PRN_PAGE_FOOTER_FONT_SIZE
     ||PRN_PAGE_FOOTER_FONT_WEIGHT
     ||PRN_PAPER_SIZE
     ||PRN_TEMPLATE_ID
     ||PRN_UNITS
     ||PRN_WIDTH
     component_signature
from wwv_flow_page_plugs r,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.id = p.flow_id and
      f.id = r.flow_id and
      p.id = r.page_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      r.PLUG_SOURCE_TYPE in ('SQL_QUERY','STRUCTURED_QUERY','FUNCTION_RETURNING_SQL_QUERY','UPDATABLE_SQL_QUERY') and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/
comment on table  apex_application_page_rpt                  is 'Printing attributes for regions that are reports';
comment on column apex_application_page_rpt.workspace        is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_rpt.application_id   is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_rpt.application_name is 'Identifies the application';
comment on column apex_application_page_rpt.page_id          is 'Identifies the application';
comment on column apex_application_page_rpt.page_name        is 'Identifies a page within an application';
comment on column apex_application_page_rpt.REGION_NAME      is 'Identifies the Region Name.  The display of the region name is controlled by the Region Template substitution string TITLE.';
comment on column apex_application_page_rpt.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_page_rpt to public;



create or replace view apex_application_page_rpt_cols
as
select
     w.short_name                          workspace,
     p.flow_id                             application_id,
     f.name                                application_name,
     p.id                                  page_id,
     p.name                                page_name,
     region.plug_Name                      region_name,
     --
     --r.QUERY_COLUMN_ID                     ,
     --r.FORM_ELEMENT_ID                     ,
     r.COLUMN_ALIAS                        column_alias,
     r.COLUMN_DISPLAY_SEQUENCE             display_sequence,
     r.COLUMN_HEADING                      heading,
     r.COLUMN_FORMAT                       format_mask,
     r.COLUMN_HTML_EXPRESSION              html_expression,
     r.COLUMN_CSS_CLASS                    css_class,
     r.COLUMN_CSS_STYLE                    css_style,
     r.COLUMN_HIT_HIGHLIGHT                highlight_words,
     --
     r.COLUMN_LINK                         column_link_url,
     r.COLUMN_LINKTEXT                     column_link_text,
     r.COLUMN_LINK_ATTR                    column_link_attributes,
     --
     r.COLUMN_LINK_CHECKSUM_TYPE           page_checksum,
     --
     r.COLUMN_ALIGNMENT                    column_alignment,
     r.HEADING_ALIGNMENT                   heading_alignment,
     --
     r.DEFAULT_SORT_COLUMN_SEQUENCE        default_sort_sequence,
     r.DEFAULT_SORT_DIR                    default_sort_direction,
     decode(r.DISABLE_SORT_COLUMN,
       'Y','Yes','N','No',
       r.DISABLE_SORT_COLUMN)              sortable_column,
     decode(r.SUM_COLUMN,
       'Y','Yes','N','No',
       r.SUM_COLUMN)                       sum_column,
     decode(r.HIDDEN_COLUMN ,
       'Y','Yes','N','No',
       r.HIDDEN_COLUMN )                   column_is_hidden,
     --
     r.DISPLAY_WHEN_COND_TYPE              condition_type,
     r.DISPLAY_WHEN_CONDITION              condition_expression1,
     r.DISPLAY_WHEN_CONDITION2             condition_expression2,
     --
     decode(substr(r.REPORT_COLUMN_REQUIRED_ROLE,1,1),'!','Not ')||
     nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(r.REPORT_COLUMN_REQUIRED_ROLE,'!')
     and    flow_id = f.id),
            r.REPORT_COLUMN_REQUIRED_ROLE)
                                           authorization_scheme,
     r.REPORT_COLUMN_REQUIRED_ROLE         authorization_scheme_id,
     --
     r.LAST_UPDATED_BY                     last_updated_by,
     r.LAST_UPDATED_ON                     last_updated_on,
     --
     decode(r.DISPLAY_AS,
        'WITHOUT_MODIFICATION','Standard Report Column',
        'TEXT_FROM_LOV','Display as Text (based on LOV, does not save state)',
        'DISPLAY_AND_SAVE','Display as Text (saves state)',
        'ESCAPE_SC','Display as Text (escape special characters, does not save state)',
        'DATE_POPUP','Date Picker',
        'TEXT','Text Field',
        'TEXTAREA','Text Area',
        'SELECT_LIST','Select List (static LOV)',
        'SELECT_LIST_FROM_LOV','Select List (named LOV)',
        'SELECT_LIST_FROM_QUERY','Select List (query based LOV)',
        'HIDDEN','Hidden',
        'POPUP','Popup LOV (named LOV)',
        'POPUP_QUERY','Popup LOV (query based LOV)',
        r.DISPLAY_AS)                      display_as,
     --
     decode((select lov_name
      from wwv_flow_lists_of_values$
      where id = r.NAMED_LOV),null,null,
      (select lov_name
      from wwv_flow_lists_of_values$
      where id = r.NAMED_LOV))                            named_list_of_values,
     r.INLINE_LOV                          inline_list_of_values,
     decode(r.LOV_SHOW_NULLS,
       'YES','Yes','NO','No',
       r.LOV_SHOW_NULLS)                   LOV_SHOW_NULLS,
     decode(r.LOV_DISPLAY_EXTRA,
       'YES','Yes','NO','No',
       r.LOV_DISPLAY_EXTRA)                LOV_DISPLAY_EXTRA_VALUES,
     r.LOV_NULL_TEXT                       lov_null_text,
     r.LOV_NULL_VALUE                      lov_null_value,
     --
     r.COLUMN_WIDTH                        form_element_width,
     r.COLUMN_HEIGHT                       form_element_height,
     r.CATTRIBUTES                         form_Element_Attributes,
     r.CATTRIBUTES_ELEMENT                 form_Element_Option_Attributes,
     --
     --r.COLUMN_COMMENT                      ,
     r.PK_COL_SOURCE_TYPE                  primary_key_column_source_type,
     r.PK_COL_SOURCE                       primary_key_column_source,
     decode(r.DERIVED_COLUMN,
       'Y','Yes',
        r.DERIVED_COLUMN)                  derived_column,
     --
     r.COLUMN_DEFAULT                      column_default,
     r.COLUMN_DEFAULT_TYPE                 column_default_type,
     --
     r.REF_SCHEMA                          reference_schema,
     r.REF_TABLE_NAME                      reference_table_name,
     r.REF_COLUMN_NAME                     reference_column_name,
     --
     decode(include_in_export,'Y','Yes','N','No') include_in_export,
     print_col_width                       print_column_width,
     print_col_align                       print_column_alignment,
     COLUMN_COMMENT                        column_comment,
     --
     region.id                             region_id,
     r.id                                  region_report_column_id,
     --
     substr(r.COLUMN_ALIAS,1,30)
     ||' s='||r.COLUMN_DISPLAY_SEQUENCE
     ||' h='||substr(r.COLUMN_HEADING,1,15)||length(r.COLUMN_HEADING)
     ||substr(r.COLUMN_FORMAT,1,15)||length(r.COLUMN_FORMAT)
     ||' e='||substr(r.COLUMN_HTML_EXPRESSION,1,15)||length(r.COLUMN_HTML_EXPRESSION)
     ||substr(r.COLUMN_CSS_CLASS,1,20)
     ||substr(r.COLUMN_CSS_STYLE,1,20)
     ||substr(r.COLUMN_HIT_HIGHLIGHT,1,15)||length(r.COLUMN_HIT_HIGHLIGHT)
     ||' l='||substr(r.COLUMN_LINK,1,20)||length(r.COLUMN_LINK)
     ||substr(r.COLUMN_LINKTEXT,1,15)||length(r.COLUMN_LINKTEXT)
     ||substr(r.COLUMN_LINK_ATTR,1,15)||length(r.COLUMN_LINK_ATTR)
     ||substr(r.COLUMN_LINK_CHECKSUM_TYPE,1,15)
     ||' a='||substr(r.COLUMN_ALIGNMENT,1,6)||substr(r.HEADING_ALIGNMENT,1,6)
     ||' s='||DEFAULT_SORT_COLUMN_SEQUENCE
     ||substr(DEFAULT_SORT_DIR,1,6)
     ||substr(r.DISABLE_SORT_COLUMN,1,10)
     ||substr(r.SUM_COLUMN,1,10)
     ||substr(r.HIDDEN_COLUMN,1,15)
     ||' c='||substr(r.DISPLAY_WHEN_COND_TYPE,1,20)
	   ||substr(r.DISPLAY_WHEN_CONDITION,1,15)||length(r.DISPLAY_WHEN_CONDITION)
     ||substr(r.DISPLAY_WHEN_CONDITION2,1,15)||length(r.DISPLAY_WHEN_CONDITION2)
     ||' a='||substr(decode(substr(r.REPORT_COLUMN_REQUIRED_ROLE,1,1),'!','Not ')||
     nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(r.REPORT_COLUMN_REQUIRED_ROLE,'!')
     and    flow_id = f.id),
            r.REPORT_COLUMN_REQUIRED_ROLE),1,30)
     ||' d='||substr(r.DISPLAY_AS,1,20)
     ||' l='||substr(decode((select lov_name
      from wwv_flow_lists_of_values$
      where id = r.NAMED_LOV),null,null,
      (select lov_name
      from wwv_flow_lists_of_values$
      where id = r.NAMED_LOV)),1,30)
     ||substr(r.INLINE_LOV,1,30)||substr(r.LOV_SHOW_NULLS,1,20)||substr(r.LOV_DISPLAY_EXTRA,1,6)||substr(r.LOV_NULL_VALUE,1,20)||r.COLUMN_WIDTH||r.COLUMN_HEIGHT
     ||' c='||substr(r.CATTRIBUTES,1,20)||length(r.CATTRIBUTES)
     ||' c='||substr(r.CATTRIBUTES_ELEMENT,1,20)||length(r.CATTRIBUTES_ELEMENT)
     ||' pk='||r.PK_COL_SOURCE_TYPE||dbms_lob.substr(r.PK_COL_SOURCE,20,1)||dbms_lob.getlength(r.PK_COL_SOURCE)
     ||' d='||substr(r.DERIVED_COLUMN,1,6)
     ||' d='||substr(r.COLUMN_DEFAULT,1,20)||length(r.COLUMN_DEFAULT)
     ||' t='||r.COLUMN_DEFAULT_TYPE||include_in_export||print_col_width||print_col_align
     component_signature
from WWV_FLOW_REGION_REPORT_COLUMN r,
     wwv_flow_steps p,
     wwv_flow_page_plugs region,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = f.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.security_group_id = r.security_group_id and
      f.id = p.flow_id and
      f.id = region.flow_id and
      p.id = region.page_id and
      region.id = r.region_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_page_rpt_cols is 'Report column definitions used for report regions';
comment on column apex_application_page_rpt_cols.workspace                        is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_rpt_cols.application_id                   is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_rpt_cols.application_name                 is 'Identifies the application';
comment on column apex_application_page_rpt_cols.page_id                          is 'Identifies the application';
comment on column apex_application_page_rpt_cols.page_name                        is 'Identifies a page within an application';
comment on column apex_application_page_rpt_cols.REGION_NAME                      is 'Report region name';
comment on column apex_application_page_rpt_cols.COLUMN_ALIAS                     is 'SQL query column alias';
comment on column apex_application_page_rpt_cols.DISPLAY_SEQUENCE                 is 'Identifies the sequence in the report that this column is to be displayed';
comment on column apex_application_page_rpt_cols.HEADING                          is 'Report column heading';
comment on column apex_application_page_rpt_cols.FORMAT_MASK                      is 'Number or Date format mask';
comment on column apex_application_page_rpt_cols.HTML_EXPRESSION                  is 'HTML column template used to display this column';
comment on column apex_application_page_rpt_cols.CSS_CLASS                        is 'Use this CSS class in the HTML TD tag when displaying this report column';
comment on column apex_application_page_rpt_cols.CSS_STYLE                        is 'Use this CSS style in the HTML TD tag when displaying this report column';
comment on column apex_application_page_rpt_cols.HIGHLIGHT_WORDS                  is 'Identify keywords to highlight, for example "&P1_SEARCH."';
comment on column apex_application_page_rpt_cols.COLUMN_LINK_URL                  is 'URL target of report column';
comment on column apex_application_page_rpt_cols.COLUMN_LINK_TEXT                 is 'Text displayed for linked columns';
comment on column apex_application_page_rpt_cols.COLUMN_LINK_ATTRIBUTES           is 'HTML "A" tag attributes';
comment on column apex_application_page_rpt_cols.PAGE_CHECKSUM                    is 'An appropriate checksum when linking to protected pages';
comment on column apex_application_page_rpt_cols.COLUMN_ALIGNMENT                 is 'Report column alignment';
comment on column apex_application_page_rpt_cols.HEADING_ALIGNMENT                is 'Report heading alignment';
comment on column apex_application_page_rpt_cols.DEFAULT_SORT_SEQUENCE            is 'For reports with column heading sorting, identifies the default sort order';
comment on column apex_application_page_rpt_cols.DEFAULT_SORT_DIRECTION           is 'Default sort direction, ascending or descending';
comment on column apex_application_page_rpt_cols.SORTABLE_COLUMN                  is 'Identifies if the column is column heading sortable';
comment on column apex_application_page_rpt_cols.SUM_COLUMN                       is 'Identifies if this column is to be summed';
comment on column apex_application_page_rpt_cols.COLUMN_IS_HIDDEN                 is 'Identifies the column as hidden, the values will be returned to the browser but they will not be displayed.';
comment on column apex_application_page_rpt_cols.CONDITION_TYPE                   is 'Identifies the condition type used to conditionally display this Report Column';
comment on column apex_application_page_rpt_cols.CONDITION_EXPRESSION1            is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_rpt_cols.CONDITION_EXPRESSION2            is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_rpt_cols.AUTHORIZATION_SCHEME             is 'An authorization scheme must evaluate to TRUE in order for this component to be displayed';
comment on column apex_application_page_rpt_cols.AUTHORIZATION_SCHEME_ID          is 'Foreign Key';
comment on column apex_application_page_rpt_cols.LAST_UPDATED_BY                  is 'Apex User Name that last updated this report column';
comment on column apex_application_page_rpt_cols.LAST_UPDATED_ON                  is 'Date of last update';
comment on column apex_application_page_rpt_cols.DISPLAY_AS                       is 'Identifies how the report column is to be displayed';
comment on column apex_application_page_rpt_cols.NAMEd_LIST_OF_VALUES             is 'Identifies the Shared List of Values to be used to display this report column';
comment on column apex_application_page_rpt_cols.INLINE_LIST_OF_VALUES            is 'Identifies an inline List of Values to display this column value';
comment on column apex_application_page_rpt_cols.LOV_SHOW_NULLS                   is 'For column "Display As" ';
comment on column apex_application_page_rpt_cols.LOV_DISPLAY_EXTRA_VALUES         is 'Identifies if the column value is to be displayed if the List of Values domain does not include the column value.';
comment on column apex_application_page_rpt_cols.LOV_NULL_TEXT                    is 'Identifies the text to be displayed for a null value';
comment on column apex_application_page_rpt_cols.LOV_NULL_VALUE                   is 'Identifies the text to be returned for a null value';
comment on column apex_application_page_rpt_cols.FORM_ELEMENT_WIDTH               is 'For form elements, identifies the element width';
comment on column apex_application_page_rpt_cols.FORM_ELEMENT_HEIGHT              is 'For form elements, identifies the element height';
comment on column apex_application_page_rpt_cols.FORM_ELEMENT_ATTRIBUTES          is 'Identifies HTML attributes for the HTML form element';
comment on column apex_application_page_rpt_cols.FORM_ELEMENT_OPTION_ATTRIBUTES   is 'Identifies HTML attributes for the HTML form element options';
comment on column apex_application_page_rpt_cols.PRIMARY_KEY_COLUMN_SOURCE_TYPE   is 'Identifies the datatype of an updatable reports primary key.';
comment on column apex_application_page_rpt_cols.PRIMARY_KEY_COLUMN_SOURCE        is 'Identifies the source value for an updatable reports primary key.';
comment on column apex_application_page_rpt_cols.DERIVED_COLUMN                   is 'Column is generated by the reporting engine and is not derived from the SQL query';
comment on column apex_application_page_rpt_cols.COLUMN_DEFAULT                   is 'Identifies the default value source for this updatable report column';
comment on column apex_application_page_rpt_cols.COLUMN_DEFAULT_TYPE              is 'Identifies the default value source type for an updatable report column';
comment on column apex_application_page_rpt_cols.REGION_ID                        is 'Identifies the Primary Key of the report Region';
comment on column apex_application_page_rpt_cols.REGION_REPORT_COLUMN_ID          is 'Identifies the Primary Key of the Report Column Entry';
comment on column apex_application_page_rpt_cols.include_in_export                is 'Include column in download';
comment on column apex_application_page_rpt_cols.print_column_width               is 'Print column width for exact control';
comment on column apex_application_page_rpt_cols.print_column_alignment           is 'Print column alignment';
comment on column apex_application_page_rpt_cols.COLUMN_COMMENT                   is 'Comment on Report Column';
comment on column apex_application_page_rpt_cols.reference_schema                 is 'Referenced column';
comment on column apex_application_page_rpt_cols.reference_table_name             is 'Referenced column';
comment on column apex_application_page_rpt_cols.reference_column_name            is 'Referenced column';
comment on column apex_application_page_rpt_cols.component_signature              is 'Identifies attributes defined at a given component level to facilitate application comparisons';


grant select on   apex_application_page_rpt_cols to public;


-------------------------------------------------------
-- A P P L I C A T I O N   P A G E   P R O C E S S E S
-- 4312

prompt ...apex_application_page_proc

create or replace view apex_application_page_proc
as
select
     w.short_name                   workspace,
     p.flow_id                      application_id,
     f.name                         application_name,
     p.id                           page_id,
     p.name                         page_name,
     --
     pr.process_name                process_name,
     pr.PROCESS_SEQUENCE            execution_sequence,
     --
     decode(pr.PROCESS_POINT,
       'RETURN_VALUE','DISPLAY_VALUE',
       'AFTER_AUTHENTICATION','On New Instance After Authentication',
       'BEFORE_HEADER','On Load - Before Header',
       'AFTER_HEADER','On Load - After Header',
       'BEFORE_BOX_BODY','On Load - Before Regions',
       'AFTER_BOX_BODY','On Load - After Regions',
       'BEFORE_FOOTER','On Load - Before Footer',
       'AFTER_FOOTER','On Load - After Footer',
       'ON_SUBMIT_BEFORE_COMPUTATION','On Submit - Before Computations and Validations ',
       'AFTER_SUBMIT','On Submit - After Computations and Validations',
       'AFTER_ERROR_HEADER','On Error - After Header',
       'BEFORE_ERROR_FOOTER','On Error - Before Footer',
       'BEFORE_SHOW_ITEMS','Deprecated - Before Showing page items',
       'AFTER_SHOW_ITEMS','Deprecated - After showing page items',
       pr.PROCESS_POINT)            process_point,
     --
     decode(pr.PROCESS_TYPE,
       'RETURN_VALUE','DISPLAY_VALUE',
       'GET_NEXT_OR_PREV_PK','Get Next or Previous Primary Key Value',
       'INITIALIZE_PAGINATION_FOR_ALL_PAGES','Reset Pagination For All Pages',
       'INITIALIZE_PAGE_PAGINATION','Reset Pagination For Page(s) (PageID,PageID,PageID)',
       'CLEAR_CACHE_CURRENT_FLOW','Clear Cache For Current Application (removes all session state for current application)',
       'CLEAR_CACHE_FOR_FLOWS','Clear Cache For Applications (removes all session state for listed applications)',
       'ADD_ROWS_TO_TABULAR_FORM','Add rows to tabular form',
       'WEB_SERVICE','Web Service',
       'CLOSE_WINDOW','Close popup window',
       'PLSQL','PL/SQL anonymous block',
       'PLSQL_DBMS_JOB','PL/SQL DBMS JOB (runs anonymous block asynchronously)',
       'RESET_PAGINATION','Reset Pagination',
       'CLEAR_CACHE_FOR_PAGES','Clear Cache for all Items on Pages (PageID,PageID,PageID)',
       'CLEAR_CACHE_FOR_ITEMS','Clear Cache for Items (ITEM,ITEM,ITEM)',
       'DML_FETCH_ROW','Automated Row Fetch',
       'DML_PROCESS_ROW','Automatic Row Processing (DML)',
       'SET_PREFERENCE_TO_ITEM_VALUE','Set Preference to value of Item',
       'SET_PREFERENCE_TO_ITEM_VALUE_IF_ITEM_NOT_NULL','Set Preference to value of Item if item is not null (PreferenceName:ITEM)',
       'MULTI_ROW_UPDATE','Multi Row Update',
       'RESET_SESSION_STATE','Clear Cache For Current Session (removes all state for current session)',
       'RESET_USER_PREFERENCES','Reset Preferences (remove all preferences for current user)',
       'INITIALIZE_ALL_PAGE_ITEMS','Initialize all page items',
       'ON_DEMAND','On Demand - Run an on-demand application process',
       'MULTI_ROW_DELETE','Multi Row Delete',
       pr.PROCESS_TYPE)             process_type,
     --pr.ITEM_NAME,
     pr.runtime_where_clause,
     pr.PROCESS_SQL_CLOB            process_source,
     pr.PROCESS_ERROR_MESSAGE       process_error_message,
     --
     (select button_name
      from wwv_flow_step_buttons
      where id = pr.PROCESS_WHEN_BUTTON_ID
      union
      select name
      from wwv_flow_step_items
      where id = pr.PROCESS_WHEN_BUTTON_ID)
                                    when_button_pressed,
     pr.PROCESS_WHEN_BUTTON_ID      when_button_pressed_id,
     --
     nvl((select r from apex_standard_conditions where d = pr.PROCESS_WHEN_TYPE),pr.PROCESS_WHEN_TYPE)
                                    condition_type,
     pr.PROCESS_WHEN                condition_expression1,
     pr.PROCESS_WHEN2               condition_expression2,
     --pr.PROCESS_WHEN_TYPE2,
     --
     decode(pr.PROCESS_IS_STATEFUL_Y_N,
       'Y','Once Per Session or When Reset',
       'N','Once Per Page Visit (default)',
       pr.PROCESS_IS_STATEFUL_Y_N)  run_process,
     --
     pr.RETURN_KEY_INTO_ITEM1       return_key_into_item_1,
     pr.RETURN_KEY_INTO_ITEM2       return_key_into_item_2,
     pr.PROCESS_SUCCESS_MESSAGE     success_message,
     --
     (select case when pr.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id=abs(pr.REQUIRED_PATCH))    build_option,
     --
     decode(substr(pr.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
      from   wwv_flow_security_schemes
      where  to_char(id) = ltrim(pr.SECURITY_SCHEME,'!')
      and    flow_id = f.id),
      pr.SECURITY_SCHEME)           authorization_scheme,
     pr.SECURITY_SCHEME             authorization_scheme_id,
     --
     pr.LAST_UPDATED_BY             last_updated_by,
     pr.LAST_UPDATED_ON             last_updated_on,
     pr.PROCESS_COMMENT             component_comment,
     pr.id                          process_id,
     --
     lpad(pr.PROCESS_SEQUENCE,5,'00000')
     ||',point='||decode(pr.PROCESS_POINT,
       'RETURN_VALUE','DISPLAY_VALUE',
       'AFTER_AUTHENTICATION','On New Instance After Authentication',
       'BEFORE_HEADER','On Load - Before Header',
       'AFTER_HEADER','On Load - After Header',
       'BEFORE_BOX_BODY','On Load - Before Regions',
       'AFTER_BOX_BODY','On Load - After Regions',
       'BEFORE_FOOTER','On Load - Before Footer',
       'AFTER_FOOTER','On Load - After Footer',
       'ON_SUBMIT_BEFORE_COMPUTATION','On Submit - Before Computations and Validations ',
       'AFTER_SUBMIT','On Submit - After Computations and Validations',
       'AFTER_ERROR_HEADER','On Error - After Header',
       'BEFORE_ERROR_FOOTER','On Error - Before Footer',
       'BEFORE_SHOW_ITEMS','Deprecated - Before Showing page items',
       'AFTER_SHOW_ITEMS','Deprecated - After showing page items',
       pr.PROCESS_POINT)
     ||',type='||decode(pr.PROCESS_TYPE,
       'RETURN_VALUE','DISPLAY_VALUE',
       'GET_NEXT_OR_PREV_PK','Get Next or Previous Primary Key Value',
       'INITIALIZE_PAGINATION_FOR_ALL_PAGES','Reset Pagination For All Pages',
       'INITIALIZE_PAGE_PAGINATION','Reset Pagination For Page(s) (PageID,PageID,PageID)',
       'CLEAR_CACHE_CURRENT_FLOW','Clear Cache For Current Application (removes all session state for current application)',
       'CLEAR_CACHE_FOR_FLOWS','Clear Cache For Applications (removes all session state for listed applications)',
       'ADD_ROWS_TO_TABULAR_FORM','Add rows to tabular form',
       'WEB_SERVICE','Web Service',
       'CLOSE_WINDOW','Close popup window',
       'PLSQL','PL/SQL anonymous block',
       'PLSQL_DBMS_JOB','PL/SQL DBMS JOB (runs anonymous block asynchronously)',
       'RESET_PAGINATION','Reset Pagination',
       'CLEAR_CACHE_FOR_PAGES','Clear Cache for all Items on Pages (PageID,PageID,PageID)',
       'CLEAR_CACHE_FOR_ITEMS','Clear Cache for Items (ITEM,ITEM,ITEM)',
       'DML_FETCH_ROW','Automated Row Fetch',
       'DML_PROCESS_ROW','Automatic Row Processing (DML)',
       'SET_PREFERENCE_TO_ITEM_VALUE','Set Preference to value of Item',
       'SET_PREFERENCE_TO_ITEM_VALUE_IF_ITEM_NOT_NULL','Set Preference to value of Item if item is not null (PreferenceName:ITEM)',
       'MULTI_ROW_UPDATE','Multi Row Update',
       'RESET_SESSION_STATE','Clear Cache For Current Session (removes all state for current session)',
       'RESET_USER_PREFERENCES','Reset Preferences (remove all preferences for current user)',
       'INITIALIZE_ALL_PAGE_ITEMS','Initialize all page items',
       'ON_DEMAND','On Demand - Run an on-demand application process',
       'MULTI_ROW_DELETE','Multi Row Delete',
       pr.PROCESS_TYPE)
       ||',src='||dbms_lob.substr(pr.PROCESS_SQL_CLOB,30,1)||'.'||
       dbms_lob.getlength(pr.PROCESS_SQL_CLOB)
       ||(select ',wbp='||button_name n from wwv_flow_step_buttons where id = pr.PROCESS_WHEN_BUTTON_ID
       union
       select ',wbp='||name n from wwv_flow_step_items where id = pr.PROCESS_WHEN_BUTTON_ID)
       ||decode(pr.PROCESS_ERROR_MESSAGE,null,null,',errm='||
       substr(pr.PROCESS_ERROR_MESSAGE,1,20)||length(pr.PROCESS_ERROR_MESSAGE))
       ||decode(pr.PROCESS_SUCCESS_MESSAGE,null,null,',succm='||
       substr(pr.PROCESS_SUCCESS_MESSAGE,1,20)||length(pr.PROCESS_SUCCESS_MESSAGE))
       ||nvl((select name from wwv_flow_security_schemes where to_char(id) = ltrim(pr.SECURITY_SCHEME,'!') and flow_id = f.id),pr.SECURITY_SCHEME)
       ||',cond='||pr.PROCESS_WHEN_TYPE
       ||substr(pr.PROCESS_WHEN,1,20)||length(pr.PROCESS_WHEN)||'.'
       ||substr(pr.PROCESS_WHEN2,1,20)||length(pr.PROCESS_WHEN2)
       ||(select PATCH_NAME from wwv_flow_patches where id=abs(pr.REQUIRED_PATCH))
       ||decode(pr.PROCESS_IS_STATEFUL_Y_N,'Y','Once Per Session or When Reset','N','Once Per Page Visit (default)',pr.PROCESS_IS_STATEFUL_Y_N)
     ||',key='||pr.RETURN_KEY_INTO_ITEM1||pr.RETURN_KEY_INTO_ITEM1
     component_signature
from wwv_flow_step_processing pr,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = f.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.security_group_id = pr.security_group_id and
      f.id = p.flow_id and
      f.id = pr.flow_id and
      p.id = pr.flow_step_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_page_proc                        is 'Identifies SQL or PL/SQL processing associated with a page';
comment on column apex_application_page_proc.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_proc.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_proc.application_name       is 'Identifies the application';
comment on column apex_application_page_proc.page_id                is 'Identifies the application';
comment on column apex_application_page_proc.page_name              is 'Identifies a page within an application';
comment on column apex_application_page_proc.PROCESS_NAME           is 'Identifies Page Process Name';
comment on column apex_application_page_proc.EXECUTION_SEQUENCE     is 'Identifies order of execution within each Process Point';
comment on column apex_application_page_proc.PROCESS_POINT          is 'Specifies the point at which the process is executed';
comment on column apex_application_page_proc.PROCESS_TYPE           is 'Identifies process type';
comment on column apex_application_page_proc.RUNTIME_WHERE_CLAUSE   is 'Appended to Oracle APEX generated SELECT, UPDATE, and DELETE statements';
comment on column apex_application_page_proc.PROCESS_SOURCE         is 'Identifies the corresponding process text for the process type';
comment on column apex_application_page_proc.PROCESS_ERROR_MESSAGE  is 'Error message to be displayed when this process raises an exception';
comment on column apex_application_page_proc.WHEN_BUTTON_PRESSED    is 'This process will only be executed if a user clicks the button identified';
comment on column apex_application_page_proc.WHEN_BUTTON_PRESSED_ID is 'Foreign key to button';
comment on column apex_application_page_proc.CONDITION_TYPE         is 'Identifies the condition type used to conditionally execute the Page Process';
comment on column apex_application_page_proc.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_proc.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_proc.RUN_PROCESS            is 'Specifies when the process should run; Once Per Session or When Reset, or Once Per Page Visit';
comment on column apex_application_page_proc.RETURN_KEY_INTO_ITEM_1 is 'After performing a SQL INSERT statement, take the first (or only) column of the primary key and return it into this item. Use this feature to get back ID fields populated from sequences within database triggers.';
comment on column apex_application_page_proc.RETURN_KEY_INTO_ITEM_2 is 'After performing a SQL INSERT statement, take the second column of the primary key and return it into this item. Use this feature to get back ID fields populated from sequences within database triggers.';
comment on column apex_application_page_proc.SUCCESS_MESSAGE        is 'Identifies the message to be displayed upon successful execution of this Page Process';
comment on column apex_application_page_proc.BUILD_OPTION           is 'Page Process will be considered for execution if the Build Option is enabled';
comment on column apex_application_page_proc.AUTHORIZATION_SCHEME   is 'An authorization scheme must evaluate to TRUE in order for this Page Process to be considered for execution';
comment on column apex_application_page_proc.AUTHORIZATION_SCHEME_ID is 'Foreign Key';
comment on column apex_application_page_proc.COMPONENT_COMMENT      is 'Developer comment';
comment on column apex_application_page_proc.PROCESS_ID             is 'Primary Key of this Page Process';
comment on column apex_application_page_proc.last_updated_by        is 'Apex developer who made last update';
comment on column apex_application_page_proc.last_updated_on        is 'Date of last update';
comment on column apex_application_page_proc.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';
grant select on   apex_application_page_proc to public;



------------------------------------------------------------
-- A P P L I C A T I O N   P A G E   C O M P U T A T I O N S
-- 4315

prompt ...apex_application_page_comp


create or replace view apex_application_page_comp
as
select
     w.short_name                   workspace,
     p.flow_id                      application_id,
     f.name                         application_name,
     p.id                           page_id,
     p.name                         page_name,
     --
     c.COMPUTATION_ITEM             item_name,
     c.COMPUTATION_SEQUENCE         execution_sequence,
     --
     decode(c.COMPUTATION_POINT,
       'ON_NEW_INSTANCE','On New Instance (e.g. On Login)',
       'BEFORE_HEADER','Before Header',
       'AFTER_HEADER','After Header',
       'BEFORE_BOX_BODY','Before Region(s)',
       'AFTER_BOX_BODY','After Region(s)',
       'BEFORE_FOOTER','Before Footer',
       'AFTER_FOOTER','After Footer',
       'AFTER_SUBMIT','After Submit',
       c.COMPUTATION_POINT)         computation_point,
     --
     decode(c.COMPUTATION_TYPE,
        'STATIC_ASSIGNMENT','Static Assignment',
        'FUNCTION_BODY','PL/SQL Function Body',
        'QUERY','SQL Query',
        'SQL_EXPRESSION','SQL Expression',
        'PLSQL_EXPRESSION','PL/SQL Expression',
        'ITEM_VALUE','Item Value',
        c.COMPUTATION_TYPE)         computation_type,
     --c.COMPUTATION_PROCESSED        computation_processed,
     c.COMPUTATION                  computation,
     --
     decode(c.COMPUTE_WHEN_TYPE,'%'||'null%',null,
     nvl((select r from apex_standard_conditions where d = c.COMPUTE_WHEN_TYPE),c.COMPUTE_WHEN_TYPE))
                                    condition_type,
     c.COMPUTE_WHEN                 condition_expression1,
     c.COMPUTE_WHEN_TEXT            condition_expression2,
     c.COMPUTATION_ERROR_MESSAGE    error_message,
     (select case when c.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id= abs(c.REQUIRED_PATCH))    build_option,
     --
     decode(substr(c.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id) = ltrim(c.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     c.SECURITY_SCHEME)             authorization_scheme,
     c.SECURITY_SCHEME              authorization_scheme_id,
     c.LAST_UPDATED_BY              last_updated_by,
     c.LAST_UPDATED_ON              last_updated_on,
     c.COMPUTATION_COMMENT          component_comment,
     --
     c.COMPUTATION_ITEM
     ||c.COMPUTATION_SEQUENCE
     ||c.COMPUTATION_POINT
     ||c.COMPUTATION_TYPE
     ||length(c.COMPUTATION)
     ||c.COMPUTE_WHEN_TYPE
     ||length(c.COMPUTE_WHEN)||length(c.COMPUTE_WHEN_TEXT)
     ||length(c.COMPUTATION_ERROR_MESSAGE)
     ||(select case when c.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id= abs(c.REQUIRED_PATCH))
     ||decode(substr(c.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id) = ltrim(c.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     c.SECURITY_SCHEME)             component_signature,
     --
     c.id                           computation_id
from wwv_flow_step_computations c,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.security_group_id = c.security_group_id and
      f.id = p.flow_id and
      f.id = c.flow_id and
      p.id = c.flow_step_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_page_comp                       is 'Identifies the computation of Item Session State';
comment on column apex_application_page_comp.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_comp.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_comp.application_name      is 'Identifies the application';
comment on column apex_application_page_comp.page_id               is 'Identifies the application';
comment on column apex_application_page_comp.page_name             is 'Identifies a page within an application';
comment on column apex_application_page_comp.item_name             is 'Item name to compute the value of';
comment on column apex_application_page_comp.EXECUTION_SEQUENCE    is 'Identifies the execution order of the computations within each computation point';
comment on column apex_application_page_comp.COMPUTATION_POINT     is 'Identifies the computation point that the computation will be considered for execution';
comment on column apex_application_page_comp.COMPUTATION_TYPE      is 'Identifies the type of computation, reference the Computation attribute.';
comment on column apex_application_page_comp.COMPUTATION           is 'Identifies the Computation which corresponds to the Computation Type';
comment on column apex_application_page_comp.CONDITION_TYPE        is 'Identifies the condition type used to conditionally execute the Page Computation';
comment on column apex_application_page_comp.CONDITION_EXPRESSION1 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_comp.CONDITION_EXPRESSION2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_comp.ERROR_MESSAGE         is 'Identifies the error message to display if the Page Computation raises an error';
comment on column apex_application_page_comp.BUILD_OPTION          is 'Page Computation will be considered for execution if the Build Option is enabled';
comment on column apex_application_page_comp.AUTHORIZATION_SCHEME  is 'An authorization scheme must evaluate to TRUE in order for this computation to be considered for execution';
comment on column apex_application_page_comp.AUTHORIZATION_SCHEME_ID  is 'Foriegn Key';
comment on column apex_application_page_comp.COMPONENT_COMMENT     is 'Developer comment';
comment on column apex_application_page_comp.COMPUTATION_ID        is 'Primary key of this page computation';
comment on column apex_application_page_comp.last_updated_by       is 'Apex developer who made last update';
comment on column apex_application_page_comp.last_updated_on       is 'Date of last update';
comment on column apex_application_page_comp.component_signature   is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_page_comp to public;

------------------------------------------------------------
-- A P P L I C A T I O N   P A G E   B R A N C H E S
-- 4315

prompt ...apex_application_page_branches


create or replace view apex_application_page_branches
as
select
     w.short_name                   workspace,
     p.flow_id                      application_id,
     f.name                         application_name,
     p.id                           page_id,
     p.name                         page_name,
     --
     b.BRANCH_ACTION                branch_action,
     b.BRANCH_POINT                 branch_point,
     decode(b.BRANCH_WHEN_BUTTON_ID,
     null,null,(select button_name
      from wwv_flow_step_buttons
      where id = b.BRANCH_WHEN_BUTTON_ID
      union
      select name
      from wwv_flow_step_items
      where id = b.BRANCH_WHEN_BUTTON_ID))
                                    when_button_pressed,
     decode(b.BRANCH_TYPE,
       'BRANCH_TO_FUNCTION_RETURNING_PAGE','Branch to Function Returning a Page',
       'BRANCH_TO_FUNCTION_RETURNING_URL', 'Branch to Function Returning a URL',
       'BRANCH_TO_PAGE_IDENT_BY_ITEM',     'Branch to Page Identified by Item (Use Item Name)',
       'BRANCH_TO_PAGE_ACCEPT',            'Branch to Page Accept Processing (not common)',
       'BRANCH_TO_STEP',                   'Branch to Page',
       'BRANCH_TO_URL_IDENT_BY_ITEM',      'Branch to URL Identified by Item (Use Item Name)',
       'PLSQL',                            'Branch to PL/SQL Procedure',
       'REDIRECT_URL',                     'Branch to Page or URL',
       b.BRANCH_TYPE)               branch_type,
     b.BRANCH_SEQUENCE              process_sequence,
     --b.CLEAR_PAGE_CACHE,
     nvl((select r from apex_standard_conditions where d = b.BRANCH_CONDITION_TYPE),b.BRANCH_CONDITION_TYPE)
                                    condition_type,
     b.BRANCH_CONDITION             condition_expression1,
     b.BRANCH_CONDITION_TEXT        condition_expression2,
     decode(nvl(b.save_state_before_branch_yn,'N'),'N','No','Yes')  save_state_before_branch,
     (select case when b.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id=  abs(b.REQUIRED_PATCH))   build_option,
     --
     decode(substr(b.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id) = ltrim(b.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     b.SECURITY_SCHEME)             authorization_scheme,
     b.SECURITY_SCHEME              authorization_scheme_id,
     b.LAST_UPDATED_BY              last_updated_by,
     b.LAST_UPDATED_ON              last_updated_on,
     b.BRANCH_COMMENT               component_comment,
     b.id                           branch_id,
     b.BRANCH_WHEN_BUTTON_ID        branch_when_button_id,
     --
     'Point='||BRANCH_POINT
     ||',seq='||lpad(b.BRANCH_SEQUENCE,5,'00000')
     ||',act='||substr(b.BRANCH_ACTION,1,30)||'.'||length(b.BRANCH_ACTION)
     ||',type='||decode(b.BRANCH_TYPE,
       'BRANCH_TO_FUNCTION_RETURNING_PAGE','Branch to Function Returning a Page',
       'BRANCH_TO_FUNCTION_RETURNING_URL', 'Branch to Function Returning a URL',
       'BRANCH_TO_PAGE_IDENT_BY_ITEM',     'Branch to Page Identified by Item (Use Item Name)',
       'BRANCH_TO_PAGE_ACCEPT',            'Branch to Page Accept Processing (not common)',
       'BRANCH_TO_STEP',                   'Branch to Page',
       'BRANCH_TO_URL_IDENT_BY_ITEM',      'Branch to URL Identified by Item (Use Item Name)',
       'PLSQL',                            'Branch to PL/SQL Procedure',
       'REDIRECT_URL',                     'Branch to Page or URL',
       b.BRANCH_TYPE)||'.'
     ||decode(b.BRANCH_WHEN_BUTTON_ID,null,null,(select button_name from wwv_flow_step_buttons where id = b.BRANCH_WHEN_BUTTON_ID
     union
     select name from wwv_flow_step_items where id = b.BRANCH_WHEN_BUTTON_ID))||
     decode(substr(b.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name from wwv_flow_security_schemes where to_char(id) = ltrim(b.SECURITY_SCHEME,'!') and flow_id = f.id),b.SECURITY_SCHEME)||
     'cond='||nvl((select r from apex_standard_conditions where d = b.BRANCH_CONDITION_TYPE),b.BRANCH_CONDITION_TYPE)||
        '.'||substr(b.BRANCH_CONDITION,1,20)||'.'||length(b.BRANCH_CONDITION)||'.'||length(b.BRANCH_CONDITION_TEXT)||
     'save='||decode(nvl(b.save_state_before_branch_yn,'N'),'N','No','Yes')||
     'build='||(select PATCH_NAME from wwv_flow_patches where id=  abs(b.REQUIRED_PATCH))
     component_signature
from wwv_flow_step_branches b,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.security_group_id = b.security_group_id and
      f.id = p.flow_id and
      f.id = b.flow_id and
      p.id = b.flow_step_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_page_branches                       is 'Identifies branch processing associated with a page.  A branch is a directive to navigate to a page or URL which is run at the conclusion of page accept processing.';
comment on column apex_application_page_branches.workspace             is 'A branch fires on page submit and direct a posted page to the next page to view';
comment on column apex_application_page_branches.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_branches.application_name      is 'Identifies the application';
comment on column apex_application_page_branches.page_id               is 'Identifies the application';
comment on column apex_application_page_branches.page_name             is 'Identifies a page within an application';
comment on column apex_application_page_branches.BRANCH_ACTION         is 'Identifies the branch target, typically a page';
comment on column apex_application_page_branches.BRANCH_POINT          is 'Identifies the point at which the branch will be evaluated for execution';
comment on column apex_application_page_branches.WHEN_BUTTON_PRESSED   is 'Identifies a button that must be pressed to consider the branch for execution';
comment on column apex_application_page_branches.BRANCH_TYPE           is 'Identifies how the branch action will be processed, typically identifies a page ID or URL';
comment on column apex_application_page_branches.PROCESS_SEQUENCE      is 'Identifies the order in which the branch will be evaluated for execution for each branch point';
comment on column apex_application_page_branches.CONDITION_TYPE        is 'Identifies a condition that must be met in order for this branch to be processed';
comment on column apex_application_page_branches.CONDITION_EXPRESSION1 is 'Identifies a condition which is specific to the selected condition type';
comment on column apex_application_page_branches.CONDITION_EXPRESSION2 is 'Identifies a condition which is specific to the selected condition type';
comment on column apex_application_page_branches.BUILD_OPTION          is 'Build options enabled or disable components';
comment on column apex_application_page_branches.AUTHORIZATION_SCHEME  is 'An authorization scheme must evaluate to TRUE in order for this component to be processed';
comment on column apex_application_page_branches.AUTHORIZATION_SCHEME_ID  is 'Foreign Key';
comment on column apex_application_page_branches.COMPONENT_COMMENT     is 'Developer comment';
comment on column apex_application_page_branches.BRANCH_ID             is 'Primary key for this component';
comment on column apex_application_page_branches.branch_when_button_id is 'Foreign Key to Branch When Button ID';
comment on column apex_application_page_branches.save_state_before_branch	is 'Yes - Save session state and clear cache before branch. No - Redirect to URL with clear-cache and session state settings';
comment on column apex_application_page_branches.last_updated_by       is 'Apex developer who made last update';
comment on column apex_application_page_branches.last_updated_on       is 'Date of last update';
comment on column apex_application_page_branches.component_signature   is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on apex_application_page_branches to public;


----------------------------------------------------------
-- A P P L I C A T I O N   P A G E   V A L I D A T I O N S
-- 4316

prompt ...apex_application_page_val

create or replace view apex_application_page_val
as
select
     w.short_name                  workspace,
     p.flow_id                     application_id,
     f.name                        application_name,
     p.id                          page_id,
     p.name                        page_name,
     --
     v.VALIDATION_NAME             validation_name,
     v.VALIDATION_SEQUENCE         validation_sequence,
     --
     decode(v.VALIDATION_TYPE,
        'EXISTS','Exists',
        'FUNC_BODY_RETURNING_BOOLEAN','Function Returning Boolean',
        'FUNC_BODY_RETURNING_ERR_TEXT','Function Returning Error Text',
        'ITEM_NOT_NULL','Item specified is NOT NULL',
        'ITEM_IN_VALIDATION_CONTAINS_AT_LEAST_ONE_CHAR_IN_STRING2','Item in Expression 1 contains at least one of the characters in Expression 2',
        'ITEM_IN_VALIDATION_CONTAINS_ONLY_CHAR_IN_STRING2','Item in Expression 1 contains only characters in Expression 2',
        'ITEM_IN_VALIDATION_NOT_EQ_STRING2','Item in Expression 1 does NOT equal string literal in Expression2',
        'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2','Item in Expression 1 does not contain any of the characters in Expression 2',
        'ITEM_IN_VALIDATION_EQ_STRING2','Item in Expression 1 equals string literal in Expression 2',
        'ITEM_IN_VALIDATION_NOT_IN_STRING2','Item in Expression 1 is NOT contained in Expression 2',
        'ITEM_IN_VALIDATION_IN_STRING2','Item in Expression 1 is contained in Expression 2',
        'ITEM_NOT_ZERO','Item specified is NOT zero',
        'ITEM_CONTAINS_NO_SPACES','Item specified contains no spaces',
        'ITEM_NOT_NULL_OR_ZERO','Item specified is NOT NULL or zero',
        'ITEM_IS_ALPHANUMERIC','Item specified is alphanumeric',
        'ITEM_IS_NUMERIC','Item specified is numeric',
        'ITEM_IS_DATE','Item specified is a valid date',
        'NOT_EXISTS','NOT Exists',
        'PLSQL_ERROR','PL/SQL Error',
        'PLSQL_EXPRESSION','PL/SQL Expression',
        'REGULAR_EXPRESSION','Regular Expression',
        'SQL_EXPRESION','SQL Expression',
         v.VALIDATION_TYPE)        validation_type,
     v.VALIDATION                  validation_expression1,
     v.VALIDATION2                 validation_expression2,
     --
     nvl((select r from apex_standard_conditions where d = v.VALIDATION_CONDITION_TYPE),v.VALIDATION_CONDITION_TYPE)
                                   condition_type,
     v.VALIDATION_CONDITION        condition_expression1,
     v.VALIDATION_CONDITION2       condition_expression2,
     --
     (select button_name
      from wwv_flow_step_buttons
      where id = v.WHEN_BUTTON_PRESSED
      union
      select name
      from wwv_flow_step_items
      where id = v.WHEN_BUTTON_PRESSED)
                                   when_button_pressed,
     --
     v.ERROR_MESSAGE               validation_failure_text,
     (select name from wwv_flow_step_items
      where id = v.ASSOCIATED_ITEM and
            flow_id = f.id)        associated_item,
     v.ERROR_DISPLAY_LOCATION      error_display_location,
     (select case when v.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id= abs(v.REQUIRED_PATCH))   build_option,
     --
     decode(substr(v.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id) = ltrim(v.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     v.SECURITY_SCHEME)            authorization_scheme,
     v.SECURITY_SCHEME             authorization_scheme_id,
     --
     v.LAST_UPDATED_BY             last_updated_by,
     v.LAST_UPDATED_ON             last_updated_on,
     v.VALIDATION_COMMENT          component_comment,
     v.id                          validation_id,
     'seq='||v.VALIDATION_SEQUENCE
     ||',item='||(select name from wwv_flow_step_items where id=v.ASSOCIATED_ITEM)
     ||',type='||v.VALIDATION_TYPE
     ||',val='||substr(v.VALIDATION,1,40)||'.'||length(v.VALIDATION)||'.'
      ||substr(v.VALIDATION2,1,40)||'.'||length(v.VALIDATION2)||'.'
     ||decode(v.VALIDATION_CONDITION_TYPE,null,null,',cond='||v.VALIDATION_CONDITION_TYPE||'.'||
         substr(v.VALIDATION_CONDITION,1,30)||length(v.VALIDATION_CONDITION)||'.'||
         substr(v.VALIDATION_CONDITION2,1,30)||length(v.VALIDATION_CONDITION2))
     component_signature
from wwv_flow_step_validations v,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.security_group_id = v.security_group_id and
      f.id = p.flow_id and
      f.id = v.flow_id and
      p.id = v.flow_step_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_page_val                         is 'Identifies Validations associated with an Application Page';
comment on column apex_application_page_val.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_val.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_val.application_name        is 'Identifies the application';
comment on column apex_application_page_val.page_id                 is 'Identifies the application';
comment on column apex_application_page_val.page_name               is 'Identifies a page within an application';
comment on column apex_application_page_val.VALIDATION_NAME         is 'Identifies the name of the validation';
comment on column apex_application_page_val.VALIDATION_SEQUENCE     is 'Identifies the sequence in which this validation will be considered for execution';
comment on column apex_application_page_val.VALIDATION_TYPE         is 'Specifies predefined validation type with the corresponding appropriate values in the Expression 1 and Expression 2 fields.';
comment on column apex_application_page_val.VALIDATION_EXPRESSION1  is 'Identifies the validation which corresponds to the specified Validation Type';
comment on column apex_application_page_val.VALIDATION_EXPRESSION2  is 'Identifies the validation which corresponds to the specified Validation Type';
comment on column apex_application_page_val.CONDITION_TYPE          is 'Identifies the condition type used to conditionally execute the Page Validation';
comment on column apex_application_page_val.CONDITION_EXPRESSION1   is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_val.CONDITION_EXPRESSION2   is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_val.WHEN_BUTTON_PRESSED     is 'This validation will only be evaluated if the identified button is pressed';
comment on column apex_application_page_val.VALIDATION_FAILURE_TEXT is 'Specifies the text that will be displayed in the event the validation raises an error';
comment on column apex_application_page_val.ASSOCIATED_ITEM         is 'If applicable, select the item associated with this validation error message.';
comment on column apex_application_page_val.ERROR_DISPLAY_LOCATION  is 'The Error display location identifies where the validation error message will display. Messages can be displayed on an error page, or inline with the existing page. Inline validations are displayed in the "notification" area (defined as part of the page template), and/or within the item label.';
comment on column apex_application_page_val.BUILD_OPTION            is 'Page Computation will be considered for execution if the Build Option is enabled';
comment on column apex_application_page_val.AUTHORIZATION_SCHEME    is 'An authorization scheme must evaluate to TRUE in order for this validation to be considered for execution';
comment on column apex_application_page_val.AUTHORIZATION_SCHEME_id is 'Foreign Key';
comment on column apex_application_page_val.COMPONENT_COMMENT       is 'Developer comment';
comment on column apex_application_page_val.VALIDATION_ID           is 'Primary key of this page validation';
comment on column apex_application_page_val.last_updated_by         is 'Apex developer who made last update';
comment on column apex_application_page_val.last_updated_on         is 'Date of last update';
comment on column apex_application_page_val.component_signature   is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_page_val to public;




--------------------------------------------------
-- A P P L I C A T I O N   P A G E   B U T T O N S
--
prompt ...apex_application_page_buttons

create or replace view apex_application_page_buttons
as
select
     w.short_name                  workspace,
     p.flow_id                     application_id,
     f.name                        application_name,
     p.id                          page_id,
     p.name                        page_name,
     --
     b.BUTTON_SEQUENCE             button_sequence,
     (select plug_name
      from wwv_flow_page_plugs
      where id=b.BUTTON_PLUG_ID)   region,
     b.button_plug_id              region_id,
     b.BUTTON_NAME                 button_name,
     (select template_name
      from wwv_flow_button_templates
      where b.BUTTON_IMAGE =
         'template:'||to_char(id)
      and flow_id = f.id)          button_template,
     decode(substr(b.BUTTON_IMAGE,1,9),'template:',null,b.BUTTON_IMAGE) image_name,
     b.BUTTON_IMAGE_ALT            label,
     b.BUTTON_POSITION             display_position,
     b.BUTTON_ALIGNMENT            alignment,
     b.BUTTON_REDIRECT_URL         redirect_url,
     --
     nvl((select r from apex_standard_conditions where d = b.BUTTON_CONDITION_TYPE),b.BUTTON_CONDITION_TYPE)
                                   condition_type,
     b.BUTTON_CONDITION            condition_expression1,
     b.BUTTON_CONDITION2           condition_expression2,
     b.BUTTON_IMAGE_ATTRIBUTES     image_attributes,
     b.BUTTON_CATTRIBUTES          button_attributes,
     decode(
        b.DATABASE_ACTION,
        'DELETE','SQL DELETE action',
        'INSERT','SQL INSERT action',
        'UPDATE','SQL UPDATE action',
        b.DATABASE_ACTION)         database_action,
     --
     (select case when b.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id= abs(b.REQUIRED_PATCH))   build_option,
     --
     decode(substr(b.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(b.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     b.SECURITY_SCHEME)            authorization_scheme,
     b.SECURITY_SCHEME             authorization_scheme_id,
     --
     b.LAST_UPDATED_BY             last_updated_by,
     b.LAST_UPDATED_ON             last_updated_on,
     b.BUTTON_COMMENT              component_comment,
     'Region Position'             button_position,
     b.id                          button_id,
     --
     b.BUTTON_NAME
     ||',s='||rpad(b.BUTTON_SEQUENCE,5,'00000')
     ||',r='||(select plug_name from wwv_flow_page_plugs where id=b.BUTTON_PLUG_ID)
     ||' t='||(select template_name from wwv_flow_button_templates where b.BUTTON_IMAGE = 'template:'||to_char(id) and flow_id = f.id)
     ||' label='||b.BUTTON_IMAGE_ALT
     ||' p='||b.BUTTON_POSITION
     ||' a='||b.BUTTON_ALIGNMENT
     ||' u='||substr(b.BUTTON_REDIRECT_URL,1,30)||length(b.BUTTON_REDIRECT_URL)
     ||' c='||b.BUTTON_CONDITION_TYPE
     ||substr(b.BUTTON_CONDITION,1,20)||length(b.BUTTON_CONDITION)||'.'
     ||substr(b.BUTTON_CONDITION2,1,20)||length(b.BUTTON_CONDITION2)
     ||' ii='||substr(b.BUTTON_IMAGE_ATTRIBUTES,1,20)||length(b.BUTTON_IMAGE_ATTRIBUTES)
     ||' ca='||substr(b.BUTTON_CATTRIBUTES,1,20)||length(b.BUTTON_CATTRIBUTES)
     ||' b='||decode(
        b.DATABASE_ACTION,
        'DELETE','SQLDELETE',
        'INSERT','SQLINSERT',
        'UPDATE','SQLUPDATE',
        b.DATABASE_ACTION)
     ||' b='||(select PATCH_NAME
     from wwv_flow_patches
     where id= abs(b.REQUIRED_PATCH))
     ||' s='||decode(substr(b.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(b.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     b.SECURITY_SCHEME)
     component_signature
from wwv_flow_step_buttons b,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.security_group_id = b.security_group_id and
      f.id = p.flow_id and
      f.id = b.flow_id and
      p.id = b.flow_step_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
union all
select
    w.short_name                    workspace,
    p.flow_id                       application_id,
    f.name                          application_name,
    p.id                            page_id,
    p.name                          page_name,
    --
    i.ITEM_SEQUENCE                 button_sequence,
    (select plug_name
     from wwv_flow_page_plugs
     where id = i.ITEM_PLUG_ID)     region,
    i.item_plug_id                  region_id,
    i.name                          button_name,
    --
    null                            button_template,
    decode(substr(i.BUTTON_IMAGE,1,9),'template:',null,i.BUTTON_IMAGE) image_name,
    i.PROMPT                        label,
    null                            display_position,
    null                            alignment,
    null                            redirect_url,
    --
    nvl((select r from apex_standard_conditions where d = i.DISPLAY_WHEN_TYPE),i.DISPLAY_WHEN_TYPE)
                                    condition_type,
    i.DISPLAY_WHEN                  condition_expression1,
    i.DISPLAY_WHEN2                 condition_expression2,
    --
    null                            image_attributes,
    null                            button_attributes,
    null                            database_action,
    (select case when i.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(i.REQUIRED_PATCH))   build_option,
    --
    decode(substr(i.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(i.SECURITY_SCHEME,'!')
     and    flow_id = f.id),
     i.SECURITY_SCHEME)             authorization_scheme,
    i.SECURITY_SCHEME               authorization_scheme_id,
    i.LAST_UPDATED_BY               last_updated_by,
    i.LAST_UPDATED_ON               last_updated_on,
    i.ITEM_COMMENT                  component_comment,
    'Among region items'            button_position,
    i.id                            button_id,
    --
    lpad(i.ITEM_SEQUENCE,5,'00000')
    ||' r='||(select plug_name
     from wwv_flow_page_plugs
     where id = i.ITEM_PLUG_ID)
    ||' n='||i.name
    ||' l='||substr(i.PROMPT,1,40)||length(i.PROMPT)
    ||' c='||i.DISPLAY_WHEN_TYPE
    ||'.'||substr(i.DISPLAY_WHEN,1,20)||length(i.DISPLAY_WHEN)
    ||'.'||substr(i.DISPLAY_WHEN2,1,20)||length(i.DISPLAY_WHEN2)
    ||' bo='||(select case when i.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(i.REQUIRED_PATCH))
    ||' sec='||decode(substr(i.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(i.SECURITY_SCHEME,'!')
     and    flow_id = f.id),
     i.SECURITY_SCHEME)
    ||' ItemButton'
    component_signature
from wwv_flow_step_items i,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.id = p.flow_id and
      f.id = i.flow_id and
      p.id = i.flow_step_id and
      nvl(i.display_as,'x') = 'BUTTON' and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_page_buttons                       is 'Identifies buttons associated with a Page and Region';
comment on column apex_application_page_buttons.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_buttons.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_buttons.application_name      is 'Identifies the application';
comment on column apex_application_page_buttons.page_id               is 'Identifies the application';
comment on column apex_application_page_buttons.page_name             is 'Identifies a page within an application';
comment on column apex_application_page_buttons.BUTTON_SEQUENCE       is 'Identifies the display sequence of the button within the region and display position';
comment on column apex_application_page_buttons.REGION                is 'Identifies the Page Region in which this Button is displayed';
comment on column apex_application_page_buttons.REGION_ID             is 'Identifies the Page Region foreign key to the apex_application_page_regions view';
comment on column apex_application_page_buttons.BUTTON_NAME           is 'Identifies the name of the button, which when submitted becomes the REQUEST value';
comment on column apex_application_page_buttons.BUTTON_TEMPLATE       is 'Identifies the template used to display this button';
comment on column apex_application_page_buttons.LABEL                 is 'Identifies the Button Label';
comment on column apex_application_page_buttons.image_name            is 'Name of image for non template based buttons';
comment on column apex_application_page_buttons.DISPLAY_POSITION      is 'Identifies the Display Position with the Region';
comment on column apex_application_page_buttons.ALIGNMENT             is 'Identifies the button alignment used for selected display positions';
comment on column apex_application_page_buttons.REDIRECT_URL          is 'Identifies an optional Page or URL to redirect to when this button is pressed.  If no Redirect URL is provided then the button will submit the page, a redirect will not submit the page.';
comment on column apex_application_page_buttons.CONDITION_TYPE        is 'Identifies the condition type used to conditionally display the Page Button';
comment on column apex_application_page_buttons.CONDITION_EXPRESSION1 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_buttons.CONDITION_EXPRESSION2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_buttons.IMAGE_ATTRIBUTES      is 'Identifies the HTML IMG tag attributes for the image used to display the button';
comment on column apex_application_page_buttons.BUTTON_ATTRIBUTES     is 'Identifies the HTML INPUT tag attributes';
comment on column apex_application_page_buttons.DATABASE_ACTION       is 'A button can be used to trigger table row processing (insert, update, and delete). This attribute determines the type of DML action to be performed.';
comment on column apex_application_page_buttons.BUILD_OPTION          is 'Button will be displayed if the Build Option is enabled';
comment on column apex_application_page_buttons.AUTHORIZATION_SCHEME  is 'An authorization scheme must evaluate to TRUE in order for this button to be displayed';
comment on column apex_application_page_buttons.AUTHORIZATION_SCHEME_ID  is 'Foreign Key';
comment on column apex_application_page_buttons.COMPONENT_COMMENT     is 'Developer comment';
comment on column apex_application_page_buttons.BUTTON_POSITION       is 'Identifies where the button displays';
comment on column apex_application_page_buttons.BUTTON_ID             is 'Primary key of this page button';
comment on column apex_application_page_buttons.last_updated_by       is 'Apex developer who made last update';
comment on column apex_application_page_buttons.last_updated_on       is 'Date of last update';
comment on column apex_application_page_buttons.component_signature   is 'Identifies attributes defined at a given component level to facilitate application comparisons';
grant select on   apex_application_page_buttons to public;




---------------------------------------------------
-- A P P L I C A T I O N   B U I L D  O P T I O N S
--
prompt ...apex_application_build_options

create or replace view apex_application_build_options
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    b.PATCH_NAME                     build_option_name,
    decode(b.PATCH_STATUS,
        'INCLUDE','Include',
        'EXCLUDE','Exclude',
        b.patch_status)              build_option_status,
    decode(nvl(b.DEFAULT_ON_EXPORT,
        b.patch_status),
        'INCLUDE','Include',
        'EXCLUDE','Exclude',
        b.DEFAULT_ON_EXPORT)         status_on_export,
    --b.ATTRIBUTE1                   attribute1,
    --b.ATTRIBUTE2                   attribute2,
    --b.ATTRIBUTE3                   attribute3,
    --b.ATTRIBUTE4                   attribute4,
    b.LAST_UPDATED_BY                last_updated_by,
    b.LAST_UPDATED_ON                last_updated_on,
    b.PATCH_COMMENT                  component_comment,
    b.id                             build_option_id,
    --
    b.PATCH_NAME
    ||' s='||decode(b.PATCH_STATUS,
        'INCLUDE','Include',
        'EXCLUDE','Exclude',
        b.patch_status)
    ||' e='||decode(nvl(b.DEFAULT_ON_EXPORT,
        b.patch_status),
        'INCLUDE','Include',
        'EXCLUDE','Exclude',
        b.DEFAULT_ON_EXPORT)
    component_signature
from wwv_flow_patches b,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = b.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_build_options                      is 'Identifies Build Options available to an application';
comment on column apex_application_build_options.workspace            is 'A work area mapped to one or more database schemas';
comment on column apex_application_build_options.application_id       is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_build_options.application_name     is 'Identifies the application';
comment on column apex_application_build_options.BUILD_OPTION_NAME    is 'Identifies the build option';
comment on column apex_application_build_options.BUILD_OPTION_STATUS  is 'Identifies the current status of the Build option; Include or Exclude.';
comment on column apex_application_build_options.STATUS_ON_EXPORT     is 'Identifies the status (Include or Exclude) of this Build Option when the build option is exported.';
comment on column apex_application_build_options.COMPONENT_COMMENT    is 'Developer Comment';
comment on column apex_application_build_options.BUILD_OPTION_ID      is 'Identifies the primary key of this component';
comment on column apex_application_build_options.last_updated_by      is 'Apex developer who made last update';
comment on column apex_application_build_options.last_updated_on      is 'Date of last update';
comment on column apex_application_build_options.component_signature  is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_build_options to public;

---------------------------------------------------
-- A P P L I C A T I O N   T A B S
--
prompt ...apex_application_tabs

create or replace view apex_application_tabs
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.TAB_SET                        tab_set,
    t.TAB_SEQUENCE                   display_sequence,
    t.TAB_NAME                       tab_name,
    t.TAB_IMAGE                      when_current_tab_image,
    t.TAB_NON_CURRENT_IMAGE          when_not_current_tab_image,
    t.TAB_IMAGE_ATTRIBUTES           tab_image_attributes,
    t.TAB_TEXT                       tab_label,
    t.TAB_STEP                       tab_page,
    t.TAB_ALSO_CURRENT_FOR_PAGES     tab_also_current_for_pages,
    t.TAB_PARENT_TABSET              parent_tabset,
    --
    nvl((select r from apex_standard_conditions where d = t.DISPLAY_CONDITION_TYPE),t.DISPLAY_CONDITION_TYPE)
                                     condition_type,
    t.TAB_PLSQL_CONDITION            condition_expression1,
    t.TAB_DISP_COND_TEXT             condition_expression2,
    --
    (select case when t.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(t.REQUIRED_PATCH))    build_option,
     --
    decode(substr(t.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(t.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     t.SECURITY_SCHEME)              authorization_scheme,
    t.SECURITY_SCHEME                authorization_scheme_id,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    t.TAB_COMMENT                    component_comment,
    t.id                             tab_id,
    --
    t.TAB_SET
    ||' '||lpad(t.TAB_SEQUENCE,5,'00000')
    ||' '||t.TAB_NAME
    ||substr(t.TAB_IMAGE,1,30)||length(t.TAB_IMAGE)
    ||substr(t.TAB_NON_CURRENT_IMAGE,1,30)||length(t.TAB_NON_CURRENT_IMAGE)
    ||substr(t.TAB_IMAGE_ATTRIBUTES,1,30)||length(t.TAB_IMAGE_ATTRIBUTES)
    ||' text='||substr(t.TAB_TEXT,1,30)||length(t.TAB_TEXT)
    ||' p='||t.TAB_STEP
    ||' a='||substr(t.TAB_ALSO_CURRENT_FOR_PAGES,1,30)||length(t.TAB_ALSO_CURRENT_FOR_PAGES)
    ||substr(t.TAB_PARENT_TABSET,1,30)||length(t.TAB_PARENT_TABSET)
    ||' c='||t.DISPLAY_CONDITION_TYPE
    ||substr(t.TAB_PLSQL_CONDITION,1,30)||length(t.TAB_PLSQL_CONDITION)
    ||substr(t.TAB_DISP_COND_TEXT,1,30)||length(t.TAB_DISP_COND_TEXT)
    ||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(t.REQUIRED_PATCH))
    ||decode(substr(t.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(t.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     t.SECURITY_SCHEME)
    component_signature
from wwv_flow_tabs t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_tabs                            is 'Identifies a set of tabs collected into tab sets which are associated with a Standard Tab Entry';
comment on column apex_application_tabs.workspace                  is 'A work area mapped to one or more database schemas';
comment on column apex_application_tabs.application_id             is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_tabs.application_name           is 'Identifies the application';
comment on column apex_application_tabs.TAB_SET                    is 'Identifies a collection of tabs that will be displayed together.  If an application uses tabs each page identifies the Tab Set to be displayed with the page.';
comment on column apex_application_tabs.DISPLAY_SEQUENCE           is 'Identifies the display sequence of the Tab within the Tab Set';
comment on column apex_application_tabs.TAB_NAME                   is 'Identifies the name of the tab; which will be the value of the REQUEST when the tab is pressed';
comment on column apex_application_tabs.WHEN_CURRENT_TAB_IMAGE     is 'For tabs displayed using images and not a Tab Label, identifies the current tab image';
comment on column apex_application_tabs.WHEN_NOT_CURRENT_TAB_IMAGE is 'For tabs displayed using images and not a Tab Label, identifies the non current tab image';
comment on column apex_application_tabs.TAB_IMAGE_ATTRIBUTES       is 'Identifies the HTML IMG tag image attributes';
comment on column apex_application_tabs.TAB_LABEL                  is 'Identifies the display Tab Label for tabs that are not based on image';
comment on column apex_application_tabs.TAB_PAGE                   is 'Identifies the page which is current and associated with this tab.';
comment on column apex_application_tabs.TAB_ALSO_CURRENT_FOR_PAGES is 'Identifies one or more other page ID''s which are also current for this tab';
comment on column apex_application_tabs.PARENT_TABSET              is 'Identifies the Parent Tab Tab-Set to be displayed when this tab is current.  Used only when using two levels of tabs.';
comment on column apex_application_tabs.CONDITION_TYPE             is 'Identifies the condition type used to conditionally display the tab.';
comment on column apex_application_tabs.CONDITION_EXPRESSION1      is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_tabs.CONDITION_EXPRESSION2      is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_tabs.BUILD_OPTION               is 'Tab will be displayed if the Build Option is enabled';
comment on column apex_application_tabs.AUTHORIZATION_SCHEME       is 'An authorization scheme must evaluate to TRUE in order for this tab to be displayed';
comment on column apex_application_tabs.AUTHORIZATION_SCHEME_ID    is 'Foreign Key';
comment on column apex_application_tabs.COMPONENT_COMMENT          is 'Developer comment';
comment on column apex_application_tabs.TAB_ID                     is 'Primary key of this tab';
comment on column apex_application_tabs.last_updated_by            is 'Apex developer who made last update';
comment on column apex_application_tabs.last_updated_on            is 'Date of last update';
comment on column apex_application_tabs.component_signature        is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on apex_application_tabs to public;


---------------------------------------------------
-- A P P L I C A T I O N   P A R E N T   T A B S
--
prompt ...apex_application_parent_tabs

create or replace view apex_application_parent_tabs
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.TAB_SET                        tab_set,
    t.TAB_SEQUENCE                   display_sequence,
    t.TAB_NAME                       tab_name,
    t.TAB_IMAGE                      when_current_image,
    t.TAB_NON_CURRENT_IMAGE          when_non_current_image,
    t.TAB_IMAGE_ATTRIBUTES           image_attributes,
    t.TAB_TEXT                       tab_label,
    t.TAB_TARGET                     tab_target,
    --
    nvl((select r from apex_standard_conditions where d = t.DISPLAY_CONDITION_TYPE),t.DISPLAY_CONDITION_TYPE)
                                     condition_type,
    t.DISPLAY_CONDITION              condition_expression1,
    t.DISPLAY_CONDITION2             condition_expression2,
    --
    t.CURRENT_ON_TABSET              current_for_tabset,
    --
    (select case when t.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(t.REQUIRED_PATCH))    build_option,
    --
    decode(substr(t.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(t.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     t.SECURITY_SCHEME)              authorization_scheme,
    t.SECURITY_SCHEME                authorization_scheme_id,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    t.TAB_COMMENT                    component_comment,
    t.id                             parent_tab_id,
    --
    t.TAB_SET
    ||' '||lpad(t.TAB_SEQUENCE,5,'00000')
    ||' '||substr(t.TAB_NAME              ,1,30)||length(t.TAB_NAME             )
    ||' '||substr(t.TAB_IMAGE             ,1,30)||length(t.TAB_IMAGE            )
    ||' '||substr(t.TAB_NON_CURRENT_IMAGE ,1,30)||length(t.TAB_NON_CURRENT_IMAGE)
    ||' '||substr(t.TAB_IMAGE_ATTRIBUTES  ,1,30)||length(t.TAB_IMAGE_ATTRIBUTES )
    ||' '||substr(t.TAB_TEXT              ,1,30)||length(t.TAB_TEXT             )
    ||' '||substr(t.TAB_TARGET            ,1,30)||length(t.TAB_TARGET           )
    ||' cond='||t.DISPLAY_CONDITION_TYPE
    ||substr(t.DISPLAY_CONDITION,1,30)||length(t.DISPLAY_CONDITION)
    ||substr(t.DISPLAY_CONDITION2,1,30)||length(t.DISPLAY_CONDITION2)
    ||' ct='||t.CURRENT_ON_TABSET
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(t.REQUIRED_PATCH))
    ||' sec='||decode(substr(t.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(t.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     t.SECURITY_SCHEME)
    component_signature
from wwv_flow_toplevel_tabs t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_parent_tabs                        is 'Identifies a collection of tabs called a Tab Set.  Each tab is part of a tab set and can be current for one or more pages.  Each tab can also have a corresponding Parent Tab if two levels of Tabs are defined.';
comment on column apex_application_parent_tabs.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_parent_tabs.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_parent_tabs.application_name       is 'Identifies the application';
comment on column apex_application_parent_tabs.TAB_SET                is 'Identifies a collection of Parent Tabs that are displayed together.';
comment on column apex_application_parent_tabs.DISPLAY_SEQUENCE       is 'Identifies the display sequence within the Tab Set';
comment on column apex_application_parent_tabs.TAB_NAME               is 'Identifies the Tab Name';
comment on column apex_application_parent_tabs.WHEN_CURRENT_IMAGE     is 'For tabs displayed using images and not a Tab Label, identifies the current tab image';
comment on column apex_application_parent_tabs.WHEN_NON_CURRENT_IMAGE is 'For tabs displayed using images and not a Tab Label, identifies the non current tab image';
comment on column apex_application_parent_tabs.IMAGE_ATTRIBUTES       is 'Identifies the HTML IMG tag image attributes';
comment on column apex_application_parent_tabs.TAB_LABEL              is 'Identifies the display Tab Label for tabs that are not based on image';
comment on column apex_application_parent_tabs.TAB_TARGET             is 'Identifies the Page or URL to branch to when this Parent Tab is pressed';
comment on column apex_application_parent_tabs.CONDITION_TYPE         is 'Identifies the condition type used to conditionally display the tab.';
comment on column apex_application_parent_tabs.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_parent_tabs.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_parent_tabs.CURRENT_FOR_TABSET     is 'Identifies the child (corresponding standard tab) of this parent tab.';
comment on column apex_application_parent_tabs.BUILD_OPTION           is 'Tab will be displayed if the Build Option is enabled';
comment on column apex_application_parent_tabs.AUTHORIZATION_SCHEME   is 'An authorization scheme must evaluate to TRUE in order for this tab to be displayed';
comment on column apex_application_parent_tabs.AUTHORIZATION_SCHEME_id is 'Foreign Key';
comment on column apex_application_parent_tabs.COMPONENT_COMMENT      is 'Developer comment';
comment on column apex_application_parent_tabs.PARENT_TAB_ID          is 'Primary key of the Parent Tab component';
comment on column apex_application_parent_tabs.last_updated_by        is 'Apex developer who made last update';
comment on column apex_application_parent_tabs.last_updated_on        is 'Date of last update';
comment on column apex_application_parent_tabs.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_parent_tabs to public;

---------------------------------------------------------
-- S U P P OR T I N G    O B J E C T S
--
prompt ...apex_application_supp_objects

create or replace view apex_application_supp_objects
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    (select count(*)
    from wwv_flow_install_build_opt
    where install_id = i.id)         build_options,
    --
    decode(i.INCLUDE_IN_EXPORT_YN,
      'Y','Yes',
      'N','No',
      i.INCLUDE_IN_EXPORT_YN)        include_in_application_export,
    i.WELCOME_MESSAGE                ,
    i.LICENSE_MESSAGE                ,
    i.VALIDATION_MESSAGE             ,
    --
    i.INSTALL_MESSAGE                installation_message,
    i.INSTALL_SUCCESS_MESSAGE        installation_success_message,
    i.INSTALL_FAILURE_MESSAGE        installation_failure_message,
    (select count(*)
     from wwv_flow_install_scripts
     where i.id = install_id
       and nvl(script_type,'INSTALL') = 'INSTALL')
                                     installation_scripts,
    --
    i.get_version_sql_query          upgrade_when_query,
    i.upgrade_message                upgrade_message,
    i.upgrade_confirm_message        upgrade_confirm_message,
    i.upgrade_success_message        upgrade_success_message,
    i.upgrade_failure_message        upgrade_failure_message,
    (select count(*)
     from wwv_flow_install_scripts
     where i.id = install_id
       and nvl(script_type,'INSTALL') = 'UPGRADE')
                                     upgrade_scripts,
    --
    --
    i.DEINSTALL_MESSAGE              ,
    i.DEINSTALL_SUCCESS_MESSAGE      ,
    --i.DEINSTALL_FAILURE_MESSAGE      ,
    i.DEINSTALL_SCRIPT               deinstallation_script,
    --
    --i.PROMPT_SUBSTITUTION_01_YN      ,
    --i.PROMPT_SUBSTITUTION_02_YN      ,
    --i.PROMPT_SUBSTITUTION_03_YN      ,
    --i.PROMPT_SUBSTITUTION_04_YN      ,
    --i.PROMPT_SUBSTITUTION_05_YN      ,
    --i.PROMPT_SUBSTITUTION_06_YN      ,
    --i.PROMPT_SUBSTITUTION_07_YN      ,
    --i.PROMPT_SUBSTITUTION_08_YN      ,
    --i.PROMPT_SUBSTITUTION_09_YN      ,
    --i.PROMPT_SUBSTITUTION_10_YN      ,
    --i.PROMPT_SUBSTITUTION_11_YN      ,
    --i.PROMPT_SUBSTITUTION_12_YN      ,
    --i.PROMPT_SUBSTITUTION_13_YN      ,
    --i.PROMPT_SUBSTITUTION_14_YN      ,
    --i.PROMPT_SUBSTITUTION_15_YN      ,
    --i.PROMPT_SUBSTITUTION_16_YN      ,
    --i.PROMPT_SUBSTITUTION_17_YN      ,
    --i.PROMPT_SUBSTITUTION_18_YN      ,
    --i.PROMPT_SUBSTITUTION_19_YN      ,
    --i.PROMPT_SUBSTITUTION_20_YN      ,
    ----
    --i.PROMPT_IF_MULT_AUTH_YN         ,
    --i.PROMPT_BUILD_OPTIONS           ,
    --
    i.LAST_UPDATED_BY                ,
    i.LAST_UPDATED_ON                ,
    i.CREATED_BY                     ,
    i.CREATED_ON                     ,
    --
    --i.INSTALL_PROMPT_01              ,
    --i.INSTALL_PROMPT_02              ,
    --i.INSTALL_PROMPT_03              ,
    --i.INSTALL_PROMPT_04              ,
    --i.INSTALL_PROMPT_05              ,
    --i.INSTALL_PROMPT_06              ,
    --i.INSTALL_PROMPT_07              ,
    --i.INSTALL_PROMPT_08              ,
    --i.INSTALL_PROMPT_09              ,
    --i.INSTALL_PROMPT_10              ,
    --i.INSTALL_PROMPT_11              ,
    --i.INSTALL_PROMPT_12              ,
    --i.INSTALL_PROMPT_13              ,
    --i.INSTALL_PROMPT_14              ,
    --i.INSTALL_PROMPT_15              ,
    --i.INSTALL_PROMPT_16              ,
    --i.INSTALL_PROMPT_17              ,
    --i.INSTALL_PROMPT_18              ,
    --i.INSTALL_PROMPT_19              ,
    --i.INSTALL_PROMPT_20              ,
    i.CONFIGURATION_MESSAGE          ,
    -- obsolete i.TRIGGER_INSTALL_WHEN_COND      ,
    -- obsolete i.TRIGGER_INSTALL_WHEN_EXP1      ,
    -- obsolete i.TRIGGER_INSTALL_WHEN_EXP2      ,
    -- obsolete i.TRIGGER_FAILURE_MESSAGE        ,
    i.BUILD_OPTIONS_MESSAGE          ,
    i.REQUIRED_FREE_KB               ,
    i.REQUIRED_SYS_PRIVS             required_system_privileges,
    i.REQUIRED_NAMES_AVAILABLE       ,
    --
    i.id                             supporting_object_id
from wwv_flow_install i,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.id = i.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_supp_objects                               is 'Identifies the Supporting Object installation messages';
comment on column apex_application_supp_objects.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_supp_objects.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_supp_objects.application_name              is 'Identifies the application';
comment on column apex_application_supp_objects.BUILD_OPTIONS                 is 'Count of Build Options referenced in this applications supporting object installation wizard';
comment on column apex_application_supp_objects.INCLUDE_IN_APPLICATION_EXPORT is 'Flag that specifies if the application export will include the supporting object definitions and scripts';
comment on column apex_application_supp_objects.WELCOME_MESSAGE               is 'After successfully importing and installing an application definition, the installation wizard prompts the user to install supporting objects for the application.';
comment on column apex_application_supp_objects.LICENSE_MESSAGE               is 'If the use of this application requires the user to accept a license, enter it here. The user will be prompted to accept the message before installing database objects.';
comment on column apex_application_supp_objects.VALIDATION_MESSAGE            is 'Message to display above the list of installation validations when this application installs.';
comment on column apex_application_supp_objects.INSTALLATION_MESSAGE          is 'Message to display during installation confirmation before the installation scripts are run and configuration options are applied.';
comment on column apex_application_supp_objects.INSTALLATION_SUCCESS_MESSAGE  is 'Enter a message to display after all installation scripts have run without errors.';
comment on column apex_application_supp_objects.INSTALLATION_FAILURE_MESSAGE  is 'Enter a message to display after installation scripts have been run with errors.';
comment on column apex_application_supp_objects.INSTALLATION_SCRIPTS          is 'Count of installation SQL scripts';
comment on column apex_application_supp_objects.upgrade_when_query            is 'SQL query that returns at least one row if supporting objects exist, which means an upgrade should be performed';
comment on column apex_application_supp_objects.upgrade_message               is 'Message to display before this application''s supporting objects are upgraded';
comment on column apex_application_supp_objects.upgrade_confirm_message       is 'Message to display during upgrade confirmation before the upgrade scripts are run and configuration options are applied';
comment on column apex_application_supp_objects.upgrade_success_message       is 'Message to display after all upgrade scripts have run without errors';
comment on column apex_application_supp_objects.upgrade_failure_message       is 'Message to display after upgrade scripts have been run with errors';
comment on column apex_application_supp_objects.upgrade_scripts               is 'Count of upgrade SQL scripts';
comment on column apex_application_supp_objects.DEINSTALL_MESSAGE             is 'Enter a message to display during deinstallation confirmation when this application is deinstalled.';
comment on column apex_application_supp_objects.DEINSTALL_SUCCESS_MESSAGE     is 'Enter a message to display after all deinstallation scripts have run.';
comment on column apex_application_supp_objects.DEINSTALLATION_SCRIPT         is 'The deinstallation SQL script, uses SQL*plus like script syntax';
comment on column apex_application_supp_objects.CREATED_BY                    is 'Apex developer who created the component';
comment on column apex_application_supp_objects.CREATED_ON                    is 'Date created';
comment on column apex_application_supp_objects.CONFIGURATION_MESSAGE         is 'Message to display above the application substitution prompts when this application installs.';
comment on column apex_application_supp_objects.BUILD_OPTIONS_MESSAGE         is 'Message to display above the build option prompts when this application installs.';
comment on column apex_application_supp_objects.REQUIRED_FREE_KB              is 'Freespace required to install this application.';
comment on column apex_application_supp_objects.required_system_privileges    is 'Identifies the system privileges required to install this application.';
comment on column apex_application_supp_objects.REQUIRED_NAMES_AVAILABLE      is 'Installation is prevented if these objects already exist in the parsing schema.';
comment on column apex_application_supp_objects.SUPPORTING_OBJECT_ID          is 'Primary Key of this component';
comment on column apex_application_supp_objects.last_updated_by               is 'Apex developer who made last update';
comment on column apex_application_supp_objects.last_updated_on               is 'Date of last update';
grant select   on apex_application_supp_objects to public;



create or replace view apex_application_supp_obj_bopt
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    (select patch_name
     from   wwv_flow_patches
     where  id=i.BUILD_OPT_ID)       build_option,
    --
    decode(
    (select patch_status
     from   wwv_flow_patches
     where  id=i.BUILD_OPT_ID),
     'INCLUDE','Include',
     'EXCLUDE','Exclude',
     i.BUILD_OPT_ID)                 default_status,
    --
    (select patch_comment
     from   wwv_flow_patches
     where  id=i.BUILD_OPT_ID)       developer_comment,
     i.id                            install_build_option_id
from wwv_flow_install_build_opt i,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.id = i.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/


comment on table  apex_application_supp_obj_bopt                         is 'Identifies the Application Build Options that will be exposed to the Supporting Object installation';
comment on column apex_application_supp_obj_bopt.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_supp_obj_bopt.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_supp_obj_bopt.application_name        is 'Identifies the application';
comment on column apex_application_supp_obj_bopt.build_option            is 'Identifies the Application Build Option that will be prompted for during the installation of the Supporting Objects';
comment on column apex_application_supp_obj_bopt.default_status          is 'Identifies the default Status (Excluded, Included) of the Build Option';
comment on column apex_application_supp_obj_bopt.developer_comment       is 'Identifies the developer comment applied to the Build Option definition';
comment on column apex_application_supp_obj_bopt.install_build_option_id is 'Primary Key of this Supporting Object Build Option';
grant select   on apex_application_supp_obj_bopt to public;


create or replace view apex_application_supp_obj_scr
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    i.NAME                           script_name,
    i.SEQUENCE                       execution_sequence,
    decode(i.SCRIPT_TYPE,
           'UPGRADE','Upgrade',
           'INSTALL','Install',
           i.SCRIPT_TYPE)            script_type,
    --
    i.SCRIPT                         sql_script,
    --
    i.CONDITION_TYPE                 condition_type,
    i.CONDITION                      condition_expression1,
    i.CONDITION2                     condition_expression2,
    --
    i.LAST_UPDATED_BY                last_updated_by,
    i.LAST_UPDATED_ON                last_updated_on,
    i.CREATED_BY                     created_by,
    i.CREATED_ON                     created_on,
    --
    i.ID                             supporting_object_script_id
from wwv_flow_install_scripts i,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.id = i.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_supp_obj_scr                             is 'Identifies the Supporting Object installation SQL Scripts';
comment on column apex_application_supp_obj_scr.workspace                   is 'A work area mapped to one or more database schemas';
comment on column apex_application_supp_obj_scr.application_id              is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_supp_obj_scr.application_name            is 'Identifies the application';
comment on column apex_application_supp_obj_scr.SCRIPT_NAME                 is 'Identifies the name of the installation SQL Script';
comment on column apex_application_supp_obj_scr.EXECUTION_SEQUENCE          is 'Identifies the execution of the installation SQL Script';
comment on column apex_application_supp_obj_scr.SCRIPT_TYPE                 is 'Identifies whether this is an install or upgrade SQL Script';
comment on column apex_application_supp_obj_scr.SQL_SCRIPT                  is 'Identifies the SQL Script.  Most basic SQL*plus syntax can be used to create database objects and load sample data.';
comment on column apex_application_supp_obj_scr.CONDITION_TYPE              is 'Identifies the condition type used to conditionally execute the Installation SQL Script';
comment on column apex_application_supp_obj_scr.CONDITION_EXPRESSION1       is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_supp_obj_scr.CONDITION_EXPRESSION2       is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_supp_obj_scr.CREATED_BY                  is 'Apex User Name of the developer who created this SQL Script';
comment on column apex_application_supp_obj_scr.CREATED_ON                  is 'Date that this SQL Script was created';
comment on column apex_application_supp_obj_scr.SUPPORTING_OBJECT_SCRIPT_ID is 'Primary Key of this SQL Script component';
comment on column apex_application_supp_obj_scr.last_updated_by             is 'Apex developer who made last update';
comment on column apex_application_supp_obj_scr.last_updated_on             is 'Date of last update';
grant select   on apex_application_supp_obj_scr to public;




create or replace view apex_application_supp_obj_chck
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    c.ID                             check_id,
    c.NAME                           check_name,
    c.SEQUENCE                       check_sequence,
    --
    c.CHECK_TYPE                     check_type,
    c.CHECK_CONDITION                check_expression1,
    c.CHECK_CONDITION2               check_expression2,
    --
    --c.SUCCESS_MESSAGE                ,
    c.FAILURE_MESSAGE                error_message,
    --
    c.CONDITION_TYPE                 condition_type,
    c.CONDITION                      condition_expression1,
    c.CONDITION2                     condition_expression2,
    --
    c.LAST_UPDATED_BY                last_updated_by,
    c.LAST_UPDATED_ON                last_updated_on,
    c.CREATED_BY                     created_by,
    c.CREATED_ON                     created_on
from
     wwv_flow_install_checks c,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.id = c.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_supp_obj_chck                       is 'Identifies the Supporting Object pre-installation checks to ensure the database is compatible with the objects to be installed';
comment on column apex_application_supp_obj_chck.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_supp_obj_chck.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_supp_obj_chck.application_name      is 'Identifies the application';
comment on column apex_application_supp_obj_chck.CHECK_ID              is 'Specifies the ID for this validation.';
comment on column apex_application_supp_obj_chck.CHECK_NAME            is 'Specifies the name for this validation.';
comment on column apex_application_supp_obj_chck.CHECK_SEQUENCE        is 'Specifies the sequence for this validation. The sequence number determines the order of evaluation.';
comment on column apex_application_supp_obj_chck.CHECK_TYPE            is 'Specifies the condition type that must be met during installation before installation scripts are run.';
comment on column apex_application_supp_obj_chck.CHECK_EXPRESSION1     is 'Use this attribute to conditionally control whether installation can continue. Values correspond to the specific condition type selected.';
comment on column apex_application_supp_obj_chck.CHECK_EXPRESSION2     is 'Use this attribute to conditionally control whether installation can continue. Values correspond to the specific condition type selected.';
comment on column apex_application_supp_obj_chck.error_MESSAGE         is 'Enter a message to be displayed when the conditions of this validation are not met.';
comment on column apex_application_supp_obj_chck.CONDITION_TYPE        is 'Specifies a condition type from the list that conditionally controls whether this validation is performed.';
comment on column apex_application_supp_obj_chck.CONDITION_EXPRESSION1 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_supp_obj_chck.CONDITION_EXPRESSION2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_supp_obj_chck.CREATED_BY            is 'Identifies the User Name of the Apex developer who created this check condition';
comment on column apex_application_supp_obj_chck.CREATED_ON            is 'Identifies the date that this component was created';
comment on column apex_application_supp_obj_chck.last_updated_by       is 'Apex developer who made last update';
comment on column apex_application_supp_obj_chck.last_updated_on       is 'Date of last update';
grant select   on apex_application_supp_obj_chck to public;




---------------------------------------------------------
-- A P P L I C A T I O N   T R A N S L A T I O N S
--
prompt ...apex_application_translations

create or replace view apex_application_translations
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.NAME                           translatable_message,
    t.MESSAGE_LANGUAGE               language_code,
    --
    t.MESSAGE_TEXT                   message_text,
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    t.MESSAGE_COMMENT                developer_comment,
    t.id                             translation_entry_id
from WWV_FLOW_MESSAGES$ t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      /* keep this language map not exists */
      not exists (
        select 1 from wwv_flow_language_map
        where translation_flow_id = f.id) and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_translations                       is 'Identifies message primary language text and translated text';
comment on column apex_application_translations.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_translations.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_translations.application_name      is 'Identifies the application';
comment on column apex_application_translations.TRANSLATABLE_MESSAGE  is 'Identifies the Message Name';
comment on column apex_application_translations.LANGUAGE_CODE         is 'Identifies the Language Code';
comment on column apex_application_translations.MESSAGE_TEXT          is 'Identifies the message text in the Language Code language';
comment on column apex_application_translations.DEVELOPER_COMMENT     is 'Developer Comment';
comment on column apex_application_translations.last_updated_by       is 'Apex developer who made last update';
comment on column apex_application_translations.last_updated_on       is 'Date of last update';
comment on column apex_application_translations.translation_entry_id  is 'Primary Key of this Translation Entry';
grant select on   apex_application_translations to public;


---------------------------------------------------------
-- A P P L I C A T I O N   I T E M S
--
prompt ...apex_application_items

create or replace view apex_application_items
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    i.NAME                           item_name,
    --i.NAME_LENGTH
    i.DATA_TYPE                      data_type,
    --i.IS_PERSISTENT                  ,
    i.PROTECTION_LEVEL               Session_State_Protection,
    (select case when i.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(i.REQUIRED_PATCH))    build_option,
    i.LAST_UPDATED_BY                ,
    i.LAST_UPDATED_ON                ,
    i.ITEM_COMMENT                   component_comment,
    i.id                             application_item_id,
    --
    i.NAME
    ||' dt='||i.DATA_TYPE
    ||' prot='||i.PROTECTION_LEVEL
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =i.REQUIRED_PATCH)
    component_signature
from wwv_flow_items i,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.id = i.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_items                           is 'Identifies Application Items used to maintain session state that are not associated with a page';
comment on column apex_application_items.workspace                 is 'A work area mapped to one or more database schemas';
comment on column apex_application_items.application_id            is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_items.application_name          is 'Identifies the application';
comment on column apex_application_items.ITEM_NAME                 is 'Name of the Application Item used to maintain session state';
comment on column apex_application_items.DATA_TYPE                 is 'Datatype (Varchar or Number) of the Application Item.  Use a numeric data type to limit exposure to URL hackers for management of numeric session state';
comment on column apex_application_items.Session_State_Protection  is 'Identifies the Session State Protection for this item.  If the item is "Unrestricted" the item may be set by passing the item name/value in a URL or in a form.  Other protection levels provide enhanced protection of session state.';
comment on column apex_application_items.BUILD_OPTION              is 'Application Item will be available if the Build Option is enabled';
comment on column apex_application_items.COMPONENT_COMMENT         is 'Developer comment';
comment on column apex_application_items.APPLICATION_ITEM_ID       is 'Primary key of this Application Item';
comment on column apex_application_items.last_updated_by           is 'Apex developer who made last update';
comment on column apex_application_items.last_updated_on           is 'Date of last update';
comment on column apex_application_items.component_signature       is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_items to public;

---------------------------------------------------------
-- A P P L I C A T I O N   P R O C E S S E S
--
prompt ...apex_application_processes

create or replace view apex_application_processes
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    p.PROCESS_SEQUENCE               process_sequence,
    --
    decode(p.PROCESS_POINT,
      'BEFORE_HEADER','On Load: Before Header (page template header)',
      'AFTER_HEADER','On Load: After Header (page template header)',
      'BEFORE_BOX_BODY','On Load: Before Body Region(s)',
      'AFTER_BOX_BODY','On Load: After Body Region(s)',
      'BEFORE_FOOTER','On Load: Before Footer (page template footer)',
      'AFTER_FOOTER','On Load: After Footer (page template footer)',
      'ON_SUBMIT_BEFORE_COMPUTATION','On Submit: After Page Submission - Before Computations and Validations',
      'AFTER_SUBMIT','On Submit: After Page Submission - After Computations and Validations',
      'AFTER_AUTHENTICATION','On New Session: After Authentication',
      'ON_DEMAND','On Demand: Run this application process when requested by a page process',
      p.process_point)               process_point,
    --
    decode(p.PROCESS_TYPE,
      'PLSQL','PL/SQL Anonymous Block',
      p.PROCESS_TYPE)                process_type,
    --
    p.PROCESS_NAME                   process_name,
    p.PROCESS_SQL_CLOB               process,
    p.PROCESS_ERROR_MESSAGE          error_message,
    --
    nvl((select r
    from apex_standard_conditions
    where d = p.PROCESS_WHEN_TYPE ),
    p.PROCESS_WHEN_TYPE)
                                     condition_type,
    p.PROCESS_WHEN                   condition_expression1,
    p.PROCESS_WHEN2                  condition_expression2,
    --p.PROCESS_WHEN_TYPE2             ,
    --p.ITEM_NAME                      ,
    nvl((select case when p.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(p.REQUIRED_PATCH)),
     p.REQUIRED_PATCH)               build_option,
     --
     decode(substr(p.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(p.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     p.SECURITY_SCHEME)              authorization_scheme,
    p.SECURITY_SCHEME                authorization_scheme_id,
    p.LAST_UPDATED_BY                last_updated_by,
    p.LAST_UPDATED_ON                last_updated_on,
    p.PROCESS_COMMENT                component_comment,
    p.id                             application_process_id,
    --
    p.PROCESS_NAME
    ||' seq='||lpad(p.PROCESS_SEQUENCE,5,'00000')
    ||' '||p.PROCESS_POINT
    ||' '||decode(p.PROCESS_TYPE,'PLSQL','PL/SQL Anonymous Block',p.PROCESS_TYPE)
    ||' txt='||dbms_lob.substr(p.PROCESS_SQL_CLOB,50,1)||dbms_lob.getlength(p.PROCESS_SQL_CLOB)
    ||' m='||substr(p.PROCESS_ERROR_MESSAGE,1,30)||length(p.PROCESS_ERROR_MESSAGE)
    ||' cond='||p.PROCESS_WHEN_TYPE
    ||substr(p.PROCESS_WHEN,1,20)||length(p.PROCESS_WHEN)
    ||substr(p.PROCESS_WHEN2,1,20)||length(p.PROCESS_WHEN2)
    ||' b='||nvl((select name from    wwv_flow_security_schemes where   to_char(id)= abs(p.REQUIRED_PATCH) and flow_id = f.id),p.REQUIRED_PATCH)
    ||' s='||decode(substr(p.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(p.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     p.SECURITY_SCHEME)
    component_signature
from wwv_flow_processing p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.id = p.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_processes                        is 'Identifies Application Processes which can run for every page, on login or upon demand';
comment on column apex_application_processes.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_processes.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_processes.application_name       is 'Identifies the application';
comment on column apex_application_processes.PROCESS_SEQUENCE       is 'Identifies the sequence that processes will be considered for execution within each process point';
comment on column apex_application_processes.PROCESS_POINT          is 'Identifies the point of execution of this process';
comment on column apex_application_processes.PROCESS_TYPE           is 'Identifies the type of process this is';
comment on column apex_application_processes.PROCESS_NAME           is 'Identifies this process';
comment on column apex_application_processes.PROCESS                is 'Text of the Application Process';
comment on column apex_application_processes.ERROR_MESSAGE          is 'Identifies the error message to be displayed if this processes raises an exception';
comment on column apex_application_processes.CONDITION_type         is 'Specifies a condition type from the Application Process that conditionally controls whether this Application Process is performed.';
comment on column apex_application_processes.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_processes.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_processes.BUILD_OPTION           is 'Application Process will be available for execution if the Build Option is enabled';
comment on column apex_application_processes.AUTHORIZATION_SCHEME   is 'An authorization scheme must evaluate to TRUE in order for this process to be executed';
comment on column apex_application_processes.AUTHORIZATION_SCHEME_ID is 'Foreign Key';
comment on column apex_application_processes.COMPONENT_COMMENT      is 'Developer comment';
comment on column apex_application_processes.APPLICATION_PROCESS_ID is 'Primary key of this Application Process';
comment on column apex_application_processes.last_updated_by        is 'Apex developer who made last update';
comment on column apex_application_processes.last_updated_on        is 'Date of last update';
comment on column apex_application_processes.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_processes to public;

---------------------------------------------------------
-- A P P L I C A T I O N   C O M P U T A T I O N S
--
prompt ...apex_application_computations

create or replace view apex_application_computations
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    c.COMPUTATION_SEQUENCE           computation_sequence,
    c.COMPUTATION_ITEM               computation_item,
    c.COMPUTATION_POINT              computation_point,
    --c.COMPUTATION_ITEM_TYPE
    c.COMPUTATION_TYPE               computation_type,
    --c.COMPUTATION_PROCESSED          computation_processed,
    c.COMPUTATION                    computation,
    --
    decode(substr(c.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(c.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     c.SECURITY_SCHEME)              authorization_scheme,
    c.SECURITY_SCHEME                authorization_scheme_id,
    --
    nvl((select case when c.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(c.REQUIRED_PATCH)),
     c.REQUIRED_PATCH)               build_option,
    --
    nvl((select r from apex_standard_conditions where d = c.COMPUTE_WHEN_TYPE),c.COMPUTE_WHEN_TYPE)
                                     condition_type,
    c.COMPUTE_WHEN                   condition_expression1,
    c.COMPUTE_WHEN_TEXT              condition_expression2,
    --
    c.COMPUTATION_ERROR_MESSAGE      error_message,
    c.LAST_UPDATED_BY                last_updated_by,
    c.LAST_UPDATED_ON                last_updated_on,
    c.COMPUTATION_COMMENT            component_comment,
    c.id                             application_computation_id,
    --
    c.COMPUTATION_ITEM
    ||' seq='||lpad(c.COMPUTATION_SEQUENCE,5,'00000')
    ||' p='||c.COMPUTATION_POINT
    ||' t='||c.COMPUTATION_TYPE
    ||' c='||substr(c.COMPUTATION,1,50)||length(c.COMPUTATION)
    ||' s='||decode(substr(c.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(c.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     c.SECURITY_SCHEME)
    ||' c='||c.COMPUTE_WHEN_TYPE
    ||substr(c.COMPUTE_WHEN,1,30)||length(c.COMPUTE_WHEN)
    ||substr(c.COMPUTE_WHEN_TEXT,1,30)||length(c.COMPUTE_WHEN_TEXT)
    ||' m='||substr(c.COMPUTATION_ERROR_MESSAGE,1,30)||length(c.COMPUTATION_ERROR_MESSAGE)
    component_signature
from wwv_flow_computations c,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = c.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_computations                        is 'Identifies Application Computations which can run for every page or on login';
comment on column apex_application_computations.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_computations.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_computations.application_name       is 'Identifies the application';
comment on column apex_application_computations.COMPUTATION_SEQUENCE   is 'Identifies the sequence within the Display Point that this computation will be considered for execution';
comment on column apex_application_computations.COMPUTATION_ITEM       is 'Compute this item value; the purpose of this computation is to set this item''s value.';
comment on column apex_application_computations.COMPUTATION_POINT      is 'Identifies a pre-defined point at which this computation will be performed';
comment on column apex_application_computations.COMPUTATION_TYPE       is 'Identifies the manner in which this computation will be performed';
comment on column apex_application_computations.COMPUTATION            is 'Identifies the computation logic that corresponds to the computation type';
comment on column apex_application_computations.AUTHORIZATION_SCHEME   is 'An authorization scheme must evaluate to TRUE in order for this computation to be executed';
comment on column apex_application_computations.AUTHORIZATION_SCHEME_ID  is 'Foreign Key';
comment on column apex_application_computations.CONDITION_TYPE         is 'Specifies a condition type from the application computation that conditionally controls whether this computation is performed.';
comment on column apex_application_computations.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_computations.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_computations.ERROR_MESSAGE          is 'Identifies the error text that is displayed if this computation raises an error';
comment on column apex_application_computations.COMPONENT_COMMENT      is 'Developer comment';
comment on column apex_application_computations.APPLICATION_COMPUTATION_ID is 'Identifies the primary key of this Application Computation';
comment on column apex_application_computations.last_updated_by        is 'Apex developer who made last update';
comment on column apex_application_computations.last_updated_on        is 'Date of last update';
comment on column apex_application_computations.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_computations to public;

---------------------------------------------------------
-- A P P L I C A T I O N   S H O R T C U T S
--
prompt ...apex_application_shortcuts

create or replace view apex_application_shortcuts
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    s.SHORTCUT_NAME                  shortcut_name,
    --s.SHORTCUT_CONSIDERATION_SEQ     consideration_sequence,
    s.SHORTCUT_TYPE                  shortcut_type,
    nvl((select r from apex_standard_conditions where d = s.SHORTCUT_CONDITION_TYPE1),s.SHORTCUT_CONDITION_TYPE1)
                                     condition_type,
    s.SHORTCUT_CONDITION1            condition_expression1,
    --s.SHORTCUT_CONDITION_TYPE2       ,
    s.SHORTCUT_CONDITION2            condition_expression2,
    s.ERROR_TEXT                     error_text,
    (select case when s.build_option > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(s.BUILD_OPTION))      build_option,
    s.SHORTCUT                       shortcut,
    --
    decode(s.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name n
     from wwv_flow_shortcuts
     where id = s.reference_id)      subscribed_from,
    --
    s.LAST_UPDATED_BY                last_updated_by,
    s.LAST_UPDATED_ON                last_updated_on,
    s.COMMENTS                       component_comments,
    s.id                             shortcut_id,
    --
    s.SHORTCUT_NAME
    ||' '||s.SHORTCUT_TYPE
    ||' cond='||s.SHORTCUT_CONDITION_TYPE1
    ||substr(s.SHORTCUT_CONDITION1,1,30)||length(s.shortcut_condition1)||'.'
    ||substr(s.SHORTCUT_CONDITION2,1,30)||length(s.shortcut_condition2)
    ||' e='||substr(s.ERROR_TEXT,1,30)||length(s.ERROR_TEXT)
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(s.BUILD_OPTION))
    ||' s='||dbms_lob.substr(s.SHORTCUT,50,1)||dbms_lob.getlength(s.SHORTCUT)
    ||' r='||decode(s.REFERENCE_ID,null,'No','Yes')
    component_signature
from wwv_flow_shortcuts s,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas ws,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (ws.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = ws.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      ws.security_group_id = w.PROVISIONING_COMPANY_ID and
      ws.schema = f.owner and
      f.id = s.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_shortcuts                        is 'Identifies Application Shortcuts which can be referenced "MY_SHORTCUT" syntax';
comment on column apex_application_shortcuts.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_shortcuts.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_shortcuts.application_name       is 'Identifies the application';
comment on column apex_application_shortcuts.SHORTCUT_NAME          is 'Identifies the Shortcut Name, which can be referenced using "SHORTCUT_NAME" syntax';
comment on column apex_application_shortcuts.SHORTCUT_TYPE          is 'The shortcut type identifies how the Shortcut text is to be interpreted; for example it could by PL/SQL or HTML.';
comment on column apex_application_shortcuts.CONDITION_TYPE         is 'Identifies the condition type used to conditionally execute the shortcut';
comment on column apex_application_shortcuts.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_shortcuts.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_shortcuts.ERROR_TEXT             is 'Text to be displayed if this shortcut raises an exception';
comment on column apex_application_shortcuts.BUILD_OPTION           is 'Shortcut will be available if the Build Option is enabled';
comment on column apex_application_shortcuts.SHORTCUT               is 'Text and definition of this Shortcut';
comment on column apex_application_shortcuts.IS_SUBSCRIBED          is 'Identifies if this Shortcut is subscribed from another Shortcut';
comment on column apex_application_shortcuts.SUBSCRIBED_FROM        is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_shortcuts.COMPONENT_COMMENTS     is 'Developer comments';
comment on column apex_application_shortcuts.SHORTCUT_ID            is 'Primary Key of this Shortcut';
comment on column apex_application_shortcuts.last_updated_by        is 'Apex developer who made last update';
comment on column apex_application_shortcuts.last_updated_on        is 'Date of last update';
comment on column apex_application_shortcuts.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_shortcuts to public;

---------------------------------------------------------
-- A P P L I C A T I O N   T R E E S
--
prompt ...apex_application_trees

create or replace view apex_application_trees
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.TREE_NAME                      tree_name,
    t.TREE_TYPE                      tree_type,
    t.TREE_QUERY                     tree_query,
    t.FLOW_ITEM                      ,
    t.MAX_LEVELS                     maximum_levels,
    t.UNEXPANDED_PARENT              ,
    t.UNEXPANDED_PARENT_LAST         ,
    t.EXPANDED_PARENT                ,
    t.EXPANDED_PARENT_LAST           ,
    t.LEAF_NODE                      ,
    t.LEAF_NODE_LAST                 ,
    t.DRILL_UP                       ,
    t.NAME_LINK_ANCHOR_TAG           ,
    t.NAME_LINK_NOT_ANCHOR_TAG       ,
    t.INDENT_VERTICAL_LINE           ,
    t.INDENT_VERTICAL_LINE_LAST      ,
    t.BEFORE_TREE                    ,
    t.AFTER_TREE                     ,
    t.LEVEL_1_TEMPLATE               ,
    t.LEVEL_2_TEMPLATE               ,
    t.LEVEL_3_TEMPLATE               ,
    t.LEVEL_4_TEMPLATE               ,
    t.LEVEL_5_TEMPLATE               ,
    t.LEVEL_6_TEMPLATE               ,
    t.LEVEL_7_TEMPLATE               ,
    t.LEVEL_8_TEMPLATE               ,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    --
    t.TREE_COMMENT                   component_comment,
    t.id                             application_tree_id,
    --
    t.TREE_NAME
    ||' t='||t.TREE_TYPE
    ||substr(t.TREE_QUERY,1,50)||length(t.tree_query)
    ||' i='||t.FLOW_ITEM
    ||' l='||t.MAX_LEVELS
    ||'.'||length(t.UNEXPANDED_PARENT        )
    ||'.'||length(t.UNEXPANDED_PARENT_LAST   )
    ||'.'||length(t.EXPANDED_PARENT          )
    ||'.'||length(t.EXPANDED_PARENT_LAST     )
    ||'.'||length(t.LEAF_NODE                )
    ||'.'||length(t.LEAF_NODE_LAST           )
    ||'.'||length(t.DRILL_UP                 )
    ||'.'||length(t.NAME_LINK_ANCHOR_TAG     )
    ||'.'||length(t.NAME_LINK_NOT_ANCHOR_TAG )
    ||'.'||length(t.INDENT_VERTICAL_LINE     )
    ||'.'||length(t.INDENT_VERTICAL_LINE_LAST)
    ||'.'||length(t.BEFORE_TREE              )
    ||'.'||length(t.AFTER_TREE               )
    ||'.'||length(t.LEVEL_1_TEMPLATE         )
    ||'.'||length(t.LEVEL_2_TEMPLATE         )
    ||'.'||length(t.LEVEL_3_TEMPLATE         )
    ||'.'||length(t.LEVEL_4_TEMPLATE         )
    ||'.'||length(t.LEVEL_5_TEMPLATE         )
    ||'.'||length(t.LEVEL_6_TEMPLATE         )
    ||'.'||length(t.LEVEL_7_TEMPLATE         )
    ||'.'||length(t.LEVEL_8_TEMPLATE         )
    component_signature
from wwv_flow_trees t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_trees                            is 'Identifies a tree control which can be referenced and displayed by creating a region with a source of this tree';
comment on column apex_application_trees.workspace                  is 'A work area mapped to one or more database schemas';
comment on column apex_application_trees.application_id             is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_trees.application_name           is 'Identifies the application';
comment on column apex_application_trees.tree_name                  is 'Component name';
comment on column apex_application_trees.tree_type                  is 'Tree component type';
comment on column apex_application_trees.tree_query                 is 'Query which will be used to generate this tree';
comment on column apex_application_trees.flow_item                  is 'Identifies an application or page item which specifies the starting point of the tree';
comment on column apex_application_trees.maximum_levels             is 'This attribute specifies how many levels will appear when a tree first displays';
comment on column apex_application_trees.unexpanded_parent          is 'HTML template for unexpanded parent nodes';
comment on column apex_application_trees.unexpanded_parent_last     is 'HTML template for the last unexpanded parent node';
comment on column apex_application_trees.expanded_parent            is 'HTML template for the expanded parent node';
comment on column apex_application_trees.expanded_parent_last       is 'HTML template for the last expanded parent node';
comment on column apex_application_trees.leaf_node                  is 'Controls the text that is painted before showing the text of the leaf node';
comment on column apex_application_trees.leaf_node_last             is 'Controls the text that is painted before showing the text of the last leaf node.';
comment on column apex_application_trees.drill_up                   is 'Identifies the link text shown when drilling up is possible in the tree';
comment on column apex_application_trees.name_link_anchor_tag       is 'Identifies the manner in which a Name will render if the name has a link';
comment on column apex_application_trees.name_link_not_anchor_tag   is 'Tag for node names which are not links';
comment on column apex_application_trees.indent_vertical_line       is 'Controls vertical line or spacing between peers';
comment on column apex_application_trees.indent_vertical_line_last  is 'Indent Vertical Line Last, controls a blank space';
comment on column apex_application_trees.before_tree                is 'Text before displaying any nodes of the tree';
comment on column apex_application_trees.after_tree                 is 'Text after displaying nodes of the tree';
comment on column apex_application_trees.level_1_template           is 'Parent Node Template';
comment on column apex_application_trees.level_2_template           is 'Node Text Template';
comment on column apex_application_trees.level_3_template           is '';
comment on column apex_application_trees.level_4_template           is '';
comment on column apex_application_trees.level_5_template           is '';
comment on column apex_application_trees.level_6_template           is '';
comment on column apex_application_trees.level_7_template           is '';
comment on column apex_application_trees.level_8_template           is '';
comment on column apex_application_trees.COMPONENT_COMMENT          is 'Developer comment';
comment on column apex_application_trees.APPLICATION_TREE_ID        is 'Primary Key of this Application Tree shared component';
comment on column apex_application_trees.last_updated_by            is 'Apex developer who made last update';
comment on column apex_application_trees.last_updated_on            is 'Date of last update';
comment on column apex_application_trees.component_signature        is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_trees to public;



---------------------------------------------------------
-- A P P L I C A T I O N   N A V I G A T I O N   B A R
--
prompt ...apex_application_nav_bar

create or replace view apex_application_nav_bar
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    n.ICON_SEQUENCE                  display_sequence,
    decode(n.BEGINS_ON_NEW_LINE,
       'YES','Yes',
       'NO','No',
       n.BEGINS_ON_NEW_LINE)         begins_on_new_line,
    n.CELL_COLSPAN                   cell_column_span,
    --
    n.ICON_IMAGE                     ,
    --n.ICON_IMAGE2                    ,
    --n.ICON_IMAGE3                    ,
    n.ICON_SUBTEXT                   ,
    --n.ICON_SUBTEXT2                  ,
    --n.ICON_SUBTEXT3                  ,
    n.ICON_TARGET                    ,
    n.ICON_IMAGE_ALT                 ,
    n.ICON_HEIGHT                    ,
    n.ICON_WIDTH                     ,
    --n.ICON_HEIGHT2                   ,
    --n.ICON_WIDTH2                    ,
    --n.ICON_HEIGHT3                   ,
    --n.ICON_WIDTH3                    ,
    --
    nvl((select r from apex_standard_conditions where d = n.ICON_BAR_DISP_COND_TYPE),n.ICON_BAR_DISP_COND_TYPE)
                                     condition_type,
    n.ICON_BAR_DISP_COND             condition_expression1,
    n.ICON_BAR_FLOW_COND_INSTR       condition_expression2,
    --
    n.ONCLICK                        onclick_javascript,
    --
    (select case when n.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(n.REQUIRED_PATCH))    build_option,
     --
    decode(substr(n.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(n.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     n.SECURITY_SCHEME)              authorization_scheme,
    n.SECURITY_SCHEME                authorization_scheme_id,
    --
    decode(n.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name n
     from wwv_flow_icon_bar
     where id = n.reference_id)      subscribed_from,
    --
    n.LAST_UPDATED_BY                last_updated_by,
    n.LAST_UPDATED_ON                last_updated_on,
    n.ICON_BAR_COMMENT               component_comment,
    n.id                             nav_bar_id,
    n.REFERENCE_ID                   referenced_nav_bar_id,
    --
    lpad(n.ICON_SEQUENCE,5,'00000')
    ||decode(n.BEGINS_ON_NEW_LINE,
       'YES','Yes',
       'NO','No',
       n.BEGINS_ON_NEW_LINE)
    ||n.CELL_COLSPAN
    ||' img='||n.ICON_IMAGE
    ||' '||substr(n.ICON_SUBTEXT,1,30)||length(n.ICON_SUBTEXT)
    ||' t='||substr(n.ICON_TARGET,1,30)||length(n.ICON_TARGET)
    ||' a='||substr(n.ICON_IMAGE_ALT,1,20)||length(n.ICON_IMAGE_ALT)
    ||n.ICON_HEIGHT
    ||n.ICON_WIDTH
    ||' c='||n.ICON_BAR_DISP_COND_TYPE
    ||substr(n.ICON_BAR_DISP_COND,1,30)||length(n.ICON_BAR_DISP_COND)
    ||substr(n.ICON_BAR_FLOW_COND_INSTR,1,30)||length(n.ICON_BAR_FLOW_COND_INSTR)
    ||' ck='||substr(n.ONCLICK,1,20)||length(n.onclick)
    ||' bo='||
    (select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(n.REQUIRED_PATCH))
    ||' a='||decode(substr(n.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(n.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     n.SECURITY_SCHEME)
    ||' s='||decode(n.REFERENCE_ID,
    null,'No','Yes')
    component_signature
from wwv_flow_icon_bar n,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = n.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_nav_bar                        is 'Identifies navigation bar entries displayed on pages that use a Page Template that include a #NAVIGATION_BAR# substitution string';
comment on column apex_application_nav_bar.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_nav_bar.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_nav_bar.application_name       is 'Identifies the application';
comment on column apex_application_nav_bar.DISPLAY_SEQUENCE       is 'Identifies the order in which each Navigation Bar Entry will be displayed';
comment on column apex_application_nav_bar.ICON_IMAGE             is 'Identifies image to be displayed in the Navigation Bar Entry';
comment on column apex_application_nav_bar.ICON_SUBTEXT           is 'Identifies text to be displayed in the Navigation Bar Entry';
comment on column apex_application_nav_bar.ICON_TARGET            is 'Identifies the URL that this Navigation Bar Entry will link to';
comment on column apex_application_nav_bar.ICON_IMAGE_ALT         is 'Identifies the HTML IMG tag ALT value';
comment on column apex_application_nav_bar.ICON_HEIGHT            is 'Identifies the HTML IMG tag HEIGHT value';
comment on column apex_application_nav_bar.ICON_WIDTH             is 'Identifies the HTML IMG tag WIDTH value';
comment on column apex_application_nav_bar.CONDITION_TYPE         is 'Identifies the condition type used to conditionally display the Navigation Bar Entry';
comment on column apex_application_nav_bar.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_nav_bar.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_nav_bar.BEGINS_ON_NEW_LINE     is 'Navigation icons are displayed in table cells, if you set begins-on-new-line to YES then a new table row will be created.';
comment on column apex_application_nav_bar.CELL_COLumn_SPAN       is 'By default each navigation bar entry spans one cell (i.e. the HTML table data colspan=1).  If your HTML requires a different COLSPAN you can set it using this control.';




comment on column apex_application_nav_bar.ONCLICK_javascript     is 'The link generated for this icon include the following onClick javascript.';
comment on column apex_application_nav_bar.BUILD_OPTION           is 'Navigation Bar Entry will be displayed if the Build Option is enabled';
comment on column apex_application_nav_bar.AUTHORIZATION_SCHEME   is 'An authorization scheme must evaluate to TRUE in order for this Navigation Bar Entry to be displayed';
comment on column apex_application_nav_bar.AUTHORIZATION_SCHEME_ID is 'Foreign Key';
comment on column apex_application_nav_bar.IS_SUBSCRIBED          is 'Identifies if this Navigation Bar Entry is subscribed from another Navigation Bar Entry';
comment on column apex_application_nav_bar.SUBSCRIBED_FROM        is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_nav_bar.COMPONENT_COMMENT      is 'Developer comment';
comment on column apex_application_nav_bar.NAV_BAR_ID             is 'Primary Key of this Navigation Bar component';
comment on column apex_application_nav_bar.referenced_nav_bar_id  is 'Primary Key of this Navigation Bar component';
comment on column apex_application_nav_bar.last_updated_by        is 'Apex developer who made last update';
comment on column apex_application_nav_bar.last_updated_on        is 'Date of last update';
comment on column apex_application_nav_bar.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_nav_bar to public;



----------------------------------------------------------
-- A P P L I C A T I O N   L I S T S    O F    V A L U E S
--

prompt ...apex_application_lovs

create or replace view apex_application_lovs
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    l.LOV_NAME                       list_of_values_name,
    --
    decode(substr(l.lov_query,1,1),
    '.','Static','Dynamic')          lov_type,
    decode(substr(l.lov_query,1,1),
    '.',null,l.LOV_QUERY)
                                     list_of_values_query,
    (select count(*)
    from wwv_flow_list_of_values_data
    where flow_id = f.id and
          lov_id = l.id)             lov_entries,
    --
    decode(l.REFERENCE_ID,null,'No','Yes')
                                     is_subscribed,
    (select flow_id||'. '||name n
     from wwv_flow_lists_of_values$
     where id = l.reference_id)      subscribed_from,
    --
    l.LAST_UPDATED_BY                last_updated_by,
    l.LAST_UPDATED_ON                last_updated_on,
    l.LOV_COMMENT                    component_comment,
    --
    l.ID                             lov_id,
    l.REFERENCE_ID                   referenced_lov_id,
    --
    l.LOV_NAME
    ||' t='||decode(substr(l.lov_query,1,1),'.','Static','Dynamic')
    ||' q='||decode(substr(l.lov_query,1,1),'.',null,substr(l.LOV_QUERY,1,30)||length(l.LOV_QUERY))
    ||' ref='||decode(l.REFERENCE_ID,null,'No','Yes')
    component_signature
from wwv_flow_lists_of_values$ l,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = l.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_lovs                      is 'Identifies a shared list of values that can be referenced by a Page Item or Report Column';
comment on column apex_application_lovs.workspace            is 'A work area mapped to one or more database schemas';
comment on column apex_application_lovs.application_id       is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_lovs.application_name     is 'Identifies the application';
comment on column apex_application_lovs.LIST_OF_VALUES_NAME  is 'Identifies the name of the List of Values';
comment on column apex_application_lovs.LIST_OF_VALUES_QUERY is 'SQL SELECT statement used to identify dynamic Lists of Values.  Static Lists of Values are defined in a child List of Values Entries table.';
comment on column apex_application_lovs.LOV_TYPE             is 'List of Values type, Static or Dynamic.';
comment on column apex_application_lovs.LOV_ENTRIES          is 'Count of List of Values static entries';
comment on column apex_application_lovs.IS_SUBSCRIBED        is 'Identifies if this List of Values is subscribed from another List of Values';
comment on column apex_application_lovs.SUBSCRIBED_FROM      is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_lovs.COMPONENT_COMMENT    is 'Developer comment';
comment on column apex_application_lovs.LOV_ID               is 'Primary Key of the Shared List of Values';
comment on column apex_application_lovs.referenced_lov_id    is 'Foreign Key of referenced Shared List of Values';
comment on column apex_application_lovs.last_updated_by      is 'Apex developer who made last update';
comment on column apex_application_lovs.last_updated_on      is 'Date of last update';
comment on column apex_application_lovs.component_signature  is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_lovs to public;


prompt ...apex_application_lov_entires

create or replace view apex_application_lov_entries
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    (select lov_name from wwv_flow_lists_of_values$ where id = l.lov_id) list_of_values_name,
    l.LOV_DISP_SEQUENCE              display_sequence,
    l.LOV_DISP_VALUE                 display_value,
    l.LOV_RETURN_VALUE               return_value,
    --
    l.LOV_TEMPLATE                   lov_entry_template,
    -- conditionality
    nvl((select r from apex_standard_conditions where d = l.LOV_DISP_COND_TYPE),l.LOV_DISP_COND_TYPE)
                                     condition_type,
    l.LOV_DISP_COND                  condition_expression1,
    l.LOV_DISP_COND2                 condition_expression2,
    (select case when l.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(l.REQUIRED_PATCH))    build_option,
    --
    l.LAST_UPDATED_BY                last_updated_by,
    l.LAST_UPDATED_ON                last_updated_on,
    l.LOV_DATA_COMMENT               component_comment,
    --
    l.LOV_ID                         lov_id,
    l.id                             lov_entry_id,
    --
    (select lov_name from wwv_flow_lists_of_values$ where id = l.lov_id)
    ||' seq='||lpad(l.LOV_DISP_SEQUENCE,5,'00000')
    ||' v='||substr(l.LOV_DISP_VALUE,1,30)||length(l.LOV_DISP_VALUE)
    ||' r='||substr(l.LOV_RETURN_VALUE,1,30)||length(l.LOV_RETURN_VALUE)
    ||' t='||l.LOV_TEMPLATE
    ||' cond='||l.LOV_DISP_COND_TYPE
    ||substr(l.LOV_DISP_COND,1,30)||length(l.LOV_DISP_COND)
    ||substr(l.LOV_DISP_COND2,1,30)||length(l.LOV_DISP_COND2)
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(l.REQUIRED_PATCH))
    component_signature
from wwv_flow_list_of_values_data l,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = l.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_lov_entries                       is 'Identifies the List of Values Entries which comprise a shared List of Values';
comment on column apex_application_lov_entries.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_lov_entries.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_lov_entries.application_name      is 'Identifies the application';
comment on column apex_application_lov_entries.LIST_OF_VALUES_NAME   is 'Identifies the name of the List of Values';
comment on column apex_application_lov_entries.DISPLAY_SEQUENCE      is 'List of Values display sequence';
comment on column apex_application_lov_entries.DISPLAY_VALUE         is 'Value displayed to end users';
comment on column apex_application_lov_entries.RETURN_VALUE          is 'Value returned and stored in session state';
comment on column apex_application_lov_entries.LOV_ENTRY_TEMPLATE    is 'Identifies a template used to display a List of Values Entry';
comment on column apex_application_lov_entries.CONDITION_TYPE        is 'Identifies the condition type used to conditionally execute the List of Values Entry';
comment on column apex_application_lov_entries.CONDITION_EXPRESSION1 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_lov_entries.CONDITION_EXPRESSION2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_lov_entries.BUILD_OPTION          is 'List of Values Entry will be displayed if the Build Option is enabled';
comment on column apex_application_lov_entries.COMPONENT_COMMENT     is 'Developer Comment';
comment on column apex_application_lov_entries.LOV_ID                is 'Foreign Key of the List of Values';
comment on column apex_application_lov_entries.LOV_ENTRY_ID          is 'Primary Key of the List of Values Entry';
comment on column apex_application_lov_entries.last_updated_by       is 'Apex developer who made last update';
comment on column apex_application_lov_entries.last_updated_on       is 'Date of last update';
comment on column apex_application_lov_entries.component_signature   is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_lov_entries to public;



----------------------------------------------------------------------
-- A P P L I C A T I O N   A U T H E N T I C A T I O N   S C H E M E S
--

prompt ...apex_application_auth

create or replace view apex_application_auth
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    decode(a.REFERENCE_ID,
      null,'No','Yes')               is_subscribed,
    a.NAME                           authentication_scheme_name,
    a.DESCRIPTION                    ,
    a.PAGE_SENTRY_FUNCTION           page_sentry_function,
    a.SESS_VERIFY_FUNCTION           session_verify_function,
    a.INVALID_SESSION_PAGE           invalid_session_page,
    a.INVALID_SESSION_URL            invalid_session_url,
    --
    a.PRE_AUTH_PROCESS               pre_authentication_process,
    a.AUTH_FUNCTION                  authentication_function,
    a.POST_AUTH_PROCESS              post_authentication_process,
    --
    a.COOKIE_NAME                    cookie_name,
    a.COOKIE_PATH                    cookie_path,
    a.COOKIE_DOMAIN                  cookie_domain,
    decode(a.USE_SECURE_COOKIE_YN,'Y','Yes','N','No','No') cookie_secure,    
    --
    a.LDAP_HOST                      ldap_host,
    a.LDAP_PORT                      ldap_port,
    a.LDAP_STRING                    ldap_dn_string,
    --
    a.ATTRIBUTE_01                   ldap_username_edit_function,
    a.ATTRIBUTE_02                   logout_url,
    a.ATTRIBUTE_03                   help_text,
    --a.ATTRIBUTE_04                   ,
    --a.ATTRIBUTE_05                   ,
    --a.ATTRIBUTE_06                   ,
    --a.ATTRIBUTE_07                   ,
    --a.ATTRIBUTE_08                   ,
    --
    --(select PATCH_NAME
    -- from   wwv_flow_patches
    -- where  id =a.REQUIRED_PATCH)    build_option,
    --
    a.LAST_UPDATED_BY                ,
    a.LAST_UPDATED_ON                ,
    a.id                             authentication_scheme_id,
    a.reference_id                   referenced_schema_id,
    --
    a.NAME
    ||' '||decode(a.REFERENCE_ID,null,'No','Yes')
    ||dbms_lob.substr(a.PAGE_SENTRY_FUNCTION,20,1)||dbms_lob.getlength(a.PAGE_SENTRY_FUNCTION)||'.'
    ||dbms_lob.substr(a.SESS_VERIFY_FUNCTION,20,1)||dbms_lob.getlength(a.SESS_VERIFY_FUNCTION)||'.'
    ||substr(a.INVALID_SESSION_PAGE,1,20)||length(a.INVALID_SESSION_PAGE)||'.'
    ||substr(a.INVALID_SESSION_URL ,1,20)||length(a.INVALID_SESSION_URL )||'.'
    ||dbms_lob.substr(a.PRE_AUTH_PROCESS,20,1)||dbms_lob.getlength(a.PRE_AUTH_PROCESS    )||'.'
    ||dbms_lob.substr(a.AUTH_FUNCTION   ,20,1)||dbms_lob.getlength(a.AUTH_FUNCTION       )||'.'
    ||dbms_lob.substr(a.POST_AUTH_PROCESS,20,1)||dbms_lob.getlength(a.POST_AUTH_PROCESS   )||'.'
    ||substr(a.COOKIE_NAME         ,1,20)||length(a.COOKIE_NAME         )||'.'
    ||substr(a.COOKIE_PATH         ,1,20)||length(a.COOKIE_PATH         )||'.'
    ||substr(a.COOKIE_DOMAIN       ,1,20)||length(a.COOKIE_DOMAIN       )||'.'
    ||substr(a.USE_SECURE_COOKIE_YN,1,1)||length(a.USE_SECURE_COOKIE_YN)||'.'        
    ||substr(a.LDAP_HOST           ,1,20)||length(a.LDAP_HOST           )||'.'
    ||substr(a.LDAP_PORT           ,1,20)||length(a.LDAP_PORT           )||'.'
    ||substr(a.LDAP_STRING         ,1,20)||length(a.LDAP_STRING         )||'.'
    ||substr(a.ATTRIBUTE_01        ,1,20)||length(a.ATTRIBUTE_01        )||'.'
    ||substr(a.ATTRIBUTE_02        ,1,20)||length(a.ATTRIBUTE_02        )||'.'
    ||substr(a.ATTRIBUTE_03        ,1,20)||length(a.ATTRIBUTE_03        )
    component_signature
from wwv_flow_custom_auth_setups a,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = a.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_auth                             is 'Identifies the available Authentication Schemes defined for an Application';
comment on column apex_application_auth.workspace                   is 'A work area mapped to one or more database schemas';
comment on column apex_application_auth.application_id              is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_auth.application_name            is 'Identifies the application';
comment on column apex_application_auth.is_subscribed               is 'Identifies if this Authentication Scheme is subscribed from another Authentication Scheme.';
comment on column apex_application_auth.authentication_scheme_name  is 'Identifies this Authentication Scheme';
comment on column apex_application_auth.DESCRIPTION                 is 'Text discription of this Authentication Scheme';
comment on column apex_application_auth.page_sentry_function        is 'This function is executed by the Application Express engine before each page is shown or processed. If this function returns false (indicating perhaps that the user isn''t logged in), the engine redirects to a login page';
comment on column apex_application_auth.session_verify_function     is 'This function determines whether or not a valid session exists.';
comment on column apex_application_auth.invalid_session_page        is 'Specifies the page in this application that the engine should redirect to if the page sentry function returns false. This would normally be a login page.';
comment on column apex_application_auth.invalid_session_url         is 'Specifies a URL Application Express should redirect to if the authentication function returns false. This would normally be a URL to a login page or single signon portal. You can''t enter both a page and a URL for the invalid session redirect target.';
comment on column apex_application_auth.pre_authentication_process  is 'Code that will be executed after the login page is submitted and just before credentials verification is performed.';
comment on column apex_application_auth.authentication_function     is 'Specify the function that will verify the user''s login credentials. This function must return boolean to the login procedure that calls it. ';
comment on column apex_application_auth.post_authentication_process is 'Specifies a block of code to be executed by the Application Express login procedure (login API) after the authentication step (login credentials verification).';
comment on column apex_application_auth.cookie_name                 is 'Name for the session cookie to be set by the post-login procedure and checked by the Verify Session function.';
comment on column apex_application_auth.cookie_path                 is 'Path attribute for the session cookie to be set by the post-login procedure and checked by the Verify Session function.';
comment on column apex_application_auth.cookie_domain               is 'Domain attribute for the session cookie to be set by the post-login procedure and checked by the Verify Session function. Defaults to null.';
comment on column apex_application_auth.cookie_secure               is 'Specifies whether to set the secure attribute of the session management cookie when sending cookie to browser. Secure cookies can be used only with HTTPS. Defaults to No.';	
comment on column apex_application_auth.ldap_host                   is 'The hostname of your LDAP directory server.';
comment on column apex_application_auth.ldap_port                   is 'The port number of your LDAP directory host.';
comment on column apex_application_auth.ldap_dn_string              is 'The pattern used to construct the Domain Name (DN) argument to DBMS_LDAP.SIMPLE_BIND_S.';
comment on column apex_application_auth.ldap_username_edit_function is 'A function that can refine the username captured in the login form into a format suitable for the LDAP call.';
comment on column apex_application_auth.logout_url                  is 'Specify a URL to become the LOGOUT_URL substitution string.';
comment on column apex_application_auth.help_text                   is 'Text to be displayed in login help popup window off login page. This should offer guidance and links to resources to assist users of the Application Express built-in login page, specific to the type of authentication your application is using (Open Door, Application Express account, or LDAP).';
comment on column apex_application_auth.last_updated_by             is 'Apex user name who last modified this component';
comment on column apex_application_auth.last_updated_on             is 'Date of last modification';
comment on column apex_application_auth.authentication_scheme_id    is 'Primary Key of this component';
comment on column apex_application_auth.referenced_schema_id        is 'Foreign Key to referenced Authentication Scheme';
comment on column apex_application_auth.last_updated_by             is 'Apex developer who made last update';
comment on column apex_application_auth.last_updated_on             is 'Date of last update';
comment on column apex_application_auth.component_signature         is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on apex_application_auth to public;

----------------------------------------------------------------------
-- A P P L I C A T I O N   A U T H O R I Z A T I O N   S C H E M E S
-- 4008

prompt ...apex_application_authorization

create or replace view apex_application_authorization
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    a.NAME                           authorization_scheme_name,
    a.SCHEME_TYPE                    scheme_type,
    a.SCHEME                         scheme,
    a.SCHEME_TEXT                    scheme_text,
    a.ERROR_MESSAGE                  error_message,
    --
    decode(a.CACHING,
      'BY_USER_BY_PAGE_VIEW','Once per page view',
      'BY_USER_BY_SESSION','Once per session',
      a.CACHING)                     caching,
    decode(a.REFERENCE_ID,null,'No','Yes') is_subscribed,
    a.LAST_UPDATED_BY                last_updated_by,
    a.LAST_UPDATED_ON                last_updated_on,
    a.COMMENTS                       component_comment,
    --
    a.id                             authorization_scheme_id,
    a.REFERENCE_ID                   referenced_scheme_id,
    --
    substr(a.NAME,1,30)||length(a.NAME         )
    ||' t='||substr(a.SCHEME_TYPE  ,1,30)||length(a.SCHEME_TYPE  )
    ||' s='||substr(a.SCHEME       ,1,30)||length(a.SCHEME       )
    ||' t='||substr(a.SCHEME_TEXT  ,1,30)||length(a.SCHEME_TEXT  )
    ||' e='||substr(a.ERROR_MESSAGE,1,30)||length(a.ERROR_MESSAGE)
    ||' s='||decode(a.CACHING,'BY_USER_BY_PAGE_VIEW','Once per page view','BY_USER_BY_SESSION','Once per session',substr(a.CACHING,1,20))
    ||' r='||decode(a.REFERENCE_ID,null,'No','Yes')
    component_signature
from WWV_FLOW_SECURITY_SCHEMES a,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = a.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_authorization                           is 'Identifies Authorization Schemes which can be applied at the application, page or component level';
comment on column apex_application_authorization.workspace                 is 'A work area mapped to one or more database schemas';
comment on column apex_application_authorization.application_id            is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_authorization.application_name          is 'Identifies the application';
comment on column apex_application_authorization.AUTHORIZATION_SCHEME_NAME is 'Name of the Authorization Scheme';
comment on column apex_application_authorization.SCHEME_TYPE               is 'Type of Authorization Scheme which defines how the Authorization Scheme Source will be interpreted';
comment on column apex_application_authorization.SCHEME                    is 'Identifies the Authorization Scheme.  Session state my be referenced using bind variables for Schemes of type SQL or PL/SQL.';
comment on column apex_application_authorization.SCHEME_TEXT               is 'Further Identifies an Authorization Scheme, used only for specific Authorization Scheme Types';
comment on column apex_application_authorization.ERROR_MESSAGE             is 'Identifies the Error Message end users will see when this Authentication Scheme fails';
comment on column apex_application_authorization.CACHING                   is 'Identifies the level of Caching used for this Authentication Scheme; typically by Session or Page View.';
comment on column apex_application_authorization.IS_SUBSCRIBED             is 'Identifies if this Authorization Scheme is subscribed from another Authorization Scheme.';
comment on column apex_application_authorization.LAST_UPDATED_BY           is 'Apex Developer User Name who last updated this component';
comment on column apex_application_authorization.LAST_UPDATED_ON           is 'Date this component was last updated';
comment on column apex_application_authorization.COMPONENT_COMMENT         is 'Developer comment';
comment on column apex_application_authorization.AUTHORIZATION_SCHEME_ID   is 'Primary Key of this Authorization Scheme';
comment on column apex_application_authorization.referenced_scheme_id      is 'Foreign Key of referenced Authorization Scheme';
comment on column apex_application_authorization.last_updated_by           is 'Apex developer who made last update';
comment on column apex_application_authorization.last_updated_on           is 'Date of last update';
comment on column apex_application_authorization.component_signature         is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_authorization to public;

----------------------------------------------------------
-- A P P L I C A T I O N   W E B  S E R V I C E S
--

prompt ...apex_application_web_services

create or replace view apex_application_web_services
as
select
    ws.short_name                          workspace,
    f.ID                                   application_id,
    f.NAME                                 application_name,
    --
    w.NAME                                 web_service_name,
    w.URL                                  ,
    w.ACTION                               ,
    w.PROXY_OVERRIDE                       ,
    w.SOAP_ENVELOPE                        ,
    w.FLOW_ITEMS_COMMA_DELIMITED           ,
    w.STATIC_PARM_01                       ,
    w.STATIC_PARM_02                       ,
    w.STATIC_PARM_03                       ,
    w.STATIC_PARM_04                       ,
    w.STATIC_PARM_05                       ,
    w.STATIC_PARM_06                       ,
    w.STATIC_PARM_07                       ,
    w.STATIC_PARM_08                       ,
    w.STATIC_PARM_09                       ,
    w.STATIC_PARM_10                       ,
    w.STYLESHEET                           ,
    --
    decode(w.REFERENCE_ID,
        null,'No','Yes')                   is_subscribed,
    (select flow_id||'. '||name n
     from wwv_flow_shared_web_services
     where id = w.id)                      subscribed_from,
    --
    w.LAST_UPDATED_BY                      last_updated_by,
    w.LAST_UPDATED_ON                      last_updated_on,
    --
    w.id                                   web_service_id
from wwv_flow_shared_web_services w,
     wwv_flows f,
     wwv_flow_companies ws,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = ws.PROVISIONING_COMPANY_ID and
      s.security_group_id = ws.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = w.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      ws.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or ws.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_web_services                             is 'Web Services referenceable from this Application';
comment on column apex_application_web_services.workspace                   is 'A work area mapped to one or more database schemas';
comment on column apex_application_web_services.application_id              is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_web_services.application_name            is 'Identifies the application';
comment on column apex_application_web_services.WEB_SERVICE_NAME            is 'Identifies the name of the Web Service';
comment on column apex_application_web_services.URL                         is 'Specifies the URL used to post the SOAP request over HTTP';
comment on column apex_application_web_services.ACTION                      is 'Indicates the intent of the SOAP HTTP request';
comment on column apex_application_web_services.PROXY_OVERRIDE              is 'Overrides the system defined HTTP proxy for request';
comment on column apex_application_web_services.SOAP_ENVELOPE               is 'Specifies the SOAP envelope to be used for the SOAP request to the Web service';
comment on column apex_application_web_services.FLOW_ITEMS_COMMA_DELIMITED  is 'Comma delimited list of application items';
comment on column apex_application_web_services.STATIC_PARM_01              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_02              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_03              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_04              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_05              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_06              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_07              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_08              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_09              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_10              is 'Identifies static parameters';
comment on column apex_application_web_services.STYLESHEET                  is 'Stylesheet will be used to apply an XML transformation against the result of the SOAP Request';
comment on column apex_application_web_services.IS_SUBSCRIBED               is 'Identifies if this Web Service is subscribed from another Web Service';
comment on column apex_application_web_services.SUBSCRIBED_FROM             is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_web_services.web_service_id              is 'Identifies the primary key of the Web Service';
comment on column apex_application_web_services.last_updated_by             is 'Apex developer who made last update';
comment on column apex_application_web_services.last_updated_on             is 'Date of last update';
grant select on   apex_application_web_services to public;


---------------------------------------------------------
-- A P P L I C A T I O N    B R E A D C R U M B S
--

prompt ...apex_application_breadcrumbs

create or replace view apex_application_breadcrumbs
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    m.NAME                           breadcrumb_name,
    --
    (select count(*) from wwv_flow_menu_options where menu_id = m.id) breadcrumb_entries,
    --
    m.LAST_UPDATED_BY                last_updated_by,
    m.LAST_UPDATED_ON                last_updated_on,
    m.MENU_COMMENT                   component_comment,
    m.id                             breadcrumb_id,
    --
    m.NAME
    component_signature
from wwv_flow_menus m,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = m.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_breadcrumbs                    is 'Identifies the definition of a collection of Breadcrumb Entries which are used to identify a page Hierarchy';
comment on column apex_application_breadcrumbs.workspace          is 'A work area mapped to one or more database schemas';
comment on column apex_application_breadcrumbs.application_id     is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_breadcrumbs.application_name   is 'Identifies the application';
comment on column apex_application_breadcrumbs.BREADCRUMB_name    is 'Identifies the Breadcrumb Name, a breadcrumb is a collection of Breadcrumb Entries used to show page context.';
comment on column apex_application_breadcrumbs.BREADCRUMB_ENTRIES is 'Count of Entries defined for this Breadcrumb';
comment on column apex_application_breadcrumbs.COMPONENT_COMMENT  is 'Developer Comment';
comment on column apex_application_breadcrumbs.BREADCRUMB_ID      is 'Primary key of this Breadcrumb';
comment on column apex_application_breadcrumbs.last_updated_by    is 'Apex developer who made last update';
comment on column apex_application_breadcrumbs.last_updated_on    is 'Date of last update';
comment on column apex_application_breadcrumbs.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_breadcrumbs to public;


prompt ...apex_application_bc_entries

create or replace view apex_application_bc_entries
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    m.PARENT_ID                      parent_breadcrumb_id,
    m.MENU_ID                        breadcrumb_id,
    --m.OPTION_SEQUENCE                display_sequence,
    m.SHORT_NAME                     entry_label,
    m.LONG_NAME                      entry_long_label,
    m.LINK                           url,
    m.PAGE_ID                        defined_for_page,
    m.ALSO_CURRENT_FOR_PAGES         current_for_pages,
    --
    nvl((select r from apex_standard_conditions where d = m.DISPLAY_WHEN_COND_TYPE),m.DISPLAY_WHEN_COND_TYPE)
                                     condition_type,
    m.DISPLAY_WHEN_CONDITION         condition_expression1,
    m.DISPLAY_WHEN_CONDITION2        condition_expression2,
    --
    decode(substr(m.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(m.SECURITY_SCHEME,'!')
     and     flow_id = f.id),
     m.SECURITY_SCHEME)              authorization_scheme,
    m.SECURITY_SCHEME                authorization_scheme_id,
     --
    (select case when m.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(m.REQUIRED_PATCH) )   build_option,
    m.LAST_UPDATED_BY                last_updated_by,
    m.LAST_UPDATED_ON                last_updated_on,
    m.MENU_OPTION_COMMENT            component_comment,
    m.id                             breadcrumb_entry_id,
    --
    substr(m.SHORT_NAME,1,30)||length(m.SHORT_NAME)
    ||substr(m.LONG_NAME,1,30)||length(m.LONG_NAME)
    ||' l='||substr(m.LINK,1,30)||length(m.LINK)
    ||' p='||PAGE_ID
    ||' c='||substr(m.ALSO_CURRENT_FOR_PAGES,1,30)||length(m.ALSO_CURRENT_FOR_PAGES)
    ||' cond='||m.DISPLAY_WHEN_COND_TYPE
    ||substr(m.DISPLAY_WHEN_CONDITION,1,30)||length(m.DISPLAY_WHEN_CONDITION)
    ||substr(m.DISPLAY_WHEN_CONDITION2,1,30)||length(m.DISPLAY_WHEN_CONDITION2)
    ||' sec='||decode(substr(m.SECURITY_SCHEME,1,1),'!','Not ')||
      nvl((select name from wwv_flow_security_schemes where   to_char(id)= ltrim(m.SECURITY_SCHEME,'!') and flow_id = f.id), m.SECURITY_SCHEME)
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(m.REQUIRED_PATCH) )
    component_signature
from wwv_flow_menu_options m,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = m.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_bc_entries                       is 'Identifies Breadcrumb Entries which map to a Page and identify a pages parent';
comment on column apex_application_bc_entries.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_bc_entries.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_bc_entries.application_name      is 'Identifies the application';
comment on column apex_application_bc_entries.PARENT_BREADCRUMB_ID  is 'Identifies the Parent Breadcrumb ID.';
comment on column apex_application_bc_entries.BREADCRUMB_ID         is 'Identifies the Primary Key of this Breadcrumb Entry';
comment on column apex_application_bc_entries.ENTRY_LABEL           is 'Identifies the label which will be displayed for this Breadcrumb Entry';
comment on column apex_application_bc_entries.ENTRY_LONG_LABEL      is 'Identifies an optional longer version of the Breadcrumb Entry';
comment on column apex_application_bc_entries.URL                   is 'The URL corresponding to a breadcrumb entry.  When a user clicks the breadcrumb they will navigate to this URL.';
comment on column apex_application_bc_entries.DEFINED_FOR_PAGE      is 'Identifies the pages for which this Breadcrumb Entry is defined';
comment on column apex_application_bc_entries.CURRENT_FOR_PAGES     is 'Identifies a page or pages for which this breadcrumb is current.  Current and non current breadcrumbs have different templates and may be rendered differently.';
comment on column apex_application_bc_entries.CONDITION_TYPE        is 'For breadcrumbs that are displayed conditionally identifies the condition type';
comment on column apex_application_bc_entries.CONDITION_EXPRESSION1 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_bc_entries.CONDITION_EXPRESSION2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_bc_entries.AUTHORIZATION_SCHEME  is 'An authorization scheme must evaluate to TRUE in order for this page to be displayed';
comment on column apex_application_bc_entries.AUTHORIZATION_SCHEME_ID is 'Foreign Key';
comment on column apex_application_bc_entries.BUILD_OPTION          is 'Breadcrumb Entry will be displayed if the Build Option is enabled';
comment on column apex_application_bc_entries.COMPONENT_COMMENT     is 'Developer comment';
comment on column apex_application_bc_entries.BREADCRUMB_ENTRY_ID   is 'Foreign key identifying the Breadcrumb definition';
comment on column apex_application_bc_entries.last_updated_by       is 'Apex developer who made last update';
comment on column apex_application_bc_entries.last_updated_on       is 'Date of last update';
comment on column apex_application_bc_entries.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_bc_entries to public;


---------------------------------------------------------
-- A P P L I C A T I O N   L I S T S
--

prompt ...apex_application_lists

create or replace view apex_application_lists
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    l.NAME                           list_name,
    --l.LIST_STATUS                    list_status,
    --l.LIST_DISPLAYED,
    (select list_template_name from wwv_flow_list_templates where id = l.DISPLAY_ROW_TEMPLATE_ID)  template,
    (select case when l.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(l.REQUIRED_PATCH))    build_option,
    (select count(*) from wwv_flow_list_items where list_id = l.id) list_entries,
    --
    l.LAST_UPDATED_BY                last_updated_by,
    l.LAST_UPDATED_ON                last_updated_on,
    l.LIST_COMMENT                   component_comment,
    l.ID                             list_id,
    --
    l.NAME
    ||' s='||l.LIST_STATUS
    ||' t='||(select list_template_name from wwv_flow_list_templates where id = l.DISPLAY_ROW_TEMPLATE_ID)
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(l.REQUIRED_PATCH))
    component_signature
from wwv_flow_lists l,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = l.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_lists                   is 'Identifies a named collection of Application List Entries which can be included on any page using a region of type List.  Display attributes are controlled using a List Template.';
comment on column apex_application_lists.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_lists.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_lists.application_name  is 'Identifies the application';
comment on column apex_application_lists.LIST_NAME         is 'Identifies the name of the Application List';
comment on column apex_application_lists.TEMPLATE          is 'Identifies the List Template to use by default when rendering this List within a Region.  Regions may override this default template.';
comment on column apex_application_lists.BUILD_OPTION      is 'List will be displayed if the Build Option is enabled';
comment on column apex_application_lists.COMPONENT_COMMENT is 'Developer Comment';
comment on column apex_application_lists.LIST_ID           is 'Identifies the primary key of this component';
comment on column apex_application_lists.last_updated_by   is 'Apex developer who made last update';
comment on column apex_application_lists.last_updated_on   is 'Date of last update';
comment on column apex_application_lists.list_entries      is 'Number of list entries defined for list';
comment on column apex_application_lists.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on apex_application_lists to public;


create or replace view apex_application_list_entries
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    l.NAME                           list_name,
    --
    --e.SUB_ITEM_COUNT                 ,
    --e.PARENT_LIST_ITEM_ID            ,
    (select list_item_link_text
     from   wwv_flow_list_items
     where  id = e.PARENT_LIST_ITEM_ID and
            flow_id = e.flow_id)     parent_entry_text,
    --e.LIST_ITEM_TYPE                 ,
    --e.LIST_ITEM_STATUS               ,
    --e.ITEM_DISPLAYED                 ,
    e.LIST_ITEM_DISPLAY_SEQUENCE     display_sequence,
    e.LIST_ITEM_LINK_TEXT            entry_text,
    e.LIST_ITEM_LINK_TARGET          entry_target,
    --
    e.LIST_ITEM_ICON                 entry_image,
    e.LIST_ITEM_ICON_ATTRIBUTES      entry_image_attributes,
    --e.LIST_ITEM_ICON_EXP             ,
    --e.LIST_ITEM_ICON_EXP_ATTR        ,
    --e.LIST_ITEM_OWNER                ,
    --
    decode(e.LIST_ITEM_CURRENT_TYPE,
      'ALWAYS',                      'Always',
      'COLON_DELIMITED_PAGE_LIST',   'Colon Delimited Page List',
      'EXISTS',                      'Exists SQL Query',
      'NEVER',                       'Never',
      'NOT_EXISTS',                  'Not Exists SQL Query',
      'PLSQL_EXPRESSION',            'PL/SQL Expression',
      e.LIST_ITEM_CURRENT_TYPE)      current_for_pages_type,
    e.LIST_ITEM_CURRENT_FOR_PAGES    current_for_pages_expression,
    --
    nvl((select r from apex_standard_conditions where d = e.LIST_ITEM_DISP_COND_TYPE),e.LIST_ITEM_DISP_COND_TYPE)
                                     condition_type,
    e.LIST_ITEM_DISP_CONDITION       condition_expression1,
    --e.LIST_ITEM_DISP_COND_TYPE2      ,
    e.LIST_ITEM_DISP_CONDITION2      condition_expression2,
    --
    decode(e.LIST_COUNTCLICKS_Y_N,
      'Y','Yes','N','No',
      e.LIST_COUNTCLICKS_Y_N)        count_clicks,
    e.LIST_COUNTCLICKS_CAT           click_count_category,
    --
    e.LIST_TEXT_01                   entry_attribute_01,
    e.LIST_TEXT_02                   entry_attribute_02,
    e.LIST_TEXT_03                   entry_attribute_03,
    e.LIST_TEXT_04                   entry_attribute_04,
    e.LIST_TEXT_05                   entry_attribute_05,
    e.LIST_TEXT_06                   entry_attribute_06,
    e.LIST_TEXT_07                   entry_attribute_07,
    e.LIST_TEXT_08                   entry_attribute_08,
    e.LIST_TEXT_09                   entry_attribute_09,
    e.LIST_TEXT_10                   entry_attribute_10,
    --e.LIST_TEXT_11                   entry_attribute_11,
    --e.LIST_TEXT_12                   entry_attribute_12,
    --e.LIST_TEXT_13                   entry_attribute_13,
    --e.LIST_TEXT_14                   entry_attribute_14,
    --e.LIST_TEXT_15                   entry_attribute_15,
    --e.LIST_TEXT_16                   entry_attribute_16,
    --e.LIST_TEXT_17                   entry_attribute_17,
    --e.LIST_TEXT_18                   entry_attribute_18,
    --e.LIST_TEXT_19                   entry_attribute_19,
    --e.LIST_TEXT_20                   entry_attribute_20,
    --
    (select case when e.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(e.REQUIRED_PATCH))    build_option,
    --
    decode(substr(e.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(e.SECURITY_SCHEME,'!')
     and    flow_id = f.id),
     e.SECURITY_SCHEME)              authorization_scheme,
    e.SECURITY_SCHEME                authorization_scheme_id,
    --
    e.LAST_UPDATED_BY                last_updated_by,
    e.LAST_UPDATED_ON                last_updated_on,
    e.LIST_ITEM_COMMENT              component_comment,
    e.list_id                        list_id,
    e.PARENT_LIST_ITEM_ID            list_entry_parent_id,
    e.id                             list_entry_id,
    --
    l.NAME
    ||' p='||(select list_item_link_text from wwv_flow_list_items where  id = e.PARENT_LIST_ITEM_ID and flow_id = e.flow_id)
    ||' '||lpad(e.LIST_ITEM_DISPLAY_SEQUENCE,5,'00000')
    ||' '||substr(e.LIST_ITEM_LINK_TEXT      ,1,30)
    ||' '||substr(e.LIST_ITEM_LINK_TARGET    ,1,30)||length(e.LIST_ITEM_LINK_TARGET)
    ||' '||substr(e.LIST_ITEM_ICON           ,1,30)
    ||' '||substr(e.LIST_ITEM_ICON_ATTRIBUTES,1,30)||length(e.LIST_ITEM_ICON_ATTRIBUTES)
    ||' '||decode(e.LIST_ITEM_CURRENT_TYPE,
      'ALWAYS',                      'Always',
      'COLON_DELIMITED_PAGE_LIST',   'Colon Delimited Page List',
      'EXISTS',                      'Exists SQL Query',
      'NEVER',                       'Never',
      'NOT_EXISTS',                  'Not Exists SQL Query',
      'PLSQL_EXPRESSION',            'PL/SQL Expression',
      e.LIST_ITEM_CURRENT_TYPE)
    ||' '||substr(e.LIST_ITEM_CURRENT_FOR_PAGES,1,30)||length(e.LIST_ITEM_CURRENT_FOR_PAGES)
    ||' c='||e.LIST_ITEM_DISP_COND_TYPE
    ||substr(e.LIST_ITEM_DISP_CONDITION,1,30)||length(e.LIST_ITEM_DISP_CONDITION)
    ||substr(e.LIST_ITEM_DISP_CONDITION2,1,30)||length(e.LIST_ITEM_DISP_CONDITION2)
    ||' c='||decode(e.LIST_COUNTCLICKS_Y_N,
      'Y','Yes','N','No',
      e.LIST_COUNTCLICKS_Y_N)
    ||' c='||e.LIST_COUNTCLICKS_CAT
    ||' t='
    ||length(e.LIST_TEXT_01)
    ||length(e.LIST_TEXT_02)
    ||length(e.LIST_TEXT_03)
    ||length(e.LIST_TEXT_04)
    ||length(e.LIST_TEXT_05)
    ||length(e.LIST_TEXT_06)
    ||length(e.LIST_TEXT_07)
    ||length(e.LIST_TEXT_08)
    ||length(e.LIST_TEXT_09)
    ||length(e.LIST_TEXT_10)
    ||' b='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(e.REQUIRED_PATCH))
    ||' s='||decode(substr(e.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(e.SECURITY_SCHEME,'!')
     and    flow_id = f.id),
     e.SECURITY_SCHEME)
    component_signature
from wwv_flow_list_items e,
     wwv_flow_lists l,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = l.flow_id and
      l.id = e.list_Id and
      f.id = e.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_list_entries                   is 'Identifies the List Entries which define a List.  List Entries can be hierarchical or flat.';
comment on column apex_application_list_entries.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_list_entries.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_list_entries.application_name  is 'Identifies the application';
comment on column apex_application_list_entries.LIST_NAME                    is 'Name of the Application List this List Entry is part of';
comment on column apex_application_list_entries.PARENT_entry_TEXT             is 'Identifies the Parent of this List Entry';
comment on column apex_application_list_entries.DISPLAY_SEQUENCE             is 'Identifies the display sequence';
comment on column apex_application_list_entries.entry_TEXT                    is 'Identifies the Link Text which will be displayed to the end user of the application';
comment on column apex_application_list_entries.entry_TARGET                  is 'Identifies the URL target of this List Entry';
comment on column apex_application_list_entries.entry_IMAGE                   is 'Identifies an optional image associated with this List Entry';
comment on column apex_application_list_entries.entry_IMAGE_ATTRIBUTES        is 'Identifies image attributes that will be rendered within the HTML IMG tag for list entries that include Link Images';
comment on column apex_application_list_entries.CURRENT_FOR_PAGES_TYPE       is 'Identifies a Condition Type used to determine if this List Entry is current; reference Current For Pages Expression attribute';
comment on column apex_application_list_entries.CURRENT_FOR_PAGES_EXPRESSION is 'Identifies a page or pages (or other condition) used to determine if this List Entry is to be rendered as a Current List Entry';
comment on column apex_application_list_entries.CONDITION_TYPE               is 'For conditionally displayed list entries; identifies the condition type.  The condition is specified in the Expression 1 and Expression 2 attributes.';
comment on column apex_application_list_entries.CONDITION_EXPRESSION1        is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_list_entries.CONDITION_EXPRESSION2        is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_list_entries.COUNT_CLICKS                 is 'Determines if the Apex click counter log should record a click entry when this list entry is clicked';
comment on column apex_application_list_entries.CLICK_COUNT_CATEGORY         is 'Determines the Apex click counter category used to provide greater context to the click count log';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_01           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_02           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_03           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_04           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_05           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_06           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_07           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_08           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_09           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_10           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.BUILD_OPTION                 is 'List Entry will be displayed if the Build Option is enabled';
comment on column apex_application_list_entries.AUTHORIZATION_SCHEME         is 'An authorization scheme must evaluate to TRUE in order for this page to be displayed';
comment on column apex_application_list_entries.AUTHORIZATION_SCHEME_ID      is 'Foreign Key';
comment on column apex_application_list_entries.LAST_UPDATED_BY              is 'Apex User who last updated this component';
comment on column apex_application_list_entries.LAST_UPDATED_ON              is 'Date on which this component was last updated last';
comment on column apex_application_list_entries.COMPONENT_COMMENT            is 'Developer Comment';
comment on column apex_application_list_entries.last_updated_by              is 'Apex developer who made last update';
comment on column apex_application_list_entries.last_updated_on              is 'Date of last update';
comment on column apex_application_list_entries.list_id                      is 'Foreign key of the List';
comment on column apex_application_list_entries.list_entry_parent_id         is 'Foreign key of the Parent List Entry';
comment on column apex_application_list_entries.list_entry_id                is 'Primary Key of this List Entry';
comment on column apex_application_list_entries.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on apex_application_list_entries to public;

---------------------------------------------------------
-- A P P L I C A T I O N   T H E M E S
--
prompt ...apex_application_themes

create or replace view apex_application_themes
as
select
    w.short_name                                                                                             workspace,
    f.ID                                                                                                     application_id,
    f.NAME                                                                                                   application_name,
    --
    t.theme_id                                                                                               theme_number,
    t.theme_name                                                                                             theme_name,
    (select name from wwv_flow_templates where id = t.default_page_template)                                 default_page_template,
    --t.error_template                   ,
    --t.printer_friendly_template        ,
    --t.breadcrumb_display_point         ,
    --t.sidebar_display_point,
    --t.login_template                   ,
    (select template_name from wwv_flow_button_templates where id = t.default_button_template )              default_button_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_region_template)  default_region_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_chart_template)   default_chart_rg_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_form_template)    default_form_rg_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_reportr_template) default_report_region_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_tabform_template) default_tabular_form_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_wizard_template)  default_wizard_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_menur_template)   default_breadcrumb_rg_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_listr_template)   default_list_region_template,
    (select row_template_name from wwv_flow_row_templates where id = t.default_report_template)              default_report_row_template,
    (select template_Name from wwv_flow_field_templates where id = t.default_label_template)                 default_item_label_template,
    (select name from wwv_flow_menu_templates where id = t.default_menu_template)                            default_breadcrumb_template,
    (select name from wwv_flow_cal_templates where id = t.default_calendar_template)                         default_calendar_template,
    (select list_template_name from wwv_flow_list_templates where id = t.default_list_template)              default_list_template,
    (select template_Name from wwv_flow_field_templates where id = t.default_option_label)                   default_option_label,
    (select template_Name from wwv_flow_field_templates where id = t.default_required_label)                 default_required_label,
    t.last_updated_on                                                                                        last_updated_on,
    t.last_updated_by                                                                                        last_updated_by,
    t.calendar_icon                                                                                          calendar_icon_image_name,
    t.calendar_icon_attr                                                                                     calendar_icon_attributes,
    t.id                                                                                                     theme_id,
    t.theme_description                                                                                      theme_description,
    --
    t.theme_id
    ||' n='||substr(t.theme_name                                                                                             ,1,30)
    ||' p='||substr((select name from wwv_flow_templates where id = t.default_page_template)                                 ,1,30)
    ||' e='||substr((select name from wwv_flow_templates where id = t.error_template),1,30)
    ||' b='||substr((select template_name from wwv_flow_button_templates where id = t.default_button_template )              ,1,30)
    ||' r='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_region_template)  ,1,30)
    ||' c='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_chart_template)   ,1,30)
    ||' f='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_form_template)    ,1,30)
    ||' r='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_reportr_template) ,1,30)
    ||' t='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_tabform_template) ,1,30)
    ||' w='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_wizard_template)  ,1,30)
    ||' b='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_menur_template)   ,1,30)
    ||' l='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_listr_template)   ,1,30)
    ||' r='||substr((select row_template_name from wwv_flow_row_templates where id = t.default_report_template)              ,1,30)
    ||' i='||substr((select template_Name from wwv_flow_field_templates where id = t.default_label_template)                 ,1,30)
    ||' b='||substr((select name from wwv_flow_menu_templates where id = t.default_menu_template)                            ,1,30)
    ||' c='||substr((select name from wwv_flow_cal_templates where id = t.default_calendar_template)                         ,1,30)
    ||' l='||substr((select list_template_name from wwv_flow_list_templates where id = t.default_list_template)              ,1,30)
    ||' l='||substr((select template_Name from wwv_flow_field_templates where id = t.default_option_label)                   ,1,30)
    ||' l='||substr((select template_Name from wwv_flow_field_templates where id = t.default_required_label)                 ,1,30)
    ||' c='||substr(t.calendar_icon,1,30)
    ||' c='||substr(t.calendar_icon_attr,1,30)
    component_signature
from wwv_flow_themes t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_themes                   is 'Identifies a named collection of Templates';
comment on column apex_application_themes.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_themes.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_themes.application_name  is 'Identifies the application';
comment on column apex_application_themes.THEME_NUMBER                     is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_themes.THEME_NAME                       is 'Identifies the name of the theme';
comment on column apex_application_themes.DEFAULT_PAGE_TEMPLATE            is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_BUTTON_TEMPLATE          is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_REGION_TEMPLATE          is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_CHART_RG_TEMPLATE        is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_FORM_RG_TEMPLATE         is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_REPORT_REGION_TEMPLATE   is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_TABULAR_FORM_TEMPLATE    is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_WIZARD_TEMPLATE          is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_BREADCRUMB_RG_TEMPLATE   is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_LIST_REGION_TEMPLATE     is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_REPORT_ROW_TEMPLATE      is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_ITEM_LABEL_TEMPLATE      is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_BREADCRUMB_TEMPLATE      is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_CALENDAR_TEMPLATE        is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_LIST_TEMPLATE            is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_OPTION_LABEL             is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_REQUIRED_LABEL           is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.CALENDAR_ICON_IMAGE_NAME         is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.CALENDAR_ICON_ATTRIBUTES         is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.THEME_ID                         is 'Primary Key of the Theme';
comment on column apex_application_themes.theme_description                is 'Comment field';
comment on column apex_application_themes.last_updated_by   is 'Apex developer who made last update';
comment on column apex_application_themes.last_updated_on   is 'Date of last update';
comment on column apex_application_themes.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on apex_application_themes to public
/

---------------------------------------------------------
-- A P P L I C A T I O N   T E M P L A T E S
--
prompt ...apex_application_templates

create or replace view apex_application_temp_page
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.NAME                           template_name,
    --t.LOOK
    --
    t.HEADER_TEMPLATE                ,
    t.BOX                            page_body,
    t.FOOTER_TEMPLATE                ,
    --
    t.SUCCESS_MESSAGE                ,
    t.CURRENT_TAB                    ,
    t.CURRENT_TAB_FONT_ATTR          ,
    t.NON_CURRENT_TAB                ,
    t.NON_CURRENT_TAB_FONT_ATTR      ,
    t.CURRENT_IMAGE_TAB              ,
    t.NON_CURRENT_IMAGE_TAB          ,
    t.TOP_CURRENT_TAB                Current_Parent_Tab,
    t.TOP_CURRENT_TAB_FONT_ATTR      Current_Parent_Tab_attr,
    t.TOP_NON_CURRENT_TAB            NonCurrent_Parent_Tab,
    t.TOP_NON_CURRENT_TAB_FONT_ATTR  NonCurrent_Parent_Tab_attr,
    --
    t.NAVIGATION_BAR                 ,
    t.NAVBAR_ENTRY                   ,
    --t.BODY_TITLE                     ,
    t.MESSAGE                        ,
    --t.ATTRIBUTE1                     ,
    --t.ATTRIBUTE2                     ,
    --t.ATTRIBUTE3                     ,
    --t.ATTRIBUTE4                     ,
    --t.ATTRIBUTE5                     ,
    --t.ATTRIBUTE6                     ,
    --t.DEFAULT_BUTTON_POSITION        ,
    --t.TABLE_BGCOLOR                  ,
    --t.HEADING_BGCOLOR                ,
    --t.TABLE_CATTRIBUTES              ,
    --t.FONT_SIZE                      ,
    --t.FONT_FACE                      ,
    t.REGION_TABLE_CATTRIBUTES         MultiColumn_Region_Table_Attr,
    --t.APP_TAB_BEFORE_TABS            ,
    --t.APP_TAB_CURRENT_TAB            ,
    --t.APP_TAB_NON_CURRENT_TAB        ,
    --t.APP_TAB_AFTER_TABS             ,
    t.ERROR_PAGE_TEMPLATE            ,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from wwv_flow_templates
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    --t.BREADCRUMB_DEF_REG_POS         ,
    --t.SIDEBAR_DEF_REG_POS            ,
    --t.REQUIRED_PATCH                 ,
    t.THEME_ID                       theme_number,
    decode(t.THEME_CLASS_ID,
      '1', 'One Level Tabs',
      '2', 'Two Level Tabs',
      '3', 'No Tabs',
      '4', 'Popup',
      '5', 'Printer Friendly',
      '6', 'Login',
      '7', 'Unknown',
      '8',  'Custom 1',
      '9',  'Custom 2',
      '10', 'Custom 3',
      '11', 'Custom 4',
      '12', 'Custom 5',
      '13', 'Custom 6',
      '14', 'Custom 7',
      '15', 'Custom 8',
      '16', 'One Level Tabs with Sidebar',
      '17', 'No Tabs with Sidebar',
      '18', 'Two Level Tabs with Sidebar',
      t.THEME_CLASS_ID)              theme_class,
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    decode(
       t.TRANSLATE_THIS_TEMPLATE,
       'N','No','Y','Yes','Yes')     translatable,
    t.TEMPLATE_COMMENT               component_comment,
    t.id                             template_id,
    --
    substr(t.NAME,1,40)||'.'||length(t.NAME)
    ||' h='||dbms_lob.substr(t.HEADER_TEMPLATE                  ,40,1)||'.'||dbms_lob.getlength(t.HEADER_TEMPLATE                )
    ||' b='||dbms_lob.substr(t.BOX                              ,40,1)||'.'||dbms_lob.getlength(t.BOX                            )
    ||' f='||dbms_lob.substr(t.FOOTER_TEMPLATE                  ,40,1)||'.'||dbms_lob.getlength(t.FOOTER_TEMPLATE                )
    ||' s='||substr(t.SUCCESS_MESSAGE                  ,1,40)||'.'||length(t.SUCCESS_MESSAGE                )
    ||' t='||substr(t.CURRENT_TAB                      ,1,40)||'.'||length(t.CURRENT_TAB                    )
    ||' t='||substr(t.CURRENT_TAB_FONT_ATTR            ,1,40)||'.'||length(t.CURRENT_TAB_FONT_ATTR          )
    ||' n='||substr(t.NON_CURRENT_TAB                  ,1,40)||'.'||length(t.NON_CURRENT_TAB                )
    ||' n='||substr(t.NON_CURRENT_TAB_FONT_ATTR        ,1,40)||'.'||length(t.NON_CURRENT_TAB_FONT_ATTR      )
    ||' i='||substr(t.CURRENT_IMAGE_TAB                ,1,40)||'.'||length(t.CURRENT_IMAGE_TAB              )
    ||' i='||substr(t.NON_CURRENT_IMAGE_TAB            ,1,40)||'.'||length(t.NON_CURRENT_IMAGE_TAB          )
    ||' t='||substr(t.TOP_CURRENT_TAB                  ,1,40)||'.'||length(t.TOP_CURRENT_TAB                )
    ||' t='||substr(t.TOP_CURRENT_TAB_FONT_ATTR        ,1,40)||'.'||length(t.TOP_CURRENT_TAB_FONT_ATTR      )
    ||' t='||substr(t.TOP_NON_CURRENT_TAB              ,1,40)||'.'||length(t.TOP_NON_CURRENT_TAB            )
    ||' t='||substr(t.TOP_NON_CURRENT_TAB_FONT_ATTR    ,1,40)||'.'||length(t.TOP_NON_CURRENT_TAB_FONT_ATTR  )
    ||' n='||substr(t.NAVIGATION_BAR                   ,1,40)||'.'||length(t.NAVIGATION_BAR                 )
    ||' n='||substr(t.NAVBAR_ENTRY                     ,1,40)||'.'||length(t.NAVBAR_ENTRY                   )
    ||' m='||substr(t.MESSAGE                          ,1,40)||'.'||length(t.MESSAGE                        )
    ||' e='||substr(t.ERROR_PAGE_TEMPLATE              ,1,40)||'.'||length(t.ERROR_PAGE_TEMPLATE            )
    --
    ||' s='||decode(t.REFERENCE_ID,null,'No','Yes')
    ||' t='||t.THEME_ID
    ||' c='||decode(t.THEME_CLASS_ID,
      '1', 'One Level Tabs',
      '2', 'Two Level Tabs',
      '3', 'No Tabs',
      '4', 'Popup',
      '5', 'Printer Friendly',
      '6', 'Login',
      '7', 'Unknown',
      '8',  'Custom 1',
      '9',  'Custom 2',
      '10', 'Custom 3',
      '11', 'Custom 4',
      '12', 'Custom 5',
      '13', 'Custom 6',
      '14', 'Custom 7',
      '15', 'Custom 8',
      '16', 'One Level Tabs with Sidebar',
      '17', 'No Tabs with Sidebar',
      '18', 'Two Level Tabs with Sidebar',
      t.THEME_CLASS_ID)
    ||' t='||t.TRANSLATE_THIS_TEMPLATE
    component_signature
from wwv_flow_templates t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_temp_page                                is 'The Page Template which identifies the HTML used to organized and render a page content';
comment on column apex_application_temp_page.workspace                      is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_page.application_id                 is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_page.application_name               is 'Identifies the application';
comment on column apex_application_temp_page.THEME_number                   is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_temp_page.TEMPLATE_NAME                  is 'Name of the Page Template';
comment on column apex_application_temp_page.HEADER_TEMPLATE                is 'In the Header is the first of 3 parts of the page template.  Enter the HTML that makes up the HEAD section of the HTML document.  That is, all the required HTML tags before the BODY of the HTML document.';
comment on column apex_application_temp_page.page_body                      is 'The Body is the second of 3 parts of the page template.  Enter HTML that makes up the BODY of the HTML document.';
comment on column apex_application_temp_page.FOOTER_TEMPLATE                is 'The Footer is the third template and displays after the body.';
comment on column apex_application_temp_page.SUCCESS_MESSAGE                is 'Enter HTML that will substitute the string #SUCCESS_MESSAGE# in the template body';
comment on column apex_application_temp_page.CURRENT_TAB                    is 'Enter HTML or text that will be substituted for the currently selected standard tab, use #TAB_LINK#" and #TAB_LABEL# substitutions.';
comment on column apex_application_temp_page.CURRENT_TAB_FONT_ATTR          is 'This attribute is part of the Standard Tab subtemplate.  This value replaces the #TAB_FONT_ATTRIBUTES# substitution string.';
comment on column apex_application_temp_page.NON_CURRENT_TAB                is 'HTML or text that will be substituted for the unselected standard tabs, use #TAB_LINK#" and #TAB_LABEL# substitutions';
comment on column apex_application_temp_page.NON_CURRENT_TAB_FONT_ATTR      is 'This attribute is part of the Parent Tab subtemplate and expands the #PARENT_TAB_CELLS# substitution string.';
comment on column apex_application_temp_page.CURRENT_IMAGE_TAB              is 'HTML to be used to indicate that an image-based tab is currently selected';
comment on column apex_application_temp_page.NON_CURRENT_IMAGE_TAB          is 'HTML to be used to indicate that an image-based tab is not currently selected';
comment on column apex_application_temp_page.Current_Parent_Tab             is 'HTML or text that will be substituted for the selected parent tabs';
comment on column apex_application_temp_page.Current_Parent_Tab_ATTR        is 'This value replaces the #TAB_FONT_ATTRIBUTES# substitution string';
comment on column apex_application_temp_page.NonCurrent_Parent_Tab          is 'HTML or text that will be substituted for the unselected standard tabs, use #TAB_LINK# and #TAB_LABEL# substitutions';
comment on column apex_application_temp_page.NonCurrent_Parent_Tab_ATTR     is 'This value replaces the #TAB_FONT_ATTRIBUTES# substitution string';
comment on column apex_application_temp_page.NAVIGATION_BAR                 is 'HTML or text that will be substituted when the string #NAVIGATION_BAR# is referenced in the template header, body or footer';
comment on column apex_application_temp_page.NAVBAR_ENTRY                   is 'HTML or text that will be substituted into the navigation bar #BAR_BODY# for each navigation bar entry';
comment on column apex_application_temp_page.MESSAGE                        is 'HTML or text that will be substituted when the string #NOTIFICATION_MESSAGE# is referenced in the template header, body or footer';
comment on column apex_application_temp_page.ERROR_PAGE_TEMPLATE            is 'Used only when this page template will be designated as an error template.  Use #MESSAGE# to place the error message and #BACK_LINK# to display a link back to the previous page.';
comment on column apex_application_temp_page.THEME_NUMBER                   is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_temp_page.THEME_CLASS                    is 'Identifies a specific usage for this template';
comment on column apex_application_temp_page.TRANSLATABLE                   is 'Identifies if this component is to be identified as translatable (yes or no)';
comment on column apex_application_temp_page.COMPONENT_COMMENT              is 'Developer comment';
comment on column apex_application_temp_page.IS_SUBSCRIBED                  is 'Identifies if this template is subscribed from another template';
comment on column apex_application_temp_page.SUBSCRIBED_FROM                is 'Identifies the Application ID and Template Name this template is subscribed from';
comment on column apex_application_temp_page.TEMPLATE_ID                    is 'Primary Key of this Page Template';
comment on column apex_application_temp_page.last_updated_by                is 'Apex developer who made last update';
comment on column apex_application_temp_page.last_updated_on                is 'Date of last update';
comment on column apex_application_temp_page.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_application_temp_page.MultiColumn_Region_Table_Attr  is 'This attribute controls the attributes of the HTML table tag used to display regions in multiple columns.';


grant select on   apex_application_temp_page to public;


create or replace view apex_application_temp_region
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.PAGE_PLUG_TEMPLATE_NAME        template_name,
    t.THEME_ID                       theme_number,
    --
    decode(t.THEME_CLASS_ID,
        'RETURN_VALUE','DISPLAY_VALUE',
        '1','Hide and Show Region',
        '2','Sidebar Region',
        '3','Sidebar Region, Alternative 1',
        '4','Button Region with Title',
        '5','Navigation Region',
        '6','Breadcrumb Region',
        '7','Borderless Region',
        '8','Form Region',
        '9','Reports Region',
        '10','Reports Region, Alternative 1',
        '11','Region without Title',
        '12','Wizard Region',
        '13','Reports Region 100% Width',
        '16','Navigation Region, Alternative 1',
        '17','Button Region without Title',
        '18','Bracketed Region',
        '19','Region without Buttons and Title',
        '20','Wizard Region with Icon',
        '21','Custom 1',
        '22','Custom 2',
        '23','Custom 3',
        '24','Custom 4',
        '25','Custom 5',
        '26','Custom 6',
        '27','Custom 7',
        '28','Custom 8',
        '29','List Region with Icon',
        '30','Chart Region',
        t.theme_class_id)            theme_class,
    --
    t.TEMPLATE,
    t.TEMPLATE2,
    t.TEMPLATE3,
    t.PLUG_TABLE_BGCOLOR,
    t.PLUG_HEADING_BGCOLOR,
    t.PLUG_FONT_SIZE,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from WWV_FLOW_PAGE_PLUG_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    decode(t.TRANSLATE_THIS_TEMPLATE,
      'N','No','Y','Yes','Yes')      translatable,
    t.TEMPLATE_COMMENT               component_comment,
    t.id                             region_template_id,
    --
    t.PAGE_PLUG_TEMPLATE_NAME
    ||' t='||t.THEME_ID
    ||' c='||THEME_CLASS_ID
    ||' 1='||dbms_lob.substr(t.TEMPLATE,40,1)||'.'||dbms_lob.getlength(t.TEMPLATE)
    ||' 2='||dbms_lob.substr(t.TEMPLATE2,40,1)||'.'||dbms_lob.getlength(t.TEMPLATE2)
    ||' 3='||dbms_lob.substr(t.TEMPLATE3,40,1)||'.'||dbms_lob.getlength(t.TEMPLATE3)
    ||' b='||substr(t.PLUG_TABLE_BGCOLOR,1,20)
    ||' b='||substr(t.PLUG_HEADING_BGCOLOR,1,20)
    ||' f='||substr(t.PLUG_FONT_SIZE,1,20)
    ||' t='||TRANSLATE_THIS_TEMPLATE
    ||' r='||decode(t.REFERENCE_ID,null,'N','Y')
    component_signature
from WWV_FLOW_PAGE_PLUG_TEMPLATES t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_temp_region                       is 'Identifies a regions HTML template display attributes';
comment on column apex_application_temp_region.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_region.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_region.application_name      is 'Identifies the application';
comment on column apex_application_temp_region.TEMPLATE_NAME         is 'Identifies the region template';
comment on column apex_application_temp_region.THEME_NUMBER          is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_temp_region.THEME_CLASS           is 'Identifies a specific usage for this template';
comment on column apex_application_temp_region.TEMPLATE              is 'HTML that defined the appearance for a page region';
comment on column apex_application_temp_region.TEMPLATE2             is '';
comment on column apex_application_temp_region.TEMPLATE3             is '';
comment on column apex_application_temp_region.PLUG_TABLE_BGCOLOR    is '';
comment on column apex_application_temp_region.PLUG_HEADING_BGCOLOR  is '';
comment on column apex_application_temp_region.PLUG_FONT_SIZE        is '';
comment on column apex_application_temp_region.is_subscribed         is 'Identifies if this Region Template is subscribed from another Region Template';
comment on column apex_application_temp_region.subscribed_from       is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_region.LAST_UPDATED_BY       is 'Apex Developer User Name who last updated this component';
comment on column apex_application_temp_region.LAST_UPDATED_ON       is 'Date this component was last updated';
comment on column apex_application_temp_region.TRANSLATABLE          is 'Identifies if this component is to be included in the list of translatable components';
comment on column apex_application_temp_region.COMPONENT_COMMENT     is 'Developer comment';
comment on column apex_application_temp_region.last_updated_by       is 'Apex developer who made last update';
comment on column apex_application_temp_region.last_updated_on       is 'Date of last update';
comment on column apex_application_temp_region.region_template_id    is 'Primary Key of this Region Template';
comment on column apex_application_temp_region.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_temp_region to public;




create or replace view apex_application_temp_label
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.THEME_ID                       theme_number,
    decode(t.THEME_CLASS_ID,
      '1','Optional Label with Help',
      '2','Required Label with Help',
      '3','Optional Label',
      '4','Required Label',
      '5','Custom 1',
      '6','Custom 2',
      '7','Custom 3',
      '8','Custom 4',
      '9','Custom 5',
      '10','Custom 6',
      '11','Custom 7',
      '12','Custom 8',
      '13','No Label',
      t.THEME_CLASS_ID)              theme_class,
    --
    t.TEMPLATE_NAME                  template_name,
    t.TEMPLATE_BODY1                 before_label,
    t.TEMPLATE_BODY2                 after_label,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from WWV_FLOW_FIELD_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.ON_ERROR_BEFORE_LABEL,
    t.ON_ERROR_AFTER_LABEL,
    t.LAST_UPDATED_ON                last_updated_on,
    t.LAST_UPDATED_BY                last_updated_by,
    t.TRANSLATE_THIS_TEMPLATE        ,
    t.TEMPLATE_COMMENT               component_comment,
    t.id                             label_template_id,
    --
    t.TEMPLATE_NAME
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    ||' 1='||substr(t.TEMPLATE_BODY1,1,40)||length(t.TEMPLATE_BODY1)
    ||' 2='||substr(t.TEMPLATE_BODY2,1,40)||length(t.TEMPLATE_BODY2)
    ||' r='||decode(t.REFERENCE_ID,null,'N','Y')
    ||' e='||substr(t.ON_ERROR_BEFORE_LABEL,1,40)||length(t.ON_ERROR_BEFORE_LABEL)
    ||' e='||substr(t.ON_ERROR_AFTER_LABEL,1,40)||length(t.ON_ERROR_AFTER_LABEL)
    ||' t='||t.TRANSLATE_THIS_TEMPLATE
    component_signature
from WWV_FLOW_FIELD_TEMPLATES t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_temp_label                         is 'Identifies a Page Item Label HTML template display attributes';
comment on column apex_application_temp_label.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_label.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_label.application_name        is 'Identifies the application';
comment on column apex_application_temp_label.THEME_NUMBER            is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_temp_label.THEME_CLASS             is 'Identifies a specific usage for this template';
comment on column apex_application_temp_label.TEMPLATE_NAME           is 'Identifies the name of this Item Label Template';
comment on column apex_application_temp_label.before_label            is 'HTML to be displayed before an item label';
comment on column apex_application_temp_label.after_label             is 'HTML to be displayed after an item label';
comment on column apex_application_temp_label.is_subscribed           is 'Identifies if this Item Label Template is subscribed from another Item Label Template';
comment on column apex_application_temp_label.subscribed_from         is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_label.ON_ERROR_BEFORE_LABEL   is 'HTML to precede the item label when a application displays an inline validation error message for the item';
comment on column apex_application_temp_label.ON_ERROR_AFTER_LABEL    is 'HTML to be appended to the item label when a application  displays an inline validation error message for the item';
comment on column apex_application_temp_label.TRANSLATE_THIS_TEMPLATE is 'Identifies if this template should be translated';
comment on column apex_application_temp_label.COMPONENT_COMMENT       is 'Developer comment';
comment on column apex_application_temp_label.label_template_id       is 'Primary Key of this Item Label Template';
comment on column apex_application_temp_label.last_updated_by         is 'Apex developer who made last update';
comment on column apex_application_temp_label.last_updated_on         is 'Date of last update';
comment on column apex_application_temp_label.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_temp_label to public;


create or replace view apex_application_temp_list
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.LIST_TEMPLATE_NAME             template_name,
    t.LIST_TEMPLATE_CURRENT,
    t.LIST_TEMPLATE_NONCURRENT,
    t.LIST_TEMPLATE_BEFORE_ROWS,
    t.LIST_TEMPLATE_AFTER_ROWS,
    t.BETWEEN_ITEMS,
    t.BEFORE_SUB_LIST,
    t.AFTER_SUB_LIST,
    t.BETWEEN_SUB_LIST_ITEMS,
    t.SUB_LIST_ITEM_CURRENT,
    t.SUB_LIST_ITEM_NONCURRENT,
    t.ITEM_TEMPLATE_CURR_W_CHILD,
    t.ITEM_TEMPLATE_NONCURR_W_CHILD,
    t.SUB_TEMPLATE_CURR_W_CHILD,
    t.SUB_TEMPLATE_NONCURR_W_CHILD,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from WWV_FLOW_LIST_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_BY                ,
    t.LAST_UPDATED_ON                ,
    t.THEME_ID                       theme_number,
    decode(t.THEME_CLASS_ID,
       '1','Vertical Unordered List with Bullets',
       '2','Vertical Ordered List',
       '3','Horizontal Links List',
       '4','Horizontal Images with Label List',
       '5','Vertical Images List',
       '6','Button List',
       '7','Tabbed Navigation List',
       '9','Custom 1',
       '10','Custom 2',
       '11','Custom 3',
       '12','Custom 4',
       '13','Custom 5',
       '14','Custom 6',
       '15','Custom 7',
       '16','Custom 8',
       '17','Wizard Progress List',
       '18','Vertical Unordered List without Bullets',
       '19','Vertical Sidebar List',
       '20','Pull Down Menu',
       '21','Pull Down Menu with Image',
       '22','Hierarchical Expanding',
       '23','Hierarchical Expanded',
       t.THEME_CLASS_ID)             theme_class,
    t.TRANSLATE_THIS_TEMPLATE,
    t.LIST_TEMPLATE_COMMENT          component_comment,
    t.id                             list_template_id,
    --
    t.LIST_TEMPLATE_NAME
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    ||' 1='||dbms_lob.substr(t.LIST_TEMPLATE_CURRENT,40,1)||'.'||dbms_lob.getlength(t.LIST_TEMPLATE_CURRENT)
    ||' 2='||dbms_lob.substr(t.LIST_TEMPLATE_NONCURRENT,40,1)||'.'||dbms_lob.getlength(t.LIST_TEMPLATE_NONCURRENT)
    ||' 3='||dbms_lob.substr(t.SUB_LIST_ITEM_CURRENT,40,1)||'.'||dbms_lob.getlength(t.SUB_LIST_ITEM_CURRENT)
    ||' 4='||dbms_lob.substr(t.SUB_LIST_ITEM_NONCURRENT,40,1)||'.'||dbms_lob.getlength(t.SUB_LIST_ITEM_NONCURRENT)
    ||' 5='||dbms_lob.substr(t.ITEM_TEMPLATE_CURR_W_CHILD,40,1)||'.'||dbms_lob.getlength(t.ITEM_TEMPLATE_CURR_W_CHILD)
    ||' 6='||dbms_lob.substr(t.ITEM_TEMPLATE_NONCURR_W_CHILD,40,1)||'.'||dbms_lob.getlength(t.ITEM_TEMPLATE_NONCURR_W_CHILD)
    ||' 7='||dbms_lob.substr(t.SUB_TEMPLATE_CURR_W_CHILD,40,1)||'.'||dbms_lob.getlength(t.SUB_TEMPLATE_CURR_W_CHILD)
    ||' 8='||dbms_lob.substr(t.SUB_TEMPLATE_NONCURR_W_CHILD,40,1)||'.'||dbms_lob.getlength(t.SUB_TEMPLATE_NONCURR_W_CHILD)
    ||' t='||t.TRANSLATE_THIS_TEMPLATE
    ||' r='||decode(t.REFERENCE_ID,null,'N','Y')
    ||' b='||substr(t.LIST_TEMPLATE_BEFORE_ROWS,1,20)||length(t.LIST_TEMPLATE_BEFORE_ROWS)
    ||' a='||substr(t.LIST_TEMPLATE_AFTER_ROWS,1,20)||length(t.LIST_TEMPLATE_AFTER_ROWS)
    ||' b='||substr(t.BETWEEN_ITEMS,1,20)||length(t.BETWEEN_ITEMS)
    ||' b='||substr(t.BEFORE_SUB_LIST,1,20)||length(t.BEFORE_SUB_LIST)
    ||' a='||substr(t.AFTER_SUB_LIST,1,20)||length(t.AFTER_SUB_LIST)
    ||' b='||substr(t.BETWEEN_SUB_LIST_ITEMS,1,20)||length(t.BETWEEN_SUB_LIST_ITEMS)
    component_signature
from WWV_FLOW_LIST_TEMPLATES t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_temp_list                               is 'Identifies HTML template markup used to render a List with List Elements';
comment on column apex_application_temp_list.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_list.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_list.application_name              is 'Identifies the application';
comment on column apex_application_temp_list.TEMPLATE_NAME                 is 'Identifies the List template name';
comment on column apex_application_temp_list.LIST_TEMPLATE_CURRENT         is 'HTML or text to be substituted for the selected (or current) list entry';
comment on column apex_application_temp_list.LIST_TEMPLATE_NONCURRENT      is 'HTML or text to be substituted for the non selected (or non-current) list entry';
comment on column apex_application_temp_list.LIST_TEMPLATE_BEFORE_ROWS     is 'HTML that displays before any list elements. You can use this attribute to open an HTML table or HTML table row';
comment on column apex_application_temp_list.LIST_TEMPLATE_AFTER_ROWS      is 'HTML that displays after list elements. You can use this attribute to close an HTML table or HTML table row';
comment on column apex_application_temp_list.BETWEEN_ITEMS                 is 'HTML that displays between list elements';
comment on column apex_application_temp_list.BEFORE_SUB_LIST               is 'HTML that displays before any sub list elements. ';
comment on column apex_application_temp_list.AFTER_SUB_LIST                is 'HTML that displays after any sub list elements.';
comment on column apex_application_temp_list.BETWEEN_SUB_LIST_ITEMS        is 'HTML that displays between sub list elements';
comment on column apex_application_temp_list.SUB_LIST_ITEM_CURRENT         is 'HTML or text to be substituted for the selected (or current) sub list entry';
comment on column apex_application_temp_list.SUB_LIST_ITEM_NONCURRENT      is 'HTML or text to be substituted for the unselected (or noncurrent) sub list entry';
comment on column apex_application_temp_list.ITEM_TEMPLATE_CURR_W_CHILD    is 'HTML or text to be substituted for the selected (or current) sub list template used when an item has sub list entries';
comment on column apex_application_temp_list.ITEM_TEMPLATE_NONCURR_W_CHILD is 'HTML or text to be substituted for the unselected (or noncurrent) list template used when item has sub list items';
comment on column apex_application_temp_list.SUB_TEMPLATE_CURR_W_CHILD     is 'HTML or text to be substituted for the selected (or current) sub list template used when an item has sub list entries';
comment on column apex_application_temp_list.SUB_TEMPLATE_NONCURR_W_CHILD  is 'HTML or text to be substituted for the unselected (or noncurrent) list template used when item has sub list items';
comment on column apex_application_temp_list.is_subscribed                 is 'Identifies if this List Template is subscribed from another List Template';
comment on column apex_application_temp_list.subscribed_from               is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_list.THEME_number                  is 'Identifies the numeric identifier of this theme to which this template is associated';
comment on column apex_application_temp_list.THEME_CLASS                   is 'Identifies a specific usage for this template';
comment on column apex_application_temp_list.TRANSLATE_THIS_TEMPLATE       is 'Identifies if this template should be translated';
comment on column apex_application_temp_list.COMPONENT_COMMENT             is 'Developer comment';
comment on column apex_application_temp_list.list_template_id              is 'Primary Key of this template';
comment on column apex_application_temp_list.last_updated_by               is 'Apex developer who made last update';
comment on column apex_application_temp_list.last_updated_on               is 'Date of last update';
comment on column apex_application_temp_list.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_temp_list to public;


create or replace view apex_application_temp_bc
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.THEME_ID                       theme_number,
    --
    decode(t.THEME_CLASS_ID,
      '1','Breadcrumb',
      '2','Hierarchical',
      '3','Custom 1',
      '4','Custom 2',
      '5','Custom 3',
      '6','Custom 4',
      '7','Custom 5',
      '8','Custom 6',
      '9','Custom 7',
      '10','Custom 10',
      t.THEME_CLASS_ID)              theme_class,
    --
    t.NAME                           template_name,
    t.BEFORE_FIRST                   ,
    t.CURRENT_PAGE_OPTION            ,
    t.NON_CURRENT_PAGE_OPTION        ,
    t.MENU_LINK_ATTRIBUTES           breadcrumb_link_attributes,
    t.BETWEEN_LEVELS                 ,
    t.AFTER_LAST                     ,
    t.MAX_LEVELS                     ,
    decode(t.START_WITH_NODE,
       'CHILD_MENU','Child Breadcrumb Entries',
       'CURRENT_MENU','Current Breadcrumb',
       'PARENT_MENU','Parent Breadcrumb Entries',
       'PARENT_TO_LEAF','Parent to Leaf (breadcrumb style)',
       t.START_WITH_NODE)            start_with,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from WWV_FLOW_MENU_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    decode(t.TRANSLATE_THIS_TEMPLATE,
      'Y','Yes','N','No','Yes')      translatable,
    t.TEMPLATE_COMMENTS              component_comments,
    t.id                             breadcrumb_template_id,
    --
    t.NAME
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    ||' 1='||substr(t.BEFORE_FIRST           ,1,30)||length(t.BEFORE_FIRST           )
    ||' 2='||substr(t.CURRENT_PAGE_OPTION    ,1,30)||length(t.CURRENT_PAGE_OPTION    )
    ||' 3='||substr(t.NON_CURRENT_PAGE_OPTION,1,30)||length(t.NON_CURRENT_PAGE_OPTION)
    ||' 4='||substr(t.MENU_LINK_ATTRIBUTES   ,1,30)||length(t.MENU_LINK_ATTRIBUTES   )
    ||' 5='||substr(t.BETWEEN_LEVELS         ,1,30)||length(t.BETWEEN_LEVELS         )
    ||' 6='||substr(t.AFTER_LAST             ,1,30)||length(t.AFTER_LAST             )
    ||' l='||t.MAX_LEVELS
    ||' r='||decode(t.REFERENCE_ID,null,'N','Y')
    ||' n='||t.START_WITH_NODE
    component_signature
from WWV_FLOW_MENU_TEMPLATES t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_temp_bc                            is 'Identifies the HTML template markup used to render a Breadcrumb';
comment on column apex_application_temp_bc.workspace                  is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_bc.application_id             is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_bc.application_name           is 'Identifies the application';
comment on column apex_application_temp_bc.THEME_NUMBER               is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_temp_bc.THEME_CLASS                is 'Identifies a specific usage for this template';
comment on column apex_application_temp_bc.TEMPLATE_NAME              is 'Identifies the name of this template';
comment on column apex_application_temp_bc.BEFORE_FIRST               is 'Defines text that displays before the first breadcrumb entry.';
comment on column apex_application_temp_bc.CURRENT_PAGE_OPTION        is 'Defines current entry, use #LINK#, #NAME#, #NAME_ESC_SC#, #LONG_NAME# substitution strings';
comment on column apex_application_temp_bc.NON_CURRENT_PAGE_OPTION    is 'Defines non current entry, use #LINK#, #NAME#, #NAME_ESC_SC#, #LONG_NAME# substitution strings';
comment on column apex_application_temp_bc.breadcrumb_LINK_ATTRIBUTES is 'Displayed within the HTML "A" tag';
comment on column apex_application_temp_bc.BETWEEN_LEVELS             is 'Defines text that displays between levels of breadcrumb entries';
comment on column apex_application_temp_bc.AFTER_LAST                 is 'Defines text that displays after the last breadcrumb entry.';
comment on column apex_application_temp_bc.MAX_LEVELS                 is 'Specifies the number of levels that appear when displaying breadcrumbs in a breadcrumb style.';
comment on column apex_application_temp_bc.START_WITH                 is 'Defines the breadcrumb display style';
comment on column apex_application_temp_bc.is_subscribed              is 'Identifies if this Breadcrumb Template is subscribed from another Breadcrumb Template';
comment on column apex_application_temp_bc.subscribed_from            is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_bc.TRANSLATABLE               is 'Identifies if this component is to be identified as translatable (yes or no)';
comment on column apex_application_temp_bc.COMPONENT_COMMENTS         is 'Developer Comments';
comment on column apex_application_temp_bc.breadcrumb_template_id     is 'Primary Key of this Breadcrumb Template';
comment on column apex_application_temp_bc.last_updated_by            is 'Apex developer who made last update';
comment on column apex_application_temp_bc.last_updated_on            is 'Date of last update';
comment on column apex_application_temp_bc.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_temp_bc to public;



create or replace view apex_application_temp_report
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.ROW_TEMPLATE_NAME              template_name,
    decode(t.ROW_TEMPLATE_TYPE,
      'GENERIC_COLUMNS','Generic Columns (column template)',
      'NAMED_COLUMNS','Named Column (row template)',
      t.ROW_TEMPLATE_TYPE)           template_type,
      --
    t.before_column_heading          ,
    t.COLUMN_HEADING_TEMPLATE        ,
    t.after_column_heading           ,
    t.ROW_TEMPLATE1                  col_TEMPLATE1                ,
    t.ROW_TEMPLATE_CONDITION1        col_TEMPLATE_CONDITION1      ,
    t.ROW_TEMPLATE_DISPLAY_COND1     col_TEMPLATE_DISPLAY_COND1   ,
    t.ROW_TEMPLATE2                  col_TEMPLATE2                ,
    t.ROW_TEMPLATE_CONDITION2        col_TEMPLATE_CONDITION2      ,
    t.ROW_TEMPLATE_DISPLAY_COND2     col_TEMPLATE_DISPLAY_COND2   ,
    t.ROW_TEMPLATE3                  col_TEMPLATE3                ,
    t.ROW_TEMPLATE_CONDITION3        col_TEMPLATE_CONDITION3      ,
    t.ROW_TEMPLATE_DISPLAY_COND3     col_TEMPLATE_DISPLAY_COND3   ,
    t.ROW_TEMPLATE4                  col_TEMPLATE4                ,
    t.ROW_TEMPLATE_CONDITION4        col_TEMPLATE_CONDITION4      ,
    t.ROW_TEMPLATE_DISPLAY_COND4     col_TEMPLATE_DISPLAY_COND4   ,
    t.ROW_TEMPLATE_BEFORE_ROWS       col_TEMPLATE_BEFORE_ROWS     ,
    t.ROW_TEMPLATE_AFTER_ROWS        col_TEMPLATE_AFTER_ROWS      ,
    t.ROW_TEMPLATE_BEFORE_FIRST      col_TEMPLATE_BEFORE_FIRST    ,
    t.ROW_TEMPLATE_AFTER_LAST        col_TEMPLATE_AFTER_LAST      ,
    --t.ROW_TEMPLATE_TABLE_ATTRIBUTES  col_TEMPLATE_TABLE_ATTRIBUTES,
    t.PAGINATION_TEMPLATE            ,
    t.NEXT_PAGE_TEMPLATE             ,
    t.PREVIOUS_PAGE_TEMPLATE         ,
    t.NEXT_SET_TEMPLATE              ,
    t.PREVIOUS_SET_TEMPLATE          ,
    t.ROW_STYLE_MOUSE_OVER           ,
    --t.ROW_STYLE_MOUSE_OUT            ,
    t.ROW_STYLE_CHECKED              ,
    --t.ROW_STYLE_UNCHECKED            ,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from WWV_FLOW_ROW_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_BY                ,
    t.LAST_UPDATED_ON                ,
    t.THEME_ID                       theme_number,
    --
    decode(t.THEME_CLASS_ID,
      '1','Borderless',
      '2','Horizontal Border',
      '3','One Column Unordered List',
      '4','Standard',
      '5','Standard, Alternating Row Colors',
      '6','Value Attribute Pairs',
      '7','Custom 1',
      '8','Custom 2',
      '9','Custom 3',
      '10','Custom 4',
      '11','Custom 5',
      '12','Custom 6',
      '13','Custom 7',
      '14','Custom 8',
      t.THEME_CLASS_ID)              theme_class,
    decode(t.TRANSLATE_THIS_TEMPLATE,
       'Y','Yes','N','No','Yes')     translate_this_template,
    t.ROW_TEMPLATE_COMMENT           component_comment,
    --
    t.ROW_TEMPLATE_NAME
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    ||' t='||t.ROW_TEMPLATE_TYPE
    ||' 1='||dbms_lob.substr(t.ROW_TEMPLATE1,1,40)||dbms_lob.getlength(t.ROW_TEMPLATE1)
    ||' c='||substr(t.ROW_TEMPLATE_CONDITION1   ,1,20)||length(t.ROW_TEMPLATE_CONDITION1)
    ||' c='||substr(t.ROW_TEMPLATE_DISPLAY_COND1,1,20)||length(t.ROW_TEMPLATE_DISPLAY_COND1)
    ||' 2='||dbms_lob.substr(t.ROW_TEMPLATE2,1,40)||dbms_lob.getlength(t.ROW_TEMPLATE2)
    ||' c='||substr(t.ROW_TEMPLATE_CONDITION2   ,1,20)||length(t.ROW_TEMPLATE_CONDITION2)
    ||' c='||substr(t.ROW_TEMPLATE_DISPLAY_COND2,1,20)||length(t.ROW_TEMPLATE_DISPLAY_COND2)
    ||' 3='||dbms_lob.substr(t.ROW_TEMPLATE3,1,40)||dbms_lob.getlength(t.ROW_TEMPLATE3)
    ||' c='||substr(t.ROW_TEMPLATE_CONDITION3   ,1,20)||length(t.ROW_TEMPLATE_CONDITION3)
    ||' c='||substr(t.ROW_TEMPLATE_DISPLAY_COND3,1,20)||length(t.ROW_TEMPLATE_DISPLAY_COND3)
    ||' 4='||dbms_lob.substr(t.ROW_TEMPLATE4,1,40)||dbms_lob.getlength(t.ROW_TEMPLATE4)
    ||decode(t.REFERENCE_ID,null,'N','Y')
    component_signature,
    t.id template_id
from WWV_FLOW_ROW_TEMPLATES t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_temp_report                               is 'Identifies the HTML template markup used to render a Report Headings and Rows';
comment on column apex_application_temp_report.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_report.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_report.application_name              is 'Identifies the application';
comment on column apex_application_temp_report.TEMPLATE_NAME                 is 'Identifies a name for this template';
comment on column apex_application_temp_report.TEMPLATE_TYPE                 is 'Displays the type of the template - either Named columns or Generic Columns';
comment on column apex_application_temp_report.before_column_heading         is 'Emit this before the column header cell.';
comment on column apex_application_temp_report.COLUMN_HEADING_TEMPLATE       is 'This attribute is only applicable to generic column templates. Use this template to colorize each column header cell.';
comment on column apex_application_temp_report.after_column_heading          is 'Emit this after the column header cell.';
comment on column apex_application_temp_report.col_TEMPLATE1                 is 'Defines the column template, use #COLUMN_VALUE#, #ALIGNMENT#, #COLNUM#, #COLUMN_HEADER#, #COLCOUNT#, #ROW_NUM# substitutions';
comment on column apex_application_temp_report.col_TEMPLATE_CONDITION1       is 'Optionally select a condition type that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE_DISPLAY_COND1    is 'A condition that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE2                 is 'Defines the column template, use #COLUMN_VALUE#, #ALIGNMENT#, #COLNUM#, #COLUMN_HEADER#, #COLCOUNT#, #ROW_NUM# substitutions';
comment on column apex_application_temp_report.col_TEMPLATE_CONDITION2       is 'Optionally select a condition type that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE_DISPLAY_COND2    is 'A condition that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE3                 is 'Defines the column template, use #COLUMN_VALUE#, #ALIGNMENT#, #COLNUM#, #COLUMN_HEADER#, #COLCOUNT#, #ROW_NUM# substitutions';
comment on column apex_application_temp_report.col_TEMPLATE_CONDITION3       is 'Optionally select a condition type that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE_DISPLAY_COND3    is 'A condition that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE4                 is 'Defines the column template, use #COLUMN_VALUE#, #ALIGNMENT#, #COLNUM#, #COLUMN_HEADER#, #COLCOUNT#, #ROW_NUM# substitutions';
comment on column apex_application_temp_report.col_TEMPLATE_CONDITION4       is 'Optionally select a condition type that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE_DISPLAY_COND4    is 'A condition that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE_BEFORE_ROWS      is 'HTML which will be displayed one time at the beginning of a report template';
comment on column apex_application_temp_report.col_TEMPLATE_AFTER_ROWS       is 'HTML which will be displayed one time at the beginning of a report template';
comment on column apex_application_temp_report.col_TEMPLATE_BEFORE_FIRST     is 'Display this text before displaying all columns for the report. Use this attribute to open a new HTML row';
comment on column apex_application_temp_report.col_TEMPLATE_AFTER_LAST       is 'Display this HTML after all columns for the report display. Typically used to close an HTML table row';
--comment on column apex_application_temp_report.col_TEMPLATE_TABLE_ATTRIBUTES is '';
comment on column apex_application_temp_report.PAGINATION_TEMPLATE           is 'This attribute will be applied to the entire pagination subtemplate.';
comment on column apex_application_temp_report.NEXT_PAGE_TEMPLATE            is 'HTML that will modify how the "Next Page" portion of the pagination subtemplate will appear';
comment on column apex_application_temp_report.PREVIOUS_PAGE_TEMPLATE        is 'HTML that will modify how the "Previous Page" portion of the pagination subtemplate will appear';
comment on column apex_application_temp_report.NEXT_SET_TEMPLATE             is 'HTML that will modify how the "Next Set" portion of the pagination subtemplate will appear';
comment on column apex_application_temp_report.PREVIOUS_SET_TEMPLATE         is 'HTML that will modify how the "Previous Set" portion of the pagination subtemplate will appear';
comment on column apex_application_temp_report.ROW_STYLE_MOUSE_OVER          is 'This attribute controls the background color of a report row when the user moves the mouse over the row';
--comment on column apex_application_temp_report.ROW_STYLE_MOUSE_OUT           is '';
comment on column apex_application_temp_report.ROW_STYLE_CHECKED             is 'This attribute controls the background color of a report row when the row selector is checked';
--comment on column apex_application_temp_report.ROW_STYLE_UNCHECKED           is '';
comment on column apex_application_temp_report.is_subscribed                 is 'Identifies if this Report Template is subscribed from another Report Template';
comment on column apex_application_temp_report.subscribed_from               is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_report.THEME_number                  is 'Identifies the numeric identifier of this theme to which this template is associated';
comment on column apex_application_temp_report.THEME_CLASS                   is 'Identifies a specific usage for this template';
comment on column apex_application_temp_report.TRANSLATE_THIS_TEMPLATE       is 'Identifies if this template should be translated';
comment on column apex_application_temp_report.COMPONENT_COMMENT             is 'Developer Comment';
comment on column apex_application_temp_report.last_updated_by               is 'Apex developer who made last update';
comment on column apex_application_temp_report.last_updated_on               is 'Date of last update';
comment on column apex_application_temp_report.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_application_temp_report.template_id                   is 'Unique ID of report template';


grant select on   apex_application_temp_report to public;



create or replace view apex_application_temp_calendar
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.NAME                           template_name,
    t.LAST_UPDATED_BY                ,
    t.LAST_UPDATED_ON                ,
    t.THEME_ID                       theme_number,
    decode(t.THEME_CLASS_ID,
       '1','Calendar',
       '2','Calendar, Alternative 1',
       '3','Small Calendar',
       '4','Custom 1',
       '5','Custom 2',
       '6','Custom 3',
       '7','Custom 4',
       '8','Custom 5',
       '9','Custom 6',
       '10','Custom 7',
       '11','Custom 8',
       t.THEME_CLASS_ID)             theme_class,
    --
    decode(t.TRANSLATE_THIS_TEMPLATE,
      'Y','Yes','N','No','Yes')      translatable,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from WWV_FLOW_CAL_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.MONTH_TITLE_FORMAT             ,
    t.DAY_OF_WEEK_FORMAT             ,
    t.MONTH_OPEN_FORMAT              ,
    t.MONTH_CLOSE_FORMAT             ,
    t.DAY_TITLE_FORMAT               ,
    t.DAY_OPEN_FORMAT                ,
    t.DAY_CLOSE_FORMAT               ,
    t.TODAY_OPEN_FORMAT              ,
    t.WEEKEND_TITLE_FORMAT           ,
    t.WEEKEND_OPEN_FORMAT            ,
    t.WEEKEND_CLOSE_FORMAT           ,
    t.NONDAY_TITLE_FORMAT            ,
    t.NONDAY_OPEN_FORMAT             ,
    t.NONDAY_CLOSE_FORMAT            ,
    t.WEEK_TITLE_FORMAT              ,
    t.WEEK_OPEN_FORMAT               ,
    t.WEEK_CLOSE_FORMAT              ,
    t.DAILY_TITLE_FORMAT             ,
    t.DAILY_OPEN_FORMAT              ,
    t.DAILY_CLOSE_FORMAT             ,
    t.weekly_title_format            ,
    t.weekly_day_of_week_format      ,
    t.weekly_month_open_format       ,
    t.weekly_month_close_format      ,
    t.weekly_day_title_format        ,
    t.weekly_day_open_format         ,
    t.weekly_day_close_format        ,
    t.weekly_today_open_format       ,
    t.weekly_weekend_title_format    ,
    t.weekly_weekend_open_format     ,
    t.weekly_weekend_close_format    ,
    t.weekly_time_open_format        ,
    t.weekly_time_close_format       ,
    t.weekly_time_title_format       ,
    t.weekly_hour_open_format        ,
    t.weekly_hour_close_format       ,
    t.daily_day_of_week_format       ,
    t.daily_month_title_format       ,
    t.daily_month_open_format        ,
    t.daily_month_close_format       ,
    t.daily_day_title_format         ,
    t.daily_day_open_format          ,
    t.daily_day_close_format         ,
    t.daily_today_open_format        ,
    t.daily_time_open_format         ,
    t.daily_time_close_format        ,
    t.daily_time_title_format        ,
    t.daily_hour_open_format         ,
    t.daily_hour_close_format        ,
    t.TEMPLATE_COMMENTS              component_comment,
    t.id                             calendar_template_id,
    --
    t.NAME
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    component_signature
from WWV_FLOW_CAL_TEMPLATES t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_temp_calendar                         is 'Identifies the HTML template markup used to display a Calendar';
comment on column apex_application_temp_calendar.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_calendar.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_calendar.application_name        is 'Identifies the application';
comment on column apex_application_temp_calendar.TEMPLATE_NAME           is 'Identifies the template name';
comment on column apex_application_temp_calendar.THEME_number            is 'Identifies the numeric identifier of this theme to which this template is associated';
comment on column apex_application_temp_calendar.THEME_CLASS             is 'Identifies a specific usage for this template';
comment on column apex_application_temp_calendar.translatable            is 'Identifies if this component is to be identified as translatable (yes or no)';
comment on column apex_application_temp_calendar.IS_SUBSCRIBED           is 'Identifies if this Calendar Template is subscribed from another Calendar Template';
comment on column apex_application_temp_calendar.SUBSCRIBED_FROM         is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_calendar.MONTH_TITLE_FORMAT      is 'Format for the monthly title that appears at the top of each month';
comment on column apex_application_temp_calendar.DAY_OF_WEEK_FORMAT      is 'Format for the week day names which display as the column header for that day of the week';
comment on column apex_application_temp_calendar.MONTH_OPEN_FORMAT       is 'Printed immediately after the "Month Title Format". Usually this would be an HTML tag which is a container such as a table. Include substitution strings to include dynamic content.';
comment on column apex_application_temp_calendar.MONTH_CLOSE_FORMAT      is 'HTML to be used to close a month';
comment on column apex_application_temp_calendar.DAY_TITLE_FORMAT        is 'HTML to be used for the day''s title which the first thing printed after the "Day Open Format';
comment on column apex_application_temp_calendar.DAY_OPEN_FORMAT         is 'HTML to be used to opening a day. This is printed for each day. Usually this would be an HTML tag which is a container such as a TD.';
comment on column apex_application_temp_calendar.DAY_CLOSE_FORMAT        is 'HTML to be used to close a day';
comment on column apex_application_temp_calendar.TODAY_OPEN_FORMAT       is 'HTML to be used to open today. Usually this would be an HTML tag which is a container such as a td and would be different somehow from the "Day Open".';
comment on column apex_application_temp_calendar.WEEKEND_TITLE_FORMAT    is 'HTML be used to for a day occurring on a weekend';
comment on column apex_application_temp_calendar.WEEKEND_OPEN_FORMAT     is 'HTML used to open a day which is on a weekend';
comment on column apex_application_temp_calendar.WEEKEND_CLOSE_FORMAT    is 'HTML used to close a day which is on a weekend';
comment on column apex_application_temp_calendar.NONDAY_TITLE_FORMAT     is 'HTML used to format a non-day title. For example, suppose the first of a month is a Monday, but the week starts on a Sunday. Since Sunday is not be part of the current month, Sunday would be a non-day.';
comment on column apex_application_temp_calendar.NONDAY_OPEN_FORMAT      is 'HTML to open a non-day';
comment on column apex_application_temp_calendar.NONDAY_CLOSE_FORMAT     is 'HTML which will close a non-day';
comment on column apex_application_temp_calendar.WEEK_TITLE_FORMAT       is 'HTML be used to for a day occurring on a weekend';
comment on column apex_application_temp_calendar.WEEK_OPEN_FORMAT        is 'HTML to be used to open a week. This is printed for each week. Usually this would be an HTML tag which is a container such as a TR.';
comment on column apex_application_temp_calendar.WEEK_CLOSE_FORMAT       is 'HTML to be used to close a week.';
comment on column apex_application_temp_calendar.weekly_title_format            is 'Format for the weekly title that appears at the top of each week';
comment on column apex_application_temp_calendar.weekly_day_of_week_format      is 'Format for the week day names which display as the column header for that day of the Week';
comment on column apex_application_temp_calendar.weekly_month_open_format       is 'Printed immediately after the "Week Title Format". Usually this would be an HTML tag which is a container such as a table. Include substitution strings to include dynamic content.';
comment on column apex_application_temp_calendar.weekly_month_close_format      is 'HTML to be used to close a Week';
comment on column apex_application_temp_calendar.weekly_day_title_format        is 'HTML to be used for the day''s title which the first thing printed after the "Day Open Format';
comment on column apex_application_temp_calendar.weekly_day_open_format         is 'HTML to be used to opening a day. This is printed for each day. Usually this would be an HTML tag which is a container such as a TD.';
comment on column apex_application_temp_calendar.weekly_day_close_format        is 'HTML to be used to close a day';
comment on column apex_application_temp_calendar.weekly_today_open_format       is 'HTML to be used to open today. Usually this would be an HTML tag which is a container such as a td and would be different somehow from the "Day Open".';
comment on column apex_application_temp_calendar.weekly_weekend_title_format    is 'HTML be used to for a day occurring on a weekend';
comment on column apex_application_temp_calendar.weekly_weekend_open_format     is 'HTML used to open a day which is on a weekend';
comment on column apex_application_temp_calendar.weekly_weekend_close_format    is 'HTML used to close a day which is on a weekend';
comment on column apex_application_temp_calendar.weekly_time_open_format        is 'HTML to be used to display the Time. This is printed for each Hour for a week. Usually this would be an HTML tag which is a container such as a TD.';
comment on column apex_application_temp_calendar.weekly_time_close_format       is 'HTML to be used to close the Time display column';
comment on column apex_application_temp_calendar.weekly_time_title_format       is 'HTML be used for displaying the Time';
comment on column apex_application_temp_calendar.weekly_hour_open_format        is 'HTML to be used to opening the Hour for the week. This is printed for each Hour. Usually this would be an HTML tag which is a container such as a TR.';
comment on column apex_application_temp_calendar.weekly_hour_close_format       is 'HTML to be used to close the Hour';
comment on column apex_application_temp_calendar.daily_day_of_week_format       is 'Format for the week day names which display as the column header for that day of the Week';
comment on column apex_application_temp_calendar.daily_month_title_format       is 'Title format for the Daily Calendar.';
comment on column apex_application_temp_calendar.daily_month_open_format        is 'Printed immediately after the "Day Title Format". Usually this would be an HTML tag which is a container such as a table. Include substitution strings to include dynamic content.';
comment on column apex_application_temp_calendar.daily_month_close_format       is 'HTML to be used to close a Day';
comment on column apex_application_temp_calendar.daily_day_title_format         is 'HTML to be used for the day''s title which the first thing printed after the "Day Open Format';
comment on column apex_application_temp_calendar.daily_day_open_format          is 'HTML to be used to opening a day. This is printed for each day. Usually this would be an HTML tag which is a container such as a TD.';
comment on column apex_application_temp_calendar.daily_day_close_format         is 'HTML to be used to close a day';
comment on column apex_application_temp_calendar.daily_today_open_format        is 'HTML to be used to open today. Usually this would be an HTML tag which is a container such as a td and would be different somehow from the "Day Open".';
comment on column apex_application_temp_calendar.daily_time_open_format         is 'HTML to be used to display the Time. This is printed for each Hour. Usually this would be an HTML tag which is a container such as a TD.';
comment on column apex_application_temp_calendar.daily_time_close_format        is 'HTML to be used to close the Time display column';
comment on column apex_application_temp_calendar.daily_time_title_format        is 'HTML be used for displaying the Time';
comment on column apex_application_temp_calendar.daily_hour_open_format         is 'HTML to be used to opening the Hour for the Day. This is printed for each Hour. Usually this would be an HTML tag which is a container such as a TR.';
comment on column apex_application_temp_calendar.daily_hour_close_format        is 'HTML to be used to close the Hour';
comment on column apex_application_temp_calendar.COMPONENT_COMMENT       is 'Developer comment';
comment on column apex_application_temp_calendar.last_updated_by         is 'Apex developer who made last update';
comment on column apex_application_temp_calendar.last_updated_on         is 'Date of last update';
comment on column apex_application_temp_calendar.calendar_template_id    is 'Identifies the Primary Key of this Calendar Template';
comment on column apex_application_temp_calendar.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_temp_calendar to public;


create or replace view apex_application_temp_button
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.THEME_ID                       theme_number,
    decode(t.THEME_CLASS_ID,
       '1','Button',
       '2','Button, Alternative 3',
       '4','Button, Alternative 1',
       '5','Button, Alternative 2',
       '6','Custom 1',
       '7','Custom 2',
       '8','Custom 3',
       '9','Custom 4',
       '10','Custom 5',
       '11','Custom 6',
       '12','Custom 7',
       '13','Custom 8',
       t.THEME_CLASS_ID)             theme_class,
    --
    t.TEMPLATE_NAME                  template_name,
    t.TEMPLATE                       ,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from WWV_FLOW_button_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    --
    decode(t.TRANSLATE_THIS_TEMPLATE,
      'Y','Yes','N','No','Yes')      translatable,
    t.TEMPLATE_COMMENT               component_comment,
    t.id                             button_template_id,
    --
    t.template_name
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    component_signature
from WWV_FLOW_button_TEMPLATES t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_temp_button                           is 'Identifies the HTML template markup used to display a Button';
comment on column apex_application_temp_button.workspace                 is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_button.application_id            is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_button.application_name          is 'Identifies the application';
comment on column apex_application_temp_button.THEME_NUMBER              is 'Identifies the templates corresponding theme';
comment on column apex_application_temp_button.THEME_CLASS               is 'Identifies a specific usage for this template';
comment on column apex_application_temp_button.TEMPLATE_NAME             is 'Identifies the button template';
comment on column apex_application_temp_button.TEMPLATE                  is 'HTML Template';
comment on column apex_application_temp_button.is_subscribed             is 'Identifies if this Button Template is subscribed from another Button Template';
comment on column apex_application_temp_button.SUBSCRIBED_FROM           is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_button.TRANSLATable              is 'Identifies if this component is to be identified as translatable (yes or no)';
comment on column apex_application_temp_button.COMPONENT_COMMENT         is 'Developer comment';
comment on column apex_application_temp_button.last_updated_by           is 'Apex developer who made last update';
comment on column apex_application_temp_button.last_updated_on           is 'Date of last update';
comment on column apex_application_temp_button.button_template_id        is 'Primary Key of this Button Template';
comment on column apex_application_temp_button.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_temp_button to public;


create or replace view apex_application_temp_popuplov
as
select
    w.short_name                     workspace,
    f.ID                             application_id,
    f.NAME                           application_name,
    --
    t.POPUP_ICON                     ,
    t.POPUP_ICON_ATTR                ,
    t.POPUP_ICON2                    ,
    t.POPUP_ICON_ATTR2               ,
    --t.PAGE_NAME                      ,
    t.PAGE_TITLE                     ,
    t.PAGE_HTML_HEAD                 ,
    t.PAGE_BODY_ATTR                 ,
    t.BEFORE_FIELD_TEXT              ,
    t.AFTER_FIELD_TEXT               ,
    t.PAGE_HEADING_TEXT              ,
    t.PAGE_FOOTER_TEXT               ,
    t.BEFORE_RESULT_SET              ,
    t.AFTER_RESULT_SET               ,
    t.FILTER_WIDTH                   ,
    t.FILTER_MAX_WIDTH               ,
    t.FILTER_TEXT_ATTR               ,
    t.FIND_BUTTON_TEXT               ,
    t.FIND_BUTTON_IMAGE              ,
    t.FIND_BUTTON_ATTR               ,
    t.CLOSE_BUTTON_TEXT              ,
    t.CLOSE_BUTTON_IMAGE             ,
    t.CLOSE_BUTTON_ATTR              ,
    t.NEXT_BUTTON_TEXT               ,
    t.NEXT_BUTTON_IMAGE              ,
    t.NEXT_BUTTON_ATTR               ,
    t.PREV_BUTTON_TEXT               ,
    t.PREV_BUTTON_IMAGE              ,
    t.PREV_BUTTON_ATTR               ,
    t.SCROLLBARS                     ,
    t.RESIZABLE                      ,
    t.WIDTH                          ,
    t.HEIGHT                         ,
    t.RESULT_ROW_X_OF_Y              ,
    t.RESULT_ROWS_PER_PG             ,
    t.WHEN_NO_DATA_FOUND_MESSAGE     ,
    t.BEFORE_FIRST_FETCH_MESSAGE     ,
    t.MINIMUM_CHARACTERS_REQUIRED    ,
    t.THEME_ID                       theme_number,
    --
    decode(t.THEME_CLASS_ID,
     '1','Standard',
     t.THEME_CLASS_ID)               theme_class,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from WWV_FLOW_POPUP_LOV_TEMPLATE
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_ON                last_updated_on,
    t.LAST_UPDATED_BY                last_updated_by,
    decode(t.TRANSLATE_THIS_TEMPLATE,
      'N','No','Y','Yes','Yes')      translatable,
    t.TEMPLATE_COMMENT               component_comment,
    t.id                             template_id,
    --
    'pop'
    ||' ='||substr(POPUP_ICON                 ,1,20)||length(POPUP_ICON                 )
    ||' ='||substr(POPUP_ICON_ATTR            ,1,20)||length(POPUP_ICON_ATTR            )
    ||' ='||substr(POPUP_ICON2                ,1,20)||length(POPUP_ICON2                )
    ||' ='||substr(POPUP_ICON_ATTR2           ,1,20)||length(POPUP_ICON_ATTR2           )
    ||' ='||substr(PAGE_TITLE                 ,1,20)||length(PAGE_TITLE                 )
    ||' ='||substr(PAGE_HTML_HEAD             ,1,20)||length(PAGE_HTML_HEAD             )
    ||' ='||substr(PAGE_BODY_ATTR             ,1,20)||length(PAGE_BODY_ATTR             )
    ||' ='||substr(BEFORE_FIELD_TEXT          ,1,20)||length(BEFORE_FIELD_TEXT          )
    ||' ='||substr(AFTER_FIELD_TEXT           ,1,20)||length(AFTER_FIELD_TEXT           )
    ||' ='||substr(PAGE_HEADING_TEXT          ,1,20)||length(PAGE_HEADING_TEXT          )
    ||' ='||substr(PAGE_FOOTER_TEXT           ,1,20)||length(PAGE_FOOTER_TEXT           )
    ||' ='||substr(BEFORE_RESULT_SET          ,1,20)||length(BEFORE_RESULT_SET          )
    ||' ='||substr(AFTER_RESULT_SET           ,1,20)||length(AFTER_RESULT_SET           )
    ||' ='||substr(FILTER_WIDTH               ,1,20)||length(FILTER_WIDTH               )
    ||' ='||substr(FILTER_MAX_WIDTH           ,1,20)||length(FILTER_MAX_WIDTH           )
    ||' ='||substr(FILTER_TEXT_ATTR           ,1,20)||length(FILTER_TEXT_ATTR           )
    ||' ='||substr(FIND_BUTTON_TEXT           ,1,20)||length(FIND_BUTTON_TEXT           )
    ||' ='||substr(FIND_BUTTON_IMAGE          ,1,20)||length(FIND_BUTTON_IMAGE          )
    ||' ='||substr(FIND_BUTTON_ATTR           ,1,20)||length(FIND_BUTTON_ATTR           )
    ||' ='||substr(CLOSE_BUTTON_TEXT          ,1,20)||length(CLOSE_BUTTON_TEXT          )
    ||' ='||substr(CLOSE_BUTTON_IMAGE         ,1,20)||length(CLOSE_BUTTON_IMAGE         )
    ||' ='||substr(CLOSE_BUTTON_ATTR          ,1,20)||length(CLOSE_BUTTON_ATTR          )
    ||' ='||substr(NEXT_BUTTON_TEXT           ,1,20)||length(NEXT_BUTTON_TEXT           )
    ||' ='||substr(NEXT_BUTTON_IMAGE          ,1,20)||length(NEXT_BUTTON_IMAGE          )
    ||' ='||substr(NEXT_BUTTON_ATTR           ,1,20)||length(NEXT_BUTTON_ATTR           )
    ||' ='||substr(PREV_BUTTON_TEXT           ,1,20)||length(PREV_BUTTON_TEXT           )
    ||' ='||substr(PREV_BUTTON_IMAGE          ,1,20)||length(PREV_BUTTON_IMAGE          )
    ||' ='||substr(PREV_BUTTON_ATTR           ,1,20)||length(PREV_BUTTON_ATTR           )
    ||' ='||substr(SCROLLBARS                 ,1,20)||length(SCROLLBARS                 )
    ||' ='||substr(RESIZABLE                  ,1,20)||length(RESIZABLE                  )
    ||' ='||substr(WIDTH                      ,1,20)||length(WIDTH                      )
    ||' ='||substr(HEIGHT                     ,1,20)||length(HEIGHT                     )
    ||' ='||substr(RESULT_ROW_X_OF_Y          ,1,20)||length(RESULT_ROW_X_OF_Y          )
    ||' ='||RESULT_ROWS_PER_PG
    ||' ='||substr(WHEN_NO_DATA_FOUND_MESSAGE ,1,20)||length(WHEN_NO_DATA_FOUND_MESSAGE )
    ||' ='||substr(BEFORE_FIRST_FETCH_MESSAGE ,1,20)||length(BEFORE_FIRST_FETCH_MESSAGE )
    ||' ='||substr(MINIMUM_CHARACTERS_REQUIRED,1,20)||length(MINIMUM_CHARACTERS_REQUIRED)
    ||' r='||decode(t.REFERENCE_ID,null,'N','Y')
    component_signature
from WWV_FLOW_POPUP_LOV_TEMPLATE t,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = t.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_temp_popuplov                               is 'Identifies the HTML template markup and some functionality of all Popup List of Values controls for this application';
comment on column apex_application_temp_popuplov.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_popuplov.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_popuplov.application_name              is 'Identifies the application';
comment on column apex_application_temp_popuplov.POPUP_ICON                    is 'Name of the image used for all Popup List of Values Icons within this application';
comment on column apex_application_temp_popuplov.POPUP_ICON_ATTR               is 'HTML IMG attributes used to render the Popup List of Values Image';
comment on column apex_application_temp_popuplov.POPUP_ICON2                   is 'Name of the image used for Color Picker Popup List of Values Icon within this application';
comment on column apex_application_temp_popuplov.POPUP_ICON_ATTR2              is 'HTML IMG attributes used to render the Color Picker Popup List of Values Image';
comment on column apex_application_temp_popuplov.PAGE_TITLE                    is 'Page title of the popup list of values page';
comment on column apex_application_temp_popuplov.PAGE_HTML_HEAD                is 'HTML Page Heading';
comment on column apex_application_temp_popuplov.PAGE_BODY_ATTR                is 'Defines text that is added into the popup list of values HTML BODY';
comment on column apex_application_temp_popuplov.BEFORE_FIELD_TEXT             is 'Defines text to display before the popup list of values search field displays';
comment on column apex_application_temp_popuplov.AFTER_FIELD_TEXT              is 'Defines text to display after displaying the search field, the search button, and the close button';
comment on column apex_application_temp_popuplov.PAGE_HEADING_TEXT             is 'Defines text to display after opening the form, but before displaying any text';
comment on column apex_application_temp_popuplov.PAGE_FOOTER_TEXT              is 'Defines text to display after displaying the popup page including the search list results';
comment on column apex_application_temp_popuplov.BEFORE_RESULT_SET             is 'Display this text before displaying the result set. The result set is the result of the list of values query';
comment on column apex_application_temp_popuplov.AFTER_RESULT_SET              is 'Display this text after displaying the result set. The result set is the result of the list of values query';
comment on column apex_application_temp_popuplov.FILTER_WIDTH                  is 'Display the HTML INPUT TYPE = TEXT widget using this width';
comment on column apex_application_temp_popuplov.FILTER_MAX_WIDTH              is 'Display the HTML INPUT TYPE = TEXT widget using this maximum width';
comment on column apex_application_temp_popuplov.FILTER_TEXT_ATTR              is 'Display the HTML INPUT TYPE = TEXT widget using these attributes';
comment on column apex_application_temp_popuplov.FIND_BUTTON_TEXT              is 'Defines text that displays on the name of the button used to search on the popup page';
comment on column apex_application_temp_popuplov.FIND_BUTTON_IMAGE             is 'Defines button image of the button used to search on the popup page';
comment on column apex_application_temp_popuplov.FIND_BUTTON_ATTR              is 'Defines additional attributes for the Find button';
comment on column apex_application_temp_popuplov.CLOSE_BUTTON_TEXT             is 'Defines the name of the close button. The close button dismisses the popup list of values page';
comment on column apex_application_temp_popuplov.CLOSE_BUTTON_IMAGE            is 'Defines close button image. The close button dismisses the popup list of values page';
comment on column apex_application_temp_popuplov.CLOSE_BUTTON_ATTR             is 'Defines additional attributes of the Close button';
comment on column apex_application_temp_popuplov.NEXT_BUTTON_TEXT              is 'Defines the name of the Next button used when paginating result sets';
comment on column apex_application_temp_popuplov.NEXT_BUTTON_IMAGE             is 'Defines the button image of the Next button used when paginating result sets';
comment on column apex_application_temp_popuplov.NEXT_BUTTON_ATTR              is 'Defines additional attributes for the Next button';
comment on column apex_application_temp_popuplov.PREV_BUTTON_TEXT              is 'Defines the name of Previous page button. This button is used to paginate result sets';
comment on column apex_application_temp_popuplov.PREV_BUTTON_IMAGE             is 'Defines the button image of Previous page button. This button is used to paginate result sets.';
comment on column apex_application_temp_popuplov.PREV_BUTTON_ATTR              is 'Defines additional attributes of the Previous button';
comment on column apex_application_temp_popuplov.SCROLLBARS                    is 'Popup lists of values are executed using JavaScript. Use this attribute to control the values of scrollbars';
comment on column apex_application_temp_popuplov.RESIZABLE                     is 'Popup lists of values are executed using JavaScript. Use this attribute to control the value of resizable';
comment on column apex_application_temp_popuplov.WIDTH                         is 'Popup lists of values are executed using JavaScript. Use this attribute to control the values of width';
comment on column apex_application_temp_popuplov.HEIGHT                        is 'Popup lists of values are executed using JavaScript. Use this attribute to control the values of height';
comment on column apex_application_temp_popuplov.RESULT_ROW_X_OF_Y             is 'Defines how row count results display';
comment on column apex_application_temp_popuplov.RESULT_ROWS_PER_PG            is 'Defines the number of rows per page';
comment on column apex_application_temp_popuplov.WHEN_NO_DATA_FOUND_MESSAGE    is '';
comment on column apex_application_temp_popuplov.BEFORE_FIRST_FETCH_MESSAGE    is '';
comment on column apex_application_temp_popuplov.MINIMUM_CHARACTERS_REQUIRED   is '';
comment on column apex_application_temp_popuplov.THEME_NUMBER                  is 'Identifies the templates corresponding theme';
comment on column apex_application_temp_popuplov.THEME_CLASS                   is 'Identifies a specific usage for this template';
comment on column apex_application_temp_popuplov.is_subscribed                 is 'Identifies if this Popup List of Values Template is subscribed from another Popup List of Values Template';
comment on column apex_application_temp_popuplov.subscribed_from               is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_popuplov.TRANSLATable                  is 'Identifies if this component is to be identified as translatable (yes or no)';
comment on column apex_application_temp_popuplov.COMPONENT_COMMENT             is 'Developer comment';
comment on column apex_application_temp_popuplov.template_id                   is 'Primary Key of this Popup List of Values Template';
comment on column apex_application_temp_popuplov.last_updated_by               is 'Apex developer who made last update';
comment on column apex_application_temp_popuplov.last_updated_on               is 'Date of last update';
comment on column apex_application_temp_popuplov.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_temp_popuplov to public;




create or replace view apex_application_templates
as
select
  w.short_name                          workspace,
  ff.ID                                 application_id,
  ff.NAME                               application_name,
  x.theme_id                            theme_number,
  decode(x.template_type,
  'PAGE','Page',
  'REGION','Region',
  'LABEL','Item Label',
  'LIST','List',
  'POPUP_LOV','Popup List of Values',
  'CALENDAR','Calendar',
  'MENU','Breadcrumb',
  'BUTTON','Button',
  'REPORT','Report',
  x.template_type)                      template_type,
  x.template_name                       template_name,
  x.reference_count                     reference_count,
  x.last_updated_on                     last_updated_on,
  x.last_updated_by                     last_updated_by,
  decode(x.reference_id,null,
      'No',0,'No','Yes')                is_subscribed,
  decode(x.is_default,0,'No','Yes')     is_default,
  tid                                   template_id
from
     wwv_flows ff,
     wwv_flow_companies w,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d,
(
select
    flow_id,
    'POPUP_LOV' template_type,
    'Popup LOV' template_name,
    1 reference_count,
    last_updated_on,
    last_updated_by,
    null reference_id,
    1 is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_popup_lov_template plt
union all
select
    flow_id,
    'CALENDAR' template_type,
    NAME template_name,
    (select count(*) from WWV_FLOW_CALS where template_id = c.id and flow_id = c.flow_id )+
    (select count(*) from wwv_flows f where f.id = c.flow_id and f.default_calendar_template = c.id) reference_count,
    last_updated_on,
    last_updated_by,
    reference_id,
    (select count(*) from wwv_flows f where f.id = c.flow_id and f.default_calendar_template = c.id) is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_cal_templates c
union all
select
    flow_id,
    'MENU'   template_type,
    NAME     template_name,
    (select count(*) from wwv_flow_page_plugs r where r.flow_id = m.flow_id and r.menu_template_id = m.id)+
    (select count(*) from wwv_flows f where f.id = m.flow_id and f.default_menu_template = m.id)
    reference_count,
    last_updated_on,
    last_updated_by,
    reference_id,
    (select count(*) from wwv_flows f where f.id = m.flow_id and f.default_menu_template = m.id) is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_menu_templates m
union all
select
    flow_id,
    'BUTTON'             template_type,
    TEMPLATE_NAME        template_name,
    (select count(*)
     from wwv_flow_step_buttons sb
     where sb.flow_id = b.flow_id and
           substr(sb.button_image,1,9) = 'template:' and
           substr(sb.button_image,10) = to_char(b.id))+
    (select count(*) from wwv_flow_step_items si
     where flow_id = b.flow_id and
     si.TAG_ATTRIBUTES = 'template:'||to_char(b.id))+
    (select count(*) from wwv_flows f where f.id = b.flow_id and f.default_button_template = b.id) reference_count,
    last_updated_on,
    last_updated_by,
    reference_id,
    (select count(*) from wwv_flows f where f.id = b.flow_id and f.default_button_template = b.id) is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_button_templates b
union all
select
    flow_id,
    'LABEL' template_type,
    TEMPLATE_NAME template_name,
    (select count(*) from wwv_flow_step_items i where i.flow_id = f.flow_id and i.ITEM_FIELD_TEMPLATE = f.id)+
    (select count(*) from wwv_flows f1 where f1.id = f.flow_id and f1.default_label_template = f.id) reference_count,
    last_updated_on, last_updated_by, reference_id,
    (select count(*) from wwv_flows fp where fp.id = f.flow_id and fp.default_label_template = f.id) is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_field_templates f
union all
select
    flow_id,
    'LIST' template_type,
    l.LIST_TEMPLATE_NAME template_name,
    (select count(*) from wwv_flow_lists ll where ll.flow_id = l.flow_id and ll.DISPLAY_ROW_TEMPLATE_ID = l.id) +
    (select count(*) from wwv_flow_page_plugs p where p.flow_id = l.flow_id and p.list_template_id = l.id) +
    (select count(*) from wwv_flows f where f.id = l.flow_id and f.default_list_template = l.id) reference_count,
    last_updated_on, last_updated_by, reference_id,
    (select count(*) from wwv_flows f where f.id = l.flow_id and f.default_list_template = l.id) is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_list_templates l
union all
select
    flow_id,
    'REPORT'                 template_type,
    ROW_TEMPLATE_NAME        template_name,
    (select count(*) from wwv_flow_page_plugs p where flow_id = ro.flow_id and p.PLUG_QUERY_ROW_TEMPLATE = ro.id) +
    (select count(*) from wwv_flows f where id = ro.flow_id and f.default_report_template = ro.id) reference_count,
    last_updated_on, last_updated_by, reference_id,
    (select count(*) from wwv_flows f where id = ro.flow_id and f.default_report_template = ro.id) is_default,
    ro.id preview,
    theme_id,
    id tid
from wwv_flow_row_templates ro
union all
select
    flow_id,
    'PAGE' template_type,
    name         template_name,
    (select count(*) from wwv_flow_steps s where flow_id = p.flow_id and s.step_template = p.id) +
    (select count(*) from wwv_flows f where flow_id = p.flow_id and f.DEFAULT_PAGE_TEMPLATE = p.id) +
    (select count(*) from wwv_flows f where flow_id = p.flow_id and f.error_template=p.id) +
    (select count(*) from wwv_flows f where flow_id = p.flow_id and f.printer_friendly_template=p.id) reference_count,
    last_updated_on, last_updated_by, reference_id,
    (select count(*) from wwv_flows f where flow_id = p.flow_id and f.DEFAULT_PAGE_TEMPLATE=p.id) is_default,
    p.id preview,
    theme_id,
    id tid
from wwv_flow_templates p
union all
select
    flow_id,
    'REGION' template_type,
    PAGE_PLUG_TEMPLATE_NAME template_name,
    (select count(*) from wwv_flow_page_plugs p where flow_id = r.flow_id and p.PLUG_TEMPLATE = r.id) +
    (select count(*) from wwv_flows f where  id = r.flow_id and f.default_region_template = r.id) reference_count,
    last_updated_on,
    last_updated_by,
    reference_id,
    (select count(*) from wwv_flows f where  id = r.flow_id and f.default_region_template = r.id)  is_default,
    r.id preview,
    theme_id,
    id tid
from wwv_flow_page_plug_templates r
) x
where (ff.owner = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = ff.security_group_id) and
      ff.security_group_id = w.PROVISIONING_COMPANY_ID and
      ff.id = x.flow_id and
      (d.sgid != 0 or nvl(ff.BUILD_STATUS,'x') != 'RUN_ONLY')
/

comment on table  apex_application_templates is 'Identifies reference counts for templates of all types';

comment on column apex_application_templates.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_templates.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_templates.application_name  is 'Identifies the application';
comment on column apex_application_templates.THEME_number      is 'Identifies the numeric identifier of this theme to which this template is associated';
comment on column apex_application_templates.TEMPLATE_TYPE     is 'Identifies the Template Type';
comment on column apex_application_templates.TEMPLATE_NAME     is 'Name of the template';
comment on column apex_application_templates.REFERENCE_COUNT   is 'Number of references to this template';
comment on column apex_application_templates.LAST_UPDATED_ON   is 'Date of last update';
comment on column apex_application_templates.LAST_UPDATED_BY   is 'Apex User Name who made the last update';
comment on column apex_application_templates.IS_SUBSCRIBED     is 'Identifies if this template is subscribed from another template';
comment on column apex_application_templates.IS_DEFAULT        is 'Identifies this template as the default template for new components created with a corresponding type';
comment on column apex_application_templates.TEMPLATE_ID       is 'Primary key of this component';

grant select on apex_application_templates to public;





--------------------------------------------
-- S I T E   M A P
--
prompt ...apex_application_page_map

create or replace view apex_application_page_map as
select w.short_name                 workspace,
       p.flow_id                    application_id,
       (select name
        from wwv_flows
        where id = p.flow_id)       application_name,
       p.id                         page_id,
       p.name                       page_name,
       p.step_title                 page_title,
       --
       breadcrumb                   breadcrumb,
       ltrim((select max(short_name)
       from wwv_flow_menu_options b2
       where c.ggggg_parent_id = b2.id) ||
       ggggg_parent||' > '||
       gggg_parent||' > '||
       ggg_parent||' > '||
       great_grand_parent||' > '||
       grand_parent||' > '||
       parent_breadcrumb||' > '||
       breadcrumb,' >')             full_breadcrumb,
       help_text
from wwv_flow_steps p,
     wwv_flow_companies w,
(
select flow_id, page_id, breadcrumb_id, breadcrumb, parent_breadcrumb, grand_parent,
       great_grand_parent, ggg_parent,gggg_parent,
       (select max(short_name) from wwv_flow_menu_options b2
       where b.gggg_parent_id = b2.id and b.flow_id = b2.flow_id) ggggg_parent,
       (select max(parent_id) from wwv_flow_menu_options b2
       where b.gggg_parent_id = b2.id and b.flow_id = b2.flow_id) ggggg_parent_id
from
(
select flow_id, page_id, breadcrumb_id, breadcrumb, parent_breadcrumb, grand_parent,
       great_grand_parent, ggg_parent,
       (select max(short_name) from wwv_flow_menu_options b2
       where a.ggg_parent_id = b2.id and a.flow_id = b2.flow_id) gggg_parent,
       (select max(parent_id) from wwv_flow_menu_options b2
       where a.ggg_parent_id = b2.id and a.flow_id = b2.flow_id) gggg_parent_id
from
(
select flow_id, page_id, breadcrumb_id, breadcrumb, parent_breadcrumb, grand_parent,
       great_grand_parent,
       (select max(short_name) from wwv_flow_menu_options b2
       where z.great_grand_parent_id = b2.id and z.flow_id = b2.flow_id) ggg_parent,
       (select max(parent_id) from wwv_flow_menu_options b2
       where z.great_grand_parent_id = b2.id and z.flow_id = b2.flow_id) ggg_parent_id
from
(
select flow_id, page_id, breadcrumb_id, breadcrumb, parent_breadcrumb, grand_parent,
       (select max(short_name) from wwv_flow_menu_options b2
       where y.grand_parent_id = b2.id and y.flow_id = b2.flow_id) great_grand_parent,
       (select max(parent_id) from wwv_flow_menu_options b2
       where y.grand_parent_id = b2.id and y.flow_id = b2.flow_id) great_grand_parent_id
from
(
select flow_id, page_id, breadcrumb_id, breadcrumb, parent_breadcrumb,
       (select max(short_name) from wwv_flow_menu_options b2
       where x.parent_id = b2.id) grand_parent,
       (select max(parent_id) from wwv_flow_menu_options b2
       where x.parent_id = b2.id and x.flow_id = b2.flow_id) grand_parent_id
from
(
select flow_id, b.id breadcrumb_id, page_id, short_name breadcrumb,
       (select max(short_name) from wwv_flow_menu_options b2
       where b.parent_id = b2.id and b.flow_id = b2.flow_id) parent_breadcrumb,
       (select max(parent_id) from wwv_flow_menu_options b2
       where b.parent_id = b2.id and b.flow_id = b2.flow_id) parent_id
from wwv_flow_menu_options b
) x
) y
) z
) a
) b
) c
where p.id = c.page_id(+)
and  p.flow_id = c.flow_id
and  w.provisioning_company_id = p.flow_id
and (user = (select owner from wwv_flows where id = p.flow_id) or
     p.security_group_id = (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual))
/

comment on table  apex_application_page_map                   is 'Identifies the full breadcrumb path for each page with a breadcrumb entry';
comment on column apex_application_page_map.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_map.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_map.application_name  is 'Identifies the application';
comment on column apex_application_page_map.page_id           is 'Identifies the application';
comment on column apex_application_page_map.page_name         is 'Identifies a page within an application';

comment on column apex_application_page_map.PAGE_TITLE        is 'Identifies the Page Title';
comment on column apex_application_page_map.BREADCRUMB        is 'Identifies the corresponding Page Breadcrumb Entry Text';
comment on column apex_application_page_map.FULL_BREADCRUMB   is 'Identifies the full breadcrumb hierarchy';
comment on column apex_application_page_map.HELP_TEXT         is 'Identifies the help text associated with the page';

grant select on apex_application_page_map to public;

---------------------------------------------------
-- A P E X    D I C T I O N A R Y   C O M M E N T S
-- includes column and view names, view names have column id of zero
-- parent view name is used to display views in hierarchy

create or replace view apex_dictionary as
select apex_view_name,
       column_id,
       column_name,
       comments,
       comment_type,
       parent_view
from
(
select t.table_name   apex_view_name,
       t.column_id    column_id,
       t.column_name  column_name,
       c.comments     comments,
       'Column'       comment_type,
       case
         when        t.table_name      ='APEX_APPLICATIONS'             then 'APEX_WORKSPACES'
         when        t.table_name      ='APEX_APPLICATION_LOV_ENTRIES'  then 'APEX_APPLICATION_LOVS'
         when        t.table_name      ='APEX_APPLICATION_PAGE_ITEMS'   then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.table_name      ='APEX_APPLICATION_PAGE_BUTTONS' then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.table_name      ='APEX_APPLICATION_LIST_ENTRIES' then 'APEX_APPLICATION_LISTS'
         when        t.table_name      ='APEX_APPLICATION_TEMPLATES'    then 'APEX_APPLICATION_THEMES'
         when substr(t.table_name,1,26)='APEX_APPLICATION_SUPP_OBJ_'    then 'APEX_APPLICATION_SUPP_OBJECTS'
         when substr(t.table_name,1,18)='APEX_WORKSPACE_LOG'            then 'APEX_WORKSPACE_ACTIVITY_LOG'
         when substr(t.table_name,1,21)='APEX_APPLICATION_TEMP'         then 'APEX_APPLICATION_THEMES'
         when substr(t.table_name,1,30)='APEX_APPLICATION_PAGE_RPT_COLS' then 'APEX_APPLICATION_PAGE_RPT'
         when substr(t.table_name,1,25)='APEX_APPLICATION_PAGE_RPT'     then 'APEX_APPLICATION_PAGE_REGIONS'
         when substr(t.table_name,1,29)='APEX_APPLICATION_PAGE_FLASH_S' then 'APEX_APPLICATION_PAGE_FLASH_CH'
         when substr(t.table_name,1,25)='APEX_APPLICATION_PAGE_IR_'     then 'APEX_APPLICATION_PAGE_IR'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR'      then 'APEX_APPLICATION_PAGE_REGIONS'
         when substr(t.table_name,1,27)='APEX_APPLICATION_PAGE_FLASH'   then 'APEX_APPLICATION_PAGE_REGIONS'
         when substr(t.table_name,1,22)='APEX_APPLICATION_PAGE_'        then 'APEX_APPLICATION_PAGES'
         when substr(t.table_name,1,15)='APEX_WORKSPACE_'               then 'APEX_WORKSPACES'
         when substr(t.table_name,1,17)='APEX_APPLICATION_'             then 'APEX_APPLICATIONS'
         end         parent_view,
       case
         when        t.table_name      ='APEX_WORKSPACES'               then null
         when        t.table_name      ='APEX_APPLICATIONS'             then 'APEX_WORKSPACES/'
         when        t.table_name      ='APEX_APPLICATION_LOV_ENTRIES'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_LOVS/'
         when        t.table_name      ='APEX_APPLICATION_PAGE_ITEMS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.table_name      ='APEX_APPLICATION_PAGE_BUTTONS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.table_name      ='APEX_APPLICATION_LIST_ENTRIES' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_LISTS/'
         when        t.table_name      ='APEX_APPLICATION_TEMPLATES'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when substr(t.table_name,1,18)='APEX_WORKSPACE_LOG'            then 'APEX_WORKSPACES/APEX_WORKSPACE_ACTIVITY_LOG/'
         when substr(t.table_name,1,26)='APEX_APPLICATION_SUPP_OBJ_'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_SUPP_OBJECTS/'
         when substr(t.table_name,1,21)='APEX_APPLICATION_TEMP'         then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when substr(t.table_name,1,30)='APEX_APPLICATION_PAGE_RPT_COLS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_RPT/'
         when substr(t.table_name,1,25)='APEX_APPLICATION_PAGE_RPT'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.table_name,1,29)='APEX_APPLICATION_PAGE_FLASH_S' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_FLASH_CH/'
         when substr(t.table_name,1,25)='APEX_APPLICATION_PAGE_IR_'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR'      then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.table_name,1,27)='APEX_APPLICATION_PAGE_FLASH'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.table_name,1,22)='APEX_APPLICATION_PAGE_'        then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/'
         when substr(t.table_name,1,15)='APEX_WORKSPACE_'               then 'APEX_WORKSPACES/'
         when substr(t.table_name,1,17)='APEX_APPLICATION_'             then 'APEX_WORKSPACES/APEX_APPLICATIONS/'
         end ||t.table_name        path
from  sys.all_tab_columns t, sys.all_col_comments c
where t.owner = 'APEX_030200' and
      t.owner = c.owner and
      t.table_name = c.table_name and
      t.column_Name = c.column_name and
      (t.table_name like 'APEX_APPLICATION%' or t.table_name like 'APEX_WORKSPACE%' or t.table_name = 'APEX_THEMES') and
      t.table_name != 'apex_dictionary'
union all
select t.view_name   apex_view_name,
       0             column_id,
       null          column_name,
       c.comments    apex_view_comments,
       'View'        comment_type,
       case
         when        t.view_name      ='APEX_APPLICATIONS'             then 'APEX_WORKSPACES'
         when        t.view_name      ='APEX_APPLICATION_LOV_ENTRIES'  then 'APEX_APPLICATION_LOVS'
         when        t.view_name      ='APEX_APPLICATION_PAGE_ITEMS'   then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.view_name      ='APEX_APPLICATION_PAGE_BUTTONS' then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.view_name      ='APEX_APPLICATION_LIST_ENTRIES' then 'APEX_APPLICATION_LISTS'
         when        t.view_name      ='APEX_APPLICATION_TEMPLATES'    then 'APEX_APPLICATION_THEMES'
         when substr(t.view_name,1,26)='APEX_APPLICATION_SUPP_OBJ_'    then 'APEX_APPLICATION_SUPP_OBJECTS'
         when substr(t.view_name,1,18)='APEX_WORKSPACE_LOG'            then 'APEX_WORKSPACE_ACTIVITY_LOG'
         when substr(t.view_name,1,21)='APEX_APPLICATION_TEMP'         then 'APEX_APPLICATION_THEMES'
         when substr(t.view_name,1,30)='APEX_APPLICATION_PAGE_RPT_COLS' then 'APEX_APPLICATION_PAGE_RPT'
         when substr(t.view_name,1,25)='APEX_APPLICATION_PAGE_RPT'     then 'APEX_APPLICATION_PAGE_REGIONS'
         when substr(t.view_name,1,29)='APEX_APPLICATION_PAGE_FLASH_S' then 'APEX_APPLICATION_PAGE_FLASH_CH'
         when substr(t.view_name,1,25)='APEX_APPLICATION_PAGE_IR_'     then 'APEX_APPLICATION_PAGE_IR'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR'      then 'APEX_APPLICATION_PAGE_PAGE_REGIONS'
         when substr(t.view_name,1,27)='APEX_APPLICATION_PAGE_FLASH'   then 'APEX_APPLICATION_PAGE_REGIONS'
         when substr(t.view_name,1,22)='APEX_APPLICATION_PAGE_'        then 'APEX_APPLICATION_PAGES'
         when substr(t.view_name,1,15)='APEX_WORKSPACE_'               then 'APEX_WORKSPACES'
         when substr(t.view_name,1,17)='APEX_APPLICATION_'             then 'APEX_APPLICATIONS'
         end         parent_view,
       case
         when        t.view_name      ='APEX_WORKSPACES'               then null
         when        t.view_name      ='APEX_APPLICATIONS'             then 'APEX_WORKSPACES/'
         when        t.view_name      ='APEX_APPLICATION_LOV_ENTRIES'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_LOVS/'
         when        t.view_name      ='APEX_APPLICATION_PAGE_ITEMS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.view_name      ='APEX_APPLICATION_PAGE_BUTTONS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.view_name      ='APEX_APPLICATION_LIST_ENTRIES' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_LISTS/'
         when        t.view_name      ='APEX_APPLICATION_TEMPLATES'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when substr(t.view_name,1,18)='APEX_WORKSPACE_LOG'            then 'APEX_WORKSPACES/APEX_WORKSPACE_ACTIVITY_LOG/'
         when substr(t.view_name,1,26)='APEX_APPLICATION_SUPP_OBJ_'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_SUPP_OBJECTS/'
         when substr(t.view_name,1,21)='APEX_APPLICATION_TEMP'         then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when substr(t.view_name,1,30)='APEX_APPLICATION_PAGE_RPT_COLS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_RPT/'
         when substr(t.view_name,1,25)='APEX_APPLICATION_PAGE_RPT'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.view_name,1,29)='APEX_APPLICATION_PAGE_FLASH_S' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_FLASH_CH/'
         when substr(t.view_name,1,25)='APEX_APPLICATION_PAGE_IR_'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR'      then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.view_name,1,27)='APEX_APPLICATION_PAGE_FLASH'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.view_name,1,22)='APEX_APPLICATION_PAGE_'        then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/'
         when substr(t.view_name,1,15)='APEX_WORKSPACE_'               then 'APEX_WORKSPACES/'
         when substr(t.view_name,1,17)='APEX_APPLICATION_'             then 'APEX_WORKSPACES/APEX_APPLICATIONS/'
         end ||t.view_name        path
from  sys.all_views t, sys.all_tab_comments c
where t.owner = 'APEX_030200' and
      t.owner = c.owner and
      t.view_name = c.table_name and
      (t.view_name like 'APEX_APPLICATION%' or t.view_name like 'APEX_WORKSPACE%' or t.view_name = 'APEX_THEMES')
order by 7,2
) x
/

comment on table apex_dictionary is 'Identifies the comment associated with each Apex view and view column';
comment on column apex_dictionary.APEX_VIEW_NAME is 'Name of the Apex dictionary view';
comment on column apex_dictionary.COLUMN_ID      is 'Display order of the Apex dictionary column within the dictionary view';
comment on column apex_dictionary.COLUMN_NAME    is 'Identifies the column name for column dictionary comments, null for view dictionary comments';
comment on column apex_dictionary.COMMENTS       is 'Description of the Apex view name or column name';
comment on column apex_dictionary.COMMENT_TYPE   is 'Type of dictionary comment, View or Column';
comment on column apex_dictionary.parent_view    is 'Identifies the component parent';
grant select   on apex_dictionary to public;


----------------------------------------------
-- A C T I V I T Y    V I E W S
--
prompt ...activity views

create or replace view apex_workspace_access_log as
select
    w.short_name             workspace,
    l.APPLICATION            application_id,
    f.name                   application_name,
    upper(l.LOGIN_NAME)      user_name,
    l.AUTHENTICATION_METHOD  authentication_method,
    l.OWNER                  application_schema_owner,
    l.ACCESS_DATE,
    86400 * (sysdate - l.access_date) seconds_ago,
    l.IP_ADDRESS,
    --l.REMOTE_USER,
    decode(nvl(l.authentication_result,0),
        0,'AUTH_SUCCESS',
        1,'AUTH_UNKNOWN_USER',
        2,'AUTH_ACCOUNT_LOCKED',
        3,'AUTH_ACCOUNT_EXPIRED',
        4,'AUTH_PASSWORD_INCORRECT',
        5,'AUTH_PASSWORD_FIRST_USE',
        6,'AUTH_ATTEMPTS_EXCEEDED',
        7,'AUTH_INTERNAL_ERROR',
        authentication_result) authentication_result,
    l.CUSTOM_STATUS_TEXT       custom_status_text,
    l.SECURITY_GROUP_ID        workspace_id
from WWV_FLOW_USER_ACCESS_LOG_V l,
     wwv_flow_companies w,
     wwv_flows f,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (l.security_group_id in (select security_group_id from  wwv_flow_company_schemas where schema = user) or
       user in ('SYS','SYSTEM', 'APEX_030200')  or
       d.sgid = l.security_group_id) and
       --
      l.security_group_id = w.PROVISIONING_COMPANY_ID and
      l.application = f.id(+) and
      l.ACCESS_DATE > sysdate - 14 and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_workspace_access_log                          is 'One row is logged for each login attempt.';
comment on column apex_workspace_access_log.workspace                is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_access_log.application_id           is 'Application Primary Key, Unique over all workspaces';
comment on column apex_workspace_access_log.application_name         is 'Name of Application';
comment on column apex_workspace_access_log.user_name                is 'Identifies the Application Express username';
comment on column apex_workspace_access_log.authentication_method    is 'Identifies the authentication method';
comment on column apex_workspace_access_log.application_schema_owner is 'Identifies the parse as schema owner for the application';
comment on column apex_workspace_access_log.custom_status_text       is 'Identifies the status of the authentication attempt';
comment on column apex_workspace_access_log.access_date              is 'Date of login attempt';
comment on column apex_workspace_access_log.ip_address               is 'IP Address of user';
comment on column apex_workspace_access_log.AUTHENTICATION_RESULT    is 'Status of authentication attempt';
comment on column apex_workspace_access_log.workspace_id             is 'Workspace numeric identifier';
comment on column apex_workspace_access_log.seconds_ago              is 'Elapsed seconds since event occured';
grant select on   apex_workspace_access_log to public;


create or replace view apex_workspace_activity_log as
    select
           w.short_name              workspace,
           l.userid                  apex_user,
           l.flow_id                 application_id,
           f.name                    application_name,
           f.owner                   application_schema_owner,
           l.step_id                 page_id,
           (select name
            from wwv_flow_steps
            where id = l.step_id and
                  flow_id = f.id)    page_name,
           l.time_stamp              view_date,
           round(86400 * (l.time_stamp - lag(l.time_stamp) over (order by l.time_stamp, l.flow_id, l.userid, l.session_id))) think_time,
           round(86400 * (sysdate - l.time_stamp))     seconds_ago,
           --l.component_type          component_type,
           --l.component_name          component_name,
           l.component_attribute     log_context,
           --l.information             page_view_information,
           l.elap                    elapsed_time,
           l.num_rows                rows_queried,
           l.ip_address              ip_address,
           l.USER_AGENT              agent,
           l.session_id              apex_session_id,
           l.sqlerrm                 error_message,
           l.sqlerrm_component_type  error_on_component_type,
           l.sqlerrm_component_name  error_on_component_name,
           decode(l.page_mode,
             'D','Dynamic',
             'C','Cache Created',
             'R','Cached',
             'P','Partial Page',
             'A','Page Processing',
             l.page_mode)            page_view_mode,
           l.application_info,
           nvl(l.cached_regions,0)   regions_from_cache,
           l.security_group_id       workspace_id
from wwv_flow_activity_log l,
     wwv_flow_companies w,
     wwv_flows f,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (l.security_group_id in (select security_group_id from  wwv_flow_company_schemas where schema = user) or
       user in ('SYS','SYSTEM', 'APEX_030200')  or
       d.sgid = l.security_group_id) and
       --
      l.security_group_id = w.PROVISIONING_COMPANY_ID and
      l.flow_id = f.id(+) and
      l.time_stamp > sysdate - 14 and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_workspace_activity_log                          is 'Page view activity log detail.  One row is logged for each page view for application with logging enabled.';
comment on column apex_workspace_activity_log.workspace                is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_activity_log.application_id           is 'Application Primary Key, Unique over all workspaces';
comment on column apex_workspace_activity_log.application_name         is 'Identifies the application';
comment on column apex_workspace_activity_log.page_id                  is 'ID of the application page';
comment on column apex_workspace_activity_log.page_name                is 'Name of the application page';
comment on column apex_workspace_activity_log.view_date                is 'Date of page view with precision to the second';
comment on column apex_workspace_activity_log.log_context              is 'Context of Page View';
comment on column apex_workspace_activity_log.ELAPSED_TIME             is 'Elapsed time to generate page source';
comment on column apex_workspace_activity_log.ROWS_QUERIED             is 'Number of rows fetched by the Apex reporting engine';
comment on column apex_workspace_activity_log.IP_ADDRESS               is 'IP Address for this page view';
comment on column apex_workspace_activity_log.AGENT                    is 'HTTP User Agent for this page view';
comment on column apex_workspace_activity_log.APEX_SESSION_ID          is 'Apex Session ID for this page view';
comment on column apex_workspace_activity_log.ERROR_MESSAGE            is 'Error message raised for this page view';
comment on column apex_workspace_activity_log.ERROR_ON_COMPONENT_TYPE  is 'The component type that caused an error to be raised';
comment on column apex_workspace_activity_log.ERROR_ON_COMPONENT_NAME  is 'The component name which caused the error to be raised';
comment on column apex_workspace_activity_log.PAGE_VIEW_MODE           is 'The page view mode, typically Static or Dynamic';
comment on column apex_workspace_activity_log.apex_user                is 'Name of the end user of the application';
comment on column apex_workspace_activity_log.application_schema_owner is 'Parsing Schema of the Application';
comment on column apex_workspace_activity_log.regions_from_cache       is 'Count of regions on this page that are rendered from cache';
comment on column apex_workspace_activity_log.think_time               is 'Think time in seconds by application and user with second level granularity';
comment on column apex_workspace_activity_log.application_info         is 'Information provided by the application to provide additional application context';


comment on column apex_workspace_activity_log.workspace_id             is 'Primary Key of the Workspace';


grant select on   apex_workspace_activity_log to public;


create or replace view apex_workspace_log_summary as
    select
           w.short_name                           workspace,
           l.flow_id                              application_id,
           f.name                                 application_name,
           count(*)                               page_views,
           count(distinct l.step_id)              distinct_pages,
           sum(l.elap)                            total_elapsed_time,
           avg(l.elap)                            average_elapsed_time,
           min(l.elap)                            minimum_elapsed_time,
           max(l.elap)                            maximum_elapsed_time,
           sum(l.num_rows)                        total_rows_queried,
           count(distinct l.ip_address)           ip_addresses,
           count(distinct l.USER_AGENT)           agents,
           count(distinct l.session_id)           apex_sessions,
           sum(decode(l.sqlerrm,null,0,1))        page_views_with_errors,
           sum(decode(l.page_mode,'D',1,'C',1,0)) dynamic_page_views,
           sum(decode(l.page_mode,'R',1,0))       cached_page_views,
           min(l.time_stamp)                      first_view,
           max(l.time_stamp)                      last_view,
           max(l.time_stamp)-min(l.time_stamp)    period_in_days
from wwv_flow_activity_log l,
     wwv_flows f,
     wwv_flow_companies w,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (l.security_group_id in (select security_group_id from  wwv_flow_company_schemas where schema = user) or
       user in ('SYS','SYSTEM', 'APEX_030200')  or
       d.sgid = l.security_group_id) and
       --
       l.security_group_id = w.PROVISIONING_COMPANY_ID and
       l.flow_id = f.id(+) and
       l.time_stamp > sysdate - 14 and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
group by w.short_name, l.flow_id, f.name
/


comment on table  apex_workspace_log_summary is 'Page view activity log summarized by application for the last 14 days';
comment on column apex_workspace_log_summary.WORKSPACE                is 'Workspace for which this page view log was recorded';
comment on column apex_workspace_log_summary.APPLICATION_ID           is 'Application ID for which this page view log was recorded';
comment on column apex_workspace_log_summary.APPLICATION_NAME         is 'Application Name for which this page view log was recorded';
comment on column apex_workspace_log_summary.PAGE_VIEWS               is 'Page views aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.DISTINCT_PAGES           is 'Distinct page views aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.TOTAL_ELAPSED_TIME       is 'Total elapsed time generating page source aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.AVERAGE_ELAPSED_TIME     is 'Average elapsed time generating page source aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.MINIMUM_ELAPSED_TIME     is 'Minimum elapsed time generating page source aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.MAXIMUM_ELAPSED_TIME     is 'Maximum elapsed time generating page source aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.TOTAL_ROWS_QUERIED       is 'Total rows queried by the Apex reporting engine aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.IP_ADDRESSES             is 'Distinct IP addresses aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.AGENTS                   is 'Distinct User Agents aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.APEX_SESSIONS            is 'Count of sessions aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.PAGE_VIEWS_WITH_ERRORS   is 'Count of page views generating error text aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.DYNAMIC_PAGE_VIEWS       is 'Count of dynamic page views aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.CACHED_PAGE_VIEWS        is 'Count of static page views aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.FIRST_VIEW               is 'First logged page by Workspace and Application';
comment on column apex_workspace_log_summary.LAST_VIEW                is 'Most recently logged page by Workspace and Application';
comment on column apex_workspace_log_summary.PERIOD_IN_DAYS           is 'Period in days between first logged page view and most recent page view';
grant select on   apex_workspace_log_summary to public;


create or replace view apex_workspace_log_summary_usr as
    select
           w.short_name                           workspace,
           nvl(l.userid,'PUBLIC')                 apex_user,
           count(distinct l.flow_id)              applications,
           count(*)                               page_views,
           count(distinct l.flow_id||'.'||l.step_id) distinct_pages,
           sum(l.elap)                            total_elapsed_time,
           avg(l.elap)                            average_elapsed_time,
           min(l.elap)                            minimum_elapsed_time,
           max(l.elap)                            maximum_elapsed_time,
           sum(l.num_rows)                        total_rows_queried,
           count(distinct l.ip_address)           distinct_ip_addresses,
           count(distinct l.USER_AGENT)           distinct_agents,
           count(distinct l.session_id)           distinct_apex_sessions,
           sum(decode(l.sqlerrm,null,0,1))        page_views_with_errors,
           sum(decode(l.page_mode,'D',1,'C',1,0)) dynamic_page_views,
           sum(decode(l.page_mode,'R',1,0))       cached_page_views,
           min(l.time_stamp)                      first_view,
           max(l.time_stamp)                      last_view,
           max(l.time_stamp)-min(l.time_stamp)    period_in_days,
           --
           sum(decode(greatest(s.the_date - (1/1440),l.time_stamp),l.time_stamp,1,0) )  last_1_minute,
           sum(decode(greatest(s.the_date - (5/1440),l.time_stamp),l.time_stamp,1,0) )  last_5_minutes,
           sum(decode(greatest(s.the_date - (10/1440),l.time_stamp),l.time_stamp,1,0) ) last_10_minutes,
           sum(decode(greatest(s.the_date - (15/1440),l.time_stamp),l.time_stamp,1,0) ) last_15_minutes,
           sum(decode(greatest(s.the_date - (30/1440),l.time_stamp),l.time_stamp,1,0) ) last_30_minutes,
           sum(decode(greatest(s.the_date - (1/24),l.time_stamp),l.time_stamp,1,0) )    last_1_hour,
           sum(decode(greatest(s.the_date - (2/24),l.time_stamp),l.time_stamp,1,0) )    last_2_hours,
           sum(decode(greatest(s.the_date - (6/24),l.time_stamp),l.time_stamp,1,0) )    last_6_hours,
           sum(decode(greatest(s.the_date - (2/24),l.time_stamp),l.time_stamp,1,0) )    last_12_hours,
           sum(decode(greatest(s.the_date - 1,l.time_stamp),l.time_stamp,1,0)      )    last_24_hours,
           sum(decode(greatest(s.the_date - 2,l.time_stamp),l.time_stamp,1,0)      )    last_48_hours,
           sum(decode(greatest(s.the_date - 7,l.time_stamp),l.time_stamp,1,0)      )    last_7_days,
           sum(decode(greatest(s.the_date - 14,l.time_stamp),l.time_stamp,1,0)     )    last_14_days,
           --
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'01',1,0),0))  today_HH01,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'02',1,0),0))  today_HH02,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'03',1,0),0))  today_HH03,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'04',1,0),0))  today_HH04,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'05',1,0),0))  today_HH05,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'06',1,0),0))  today_HH06,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'07',1,0),0))  today_HH07,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'08',1,0),0))  today_HH08,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'09',1,0),0))  today_HH09,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'10',1,0),0))  today_HH10,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'11',1,0),0))  today_HH11,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'12',1,0),0))  today_HH12,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'13',1,0),0))  today_HH13,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'14',1,0),0))  today_HH14,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'15',1,0),0))  today_HH15,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'16',1,0),0))  today_HH16,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'17',1,0),0))  today_HH17,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'18',1,0),0))  today_HH18,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'19',1,0),0))  today_HH19,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'20',1,0),0))  today_HH20,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'21',1,0),0))  today_HH21,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'22',1,0),0))  today_HH22,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'23',1,0),0))  today_HH23,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'24',1,0),0))  today_HH24,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,1,0))                                              today
from wwv_flow_activity_log l,
     wwv_flows f,
     wwv_flow_companies w,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d,
     (select sysdate the_date from dual) s
where (l.security_group_id in (select security_group_id from  wwv_flow_company_schemas where schema = user) or
       user in ('SYS','SYSTEM', 'APEX_030200')  or
       d.sgid = l.security_group_id) and
       --
       l.security_group_id = w.PROVISIONING_COMPANY_ID and
       l.flow_id = f.id(+) and
       l.time_stamp > sysdate - 14 and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
group by w.short_name, nvl(l.userid,'PUBLIC')
/

comment on table apex_workspace_log_summary_usr is 'Page view activity log summarized by user for the last two weeks';
comment on column apex_workspace_log_summary_usr.WORKSPACE                      is 'Name of Workspace that generated the page view log entry';
comment on column apex_workspace_log_summary_usr.APEX_USER                      is 'Name of the Apex User name associated with the page view log entry';
comment on column apex_workspace_log_summary_usr.APPLICATIONS                   is 'Number of applications contained in the aggregation by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.PAGE_VIEWS                     is 'Page views aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.DISTINCT_PAGES                 is 'Distinct page views aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.TOTAL_ELAPSED_TIME             is 'Total elapsed time logged aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.AVERAGE_ELAPSED_TIME           is 'Average elapsed time logged aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.MINIMUM_ELAPSED_TIME           is 'Minimum elapsed time logged aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.MAXIMUM_ELAPSED_TIME           is 'Maximum elapsed time aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.TOTAL_ROWS_QUERIED             is 'Total rows queried by the Apex reporting engine aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.DISTINCT_IP_ADDRESSES          is 'Distinct IP addresses aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.DISTINCT_AGENTS                is 'Distinct User Agents aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.DISTINCT_APEX_SESSIONS         is 'Distinct Apex Sessions aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.PAGE_VIEWS_WITH_ERRORS         is 'Count of page views with recorded errors aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.DYNAMIC_PAGE_VIEWS             is 'Count of dynamic page views aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.CACHED_PAGE_VIEWS              is 'Count of cached page views aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.FIRST_VIEW                     is 'Date of first page view by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_VIEW                      is 'Date of most recent page view by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.PERIOD_IN_DAYS                 is 'Period in days between the first recorded page view an the most recent page view';
comment on column apex_workspace_log_summary_usr.LAST_1_MINUTE                  is 'Page views recorded in the last 1 minute aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_5_MINUTES                 is 'Page views recorded in the last 5 minutes aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_10_MINUTES                is 'Page views recorded in the last 10 minutes aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_15_MINUTES                is 'Page views recorded in the last 15 minutes aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_30_MINUTES                is 'Page views recorded in the last 30 minutes aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_1_HOUR                    is 'Page views recorded in the last 1 hour aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_2_HOURS                   is 'Page views recorded in the last 2 hours aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_6_HOURS                   is 'Page views recorded in the last 6 hours aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_12_HOURS                  is 'Page views recorded in the last 12 hours aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_24_HOURS                  is 'Page views recorded in the last 24 hours aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_48_HOURS                  is 'Page views recorded in the last 48 hours aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_7_DAYS                    is 'Page views recorded in the last 7 days aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_14_DAYS                   is 'Page views recorded in the last 14 days aggregated by Apex User Name and Workspace';
comment on column apex_workspace_log_summary_usr.TODAY_HH01                     is 'Page views recorded today for the hour 00-01';
comment on column apex_workspace_log_summary_usr.TODAY_HH02                     is 'Page views recorded today for the hour 01-02';
comment on column apex_workspace_log_summary_usr.TODAY_HH03                     is 'Page views recorded today for the hour 02-03';
comment on column apex_workspace_log_summary_usr.TODAY_HH04                     is 'Page views recorded today for the hour 03-04';
comment on column apex_workspace_log_summary_usr.TODAY_HH05                     is 'Page views recorded today for the hour 04-05';
comment on column apex_workspace_log_summary_usr.TODAY_HH06                     is 'Page views recorded today for the hour 05-06';
comment on column apex_workspace_log_summary_usr.TODAY_HH07                     is 'Page views recorded today for the hour 06-07';
comment on column apex_workspace_log_summary_usr.TODAY_HH08                     is 'Page views recorded today for the hour 07-08';
comment on column apex_workspace_log_summary_usr.TODAY_HH09                     is 'Page views recorded today for the hour 08-09';
comment on column apex_workspace_log_summary_usr.TODAY_HH10                     is 'Page views recorded today for the hour 09-10';
comment on column apex_workspace_log_summary_usr.TODAY_HH11                     is 'Page views recorded today for the hour 10-11';
comment on column apex_workspace_log_summary_usr.TODAY_HH12                     is 'Page views recorded today for the hour 11-12';
comment on column apex_workspace_log_summary_usr.TODAY_HH13                     is 'Page views recorded today for the hour 12-13';
comment on column apex_workspace_log_summary_usr.TODAY_HH14                     is 'Page views recorded today for the hour 13-14';
comment on column apex_workspace_log_summary_usr.TODAY_HH15                     is 'Page views recorded today for the hour 14-15';
comment on column apex_workspace_log_summary_usr.TODAY_HH16                     is 'Page views recorded today for the hour 15-16';
comment on column apex_workspace_log_summary_usr.TODAY_HH17                     is 'Page views recorded today for the hour 16-17';
comment on column apex_workspace_log_summary_usr.TODAY_HH18                     is 'Page views recorded today for the hour 17-18';
comment on column apex_workspace_log_summary_usr.TODAY_HH19                     is 'Page views recorded today for the hour 18-19';
comment on column apex_workspace_log_summary_usr.TODAY_HH20                     is 'Page views recorded today for the hour 19-20';
comment on column apex_workspace_log_summary_usr.TODAY_HH21                     is 'Page views recorded today for the hour 20-21';
comment on column apex_workspace_log_summary_usr.TODAY_HH22                     is 'Page views recorded today for the hour 21-22';
comment on column apex_workspace_log_summary_usr.TODAY_HH23                     is 'Page views recorded today for the hour 22-23';
comment on column apex_workspace_log_summary_usr.TODAY_HH24                     is 'Page views recorded today for the hour 23-24';
comment on column apex_workspace_log_summary_usr.TODAY                          is 'Todays date on the server to provide greater context for people in different timezones';
grant select on  apex_workspace_log_summary_usr to public;



----------------------------------
-- C R O S S   V I E W   V I E W S
--
create or replace view APEX_APPLICATION_ALL_AUTH
as
          select workspace, application_id, application_name, null page_id, 'Application'            component_type, application_name                component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATIONS                where authorization_scheme is not null
union all select workspace, application_id, application_name, null page_id, 'Breadcrumb Entry'       component_type, ENTRY_LABEL                     component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_BC_ENTRIES      where authorization_scheme is not null
union all select workspace, application_id, application_name, null page_id, 'Application Compuation' component_type, COMPUTATION_ITEM                component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_COMPUTATIONS    where authorization_scheme is not null
union all select workspace, application_id, application_name, null page_id, 'List Entry'             component_type, ENTRY_TEXT                      component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_LIST_ENTRIES    where authorization_scheme is not null
union all select workspace, application_id, application_name, null page_id, 'Navigation Bar'         component_type, ICON_SUBTEXT                    component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_NAV_BAR         where authorization_scheme is not null
union all select workspace, application_id, application_name, page_id,      'Page'                   component_type, page_name                       component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PAGES           where authorization_scheme is not null
union all select workspace, application_id, application_name, page_id,      'Page Branch'            component_type, substr(BRANCH_ACTION,1,30)      component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PAGE_BRANCHES   where authorization_scheme is not null
union all select workspace, application_id, application_name, page_id,      'Page Button'            component_type, BUTTON_NAME                     component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PAGE_BUTTONS    where authorization_scheme is not null
union all select workspace, application_id, application_name, page_id,      'Page Computation'       component_type, ITEM_NAME                       component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PAGE_COMP       where authorization_scheme is not null
union all select workspace, application_id, application_name, page_id,      'Page Item'              component_type, item_name                       component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PAGE_ITEMS      where authorization_scheme is not null
union all select workspace, application_id, application_name, page_id,      'Page Process'           component_type, process_name                    component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PAGE_PROC       where authorization_scheme is not null
union all select workspace, application_id, application_name, page_id,      'Page Region'            component_type, region_name                     component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PAGE_REGIONS    where authorization_scheme is not null
union all select workspace, application_id, application_name, page_id,      'Page Report Column'     component_type, region_name||'. '||column_alias component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PAGE_RPT_COLS   where authorization_scheme is not null
union all select workspace, application_id, application_name, page_id,      'Page Validation'        component_type, VALIDATION_NAME                 component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PAGE_VAL        where authorization_scheme is not null
union all select workspace, application_id, application_name, null page_id, 'Parent Tab'             component_type, tab_name                        component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PARENT_TABS     where authorization_scheme is not null
union all select workspace, application_id, application_name, null page_id, 'Application Process'    component_type, process_name                    component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_PROCESSES       where authorization_scheme is not null
union all select workspace, application_id, application_name, null page_id, 'Tab'                    component_type, tab_name                        component_name, authorization_scheme, decode(replace(translate(authorization_scheme,'1234567890!','00000000000'),'0',null),null,'Invalid','Valid') status  from APEX_APPLICATION_TABS            where authorization_scheme is not null
/


comment on table APEX_APPLICATION_ALL_AUTH is 'All authorization schemes for all components by Application';
comment on column apex_application_all_auth.WORKSPACE             is 'Authorization Scheme Workspace';
comment on column apex_application_all_auth.APPLICATION_ID        is 'Authorization Scheme Application ID';
comment on column apex_application_all_auth.APPLICATION_NAME      is 'Authorization Scheme Application Name';
comment on column apex_application_all_auth.PAGE_ID               is 'Authorization Scheme Page ID';
comment on column apex_application_all_auth.COMPONENT_TYPE        is 'Authorization Scheme Apex component type';
comment on column apex_application_all_auth.COMPONENT_NAME        is 'Authorization Scheme Apex component name';
comment on column apex_application_all_auth.AUTHORIZATION_SCHEME  is 'Authorization Scheme name';
comment on column apex_application_all_auth.STATUS                is 'Authorization Scheme status';
grant select on  APEX_APPLICATION_ALL_AUTH to public;

---------------------------------------------------------
-- C L I C K  T H R U S
--
create or replace view apex_workspace_clicks as
    select short_name                   workspace,
           category                     category,
           flow_user                    apex_user,
           clickdate                    clickdate,
           a.id                         click_id,
           ip                           clicker_ip,
           provisioning_company_id      workspace_id
      from (select clickdate, category, l.id, flow_user, ip, w.provisioning_company_id,
                   w.short_name, w.first_schema_provisioned
              from wwv_flow_clickthru_log$ l, wwv_flow_companies w
             where l.security_group_id = w.provisioning_company_id
            union all
            select clickdate, category, l.id, flow_user, ip, w.provisioning_company_id,
                   w.short_name, w.first_schema_provisioned
              from wwv_flow_clickthru_log2$ l, wwv_flow_companies w
             where l.security_group_id = w.provisioning_company_id
            ) a,
            wwv_flow_company_schemas s,
            (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
      where s.security_group_id = a.provisioning_company_id
        and a.first_schema_provisioned = s.schema
        and (d.sgid = a.provisioning_company_id or user = s.schema or user in ('SYS','SYSTEM','APEX_030200')) and
      (user in ('SYS','SYSTEM', 'APEX_030200') or a.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_workspace_clicks                          is 'Clicks in Application Express that are tracked by using APEX_UTIL.COUNT_CLICKS';
comment on column apex_workspace_clicks.workspace                is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_clicks.category                 is 'Optional category used to track the click';
comment on column apex_workspace_clicks.apex_user                is 'Name of Application Express user that clicked';
comment on column apex_workspace_clicks.clickdate                is 'Date of the recorded click';
comment on column apex_workspace_clicks.click_id                 is 'Optional secondary ID to further track the click';
comment on column apex_workspace_clicks.clicker_ip               is 'The IP address of the clicker';
comment on column apex_workspace_clicks.workspace_id             is 'Primary key that identifies the workspace';
grant select on apex_workspace_clicks to public;


----------------------------------------------------------
-- A P P L I C A T I O N   F L A S H   C H A R T S
--

prompt ...apex_application_page_flash_ch

create or replace view apex_application_page_flash_ch
as
select
    w.short_name                     workspace,
    f.id                             application_id,
    f.name                           application_name,
    p.id                             page_id,
    p.name                           page_name,
    c.region_id                      region_id,
    (select plug_name
     from wwv_flow_page_plugs
     where id = c.region_id)         region_name,
    c.id                             chart_id,
    decode(c.default_chart_type,
    '2DColumn', '2D Column',
    '2DColumn_Line', '2D Column Line',
    '2DDoughnut', '2D Doughnut',
    '2DLine', '2D Line',
    '2DPie', '2D Pie',
    '3DColumn', '3D Column',
    '3DPie', '3D Pie',
    'Candlestick', 'Candlestick',
    'GaugeChart', 'Dial',
    'DIALSWEEP', 'Dial (Sweep)',
    'Horizontal2DColumn', 'Horizontal 2D Column',
    'Horizontal3DColumn', 'Horizontal 3D Column',
    'HorizontalRange3DColumn', 'Horizontal Range 3D Column',
    'HorizontalRange2DColumn', 'HorizontalRange 2D Column',
    'Inverse2DLine', 'Inverse 2D Line',
    'Range2DColumn', 'Range 2D Column',
    'Range3DColumn', 'Range 3D Column',
    'dot', 'Scatter',
    'Stacked2DColumn', 'Stacked 2D Column',
    '2DSTACKED_PCT', 'Stacked 2D Column (Percent)',
    'Stacked3DColumn', 'Stacked 3D Column',
    '3DSTACKED_PCT', 'Stacked 3D Column (Percent)',
    'StackedHorizontal2DColumn', 'Stacked Horizontal 2D Column',
    '2DHSTACKED_PCT', 'Stacked Horizontal 2D Column (Percent)',
    'StackedHorizontal3DColumn', 'Stacked Horizontal 3D Column',
    '3DHSTACKED_PCT', 'Stacked Horizontal 3D Column (Percent)',
    c.default_chart_type)            chart_type,
    c.chart_title                    chart_title,
    c.chart_width                    chart_width,
    c.chart_height                   chart_height,
    c.chart_animation                chart_animation,
    c.display_attr                   display_attr,
    c.dial_tick_attr                 dial_tick_attr,
    c.margins                        margins,
    c.omit_label_interval            omit_label_interval,
    c.color_scheme                   color_scheme,
    c.custom_colors                  custom_colors,
    c.bgtype                         bgtype,
    c.bgcolor1                       bgcolor1,
    c.bgcolor2                       bgcolor2,
    c.gradient_rotation              gradient_rotation,
    c.x_axis_title                   x_axis_title,
    c.x_axis_min                     x_axis_min,
    c.x_axis_max                     x_axis_max,
    c.x_axis_grid_spacing            x_axis_grid_spacing,
    c.x_axis_prefix                  x_axis_prefix,
    c.x_axis_postfix                 x_axis_postfix,
    c.x_axis_group_sep               x_axis_group_sep,
    c.x_axis_decimal_place           x_axis_decimal_place,
    c.y_axis_title                   y_axis_title,
    c.y_axis_min                     y_axis_min,
    c.y_axis_max                     y_axis_max,
    c.y_axis_grid_spacing            y_axis_grid_spacing,
    c.y_axis_prefix                  y_axis_prefix,
    c.y_axis_postfix                 y_axis_postfix,
    c.y_axis_group_sep               y_axis_group_sep,
    c.y_axis_decimal_place           y_axis_decimal_place,
    c.async_update                   async_update,
    c.async_time                     async_time,
    c.names_font                     names_font,
    c.names_rotation                 names_rotation,
    c.values_font                    values_font,
    c.values_rotation                values_rotation,
    c.hints_font                     hints_font,
    c.legend_font                    legend_font,
    c.grid_labels_font               grid_labels_font,
    c.chart_title_font               chart_title_font,
    c.x_axis_title_font              x_axis_title_font,
    c.y_axis_title_font              y_axis_title_font,
    c.use_chart_xml                  use_chart_xml,
    c.chart_xml                      chart_xml,
    --
    c.updated_by                     last_updated_by,
    c.updated_on                     last_updated_on,
    --
    decode(c.default_chart_type,
    '2DColumn', '2D Column',
    '2DColumn_Line', '2D Column Line',
    '2DDoughnut', '2D Doughnut',
    '2DLine', '2D Line',
    '2DPie', '2D Pie',
    '3DColumn', '3D Column',
    '3DPie', '3D Pie',
    'Candlestick', 'Candlestick',
    'GaugeChart', 'Dial',
    'DIALSWEEP', 'Dial (Sweep)',
    'Horizontal2DColumn', 'Horizontal 2D Column',
    'Horizontal3DColumn', 'Horizontal 3D Column',
    'HorizontalRange3DColumn', 'Horizontal Range 3D Column',
    'HorizontalRange2DColumn', 'HorizontalRange 2D Column',
    'Inverse2DLine', 'Inverse 2D Line',
    'Range2DColumn', 'Range 2D Column',
    'Range3DColumn', 'Range 3D Column',
    'dot', 'Scatter',
    'Stacked2DColumn', 'Stacked 2D Column',
    '2DSTACKED_PCT', 'Stacked 2D Column (Percent)',
    'Stacked3DColumn', 'Stacked 3D Column',
    '3DSTACKED_PCT', 'Stacked 3D Column (Percent)',
    'StackedHorizontal2DColumn', 'Stacked Horizontal 2D Column',
    '2DHSTACKED_PCT', 'Stacked Horizontal 2D Column (Percent)',
    'StackedHorizontal3DColumn', 'Stacked Horizontal 3D Column',
    '3DHSTACKED_PCT', 'Stacked Horizontal 3D Column (Percent)',
    c.default_chart_type)
    ||' attr='||c.chart_width||c.chart_height||c.chart_animation||c.display_attr||c.dial_tick_attr||c.margins||c.omit_label_interval
    ||' color='||c.color_scheme||substr(c.custom_colors,1,20)||'.'||length(c.custom_colors)
               ||c.bgtype||substr(c.bgcolor1,1,20)||'.'||length(c.bgcolor1)||substr(c.bgcolor2,1,20)||'.'||length(c.bgcolor2)
    ||' rotation='||c.gradient_rotation||':'||c.names_rotation||':'||c.values_rotation
    ||' title='||substr(c.chart_title,1,20)||'.'||length(c.chart_title)
    ||substr(c.x_axis_title,1,20)||'.'||length(c.x_axis_title)
    ||substr(c.y_axis_title,1,20)||'.'||length(c.y_axis_title)
    ||' axis='||c.x_axis_min||':'||c.x_axis_max||':'||c.x_axis_grid_spacing||substr(c.x_axis_prefix,1,20)||':'||substr(c.x_axis_postfix,1,20)||':'||c.x_axis_group_sep||':'||c.x_axis_decimal_place
              ||c.y_axis_min||':'||c.y_axis_max||':'||c.y_axis_grid_spacing||substr(c.y_axis_prefix,1,20)||':'||substr(c.y_axis_postfix,1,20)||':'||c.y_axis_group_sep||':'||c.y_axis_decimal_place
    ||' font='||c.names_font||c.values_font||c.hints_font||c.legend_font||c.grid_labels_font||c.chart_title_font||c.x_axis_title_font||c.y_axis_title_font
    ||' xml='||decode(c.use_chart_xml,'Y',
                      dbms_lob.substr(c.chart_xml,30,1)||'.'||dbms_lob.getlength(c.chart_xml),
                      null)
    ||' refresh='||c.async_update||c.async_time
    component_signature
from wwv_flow_flash_charts c,
     wwv_flow_steps p,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = p.security_group_id and
      f.id = p.flow_id and
      f.id = c.flow_id and
      p.id = c.page_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/


comment on table  apex_application_page_flash_ch                      is 'Identifies a Flash chart associated with a Page and Region';
comment on column apex_application_page_flash_ch.workspace            is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_flash_ch.application_id       is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_flash_ch.application_name     is 'Identifies the application';
comment on column apex_application_page_flash_ch.page_id              is 'ID of the application page';
comment on column apex_application_page_flash_ch.page_name            is 'Name of the application page';
comment on column apex_application_page_flash_ch.region_name          is 'Identifies the region name in which this Flash chart is displayed';
comment on column apex_application_page_flash_ch.region_id            is 'Identifies the Page Region foreign key to the apex_application_page_regions view';
comment on column apex_application_page_flash_ch.chart_id             is 'Primary Key of the Flash chart';
comment on column apex_application_page_flash_ch.chart_type           is 'Chart type to indicate the style in which the Flash chart will render';
comment on column apex_application_page_flash_ch.chart_title          is 'A title to display at the top of the chart';
comment on column apex_application_page_flash_ch.chart_width          is 'Width of the chart';
comment on column apex_application_page_flash_ch.chart_height         is 'Height of the chart';
comment on column apex_application_page_flash_ch.chart_animation      is 'An animation to control the initial appearance of the chart';
comment on column apex_application_page_flash_ch.display_attr         is 'Display attribute to show legend, grid, hints, labels and values';
comment on column apex_application_page_flash_ch.dial_tick_attr       is 'Dial chart attribute to show ticks, show tick labels, and tick spacing';
comment on column apex_application_page_flash_ch.margins              is 'Chart attribute for top, bottom, left, right margins';
comment on column apex_application_page_flash_ch.omit_label_interval  is 'A value to specify the interval to skip label text display.';
comment on column apex_application_page_flash_ch.color_scheme         is 'Pre-built color scheme for the chart';
comment on column apex_application_page_flash_ch.custom_colors        is 'Set of custom colors defined by a user';
comment on column apex_application_page_flash_ch.bgtype               is 'Background type for the chart';
comment on column apex_application_page_flash_ch.bgcolor1             is 'Background Color 1 for the chart.  If the background type is set to Gradient, the chart background fades from Background Color 1 to Background Color 2.';
comment on column apex_application_page_flash_ch.bgcolor2             is 'Background Color 2 for the chart.  If the background type is set to Gradient, the chart background fades from Background Color 1 to Background Color 2.';
comment on column apex_application_page_flash_ch.gradient_rotation    is 'The angle for the chart background gradient';
comment on column apex_application_page_flash_ch.x_axis_title         is 'Title for the X Axis';
comment on column apex_application_page_flash_ch.x_axis_min           is 'The smallest data value to appear on the X Axis';
comment on column apex_application_page_flash_ch.x_axis_max           is 'The highest data value to appear on the X Axis';
comment on column apex_application_page_flash_ch.x_axis_grid_spacing  is 'A value to specify the interval of gridlines on the X Axis';
comment on column apex_application_page_flash_ch.x_axis_prefix        is 'Text to display before X Axis values';
comment on column apex_application_page_flash_ch.x_axis_postfix       is 'Text to display after X Axis values';
comment on column apex_application_page_flash_ch.x_axis_group_sep     is 'A flag to display thousand separator in X Axis values';
comment on column apex_application_page_flash_ch.x_axis_decimal_place is 'Number of decimal places to use in X Axis values';
comment on column apex_application_page_flash_ch.y_axis_title         is 'Title for the Y Axis';
comment on column apex_application_page_flash_ch.y_axis_min           is 'The smallest data value to appear on the Y Axis';
comment on column apex_application_page_flash_ch.y_axis_max           is 'The highest data value to appear on the Y Axis';
comment on column apex_application_page_flash_ch.y_axis_grid_spacing  is 'A value to specify the interval of gridlines on the Y Axis';
comment on column apex_application_page_flash_ch.y_axis_prefix        is 'Text to display before Y Axis values';
comment on column apex_application_page_flash_ch.y_axis_postfix       is 'Text to display after Y Axis values';
comment on column apex_application_page_flash_ch.y_axis_group_sep     is 'A flag to display thousand separator in Y Axis values';
comment on column apex_application_page_flash_ch.y_axis_decimal_place is 'Number of decimal places to use in Y Axis values';
comment on column apex_application_page_flash_ch.async_update         is 'A flag to enable an asynchronous graph update';
comment on column apex_application_page_flash_ch.async_time           is 'The interval in seconds between chart updates';
comment on column apex_application_page_flash_ch.names_font           is 'Chart label text font settings';
comment on column apex_application_page_flash_ch.names_rotation       is 'The amount of rotation for the labels';
comment on column apex_application_page_flash_ch.values_font          is 'Chart value text font settings';
comment on column apex_application_page_flash_ch.values_rotation      is 'The amount of rotation for the values';
comment on column apex_application_page_flash_ch.hints_font           is 'Chart hint text font settings';
comment on column apex_application_page_flash_ch.legend_font          is 'Chart legend text font settings';
comment on column apex_application_page_flash_ch.grid_labels_font     is 'Chart grid label font settings';
comment on column apex_application_page_flash_ch.chart_title_font     is 'Chart title font settings';
comment on column apex_application_page_flash_ch.x_axis_title_font    is 'X Axis title font settings';
comment on column apex_application_page_flash_ch.y_axis_title_font    is 'Y Axis title font settings';
comment on column apex_application_page_flash_ch.use_chart_xml        is 'A flag to override generated XML and use a custom chart XML';
comment on column apex_application_page_flash_ch.chart_xml            is 'User defined custom Chart XML for the Flash chart';
comment on column apex_application_page_flash_ch.last_updated_by      is 'Apex developer who made last update';
comment on column apex_application_page_flash_ch.last_updated_on      is 'Date of last update';
comment on column apex_application_page_flash_ch.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_page_flash_ch to public;


prompt ...apex_application_page_flash_s

create or replace view apex_application_page_flash_s
as
select
    w.short_name                     workspace,
    f.id                             application_id,
    f.name                           application_name,
    c.page_id                        page_id,
    (select name
     from wwv_flow_steps
     where id = c.page_id
     and flow_id = c.flow_id)        page_name,
    c.region_id                      region_id,
    (select plug_name
     from wwv_flow_page_plugs
     where id = c.region_id
     and flow_id = c.flow_id)        region_name,
    --
    cs.chart_id                      chart_id,
    cs.id                            series_id,
    cs.series_seq                    series_seq,
    cs.series_name                   series_name,
    cs.series_query                  series_query,
    cs.series_query_type             series_query_type,
    cs.series_query_parse_opt        series_query_parse_opt,
    cs.series_query_no_data_found    series_query_no_data_found,
    cs.series_query_row_count_max    series_query_row_count_max,
    cs.updated_on                    last_updated_on,
    cs.updated_by                    last_updated_by,
    --
    cs.series_name
    ||' seq='||lpad(cs.series_seq,5,'00000')
    ||' q='||dbms_lob.substr(cs.series_query,20,1)||'.'||dbms_lob.getlength(cs.series_query)
    ||' max='||cs.series_query_row_count_max
    ||' nd_msg='|| substr(cs.series_query_no_data_found ,1,20)||length(cs.series_query_no_data_found)
    component_signature
from wwv_flow_flash_chart_series cs,
     wwv_flow_flash_charts c,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.id = cs.flow_id and
      c.id = cs.chart_id and
      c.flow_id = cs.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

comment on table  apex_application_page_flash_s                            is 'Identifies the Flash chart series which comprise a Flash chart';
comment on column apex_application_page_flash_s.workspace                  is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_flash_s.application_id             is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_flash_s.application_name           is 'Identifies the application';
comment on column apex_application_page_flash_s.page_id                    is 'ID of the application page';
comment on column apex_application_page_flash_s.page_name                  is 'Name of the application page';
comment on column apex_application_page_flash_s.region_name                is 'Identifies the region name in which this Flash chart series is displayed';
comment on column apex_application_page_flash_s.region_id                  is 'Identifies the Page Region foreign key to the apex_application_page_regions view';
comment on column apex_application_page_flash_s.chart_id                   is 'Foreign key of the Flash chart';
comment on column apex_application_page_flash_s.series_id                  is 'Primary Key of the Flash chart series';
comment on column apex_application_page_flash_s.series_seq                 is 'Identifies the series sequence to determine the order of evaluation';
comment on column apex_application_page_flash_s.series_name                is 'Flash chart series name';
comment on column apex_application_page_flash_s.series_query               is 'SQL statement that will return the data to display the chart series';
comment on column apex_application_page_flash_s.series_query_type          is 'The query source type';
comment on column apex_application_page_flash_s.series_query_parse_opt     is 'A flag to perform query validation	when saving chart query';
comment on column apex_application_page_flash_s.series_query_no_data_found is 'Defines the text message that displays when the query does not return any rows.';
comment on column apex_application_page_flash_s.series_query_row_count_max is 'Defines the maximum number of rows to query.';
comment on column apex_application_page_flash_s.last_updated_by            is 'Apex developer who made last update';
comment on column apex_application_page_flash_s.last_updated_on            is 'Date of last update';
comment on column apex_application_page_flash_s.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

grant select on   apex_application_page_flash_s to public;




--
-- Interactive Report Views
--

create or replace view apex_application_page_ir
as
select
w.short_name                 workspace,
f.id                         application_id,
f.name                       application_name,
ir.page_id                   page_id,
ir.id                        interactive_report_id,
ir.region_id                 region_id,
--
(select count(*) from wwv_flow_worksheet_columns where worksheet_id = ir.id) number_of_columns,
(select count(*) from wwv_flow_worksheet_col_groups where worksheet_id = ir.id) number_of_column_groups,
(select count(*) from wwv_flow_worksheet_rpts where worksheet_id = ir.id and session_id is null and nvl(is_default,'N')='N') number_of_saved_reports,
ir.max_row_count             ,
ir.max_row_count_message     ,
ir.no_data_found_message     ,
ir.max_rows_per_page         ,
ir.search_button_label       ,
ir.page_items_to_submit      ,
ir.sort_asc_image            ,
ir.sort_asc_image_attr       ,
ir.sort_desc_image           ,
ir.sort_desc_image_attr      ,
-- base table
ir.sql_query                 ,
--
ir.show_nulls_as             ,
decode(ir.pagination_type,
   'ROWS_X_TO_Y_OF_Z','Row Ranges X to Y of Z (no pagination)',
   'ROWS_X_TO_Y','Row Ranges X to Y (no pagination)',
   'SEARCH_ENGINE','Search Engine 1,2,3,4 (set based pagination)',
   'COMPUTED_BUT_NOT_DISPLAYED','Use Externally Created Pagination Buttons',
   'ROW_RANGES','Row Ranges 1-15 16-30 (with set pagination)',
   'ROW_RANGES_IN_SELECT_LIST','Row Ranges 1-15 16-30 in select list (with pagination)',
   'ROW_RANGES_WITH_LINKS','Row Ranges X to Y of Z (with pagination)',
   'NEXT_PREVIOUS_LINKS','Row Ranges X to Y (with next and previous links)',
   ir.pagination_type)       pagination_scheme,
decode(ir.pagination_display_position,
  'BOTTOM_LEFT','Bottom - Left',
  'BOTTOM_RIGHT','Bottom - Right',
  'TOP_LEFT','Top - Left',
  'TOP_RIGHT','Top - Right',
  'TOP_AND_BOTTOM_LEFT','Top and Bottom - Left',
  'TOP_AND_BOTTOM_RIGHT','Top and Bottom - Right',
  ir.pagination_display_position)     pagination_display_position,
(select template_name
 from wwv_flow_button_templates
 where ir.button_template = id
 and flow_id = f.id)          button_template,
--
decode(ir.show_finder_drop_down ,'Y','Yes','N','No',ir.show_finder_drop_down ) show_finder_drop_down ,
decode(ir.show_display_row_count,'Y','Yes','N','No',ir.show_display_row_count) show_display_row_count,
decode(ir.show_search_bar       ,'Y','Yes','N','No',ir.show_search_bar       ) show_search_bar       ,
decode(ir.show_search_textbox   ,'Y','Yes','N','No',ir.show_search_textbox   ) show_search_textbox   ,
decode(ir.show_actions_menu     ,'Y','Yes','N','No',ir.show_actions_menu     ) show_actions_menu     ,
ir.actions_menu_icon         ,
ir.finder_icon               ,
decode(ir.report_list_mode,
       'TABS', 'YES',
       'NO')                 show_reports_as_tabs,
decode(ir.show_select_columns,'Y','Yes','N','No',ir.show_select_columns) show_select_columns,
decode(ir.show_filter        ,'Y','Yes','N','No',ir.show_filter        ) show_filter        ,
decode(ir.show_sort          ,'Y','Yes','N','No',ir.show_sort          ) show_sort          ,
decode(ir.show_control_break ,'Y','Yes','N','No',ir.show_control_break ) show_control_break ,
decode(ir.show_highlight     ,'Y','Yes','N','No',ir.show_highlight     ) show_highlight     ,
decode(ir.show_computation   ,'Y','Yes','N','No',ir.show_computation   ) show_compute       ,
decode(ir.show_aggregate     ,'Y','Yes','N','No',ir.show_aggregate     ) show_aggregate     ,
decode(ir.show_chart         ,'Y','Yes','N','No',ir.show_chart         ) show_chart         ,
decode(ir.show_flashback     ,'Y','Yes','N','No',ir.show_flashback     ) show_flashback     ,
decode(ir.allow_report_saving,'Y','Yes','N','No',ir.allow_report_saving) show_save          ,
decode(ir.show_reset         ,'Y','Yes','N','No',ir.show_reset         ) show_reset         ,
decode(ir.show_download      ,'Y','Yes','N','No',ir.show_download      ) show_download      ,
decode(ir.show_help          ,'Y','Yes','N','No',ir.show_help          ) show_help          ,
ir.download_formats          ,
ir.download_filename         filename,
ir.csv_output_separator      separator,
ir.csv_output_enclosed_by    enclosed_by,
--
decode(ir.show_detail_link,
       'Y', 'Single Row View',
       'C', 'Custom Link target',
       'N', 'No Link Column') detail_link_type,
ir.detail_link                detail_link_target,
ir.detail_link_text           detail_link_text,
ir.detail_link_attr           detail_link_attributes,
ir.detail_link_checksum_type  detail_link_checksum_type,
nvl((select r from apex_standard_conditions where d = ir.detail_link_condition_type),ir.detail_link_condition_type)
                                     detail_link_condition_type,
ir.detail_link_cond           detail_link_cond_expression,
ir.detail_link_cond2          detail_link_cond_expression2,
decode(substr(ir.detail_link_auth_SCHEME,1,1),'!','Not ')||
nvl((select name
 from   wwv_flow_security_schemes
 where  to_char(id) = ltrim(ir.detail_link_auth_scheme,'!')
 and    flow_id = f.id),
 ir.detail_link_auth_scheme)  detail_link_auth_scheme,
ir.detail_link_auth_scheme    detail_link_auth_scheme_id,
--
ir.alias                      alias,
ir.report_id_item             ,
ir.max_query_cost             ,
--
ir.created_on,
ir.created_by,
ir.updated_on,
ir.updated_by,
--
'Interactive Report'||
' rc='||ir.max_row_count||
' '||length(ir.max_row_count_message)||
length(ir.no_data_found_message)||
ir.max_rows_per_page||
substr(ir.search_button_label,1,30)||
length(page_items_to_submit)||
length(ir.sort_asc_image)||
length(ir.sort_asc_image_attr)||
length(ir.sort_desc_image)||
length(ir.sort_desc_image_attr)||
substr(ir.show_nulls_as,1,30)||
' p='||ir.pagination_type||
' '||ir.pagination_display_position||
' '||substr(ir.actions_menu_icon,1,30)||
' '||substr(ir.finder_icon,1,30)||
' opt='||ir.show_finder_drop_down||
ir.show_display_row_count||
ir.show_search_bar||
ir.show_search_textbox||
ir.show_actions_menu||
ir.show_select_columns||
ir.show_filter||
ir.show_sort||
ir.show_control_break||
ir.show_highlight||
ir.show_computation||
ir.show_aggregate||
ir.show_chart||
ir.show_flashback||
ir.allow_report_saving||
ir.show_reset||
ir.show_download||
ir.show_help||
' rpts='||ir.report_list_mode||
' dl='||substr(ir.download_formats,1,40)||
' fn='||substr(ir.download_filename,1,30)||
ir.csv_output_separator||
ir.csv_output_enclosed_by||
ir.show_detail_link||
' l='||substr(ir.detail_link,1,30)||
' lt='||substr(ir.detail_link_text,1,30)||
substr(ir.detail_link_attr,1,30)||
ir.detail_link_checksum_type||
' lc='||ir.detail_link_condition_type||
length(ir.detail_link_cond)||
length(ir.detail_link_cond2)||
ir.detail_link_auth_SCHEME||
' a='||substr(ir.alias,1,30)||
ir.report_id_item||
ir.max_query_cost
component_signature
--
from wwv_flow_worksheets ir,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = ir.security_group_id and
      f.id = ir.flow_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

grant select on apex_application_page_ir to public;

comment on table  apex_application_page_ir                      is 'Identifies attributes of an interactive report';
comment on column apex_application_page_ir.workspace            is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_ir.application_id       is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_ir.application_name     is 'Identifies the application';
comment on column apex_application_page_ir.page_id              is 'Identifies page number';
comment on column apex_application_page_ir.interactive_report_id        is 'ID of the interactive report';
comment on column apex_application_page_ir.region_id                    is 'ID of the interactive report region';
comment on column apex_application_page_ir.number_of_columns            is 'Total number of columns returned by the query for this report region';
comment on column apex_application_page_ir.number_of_column_groups      is 'Number of defined column groups for this report region';
comment on column apex_application_page_ir.number_of_saved_reports      is 'Number of user-defined saved reports for this report region';
comment on column apex_application_page_ir.max_row_count                is 'Maximum number of rows to query before sorting';
comment on column apex_application_page_ir.max_row_count_message        is 'Message to display if the maximum number of rows is exceeded';
comment on column apex_application_page_ir.no_data_found_message        is 'Message to display when no rows are returned by the report query';
comment on column apex_application_page_ir.max_rows_per_page            is 'Maximum number of rows to display on a single HTML page.  The Rows select list will not display any values higher than this amount.';
comment on column apex_application_page_ir.search_button_label          is 'Text to use for the search button label';
comment on column apex_application_page_ir.page_items_to_submit         is 'List of page items values which are submitted when the search button is clicked';
comment on column apex_application_page_ir.sort_asc_image               is 'Defines the image shown in report headings to sort column values in ascending order.';
comment on column apex_application_page_ir.sort_asc_image_attr          is 'Image attributes for sort images used to define attributes such width and height of image.';
comment on column apex_application_page_ir.sort_desc_image              is 'Defines the image shown in report headings to sort column values in descending order.';
comment on column apex_application_page_ir.sort_desc_image_attr         is 'Image attributes for sort images used to define attributes such width and height of image.';
comment on column apex_application_page_ir.sql_query                    is 'Query used as the base for this interactive report region.  The original query will be preserved as a subquery in the actual SQL used for the report';
comment on column apex_application_page_ir.show_nulls_as                is 'Identifies the text to display for null columns. The default value is "-".';
comment on column apex_application_page_ir.pagination_scheme            is 'Identifies the pagination style to use for this report';
comment on column apex_application_page_ir.pagination_display_position  is 'Identifies the position of pagination links relative to this report';
comment on column apex_application_page_ir.button_template              is 'Optionally identifies the button template to use in place of the generic buttons';
comment on column apex_application_page_ir.show_finder_drop_down        is 'Determines whether to display the drop down to the left of the search field';
comment on column apex_application_page_ir.show_display_row_count       is 'Determines whether to display the row count selector in the Search Bar';
comment on column apex_application_page_ir.show_search_bar              is 'Determines whether to display the Search Bar for the interactive report';
comment on column apex_application_page_ir.show_search_textbox          is 'Determines whether to allow searching from the Search Bar';
comment on column apex_application_page_ir.show_actions_menu            is 'Determines whether to display the Actions Menu and Actions Menu icon in the Search Bar';
comment on column apex_application_page_ir.actions_menu_icon            is 'Identifies the icon used for the Actions Menu.  The default icon is a green gear.';
comment on column apex_application_page_ir.finder_icon                  is 'Identifies the icon displayed on the left of the Search Bar.  The default icon is a magnifying glass.';
comment on column apex_application_page_ir.show_reports_as_tabs         is 'Determines whether saved reports are displayed as tabs.';
comment on column apex_application_page_ir.show_select_columns          is 'Determines whether to show the Select Columns option in the Actions Menu';
comment on column apex_application_page_ir.show_filter                  is 'Determines whether to show the Filter option in the Actions Menu';
comment on column apex_application_page_ir.show_sort                    is 'Determines whether to show the Sort option in the Actions Menu';
comment on column apex_application_page_ir.show_control_break           is 'Determines whether to show the Control option in the Actions Menu';
comment on column apex_application_page_ir.show_highlight               is 'Determines whether to show the Highlight option in the Actions Menu';
comment on column apex_application_page_ir.show_compute                 is 'Determines whether to show the Compute option in the Actions Menu';
comment on column apex_application_page_ir.show_aggregate               is 'Determines whether to show the Aggregate option in the Actions Menu';
comment on column apex_application_page_ir.show_chart                   is 'Determines whether to show the Chart option in the Actions Menu';
comment on column apex_application_page_ir.show_flashback               is 'Determines whether to show the Flashback option in the Actions Menu';
comment on column apex_application_page_ir.show_save                    is 'Determines whether to show the Save Report option in the Actions Menu';
comment on column apex_application_page_ir.show_reset                   is 'Determines whether to show the Reset option in the Actions Menu';
comment on column apex_application_page_ir.show_download                is 'Determines whether to show the Download option in the Actions Menu';
comment on column apex_application_page_ir.show_help                    is 'Determines whether to show the Help option in the Actions Menu';
comment on column apex_application_page_ir.download_formats             is 'Identifies the download formats supported for this interactive report';
comment on column apex_application_page_ir.filename                     is 'Identifies the filename prefix used when this report data is downloaded';
comment on column apex_application_page_ir.separator                    is 'Identifies a column separator. If no value is entered, a comma or semicolon is used depending on your current NLS settings.';
comment on column apex_application_page_ir.enclosed_by                  is 'Identifies a delimiter character. This character is used to delineate the starting and ending boundary of a data value. Default delimiter is double quotes.';
comment on column apex_application_page_ir.detail_link_type             is 'Identifies the type of link to display in the Link Column on the left of the interactive report';
comment on column apex_application_page_ir.detail_link_target           is 'Target of the Link Column, if a custom target is defined';
comment on column apex_application_page_ir.detail_link_text             is 'Text or HTML to display in the Link Column';
comment on column apex_application_page_ir.detail_link_attributes       is 'Link attributes for the Link Column.  Displayed within the HTML "A" tag';
comment on column apex_application_page_ir.detail_link_checksum_type    is 'An appropriate checksum when linking to protected pages';
comment on column apex_application_page_ir.detail_link_condition_type   is 'For conditionally displayed Link Column; identifies the condition type to evaluate';
comment on column apex_application_page_ir.detail_link_cond_expression  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_ir.detail_link_cond_expression2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_ir.detail_link_auth_scheme      is 'This authorization scheme must evaluate to TRUE in order for this page to be displayed';
comment on column apex_application_page_ir.detail_link_auth_scheme_id   is 'Foreign Key';
comment on column apex_application_page_ir.alias                        is 'Alias for this interactive report, may be used for API references';
comment on column apex_application_page_ir.report_id_item               is 'Item which holds the saved report ID to display';
comment on column apex_application_page_ir.max_query_cost               is 'Prevent execution of queries that are estimated to take longer than specified amount of time.';
comment on column apex_application_page_ir.created_on                   is 'Auditing; date the record was created.';
comment on column apex_application_page_ir.created_by                   is 'Auditing; user that created the record.';
comment on column apex_application_page_ir.updated_on                   is 'Auditing; date the record was last modified.';
comment on column apex_application_page_ir.updated_by                   is 'Auditing; user that last modified the record.';
comment on column apex_application_page_ir.component_signature          is 'Identifies attributes defined at a given component level to facilitate application comparisons';

create or replace view apex_application_page_ir_col
as
select
w.short_name                workspace,
f.id                        application_id,
f.name                      application_name,
c.page_id                   page_id,
ir.id                       interactive_report_id,
c.id                        column_id,
c.db_column_name            column_alias,
c.display_order             display_order,
(select name from wwv_flow_worksheet_col_groups where id = c.group_id) column_group,
c.group_id                  column_group_id,
c.report_label              report_label,
c.column_label              form_label,
c.column_link               ,
c.column_linktext           ,
c.column_link_attr          ,
c.column_link_checksum_type ,
--
decode(c.allow_sorting     ,'Y','Yes','N','No',c.allow_sorting     ) allow_sorting     ,
decode(c.allow_filtering   ,'Y','Yes','N','No',c.allow_filtering   ) allow_filtering   ,
decode(c.allow_ctrl_breaks ,'Y','Yes','N','No',c.allow_ctrl_breaks ) allow_ctrl_breaks ,
decode(c.allow_aggregations,'Y','Yes','N','No',c.allow_aggregations) allow_aggregations,
decode(c.allow_computations,'Y','Yes','N','No',c.allow_computations) allow_computations,
decode(c.allow_charting    ,'Y','Yes','N','No',c.allow_charting    ) allow_charting    ,
--
c.column_type               ,
c.display_text_as           ,
c.heading_alignment         ,
c.column_alignment          ,
c.format_mask               ,
--
decode(c.rpt_show_filter_lov,
       'D','Distinct Values Query',
       'S','Developer Defined LOV',
       'N','None',
       c.rpt_show_filter_lov)
                            filter_lov_source,
c.rpt_lov                   ,
c.rpt_filter_date_ranges    filter_date_ranges,
--
c.display_condition_type    ,
c.display_condition         ,
c.display_condition2        ,
--
c.help_text                 ,
--
decode(substr(c.SECURITY_SCHEME,1,1),'!','Not ')||
nvl((select name
 from   wwv_flow_security_schemes
 where  to_char(id) = ltrim(c.SECURITY_SCHEME,'!')
 and    flow_id = f.id),
 c.SECURITY_SCHEME)             authorization_scheme,
c.security_scheme               authorization_scheme_id,
c.column_expr,
--
c.created_on,
c.created_by,
c.updated_on,
c.updated_by,
--
'Interactive Report Column-'||
c.db_column_name||
' s='||c.display_order||
' g='||(select name from wwv_flow_worksheet_col_groups where id = c.group_id)||
' l='||c.report_label||
substr(c.column_label,1,30)||
substr(c.column_link,1,30)||
substr(c.column_linktext,1,30)||
substr(c.column_link_attr,1,30)||
c.column_link_checksum_type||
c.allow_sorting||
c.allow_filtering||
c.allow_ctrl_breaks||
c.allow_aggregations||
c.allow_computations||
c.allow_charting||
c.column_type||
c.display_text_as||
' ha='||c.heading_alignment||
' ca='||c.column_alignment||
' f='||c.format_mask||
c.rpt_show_filter_lov||
' lov='||length(c.rpt_lov)||
' d='||c.rpt_filter_date_ranges||
' cond='||c.display_condition_type||
length(c.display_condition)||
length(c.display_condition2)||
' h='||length(c.help_text)||
' as='||decode(substr(c.SECURITY_SCHEME,1,1),'!','Not ')||
nvl((select name
 from   wwv_flow_security_schemes
 where  to_char(id) = ltrim(c.SECURITY_SCHEME,'!')
 and    flow_id = f.id),
 c.SECURITY_SCHEME)
component_signature
from wwv_flow_worksheet_columns c,
     wwv_flow_worksheets ir,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = c.security_group_id and
      f.id = ir.flow_id and ir.id = c.worksheet_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

grant select on apex_application_page_ir_col to public;

comment on table  apex_application_page_ir_col                    is 'Report column definitions for interactive report columns';
comment on column apex_application_page_ir_col.workspace          is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_ir_col.application_id     is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_ir_col.application_name   is 'Identifies the application';
comment on column apex_application_page_ir_col.page_id            is 'Identifies the page';
comment on column apex_application_page_ir_col.interactive_report_id is 'ID of the interactive report';
comment on column apex_application_page_ir_col.column_id          is 'ID of this column';
comment on column apex_application_page_ir_col.column_alias       is 'Database column name or expression to use in SQL query when displaying this worksheet column';
comment on column apex_application_page_ir_col.display_order      is 'Default display order of this column';
comment on column apex_application_page_ir_col.column_group       is 'Name of the column group for this column';
comment on column apex_application_page_ir_col.column_group_id    is 'ID of the column group for this column';
comment on column apex_application_page_ir_col.report_label       is 'Report heading label to use for this column';
comment on column apex_application_page_ir_col.form_label         is 'Single row view label to use for this column';
comment on column apex_application_page_ir_col.column_link        is 'Optional link target for this column';
comment on column apex_application_page_ir_col.column_linktext    is 'Text do display if a link is defined';
comment on column apex_application_page_ir_col.column_link_attr   is 'Link attributes for the column link.  Displayed within the HTML "A" tag';
comment on column apex_application_page_ir_col.column_link_checksum_type is 'An appropriate checksum when linking to protected pages';
comment on column apex_application_page_ir_col.allow_sorting      is 'Determines whether to allow sorting for this column.';
comment on column apex_application_page_ir_col.allow_filtering    is 'Determines whether to allow filtering for this column.';
comment on column apex_application_page_ir_col.allow_ctrl_breaks  is 'Determines whether to allow control breaks for this column.';
comment on column apex_application_page_ir_col.allow_aggregations is 'Determines whether to allow aggregations for this column.';
comment on column apex_application_page_ir_col.allow_computations is 'Determines whether to allow computations for this column.';
comment on column apex_application_page_ir_col.allow_charting     is 'Determines whether to allow charting for this column.';
comment on column apex_application_page_ir_col.column_type        is 'Type of data in this column';
comment on column apex_application_page_ir_col.display_text_as    is 'Format to display this column';
comment on column apex_application_page_ir_col.heading_alignment  is 'Horizontal alignment of this column''s report heading';
comment on column apex_application_page_ir_col.column_alignment   is 'Horizontal alignment of this column''s report data';
comment on column apex_application_page_ir_col.format_mask        is 'Format mask for this column';
comment on column apex_application_page_ir_col.rpt_lov            is 'LOV query to display in filter dropdown';
comment on column apex_application_page_ir_col.filter_lov_source  is 'Query used to retrieve a list of values for the interactive report.  Displayed in the column header dropdowns, and during filter and highlight creation.';
comment on column apex_application_page_ir_col.filter_date_ranges is 'Determines the range of dates to display for filters on this column';
comment on column apex_application_page_ir_col.display_condition_type is 'For conditionally displayed this column; identifies the condition type to evaluate';
comment on column apex_application_page_ir_col.display_condition  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_ir_col.display_condition2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_ir_col.help_text          is 'Descriptive help text for this column, displayed when a user clicks on the column information icon';
comment on column apex_application_page_ir_col.authorization_scheme    is 'Optional authorization scheme determining whether this column and data is available to a user';
comment on column apex_application_page_ir_col.authorization_scheme_id is 'ID of the authorization scheme';
comment on column apex_application_page_ir_col.column_expr        is 'Attribute for internal use only';
comment on column apex_application_page_ir_col.created_on         is 'Auditing; date the record was created.';
comment on column apex_application_page_ir_col.created_by         is 'Auditing; user that created the record.';
comment on column apex_application_page_ir_col.updated_on         is 'Auditing; date the record was last modified.';
comment on column apex_application_page_ir_col.updated_by         is 'Auditing; user that last modified the record.';
comment on column apex_application_page_ir_col.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

create or replace view apex_application_page_ir_cgrps
as
select
w.short_name                workspace,
f.id                        application_id,
f.name                      application_name,
cg.worksheet_id             interactive_report_id,
cg.name                     column_group_name,
cg.description              column_group_description,
cg.display_sequence         display_sequence,
--
(select count(*) from wwv_flow_worksheet_columns where group_id = cg.id) columns,
--
cg.created_on                ,
cg.created_by                ,
cg.updated_on                ,
cg.updated_by
from wwv_flow_worksheet_col_groups cg,
     wwv_flow_worksheets ws,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = cg.security_group_id and
      f.id = ws.flow_id and ws.id = cg.worksheet_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

grant select on apex_application_page_ir_cgrps to public;

comment on table  apex_application_page_ir_cgrps                          is 'Column group definitions for interactive report columns';
comment on column apex_application_page_ir_cgrps.workspace                is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_ir_cgrps.application_id           is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_ir_cgrps.application_name         is 'Identifies the application';
comment on column apex_application_page_ir_cgrps.interactive_report_id    is 'ID of the interactive report';
comment on column apex_application_page_ir_cgrps.column_group_name        is 'Name of this column group, displayed on the single row view of this report and in the Select Columns dialog box';
comment on column apex_application_page_ir_cgrps.column_group_description is 'Description of this column group';
comment on column apex_application_page_ir_cgrps.display_sequence         is 'Display sequence of this column group';
comment on column apex_application_page_ir_cgrps.columns                  is 'Number of columns in this column group';
comment on column apex_application_page_ir_cgrps.created_on               is 'Auditing; date the record was created.';
comment on column apex_application_page_ir_cgrps.created_by               is 'Auditing; user that created the record.';
comment on column apex_application_page_ir_cgrps.updated_on               is 'Auditing; date the record was last modified.';
comment on column apex_application_page_ir_cgrps.updated_by               is 'Auditing; user that last modified the record.';


create or replace view apex_application_page_ir_rpt
as
select
w.short_name                 workspace,
f.id                         application_id,
f.name                       application_name,
r.page_id                    page_id,
r.worksheet_id               interactive_report_id,
r.id                         report_id,
r.application_user           application_user,
r.name                       report_name,
r.session_id                 ,
r.base_report_id             ,
r.description                report_description,
r.report_seq                 display_sequence,
r.report_type                report_view_mode,
r.status                     ,
r.category_id                ,
(case when r.is_default = 'Y' then 'DEFAULT'
      when r.session_id is null then 'USER SAVED'
 else 'SESSION' end)         report_type,
--
r.display_rows               ,
r.report_columns             ,
--
r.sort_column_1              ,
r.sort_direction_1           ,
r.sort_column_2              ,
r.sort_direction_2           ,
r.sort_column_3              ,
r.sort_direction_3           ,
r.sort_column_4              ,
r.sort_direction_4           ,
r.sort_column_5              ,
r.sort_direction_5           ,
r.sort_column_6              ,
r.sort_direction_6           ,
--
r.break_on                   ,
r.break_enabled_on           ,
--
r.sum_columns_on_break       ,
r.avg_columns_on_break       ,
r.max_columns_on_break       ,
r.min_columns_on_break       ,
r.median_columns_on_break    ,
r.count_columns_on_break     ,
--
r.flashback_mins_ago         flashback_minutes,
decode(r.flashback_enabled,'Y','Yes','N','No',r.flashback_enabled) flashback_enabled,
--
r.chart_type                 ,
r.chart_label_column         ,
r.chart_label_title          ,
r.chart_value_column         ,
r.chart_aggregate            ,
r.chart_value_title          ,
decode(r.chart_sorting,
       'DEFAULT','Default',
       'VALUE_DESC','Value - Descending',
       'VALUE_ASC','Value - Ascending',
       'LABEL_DESC','Label - Descending',
       'LAVEL_ASC','Label - Ascending',
       r.chart_sorting)  chart_sort_order,
--
r.created_on        ,
r.created_by        ,
r.updated_on        last_updated_on,
r.updated_by        last_updated_by
--
from wwv_flow_worksheet_rpts r,
     wwv_flow_worksheets ws,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = r.security_group_id and
      f.id = ws.flow_id and ws.id = r.worksheet_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

grant select on apex_application_page_ir_rpt to public;

comment on table  apex_application_page_ir_rpt                         is 'Identifies user-level report settings for an interactive report';
comment on column apex_application_page_ir_rpt.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_ir_rpt.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_ir_rpt.application_name        is 'Identifies the application';
comment on column apex_application_page_ir_rpt.page_id                 is 'Identifies page number';
comment on column apex_application_page_ir_rpt.interactive_report_id   is 'ID of the interactive report';
comment on column apex_application_page_ir_rpt.report_id               is 'ID of the report';
comment on column apex_application_page_ir_rpt.application_user        is 'The user these report settings are used by';
comment on column apex_application_page_ir_rpt.report_name             is 'The name of these report settings';
comment on column apex_application_page_ir_rpt.session_id              is 'For session-level report settings, the session ID associated with this record';
comment on column apex_application_page_ir_rpt.base_report_id          is 'For session-level report settings, the base report settings this record was derived from';
comment on column apex_application_page_ir_rpt.report_description      is 'The description given to the report';
comment on column apex_application_page_ir_rpt.display_sequence        is 'The order the report will appear in a list';
comment on column apex_application_page_ir_rpt.report_view_mode        is 'Identifies the current view settings of the report';
comment on column apex_application_page_ir_rpt.status                  is 'The shared status of these settings';
comment on column apex_application_page_ir_rpt.category_id             is 'The category_id of the report';
comment on column apex_application_page_ir_rpt.report_type             is 'Identifies whether this is a DEFAULT, USER SAVED, or SESSION based set of report settings';
comment on column apex_application_page_ir_rpt.display_rows            is 'Number of rows to display in the report';
comment on column apex_application_page_ir_rpt.report_columns          is 'List of columns to display in the report';
comment on column apex_application_page_ir_rpt.sort_column_1           is 'First column to sort by';
comment on column apex_application_page_ir_rpt.sort_direction_1        is 'Direction to use for first column sort';
comment on column apex_application_page_ir_rpt.sort_column_2           is 'First column to sort by';
comment on column apex_application_page_ir_rpt.sort_direction_2        is 'Direction to use for first column sort';
comment on column apex_application_page_ir_rpt.sort_column_3           is 'Second column to sort by';
comment on column apex_application_page_ir_rpt.sort_direction_3        is 'Direction to use for first column sort';
comment on column apex_application_page_ir_rpt.sort_column_4           is 'Third column to sort by';
comment on column apex_application_page_ir_rpt.sort_direction_4        is 'Direction to use for first column sort';
comment on column apex_application_page_ir_rpt.sort_column_5           is 'Fourth column to sort by';
comment on column apex_application_page_ir_rpt.sort_direction_5        is 'Direction to use for first column sort';
comment on column apex_application_page_ir_rpt.sort_column_6           is 'Fifth column to sort by';
comment on column apex_application_page_ir_rpt.sort_direction_6        is 'Direction to use for first column sort';
comment on column apex_application_page_ir_rpt.break_on                is 'Identifies a set of columns to break on';
comment on column apex_application_page_ir_rpt.break_enabled_on        is 'Identifies which control breaks are enabled';
comment on column apex_application_page_ir_rpt.sum_columns_on_break    is 'Identifies which columns to aggregate with a sum';
comment on column apex_application_page_ir_rpt.avg_columns_on_break    is 'Identifies which columns to aggregate with a avg';
comment on column apex_application_page_ir_rpt.max_columns_on_break    is 'Identifies which columns to aggregate with a max';
comment on column apex_application_page_ir_rpt.min_columns_on_break    is 'Identifies which columns to aggregate with a min';
comment on column apex_application_page_ir_rpt.median_columns_on_break is 'Identifies which columns to aggregate with a median';
comment on column apex_application_page_ir_rpt.count_columns_on_break  is 'Identifies which columns to aggregate with a count';
comment on column apex_application_page_ir_rpt.flashback_minutes       is 'Identifies the number of minutes to flashback in the query';
comment on column apex_application_page_ir_rpt.flashback_enabled       is 'Identifies whether flashback is enabled';
comment on column apex_application_page_ir_rpt.chart_type              is 'Identifies the current chart type';
comment on column apex_application_page_ir_rpt.chart_label_column      is 'Identifies the alias of the column to use as labels in a chart';
comment on column apex_application_page_ir_rpt.chart_label_title       is 'Text to use as the label axis title for a chart';
comment on column apex_application_page_ir_rpt.chart_value_column      is 'Identifies the alias of the column to use as values in a chart';
comment on column apex_application_page_ir_rpt.chart_aggregate         is 'Identifies an aggregation function to use on the values in the chart';
comment on column apex_application_page_ir_rpt.chart_value_title       is 'Text to use as the value axis title for a chart';
comment on column apex_application_page_ir_rpt.chart_sort_order        is 'Identifies the current chart sorting method';
comment on column apex_application_page_ir_rpt.created_on              is 'Auditing; date the record was created.';
comment on column apex_application_page_ir_rpt.created_by              is 'Auditing; user that created the record.';
comment on column apex_application_page_ir_rpt.last_updated_on         is 'Auditing; date the record was last modified.';
comment on column apex_application_page_ir_rpt.last_updated_by         is 'Auditing; user that last modified the record.';

create or replace view apex_application_page_ir_cond
as
select
w.short_name          workspace,
f.id                  application_id,
f.name                application_name,
r.page_id             page_id,
r.worksheet_id        interactive_report_id,
r.id                  report_id,
r.application_user    application_user,
r.name                report_name,
c.id                  condition_id,
c.name                condition_name,
decode(c.condition_type,'FILTER','Filter','HIGHLIGHT','Highlight','SEARCH','Search',c.condition_type)
                      condition_type,
-- filter expression
c.column_name         condition_column_name,
c.operator            condition_operator,
c.expr                condition_expression,
c.expr2               condition_expression2,
c.condition_sql       condition_sql,
c.condition_display   condition_display,
-- enabled?
decode(c.enabled,'Y','Yes','N','No',c.enabled)
                      condition_enabled,
-- highlighting settings
c.highlight_sequence  ,
c.row_bg_color        highlight_row_color,
c.row_font_color      highlight_row_font_color,
c.column_bg_color     highlight_cell_color,
c.column_font_color   highlight_cell_font_color,
-- audit
--
c.created_on        ,
c.created_by        ,
c.updated_on        last_updated_on,
c.updated_by        last_updated_by
--
from wwv_flow_worksheet_conditions c,
     wwv_flow_worksheet_rpts r,
     wwv_flow_worksheets ws,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = r.security_group_id and
      f.id = ws.flow_id and ws.id = r.worksheet_id and r.id = c.report_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

grant select on apex_application_page_ir_cond to public;

comment on table  apex_application_page_ir_cond                           is 'Identifies filters and highlights defined in user-level report settings for an interactive report';
comment on column apex_application_page_ir_cond.workspace                 is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_ir_cond.application_id            is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_ir_cond.application_name          is 'Identifies the application';
comment on column apex_application_page_ir_cond.page_id                   is 'Identifies page number';
comment on column apex_application_page_ir_cond.interactive_report_id     is 'ID of the interactive report';
comment on column apex_application_page_ir_cond.report_id                 is 'ID of the report';
comment on column apex_application_page_ir_cond.application_user          is 'The user these report settings are used by';
comment on column apex_application_page_ir_cond.report_name               is 'The name of these report settings';
comment on column apex_application_page_ir_cond.condition_id              is 'ID of this filter or highlight';
comment on column apex_application_page_ir_cond.condition_name            is 'Name of this filter or highlight';
comment on column apex_application_page_ir_cond.condition_type            is 'Identifies this as a filter or highlight condtiion';
comment on column apex_application_page_ir_cond.condition_column_name     is 'Alias of the column this condition is based on';
comment on column apex_application_page_ir_cond.condition_operator        is 'Operator used in this condition';
comment on column apex_application_page_ir_cond.condition_expression      is 'Expression used for this condition, depending on condition type.  This will be included in the report SQL as a bind variable';
comment on column apex_application_page_ir_cond.condition_expression2     is 'Expression used for this condition, depending on condition type.  This will be included in the report SQL as a bind variable';
comment on column apex_application_page_ir_cond.condition_sql             is 'Stored SQL expression to be used for this condition';
comment on column apex_application_page_ir_cond.condition_display         is 'Stored text expression representing this condition';
comment on column apex_application_page_ir_cond.condition_enabled         is 'Identifies whether this condition is enabled in the current report settings';
comment on column apex_application_page_ir_cond.highlight_sequence        is 'Determines the order a highlight rule is applied';
comment on column apex_application_page_ir_cond.highlight_row_color       is 'Determines the row background color for a row-level highlight rule';
comment on column apex_application_page_ir_cond.highlight_row_font_color  is 'Determines the row font color for a row-level highlight rule';
comment on column apex_application_page_ir_cond.highlight_cell_color      is 'Determines the cell background color for a cell-level highlight rule';
comment on column apex_application_page_ir_cond.highlight_cell_font_color is 'Determines the cell font color for a cell-level highlight rule';
comment on column apex_application_page_ir_cond.created_on                is 'Auditing; date the record was created.';
comment on column apex_application_page_ir_cond.created_by                is 'Auditing; user that created the record.';
comment on column apex_application_page_ir_cond.last_updated_on           is 'Auditing; date the record was last modified.';
comment on column apex_application_page_ir_cond.last_updated_by           is 'Auditing; user that last modified the record.';


create or replace view apex_application_page_ir_cat
as
select
w.short_name         workspace,
f.id                 application_id,
f.name               application_name,
c.worksheet_id       interactive_report_id,
c.id                 category_id,
c.name               category_name,
c.application_user   application_user,
c.base_cat_id        parent_category_id,
c.display_sequence   display_sequence
from wwv_flow_worksheet_categories c,
     wwv_flow_worksheets ws,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = s.security_group_id) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.security_group_id = w.PROVISIONING_COMPANY_ID and
      s.schema = f.owner and
      f.security_group_id = c.security_group_id and
      f.id = ws.flow_id and ws.id = c.worksheet_id and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      w.PROVISIONING_COMPANY_ID != 0 and
      (user in ('SYS','SYSTEM', 'APEX_030200') or w.PROVISIONING_COMPANY_ID != 10)
/

grant select on apex_application_page_ir_cat to public;

comment on table  apex_application_page_ir_cat                    is 'Report column category definitions for interactive report columns';
comment on column apex_application_page_ir_cat.workspace          is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_ir_cat.application_id     is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_ir_cat.application_name   is 'Identifies the application';
comment on column apex_application_page_ir_cat.interactive_report_id is 'ID of the interactive report';
comment on column apex_application_page_ir_cat.category_id        is 'ID of the category';
comment on column apex_application_page_ir_cat.category_name      is 'The name of the column category';
comment on column apex_application_page_ir_cat.parent_category_id is 'The id of the parent category';
comment on column apex_application_page_ir_cat.display_sequence   is 'The order the category will appear in a list';






create or replace view apex_component_signatures
as
select page_id,
page_name,
component,
component_name,
component_signature,
sum(decode(application_id,x.a1,1,0)) application_1,
sum(decode(application_id,x.a2,1,0)) application_2
from
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x,
(
select 'PAGE' component,
page_id,
page_name,
lpad(page_id,5,'00000')||'. '||page_title component_name,
component_signature,
application_id
from APEX_APPLICATION_PAGES,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='PAGE')
union all
select 'PAGE.VALIDATION' component,
page_id,
page_name,
VALIDATION_NAME component_name,
component_signature,
application_id
from APEX_APPLICATION_PAGE_VAL,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='PAGE.VALIDATION')
union all
select 'PAGE.BRANCH' component,
page_id,
page_name,
substr(BRANCH_ACTION,1,40)||length(branch_action) component_name,
component_signature,
application_id
from APEX_APPLICATION_PAGE_BRANCHES,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
 (nvl(x.c,'0')='0' or x.c='PAGE.BRANCH')
union all
select 'PAGE.COMPUTATION' component,
page_id,
page_name,
ITEM_NAME component_name,
component_signature,
application_id
from apex_application_page_comp,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='PAGE.COMPUTATION')
union all
select 'PAGE.PROCESS' component,
page_id,
page_name,
PROCESS_NAME component_name,
component_signature,
application_id
from APEX_APPLICATION_PAGE_PROC,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='PAGE.PROCESS')
union all
select 'PAGE.REGION' component,
page_id,
page_name,
region_name component_name,
component_signature,
application_id
from APEX_APPLICATION_PAGE_REGIONS,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='PAGE.REGION')
union all
select 'PAGE.ITEM' component,
page_id,
page_name,
item_name component_name,
component_signature,
application_id
from APEX_APPLICATION_PAGE_ITEMS,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='PAGE.ITEM')
union all
select 'PAGE.BUTTON' component,
page_id,
page_name,
button_name component_name,
component_signature,
application_id
from APEX_APPLICATION_PAGE_BUTTONS,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='PAGE.BUTTON')
union all
select 'AUTHENTICATION' component,
0 page_id,
null page_name,
'a' component_name,
component_signature,
application_id
from apex_application_auth,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='AUTHENTICATION')
union all
select 'LOV.ENTRY' component,
0 page_id,
null page_name,
LIST_OF_VALUES_NAME||'.'||substr(display_value,1,50) component_name,
component_signature,
application_id
from apex_application_lov_entries,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='LOV.ENTRY')
union all
select 'LOV' component,
0 page_id,
null page_name,
LIST_OF_VALUES_NAME component_name,
component_signature,
application_id
from APEX_APPLICATION_LOVS,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='LOV')
union all
select 'APPLICATION.PROCESS' component,
0 page_id,
null page_name,
process_name component_name,
component_signature,
application_id
from apex_application_processes,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='APPLICATION.PROCESS')
union all
select 'APPLICATION.COMPUTATION' component,
0 page_id,
null page_name,
computation_item component_name,
component_signature,
application_id
from apex_application_computations,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='APPLICATION.COMPUTATION')
union all
select 'NAVBAR' component,
0 page_id,
null page_name,
ICON_SUBTEXT component_name,
component_signature,
application_id
from APEX_APPLICATION_NAV_BAR,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='NAVBAR')
union all
select 'TAB' component,
t.tab_page page_id,
(select name from wwv_flow_steps where flow_id=t.application_id and id=t.tab_page) page_name,
tab_name component_name,
component_signature,
application_id
from apex_application_tabs t,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TAB')
union all
select 'PARENT.TAB' component,
0 page_id,
null page_name,
tab_name component_name,
component_signature,
application_id
from apex_application_parent_tabs t,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='PARENT.TAB')
union all
select 'BREADCRUMB' component,
0 page_id,
null page_name,
BREADCRUMB_NAME component_name,
component_signature,
application_id
from APEX_APPLICATION_BREADCRUMBS,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='BREADCRUMB')
union all
select 'LIST' component,
0 page_id,
null page_name,
LIST_NAME component_name,
component_signature,
application_id
from apex_application_lists,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='LIST')
union all
select 'LIST.ENTRY' component,
 0 page_id,
null page_name,
list_name||'.'||entry_text component_name,
component_signature,
application_id
from apex_application_list_entries,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='LIST.ENTRY')
union all
select 'TREE' component,
0 page_id,
null page_name,
tree_name component_name,
component_signature,
application_id
from apex_application_trees,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TREE')
union all
select 'SHORTCUT' component,
0 page_id,
null page_name,
shortcut_name component_name,
component_signature,
application_id
from apex_application_shortcuts,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='SHORTCUT')
union all
select 'APPLICATION.ITEM' component,
0 page_id,
null page_name,
ITEM_NAME component_name,
component_signature,
application_id
from apex_application_items,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='APPLICATION.ITEM')
union all
select 'BUILD.OPTION' component,
0 page_id,
null page_name,
build_option_name component_name,
component_signature,
application_id
from apex_application_build_options,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='BUILD.OPTION')
union all
select 'BREADCRUMB.ENTRY' component,
DEFINED_FOR_PAGE page_id,
(select name from wwv_flow_steps where id = DEFINED_FOR_PAGE and flow_id = application_id) page_name,
ENTRY_LABEL component_name,
component_signature,
application_id
from APEX_APPLICATION_BC_ENTRIES,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='BREADCRUMB.ENTRY')
union all
select 'APPLICATION.ATTRIBUTES' component,
0 page_id,
null page_name,
application_name component_name,
component_signature,
application_id
from APEX_APPLICATIONS,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='APPLICATION.ATTRIBUTES')
union all
select 'PAGE.REGION' component,
       page_id,
       (select name from wwv_flow_steps where id = v.page_id and flow_id = v.application_id) page_name,
       (select plug_name from wwv_flow_page_plugs where flow_id = v.application_id and id = v.region_id)||' - IR' component_name,
       component_signature,
       application_id
from   apex_application_page_ir v,
       (select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where  v.application_id in (x.a1,x.a2) and
       (nvl(x.c,'0')='0' or x.c='PAGE.REGION')
union all
select 'REPORT.COLUMN' component,
       page_id,
       (select name from wwv_flow_steps where id = v.page_id and flow_id = v.application_id) page_name,
       v.report_label component_name,
       component_signature,
       application_id
from   apex_application_page_ir_col v,
       (select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where  v.application_id in (x.a1,x.a2) and
       (nvl(x.c,'0')='0' or x.c='REPORT.COLUMN')
union all
select 'REPORT.COLUMN' component,
page_id,
page_name,
REGION_NAME||'.'||substr(column_alias,1,255) component_name,
component_signature,
application_id
from apex_application_page_rpt_cols,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='REPORT.COLUMN')
union all
select 'AUTHORIZATION' component,
0 page_id,
null page_name,
AUTHORIZATION_SCHEME_NAME component_name,
component_signature,
application_id
from apex_application_authorization,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='AUTHORIZATION')
union all
select 'THEME' component,
0 page_id,
null page_name,
theme_name component_name,
component_signature,
application_id
from apex_application_themes,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='THEME')
union all
select 'TEMPLATE.CALENDAR' component,
0 page_id,
null page_name,
template_name component_name,
component_signature,
application_id
from apex_application_temp_calendar,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TEMPLATE.CALENDAR')
union all
select 'TEMPLATE.BUTTON' component,
0 page_id,
null page_name,
template_name component_name,
component_signature,
application_id
from apex_application_temp_button,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TEMPLATE.BUTTON')
union all
select 'TEMPLATE.POPUP' component,
0 page_id,
null page_name,
'POPUP' component_name,
component_signature,
application_id
from apex_application_temp_popuplov,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TEMPLATE.POPUP')
union all
select 'TEMPLATE.REPORT' component,
0 page_id,
null page_name,
template_name component_name,
component_signature,
application_id
from apex_application_temp_report,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TEMPLATE.REPORT')
union all
select 'TEMPLATE.BREADCRUMB' component,
0 page_id,
null page_name,
template_name component_name,
component_signature,
application_id
from apex_application_temp_bc,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TEMPLATE.BREADCRUMB')
union all
select 'TEMPLATE.LIST' component,
0 page_id,
null page_name,
template_name component_name,
component_signature,
application_id
from apex_application_temp_list,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TEMPLATE.LIST')
union all
select 'TEMPLATE.LABEL' component,
0 page_id,
null page_name,
template_name component_name,
component_signature,
application_id
from apex_application_temp_label,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TEMPLATE.LABEL')
union all
select 'TEMPLATE.REGION' component,
0 page_id,
null page_name,
template_name component_name,
component_signature,
application_id
from APEX_APPLICATION_TEMP_REGION,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TEMPLATE.REGION')
union all
select 'TEMPLATE.PAGE' component,
0 page_id,
null page_name,
template_name component_name,
component_signature,
application_id
from apex_application_temp_page,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='TEMPLATE.PAGE')
union all
select 'FLASH_CHART' component,
page_id,
page_name,
region_name||'.'||chart_type component_name,
component_signature,
application_id
from apex_application_page_flash_ch,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='FLASH_CHART')
union all
select 'FLASH_CHART.SERIES' component,
page_id,
page_name,
region_name||'.'||series_name component_name,
component_signature,
application_id
from apex_application_page_flash_s,
(select nv('APEX_APPLICATION_1') a1, nv('APEX_APPLICATION_2') a2, v('APEX_COMPONENT') c from dual) x
where application_id in (x.a1,x.a2) and
(nvl(x.c,'0')='0' or x.c='FLASH_CHART.SERIES')
) d
group by page_id, page_name, component, component_signature, component_name
/


comment on table apex_component_signatures is 'Identifies two applications using APEX_APPLICATION_1 and APEX_APPLICATION_2 session date, APEX_COMPONENT must be 0 (all), or the name of an APEX component';
comment on column apex_component_signatures.page_id is 'Identifies the page number for application components that are specific to a page';
comment on column apex_component_signatures.page_name is 'Identifies the page name for application components that are specific to a page name';
comment on column apex_component_signatures.component is 'Identifies the application component type';
comment on column apex_component_signatures.component_name is 'Identifies the application component name';
comment on column apex_component_signatures.component_signature is 'Identifies the signature of the components attributes';
comment on column apex_component_signatures.application_1 is 'Returns 1 if the component exists in application 1, returns 0 if not';
comment on column apex_component_signatures.application_2 is 'Returns 1 if the component exists in application 2, returns 0 if not';



-- for application builder

create or replace view apex_developer_audit_log
as
select
       flow_id              application_id,
       flow_user            developer,
       audit_date           audit_date,
       audit_date           updated,
       audit_action         audit_action,
       page_id              page_id,
       (select name
        from wwv_flow_steps
        where flow_id = a.flow_id and
            id = a.page_id) page_name,
       FLOW_TABLE           component,
       decode(FLOW_TABLE,
'WWV_FLOW_PAGE_PLUGS',(select plug_name from wwv_flow_page_plugs where id = a.flow_table_pk),
'WWV_FLOW_ITEMS',(select name from wwv_flow_items where id = a.flow_table_pk),
'WWV_FLOW_STEP_BRANCHES',(select substr(BRANCH_ACTION,1,50) BRANCH_ACTION from wwv_flow_step_branches where id=a.flow_table_pk),
'WWV_FLOW_PROCESSING',(select process_name from wwv_flow_processing where id=a.flow_table_pk),
'WWV_FLOW_TOPLEVEL_TABS',(select TAB_NAME from WWV_FLOW_TOPLEVEL_TABS where id=a.flow_table_pk),
'WWV_FLOW_LISTS_OF_VALUES_DATA',(select lov_return_value from WWV_FLOW_LIST_OF_VALUES_DATA where id=a.flow_table_pk),
'WWV_FLOW_STEP_ITEM_HELP',(select name from wwv_flow_step_items where id = (select flow_item_id from WWV_FLOW_STEP_ITEM_HELP where id=a.flow_table_pk)),
'WWV_FLOW_DEVELOPERS',(select USERID from WWV_FLOW_DEVELOPERS where id=a.flow_table_pk),
'WWV_FLOW_LISTS_OF_VALUES$',(select LOV_NAME from WWV_FLOW_LISTS_OF_VALUES$ where id=a.flow_table_pk),
'WWV_FLOW_PAGE_PLUG_TEMPLATES',(select PAGE_PLUG_TEMPLATE_NAME from WWV_FLOW_PAGE_PLUG_TEMPLATES where id=a.flow_table_pk),
'WWV_FLOWS',flow_id,
'WWV_FLOW_STEP_COMPUTATIONS',(select COMPUTATION_ITEM from WWV_FLOW_STEP_COMPUTATIONS where id=a.flow_table_pk),
'WWV_FLOW_CUSTOM_AUTH_SETUPS',(select NAME from WWV_FLOW_CUSTOM_AUTH_SETUPS where id=a.flow_table_pk),
'WWV_FLOW_ICON_BAR',(select ICON_SEQUENCE||'. '||ICON_SUBTEXT n from WWV_FLOW_ICON_BAR where id=a.flow_table_pk),
'WWV_FLOW_STEP_BUTTONS',(select BUTTON_NAME||' "'||BUTTON_IMAGE_ALT||'"' n from wwv_flow_step_buttons where id=a.flow_table_pk),
'WWV_FLOW_STEPS',flow_table_pk,
'WWV_FLOW_COMPUTATIONS',(select COMPUTATION_SEQUENCE||'. '||COMPUTATION_ITEM n from WWV_FLOW_COMPUTATIONS where id=a.flow_table_pk),
'WWV_FLOW_TEMPLATES',(select NAME from WWV_FLOW_TEMPLATES where id=a.flow_table_pk),
'WWV_FLOW_TABS',(select TAB_NAME||' "'||tab_text||'"' n from WWV_FLOW_TABS where id=a.flow_table_pk),
'WWV_FLOW_STEP_ITEMS',(select name from wwv_flow_step_items where id = a.flow_table_pk),
'WWV_FLOW_MESSAGES$',(select NAME from WWV_FLOW_MESSAGES$ where id = a.flow_table_pk),
'WWV_FLOW_LIST_ITEMS',(select LIST_ITEM_LINK_TEXT from wwv_flow_list_items where id=a.flow_table_pk),
'WWV_FLOW_STEP_VALIDATIONS',(select VALIDATION_SEQUENCE||'. '||VALIDATION_NAME n from WWV_FLOW_STEP_VALIDATIONS where id = a.flow_table_pk),
'WWV_FLOW_STEP_PROCESSING',(select process_name from wwv_flow_step_processing where id=a.flow_table_pk),
'WWV_FLOW_ROW_TEMPLATES',(select ROW_TEMPLATE_NAME from WWV_FLOW_ROW_TEMPLATES where id=a.flow_table_pk),
'WWV_FLOW_LISTS',(select NAME from WWV_FLOW_LISTS where id=a.flow_table_pk),
'WWV_FLOW_THEMES',(select theme_id||'. '||THEME_NAME n from WWV_FLOW_THEMES where id=a.flow_table_pk),
'WWV_FLOW_SHORTCUTS',(select SHORTCUT_NAME from WWV_FLOW_SHORTCUTS where id=a.flow_table_pk),
'WWV_FLOW_MENU_OPTIONS',(select short_name from wwv_flow_menu_options where id = a.flow_table_pk),
'WWV_FLOW_LIST_TEMPLATES',(select LIST_TEMPLATE_NAME from WWV_FLOW_LIST_TEMPLATES where id=a.flow_table_pk),
FLOW_TABLE_PK) component_name,
security_group_id,
flow_table_pk
from   wwv_flow_builder_audit_trail a
/


create or replace view apex_developer_activity_log
as
select
    w.short_name           workspace,
    f.ID                   application_id,
    f.NAME                 application_name,
    a.flow_user            developer,
    a.audit_date           audit_date,
    decode(a.audit_action,
       'I','Insert',
       'U','Update',
       'D','Delete',
       a.audit_action)     audit_action,
    a.page_id              page_id,
    (select name
     from wwv_flow_steps
     where flow_id = a.flow_id and
         id = a.page_id) page_name,
    --
    decode(a.flow_table,
       'WWV_FLOWS'	 	                , 'Application Attributes',
       'WWV_FLOW_COMPUTATIONS'        , 'Application Computation',
       'WWV_FLOW_CUSTOM_AUTH_SETUPS'  , 'Authentication Setups',
       'WWV_FLOW_DEVELOPERS'          , 'Application Developers (Administration)',
       'WWV_FLOW_EFFECTIVE_USERID_MAP', 'Effective User ID (Administration)',
       'WWV_FLOW_ENTRY_POINTS'        , 'Entry Points',
       'WWV_FLOW_ENTRY_POINT_ARGS'    , 'Entry Point Arguments',
       'WWV_FLOW_ICON_BAR'            , 'Navigation Bar',
       'WWV_FLOW_LISTS'               , 'Lists',
       'WWV_FLOW_ITEMS'               , 'Application Items',
       'WWV_FLOW_LISTS_OF_VALUES$'    , 'List of Values',
       'WWV_FLOW_LISTS_OF_VALUES_DATA', 'List of Values Entry',
       'WWV_FLOW_LIST_ITEMS'          , 'List Item',
       'WWV_FLOW_LIST_TEMPLATES'      , 'List Template',
       'WWV_FLOW_MENU_OPTIONS'        , 'Breadcrumb Entry',
       'WWV_FLOW_MESSAGES$'           , 'Messages',
       'WWV_FLOW_PAGE_PLUGS'          , 'Region Attributes',
       'WWV_FLOW_PAGE_PLUG_TEMPLATES' , 'Region Template',
       'WWV_FLOW_PATCHES'             , 'Build Options',
       'WWV_FLOW_PROCESSING'          , 'Application Process',
       'WWV_FLOW_ROW_TEMPLATES'       , 'Row Template',
       'WWV_FLOW_SHORTCUTS'           , 'Shortcuts',
       'WWV_FLOW_STEPS'               , 'Page Attributes',
       'WWV_FLOW_STEP_BRANCHES'       , 'Page Branch',
       'WWV_FLOW_STEP_BRANCH_ARGS'    , 'Page Branch Arguments',
       'WWV_FLOW_STEP_BUTTONS'        , 'Page Button',
       'WWV_FLOW_STEP_COMPUTATIONS'   , 'Page Computation',
       'WWV_FLOW_STEP_ITEMS'          , 'Page Item',
       'WWV_FLOW_STEP_ITEM_HELP'      , 'Page Item Help Text',
       'WWV_FLOW_STEP_PROCESSING'     , 'Page Process',
       'WWV_FLOW_STEP_VALIDATIONS'    , 'Page Validation',
       'WWV_FLOW_TABS'                , 'Tabs',
       'WWV_FLOW_TEMPLATES'           , 'Page Template',
       'WWV_FLOW_THEMES'              , 'Themes',
       'WWV_FLOW_TOPLEVEL_TABS'       , 'Parent Tab',
       a.flow_table) component,
       decode(FLOW_TABLE,
'WWV_FLOW_PAGE_PLUGS',(select plug_name from wwv_flow_page_plugs where id = a.flow_table_pk),
'WWV_FLOW_ITEMS',(select name from wwv_flow_items where id = a.flow_table_pk),
'WWV_FLOW_STEP_BRANCHES',(select substr(BRANCH_ACTION,1,50) BRANCH_ACTION from wwv_flow_step_branches where id=a.flow_table_pk),
'WWV_FLOW_PROCESSING',(select process_name from wwv_flow_processing where id=a.flow_table_pk),
'WWV_FLOW_TOPLEVEL_TABS',(select TAB_NAME from WWV_FLOW_TOPLEVEL_TABS where id=a.flow_table_pk),
'WWV_FLOW_LISTS_OF_VALUES_DATA',(select lov_return_value from WWV_FLOW_LIST_OF_VALUES_DATA where id=a.flow_table_pk),
'WWV_FLOW_STEP_ITEM_HELP',(select name from wwv_flow_step_items where id = (select flow_item_id from WWV_FLOW_STEP_ITEM_HELP where id=a.flow_table_pk)),
'WWV_FLOW_DEVELOPERS',(select USERID from WWV_FLOW_DEVELOPERS where id=a.flow_table_pk),
'WWV_FLOW_LISTS_OF_VALUES$',(select LOV_NAME from WWV_FLOW_LISTS_OF_VALUES$ where id=a.flow_table_pk),
'WWV_FLOW_PAGE_PLUG_TEMPLATES',(select PAGE_PLUG_TEMPLATE_NAME from WWV_FLOW_PAGE_PLUG_TEMPLATES where id=a.flow_table_pk),
'WWV_FLOWS',flow_id,
'WWV_FLOW_STEP_COMPUTATIONS',(select COMPUTATION_ITEM from WWV_FLOW_STEP_COMPUTATIONS where id=a.flow_table_pk),
'WWV_FLOW_CUSTOM_AUTH_SETUPS',(select NAME from WWV_FLOW_CUSTOM_AUTH_SETUPS where id=a.flow_table_pk),
'WWV_FLOW_ICON_BAR',(select ICON_SEQUENCE||'. '||ICON_SUBTEXT n from WWV_FLOW_ICON_BAR where id=a.flow_table_pk),
'WWV_FLOW_STEP_BUTTONS',(select BUTTON_NAME||' "'||BUTTON_IMAGE_ALT||'"' n from wwv_flow_step_buttons where id=a.flow_table_pk),
'WWV_FLOW_STEPS',flow_table_pk,
'WWV_FLOW_COMPUTATIONS',(select COMPUTATION_SEQUENCE||'. '||COMPUTATION_ITEM n from WWV_FLOW_COMPUTATIONS where id=a.flow_table_pk),
'WWV_FLOW_TEMPLATES',(select NAME from WWV_FLOW_TEMPLATES where id=a.flow_table_pk),
'WWV_FLOW_TABS',(select TAB_NAME||' "'||tab_text||'"' n from WWV_FLOW_TABS where id=a.flow_table_pk),
'WWV_FLOW_STEP_ITEMS',(select name from wwv_flow_step_items where id = a.flow_table_pk),
'WWV_FLOW_MESSAGES$',(select NAME from WWV_FLOW_MESSAGES$ where id = a.flow_table_pk),
'WWV_FLOW_LIST_ITEMS',(select LIST_ITEM_LINK_TEXT from wwv_flow_list_items where id=a.flow_table_pk),
'WWV_FLOW_STEP_VALIDATIONS',(select VALIDATION_SEQUENCE||'. '||VALIDATION_NAME n from WWV_FLOW_STEP_VALIDATIONS where id = a.flow_table_pk),
'WWV_FLOW_STEP_PROCESSING',(select process_name from wwv_flow_step_processing where id=a.flow_table_pk),
'WWV_FLOW_ROW_TEMPLATES',(select ROW_TEMPLATE_NAME from WWV_FLOW_ROW_TEMPLATES where id=a.flow_table_pk),
'WWV_FLOW_LISTS',(select NAME from WWV_FLOW_LISTS where id=a.flow_table_pk),
'WWV_FLOW_THEMES',(select theme_id||'. '||THEME_NAME n from WWV_FLOW_THEMES where id=a.flow_table_pk),
'WWV_FLOW_SHORTCUTS',(select SHORTCUT_NAME from WWV_FLOW_SHORTCUTS where id=a.flow_table_pk),
'WWV_FLOW_MENU_OPTIONS',(select short_name from wwv_flow_menu_options where id = a.flow_table_pk),
'WWV_FLOW_LIST_TEMPLATES',(select LIST_TEMPLATE_NAME from WWV_FLOW_LIST_TEMPLATES where id=a.flow_table_pk),
FLOW_TABLE_PK) component_name,
    a.security_group_id   workspace_id,
    a.flow_table_pk       component_id
from
     wwv_flow_builder_audit_trail a,
     wwv_flows f,
     wwv_flow_companies w,
     wwv_flow_company_schemas s,
     (select nvl(v('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.PROVISIONING_COMPANY_ID) and
      f.security_group_id = w.PROVISIONING_COMPANY_ID and
      f.security_group_id = s.SECURITY_GROUP_ID and
      s.schema = f.owner and
      (d.sgid != 0 or nvl(f.BUILD_STATUS,'x') != 'RUN_ONLY') and
      /* developers can not edit translated apps */      
      not exists (
        select 1 from wwv_flow_language_map m
        where m.translation_flow_id = f.id) and
      w.PROVISIONING_COMPANY_ID != 0 and
      a.flow_id = f.id
/

grant select on apex_developer_activity_log to public;

comment on table  apex_developer_activity_log is 'Identifies developer changes to applications';
comment on column apex_developer_activity_log.workspace_id        is 'Primary key that identifies the workspace';
comment on column apex_developer_activity_log.workspace           is 'A work area mapped to one or more database schemas';
comment on column apex_developer_activity_log.application_id      is 'Application Primary Key, Unique over all workspaces';
comment on column apex_developer_activity_log.application_name    is 'Identifies the application';
comment on column apex_developer_activity_log.DEVELOPER           is 'Developer who made the change';
comment on column apex_developer_activity_log.AUDIT_DATE          is 'Date of application component change';
comment on column apex_developer_activity_log.AUDIT_ACTION        is 'Insert, Update or Delete';
comment on column apex_developer_activity_log.PAGE_ID             is 'Identifies page number if component corresponds to a specific page';
comment on column apex_developer_activity_log.PAGE_NAME           is 'Identifies corresponding page name';
comment on column apex_developer_activity_log.COMPONENT           is 'The type of component changed';
comment on column apex_developer_activity_log.COMPONENT_NAME      is 'The name of the affected component';
comment on column apex_developer_activity_log.COMPONENT_ID        is 'The unique ID of the affected component';

create or replace view apex_release
as
select (select wwv_flows_release from dual) version_no,
       (select wwv_flows_version from dual) api_compatibility,
       (select wwv_flow_platform.get_preference('APEX_3_0_1_PATCH') from dual) patch_applied
  from dual
/

grant select on apex_release to public;

comment on table apex_release is 'Identifies this release of Application Express';
comment on column apex_release.version_no                         is 'The specific version number of this Application Express instance';
comment on column apex_release.api_compatibility                  is 'The version of the API that this release is compatible with for importing applications or components';
comment on column apex_release.patch_applied                      is 'The date a patch was applied if this instance was patched';


--------------------------------------------
-- UI DEFAULTS
--
create or replace view apex_ui_defaults_tables as
select schema,
       table_name,
       form_region_title,
       report_region_title,
       created_by,
       created_on,
       last_updated_by,
       last_updated_on
  from wwv_flow_hnt_table_info
 where schema = user
/

grant select on apex_ui_defaults_tables to public;

comment on table apex_ui_defaults_tables is                      'The User Interface Defaults for the tables within this schema.  Used by the wizards when generating applications.';
comment on column apex_ui_defaults_tables.schema is              'Schema owning table.';
comment on column apex_ui_defaults_tables.table_name is          'Name of table in the schema.';
comment on column apex_ui_defaults_tables.form_region_title is   'When creating a form based upon this table, this title will be used as the resulting region title.';
comment on column apex_ui_defaults_tables.report_region_title is 'When creating a report or tabular form based upon this table, this title will be used as the resulting region title.';
comment on column apex_ui_defaults_tables.created_by is          'Auditing; user that created the record.';
comment on column apex_ui_defaults_tables.created_on is          'Auditing; date the record was created.';
comment on column apex_ui_defaults_tables.last_updated_by is     'Auditing; user that last modified the record.';
comment on column apex_ui_defaults_tables.last_updated_on is     'Auditing; date the record was last modified.';


create or replace view apex_ui_defaults_columns as
select t.schema,
       t.table_name,
       c.column_name,
       c.label,
       c.help_text,
       c.mask_form,
       c.display_seq_form,
       c.display_in_form,
       c.display_as_form,
       c.display_as_tab_form,
       c.display_seq_report,
       c.display_in_report,
       c.display_as_report,
       c.mask_report,
       c.aggregate_by,
       c.default_value,
       c.required,
       c.alignment,
       c.display_width,
       c.max_width,
       c.height,
       c.group_by,
       c.searchable,
       c.lov_query,
       c.created_by,
       c.created_on,
       c.last_updated_by,
       c.last_updated_on
  from wwv_flow_hnt_column_info c,
       wwv_flow_hnt_table_info t
 where t.schema   = user
   and c.table_id = t.table_id
/

grant select on apex_ui_defaults_columns to public;

comment on table apex_ui_defaults_columns is 'The User Interface Defaults for the columns within this schema.';
comment on column apex_ui_defaults_columns.schema is 'Schema owning table.';
comment on column apex_ui_defaults_columns.table_name is 'The table associated with the user interface defaults.';
comment on column apex_ui_defaults_columns.column_name is 'The column associated with the user interface defaults.';
comment on column apex_ui_defaults_columns.label is 'When creating a form against this table or view, this will be used as the label for the item if this column is included. When creating a report or tabular form, this will be used as the column heading if this column is included.';
comment on column apex_ui_defaults_columns.help_text is 'When creating a form against this table or view, this becomes the help text for the resulting item.';
comment on column apex_ui_defaults_columns.mask_form is 'When creating a form against this table or view, this specifies the mask that will be applied to the item, such as 999-99-9999. This is not used for character based items.';
comment on column apex_ui_defaults_columns.display_seq_form is 'When creating a form against this table or view, this determines the sequence in which the columns will be displayed in the resulting form page.';
comment on column apex_ui_defaults_columns.display_in_form is 'When creating a form against this table or view, this determines whether this column will be displayed in the resulting form page.';
comment on column apex_ui_defaults_columns.display_as_form is 'When creating a form against this table or view, this determines the way the column will be displayed, such as text area or text field.';
comment on column apex_ui_defaults_columns.display_as_tab_form is 'When creating a tabular form against this table or view, this determines the way the column will be displayed, such as select list or popup LOV.';
comment on column apex_ui_defaults_columns.display_seq_report is 'When creating a report against this table or view, this determines the sequence in which the columns will be displayed in the resulting report.';
comment on column apex_ui_defaults_columns.display_in_report is 'When creating a report against this table or view, this determines whether this column will be displayed in the resulting report.';
comment on column apex_ui_defaults_columns.display_as_report is 'When creating a report against this table or view, this determines the way the column will be displayed, such as Standard Report Column or Display as Text (based on LOV).';
comment on column apex_ui_defaults_columns.mask_report is 'When creating a report against this table or view, this specifies the mask that will be applied against the data, such as 999-99-9999. This is not used for character based items.';
comment on column apex_ui_defaults_columns.aggregate_by is 'When creating a report against this table or view, this determines whether this column should be used for aggregation in reports and charts.';
comment on column apex_ui_defaults_columns.default_value is 'When creating a form against this table or view, this specifies the default value for the item resulting from this column.';
comment on column apex_ui_defaults_columns.required is 'When creating a form against this table or view, this specifies to generate a validation in which the resulting item must be NOT NULL.';
comment on column apex_ui_defaults_columns.alignment is 'When creating a report against this table or view, this determines the alignment for the resulting report column (left, center, or right).';
comment on column apex_ui_defaults_columns.display_width is 'When creating a form against this table or view, this specifies the display width of the item resulting from this column.';
comment on column apex_ui_defaults_columns.max_width is 'When creating a form against this table or view, this specifies the maximum string length that a user is allowed to enter in the item resulting from this column.';
comment on column apex_ui_defaults_columns.height is 'When creating a form against this table or view, this specifies the display height of the item resulting from this column.';
comment on column apex_ui_defaults_columns.group_by is 'When creating a report against this table or view, this determines whether this column should be used for group by functions.';
comment on column apex_ui_defaults_columns.searchable is 'When creating a report against this table or view, this determines whether the resulting report column is searchable.';
comment on column apex_ui_defaults_columns.lov_query is 'A query to be turned into a Named List of Values if this column is included in a Form, Report or Tabular Form and the column is displayed as a type that uses a List of Values (such as Radio Group or Select List).';
comment on column apex_ui_defaults_columns.created_by is 'Auditing; user that created the record.';
comment on column apex_ui_defaults_columns.created_on is 'Auditing; date the record was created.';
comment on column apex_ui_defaults_columns.last_updated_by is 'Auditing; user that last modified the record.';
comment on column apex_ui_defaults_columns.last_updated_on is 'Auditing; date the record was last modified.';


create or replace view apex_ui_defaults_lov_data as
select t.schema,
       t.table_name,
       c.column_name,
       l.lov_disp_sequence,
       l.lov_disp_value,
       l.lov_return_value,
       l.last_updated_by,
       l.last_updated_on
  from wwv_flow_hnt_lov_data l,
       wwv_flow_hnt_column_info c,
       wwv_flow_hnt_table_info t
 where t.schema    = user
   and l.column_id = c.column_id
   and c.table_id  = t.table_id
/

grant select on apex_ui_defaults_lov_data to public;

comment on table apex_ui_defaults_lov_data is 'If you create a form, report, or tabular form that includes this column and if the appropriate Display As Type is set to use a list of values (Radio Group or Select List) then a Named List of Values will be created within the application and will be referenced by the resulting item or report column.';
comment on column apex_ui_defaults_lov_data.schema is 'Schema owning table.';
comment on column apex_ui_defaults_lov_data.table_name is 'The table associated with the user interface defaults.';
comment on column apex_ui_defaults_lov_data.column_name is 'The column associated with the user interface defaults.';
comment on column apex_ui_defaults_lov_data.lov_disp_sequence is 'The display sequence of the static list of values record.';
comment on column apex_ui_defaults_lov_data.lov_disp_value is 'The display value of the static list of values record.';
comment on column apex_ui_defaults_lov_data.lov_return_value is 'The return value of the static list of values record.';
comment on column apex_ui_defaults_lov_data.last_updated_by is 'Auditing; user that last modified the record.';
comment on column apex_ui_defaults_lov_data.last_updated_on is 'Auditing; date the record was last modified.';


create or replace view apex_themes as
select x.theme_number,
       x.theme_name,
       x.theme_type,
       x.workspace,
       x.workspace_id
from (-- repository theme
      select 'Theme - '||i theme_name,
             i theme_number,
             'BUILTIN' theme_type,
             null workspace,
             null workspace_id
      from wwv_flow_dual100
      where i <=20
      union all
      -- public theme
      select distinct htf.escape_sc(t.theme_name)||' - '||t.theme_id theme_name,
             theme_id theme_number,
             'PUBLIC' theme_type,
             null workspace,
             null workspace_id
      from wwv_flow_themes t,
           wwv_flow_companies w,
           wwv_flow_company_schemas s,
           (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
      where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.provisioning_company_id) and
            s.security_group_id = w.provisioning_company_id and
            (user in ('SYS','SYSTEM', 'APEX_030200') or w.provisioning_company_id != 10) and
            t.security_group_id = 11 and
            t.theme_security_group_id is null
      union all
      -- workspace theme
      select distinct htf.escape_sc(t.theme_name)||' - '||t.theme_id theme_name,
             theme_id theme_number,
             'WORKSPACE' theme_type,
             w.short_name workspace,
             w.provisioning_company_id workspace_id
      from wwv_flow_themes t,
           wwv_flow_companies w,
           wwv_flow_company_schemas s,
           (select nvl(nv('FLOW_SECURITY_GROUP_ID'),0) sgid from dual) d
      where (s.schema = user or user in ('SYS','SYSTEM', 'APEX_030200')  or d.sgid = w.provisioning_company_id) and
            s.security_group_id = w.provisioning_company_id and
            (user in ('SYS','SYSTEM', 'APEX_030200') or w.provisioning_company_id != 10) and
            t.security_group_id = 11 and
            w.provisioning_company_id = t.theme_security_group_id and
            (t.theme_security_group_id = d.sgid or t.theme_security_group_id = s.security_group_id)
      ) x
order by 1
/

grant select on apex_themes to public;

comment on table  apex_themes                          is 'List of APEX built-in, public and workspace themes';
comment on column apex_themes.theme_number             is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_themes.theme_name               is 'Identifies the name of the theme';
comment on column apex_themes.theme_type               is 'Identifies the theme type as APEX built-in, public or workspace themes';
comment on column apex_themes.workspace                is 'Identifies a workspace where the theme exists';
comment on column apex_themes.workspace_id             is 'Identifies the primary key of the workspace where the theme exists';
