set define '^'
set verify off
prompt ...audit triggers

Rem  Copyright (c) Oracle Corporation 2000 - 2006. All Rights Reserved.
Rem
Rem    NAME
Rem      audit_trigger.sql
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem       jkallman 04/25/2006 - Created from original audit.sql (Bug 5070914)


create or replace trigger wwv_biu_flow_build_audit_t
    before insert or update on wwv_flow_builder_audit_trail
    for each row
begin
    --
    -- vpd
    --
    if :new.security_group_id is null then
       :new.security_group_id := nvl(wwv_flow_security.g_security_group_id,0);
    end if;
end;
/


prompt ...wwv_flows audit

create or replace trigger wwv_biu_flows_audit
    before insert or update or delete on wwv_flows
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then
       l_action := 'I';
    elsif updating then
       -- skip audit procedure call if update is just updating the audit column
       if :new.last_updated_on <> :old.last_updated_on then
           return;
       end if;
       l_action := 'U';
    else
       l_action := 'D';
    end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOWS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_flow_templates audit

create or replace trigger wwv_biu_flow_tmplts_audit
    before insert or update or delete on wwv_flow_templates
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then
       l_action := 'I';
    elsif updating then
       l_action := 'U';
    else
       l_action := 'D';
    end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_TEMPLATES',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors



prompt ...wwv_flow_icon_bar audit

create or replace trigger wwv_biu_flow_icon_bar_audit
    before insert or update or delete on wwv_flow_icon_bar
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then
       l_action := 'I';
    elsif updating then
       l_action := 'U';
    else
       l_action := 'D';
    end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_ICON_BAR',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_flow_processing audit

create or replace trigger wwv_biu_processing_audit
    before insert or update or delete on wwv_flow_processing
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then
       l_action := 'I';
    elsif updating then
       l_action := 'U';
    else
       l_action := 'D';
    end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_PROCESSING',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_flow_items audit

create or replace trigger wwv_biu_flow_items_audit
    before insert or update or delete on wwv_flow_items
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then
       l_action := 'I';
    elsif updating then
       l_action := 'U';
    else
       l_action := 'D';
    end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_ITEMS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors



prompt ...wwv_flow_computations audit
create or replace trigger wwv_biu_computations_audit
    before insert or update or delete on wwv_flow_computations
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_COMPUTATIONS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors





prompt ...wwv_flow_tabs audit
create or replace trigger wwv_biu_flow_tabs_audit
    before insert or update or delete on wwv_flow_tabs
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_TABS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors



prompt ...wwv_flow_toplevel_tabs audit

create or replace trigger wwv_biu_flow_tl_tabs_audit
    before insert or update or delete on wwv_flow_toplevel_tabs
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_TOPLEVEL_TABS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_flow_lists_of_values$ audit

create or replace trigger wwv_biu_flow_lov_audit
    before insert or update or delete on wwv_flow_lists_of_values$
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_LISTS_OF_VALUES$',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors



prompt ...wwv_flow_list_of_values_data audit

create or replace trigger wwv_biu_flow_lovd_audit
    before insert or update or delete on wwv_flow_list_of_values_data
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_LISTS_OF_VALUES_DATA',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors






prompt ...wwv_flow_steps audit

create or replace trigger wwv_biu_flow_steps_audit
    before insert or update or delete on wwv_flow_steps
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_STEPS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_flow_step_buttons audit

create or replace trigger wwv_biu_step_buttons_audit
    before insert or update or delete on wwv_flow_step_buttons
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_STEP_BUTTONS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors




prompt ...wwv_flow_step_branches audit

create or replace trigger wwv_biu_step_branches_audit
    before insert or update or delete on wwv_flow_step_branches
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_STEP_BRANCHES',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_flow_step_branch_args audit

create or replace trigger wwv_biu_step_branch_args_audit
    before insert or update or delete on wwv_flow_step_branch_args
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_STEP_BRANCH_ARGS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_flow_step_items audit

create or replace trigger wwv_biu_step_items_audit
    before insert or update or delete on wwv_flow_step_items
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_STEP_ITEMS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_biu_flow_menu_opt_audit

create or replace trigger wwv_biu_flow_menu_opt_audit
    before insert or update or delete on wwv_flow_menu_options
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_MENU_OPTIONS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors



prompt ...wwv_flow_step_computations audit

create or replace trigger wwv_biu_step_comp_audit
    before insert or update or delete on wwv_flow_step_computations
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_STEP_COMPUTATIONS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors



prompt ...wwv_flow_step_validations audit 

create or replace trigger wwv_biu_step_valid_audit
    before insert or update or delete on wwv_flow_step_validations
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_STEP_VALIDATIONS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_flow_step_processing audit

create or replace trigger wwv_biu_step_processing_audit
    before insert or update or delete on wwv_flow_step_processing
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_STEP_PROCESSING',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors



prompt ...wwv_flow_page_plug_templates audit

create or replace trigger wwv_biu_flowpageplugtemp_audit
    before insert or update or delete on wwv_flow_page_plug_templates
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_PAGE_PLUG_TEMPLATES',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors




prompt ...wwv_flow_row_templates audit

create or replace trigger wwv_biu_flowrowtmplts_audit
    before insert or update or delete on wwv_flow_row_templates
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_ROW_TEMPLATES',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors



prompt ...wwv_flow_list_templates audit

create or replace trigger wwv_biu_flowlisttmplts_audit
    before insert or update or delete on wwv_flow_list_templates
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_LIST_TEMPLATES',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors




prompt ...wwv_flow_page_plugs audit

create or replace trigger wwv_biu_flowpageplugs_audit
    before insert or update or delete on wwv_flow_page_plugs
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_PAGE_PLUGS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors





create or replace trigger wwv_biu_flow_messages_audit
    before insert or update or delete on wwv_flow_messages$
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_MESSAGES$',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_flow_patches audit (build options)

create or replace trigger wwv_biu_flow_patches_audit
    before insert or update or delete on wwv_flow_patches
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_PATCHES',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors



prompt ...wwv_flow_developers audit


create or replace trigger wwv_biu_flow_developers_audit
    before insert or update or delete on wwv_flow_developers
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_DEVELOPERS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors







prompt ...wwv_flow_lists audit

create or replace trigger wwv_biu_flow_lists_audit
    before insert or update or delete on wwv_flow_lists
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_LISTS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors




prompt ...wwv_flow_list_items audit

create or replace trigger wwv_biu_flow_list_items_audit
    before insert or update or delete on wwv_flow_list_items
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_LIST_ITEMS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors




prompt ...wwv_flow_lov_values

create or replace trigger wwv_biu_flow_lov_val_audit
    before insert or update or delete on wwv_flow_lov_values
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_PAGE_LOV_VALUES',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors





prompt ...wwv_flow_effective_userid_map audit

create or replace trigger wwv_biu_flw_eff_uid_map_audit
    before insert or update or delete on wwv_flow_effective_userid_map
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_EFFECTIVE_USERID_MAP',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...wwv_flow_shortcuts_audit

create or replace trigger wwv_biu_flow_shortcuts_audit
    before insert or update or delete on wwv_flow_shortcuts
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_SHORTCUTS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/

prompt ...wwv_flow_setp_item_help_audit

create or replace trigger wwv_biu_flow_step_item_help_a
    before insert or update or delete on wwv_flow_step_item_help
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_STEP_ITEM_HELP',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/

prompt ...wwv_flow_custom_auth_setups audit

create or replace trigger wwv_biu_flow_auth_setups_audit
    before insert or update or delete on wwv_flow_custom_auth_setups
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then
       l_action := 'I';
    elsif updating then
       l_action := 'U';
    else
       l_action := 'D';
    end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_CUSTOM_AUTH_SETUPS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/

show errors


prompt ...wwv_flow_entry_points audit

create or replace trigger wwv_biu_entry_points_audit
    before insert or update or delete on wwv_flow_entry_points
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_ENTRY_POINTS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors

prompt ...wwv_flow_entry_point_args audit

create or replace trigger wwv_biu_entry_point_args_audit
    before insert or update or delete on wwv_flow_entry_point_args
    for each row
declare
    l_action varchar2(1);
begin
    if inserting then l_action := 'I'; elsif updating then l_action := 'U'; else l_action := 'D'; end if;
    begin
    wwv_flow_audit.audit_action (
       p_table_name => 'WWV_FLOW_ENTRY_POINT_ARGS',
       p_action     => l_action,
       p_table_pk   => nvl(:old.id,:new.id));
    exception when others then null;
    end;
end;
/
show errors


prompt ...trigger wwv_biu_flowthemes_audit


create or replace trigger wwv_biu_flowthemes_audit
         before insert or update or delete on wwv_flow_themes 
         for each row 
declare 
    l_action varchar2(1); 
begin 
    if inserting then 
        l_action := 'I'; 
    elsif updating then 
        l_action := 'U'; 
    else 
        l_action := 'D'; 
    end if; 

     begin 
         wwv_flow_audit.audit_action ( 
            p_table_name => 'WWV_FLOW_THEMES', 
            p_action     => l_action, 
            p_table_pk   => nvl(:old.id,:new.id)); 
     exception when others then null; 
     end; 
end; 
/
