set define '^'
set verify off
prompt ...wwv_flow_copy_util

Rem    NAME
Rem      copyu.sql
Rem    Arguments:
Rem     1:  
Rem     2:
Rem     3:  Flow user
Rem    MODIFIED   (MM/DD/YYYY)
Rem     cbcho      03/04/2002 - Created
Rem     cbcho      03/14/2002 - Added copy_navbar
Rem     sspadafo   09/20/2002 - Added copy_auth_setup


create or replace package wwv_flow_copy_util
as
--  Copyright (c) Oracle Corporation 1999 - 2002. All Rights Reserved.
--
--
--    DESCRIPTION
--      Used to copy flow objects.
--
--    NOTES
--      
--    SECURITY
--      No grants, must be run as FLOW schema owner.
--
--    NOTES
--
--    INTERNATIONALIZATION
--      unknown
--
--    MULTI-CUSTOMER
--      unknown
--
--    CUSTOMER MAY CUSTOMIZE
--      NO
--
--    RUNTIME DEPLOYMENT: YES
--

procedure copy_shortcut (
   p_copy_from_flow_id  in number,
   p_flow_id            in varchar2,
   p_from_shortcut_id   in number,
   p_to_shortcut_name   in varchar2,
   p_to_shortcut_id     in number default null
   );

procedure copy_security_scheme (
   p_copy_from_flow_id   in number,
   p_flow_id             in varchar2,
   p_from_scheme_id      in number,
   p_to_scheme_name      in varchar2,
   p_to_scheme_id        in number default null
   );

procedure copy_navbar (
   p_copy_from_flow_id   in number,
   p_flow_id             in varchar2,
   p_from_navbar_id      in number,
   p_to_navbar_name      in varchar2,
   p_to_navbar_id        in number default null
   );
   
procedure copy_auth_setup (
   p_copy_from_flow_id   in number,
   p_flow_id             in varchar2,
   p_from_setup_id       in number,
   p_to_setup_name       in varchar2,
   p_to_setup_id         in number default null
   );
   
end wwv_flow_copy_util;
/
show error;