set define '^'
set verify off
prompt core_grants

Rem  Copyright (c) Oracle Corporation 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      core_grants.sql
Rem
Rem    DESCRIPTION
Rem      System and object grants for Application Express core (runtime) installation
Rem
Rem    NOTES
Rem
Rem
Rem
Rem    SCRIPT ARGUMENTS
Rem      None
Rem
Rem    RUNTIME DEPLOYMENT: Yes
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jkallman  07/09/2007 - Created
Rem      jstraub   07/10/2007 - Added grants to dba_users, sys.users$, v$database, dba_source, dba_cons_columns,
Rem                             dba_constraints, dba_views, dba_errors, dba_col_comments
Rem      jstraub   11/26/2007 - Added set termout on after select_catalog_role grant
Rem      jkallman  01/30/2008 - Add grants on sys.v_$sql_plan and sys.v_$sesstat
Rem      jkallman  01/31/2008 - Remove grant on sys.dbms_sys_sql
Rem      sspadafo  07/20/2008 - Remove "with grant option" from grant select on sys.user$ (Bug 7225208, 7229057)
Rem      sspadafo  07/20/2008 - Remove grant select catalog_role (Bug 7225208, 7229036)
Rem      sspadafo  07/30/2008 - Remove unnecessary set termout off/set termout on statements
Rem      jkallman  08/07/2008 - Move grant on sys.dba_free_space from dev_grants.sql to core_grant.sql (Bug 7308558)
Rem      jstraub   08/14/2008 - Added grant on DBMS_JOB
Rem      sspadafo  11/02/2008 - Added grant select on sys.dba_arguments, sys.dba_procedures (Bug 7270054)
Rem      sspadafo  11/03/2008 - Removed grant select on sys.dba_arguments, sys.dba_procedures, moved to dev_grants.sql (Bug 7270054)
Rem      sspadafo  11/11/2008 - Removed grant select any table (Bug 7270054)
Rem      jkallman  11/17/2008 - Move grant on sys.dba_triggers, sys.dba_dependencies from dev_grants.sql to core_grants.sql
Rem      jkallman  11/21/2008 - Added grant on sys.v_$instance
Rem      sspadafo  04/08/2009 - Removed "with grant option" from grant execute on sys.dbms_lob (Bug 8417472)
Rem      sspadafo  04/26/2009 - Added grants to APPUN for dbms_random, dbms_obfuscation_toolkit (Bug 8466721)

prompt ...grant APEX owner core privileges

grant select on sys.dba_users        to ^APPUN;
grant select on sys.user$            to ^APPUN;
grant select on sys.DBA_ROLE_PRIVS   to ^APPUN;
grant select on sys.V_$TIMER         to ^APPUN;
grant alter session                  to ^APPUN;
grant alter user                     to ^APPUN;
grant execute on sys.dbms_lock       to ^APPUN;
grant execute on sys.utl_http        to ^APPUN;
grant execute on sys.utl_smtp        to ^APPUN;
grant execute on sys.utl_file        to ^APPUN;
grant execute on sys.dbms_lob        to ^APPUN;
grant execute on sys.dbms_job        to ^APPUN;
grant execute on sys.dbms_registry   to ^APPUN;
grant execute on sys.dbms_random     to ^APPUN;
grant execute on sys.dbms_obfuscation_toolkit  to ^APPUN;
grant select on sys.dba_objects      to ^APPUN;
grant select on sys.dba_views to ^APPUN;
grant select on sys.dba_cons_columns to ^APPUN;
grant select on sys.dba_constraints to ^APPUN;
grant select on sys.dba_errors to ^APPUN;
grant select on sys.dba_col_comments to ^APPUN;
grant select on sys.dba_data_files   to ^APPUN;
grant select on sys.dba_sys_privs    to ^APPUN;
grant select on sys.dba_tab_privs    to ^APPUN;
grant select on sys.dba_tab_columns  to ^APPUN;
grant select on sys.dba_tablespaces  to ^APPUN;
grant select on sys.dba_tables       to ^APPUN;
grant select on sys.V_$SESSION       to ^APPUN;
grant select on sys.DBA_TABLES       to ^APPUN;
grant select on sys.DBA_TABLESPACES  to ^APPUN;
grant select on sys.v_$parameter     to ^APPUN;
grant select on sys.v_$database to ^APPUN;
grant select on sys.dba_ind_columns  to ^APPUN;
grant select on sys.dba_sequences    to ^APPUN;
grant select on sys.dba_source to ^APPUN;
grant select on sys.user_sys_privs to ^APPUN;
grant select on sys.user_role_privs to ^APPUN;
grant select on sys.all_users to ^APPUN;
grant select on sys.all_sequences to ^APPUN;
grant select on sys.all_tab_columns to ^APPUN;
grant select on sys.all_triggers to ^APPUN;
grant select on sys.all_constraints to ^APPUN;
grant select on sys.all_ind_columns to ^APPUN;
grant select on sys.all_errors to ^APPUN;
grant select on sys.all_dependencies to ^APPUN;
grant select on sys.all_synonyms to ^APPUN;
grant select on sys.all_cons_columns to ^APPUN;
grant select on sys.all_objects to ^APPUN;
grant select on sys.all_tables to ^APPUN;
grant select on sys.all_col_comments to ^APPUN;
grant select on sys.all_tab_comments to ^APPUN;
grant select on sys.all_views to ^APPUN;
grant select on sys.dba_jobs to ^APPUN;
grant select on sys.dba_segments to ^APPUN;
grant select on sys.dba_extents to ^APPUN;
grant select on sys.dba_lock to ^APPUN;
grant select on sys.ts$ to ^APPUN;
grant select on sys.v_$sql_plan to ^APPUN;
grant select on sys.v_$sesstat to ^APPUN;
grant select on sys.dba_free_space to ^APPUN;
grant select on sys.dba_triggers to ^APPUN;
grant select on sys.dba_dependencies to ^APPUN;
grant select on sys.v_$instance to ^APPUN;


begin
    -- Grant execute on sys.dbms_crypto.  Silently fail if it does not exist
    execute immediate 'grant execute on sys.dbms_crypto to ^APPUN';
exception
    when others then
        null;
end;
/



grant execute on dbms_flashback to ^APPUN;
grant execute on dbms_rls to ^APPUN with grant option;
set termout off
grant execute on ctx_doc to ^APPUN with grant option;
grant execute on ctx_ddl to ^APPUN with grant option;

set termout on

grant create any context to ^APPUN with admin option;

grant create user                    to ^APPUN;
grant drop user                      to ^APPUN;
grant create role                    to ^APPUN;
grant create public synonym          to ^APPUN;
grant drop   public synonym          to ^APPUN;
grant connect                        to ^APPUN with admin option;
grant resource                       to ^APPUN with admin option;
grant create table                   to ^APPUN with admin option;
grant create tablespace              to ^APPUN;
grant drop tablespace                to ^APPUN;
grant create cluster                 to ^APPUN with admin option;
grant create dimension               to ^APPUN with admin option;
grant create indextype               to ^APPUN with admin option;
grant create materialized view       to ^APPUN with admin option;
grant create operator                to ^APPUN with admin option;
grant create procedure               to ^APPUN with admin option;
grant create sequence                to ^APPUN with admin option;
grant create snapshot                to ^APPUN with admin option;
grant create synonym                 to ^APPUN with admin option;
grant create trigger                 to ^APPUN with admin option;
grant create type                    to ^APPUN with admin option;
grant create view                    to ^APPUN with admin option;
grant alter database                 to ^APPUN;

begin
    for c1 in (select null
                 from v$instance
                where version like '1%') loop
        execute immediate 'grant create job to ^APPUN with admin option';
        exit;
    end loop;
end;
/


grant select on dba_data_files to ^APPUN;
grant select on dba_segments to ^APPUN;

prompt ...done grant APEX owner core privileges
