set define '^'
set verify off
prompt ...wwv_flow_css_api

Rem    NAME
Rem      cssapi_public.sql
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    Arguments:
Rem     1:  
Rem     2:
Rem     3:  Flow user
Rem
Rem    MODIFIED (MM/DD/YYYY)
Rem     sdillon  05/14/2001 - Created
Rem     sdillon  05/24/2001 - Removed unnecessary params to update_css
Rem     sdillon  05/24/2001 - Removed sec group id from new css repos record
Rem     jkallman 08/18/2003 - Remove write_css (Bug 3063954)
Rem     sspadafo 09/11/2004 - Add remove_css overloaded procedure (Bug 3821504)
Rem     jkallman 03/27/2006 - Add support for p_file_charset (Bug 5116366)
Rem     sspadafo 06/24/2006 - Created as copy of css.sql. Package wwv_flow_css_api will now be only for publicly exposed entry points. (Bug 5308534)


create or replace package wwv_flow_css_api
as

/*
 * Create a new css_repository entry, returns unique id for 
 *  wwv_flow_css_repository table.
 */
function new_css_repository_record(
    p_name                  in out varchar2,
    p_varchar2_table            in dbms_sql.varchar2_table,
    p_mimetype                  in varchar2,
    p_flow_id                   in number,
    p_notes                     in varchar2)
    return number
    ;
    

--
-- F I L E S Y S T E M   I N T E G R A T I O N
--

/* 
 * pass in the css id of the wwv_flow_css_repository record representing
 *  the css file you want to drop. If this css does not exist according to the
 *  wwv_flow_css_repository table, this will fail.
 */
--
-- remove by name
--
procedure remove_css(
    p_css_name                  in varchar2)
    ;
    
end wwv_flow_css_api;
/
show error
