set define '^'
set verify off
prompt ...wwv_flow_file_mgr

Rem    SCRIPT ARGUMENTS
Rem      1:
Rem      2:
Rem      3:  Flow Schema Owner
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem     jkallman   12/14/2000 - Created
Rem     mhichwa    01/18/2001 - Added grant
Rem     jkallman   02/02/2001 - Added get_file
Rem     rmattama   02/26/2003 - Added p_inline parm to get_file for content disposition
Rem     jkallman   08/18/2003 - Added get_file by fname and sgid (Bug 3063954)
Rem     jkallman   08/19/2003 - Added p_inline and p_flow_id to get_file (Bug 3063954)
Rem     sspadafo   06/25/2004 - Add get_file_id (Bug 3449543)
Rem     mhichwa    02/04/2008 - Added show_download_format_page to aid in editing download format masks
Rem     mhichwa    02/06/2008 - Added procedure show_item_download_page bug 6801990
Rem     arayner    10/29/2008 - Changed get_file_id parameter p_fname to be p_name (bug 7201348)    

Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    NOTES
Rem       Using this package, the settings in the DAD configuration should
Rem       be as follows:
Rem
Rem       Document Table:                        flows.wwv_flow_file_objects$
Rem       Document Access Path:                  docs
Rem       Document Access Procedure:             flows.wwv_flow_file_mgr.process_download
Rem       Extensions to be uploaded as Long Raw: 
Rem 


create or replace package wwv_flow_file_mgr
as

-- Copyright (c) Oracle Corporation 2000-2008. All Rights Reserved.
--
--    DESCRIPTION
--      File Upload/Download services
--
--    SECURITY
--      
--    NOTES
--      Package Body should be wrapped
--

procedure show_item_download_page (
    p_format       in varchar2 default null)
    ;

procedure show_download_format_page (
    p_format       in varchar2 default null)
    ;

function get_file_id(
    p_name in varchar2)
    return number
    ;
    
procedure process_download
    ;

procedure get_file( 
    p_id        in varchar2,
    p_mime_type in varchar2 default null,
    p_inline    in varchar2 default 'NO' );

procedure get_file(
    p_fname             in varchar2,
    p_security_group_id in varchar2,
    p_flow_id           in varchar2 default null,
    p_inline            in varchar2 default 'YES' );


end wwv_flow_file_mgr;
/
show errors


grant execute on wwv_flow_file_mgr to public;
