set define '^'
set verify off
prompt ...wwv_flow

Rem NAME
Rem      flow.sql
Rem
Rem    SCRIPT ARGUMENTS
Rem      1:
Rem      2:
Rem      3:  Flow Schema Owner
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      mhichwa   08/04/1999 - Created
Rem      mhichwa   09/30/1999 - Removed g_show_reset global
Rem      mhichwa   10/09/1999 - Added g_last_query_text global for error reporting
Rem      mhichwa   10/09/1999 - Removed g_success_procedure, g_success_url
Rem      mhichwa   10/09/1999 - Removed g_step_sub_title_font_color
Rem      mhichwa   10/14/1999 - Added 10 extra inputs v26 ... v35
Rem      mhichwa   10/21/1999 - Added t01..t35 to allow 32k for textareas
Rem      mhichwa   10/21/1999 - Moved g_flow_schema_owner to spec from body
Rem      mhichwa   10/23/1999 - Added flow_language and flow_image_prefix
Rem      mhichwa   10/26/1999 - Added pagination globals flow_current_min_row, max_row, rows_fetched
Rem      mhichwa   11/08/1999 - Added g_current_tab, and g_non_current_tab, g_box, g_navigation_bar
Rem      mhichwa   11/23/1999 - Added g_tab_non_current_image, g_tab_image_attributes
Rem      mhichwa   11/30/1999 - Added g_template_success_message
Rem      mhichwa   11/30/1999 - Changed paint_buttons from a procedure to a function
Rem      mhichwa   12/01/1999 - Added g_body_title variable, g_current_image_tab, g_non_current_image_tab
Rem      mhichwa   12/06/1999 - Added g_message, attribute1,2,3,4
Rem      mhichwa   12/09/1999 - Added g_top level tab attributes and g_tab_target
Rem      mhichwa   12/13/1999 - Changed g_message to g_notification_message, added g_notification
Rem      mhichwa   12/13/1999 - Added g_default_button_position
Rem      mhichwa   12/15/1999 - Added display_condition to toplevel_tab: g_tab_parent_display_cond
Rem      mhichwa   12/19/1999 - Added g_before_header_branch_occured global
Rem      mhichwa   12/19/1999 - Added g_tab_also_current_for_pages global
Rem      mhichwa   01/08/2000 - Added g_translated_flow_id and g_translated_page_id
Rem      mhichwa   01/09/2000 - Depricated initial_occurs and max_occurances
Rem      mhichwa   01/12/2000 - Added page plug globals
Rem      mhichwa   01/20/2000 - Added g_error_template, g_user, g_authentication, g_login_url
Rem      mhichwa   01/21/2000 - Added g_session_cookie
Rem      mhichwa   01/21/2000 - Depricated g_session_last_changed_set
Rem      mhichwa   01/23/2000 - Added logout_url
Rem      mhichwa   01/24/2000 - Added g_public_url_prefix
Rem      mhichwa   01/24/2000 - Added an extra 5 input arguments making total of 40
Rem      mhichwa   01/25/2000 - Added 10 more input arguments
Rem      mhichwa   01/26/2000 - Externalized paint_formOpen, find_value_for functions and g_ok_to_cache_sql variable
Rem      mhichwa   01/26/2000 - Added g_item_plug_id, g_plug_id and g_button_plug_id
Rem      mhichwa   01/31/2000 - Added g_heading_bgcolor,g_font_size,g_font_face,g_table_bgcolor,tattr
Rem      mhichwa   01/31/2000 - Added g_plug_heading_bgcolor,table_bgcolor,font_size,header,footer
Rem      mhichwa   02/02/2000 - Change g_box from varchar2(4000) to varchar2(32767)
Rem      mhichwa   02/20/2000 - Added g_cookie_session_id global
Rem      mhichwa   02/21/2000 - Added g_popup_filter global
Rem      mhichwa   02/23/2000 - Added g_page_document_1 global
Rem      mhichwa   03/02/2000 - Added g_tab_plsql_condtion global
Rem      mhichwa   03/04/2000 - Renamed draw_box_open, close to draw_body_open, close
Rem      mhichwa   03/08/2000 - Added g_flow_version
Rem      mhichwa   03/09/2000 - Added g_user_known_as
Rem      mhichwa   03/16/2000 - Added button_redirect_url
Rem      mhichwa   03/22/2000 - Added p_perform_oracle_substitutions
Rem      mhichwa   04/26/2000 - Added g_page_text_generated
Rem      mhichwa   05/03/2000 - Added f01 - f10
Rem      mhichwa   05/07/2000 - Moved f01 before p_t41 (allows f01 to be 98 arg, not 108 arg)
Rem      mhichwa   05/08/2000 - Reversed above
Rem      mhichwa   05/08/2000 - Add g_subscriber_id
Rem      mhichwa   05/16/2000 - Added g_process_when_button_id
Rem      mhichwa   05/22/2000 - Added g_icon_onclick
Rem      mhichwa   05/23/2000 - Removed drop package
Rem      mhichwa   05/24/2000 - obsoleted g_icon_bar_ and g_page_document_1 added comments, reordered fields
Rem      mhichwa   05/26/2000 - Added wwv_flow.g_rownum per thoechst request
Rem      mhichwa   05/30/2000 - Added g_dbauth_url_prefix, g_proxy_server
Rem      mhichwa   05/30/2000 - Added update_cache_with_write
Rem      mhichwa   06/02/2000 - Added g_step_first_item
Rem      mhichwa   06/03/2000 - Added lov_null_text null_value
Rem      mhichwa   06/09/2000 - Added g_item_lov_translated
Rem      mhichwa   06/11/2000 - Added g_plug_display_when_cond_type g_public_user
Rem      mhichwa   06/12/2000 - Added g_current_user
Rem      mhichwa   06/13/2000 - Added g_item_display_when_type
Rem      mhichwa   06/15/2000 - Added g_tab_parent_display_cond_ty g_tab_plsql_condition_type
Rem      mhichwa   06/18/2000 - Added g_process_type
Rem      mhichwa   06/18/2000 - Added g_branch_when_button_id
Rem      mhichwa   07/03/2000 - Added g_plug_column_width
Rem      mhichwa   07/10/2000 - Added g_region_table_cattributes
Rem      mhichwa   08/16/2000 - Added g_item_source_post_computation
Rem      mhichwa   08/19/2000 - Extended help procedure
Rem      mhichwa   08/21/2000 - Added additional help procedure arguments.
Rem      mhichwa   09/03/2000 - Changed formatting of page help text.
Rem      mhichwa   09/19/2000 - Added g_flow_status
Rem      mhichwa   10/25/2000 - Added p 51 ... 60
Rem      mhichwa   10/30/2000 - Added page cache update alt api
Rem      mhichwa   10/30/2000 - Added fetch_item
Rem      mhichwa   11/09/2000 - Added p_trace
Rem      mhichwa   11/21/2000 - Added g_computation_id
Rem      mhichwa   12/07/2000 - Added g_vpd
Rem      mhichwa   12/15/2000 - Added g_tab_disp_cond_text and g_compute_when_text
Rem      mhichwa   12/18/2000 - Removed g_subscriber_id and g_session_created_*
Rem      mhichwa   12/20/2000 - Removed g_item_javascript and added g_item_security_scheme
Rem      mhichwa   12/20/2000 - Added p_component argument to public role check function
Rem      mhichwa   12/20/2000 - Added g_button_security_scheme, g_icon_security_scheme, g_tab_security_scheme
Rem      mhichwa   12/20/2000 - Added g_tab_security_scheme
Rem      mhichwa   12/22/2000 - Added g_security_scheme for flow level security schemes
Rem      mhichwa   12/22/2000 - Added reset security check cache
Rem      mhichwa   01/05/2001 - Added public security check
Rem      mhichwa   01/12/2001 - Added g item tag_attributes
Rem      mhichwa   01/16/2001 - Added g application_tab set
Rem      mhichwa   01/17/2001 - Added f11 - f20
Rem      mhichwa   01/27/2001 - Return company name function
Rem      mhichwa   02/11/2001 - Added two functions to get sequence and unique ids
Rem      mhichwa   02/14/2001 - Added sdillon code to insert into temp table values from strings
Rem      mhichwa   03/01/2001 - Added g button alignment
Rem      sdillon   03/02/2001 - Added g_job for jobs which are submitted to wwv_flow_job
Rem      mhichwa   03/03/2001 - Removed references to carot 3, added comments
Rem      mhichwa   03/03/2001 - Added public syn
Rem      mhichwa   03/04/2001 - Added get_custom_auth_login_url
Rem      mhichwa   03/15/2001 - Added no data found global
Rem      mhichwa   03/21/2001 - Added g user id
Rem      mhichwa   04/09/2001 - Added p company to show and accept procedures
Rem      mhichwa   04/10/2001 - Added button c attributes
Rem      mhichwa   04/17/2001 - Added total row global to enhance pagination
Rem      mhichwa   04/23/2001 - Added rejoin sessions variable
Rem      mhichwa   05/14/2001 - Removed g item accept processing global var
Rem      mhichwa   06/01/2001 - Added checksum function and md5 checksum show and accept arguments
Rem      mhichwa   06/04/2001 - Added assignment of md5 checksum to flow global.
Rem      mhichwa   06/04/2001 - Added get_sgid function to return sec grp id for use in views on obj dollar table
Rem      mhichwa   06/18/2001 - Added g item default type
Rem      mhichwa   06/18/2001 - Added api to clear user session state (clear user cache)
Rem      mhichwa   06/18/2001 - Improved documentation
Rem      mhichwa   07/20/2001 - Added g_flow_language_derived_from
Rem      mhichwa   08/13/2001 - Added x 01 through x 20 as input items that are to be ignored.  For use with local javascript.
Rem      mhichwa   08/23/2001 - Added global notification
Rem      mhichwa   08/24/2001 - Added a global for g_last_tab_pressed
Rem      mhichwa   08/27/2001 - Added last tab pressed argument to show procedure
Rem      mhichwa   08/27/2001 - Extended documentation of flows procedure
Rem      mhichwa   10/02/2001 - Edited comments for show procedure
Rem      mhichwa   10/15/2001 - Added flow checksum fcs accept argument
Rem      mhichwa   10/19/2001 - Added header and footer template globals
Rem      mhichwa   10/24/2001 - Added process when 2 and process when 2 type to extend declarative prog on page processes
Rem      mhichwa   11/08/2001 - Added g_error_message_override
Rem      mhichwa   11/12/2001 - Added g_head (wwv_flow_steps.html_page_header)
Rem      mhichwa   12/10/2001 - Added set_g_nls_date_format
Rem      mhichwa   12/12/2001 - Added g_process_security_scheme
Rem      mhichwa   12/17/2001 - Added g_flow_charset
Rem      mhichwa   12/18/2001 - Added g_branch_security_scheme
Rem      mhichwa   12/19/2001 - Added g_current_parent_tab_text
Rem      mhichwa   02/11/2002 - Added 2 stateful process procedures and one function (sspadafore design)
Rem      mhichwa   02/13/2002 - Added validation global (g_validation_ids_in_error)
Rem      mhichwa   02/14/2002 - Added another validation global (g_inline_validation_error_cnt)
Rem      mhichwa   02/14/2002 - Added tag_attributes2
Rem      mhichwa   02/19/2002 - Added post element text
Rem      mhichwa   03/05/2002 - Added process_sql_clob
Rem      sspadafo  03/18/2002 - Added fetch_flow_item function
Rem      mhichwa   03/18/2002 - Added g_page_submitted global variable
Rem      jkallman  03/28/2002 - Added definition of vc_long_arr
Rem      mhichwa   04/04/2002 - Removed obsolete icon bar attributes
Rem      mhichwa   04/17/2002 - Fixed inline notifications of type function returning err text by adding addtional global
Rem      mhichwa   05/01/2002 - Added lov_display_extra g_item_lov_display_extra support
Rem      mhichwa   05/07/2002 - Maded look static 1, and obsolete
Rem      mhichwa   05/08/2002 - Added 5 more arguments (now 65 are supported)
Rem      mhichwa   05/08/2002 - Added button condition 2
Rem      mhichwa   05/09/2002 - Added g_tab_parent_display_cond2
Rem      mhichwa   05/09/2002 - Added g_item_display_when2
Rem      mhichwa   05/09/2002 - Added g_company_images and g_flow_images
Rem      mhichwa   05/09/2002 - Added g_shortcut_name and g_shortcut_id
Rem      mhichwa   05/10/2002 - Remove obsolete globals
Rem      mhichwa   06/05/2002 - Added p_survey_map and g_survey_map
Rem      sspadafo  06/22/2002 - Added g_list_mgr_cnt global
Rem      cbcho     07/01/2002 - Added g_footer_len, g_footer_end, g_end_tag_printed global variables
Rem      mhichwa   07/08/2002 - Added g_f21..g_f40 and g_plug_form_tab_attr
Rem      sspadafo  07/10/2002 - Added clear_flow_cache, clear_page_cache, clear_page_caches procedures
Rem      mhichwa   08/08/2002 - Added g_flow_alias
Rem      mhichwa   08/09/2002 - Added plug_query_more_data
Rem      mhichwa   08/11/2002 - Added exact_substitutions_only
Rem      mhichwa   09/24/2002 - Added plug_customized
Rem      mhichwa   09/25/2002 - Added g_item_cattributes_element
Rem      msewtz    09/26/2002 - Added g_fsp_region_id for multiple region sorting
Rem      mhichwa   09/30/2002 - Added g_page_onload
Rem      mhichwa   10/07/2002 - Increased input args from 65 to 100.
Rem      mhichwa   10/25/2002 - Added g_item_read_only_when g_item_read_only_when_type g_item_read_only_disp_attr
Rem      mhichwa   10/25/2002 - Removed support for application tabs
Rem      mhichwa   10/29/2002 - Added g_unique_page_id
Rem      mhichwa   10/29/2002 - Changed some numbers into pls_integers
Rem      msewtz    10/31/2002 - Added g_plug_position to indicate top and bottom position for button conditions
Rem      tmuth     11/01/2002 - Removed reference to ^3, now using select user... technique
Rem      mhichwa   11/08/2002 - Changed comments
Rem      jkallman  11/21/2002 - Added g_nls_decimal_separator, set_g_nls_decimal_separator
Rem      mhichwa   11/21/2002 - Added map1 map2 and map3
Rem      mhichwa   11/25/2002 - Changed map1 to an array
Rem      mhichwa   11/25/2002 - Added map2 and map3 array
Rem      msewtz    12/04/2002 - Added constant g_browser_version and function get_browser_version
Rem      jkallman  12/27/2002 - Removed end_page_processing
Rem      sspadafo  12/27/2002 - Added g_db_session_branch_targets for before header branching (Bug 2729768)
Rem      sspadafo  12/28/2002 - Added g_branch_to_page_accept_count for recursion limiting (Bug 2729767)
Rem      sspadafo  01/06/2003 - Expose function replace_cgi_env (bug 2737645)
Rem      mhichwa   01/27/2003 - Added g_process_item_name (bug 2769756)
Rem      sspadafo  02/07/2003 - Added g_in_process boolean to prevent show from being called from page process (Bug 2776207)
Rem      sspadafo  02/23/2003 - Changes for template column name changes from varchar2 to number (Bug 2748399)
Rem      msewtz    02/26/2004 - Added g_pagination_buttons_painted to determine whether or not pagination buttons are painted (bug 2823270)
Rem      jstraub   03/10/2003 - Replaced select user with select sys_context( 'userenv', 'current_schema') for FLOW_OWNER
Rem      mhichwa   03/11/2003 - Added global g_edit_cookie_session_id which replace body local var (bug 2845535)
Rem      mhichwa   03/14/2003 - Added global g_form_painted boolean (bug 2851819)
Rem      mhichwa   03/18/2003 - Added comments to globals, no bug filed
Rem      mhichwa   03/18/2003 - Added pk array values for use in inline edits (bug 2845535)
Rem      mhichwa   03/30/2003 - Added g_print_success_message
Rem      jkallman  04/08/2003 - Added reset_g_nls_decimal_separator (Bug 2894573)
Rem      sspadafo  04/26/2003 - Removed refs to g_computation_item_type for page and flow computations (Bug 2770974)
Rem      mhichwa   05/02/2003 - Improved 508 compliance, added g_nls_edit, bug 2772858
Rem      mhichwa   05/22/2003 - Added returning globals to enhanced dml support, bug 2965281
Rem      mhichwa   05/22/2003 - Added process globals to identify items to return keys to, bug 2965281
Rem      tmuth     07/09/2003 - Fixed HTML per bug 3040191
Rem      sspadafo  07/12/2003 - Increase size of g_footer_end (Bug 3044360)
Rem      sspadafo  07/30/2003 - Add clear_app_cache as equivalent of clear_flow_cache (Bug 3077346)
Rem      sspadafo  07/30/2003 - Add fetch_app_item as equivalent of fetch_flow_item (Bug 3077346)
Rem      sspadafo  08/23/2003 - Add g_build_status (Bug 3101165)
Rem      msewtz    02/04/2003 - Added Tablar From Globals for handling popup items in tabular forms (bug 3268062)
Rem      mhichwa   05/26/2004 - Added g_template_navbar_entry global.
Rem      jkallman  05/25/2004 - Remove references to ^FLOW_OWNER
Rem      sspadafo  06/09/2004 - Add save_in_substitution_cache procedure, remove update_cache procedure (Bug 3674771)
Rem      sspadafo  06/09/2004 - Remove find_value_for function (Bug 3677443)
Rem      mhichwa   06/14/2004 - Added g_flow_theme_id global
Rem      mhichwa   06/17/2004 - Added function get_translated_app_id return number function
Rem      jkallman  06/18/2004 - Added get_nls_group_separator
Rem      jkallman  07/14/2004 - Added reset_g_nls_date_format
Rem      mhichwa   08/02/2004 - Added g_logo_image and g_logo_image_attributes
Rem      mhichwa   08/02/2004 - Added g_plug_list_template_id
Rem      jkallman  08/16/2004 - Added g_base_href, set_base_href, reset_base_href, get_base_href
Rem      mhichwa   09/15/2004 - Removed obsolete wwv_flow.g_step_box_image, bug 3892054
Rem      mhichwa   09/15/2004 - Remove obsolete substitutions g_attribute 1 - 6, bug 3892054
Rem      mhichwa   09/15/2004 - Remove obsolete substitution g_look, bug 3892054
Rem      mhichwa   09/15/2004 - Remove static link substitutions, bug 3892054
Rem      jkallman  01/05/2004 - Adjust g_flow_schema_owner
Rem      sspadafo  01/31/2005 - Increase g_logout_url to vc4000 (Bug 4155342)
Rem      sspadafo  02/08/2005 - Added globals for URL tampering feature
Rem      sspadafo  02/21/2005 - Added g_protected_item_internal_flag
Rem      sspadafo  03/08/2005 - Added g_substitution_item_filter and g_item_escape_on_http_input arrays
Rem      jkallman  09/14/2005 - Adjust g_flow_schema_owner to FLOWS_020100
Rem      jkallman  01/23/2006 - Adjust g_flow_schema_owner to FLOWS_020200
Rem      sspadafo  03/07/2006 - Added g_ex_context_authentication boolean (inspired by Bug 5028808)
Rem      mhichwa   03/17/2006 - Added g_arg_name and g_arg_value to optimize mod plsql performance
Rem      mhichwa   03/20/2006 - Improved commments
Rem      mhichwa   03/22/2006 - Improved xhtml
Rem      mhichwa   04/10/2006 - Removed obsolete function convert_display_id_to_flow_id
Rem      sspadafo  04/22/2006 - Added g_use_zero_sid for zero session ID feature
Rem      sspadafo  04/23/2006 - Added g_public_page_ids, g_public_auth_scheme for zero session ID feature
Rem      mhichwa   06/01/2006 - Added g_sqlerrm global to log errors encountered during execution of applications
Rem      mhichwa   06/02/2006 - Inititialize g_sqlerrm
Rem      mhichwa   06/05/2006 - Removed obsolete and commented out code
Rem      mhichwa   06/06/2006 - Added globals for error component name and type
Rem      mhichwa   06/09/2006 - Added g_cache page global to support page caching wwv_flow_steps.cache_page_yn
Rem      mhichwa   06/09/2006 - Added get_page_alias function for use in determining if you are a login page
Rem      mhichwa   06/09/2006 - Added is_custom_auth_page function
Rem      mhichwa   06/11/2006 - Added g_cache_mode global so cache mode can be logged to activity log
Rem      mhichwa   06/14/2006 - Improved code comments
Rem      sspadafo  06/22/2006 - Changed g_flow_schema_owner to constant to prevent alteration
Rem      jkallman  09/29/2006 - Adjust g_flow_schema_owner to FLOWS_030000
Rem      jstraub   12/13/2006 - Added g_wallet_path and g_wallet_pwd for SSL (HTTPS) support
Rem      mhichwa   12/21/2006 - Added g_plug_caching global to support page caching, referenced from meta.plb
Rem      mhichwa   12/21/2006 - Added g_cached_regions global
Rem      mhichwa   01/02/2006 - Added g_item_pre_element_text
Rem      mhichwa   01/02/2006 - Added g_cached_region_count global to track the number of regions rendered from cached representations
Rem      mhichwa   01/03/2006 - Added g_remote_addr
Rem      jstraub   01/03/2006 - Removed wallet globals, moved to platform preference
Rem      rvallam   01/08/2007 - Added a new global g_is_item_shuttle for checking if display_as is shuttle
Rem      rvallam   01/08/2007 - Global added for shuttle - g_is_item_shuttle removed, not needed.
Rem      jkallman  01/26/2007 - Added g_item_format_mask
Rem      mhichwa   01/30/2007 - Added support for region static id
Rem      sspadafo  07/31/2007 - Added f01..f20 parameters to show procedure
Rem      cbcho     08/02/2007 - Adjust g_flow_schema_owner to flows_030100
Rem      sspadafo  08/07/2007 - Added new globals g_widget_name, g_x01..g_x10, g_clob_01; added input params to show: p_widget_name, x01..x10, p_clob_01 for AJAX requests
Rem      cbackstr  09/25/2007 - Changed show to include p_widget_mod,p_widget_action,p_widget_action_mod and map to g_widget_mod,g_widget_action,g_widget_action_mod
Rem      cbackstr  10/09/2007 - Changed show to include g_widget_num_return
Rem      jkallman  10/15/2007 - Added globals g_media_type and g_step_media_type
Rem      jkallman  11/19/2007 - Added global g_date_format
Rem      mhichwa   11/26/2007 - Added g_include_apex_css_js_yn
Rem      mhichwa   11/29/2007 - Added g_proc_runtime_where_clause
Rem      sspadafo  12/03/2007 - Removed g_protected_item_ids, g_protected_item_internal_flag
Rem      mhichwa   12/10/2007 - Removed g_step_box_footer_text global also changed meta.plb, gen_api_pkg.plb and flow.plb
Rem      mhichwa   12/10/2007 - Removed g_box_width global
Rem      mhichwa   12/13/2007 - Added g_plug_att_sub
Rem      sspadafo  01/21/2008 - Changed type of g_unique_page_id from pls_integer to number to accommodate IDs larger than 2**31-1
Rem      sspadafo  01/23/2008 - Added overloaded version of trim_sql (Bug 6754391)
Rem      mhichwa   01/25/2008 - Added exec count global
Rem      jkallman  02/26/2008 - Removed fetch_item and fetch_value from specification
Rem      sspadafo  04/03/2008 - Added p_ignore_01..p_ignore_10 parameters to accept (Bug 6912467)
Rem      jkallman  09/09/2008 - Change FLOWS_030100 references to APEX_030200
Rem      jstraub   12/17/2008 - Added g_autocomplete_on_off
Rem      jkallman  12/17/1008 - Change default valut of p_before_region_html in procedure help()
Rem      jkallman  12/18/2008 - Added g_application_info 
Rem      jkallman  12/18/2008 - Added vc_assoc_arr, g_deferred_session_val_ids and g_deferred_session_values in support of Bug xxxx
Rem      sspadafo  12/26/2008 - Added g_substitution_item_encrypted to support session state encryption
Rem      sspadafo  12/29/2008 - Added session timeout globals
Rem      sspadafo  12/31/2008 - Added g_item_encrypted to support session state encryption
Rem      sspadafo  01/09/2009 - Added g_save_state_before_branch_yn array and g_save_state_before_branch scalar
Rem      sspadafo  02/04/2009 - Added g_column_values array to take the place of wwv_flow_dml.g_column_values
Rem      jkallman  02/11/2009 - Added g_dml_* variables from corresponding variables in wwv_flow_dml

create or replace package wwv_flow as

--  Copyright (c) Oracle Corporation 1999 - 2009. All Rights Reserved.
--
--    DESCRIPTION
--      Application Express rendering engine package specification.
--
--    SECURITY
--      Publicly executable.
--
--    NOTES
--      This program shows and accepts application express pages.
--      The application express engine is also known as the flows engine.
--      Freqently called from the procedure f.
--
--    RUNTIME DEPLOYMENT: YES
--



----------------------------------------------------------------------------
-- F L O W   G L O B A L    V A R I A B L E S
--

    -------------------------
    -- flow public data types
    --
    type flow_vc_arr is table of varchar2(32767) index by binary_integer;
    empty_flow_vc_arr flow_vc_arr;
    --
    empty_vc_arr wwv_flow_global.vc_arr2;
    type vc_long_arr is table of varchar2(32767) index by binary_integer;

    empty_vc_long_arr vc_long_arr;

    type clob_arr is table of clob index by binary_integer;
    
    type vc_assoc_arr is table of varchar2(32767) index by varchar2(255);

    -------------------------------------
    -- Globals for generic and public use
    --
    g_image_prefix                 varchar2(255) := wwv_flow_global.g_image_prefix;
    g_company_images               varchar2(255);
    g_flow_images                  varchar2(255);
    g_id                           number;
    g_notification                 varchar2(32767) := null;
    g_global_notification          varchar2(4000) := null;
    g_value                        varchar2(32767) := null;
    g_sysdate                      date;
    g_boolean                      boolean := false;
    g_excel_format                 boolean := false;
    g_error_message_override       varchar2(4000) := null; -- if set programmatically overrides process error messages
    g_unique_page_id               number;
    g_form_painted                 boolean := false;
    g_print_success_message        varchar2(4000) := null;
    g_return_key_1                 varchar2(4000) := null;  -- used to return keys from dml operations
    g_return_key_2                 varchar2(4000) := null;  -- used to return keys from dml operations
    g_base_href                    varchar2(4000) := null;  -- BASE HREF for APEX references
    g_remote_addr                  varchar2(100)  := null;  -- remote address
    g_exec_count                   pls_integer := 0;

    ---------------------
    -- translated strings
    g_nls_edit                     varchar2(255) := 'Edit';

    ----------------------------------------------------
    -- Optimization and performance feedback information
    --
    g_use_cached_substitution_val  boolean := false;
    g_form_count                   pls_integer := 0;
    g_package_instantiated         number;
    g_ok_to_cache_sql              boolean := false;
    g_page_text_generated          boolean := false;
    g_import_in_progress           boolean := false;
    g_cached_region_count          pls_integer := 0;

    -----------------------------------
    -- Debug and error page information
    --
    g_debug                        boolean := false;        -- identifies if flow is running in debug mode
    g_unrecoverable_error          boolean := false;        -- indicates error has occured which requires error page
    g_last_query_text              varchar2(32767) := null; -- if set is the last user sql query executed

    -----------------------------------------------------
    -- security groups for virtual private database (vpd)
    --
    g_vpd                          varchar2(4000) := null;

    ----------------------------------------
    -- Authentication and login, logout info
    --
    g_authentication               varchar2(255) := null;
    g_current_user                 varchar2(255) := null;
    g_user                         varchar2(255) := null; -- corresponds to username used to login
    g_user_id                      number        := null; -- alternate primary key that identifies a user by number
    g_user_known_as                varchar2(255) := null;
    g_flow_schema_owner            constant varchar2(30)  := 'APEX_030200'; -- the owner of Oracle Application Express
    g_login_url                    varchar2(255) := null;
    g_logout_url                   varchar2(4000) := null;
    g_logo_image                   varchar2(500) := null;
    g_logo_image_attributes        varchar2(4000) := null;
    g_cookie_session_id            number := null;
    g_security_scheme              varchar2(255) := null;
    g_ex_context_authentication    boolean := false;
    g_use_zero_sid                 boolean := false;
    g_public_page_ids              wwv_flow_global.vc_arr2;
    g_public_page_aliases          wwv_flow_global.vc_arr2;
    g_public_auth_scheme           boolean := false;

    -----------------------------
    -- Optimistic Locking Globals
    --
    g_md5_checksum                 varchar2(255) := '0';

    ------------------
    -- spatial globals
    --
    g_map1                         wwv_flow_global.vc_arr2;
    g_map2                         wwv_flow_global.vc_arr2;
    g_map3                         wwv_flow_global.vc_arr2;

    ---------------------
    -- Pagination Globals
    --
    g_rownum                       pls_integer := 0;
    g_flow_current_min_row         pls_integer := 1;
    g_flow_current_max_rows        pls_integer := 10;
    g_flow_current_rows_fetched    pls_integer := 0;
    g_flow_total_row_count         pls_integer := 0;
    g_pagination_buttons_painted   boolean := false;

    ---------------------
    -- Tabular Form Globals
    --
    g_item_idx_offset              number := 0;
    g_rownum_offset                number := 0;

    ---------------------
    -- Sorting Globals
    --
    g_fsp_region_id                number := 0;

    ----------------------------
    -- Translation (NLS) Globals
    --
    g_flow_language                varchar2(255) := null;  -- language flow written in (primary langauge)
    g_flow_language_derived_from   varchar2(30);           -- how the language preference of the user is determined
    g_browser_language             varchar2(255) := null;  -- users language preference (set using lang_derived_from method)
    g_browser_version              varchar2(255) := null;  -- browser version
    g_translated_flow_id           number  := null;        -- flow ID for translated flow
    g_translated_page_id           number  := null;        -- page ID for translated flow, e.g. page_id.trans_flow_id
    g_nls_date_format              varchar2(255) := null;  -- current database format from nls_session_parameters table.
    g_nls_decimal_separator        varchar2(10)  := null;  -- current database session decimal separator (derived from NLS_NUMERIC_CHARACTERS)
    g_nls_group_separator          varchar2(10)  := null;  -- current database session numeric group separator (derived from NLS_NUMERIC_CHARACTERS)


    -----------------
    -- Fetch Counters
    --
    g_sessionCnt                   pls_integer := 0;      --
    g_roleCnt                      pls_integer := 0;      --
    g_flowCnt                      pls_integer := 0;      -- flow info found, 1 = yes, 0 = no
    g_stepCnt                      pls_integer := 0;      -- pages found
    g_itemCnt                      pls_integer := 0;      -- page items count
    g_processCnt                   pls_integer := 0;      -- page and flow processes count
    g_plugCnt                      pls_integer := 0;      -- region count
    g_buttonCnt                    pls_integer := 0;      -- page button count
    g_iconbarCnt                   pls_integer := 0;      -- nav bar icon count
    g_tabCnt                       pls_integer := 0;      -- standard tab count
    g_branchCnt                    pls_integer := 0;      -- branch count
    g_computationCnt               pls_integer := 0;      -- computations count
    g_validationCnt                pls_integer := 0;      -- validations count
    g_list_mgr_cnt                 pls_integer := 0;      --
    g_inline_validation_error_cnt  pls_integer := 0;      -- identifies number of inline errors found


    ------------------------------
    -- Substitution Variable Cache
    --
    g_substitution_item_id         wwv_flow_global.vc_arr2; --
    g_substitution_item_name       wwv_flow_global.vc_arr2; -- substitution name
    g_substitution_item_value      vc_long_arr;             -- substitution value
    g_substitution_item_filter     wwv_flow_global.vc_arr2; -- filter on input attribute 'N', 'Y'
    g_substitution_item_encrypted  wwv_flow_global.vc_arr2; -- 'Y' or 'N'
    ------------
    -- Role Info
    --
    g_required_roles               wwv_flow_global.vc_arr2;

    ----------------------
    -- Session Information
    --
    g_new_instance                 boolean := false;
    g_session_cookie               varchar2(255) := null;

    -------------------
    -- Flow Information
    --
    g_flow_id                      number;                  -- flow pk
    g_flow_theme_id                number;                  -- current theme for flow
    g_flow_alias                   varchar2(255) := null;   -- flow alphanumeric alias
    g_flow_step_id                 number;                  -- page pk
    g_instance                     number;                  -- flow session
    g_edit_cookie_session_id       number := null;          -- flow builder session
    g_page_submitted               number := null;          -- set when page posted
    g_exact_substitutions_only     varchar2(1);             -- Y or N
    g_arg_names                    wwv_flow_global.vc_arr2; -- array of item names
    g_arg_values                   wwv_flow_global.vc_arr2; -- array of item values
    g_flow_name                    varchar2(255);           -- name of flow
    g_flow_charset                 varchar2(255);           -- used in html header
    g_date_format                  varchar2(255);           -- Application default date format
    g_flow_owner                   varchar2(30);            -- for secure use wwv_flow_security.g_parse_as_schema
    g_home_link                    varchar2(4000);          -- home page for this flow
    --g_box_width                    varchar2(30);            -- obsolete ?
    g_default_page_template        varchar2(255);           --
    g_printer_friendly_template    varchar2(255);           --
    g_error_template               varchar2(255);           --
    g_webdb_logging                varchar2(30);            -- YES (insert entries into a log table), NO (do not do inserts)
    
    g_application_info             varchar2(4000);          -- apex 3.2 log this text in the apex log
    
    g_public_url_prefix            varchar2(255);           --
    g_public_user                  varchar2(255);           -- identifies public user name
    g_dbauth_url_prefix            varchar2(255);           --
    g_proxy_server                 varchar2(255);           -- used for some regions of type url and web services
    g_media_type                   varchar2(255);           -- Media Type used in Content-Type HTTP header
    g_flow_version                 varchar2(255);           --
    g_flow_status                  varchar2(30);            -- controls availability of flow
    g_build_status                 varchar2(30);            --
    g_rejoin_existing_sessions     boolean := true;         --
    g_request                      varchar2(4000);          -- method of submitting page
    g_sqlerrm                      varchar2(4000) := null;  -- unexpected sql error message to be logged into log tables
    g_err_comp_type                varchar2(255) := null;   -- sqlerrm_component_type identifies what type of component caused the error
    g_err_comp_name                varchar2(255) := null;   -- sqlerrm_component_name identifies the name of the component that raised the error
    g_cache_mode                   varchar2(1) := 'D';      -- R = rendered from cache, C = Cache Created, D = Dynamic

    ------------
    -- shortcuts
    --
    g_shortcut_name                wwv_flow_global.vc_arr2;
    g_shortcut_id                  wwv_flow_global.vc_arr2;

    -------------------
    -- Page Information
    --
    g_popup_filter                 varchar2(4000) := null;  --
    g_printer_friendly             boolean := false;        -- if true use printer friendly page template
    g_first_field_displayable      boolean := false;        --
    g_spell_check_required         boolean := false;        --
    g_step_name                    varchar2(255);           -- page name
    g_step_tab_set                 varchar2(255);           -- page current tab set
    g_step_title                   varchar2(255);           -- page title typically becomes html page title
    g_step_sub_title               varchar2(255);           -- referencable via a template
    g_step_sub_title_type          varchar2(30);            -- describes above
    g_step_media_type              varchar2(255);           -- Media Type used in Content-Type HTTP header
    g_step_first_item              varchar2(255);           -- name of item to put cursor in
    g_step_welcome_text            varchar2(4000);          -- wwv_flow_steps.welcome_text displayed after page template header
    g_step_box_welcome_text        varchar2(4000);          -- wwv_flow_steps.box_welcome_text displayed before #BOX_BODY# in page template body
    --g_step_box_footer_text         varchar2(4000);          -- obsolete ?
    g_step_footer_text             varchar2(4000);          -- wwv_flow_steps.footer_text displayed before showing page template footer
    g_step_template                varchar2(255);           -- page template
    g_step_required_role           varchar2(255);           -- priv required to view page
    g_allow_duplicate_submissions  varchar2(3);             -- Y or N
    g_head                         varchar2(32767);         -- page header for javascript etc. #HEAD#
    g_page_onload                  varchar2(32767);         -- allows control over #ONLOAD# in page template
    g_autocomplete_on_off          varchar2(3);             -- should autocomplete="off" be included in form tag
    g_cache                        varchar2(1);             -- Y or N, Y = page can be cached
    g_include_apex_css_js_yn       varchar2(1);             -- Y is default, N does not include standard apex css and js files for mobile devices

    -------------------
    -- Page Button info
    --
    g_button_id                  wwv_flow_global.n_arr;     -- pk of page button
    g_button_name                wwv_flow_global.vc_arr2;   -- becomes request when button pressed
    g_button_plug_id             wwv_flow_global.vc_arr2;   -- region in which button is displayed
    g_button_image               wwv_flow_global.vc_arr2;   -- optional image name
    g_button_image_alt           wwv_flow_global.vc_arr2;   -- button text
    g_button_position            wwv_flow_global.vc_arr2;   -- display position within region
    g_button_alignment           wwv_flow_global.vc_arr2;   -- used for some positions
    g_button_redirect_url        wwv_flow_global.vc_arr2;   -- redirect to this url, do not submit
    g_button_condition           wwv_flow_global.vc_arr2;   -- conditional attributes
    g_button_condition2          wwv_flow_global.vc_arr2;   -- conditional attributes
    g_button_condition_type      wwv_flow_global.vc_arr2;   -- conditional attributes
    g_button_image_attributes    wwv_flow_global.vc_arr2;   -- optional html image attributes
    g_button_cattributes         wwv_flow_global.vc_arr2;   -- optional html button attributes
    g_button_security_scheme     wwv_flow_global.vc_arr2;   -- security
    g_default_button_position    varchar2(30) default null; --

    -----------------
    -- Navigation Bar
    --
    g_icon_id                    wwv_flow_global.n_arr;       -- pk of nav bar icon
    g_icon_image                 wwv_flow_global.vc_arr2;     -- name of image
    g_icon_subtext               wwv_flow_global.vc_arr2;     --
    g_icon_target                wwv_flow_global.vc_arr2;     --
    g_icon_image_alt             wwv_flow_global.vc_arr2;     --
    g_icon_height                wwv_flow_global.vc_arr2;     --
    g_icon_width                 wwv_flow_global.vc_arr2;     --
    g_icon_free_text             wwv_flow_global.vc_arr2;     --
    g_icon_bar_disp_cond         wwv_flow_global.vc_arr2;     --
    g_icon_bar_disp_cond_type    wwv_flow_global.vc_arr2;     --
    g_icon_bar_flow_cond_instr   wwv_flow_global.vc_arr2;     --
    g_icon_begins_on_new_line    wwv_flow_global.vc_arr2;     --
    g_icon_colspan               wwv_flow_global.vc_arr2;     --
    g_icon_onclick               wwv_flow_global.vc_arr2;     --
    g_icon_security_scheme       wwv_flow_global.vc_arr2;     --

    --------------------------
    -- tab and parent tab info
    --
    g_tab_id                     wwv_flow_global.n_arr;       -- std tab: pk
    g_tab_set                    wwv_flow_global.vc_arr2;     -- std tab: name of tab "collection"
    g_tab_step                   wwv_flow_global.vc_arr2;     -- std tab: page
    g_tab_name                   wwv_flow_global.vc_arr2;     -- std tab: name of tab, not the display text
    g_tab_image                  wwv_flow_global.vc_arr2;     -- std tab: optional image name
    g_tab_non_current_image      wwv_flow_global.vc_arr2;     -- std tab: optional image name
    g_tab_image_attributes       wwv_flow_global.vc_arr2;     -- std tab: attributes for images
    g_tab_text                   wwv_flow_global.vc_arr2;     -- std tab: display text of tab
    g_tab_target                 wwv_flow_global.vc_arr2;     --
    g_tab_parent_id              wwv_flow_global.n_arr;       -- parent tab pk
    g_tab_parent_tabset          wwv_flow_global.vc_arr2;     -- parent tab tabset
    g_tab_parent_display_cond    wwv_flow_global.vc_arr2;     -- parent tab display condition
    g_tab_parent_display_cond2   wwv_flow_global.vc_arr2;     -- parent tab display condition2
    g_tab_parent_display_cond_ty wwv_flow_global.vc_arr2;     -- parent tab display condition type
    g_tab_parent_security_scheme wwv_flow_global.vc_arr2;     -- parent tab security scheme
    g_tab_current_on_tabset      wwv_flow_global.vc_arr2;     -- parent tab current for this standard tab set
    g_tab_also_current_for_pages wwv_flow_global.vc_arr2;     -- std tab: also current for comma delimited page list
    g_tab_plsql_condition        wwv_flow_global.vc_arr2;     --
    g_tab_plsql_condition_type   wwv_flow_global.vc_arr2;     --
    g_tab_disp_cond_text         wwv_flow_global.vc_arr2;     --
    g_tab_security_scheme        wwv_flow_global.vc_arr2;     -- sec scheme
    g_last_tab_pressed           varchar2(255);               -- when branching to a tab, this global is set
    g_current_parent_tab_text    varchar2(255) := null;       -- text of the current parent tab set

    ----------------------------
    -- page template information
    --
    g_current_tab                varchar2(4000)  default null;  --
    g_current_tab_font_attr      varchar2(255)   default null;  --
    g_non_current_tab            varchar2(4000)  default null;  --
    g_non_current_tab_font_attr  varchar2(255)   default null;  --
    g_current_image_tab          varchar2(4000)  default null;  --
    g_non_current_image_tab      varchar2(4000)  default null;  --
    g_top_current_tab            varchar2(4000)  default null;  --
    g_top_current_tab_font_attr  varchar2(255)   default null;  --
    g_top_non_curr_tab           varchar2(4000)  default null;  --
    g_top_non_curr_tab_font_attr varchar2(255)   default null;  --
    g_header_template            varchar2(32767) default null;  -- page template header
    g_box                        varchar2(32767) default null;  -- page template body
    g_footer_template            varchar2(32767) default null;  -- page template footer
    g_footer_len                 pls_integer     default null;  --
    g_footer_end                 varchar2(32767) default null;  --
    g_end_tag_printed            boolean         default true;  -- used to position edit links
    g_template_navigation_bar    varchar2(4000)  default null;  --
    g_template_navbar_entry      varchar2(4000)  default null;  -- defines a navigation bar occurance
    g_template_success_message   varchar2(4000)  default null;  -- success message page sub template
    g_body_title                 varchar2(4000)  default null;  --
    g_notification_message       varchar2(32767) default null;  -- notification message page sub template

    g_heading_bgcolor            varchar2(255)   default null;  -- obsolete ?
    g_table_bgcolor              varchar2(255)   default null;  -- obsolete ?
    g_table_cattributes          varchar2(255)   default null;  -- obsolete ?
    g_region_table_cattributes   varchar2(255)   default null;  -- obsolete ?
    g_font_size                  varchar2(255)   default null;  -- obsolete ?
    g_font_face                  varchar2(255)   default null;  -- obsolete ?

    ------------
    -- item info
    --
    g_item_id                   wwv_flow_global.vc_arr2;    -- page item pk
    g_item_name                 wwv_flow_global.vc_arr2;
    g_item_is_persistent        wwv_flow_global.vc_arr2;
    g_item_sequence             wwv_flow_global.vc_arr2;
    g_item_plug_id              wwv_flow_global.vc_arr2;
    g_item_default              wwv_flow_global.vc_arr2;
    g_item_default_type         wwv_flow_global.vc_arr2;
    g_item_prompt               wwv_flow_global.vc_arr2;
    g_item_pre_element_text     wwv_flow_global.vc_arr2;
    g_item_post_element_text    wwv_flow_global.vc_arr2;
    g_item_format_mask          wwv_flow_global.vc_arr2;
    g_item_source               wwv_flow_global.vc_arr2;
    g_item_source_type          wwv_flow_global.vc_arr2;
    g_item_source_post_computation wwv_flow_global.vc_arr2;
    g_item_display_as           wwv_flow_global.vc_arr2;
    g_item_lov                  wwv_flow_global.vc_arr2;
    g_item_lov_display_extra    wwv_flow_global.vc_arr2;
    g_item_lov_columns          wwv_flow_global.vc_arr2;
    g_item_lov_display_null     wwv_flow_global.vc_arr2;
    g_item_lov_null_text        wwv_flow_global.vc_arr2;
    g_item_lov_null_value       wwv_flow_global.vc_arr2;
    g_item_lov_translated       wwv_flow_global.vc_arr2;
    g_item_csize                wwv_flow_global.vc_arr2;
    g_item_cmaxlength           wwv_flow_global.vc_arr2;
    g_item_cHeight              wwv_flow_global.vc_arr2;
    g_item_cattributes          wwv_flow_global.vc_arr2;
    g_item_cattributes_element  wwv_flow_global.vc_arr2;
    g_item_tag_attributes       wwv_flow_global.vc_arr2;
    g_item_tag_attributes2      wwv_flow_global.vc_arr2;
    g_item_display_when         wwv_flow_global.vc_arr2;
    g_item_display_when2        wwv_flow_global.vc_arr2;
    g_item_display_when_type    wwv_flow_global.vc_arr2;
    g_item_use_cache_before_def wwv_flow_global.vc_arr2;
    g_item_begin_on_new_line    wwv_flow_global.vc_arr2;
    g_item_begin_on_new_field   wwv_flow_global.vc_arr2;
    g_item_colspan              wwv_flow_global.vc_arr2;
    g_item_rowspan              wwv_flow_global.vc_arr2;
    g_item_label_alignment      wwv_flow_global.vc_arr2;
    g_item_field_alignment      wwv_flow_global.vc_arr2;
    g_item_security_scheme      wwv_flow_global.vc_arr2;
    g_item_button_image         wwv_flow_global.vc_arr2;
    g_item_button_image_attr    wwv_flow_global.vc_arr2;
    g_item_read_only_when       wwv_flow_global.vc_arr2;
    g_item_read_only_when2      wwv_flow_global.vc_arr2;
    g_item_read_only_when_type  wwv_flow_global.vc_arr2;
    g_item_read_only_disp_attr  wwv_flow_global.vc_arr2;
    g_item_escape_on_http_input wwv_flow_global.vc_arr2;
    g_item_encrypted            wwv_flow_global.vc_arr2;

    --------------
    -- branch info
    --
    g_branch_has_occured           boolean := false;
    g_before_header_branch_occured boolean := false;
    g_db_session_branch_targets    varchar2(4000) := null;
    g_branch_to_page_accept_count  pls_integer := 0;
    g_branch_point1                varchar2(30);
    g_branch_action1               varchar2(4000);
    g_branch_point                 wwv_flow_global.vc_arr2;
    g_branch_action                wwv_flow_global.vc_arr2;
    g_branch_type1                 varchar2(4000);
    g_branch_type                  wwv_flow_global.vc_arr2;
    g_branch_when_button_id        wwv_flow_global.vc_arr2;
    g_branch_condition1            varchar2(32767);
    g_branch_condition             wwv_flow_global.vc_arr2;
    g_branch_condition_type        wwv_flow_global.vc_arr2;
    g_branch_condition_text        wwv_flow_global.vc_arr2;
    g_save_state_before_branch_yn  wwv_flow_global.vc_arr2;
    g_save_state_before_branch     varchar2(1);
    g_branch_condition_text1       varchar2(4000);
    g_branch_condition_type1       varchar2(4000);    
    g_branch_security_scheme       wwv_flow_global.vc_arr2;
    g_in_process                   boolean := false;

    ---------------
    -- process info
    --
    g_process_id                   wwv_flow_global.vc_arr2;
    g_process_name                 wwv_flow_global.vc_arr2;
    g_process_sql                  wwv_flow_global.vc_arr2;
    g_process_sql_clob             clob_arr;
    g_process_point                wwv_flow_global.vc_arr2;
    g_process_type                 wwv_flow_global.vc_arr2;
    g_process_error_message        wwv_flow_global.vc_arr2;
    g_process_success_message      wwv_flow_global.vc_arr2;
    g_process_when_button_id       wwv_flow_global.vc_arr2;
    g_process_when                 wwv_flow_global.vc_arr2;
    g_process_when2                wwv_flow_global.vc_arr2;
    g_process_when_type            wwv_flow_global.vc_arr2;
    g_process_security_scheme      wwv_flow_global.vc_arr2;
    g_job                          pls_integer;
    g_process_is_stateful_y_n      wwv_flow_global.vc_arr2;
    g_process_item_name            wwv_flow_global.vc_arr2;
    g_proc_return_key_into_item1   wwv_flow_global.vc_arr2;
    g_proc_return_key_into_item2   wwv_flow_global.vc_arr2;
    g_proc_runtime_where_clause    wwv_flow_global.vc_arr2;

    ---------------------
    -- region (plug) info
    --
    g_plug_id                      wwv_flow_global.vc_arr2;
    g_plug_name                    wwv_flow_global.vc_arr2;
    g_plug_template                wwv_flow_global.vc_arr2;
    g_plug_display_column          wwv_flow_global.vc_arr2;
    g_plug_display_point           wwv_flow_global.vc_arr2;
    g_plug_source                  wwv_flow_global.vc_arr2;
    g_plug_source_type             wwv_flow_global.vc_arr2;
    g_plug_list_template_id        wwv_flow_global.vc_arr2;
    g_plug_display_error_message   wwv_flow_global.vc_arr2;
    g_plug_table_bgcolor           varchar2(255) := null;
    g_plug_heading_bgcolor         varchar2(255) := null;
    g_plug_font_size               varchar2(255) := null;
    g_plug_form_tab_attr           varchar2(4000):= null;
    g_plug_header                  wwv_flow_global.vc_arr2;
    g_plug_footer                  wwv_flow_global.vc_arr2;
    g_plug_required_role           wwv_flow_global.vc_arr2;
    g_plug_display_when_condition  wwv_flow_global.vc_arr2;
    g_plug_display_when_cond2      wwv_flow_global.vc_arr2;
    g_plug_display_condition_type  wwv_flow_global.vc_arr2;
    g_plug_column_width            wwv_flow_global.vc_arr2;
    g_plug_customized              wwv_flow_global.vc_arr2;
    g_plug_no_data_found           wwv_flow_global.vc_arr2;
    g_plug_query_more_data         wwv_flow_global.vc_arr2;
    g_plug_caching                 wwv_flow_global.vc_arr2;
    g_plug_position                varchar2(255)  := null;
    g_cached_regions               varchar2(4000) := null;
    g_plug_static_id               wwv_flow_global.vc_arr2;
    g_plug_att_sub                 wwv_flow_global.vc_arr2;

    -------------------
    -- computation info
    --
    g_computation_id              wwv_flow_global.vc_arr2;
    g_computation_type            wwv_flow_global.vc_arr2;
    g_computation_item            wwv_flow_global.vc_arr2;
    g_computation_point           wwv_flow_global.vc_arr2;
    g_computation_processed       wwv_flow_global.vc_arr2;
    g_computation                 wwv_flow_global.vc_arr2;
    g_computation_result_vc       varchar2(32767);
    g_computation_result_vc_arr   wwv_flow_global.vc_arr2;
    g_computation_result_num      number;
    g_compute_when                wwv_flow_global.vc_arr2;
    g_compute_when_text           wwv_flow_global.vc_arr2;
    g_compute_when_type           wwv_flow_global.vc_arr2;
    g_compute_security_scheme     wwv_flow_global.vc_arr2;

    --------------------
    -- list manager info
    --
    g_list_managers               wwv_flow_global.vc_arr2;

    --------------
    -- Validations
    --
    g_validation_ids_in_error     wwv_flow_global.vc_arr2;
    g_item_ids_in_error           wwv_flow_global.vc_arr2;
    g_validation_message          wwv_flow_global.vc_arr2;

    --------------------------------------------
    -- Global input values for updatable reports
    --
    g_f01             wwv_flow_global.vc_arr2;
    g_f02             wwv_flow_global.vc_arr2;
    g_f03             wwv_flow_global.vc_arr2;
    g_f04             wwv_flow_global.vc_arr2;
    g_f05             wwv_flow_global.vc_arr2;
    g_f06             wwv_flow_global.vc_arr2;
    g_f07             wwv_flow_global.vc_arr2;
    g_f08             wwv_flow_global.vc_arr2;
    g_f09             wwv_flow_global.vc_arr2;
    g_f10             wwv_flow_global.vc_arr2;
    g_f11             wwv_flow_global.vc_arr2;
    g_f12             wwv_flow_global.vc_arr2;
    g_f13             wwv_flow_global.vc_arr2;
    g_f14             wwv_flow_global.vc_arr2;
    g_f15             wwv_flow_global.vc_arr2;
    g_f16             wwv_flow_global.vc_arr2;
    g_f17             wwv_flow_global.vc_arr2;
    g_f18             wwv_flow_global.vc_arr2;
    g_f19             wwv_flow_global.vc_arr2;
    g_f20             wwv_flow_global.vc_arr2;
    g_f21             wwv_flow_global.vc_arr2;
    g_f22             wwv_flow_global.vc_arr2;
    g_f23             wwv_flow_global.vc_arr2;
    g_f24             wwv_flow_global.vc_arr2;
    g_f25             wwv_flow_global.vc_arr2;
    g_f26             wwv_flow_global.vc_arr2;
    g_f27             wwv_flow_global.vc_arr2;
    g_f28             wwv_flow_global.vc_arr2;
    g_f29             wwv_flow_global.vc_arr2;
    g_f30             wwv_flow_global.vc_arr2;
    g_f31             wwv_flow_global.vc_arr2;
    g_f32             wwv_flow_global.vc_arr2;
    g_f33             wwv_flow_global.vc_arr2;
    g_f34             wwv_flow_global.vc_arr2;
    g_f35             wwv_flow_global.vc_arr2;
    g_f36             wwv_flow_global.vc_arr2;
    g_f37             wwv_flow_global.vc_arr2;
    g_f38             wwv_flow_global.vc_arr2;
    g_f39             wwv_flow_global.vc_arr2;
    g_f40             wwv_flow_global.vc_arr2;
    g_f41             wwv_flow_global.vc_arr2;
    g_f42             wwv_flow_global.vc_arr2;
    g_f43             wwv_flow_global.vc_arr2;
    g_f44             wwv_flow_global.vc_arr2;
    g_f45             wwv_flow_global.vc_arr2;
    g_f46             wwv_flow_global.vc_arr2;
    g_f47             wwv_flow_global.vc_arr2;
    g_f48             wwv_flow_global.vc_arr2;
    g_f49             wwv_flow_global.vc_arr2;
    g_f50             wwv_flow_global.vc_arr2;
    g_fcs             wwv_flow_global.vc_arr2;
    g_survey_map      varchar2(32767);

    ---------------------------
    -- URL Tampering Prevention
    --

    g_arg_values_delimited          wwv_flow_global.vc_arr2;
    g_protected_page_ids            wwv_flow_global.n_arr;
    g_protected_page_aliases        wwv_flow_global.vc_arr2;

    --------------------------------------------
    -- Global input variables for AJAX utilities
    --
    g_widget_name		varchar2(255);
    g_widget_mod		varchar2(255);
    g_widget_action     varchar2(255);
    g_widget_action_mod	varchar2(255);
    g_widget_num_return	varchar2(255);

    g_x01             varchar2(32767);
    g_x02             varchar2(32767);
    g_x03             varchar2(32767);
    g_x04             varchar2(32767);
    g_x05             varchar2(32767);
    g_x06             varchar2(32767);
    g_x07             varchar2(32767);
    g_x08             varchar2(32767);
    g_x09             varchar2(32767);
    g_x10             varchar2(32767);
    g_clob_01         clob;

    ------------------------------------
    -- Session Timeout
    --

    g_max_session_length_sec        number;
    g_max_session_idle_sec          number;

    -------------------------------------------------------------
    -- Global array of session values updated at end of page show.
    -- Session value name is the index of the associated array.
    --
    g_deferred_session_val_ids  vc_assoc_arr;
    g_deferred_session_values   vc_assoc_arr;
    
    ----------------------------------------------------------------------------
    -- Global array of form item values fetched by automated row fetch processes
    -- and other globals previously in wwv_flow_dml
    --
    g_column_values             wwv_flow.flow_vc_arr;
    g_dml_blob                  blob;
    g_dml_validation_count      pls_integer := 0;
    g_dml_mimetype              varchar2(255) := null;
    g_dml_filename              varchar2(400);
    g_dml_charset               varchar2(255);
    g_dml_last_updated_date     date;
    g_dml_clob_text             clob;
    g_dml_varchar32767_text     varchar2(32767) := null;
    g_dml_rowid                 varchar2(255);
    g_dml_blob_length           number := 0;

----------------------------------------------------------------------------
-- S H O W
--
-- This procedure is the entry point for the display of application express pages.
--
--
-- p_request              -- Request which can be the tab pressed, the button pressed, an
--                           arbitrary value etc.
-- p_instance             -- Flow Session ID, must be numeric.
-- p_flow_id              -- Flow ID, must be numeric.
-- p_flow_step_id         -- Page ID, must be numeric (for example: 1)
-- p_debug                -- If "YES" then flows will display debug messages.
-- p_arg_names            -- Comma seperated list of flow item names.  Item names should
--                           have corresponding (p_arg_values) values.  For example:
--                           p_arg_names => 'A,B,C'
--                           p_arg_values=> '1,2,3'
--                           This assumes that a flow or page item called A, B, and C
--                           exists.  When called a value of 1 will be assigned to A,
--                           2 to B, etc.
-- p_arg_values           -- Comma seperated list of values that corresponds to a
--                           comma seperated list of names (p_arg_names).  The session
--                           state for the flow items identified will be set to these
--                           values.
-- p_arg_name             -- use when passing one item name, itentifies a single item name
-- p_arg_value            -- use when passing one item value, identifies a single item value
-- p_clear_cache          -- Comma seperated list of pages (e.g. 2,3,4).
--                           Sets to null the values of any flow item declared for a
--                           list of pages.
-- p_box_border           -- obsolete
-- p_printer_friendly     -- If "YES" then show page using printer friendly template.
--                           Do not generate tabs or nav bar icons.
-- p_trace                -- If "YES", generate trace file for debugging and performance tuning
-- p_company              -- ID of company (security group id) must be numeric
-- p_md5_checksum         -- checksum to prevent lost updates
-- p_last_button_pressed  -- facilitates reference to :flow_last_button_pressed


procedure show (
    p_request             in varchar2   default null,
    p_instance            in varchar2   default null,
    p_flow_id             in varchar2   default null,
    p_flow_step_id        in varchar2   default null,
    p_debug               in varchar2   default 'NO',
    p_arg_names           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_arg_values          in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_clear_cache         in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_box_border          in varchar2   default '0',
    p_printer_friendly    in varchar2   default 'NO',
    p_trace               in varchar2   default 'NO',
    p_company             in number     default null,
    p_md5_checksum        in varchar2   default '0',
    p_last_button_pressed in varchar2   default null,
    p_arg_name            in varchar2   default null,
    p_arg_value           in varchar2   default null,
    f01                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f02                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f03                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f04                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f05                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f06                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f07                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f08                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f09                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f10                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f11                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f12                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f13                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f14                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f15                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f16                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f17                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f18                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f19                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f20                   in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_widget_name         in varchar2   default null,
    p_widget_mod          in varchar2   default null,
    p_widget_action       in varchar2   default null,
    p_widget_action_mod   in varchar2   default null,
	p_widget_num_return   in varchar2   default null,
    x01                   in varchar2   default null,
    x02                   in varchar2   default null,
    x03                   in varchar2   default null,
    x04                   in varchar2   default null,
    x05                   in varchar2   default null,
    x06                   in varchar2   default null,
    x07                   in varchar2   default null,
    x08                   in varchar2   default null,
    x09                   in varchar2   default null,
    x10                   in varchar2   default null,
    p_clob_01             in clob       default null)
    ;


----------------------------------------------------------------------------
-- A C C E P T
--
-- This procedure accepts virtually every flow page.
-- Reference show procedure for input argument descriptions.
--
--
--
--

procedure accept (
    p_request       in varchar2   default null,
    p_instance      in varchar2   default null,
    p_flow_id       in varchar2   default null,
    p_company       in number     default null,
    p_flow_step_id  in varchar2   default null,
    p_arg_names     in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_arg_values    in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_accept_processing in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v01           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v02           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v03           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v04           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v05           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v06           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v07           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v08           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v09           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v10           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v11           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v12           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v13           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v14           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v15           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v16           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v17           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v18           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v19           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v20           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v21           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v22           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v23           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v24           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v25           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v26           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v27           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v28           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v29           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v30           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v31           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v32           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v33           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v34           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v35           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v36           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v37           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v38           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v39           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v40           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v41           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v42           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v43           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v44           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v45           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v46           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v47           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v48           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v49           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v50           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v51           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v52           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v53           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v54           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v55           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v56           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v57           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v58           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v59           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v60           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v61           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v62           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v63           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v64           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v65           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v66           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v67           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v68           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v69           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v70           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v71           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v72           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v73           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v74           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v75           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v76           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v77           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v78           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v79           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v80           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v81           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v82           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v83           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v84           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v85           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v86           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v87           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v88           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v89           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v90           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v91           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v92           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v93           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v94           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v95           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v96           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v97           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v98           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v99           in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_v100          in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_t01           in varchar2   default null,
    p_t02           in varchar2   default null,
    p_t03           in varchar2   default null,
    p_t04           in varchar2   default null,
    p_t05           in varchar2   default null,
    p_t06           in varchar2   default null,
    p_t07           in varchar2   default null,
    p_t08           in varchar2   default null,
    p_t09           in varchar2   default null,
    p_t10           in varchar2   default null,
    p_t11           in varchar2   default null,
    p_t12           in varchar2   default null,
    p_t13           in varchar2   default null,
    p_t14           in varchar2   default null,
    p_t15           in varchar2   default null,
    p_t16           in varchar2   default null,
    p_t17           in varchar2   default null,
    p_t18           in varchar2   default null,
    p_t19           in varchar2   default null,
    p_t20           in varchar2   default null,
    p_t21           in varchar2   default null,
    p_t22           in varchar2   default null,
    p_t23           in varchar2   default null,
    p_t24           in varchar2   default null,
    p_t25           in varchar2   default null,
    p_t26           in varchar2   default null,
    p_t27           in varchar2   default null,
    p_t28           in varchar2   default null,
    p_t29           in varchar2   default null,
    p_t30           in varchar2   default null,
    p_t31           in varchar2   default null,
    p_t32           in varchar2   default null,
    p_t33           in varchar2   default null,
    p_t34           in varchar2   default null,
    p_t35           in varchar2   default null,
    p_t36           in varchar2   default null,
    p_t37           in varchar2   default null,
    p_t38           in varchar2   default null,
    p_t39           in varchar2   default null,
    p_t40           in varchar2   default null,
    p_t41           in varchar2   default null,
    p_t42           in varchar2   default null,
    p_t43           in varchar2   default null,
    p_t44           in varchar2   default null,
    p_t45           in varchar2   default null,
    p_t46           in varchar2   default null,
    p_t47           in varchar2   default null,
    p_t48           in varchar2   default null,
    p_t49           in varchar2   default null,
    p_t50           in varchar2   default null,
    p_t51           in varchar2   default null,
    p_t52           in varchar2   default null,
    p_t53           in varchar2   default null,
    p_t54           in varchar2   default null,
    p_t55           in varchar2   default null,
    p_t56           in varchar2   default null,
    p_t57           in varchar2   default null,
    p_t58           in varchar2   default null,
    p_t59           in varchar2   default null,
    p_t60           in varchar2   default null,
    p_t61           in varchar2   default null,
    p_t62           in varchar2   default null,
    p_t63           in varchar2   default null,
    p_t64           in varchar2   default null,
    p_t65           in varchar2   default null,
    p_t66           in varchar2   default null,
    p_t67           in varchar2   default null,
    p_t68           in varchar2   default null,
    p_t69           in varchar2   default null,
    p_t70           in varchar2   default null,
    p_t71           in varchar2   default null,
    p_t72           in varchar2   default null,
    p_t73           in varchar2   default null,
    p_t74           in varchar2   default null,
    p_t75           in varchar2   default null,
    p_t76           in varchar2   default null,
    p_t77           in varchar2   default null,
    p_t78           in varchar2   default null,
    p_t79           in varchar2   default null,
    p_t80           in varchar2   default null,
    p_t81           in varchar2   default null,
    p_t82           in varchar2   default null,
    p_t83           in varchar2   default null,
    p_t84           in varchar2   default null,
    p_t85           in varchar2   default null,
    p_t86           in varchar2   default null,
    p_t87           in varchar2   default null,
    p_t88           in varchar2   default null,
    p_t89           in varchar2   default null,
    p_t90           in varchar2   default null,
    p_t91           in varchar2   default null,
    p_t92           in varchar2   default null,
    p_t93           in varchar2   default null,
    p_t94           in varchar2   default null,
    p_t95           in varchar2   default null,
    p_t96           in varchar2   default null,
    p_t97           in varchar2   default null,
    p_t98           in varchar2   default null,
    p_t99           in varchar2   default null,
    p_t100          in varchar2   default null,
    f01             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f02             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f03             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f04             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f05             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f06             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f07             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f08             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f09             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f10             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f11             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f12             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f13             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f14             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f15             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f16             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f17             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f18             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f19             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f20             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f21             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f22             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f23             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f24             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f25             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f26             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f27             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f28             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f29             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f30             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f31             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f32             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f33             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f34             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f35             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f36             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f37             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f38             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f39             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f40             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f41             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f42             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f43             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f44             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f45             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f46             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f47             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f48             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f49             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    f50             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    fcs             in wwv_flow_global.vc_arr2 default empty_vc_arr,
    x01             in varchar2   default null,
    x02             in varchar2   default null,
    x03             in varchar2   default null,
    x04             in varchar2   default null,
    x05             in varchar2   default null,
    x06             in varchar2   default null,
    x07             in varchar2   default null,
    x08             in varchar2   default null,
    x09             in varchar2   default null,
    x10             in varchar2   default null,
    x11             in varchar2   default null,
    x12             in varchar2   default null,
    x13             in varchar2   default null,
    x14             in varchar2   default null,
    x15             in varchar2   default null,
    x16             in varchar2   default null,
    x17             in varchar2   default null,
    x18             in varchar2   default null,
    x19             in varchar2   default null,
    x20             in varchar2   default null,
    p_map1          in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_map2          in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_map3          in wwv_flow_global.vc_arr2 default empty_vc_arr,
    p_survey_map    in varchar2   default null,
    p_flow_current_min_row      in varchar2 default '1',
    p_flow_current_max_rows     in varchar2 default '10',
    p_flow_current_rows_fetched in varchar2 default '0',
    p_debug                     in varchar2 default 'NO',
    p_trace                     in varchar2 default 'NO',
    p_md5_checksum              in varchar2 default '0',
    p_page_submission_id        in varchar2 default null,
    p_ignore_01     in varchar2 default null,
    p_ignore_02     in varchar2 default null,
    p_ignore_03     in varchar2 default null,
    p_ignore_04     in varchar2 default null,
    p_ignore_05     in varchar2 default null,
    p_ignore_06     in varchar2 default null,
    p_ignore_07     in varchar2 default null,
    p_ignore_08     in varchar2 default null,
    p_ignore_09     in varchar2 default null,
    p_ignore_10     in varchar2 default null)
    ;





----------------------------------------------------------------------------
-- H E L P   S Y S T E M
--

procedure help (
    --
    -- Returns Page and Column level help from flow builder meta data
    -- repository.
    --
    -- Arguments:
    --    p_flow_id        = flow ID
    --    p_flow_step_id   = page ID
    --    p_show_item_help = YES (include item level help), NO do not show item level help
    --
    p_request        in varchar2 default null,
    p_flow_id        in varchar2 default null,
    p_flow_step_id   in varchar2 default null,
    p_show_item_help in varchar2 default 'YES',
    p_show_regions   in varchar2 default 'YES',
    --
    p_before_page_html     in varchar2 default '<p>',
    p_after_page_html      in varchar2 default null,
    p_before_region_html   in varchar2 default null,
    p_after_region_html    in varchar2 default '</td></tr></table></p>',
    p_before_prompt_html   in varchar2 default '<p><b>',
    p_after_prompt_html    in varchar2 default '</b></p>:&nbsp;',
    p_before_item_html     in varchar2 default null,
    p_after_item_html      in varchar2 default null)
    ;







----------------------------------------------------------------------------
-- U T I L I T I E S
--

function do_substitutions (
    --
    -- Perform substitutions of ampersand prefixed flow items with
    -- current flow session state for current user and current session.
    --
    p_string                       in varchar2 default null,
    p_sub_type                     in varchar2 default 'SQL',
    p_perform_oracle_substitutions in boolean default false,
    p_print_results                in boolean default false)
    return varchar2
    ;

function trim_sql (
    --
    -- Given a SQL statement , trim trailing and leading
    -- white spaces.  Optionally perform session state substitutions
    -- as well as ensuring the statement ends in a semicolon.
    --
    p_sql               in varchar2 default null,
    p_ends_in_semicolon in boolean default false,
    p_do_substitutions  in boolean default true)
    return varchar2
    ;

function trim_sql (
    --
    -- This function gets a SQL statement ready for execution
    -- Function is overloaded; p_owner may be provided in order to cause package global
    -- to be temporarily replaced with the value of p_owner in package state during
    -- the execution of this function and until its return to the caller.
    --
    p_sql               in varchar2 default null,
    p_ends_in_semicolon in boolean default false,
    p_do_substitutions  in boolean default true,
    p_owner             in varchar2)
    return varchar2
    ;

procedure set_g_nls_date_format
    ;

procedure reset_g_nls_date_format
    ;


procedure set_g_nls_decimal_separator
    ;

procedure reset_g_nls_decimal_separator
    ;

function get_nls_decimal_separator return varchar2
    ;

function get_nls_group_separator return varchar2
    ;

function get_translated_app_id return number
    ;

procedure set_g_base_href
    ;

procedure reset_g_base_href
    ;

function get_g_base_href return varchar2
    ;

function get_page_alias return varchar2
    ;

function is_custom_auth_page return boolean
    ;

----------------------------------------------------------------------------
-- E R R O R   H A N D L I N G
--
procedure show_error_message (
    p_message  in varchar2 default 'Error',
    p_footer   in varchar2 default null,
    p_query    in varchar2 default null)
    ;




----------------------------------------
-- I N T E R N A L     U T I L I T I E S
--
-- Internal utilities used by the flow engine runtime
-- that are not intened and are not useful to the
-- flows programmer.
--

function paint_formOpen
    -- Return the HTML form open tag given current flow state.
    return varchar2
    ;


function draw_icon_navigation_bar
    -- Given the current flows context return the HTML which
    -- represents the navigation icon bar.  Page templates provide
    -- navigation bar location.  Page templates need not specify a
    -- navigation bar.
    return varchar2
    ;

procedure draw_body_close
    ;

function paint_buttons (
    -- Given current flows context draw (omit the HTML) for
    -- buttons given a position and region ID.
    p_position in varchar2 default 'TOP',
    p_plug_id  in varchar2 default '0')
    return varchar2
    ;

function do_template_substitutions (
    p_string        in varchar2 default null,
    p_onLoad        in varchar2 default null)
    return varchar2
    ;

function tab_title (
    p_text     in varchar2 default null)
    return varchar2
    ;

procedure s (
    p in varchar2 default null)
    ;

procedure draw_body_open(
    p_title       in varchar2 default null,
    p_width       in varchar2 default '100%',
    p_box_border  in varchar2 default '0')
    ;

/*
function convert_display_id_to_flow_id (
   p_display_id in number)
   return number
   ;
*/

function convert_flow_alias_to_id (
     --
     -- Given a flow ID that may be an alphanumeric
     -- alias, convert it into the numeric flow ID.
     --
     p_flow_alias_or_id  in varchar2 default null,
     p_security_group_id in number   default null)
     return number
     ;



----------------------------------------------------------------------------
-- D E B U G G I N G
--
procedure debug (
    -- Given a string this will result in the generation of a debug entry
    p_string         in varchar2 default null)
    ;





----------------------------------------------------------------------------
-- S E S S I O N   S T A T E   M A N A G E M E N T
--
-- The following routines can be called to read and write session state.
--
--
--
--

function get_next_session_id
    -- Get integer ID values, session ID is a sequence, unique ID is a sequence
    -- with a random number which produces a virtual global unique ID.
    return number
    ;

function get_unique_id
    -- Return a number which is virually globally unique.
    return number
    ;

procedure clear_page_cache (
    -- Reset all cached items for a given page to null
    p_flow_page_id in number default null)
    ;

procedure null_page_cache (
    -- deprecated
    -- Reset all cached items for a given page to null
    p_flow_page_id in number default null)
    ;

procedure null_step_cache (
    -- depricated
    p_flow_step_id in number default null)
    ;

procedure clear_page_caches (
    -- Reset all cached items for pages in array to null
    p_flow_page_id in wwv_flow_global.vc_arr2 default empty_vc_arr)
    ;

procedure null_page_caches (
    -- deprecated
    p_flow_page_id in wwv_flow_global.vc_arr2 default empty_vc_arr)
    ;

procedure null_step_caches (
    -- depricated
    p_flow_step_id in wwv_flow_global.vc_arr2 default empty_vc_arr)
    ;

procedure clear_flow_cache (
    -- For the current session remove session state for the given flow.
    -- Requires g_instance to be set to the current flows session.
    p_flow_id in varchar2 default null)
    ;

procedure clear_app_cache (
    -- For the current session remove session state for the given flow.
    -- Requires g_instance to be set to the current flows session.
    p_app_id in varchar2 default null)
    ;

procedure clear_user_cache
    -- For the current users session remove session state and flow system preferences.
    -- Run this procedure if you reuse session IDs and want to run flows without
    -- the benifit of existing session state.  Requires g_instance to be set to the
    -- current flows session.
    ;

function find_item_id (
    -- Given a flow page or flow level items name return its numeric identifier.
    p_name in varchar2 default null)
    return number
    ;

function find_item_name (
    -- Given a flow page or flow level items numeric identifier return the items name.
    p_id in number default null)
    return varchar2
    ;

procedure save_in_substitution_cache (
    --
    -- Saves item in substitution cache (memory array only)
    -- Named item may not yet exist in cache.
    --
    -- name  = name of flow or page item
    -- value = value of flow or page item
    --
    p_name    in varchar2 default null,
    p_value   in varchar2 default null)
    ;

procedure update_cache_with_write (
    -- For the current session update an items cached value.  This update is persistent
    -- for the life of the flow session, unless the session state is cleared or updated.
    p_name    in varchar2 default null,
    p_value   in varchar2 default null)
    ;

procedure reset_security_check
    -- Security checks are cached to increase performance, this procedure allows you to
    -- undo the caching and thus require all security checks to be revalidated for the
    -- current user.  Use this routine if you allow a user to change "responcibilities"
    -- within an application, thus changing their authentication scheme.
    ;

function public_role_check (
    p_role      in varchar2 default null,
    p_component in varchar2 default null)
    return boolean
    ;

function public_security_check (
    -- Given the name of a flow security scheme determine if the current user
    -- passes the security check.
    p_security_scheme in varchar2)
    return boolean
    ;

function fetch_flow_item(
    -- Given a flow-level item name, locate item in current or specified
    -- flow and current or specified session and return item value.
    p_item         in varchar2,
    p_flow         in number default null,
    p_instance     in number default null)
    return varchar2
    ;

function fetch_app_item(
    -- Given a flow-level item name, locate item in current or specified
    -- flow and current or specified session and return item value.
    p_item         in varchar2,
    p_app          in number default null,
    p_instance     in number default null)
    return varchar2
    ;

------------------------------------------------------------------
-- V I R T U A L   P R I V A T E   D A T A B A S E   S U P P O R T
--
-- flows are owned by companies which are identified by a security
-- group ID.  The flow meta data repository is "sliced up" by
-- the security group id (sgid).
--

function get_sgid return number
    -- Given the current users context return the security group ID.
    ;
function get_browser_version return varchar2;
     -- return browser versiob

function get_company_name return varchar2
    -- Given the current users context return the company name.
    ;
function get_current_flow_sgid (
    -- Given a flow ID attempt to determine the security group ID.
    -- If the flow ID is unique on your flows runtime install then
    -- you will get a security group ID.
    p_flow_id    in number,
    p_company_id in number default null)
    return number
    ;

------------------------------------------------------------------
-- Stateful processes
--

function process_state(
    p_process_id in number)
    return varchar2
    ;

procedure reset_page_process(
    p_process_id in number)
    ;

procedure reset_page_processess(
    p_page_id in number)
    ;


------------------------------------------------------------------
-- A U T H E N T I C A T I O N
--

function get_custom_auth_login_url return varchar2
    -- for use with custom authentication
    ;

function replace_cgi_env(
    p_in varchar2)
    return varchar2
    ;
end wwv_flow;
/
show errors

grant execute on wwv_flow to public;


