set define '^'
set verify off
prompt ...wwv_flow_log


Rem    SCRIPT ARGUMENTS
Rem      1:
Rem      2:
Rem      3:
Rem      4:
Rem      5:
Rem      6:
Rem      7:
Rem      8:
Rem      9:
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      mhichwa   08/04/1999 - Created
Rem      mhichwa   09/18/2001 - Exposed current log number function
Rem      mhichwa   12/05/2002 - Moved log interval to spec from body
Rem      mhichwa   06/20/2003 - added g_total_rows_fetched to improve log accuracy, bug 3018094
Rem




create or replace package wwv_flow_log as

--  Copyright (c) Oracle Corporation 1999 - 2002. All Rights Reserved.
--
--    DESCRIPTION
--      Flow activity logging
--
--    SECURITY
--
--    NOTES:
--      This program logs flow activity
--      p_elap:     Elapsed time in seconds
--      p_num_rows: Number of rows processed by page 
--      p_verbose:  Log all information not just most critical
--
--    RUNTIME DEPLOYMENT: YES
--

g_log_interval_in_days  constant number := 14;
g_total_rows_fetched pls_integer := 0;


function current_log_number
    return number
    ;

procedure log (
    p_elap                in number   default null,
    p_num_rows            in number   default null,
    p_verbose             in boolean  default true)
    ;


end wwv_flow_log;
/
show errors
