set define '^'
set verify off
prompt ...flows_files_upgrade


Rem  Copyright (c) Oracle Corporation 2003. All Rights Reserved.
Rem
Rem    NAME
Rem      flows_files_upgrade.sql
Rem
Rem    DESCRIPTION
Rem      HTML DB file repository upgrade
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED    (MM/DD/YYYY)
Rem       jkallman  08/04/2003 - Created
Rem       cbcho     12/02/2005 - Changed dba_* to fully qualify with sys.dba_* (Bug 4390397)


prompt ...flows_files_upgrade
declare
    l_found boolean := FALSE;
begin
    for c1 in (select null
                 from sys.dba_tab_columns
                where owner = 'FLOWS_FILES'
                  and table_name = 'WWV_FLOW_FILE_OBJECTS$'
                  and column_name = 'FILE_CHARSET') loop
        l_found := TRUE;
    end loop;
    --
    -- If the new column wasn't found, add it to the file object repository
    if l_found = FALSE then
        execute immediate 'ALTER TABLE wwv_flow_file_objects$ ADD file_charset VARCHAR2(128)';
    end if;
end;
/
