set define '^'
set verify off
set serveroutput on size 1000000
prompt ...wwv_flow_gen_api


Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED (MM/DD/YYYY)
Rem     mhichwa  05/20/2000 - Created
Rem     mhichwa  08/18/2000 - Added template exports
Rem     mhichwa  08/28/2000 - Added p_owner_override
Rem     mhichwa  03/30/2001 - Added g id offset package variable
Rem     sdillon  05/10/2001 - Added export company & flow images
Rem     sdillon  05/18/2001 - Added css export
Rem     sdillon  05/29/2001 - Added multiple/individual page support to css exporting
Rem     sdillon  06/04/2001 - Added file export support
Rem     mhichwa  10/05/2001 - Added export field template
Rem     cbcho    07/09/2002 - Exposed g_mime_shown
Rem     sspadafo 01/06/2003 - Added p_build_status_override to export (Bug 2739851)
Rem     jstraub  05/21/2003 - Added g_rpt_format to support new reporting engine structures
Rem     jstraub  05/23/2003 - Removed g_rpt_format, no longer needed
Rem     sspadafo 07/28/2003 - Added g_nls_numeric_chars (Bug 3070294)
Rem     sspadafo 07/29/2003 - Removed g_nls_numeric_chars (Bug 3074774)
Rem     skutz    06/14/2004 - Added export_theme api
Rem     skutz    06/14/2004 - Added p_theme_id to all create template api's to facilitate theme export
Rem     skutz    06/14/2004 - Made export_page_template,export_region_template,export_list_template OBSOLETE
Rem     skutz    06/14/2004 - Made export_row_template,export_field_template OBSOLETE
Rem     cbcho    05/16/2005 - Added export_script
Rem     mhichwa  07/07/2005 - Added p_flashback_min_ago argument to clean up flashback export
Rem     madelfio 02/03/2005 - Added create_flow_image
Rem     madelfio 02/06/2005 - Added create_image_script(renamed from create_flow_image), create_css_script, and create_static_script
Rem     cbcho    04/06/2006 - Added p_file_id to procedure export
Rem     mhichwa  04/14/2006 - Added p_export_comments argument to export procedure
Rem     mhichwa  05/01/2006 - Added g_exp_region_col_width boolean := true; to allow export to be turned off if needed from f4000.
Rem     mhichwa  05/17/2006 - Added support for debugging_override export option bug 5231642
Rem     mhichwa  05/18/2006 - Added p_component and p_component_id to export procedure
Rem     madelfio 05/31/2006 - Added functions to return clob output of create_image_script, create_css_script, and create_html_script
Rem     jstraub  01/09/2009 - Added p_export_saved_reports to export



create or replace package wwv_flow_gen_api2
is

g_id_offset            number  := 0;
g_mime_shown           boolean := false;
g_exp_region_col_width boolean := true;


procedure export (
    -- This procedure exports flows
    --
    -- p_flow_id...............Unique ID number of your flow
    -- p_page_id...............Optional Page ID number
    -- p_format................Output format UNIX, DOS, DB, XML
    -- p_commit................Generate a commit statement at end of script (YES or NO)
    -- p_owner_override........Set the application owner to this USER and not the current flows owner attribute
    -- p_flashback_min_ago.....Set the export procedure to use flashback mode
    -- p_file_id...............Use optionally when exporting into DB format
    -- p_export_comments.......Export comments in with the file
    -- p_debugging_override....Set the application debugging status to this value (1 = Yes, 0 = No)
    --
    p_flow_id               in number,
    p_page_id               in number   default null,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES',
    p_owner_override        in varchar2 default null,
    p_build_status_override in varchar2 default 'NO',
    p_flashback_min_ago     in number   default null,
    p_file_id               in number   default null,
    p_export_comments       in varchar2 default 'N',
    p_export_saved_reports  in varchar2 default 'N',
    p_debugging_override    in number   default null,
    p_component             in varchar2 default null,
    p_component_id          in number   default null
    )
    ;


procedure export_theme (
    -- p_flow_id........Unique ID number of your flow
    -- p_page_id........Optional Page ID number
    -- p_format.........Output format UNIX, DOS, DB, XML
    -- p_commit.........Generate a commit statement at end of script (YES or NO)
    --
    p_flow_id               in number,
    p_theme_id              in number,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

procedure export_tabset (
    p_flow_id               in number,
    p_tabset                in varchar2 default null,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;



--------------------------------------------------------
-- Flow Component Export
--


procedure export_parent_tabset (
    p_flow_id               in number,
    p_tabset                in varchar2 default null,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

procedure export_flow_image_repository (
    p_flow_id               in number,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

procedure export_comp_image_repository (
    p_flow_id               in number,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

procedure create_image_script(
    p_flow_id                 in number,
    p_image_id                in number)
    ;

function create_image_script_clob (
    p_flow_id                 in number,
    p_image_id                in number)
return clob;

procedure create_css_script(
    p_flow_id                  in number,
    p_css_id                   in number)
    ;

function create_css_script_clob (
    p_flow_id                 in number,
    p_css_id                  in number)
return clob;

procedure create_html_script(
    p_flow_id                  in number,
    p_html_id                  in number)
    ;

function create_html_script_clob (
    p_flow_id                 in number,
    p_html_id                 in number)
return clob;


--------------------------------------------------------
-- File Component Export
--

procedure export_css_repository (
    p_flow_id               in number,
    p_css_ids               in wwv_flow_global.vc_arr2,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

procedure export_css_repository (
    p_flow_id               in number,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

procedure export_html_repository (
    p_flow_id               in number,
    p_html_ids              in wwv_flow_global.vc_arr2,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

procedure export_html_repository (
    p_flow_id               in number,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;


procedure export_script (
    p_format           in varchar2 default 'UNIX',
    p_commit           in varchar2 default 'YES')
    ;

-- obsolete
procedure export_image_repository (
    p_flow_id               in number,
    p_name                  in varchar2 default null,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

-- OBSOLETE
procedure export_page_template (
    p_flow_id               in number,
    p_name                  in varchar2 default null,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

-- OBSOLETE
procedure export_region_template (
    p_flow_id               in number,
    p_name                  in varchar2 default null,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

-- OBSOLETE
procedure export_list_template (
    p_flow_id               in number,
    p_name                  in varchar2 default null,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

-- OBSOLETE
procedure export_row_template (
    p_flow_id               in number,
    p_name                  in varchar2 default null,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

-- OBSOLETE
procedure export_field_template (
    p_flow_id               in number,
    p_name                  in varchar2 default null,
    p_format                in varchar2 default 'UNIX',
    p_commit                in varchar2 default 'YES')
    ;

end wwv_flow_gen_api2;
/
show error
