set define '^'
set verify off
prompt ...htmldb_site_admin_privs


Rem  Copyright (c) Oracle Corporation 2003 - 2005. All Rights Reserved.
Rem
Rem    NAME
Rem      htmldb_site_admin_privs
Rem
Rem    DESCRIPTION
Rem      Privilege Management for Site Administrators
Rem
Rem    NOTES
Rem      This package contains functions and procedures used to
Rem      restrict or extend the privileges of site administrators
Rem      who provision workspaces. 
Rem
Rem    USAGE
Rem
Rem       From SQL*Plus:
Rem          exec htmldb_site_admin_privs.report;
Rem
Rem    INTERNATIONALIZATION
Rem
Rem    MULTI-CUSTOMER
Rem      unknown
Rem
Rem    SCRIPT ARGUMENTS 
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED  (MM/DD/YYYY)
Rem    sspadafo   08/11/2004 - Created
Rem    sspadafo   07/11/2005 - Extended
Rem    mhichwa    12/02/2005 - Removed references to names



create or replace package htmldb_site_admin_privs
--
--  Copyright (c) Oracle Corporation 1999 - 2005. All Rights Reserved.
--
--    DESCRIPTION
--      Privilege Management for Site Administrators
--
as

procedure restrict_schema(
    p_schema in varchar2)
    ;
    
procedure unrestrict_schema(
    p_schema in varchar2)
    ;
  
procedure create_exception(
    p_schema    in varchar2,
    p_workspace in varchar2)
    ;

procedure remove_exception(
    p_schema    in varchar2,
    p_workspace in varchar2)
    ;    
    
procedure remove_schema_exceptions(
    p_schema    in varchar2)
    ;    

procedure remove_workspace_exceptions(
    p_workspace    in varchar2)
    ;    
    
procedure report
    ;
  
end htmldb_site_admin_privs;
/
show errors
