set define '^'
set verify off
prompt ...wwv_flow_image_api

Rem    NAME
Rem      imgapi.sql
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    Arguments:
Rem     1:  
Rem     2:
Rem     3:  Flow user
Rem
Rem    MODIFIED (MM/DD/YYYY)
Rem     sdillon  04/13/2001 - Created
Rem     sdillon  05/01/2001 - Cleaned up for integration into flows installation source
Rem     sdillon  05/04/2001 - Added ability to export blobs to varchar2 tables
Rem     sdillon  05/04/2001 - Added ability to create new file objects$ and image repository record fm vc2tab
Rem     sdillon  05/24/2001 - Removed sec group id fm new image repos record
Rem     sdillon  06/04/2001 - Added remove_image(filename,flow_id) procedure
Rem     jkallman 08/18/2003 - Remove write_image (Bug 3063954)
Rem     sspadafo 03/22/2004 - Add g_varchar2_table for export image api to use (Bug 3515462)
Rem     sspadafo 06/24/2006 - Changed package name. This package will contain only private entry points. (Bug 5308534)

create or replace package wwv_flow_image_api_private
as

procedure get_image_details(
    p_id                        in number,
    p_file_object_id           out number,
    p_file_path                out varchar2,
    p_file_name                out varchar2)
    ;

/*
 * create record in wwv_flow_image_repository, and find the associated
 *  record in wwv_flow_file_object$ (key off of p_new_image_name) and
 *  write that blob to the file system
 */
procedure process_new_image(
    p_flow_id                   in number,
    p_image_id                  in number,
    p_image_name                in varchar2,
    p_new_image_name            in varchar2,
    p_nlang                     in varchar2,
    p_height                    in number,
    p_width                     in number,
    p_notes                     in varchar2)
    ;

--
-- F I L E S Y S T E M   I N T E G R A T I O N
--
/* 
 * pass in the image id of the wwv_flow_image_repository record representing
 *  the image you want to drop. If this image does not exist according to the
 *  wwv_flow_image_repository table, this will not work.
 */
procedure remove_image(
    p_id                        in number)
    ;

end wwv_flow_image_api_private;
/
show error
