set define '^'
set feedback off
prompt ...wwv_flow_imp_parser

Rem    NAME
Rem      imp_parser.sql
Rem    Arguments:
Rem     1:  
Rem     2:
Rem     3:  Flow user
Rem    MODIFIED (MM/DD/YYYY)
Rem     cbcho    05/19/2003 - Created
Rem     cbcho    05/21/2003 - Added get_flow_id function
Rem     cbcho    05/21/2003 - Added get_parse_as_schema
Rem     cbcho    05/21/2003 - Added get_security_group_id
Rem     cbcho    05/22/2003 - Added p_parse_as_schema in parse
Rem     cbcho    05/22/2003 - Added get_schema_provisioned
Rem     cbcho    05/23/2003 - Added get_css_name
Rem     cbcho    05/23/2003 - Added get_image_name
Rem     cbcho    06/02/2003 - Added function flow_exists
Rem     cbcho    06/03/2003 - Added function is_company_export
Rem     cbcho    06/06/2003 - Added function get_version
Rem     cbcho    06/11/2003 - Added function get_build_status
Rem     sspadafo 07/04/2003 - Added flow relocation param to parse (Bug 3025348)
Rem     sspadafo 07/05/2003 - Added p_adjust_offset param to parse (Bug 3025348)
Rem     sspadafo 07/07/2003 - Added p_original_flow_id param to parse (Bug 3025348)
Rem     sspadafo 07/10/2003 - Added get_page_id function (Bug 3046586)
Rem     sspadafo 06/15/2004 - Add function get_workspace_schemas (Bug 3689457)
Rem     sspadafo 06/18/2004 - Add support for theme install
Rem     sspadafo 06/24/2004 - Add support for ui defaults
Rem     sspadafo 04/26/2005 - Add function get_workspace_name (Bug 4285727)
Rem     sspadafo 05/31/2006 - Add function is_component_export
Rem     sspadafo 06/05/2006 - Add function get_component_manifest (Bug 5234327)

create or replace package wwv_flow_imp_parser
as
--  Copyright (c) Oracle Corporation 1999 - 2003. All Rights Reserved.
--
--
--    DESCRIPTION
--      This package provides parsing engine for flow export file.
--
--      
--    SECURITY
--      No grants, must be run as FLOW schema owner.
--
--    NOTES
--
--    INTERNATIONALIZATION
--      unknown
--
--    MULTI-CUSTOMER
--      unknown
--
--    CUSTOMER MAY CUSTOMIZE
--      NO
--
--    RUNTIME DEPLOYMENT: YES
--

function get_build_status (p_file_id in number)
return varchar2;


function get_version (p_file_id in number)
return varchar2;

function is_company_export (p_file_id in number)
return boolean;

function flow_exists (p_flow_id in number)
return number;

function get_image_name (p_file_id in number)
return varchar2;

function get_css_name (p_file_id in number)
return varchar2;

function get_workspace_name (p_file_id in number)
return varchar2;

function get_schema_provisioned (p_file_id in number)
return varchar2;

function get_workspace_schemas (p_file_id in number)
return varchar2;

function get_component_manifest (p_file_id in number)
return clob;

function get_flow_id (p_file_id in number)
return number;

function get_page_id (p_file_id in number)
return number;

function get_theme_id (p_file_id in number)
return number;

function get_theme_name (p_file_id in number)
return varchar2;

function get_ui_schema (p_file_id in number)
return varchar2;

function get_security_group_id (p_file_id in number)
return number;

function get_parse_as_schema (p_file_id in number)
return varchar2;

function is_component_export (p_file_id in number)
return boolean;

procedure parse (
  p_file_id           in number,
  p_parse_as_schema   in varchar2 default null,
  p_install_as_flow   in number   default null,
  p_original_flow_id  in number   default null,  
  p_adjust_offset     in boolean  default true,
  p_create_theme      in boolean  default false
  );
    
end wwv_flow_imp_parser;
/
show error;

