
set define '^'
set verify off
prompt ...wwv_flow_meta_data


Rem    SCRIPT ARGUMENTS
Rem      1:  
Rem      2:
Rem      3:  Flow Schema Owner
Rem
Rem    SECURITY
Rem      only executable by flows engine
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED  (MM/DD/YYYY)
Rem      mhichwa  11/13/1999 - Created
Rem      mhichwa  12/09/1999 - Added fetch_toplevel_tab_info
Rem      mhichwa  01/09/2000 - Removed alt_flow_step_id argument
Rem      mhichwa  01/12/2000 - Added fetch_page_plugs function
Rem      mhichwa  02/19/2000 - Moved fetch_template_preference from fetch_flow_info
Rem      mhichwa  05/02/2000 - Added g_first_displayable_field global
Rem      mhichwa  11/08/2000 - Added static subs
Rem      mhichwa  12/12/2000 - fetch_required_roles is obsolete
Rem      mhichwa  12/22/2000 - Added security checks passed global
Rem      mhichwa  12/26/2000 - Added security checks failed
Rem      mhichwa  01/20/2001 - Added g_on_new_instance_fired_for
Rem      mhichwa  08/01/2001 - Set sec failed and fast to 4000 from 5000 bytes
Rem      tmuth    10/03/2002 - Changed g_first_displayable_field to 50 char instead of 8
Rem      mhichwa  10/20/2002 - Added fetch_show and accept processing
Rem      sspadafo 12/27/2002 - Added fetch_show_branch_info and fetch_accept_branch_info (Bug 2729764)
Rem      sspadafo 02/09/2003 - Added globals for new build option evaluation method (Bug 2748385)
Rem      sspadafo 02/10/2003 - Added functions fetch_g_build_options_.. to return build option globals (Bug 2748385)
Rem      sspadafo 02/08/2005 - Added fetch_protected_item_ids, fetch_protected_page_info procedures for URL tampering feature
Rem      sspadafo 02/27/2006 - Remove obsolete fetch_process_info
Rem      sspadafo 04/23/2006 - Added fetch_public_page_info for zero session ID feature
Rem      sspadafo 12/03/2007 - Removed fetch_protected_item_ids procedure
Rem      sspadafo 01/09/2009 - Removed obsolete procedure fetch_branch_info

create or replace package wwv_flow_meta_data
--  Copyright (c) Oracle Corporation 1999. All Rights Reserved.
--
--    DESCRIPTION
--      Fetch meta data for flow rendering
--
--    SECURITY
--
--    NOTES
--      Information required to render and process page information is queried from
--      tables using this package.  Template information is queried using the
--      wwv_flow_templates_util package.
as
g_first_displayable_field varchar2(50) := null;
g_static_substitution_string   wwv_flow_global.vc_arr2;
g_static_substitution_value    wwv_flow_global.vc_arr2;
g_sec_checks_passed            varchar2(4000) := null;
g_sec_checks_failed            varchar2(4000) := null;
g_on_new_instance_fired_for    varchar2(4000) := null;
g_build_options_included       varchar2(32767) := null;
g_build_options_excluded       varchar2(32767) := null;
--
-- flow level fetch
--
procedure fetch_items_on_new_instance
;
function  fetch_flow_info return number
;
procedure fetch_template_preference
;
function  fetch_icon_bar_info return number
;
--
-- page level fetch
--
function  fetch_step_info return number
;
function  fetch_tab_info return number
;
function  fetch_toplevel_tab_info (p_tabset in varchar2) return number
;
function  fetch_button_info return number
;
function  fetch_show_branch_info return number
;
function  fetch_accept_branch_info return number
;
function  fetch_item_info return number
;

function  fetch_show_process_info return number
;
function  fetch_accept_process_info return number
;


--function  fetch_required_roles return number OBSOLETE 12.12.00
--;
function fetch_g_build_options_included return varchar2
;
function fetch_g_build_options_excluded return varchar2
;
function  fetch_computations return number
;
function  fetch_page_plugs return number
;
procedure fetch_protected_page_info
;
procedure fetch_public_page_info
;
end wwv_flow_meta_data;
/
show errors
