
set define '^'
set verify off
prompt ...p.sql

Rem    SCRIPT ARGUMENTS
Rem      1:
Rem      2:
Rem      3:  Flow Schema Owner
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem     mhichwa    02/05/2001 - Created
Rem     rmattama   02/26/2003 - Added p_inline parm
Rem     jstraub    07/24/2003 - Replaced htp.p English text with system_message (Bug 3059228)
Rem     sspadafo   01/22/2008 - Removed 'grant all on p to public' (Bug 6596802)

create or replace procedure p (
    n       in varchar2 default null,
    p_mime_type in varchar2 default null,
    p_inline    in varchar2 default 'NO')

-- Copyright (c) Oracle Corporation 2001. All Rights Reserved.
--
--    DESCRIPTION
--      View a page given a page ID
--
--    SECURITY
--      Public shortcut
--
--    NOTES
--
--    EXAMPLES: 
--

is
begin
     if n is null then
         htp.p(wwv_flow_lang.system_message('p.valid_page_err'));
         return;
     end if;
     --
     wwv_flow_file_mgr.get_file (
        p_id => n,
        p_mime_type => p_mime_type,
        p_inline => p_inline); 
end p;
/
show errors

grant execute on p to public;

