set define '^'
set verify off
prompt ...wwv_flow_platform

Rem
Rem    SCRIPT ARGUMENTS
Rem      none
Rem
Rem    INTERNATIONALIZATION
Rem      unknown
Rem
Rem    MULTI-CUSTOMER
Rem      unknown
Rem
Rem    SCRIPT ARGUMENTS
Rem      none
Rem
Rem    RUNTIME DEPLOYMENT: NO
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      mhichwa  03/04/2001 - Created
Rem      mhichwa  03/26/2001 - changes pres to pref
Rem      mhichwa  04/18/2001 - Changed platform pref to platform prefs
Rem      jkallman 05/17/2005 - Added set_preference
Rem      nagkrish 11/12/2007 - If workspace creation via email notification is re-enabled, corresponding system message is deleted.


create or replace package wwv_flow_platform 
as
--  Copyright (c) Oracle Corporation 2005. All Rights Reserved.
--
--    DESCRIPTION
--
--    SECURITY
--      For use only as an internal function call
--
--    NOTES
--


------------------------------
-- G E T   P R E F E R E N C E
-- preference names include:
--    EXP_COMMAND_PATH = command path used to execute the export and import utilities
--
function get_preference (
   p_preference_name in varchar2)
   return varchar2
   ;

procedure set_preference (
   p_preference_name  in varchar2,
   p_preference_value in varchar2 );
   
   
end wwv_flow_platform;
/
show errors

create or replace package body wwv_flow_platform 
as

function get_preference (
   p_preference_name in varchar2)
   return varchar2
is
begin
   for c1 in (select value v from wwv_flow_platform_prefs where name = p_preference_name) loop
     return c1.v;
   end loop;
   return null;
end get_preference;

procedure set_preference (
   p_preference_name  in varchar2,
   p_preference_value in varchar2 )
is
begin
    --
    -- As null preference values are not permitted, a null value is an implicit delete
    --
    if p_preference_value is null then
        delete from wwv_flow_platform_prefs
         where name = p_preference_name;
       
       if p_preference_name = 'DISABLE_WS_PROV' then
          delete from wwv_flow_platform_prefs
           where name = 'DISABLE_WS_MSG';
       end if;
    else
        update wwv_flow_platform_prefs
           set value = p_preference_value
         where name = p_preference_name;
        --
        -- If the row wasn't found, then this implies insert
        --
        if SQL%ROWCOUNT = 0 then
            insert into wwv_flow_platform_prefs( name, value )
            values( p_preference_name, p_preference_value );
        end if;
    end if;
end set_preference;


end wwv_flow_platform;
/
show errors
