set define '^'
prompt ...wwv_flow_query_api

Rem
Rem    NAME
Rem      wwv_flow_query_api
Rem
Rem    DESCRIPTION
Rem      This package is used to support creating and manipulating structured queries.
Rem
Rem    NOTES
Rem
Rem    INTERNATIONALIZATION
Rem      unknown
Rem
Rem    MULTI-CUSTOMER
Rem      unknown
Rem
Rem    RUNTIME DEPLOYMENT: NO
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jstraub   04/30/2003 - Created
Rem      jstraub   05/06/2003 - Modified per UI review
Rem      jstraub   05/07/2003 - Added update_structured_query procedure
Rem      jstraub   05/08/2003 - Added update_joins procedure
Rem      jstraub   05/09/2003 - Parameterized spaces and linebreaks in get_conditions
Rem      jstraub   05/13/2003 - Modified create_structured_query to tie structured_query to region_id
Rem      jstraub   05/15/2003 - Added p_flow_id and p_region_id to update_structured_query
Rem      jstraub   05/19/2003 - Added p_collection parameter to reorder_columns
Rem      jstraub   05/27/2003 - Added get_alias procedure
Rem      cbcho     04/15/2004 - Changed create_structured_query,update_structured_query to use p_collection instead of 'COLUMNS'

create or replace package wwv_flow_query_api as

    g_conditions wwv_flow_global.vc_arr2;
    g_columns    wwv_flow_global.vc_arr2;
    g_rows       wwv_flow_global.vc_arr2;
    g_y          wwv_flow_global.vc_arr2;
    g_index      number;
    g_emptyvc    wwv_flow_global.vc_arr2;

    function add_columns(
      p_condition   in varchar2,
      p_column      in varchar2 ) return varchar2;

    function get_conditions(
      p_query_id    in varchar2,
      p_new_line    in varchar2 := chr(10),
      sp            in varchar2 := ' ' ) return clob;

    function get_structured_query(
      p_id          in number ) return clob;
      
    procedure get_alias(
      p_column      in varchar2,
      p_query_id    in number,
      p_num         in number := 1 );

    procedure parse_conditions(
      p_query_id    in number,
      p_id          in number,
      p_top_id      in number );

    procedure create_collection(
      p_query_id    in number );

    procedure create_conditions(
      p_query_id    in number );
      
    procedure create_structured_query(
      p_flow_id     in number,
      p_region_id   in number,
      p_collection  in varchar2 default 'COLUMNS');
      
    procedure update_query_sql(
      p_query_id    in number);      
      
    procedure delete_structured_query(
      p_query_id    in number );
      
    procedure reorder_columns(
      p_query_id    in number,
      p_collection  in varchar2 default null );     
      
    procedure update_structured_query(
      p_query_id    in number,
      p_flow_id     in number,
      p_region_id   in number,
      p_collection  in varchar2 default 'COLUMNS');     
      
    procedure update_joins(
      p_query_id    in number);      
      
        

end wwv_flow_query_api;
/
show errors