set define '^'

set verify off
prompt ...marvel_runtime


Rem  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      rt_home.sql
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem       jstraub  10/02/2001 - Created
Rem       jstraub  10/05/2001 - Changed wording of message

------------------
-- R U N T I M E
--
prompt ...marvel_runtime

create or replace procedure marvel_runtime (
    p_session in number default null)
as
    l_company_installed BOOLEAN := FALSE;
begin
    for c1 in (select 1 from wwv_flow_companies where provisioning_company_id > 20) loop
        l_company_installed := TRUE;
        exit;
    end loop;
    if l_company_installed then
        wwv_flow.show(p_instance=>p_session,p_flow_step_id=>'7',p_flow_id=>'4750');
    else
        htp.p('<p>A company has not been installed in this runtime installation. ');
        htp.p('<p>You will need to install your company from Project Marvel to ');
        htp.p('login properly.  <p>You can test this installation by clicking ');
        htp.p('<a href="application_authentication.home">here</a> and logging in ');
        htp.p('as company => internal, user => flows, password => flows. ');
        htp.p('<p>Reference the following sections of the <i>Runtime Installation Guide</i> ');
        htp.p('(link provided in readme.html):');
        htp.p('<ul><li>Installing your company<li>marvel_runtime<li>application_authentication</ul>');
    end if;
end;
/
grant execute on marvel_runtime to public
/
