Rem  Copyright (c) Oracle Corporation 1999 - 2008. All Rights Reserved.
Rem
Rem    NAME
Rem      runtime_grant_revoke.sql
Rem
Rem    DESCRIPTION
Rem      Removes unnecessary DBA system privileges for a runtime Oracle Application Express environment.
Rem
Rem
Rem    REQUIREMENTS
Rem      - Oracle database 9.2.0.3 or better
Rem      - PL/SQL Web Toolkit
Rem
Rem
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jstraub   11/26/2007 - Created
Rem      sspadafo  07/30/2008 - Added conditional block for revoke of alter user privilege
Rem      sspadafo  09/09/2008 - Fixed syntax error in execute immediate for 'revoke alter user ...'

revoke create procedure from ^APPUN;
revoke create user from ^APPUN;
revoke create any context from ^APPUN;
revoke create role from ^APPUN;
revoke create dimension from ^APPUN;
revoke create indextype from ^APPUN;
revoke create type from ^APPUN;
revoke create sequence from ^APPUN;
revoke create synonym from ^APPUN;
revoke create operator from ^APPUN;
revoke create materialized view from ^APPUN;
revoke create view from ^APPUN;
begin
    if wwv_flow_utilities.db_version_is_at_least('10.2.0.3') or wwv_flow_utilities.db_edition_is_xe then
        execute immediate 'revoke alter user from ^APPUN';
    end if;
end;
/
revoke create tablespace from ^APPUN;
revoke create trigger from ^APPUN;
revoke alter database from ^APPUN;
revoke create cluster from ^APPUN;
revoke create table from ^APPUN;
