set define '^'
set verify off
prompt ...create flow objects



Rem  Copyright (c) Oracle Corporation 1999 - 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      tab.sql
Rem
Rem    DESCRIPTION
Rem      Flow object creation script.  Create tables, views,
Rem      sequences, Indexes
Rem
Rem    NOTES
Rem      Tables that describe a given flow.  Every attribute relates
Rem      back to the ID column of the WWV_FLOWS table.
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem       mhichwa  08/04/1999 - Created
Rem       mhichwa  09/29/1999 - Removed flow_logging column from wwv flows
Rem       mhichwa  09/30/1999 - Added constraint names
Rem       mhichwa  09/30/1999 - Removed show_reset column from wwv flow steps table
Rem       mhichwa  09/30/1999 - Removed columns tab_*_gif* columns from wwv_flow_tabs
Rem       mhichwa  09/30/1999 - Removed column onload_javascript from wwv_flow_tabs
Rem       mhichwa  10/08/1999 - Removed step_sub_title_font_color column from wwv flow_steps
Rem       mhichwa  10/13/1999 - Added Banner Table
Rem       mhichwa  10/13/1999 - Added unique index on flow template name
Rem       mhichwa  10/14/1999 - Added flow_language column to wwv flows table
Rem       mhichwa  10/14/1999 - Added wwv_flow_languages table
Rem       mhichwa  10/14/1999 - Added wwv_flow_language_map table
Rem       mhichwa  10/17/1999 - Removed success_procedure and success_url from wwv flow_steps
Rem       mhichwa  10/17/1999 - Added not null constraint to wwv flows name
Rem       mhichwa  10/18/1999 - Added flow preferences table
Rem       mhichwa  10/18/1999 - Added wwv_flow_dependancies table
Rem       mhichwa  10/20/1999 - Added success_message, current_tab, and non_current_tab to template
Rem       mhichwa  10/21/1999 - Added Comments to template, proc, item, page, icons etc.
Rem       mhichwa  10/22/1999 - Changed wwv_flow_languages and wwv_flow_language_map columns
Rem       mhichwa  10/23/1999 - Added flow_image_prefix column to wwv flows table
Rem       mhichwa  10/26/1999 - Added translatable text tables
Rem       mhichwa  11/02/1999 - Added BEFORE_SHOW_ITEMS, AFTER_SHOW_ITEMS processing points
Rem       mhichwa  11/02/1999 - Added button_image_attributes column
Rem       mhichwa  11/03/1999 - Added branch types: REQUEST_IN_CONDITION, REQUEST_EQUALS_CONDITION
Rem       mhichwa  11/08/1999 - Changed wwv_flow trigger to default home link if null on insert
Rem       mhichwa  11/08/1999 - Added current_tab_font_attr, non_current_tab_font_attr, box cols to wwv_flow_templates
Rem       mhichwa  11/10/1999 - Added table wwv_flow_dynamic_translations$
Rem       mhichwa  11/13/1999 - Check that button position is not null
Rem       mhichwa  11/15/1999 - Added table wwv_flow_lists_of_values$
Rem       mhichwa  11/15/1999 - Added named_lov to wwv flow step_items table, adjusted triggers
Rem       mhichwa  11/16/1999 - Modified trigger on wwv_flow lists_of_values$ to cascade updates to wwv_flow step_items
Rem       mhichwa  11/16/1999 - Added not null constraints to wwv flow_steps table
Rem       mhichwa  11/23/1999 - Added tab_non_current_image, tab_image_attributes columns
Rem       mhichwa  12/01/1999 - Added body_title column
Rem       mhichwa  12/02/1999 - Added current_image_tab, non_current_image_tab, look columns to template
Rem       mhichwa  12/02/1999 - Added icon_image2, 3, icon_height2,3 icon_width2, 3
Rem       mhichwa  12/03/1999 - Added icon_sub_text1,2,3
Rem       mhichwa  12/07/1999 - Added patch concept, required_patch, wwv_flow_patches table, tab_parent_page...
Rem       mhichwa  12/08/1999 - Added STOP_AND_START_HTML_TABLE check option
Rem       mhichwa  12/08/1999 - Increased size of prompt from 255 to 4000 bytes
Rem       mhichwa  12/09/1999 - Change parent tab from number to varchar2 change name to tab_parent_tabset
Rem       mhichwa  12/12/1999 - Added wwv_flow_template_preferences table
Rem       mhichwa  12/13/1999 - Added default_button_position to template
Rem       mhichwa  12/14/1999 - Added TEMPLATE_DEFAULT to wwv_flow step buttons
Rem       mhichwa  12/15/1999 - Added attribute5,6
Rem       mhichwa  12/19/1999 - Added BEFORE_HEADER branch point
Rem       mhichwa  12/19/1999 - Added tab_also_current_for_pages column
Rem       mhichwa  01/02/2000 - Added table wwv_flow_purged_sessions$ to track purges generated by flowc.plb
Rem       mhichwa  01/07/2000 - Modified trigger wwv_biu_step_items to include flow_id in select statement
Rem       mhichwa  01/09/2000 - Depricated initial_occurs and max_occurances columns
Rem       mhichwa  01/09/2000 - Added translation_specific_to_item and text_substr_1_255 columns
Rem       mhichwa  01/11/2000 - Removed on delete cascade from translated_flow_id
Rem       mhichwa  01/12/2000 - Added plug tables and triggers
Rem       mhichwa  01/15/2000 - Added indexes and constraint names to page_plug tables
Rem       mhichwa  01/15/2000 - Added indexes to step buttons, branches, validations, processes, and computations
Rem       mhichwa  01/20/2000 - Added AFTER_ERROR_HEADER, BEFORE_ERROR_FOOTER
Rem       mhichwa  01/20/2000 - Added error_template, authentication, login_url
Rem       mhichwa  01/21/2000 - Added cookie to  table wwv_flow_sessions$
Rem       mhichwa  01/22/2000 - Removed page on delete cascade from wwv flow page plugs
Rem       mhichwa  01/23/2000 - Added logout_url
Rem       mhichwa  01/24/2000 - Added public_url_prefix
Rem       mhichwa  01/26/2000 - Depricated icon_bar (navbar) lov fields (3)
Rem       mhichwa  01/26/2000 - Added button_plug_id, item_plug_id
Rem       mhichwa  01/28/2000 - Changed index on plug_name to append flow_id
Rem       mhichwa  01/31/2000 - Added table_bgcolor,table_cattributes,heading_bgcolor,font_size,font_face
Rem       mhichwa  01/31/2000 - Added plug_header,footer,font_size,table_bgcolor,heading_bgcolor
Rem       mhichwa  01/31/2000 - Added on delete cascade to plug page to flow page foreign key.
Rem       mhichwa  02/02/2000 - Changed box from varchar2(4000) to clob.
Rem       mhichwa  02/03/2000 - Added SQL_QUERY to plug_source_type
Rem       mhichwa  02/03/2000 - Added wwv_flow_row_template table
Rem       mhichwa  02/11/2000 - Enhanced dynamic translations table
Rem       mhichwa  02/11/2000 - Added wwv_flow_bugs and wwv_flow_developers table
Rem       mhichwa  02/12/2000 - Added additional translatable text tables
Rem       mhichwa  02/14/2000 - Added wwv_flow_dual100 table to facilitate the building of lists of values
Rem       mhichwa  02/17/2000 - Added tables wwv_flow_lists and wwv_flow_list_items
Rem       jkallman 02/18/2000 - Added index wwv_flow_step_item_idx2
Rem       mhichwa  02/19/2000 - Changed implementation of bugs, added wwv_flow_developer_roles table
Rem       mhichwa  02/20/2000 - Added navigation condition types
Rem       mhichwa  02/20/2000 - Added FILE and BUTTON to item types
Rem       mhichwa  02/22/2000 - Change wwv_id to wwv_flow_id
Rem       mhichwa  02/22/2000 - Added button_image and button_image_attr to wwv_flow step_items
Rem       mhichwa  02/23/2000 - Added label_cell_attr, field_cell_attr, added index to ensure unique page,sequence (items)
Rem       mhichwa  02/24/2000 - Added alt_lov (alternative lists of values tables)
Rem       mhichwa  03/02/2000 - Added tab_condition, translation_image_directory
Rem       mhichwa  03/16/2000 - Added button_redirect_url, clear_page_cache for branches
Rem       mhichwa  04/08/2000 - Added display_only_lov
Rem       mhichwa  04/08/2000 - Prefixed some constraints with wwv_
Rem       mhichwa  04/16/2000 - flow_step_item name not null constraint added
Rem       mhichwa  04/16/2000 - changed syntax for create index statements for table wwv flow step_items
Rem       mhichwa  04/16/2000 - removed commented out check constraints for table wwv flow step_items
Rem       mhichwa  04/18/2000 - Added COMBOBOX_WITH_SUBMIT
Rem       mhichwa  04/18/2000 - Force item name to upper case in wwv_biu_step_items trigger
Rem       mhichwa  04/21/2000 - Changed trigger on button table to prevent creating buttons the same name as tabs.
Rem       mhichwa  04/21/2000 - flow_items.name set to upper in trigger
Rem       mhichwa  04/25/2000 - Added condition in reqest and request is numeric branch condition types
Rem       mhichwa  04/27/2000 - Added display_and_save_lov
Rem       mhichwa  05/02/2000 - Added list_item_current_for_pages column
Rem       mhichwa  05/03/2000 - Added wwv_bd_flowpageplugs to set page item plug ids to null on delete of plugs
Rem       mhichwa  05/03/2000 - Added REQUEST_IN_CONDITION type to wwv_flow_step_processing
Rem       mhichwa  05/14/2000 - Added extra cell positioning, added TEXTAREA-AUTO-HEIGHT
Rem       mhichwa  05/15/2000 - Added request equals condition to wwv_flow_step_computations
Rem       mhichwa  05/16/2000 - Added rtrim of process_sql for page processes
Rem       mhichwa  05/16/2000 - Modified plug delete trigger to only null plug id of deleted plug. fixes bug.
Rem       mhichwa  05/16/2000 - Added process_when_button_id
Rem       mhichwa  05/19/2000 - Added constraints to wwv_flow_patches, added wwv_flow_messages table
Rem       mhichwa  05/19/2000 - Removed alt_lov tables and table wwv_flow_translations
Rem       mhichwa  05/19/2000 - Added two display_as types: 'COMBOBOX_WITH_JS_POST', 'COMBOBOX_WITH_JS_REDIRECT'
Rem       mhichwa  05/24/2000 - Added validation_condition, validation_condition_type
Rem       mhichwa  05/26/2000 - Modify wwv_biu_flowrowtemplates
Rem       mhichwa  05/30/2000 - Added dbauth_url_prefix, proxy_server to wwv flows
Rem       mhichwa  05/31/2000 - Added plug_query_format_out _show_nulls_as _col_allignments _break_cols _sum_cols
Rem       mhichwa  06/02/2000 - Added first_item, changed references from Plug to region
Rem       mhichwa  06/03/2000 - Added lov_null_text, and lov_null_value
Rem       mhichwa  06/04/2000 - Added to wwv flow page plugs plug_query_number_formats
Rem       mhichwa  06/05/2000 - Added custom_authentication_process, custom_authentication_page
Rem       mhichwa  06/05/2000 - Changed WWV_FLOW_STEP_ITEM_IDX3 to be non unique
Rem       mhichwa  06/06/2000 - Changed trigger on wwv flow step_items to ignore errors on missing LOV
Rem       mhichwa  06/07/2000 - Added list_item_disp_condition
Rem       mhichwa  06/08/2000 - Added after authentication processing point
Rem       mhichwa  06/09/2000 - Added lov_translated
Rem       mhichwa  06/11/2000 - Added plug_display_condition_type
Rem       mhichwa  06/11/2000 - Added flow public_user
Rem       mhichwa  06/12/2000 - Added 'ITEM_IS_NULL', 'ITEM_IS_NOT_NULL' page validation types
Rem       mhichwa  06/13/2000 - Added wwv_flow_list_of_values_data, plug cond display types, button disp cond types
Rem       mhichwa  06/15/2000 - Added FUNC_BODY_RETURNING_ERR_TEXT
Rem       mhichwa  06/15/2000 - Modified trigger wwv_biu_step_validations
Rem       mhichwa  06/15/2000 - Added tab display condition types
Rem       mhichwa  06/16/2000 - Added CONDITION_IN_REQUEST to check constraint for page processes
Rem       mhichwa  06/17/2000 - Added button condition type MIN_ROW_GT_THAN_ONE ... to check const.
Rem       mhichwa  06/18/2000 - Added branch_when_button_id
Rem       mhichwa  06/18/2000 - added 'PAGE_IS_IN_PRINTER_FRIENDLY_MODE', 'PAGE_IS_NOT_IN_PRINTER_FRIENDLY_MODE'
Rem       mhichwa  06/19/2000 - Fixed error in branch_when_button_id column on create branch table
Rem       mhichwa  06/21/2000 - Added display_as options PICK_DATE_DD_MON_YYYY PICK_DATE_DD_MM_YYYY PICK_DATE_MM_DD_YYYY
Rem       mhichwa  06/21/2000 - flow_page_range_minimum, flow_page_range_maximum
Rem       jkallman 06/21/2000 - Added wwv_flow_months_mon, wwv_flow_months_month, wwv_flow_years
Rem       mhichwa  06/21/2000 - Added pick_date_dd_mon_yy
Rem       mhichwa  06/23/2000 - Expanded condition types for many tables (starting to fix expresion misspelling issue)
Rem       mhichwa  06/23/2000 - Modified trigger on flow_steps to check for valid page ranges
Rem       mhichwa  06/26/2000 - Added additional button positions
Rem       mhichwa  06/26/2000 - Added additional validation condition types
Rem       mhichwa  06/28/2000 - Adjusted  wwv_valid_fsval_valtype constraint
Rem       mhichwa  07/03/2000 - Added plug_column_width
Rem       mhichwa  07/05/2000 - Added not_exists to page validation types
Rem       mhichwa  07/07/2000 - Fixed check constraint on step_validations EXISTS was mission comma
Rem       mhichwa  07/07/2000 - Added trigger to set branch condition type to null if = %null%
Rem       mhichwa  07/10/2000 - Added region_table_cattributes column.
Rem       mhichwa  07/10/2000 - Modified constraint wwv_valid_plug_disppoint
Rem       mhichwa  07/12/2000 - Added text_with_calculator to check constraint
Rem       mhichwa  07/13/2000 - Added CURRENT_PAGE_IN_CONDITION and not in condition to region display types
Rem       mhichwa  07/13/2000 - Changed all foreign keys to wwv_flow_step items to reference page flow_id, id
Rem       mhichwa  08/15/2000 - Adjusted constraint wwv_valid_fsval_valtype added item not zero
Rem       mhichwa  08/19/2000 - Add page item help text table
Rem       mhichwa  08/22/2000 - Added image repository table
Rem       mhichwa  08/24/2000 - Expanded constraint wwv_valid_plug_disppoint to include 20 display regions
Rem       mhichwa  08/30/2000 - Added effective USER ID Capabilities.
Rem       mhichwa  09/03/2000 - Added prompt comments
Rem       mhichwa  09/04/2000 - Added shortcut table
Rem       mhichwa  09/07/2000 - Extended tab condition type to varchar2 255
Rem       mhichwa  09/19/2000 - Added flow status column
Rem       mhichwa  09/20/2000 - Added restrict_to_user_list
Rem       mhichwa  09/21/2000 - Added RADIOGROUP_WITH_JS_SUBMIT check cons
Rem       mhichwa  09/24/2000 - Added CURRENT_LOOK_IS_1 .. 3 for icon bar
Rem       mhichwa  09/28/2000 - Added java_entry_point
Rem       mhichwa  10/02/2000 - Added trigger for tab also current
Rem       mhichwa  10/16/2000 - Modified column name page plug query border
Rem       mhichwa  10/18/2000 - Added text area with controls
Rem       mhichwa  10/19/2000 - Added plug_query_headings_type
Rem       mhichwa  10/25/2000 - Added wwv_flow_temp_table
Rem       mhichwa  10/31/2000 - Added plug caching to wwv flow page plugs
Rem       jkallman 11/01/2000 - Added wwv_flow_mail_log, wwv_flow_mail_queue
Rem       mhichwa  11/01/2000 - Added item is null and item is not null to wwv_val_fscomp_compwhentype
Rem       mhichwa  11/02/2000 - Added preference to wwv_valid_fsitem_sourcetype
Rem       mhichwa  11/02/2000 - Added set preference to item value to wwv_valid_fsproc_type
Rem       mhichwa  11/02/2000 - Added SET_PREFERENCE_TO_ITEM_VALUE_IF_ITEM_NOT_NULL
Rem       mhichwa  11/07/2000 - Added list_item_disp_cond_type2, list_item_disp_condition2
Rem       mhichwa  11/08/2000 - Added substitution strings and values to wwv flows
Rem       mhichwa  11/17/2000 - Added region types url returning xml and query returning xml
Rem       mhichwa  11/21/2000 - Added computation_error_message
Rem       mhichwa  11/29/2000 - Added list_item_current_type column
Rem       mhichwa  12/01/2000 - Added always and never list item current types
Rem       mhichwa  12/07/2000 - Added vpd attribute to wwv flows table
Rem       mhichwa  12/08/2000 - Added security group ID to wwv flows table
Rem       mhichwa  12/08/2000 - Added computation_error_message to flow_computations
Rem       mhichwa  12/09/2000 - Added wwv_flow_security_schemes table
Rem       mhichwa  12/11/2000 - Added SET_ITEM_EQUAL_THIS_PREFERENCE
Rem       mhichwa  12/14/2000 - Added WWV_FLOW_LIST_ITEMS to translatable columns
Rem       mhichwa  12/15/2000 - Added flow_id to flow_list_items to make translations possable
Rem       mhichwa  12/15/2000 - Added when text to tabs and flow computations
Rem       mhichwa  12/18/2000 - Added branch_condition_text column
Rem       mhichwa  12/19/2000 - Added condition text
Rem       mhichwa  12/20/2000 - Removed javascript column from wwv flow step_items
Rem       mhichwa  12/20/2000 - Added security_scheme column to wwv flow step_items
Rem       mhichwa  12/20/2000 - added upper owner to trigger on flows table
Rem       jkallman 12/20/2000 - Added wwv_flow_file_objects$ table, trigger and comments
Rem       mhichwa  12/20/2000 - Added security_scheme column to tabs, parent tabs, nav bar items, and buttons
Rem       mhichwa  12/21/2000 - Added security group ID to a large number of tables
Rem       mhichwa  12/22/2000 - Expanded flow privileges to include new monitor, sql, and browse privs
Rem       mhichwa  12/22/2000 - Added caching and comments to security schemes table
Rem       mhichwa  12/22/2000 - Added security scheme column to wwv flows table
Rem       mhichwa  12/26/2000 - Added failed_sec_checks to sessions table
Rem       mhichwa  01/11/2001 - Added pipe and backslash delimited region report heading types
Rem       mhichwa  01/12/2001 - Added user manager role
Rem       mhichwa  01/12/2001 - Added tag_attributes to flow step items
Rem       mhichwa  01/12/2001 - Added cookie_session_id
Rem       mhichwa  01/12/2001 - Removed think time and page view columns from sessions table
Rem       mhichwa  01/15/2001 - Changed trigger on sessions table
Rem       mhichwa  01/15/2001 - Added support for FUNCTION_BODY_RETURNING_PIPE_DELIMITED_LIST
Rem       mhichwa  01/16/2001 - Added application tabs and application tab sets
Rem       mhichwa  01/16/2001 - Added app tab attributes to page templates
Rem       mhichwa  01/16/2001 - Added application tab set to wwv flows
Rem       mhichwa  01/17/2001 - Added process sql clob to two tables
Rem       mhichwa  01/20/2001 - Added on_new_instance_fired_for
Rem       mhichwa  01/21/2001 - Added zero button display and region display conditions
Rem       mhichwa  01/23/2001 - Added wwv_flow_alternate_config tables
Rem       mhichwa  01/24/2001 - Added build options to configuration
Rem       mhichwa  01/25/2001 - Added added two additional branch condition types
Rem       jkallman 01/26/2001 - Added 15 additional columns to wwv_flow_temp_table
Rem       mhichwa  01/26/2001 - Added two cond types to page computatations
Rem       mhichwa  01/26/2001 - Added item is not null or zero constraint to page plugs and buttons
Rem       mhichwa  01/27/2001 - Added orcl and demo companies
Rem       mhichwa  01/28/2001 - Added indexes to company table
Rem       mhichwa  01/31/2001 - Extended wwv_flow_app_cond_types
Rem       mhichwa  02/02/2001 - Extended trigger to file upload
Rem       mhichwa  02/02/2001 - Added wwv_flow_dynamic_pages table
Rem       mhichwa  02/06/2001 - Updated flow trigger
Rem       mhichwa  02/10/2001 - Added expand and parent id to list items
Rem       mhichwa  02/10/2001 - Added COMBOBOX_WITH_URL_REDIRECT, COMBOBOX_WITH_BRANCH_TO_PAGE
Rem       mhichwa  02/11/2001 - Added not null or zero constraint for page items
Rem       mhichwa  02/12/2001 - Added not null constraint to flow developers table
Rem       mhichwa  02/14/2001 - Added list of values temp table (sdillon)
Rem       mhichwa  02/16/2001 - Added set sec group id to most triggers and some tables
Rem       mhichwa  02/21/2001 - Changed wwv_flow_lov_values inserts to specify column values
Rem       mhichwa  02/21/2001 - Added item not null constraint for validations
Rem       mhichwa  02/22/2001 - Added insert order to lov temp table
Rem       mhichwa  02/23/2001 - Changed indexes on companies table
Rem       mhichwa  02/24/2001 - Changed security group id 10 to FLOWS from ORCL
Rem       mhichwa  02/25/2001 - Added company schemas
Rem       mhichwa  02/27/2001 - Added cbcho sql workshop create table statements
Rem       cbcho    02/27/2001 - Added comma to wwv_flow_sw_parameters create table stmt.
Rem       jstraub  02/28/2001 - Moved triggers to trigger.sql
Rem       tmuth    02/28/2001 - Added coulmns to mail_queue for html mail
Rem       mhichwa  03/01/2001 - Added not null constraint to branch type
Rem       mhichwa  03/01/2001 - FUNCTION_BODY_RETURNING_BOOLEAN added to buttons
Rem       mhichwa  03/01/2001 - Added PLSQL_DBMS_JOB
Rem       mhichwa  03/01/2001 - Added button alignment
Rem       cbcho    03/01/2001 - Added indexes to SQL Workshop table foreign keys
Rem       mhichwa  03/03/2001 - Addded custom auth login url
Rem       mhichwa  03/04/2001 - Depricated page range min and max values
Rem       sdillon  03/05/2001 - Removed unneeded mail queue alter scripts
Rem       sdillon  03/05/2001 - Fixed ...insert call to prompt ...insert
Rem       mhichwa  03/05/2001 - Added security group ID columns to _sw_ sql workshop tables
Rem       mhichwa  03/08/2001 - Added extra columns to support row template translations
Rem       mhichwa  03/13/2001 - Added tree
Rem       cbcho    03/13/2001 - Added SQL Workshop - Control File create table statements
Rem       cbcho    03/13/2001 - Added ctrlfile_stats_id, wwv_flow_sw_stat_fk2, and wwv_flow_sw_stats_idx2
Rem                             on wwv_flow_sw_statistics table
Rem       cbcho    03/13/2001 - Added more wwv_flow_sw_valid_file table insert stmts.
Rem       sdillon  03/14/2001 - Added tables,indexes,etc for wwv_flow_plsql_job,wwv_flow_job
Rem       mhichwa  03/14/2001 - added flow item to tree table
Rem       mhichwa  03/15/2001 - Added plug query no data found
Rem       mhichwa  03/16/2001 - Added wwv_flow_file_objects$part
Rem       mhichwa  03/17/2001 - Added wwv_flow_sw_ctrlfile_stats
Rem       cbcho    03/22/2001 - Changed wwv_flow_sw_cf_idx index creation on wwv_flow_sw_ctrl_files table
Rem       cbcho    03/22/2001 - Changed command column data type to clob on wwv_flow_sw_sql_cmds table
Rem       sdillon  03/22/2001 - Added user_id to wwv_flow_developers for referential integrity to wwv_flow_fnd_user
Rem       mhichwa  03/26/2001 - Added platform imp exp tables
Rem       mhichwa  03/26/2001 - Added file type column flow file objects
Rem       sleuniss 03/28/2001 - Added security group id to wwv_flow_import_export
Rem       sleuniss 03/29/2001 - created by id, schema_name and created by
Rem                             to wwv_flow_import_export
Rem       sdillon  03/30/2001 - Added demo_id to wwv_flow_companies
Rem       mhichwa  03/30/2001 - Made wwv flow owner not null
Rem       sdillon  04/03/2001 - Added first_schema_provisioned to wwv_flow_companies
Rem       sleuniss 04/03/2001 - set FIRST SCHEMA PROVISIONED to FLOWS for default companies.
Rem       mhichwa  04/05/2001 - Added not null constraints to flow_id foreign keys
Rem       mhichwa  04/09/2001 - Added wwv_flow_sw_archives
Rem       cbcho    04/10/2001 - Added parsed_schema column to wwv_flow_sw_sql_cmds
Rem       cbcho    04/10/2001 - Added wwv_flow_sw_archives
Rem       mhichwa  04/10/2001 - Added button c attributes column to flow step buttons
Rem       cbcho    04/10/2001 - Changed wwv_flow_sw_archives columns
Rem       sdillon  04/11/2001 - Added file_object_id to image repository table
Rem       cbcho    04/11/2001 - Added insert stmt to wwv_flow_sw_sqlplus_cmd table
Rem       mhichwa  04/11/2001 - Removed flow tree state table
Rem       cbcho    04/16/2001 - Added ctrl_file_id to wwv_flow_sw_parameters table
Rem       sdillon  04/17/2001 - Added function-based index to wwv flow image repository
Rem       sdillon  04/17/2001 - Added is_on_filesystem col to wwv flow image repository w/ index
Rem       mhichwa  04/17/2001 - Added ignore pagination column
Rem       mhichwa  04/17/2001 - Added text disabled and save to check constraint
Rem       sdillon  04/18/2001 - Removed function-based index due to rqmt to add init.ora params
Rem                             Added shadow column for upper(image_name) index w/ trigger
Rem       cbcho    04/18/2001 - Changed order of sw tables
Rem       mhichwa  04/18/2001 - changed pres to prefs for platform prefs
Rem       mhichwa  04/20/2001 - Added display flow_ID to tab.sql
Rem       mhichwa  04/23/2001 - Added rejoin existing session column to flows table
Rem       sdillon  05/04/2001 - Added image tag column to image repository table
Rem       cbcho    05/07/2001 - Added security_group_id to wwv_flow_sw_statistics table
Rem       cbcho    05/14/2001 - Changed username column lengths to varchar2(255) for all SQL Workshop tables
Rem       sdillon  05/15/2001 - Changed enduser column lengths to varchar2(255) for wwv_flow_job
Rem       sdillon  05/15/2001 - Added wwv_flow_css_repository table for cascading style sheet support
Rem       sdillon  05/24/2001 - Added wwv_flow_html_repository table for static html support
Rem       mhichwa  05/30/2001 - dropped index WWV_FLOWS_DISPLAY_ID_IDX due to dup row issues with translations
Rem       mhichwa  06/05/2001 - added check constraint to page plugs table for sort enabled column headings
Rem       mhichwa  06/07/2001 - added sgid to preferences
Rem       mhichwa  06/08/2001 - added vbs charting objects
Rem       mhichwa  06/17/2001 - added last updated by and on columns to a large number of tables.
Rem       mhichwa  06/18/2001 - Added flow step items
Rem       mhichwa  06/18/2001 - Added allow duplicate submissions table and page attribute
Rem       mhichwa  07/06/2001 - Added plug_query_num_rows_item and plug_query_num_rows_type
Rem       mhichwa  07/17/2001 - Added plug_query_row_count_max, changed meaning of plug_query_num_rows_type
Rem       mhichwa  07/18/2001 - Extended check constraint on region pagination type
Rem       mhichwa  07/18/2001 - Extended security scheme caching check constraint
Rem       mhichwa  07/20/2001 - Added flow_language_derived_from
Rem       tmuth    07/20/2001 - Fixed error in wwv_flow_security_schemes
Rem       mhichwa  07/20/2001 - Added sgid to platform prefs
Rem       mhichwa  07/22/2001 - Added 0 to flow_language_derived_from check constraint
Rem       mhichwa  07/23/2001 - Extended flow_language derived from check contraint with language codes
Rem       mhichwa  07/31/2001 - Added error_page_template
Rem       mhichwa  08/06/2001 - Extended row templates
Rem       mhichwa  08/08/2001 - Fixed bug in row templates create table statement
Rem       mhichwa  08/13/2001 - Added comments for wwv_flow_session_seq trigger
Rem       mhichwa  08/16/2001 - Added wwv flows reserved
Rem       mhichwa  05/09/2000 - apps_tab: Added Copyright
Rem       mhichwa  01/15/2001 - apps_tab: Added trigger computation of end date
Rem       mhichwa  01/15/2001 - apps_tab: Changed datatypes of created by and last updated by to varchars
Rem       mhichwa  01/15/2001 - apps_tab: Removed columns provided in fnd_user that do not make sense for web applications
Rem       mhichwa  01/15/2001 - apps_tab: Added security group ID, person id, and last and first name columns
Rem       mhichwa  02/23/2001 - apps_tab: Changed trigger on fnd user table
Rem       mhichwa  02/26/2001 - apps_tab: Changed trigger on fnd user table
Rem       mhichwa  02/26/2001 - apps_tab: Removed unused tables
Rem       mhichwa  02/26/2001 - apps_tab: Added index on fnd user table
Rem       sdillon  05/03/2001 - apps_tab: Changed ins/upd trigger to md5 hash web_password
Rem       sdillon  05/15/2001 - apps_tab: Changed md5 hash to "one_way_hash" to encapsulate db dependencies on MD5
Rem       mhichwa  05/17/2001 - apps_tab: Added fnd user groups table
Rem       mhichwa  05/21/2001 - apps_tab: Fixed wwv_flow_fnd_user trigger for updating web_password
Rem       mhichwa  06/28/2001 - apps_tab: Added two new user columns (def schema and allow access to schema)
Rem       mhichwa  07/05/2001 - apps_tab: Added 10 fnd user attributes for generic extensions for users
Rem       mhichwa  08/09/2001 - apps_tab: Added wwv_flow_fnd_user_pw_pref.web_password_format
Rem       mhichwa  08/21/2001 - apps_tab: Added on delete cascade references to group users intersection table
Rem       mhichwa  08/21/2001 - apps_tab: Added comments
Rem       tmuth    08/21/2001 - Added referential integrity constraints
Rem       tmuth    08/22/2001 - Commented referential integrity constraint out of wwv_flow_company_schemas, talk to Mike.
Rem       mhichwa  08/22/2001 - Removed tmuth commented out integrity constraint
Rem       mhichwa  08/22/2001 - Added global notification column to flows table
Rem       mhichwa  09/25/2001 - Extened check constraint for page validations to include func body returning boolean
Rem       mhichwa  09/28/2001 - Added message text translatable column, and report templates before and after rows
Rem       mhichwa  09/28/2001 - Removed message text translatable column
Rem       mhichwa  10/04/2001 - Added extra range of values for button positions
Rem       mhichwa  10/04/2001 - Added field templates table
Rem       mhichwa  10/04/2001 - Added field templates item_field_template number column to flow page items table
Rem       mhichwa  10/05/2001 - Added COPY button placement condition
Rem       mhichwa  10/05/2001 - Added field template page item column
Rem       tmuth    10/05/2001 - Removed wwv_flow_file_objects$ and moved to file "flows_files_new.sql"
Rem       mhichwa  10/09/2001 - Added collections tables
Rem       mhichwa  10/09/2001 - Extened constraint wwv_valid_flow_lang_from to include flow lang derived from item preference
Rem       mhichwa  10/09/2001 - Added create 2 button position (VALID_FSTEPB_POSITION)
Rem       mhichwa  10/15/2001 - Added never display condition type for wwv_plug_disp_when_ctype constraint
Rem       mhichwa  10/15/2001 - Added multi row update page processing type
Rem       mhichwa  10/16/2001 - Added updatable report attributes table
Rem       mhichwa  10/17/2001 - Changed index on upd rpt columns table
Rem       mhichwa  10/18/2001 - Added never condition types
Rem       mhichwa  10/24/2001 - Added alias column to flows table
Rem       mhichwa  10/24/2001 - Added alias column to flows page table (wwv flow steps)
Rem       mhichwa  10/24/2001 - Added process_when2 process_when_type2 to wwv flow step processing
Rem       tmuth    10/24/2001 - Added wwv_flow_templates$
Rem       tmuth    10/24/2001 - Added inserts for wwv_flow_templates$
Rem       tmuth    10/24/2001 - Added 3 columns to wwv_flow_templates$
Rem       mhichwa  10/25/2001 - Added additional validation types and validation 2 column
Rem       jstraub  10/29/2001 - Added tables, indexes and sequences for runtime distribution
Rem       tmuth    10/29/2001 - Added column to wwv_flow_templates$
Rem       jstraub  10/29/2001 - Added column download date to wwv_flow_rt_downloads$
Rem       mhichwa  10/30/2001 - Added when_button_pressed column to page validations table
Rem       tmuth    10/30/2001 - Added inserts for new default templates
Rem       mhichwa  10/30/2001 - Added display and save condition for updatable report types
Rem       jstraub  10/31/2001 - Added security group id to runtime distribution tables
Rem       tmuth    11/05/2001 - Removed inserts for default templates and moved to template_gallery.sql
Rem       tmuth    11/05/2001 - Added wwv_flow_template_themes$
Rem       mhichwa  11/12/2001 - Added html page header.
Rem       mhichwa  11/13/2001 - Added button comment.
Rem       mhichwa  11/13/2001 - Added BRANCH_TO_PAGE_IDENT_BY_ITEM, BRANCH_TO_URL_IDENT_BY_ITEM branch types
Rem       jstraub  11/15/2001 - Added wwv_flow_clickthru_log$
Rem       jstraub  11/16/2001 - Added list_countclicks_y_n and list_countclicks_cat to wwv_flow_lists
Rem       mhichwa  11/20/2001 - Added PLUG_QUERY_NO_DATA_FOUND per dbliss instruction.
Rem       mhichwa  11/20/2001 - Added proper spelling of branch conditions for sql and plsql expressions
Rem       tmuth    11/27/2001 - Added XML import/export tables
Rem       mhichwa  12/02/2001 - Added page_is_public_y_n
Rem       tmuth    12/07/2001 - Added 'flows_files.' for constraints that referernce wwv_flow_file_objects$ since a contraint
Rem                             can't reference a synonym.
Rem       mhichwa  12/11/2001 - Added security_scheme column to flow and page processing, validations, comp, and branching.
Rem       jstraub  12/13/2001 - Added wwv_flow_pages_reserved
Rem                           - Added index wwv_flows_reserved_idx, wwv_flow_pages_reserved_idx, wwv_flow_pages_reserved_idx2
Rem       mhichwa  12/14/2001 - Added flow_session column to wwv_flow_pages_reserved
Rem       mhichwa  12/17/2001 - Added charset column to wwv flows table
Rem       jkallman 01/16/2002 - Added views wwv_flow_hours_24, wwv_flow_hours_12, wwv_flow_minutes_5, wwv_flow_minutes
Rem       jkallman 01/17/2002 - Added PICK_DATE_DD_MON_YY_HH24_MI,PICK_DATE_DD_MON_YYYY_HH24_MI,PICK_DATE_DD_MM_YYYY_HH24_MI,
Rem                             PICK_DATE_MM_DD_YYYY_HH24_MI,PICK_DATE_DD_MON_YY_HH_MI,PICK_DATE_DD_MON_YYYY_HH_MI,PICK_DATE_DD_MM_YYYY_HH_MI
Rem                             PICK_DATE_MM_DD_YYYY_HH_MI to constraint of wwv_flow_step_items.display_as
Rem       mhichwa  01/21/2002 - Added reference_id to template tables
Rem       mhichwa  01/24/2002 - Added reference_id to security schemes
Rem       mhichwa  02/03/2002 - Added new process conditions
Rem       cbcho    02/05/2002 - Removed process_sql column from wwv_flow_processing and wwv_flow_step_processing
Rem       jkallman 02/06/2002 - Add 20 additional attributes to wwv_flow_collection_members$, collection_changed column to wwv_flow_collections$
Rem       mhichwa  02/11/2002 - Removed processing conditions added on 2-03
Rem       mhichwa  02/12/2002 - Added session state status to wwv flow data table
Rem       mhichwa  02/12/2002 - Added process condition types for page processes
Rem       mhichwa  02/13/2002 - Added reset session state to page process types
Rem       mhichwa  02/13/2002 - Added columns to many tables to support inline validation display
Rem       mhichwa  02/19/2002 - Added check constrants to valid_fproc_whentype
Rem       mhichwa  02/19/2002 - Added second process condition to flow processing
Rem       mhichwa  02/19/2002 - Added post_element_text column
Rem       cbcho    02/25/2002 - Added 'RESET_USER_PREFERENCES' type for wwv_valid_fsproc_type constraint on wwv_flow_step_processing table
Rem       jkallman 02/28/2002 - Added RADIOGROUP_WITH_SUBMIT to constraint WWV_VALID_FSITEM_DISPLAYAS
Rem       cbcho    03/01/2002 - Added reference_id to wwv_flow_shortcuts table
Rem       mhichwa  03/05/2002 - Added branch to function returning url to valid_fsbranch_branchtype
Rem       mhichwa  03/07/2002 - Added id2 column to wwv_flow_steps to make a single column primary key to facilitate xauth
Rem       msewtz   03/14/2002 - Added stage_table column to wwv_flow_xml_structure
Rem       msewtz   03/14/2002 - Added wwv_flow_xml_upload table for XML import
Rem       mhichwa  03/18/2002 - Added WHEN_THIS_PAGE_SUBMITTED region condition type
Rem       mhichwa  03/19/2002 - Added INITIALIZE_ALL_PAGE_ITEMS check constraint
Rem       cbcho    03/19/2002 - Added process_type column to wwv_flow_processing table
Rem       mhichwa  03/20/2002 - Added on_demand flow process condition type
Rem       mhichwa  03/21/2002 - Added on demand flow page processing to wwv_valid_fsproc_type
Rem       mhichwa  03/22/2002 - Removed stage_table
Rem       tmuth    03/26/2002 - Removed wwv_flow_company_u_schema constraint from wwv_flow_company_schemas so more than one company can use a schema.
Rem       mhichwa  04/01/2002 - removed unique index (changed to non unique index) on company schemas table.
Rem       cbcho    04/04/2002 - Added reference_id to wwv_flow_icon_bar table
Rem       cbcho    04/08/2002 - Added WHEN_THIS_PAGE_NOT_SUBMITTED display condition check constraint type to wwv_flow_page_plugs
Rem       cbcho    04/10/2002 - Added reference_id to WWV_FLOW_LISTS_OF_VALUES$ table
Rem       mhichwa  04/16/2002 - Made wwv_flow_company_schemas_idx index unique
Rem       jkallman 04/22/2002 - Rewrote view wwv_flow_years to accomodate 150 year range
Rem       jkallman 04/29/2002 - Added flow_id component to wwv_flow_collections (so collections are unique across flows)
Rem       mhichwa  04/29/2002 - Added flow table to hold popup lov template
Rem       mhichwa  04/30/2002 - Added sql_expression constraint domains
Rem       mhichwa  04/30/2002 - Added 3 menu tables
Rem       mhichwa  04/30/2002 - Added menu menu_template_id column
Rem       mhichwa  05/01/2002 - Added reference_id to 2 new template tables
Rem       mhichwa  05/02/2002 - Added before and after result set.
Rem       mhichwa  05/02/2002 - Added unique index for menu options table.
Rem       mhichwa  05/07/2002 - Removed condition type check constraints in preperation to moving toward standard condition types
Rem       cbcho    05/08/2002 - Modified icon_bar_disp_cond_type column length to be varchar2(255)

Rem       mhichwa  05/08/2002 - Added wwv_flow_lov_groups table
Rem       mhichwa  05/08/2002 - Added plug_display_when_cond2 column
Rem       mhichwa  05/08/2002 - Added button display condition 2
Rem       mhichwa  05/09/2002 - Added display_condition2 to toplevel tabs (parent tabs)
Rem       mhichwa  05/09/2002 - Added lov_disp_cond2
Rem       mhichwa  05/09/2002 - Added validation_condition2
Rem       mhichwa  05/09/2002 - Added display condition 2 to page items
Rem       mhichwa  05/10/2002 - Fixed on delete cascade on wwv_flow_fk_poplov_temp table
Rem       mhichwa  05/21/2002 - Added POPUP_FILTER to check constraint
Rem       mhichwa  05/29/2002 - Added before first and after last
Rem       jstraub  07/08/2002 - Added wwv_flow_version$ ddl from flows_version_tab.sql
Rem       sspadafo 07/09/2002 - Changed inserts into wwv_flow_companies to use '^FLOW_OWNER' parameter for column value
Rem       cbcho    07/12/2002 - Added timestamp column in wwv_flow_mail_queue table
Rem       cbcho    07/12/2002 - Added 'PLSQL_ANONYMOUS_BLOCK' as item source type
Rem       mhichwa  07/17/2002 - Added wwv_flow_button_templates table
Rem       tmuth    07/19/2002 - Changed check constraint on wwv_flow_templates$
Rem       mhichwa  07/19/2002 - Added PICK_DATE_DD_MON_RR and two others
Rem       mhichwa  07/31/2002 - Changed wwv_flows_alias_idx from a unique index on alias to alias and security_group_id
Rem       mhichwa  07/31/2002 - Ensure wwv_flow alias column is not null, added not null constraint
Rem       mhichwa  08/04/2002 - Added web services to wwv_valid_fsproc_type page processing check constraint
Rem       mhichwa  08/09/2002 - Added plug_query_more_data
Rem       mhichwa  08/10/2002 - Added COMPUTED_BUT_NOT_DISPLAYED
Rem       mhichwa  08/11/2002 - Added exact_substitutions_only
Rem       mhichwa  08/14/2002 - Added ROW_RANGES_WITH_LINKS_RIGHT
Rem       mhichwa  08/15/2002 - Added when_no_data_found_message before_first_fetch_message minimum_characters_required
Rem       mhichwa  05/15/2002 - Added default_on_export attribute1 attribute2 attribute3 attribute4
Rem       mhichwa  05/15/2002 - Removed not null constraints on wwv_flow_field_templates body1 and body2 columns
Rem       mhichwa  08/15/2002 - Added field types POPUP3, POPUP4, POPUP5, POPUP6
Rem       mhichwa  08/16/2002 - Added DISPLAY_ONLY_PLSQL item type
Rem       mhichwa  08/29/2002 - Removed not null from template2 and template3 columns in page region template table
Rem       mhichwa  09/13/2002 - Added TEXTAREA_CHAR_COUNT and TEXTAREA_CHAR_COUNT_SPELL to check constraint list
Rem       mhichwa  09/19/2002 - Added default_label_template default_report_template default_list_template default_menu_template
Rem       mhichwa  09/19/2002 - Added html_page_onload
Rem       mhichwa  09/21/2002 - Added more check constraints for region positions and new dynamic region positions
Rem       mhichwa  09/24/2002 - Added customized column page plugs, removed
Rem       sspadafo 09/24/2002 - Added custom_auth_setups table
Rem       mhichwa  09/25/2002 - Added plug_override_reg_pos
Rem       mhichwa  09/25/2002 - Added cattributes_element and extended cattributes to 4000 in wwv_flow_step_items
Rem       mhichwa  09/26/2002 - Added page_is_protected_y_n, prevents url tampering thus session state alt via a url
Rem       mhichwa  09/26/2002 - Added pagination template attributes
Rem       mhichwa  09/26/2002 - Altered wwv_plug_head_type_check
Rem       sspadafo 09/27/2002 - Added wwv_flow_entry_points, wwv_flow_entry_point_args, wwv_flow_step_branch_args
Rem       mhichwa  09/27/2002 - Added pagination_display_position
Rem       mhichwa  10/09/2002 - Added break column attributes
Rem       mhichwa  10/10/2002 - Added region customize attribute
Rem       mhichwa  10/10/2002 - Added wwv_flow_group_users view
Rem       mhichwa  10/11/2002 - Added wwv_flow_page_generic_attr table
Rem       mhichwa  10/20/2002 - Added item_name, name_length to wwv_flow_data
Rem       mhichwa  10/20/2002 - Added second index to wwv_flow_data
Rem       mhichwa  10/21/2002 - Added sgid to  wwv_flow_page_generic_attr
Rem       tmuth    10/24/2002 - Added cattributes_element to wwv_flow_step_items
Rem       mhichwa  10/25/2002 - Added 3 read only attributes to items table
Rem       mhichwa  10/25/2002 - Commented application tab attributes as obsolete
Rem       mhichwa  10/30/2002 - Added page_component_map
Rem       mhichwa  10/31/2002 - Added ON_SUBMIT_BEFORE_COMPUTATION process to check constraint
Rem       tmuth    11/01/2002 - Removed reference to ^FLOW_OWNER, now using select user... technique
Rem       mhichwa  11/04/2002 - Added SHOW_AS_SL_WITH_POPUP
Rem       mhichwa  11/07/2002 - Added index wwv_flow_session_idx1
Rem       tmuth    12/02/2002 - Moved wwv_flow_users and wwv_flow_group_users to view.sql
Rem       msewtz   12/04/2002 - Added NO_HEADINGS to constraint wwv_plug_head_type_check
Rem       cbcho    12/06/2002 - Changed unique index wwv_flow_developers_id to normal index. To allow saving more than 1 developer roles per user.
Rem       mhichwa  12/18/2002 - Added company_schema_comments column on wwv_flow_company_schemas to get around db bug
Rem       mhichwa  12/22/2002 - Added BRANCH_TO_PAGE_ACCEPT
Rem       mhichwa  01/02/2003 - bug 2733051, added branch type check constraint
Rem       mhichwa  01/02/2003 - bug 2733061, removed table and column comments
Rem       jkallman 01/16/2003 - bug 2753723, added view wwv_flow_user_activity_log
Rem       mhichwa  01/17/2003 - bug 2756289, adjust column create orders
Rem       mhichwa  01/26/2003 - bug 2769756, add additional process types and new process column
Rem       mhichwa  01/26/2003 - bug 2769756, added after submit before validation process point
Rem       mhichwa  01/27/2003 - bug 2769756, additional process types
Rem       mhichwa  01/27/2003 - bug 2770759, add capability to initialize session
Rem       mhichwa  01/27/2003 - bug 2770772, added capability to reset pagination from a process
Rem       tmuth    02/03/2003 - bug 2776149, added wwv_flow_tabset_view2 to union in parent tabs with no std tabs
Rem       mhichwa  02/04/2003 - bug 2785527, extend length of plug_query_number_formats column from 255 to 4000
Rem       mhichwa  02/19/2003 - bug 2811199, changed /i/ references to use image prefix
Rem       mhichwa  02/20/2003 - bug 2811609, added simple pagination lov item
Rem       sspadafo 02/23/2003 - Changes for template column name changes from varchar2 to number (Bug 2748399)
Rem       mhichwa  02/24/2003 - bug 2819037, added BRANCH_TO_FUNCTION_RETURNING_PAGE
Rem       jstraub  02/26/2003 - bug 2823889, removed insert of company 20 into wwv_flow_companies
Rem       msewtz   03/06/2003 - bug 2492409, added sequence column to wwv_flow_xml_structure
Rem       sspadafo 03/06/2003 - Add session_id hashed to wwv_flow_sessions$, with indexes (Bug 2837566)
Rem       msewtz   03/07/2003 - Added security_group_id to wwv_flow_xml_upload
Rem       jkallman 03/07/2003 - Bug 2748410, add wwv_flow_field_templates, other reporting attributes to wwv_flow_translatable_cols$,
Rem                             added index wwv_flow_translatable_key2
Rem       jstraub  03/10/2003 - Replaced select user with select sys_context( 'userenv', 'current_schema') for FLOW_OWNER
Rem       jstraub  03/11/2003 - Added nls_language, nls_territory and lang_id_upper to wwv_flow_languages
Rem       jstraub  03/12/2003 - Addded 'AVAILABLE_W_INLINE_EDIT' to wwv_flow_valid_status check (Bug 2845535)
Rem       jstraub  03/13/2003 - added translate_this_template to all template tables with Y,N check constraint
Rem       jstraub  03/14/2003 - added composite index on wwv_flow_languages
Rem       tmuth    03/17/2003 - Added to new types to wwv_valid_fsitem_displayas check constraint, TEXT_WITH_ENTER_SUBMIT & PASSWORD_WITH_ENTER_SUBMIT
Rem       jstraub  03/17/2003 - Added trans_flow_lang_code_root varchar2(30) to wwv_flow_language_map
Rem       jstraub  03/18/2003 - Changed where clause in wwv_flow_user_activity_log from wwv_flow.get_sgid to selecting it from dual per tkyte
Rem       mhichwa  03/19/2003 - Added plug_query_hit_highlighting bug (2860378)
Rem       jstraub  03/25/2003 - Added tree and web service ddl
Rem       jstraub  03/25/2003 - Removed the first wwv_flow_years view statement
Rem       jstraub  03/25/2003 - Removed obsolete table wwv_flow_dynamic_pages
Rem       mhichwa  03/30/2003 - Added to page process type check constraint domain (bug 2878963)
Rem       sspadafo 03/30/2003 - Added to CLEAR_CACHE_FOR_FLOWS page process type check constraint domain (bug 2878963)
Rem       sspadafo 04/01/2003 - Remove check constraints on condition column in shortcuts table (Bug 2860487)
Rem       sspadafo 04/02/2003 - Add wwv_flow_compound_conditions table (Bug 2860487)
Rem       sspadafo 04/02/2003 - Add new computation type 'ITEM_VALUE' (Bug 2885807)
Rem       sspadafo 04/03/2003 - Remove not null constraint from shortcuts consideration_seq column (Bug 2887077)
Rem       jkallman 04/04/2003 - Corrected view wwv_flow_years to include year 2020 (bug 2888902)
Rem       tmuth    04/07/2003 - Added Sharon's new tables (wwv_flow_upg_tab_obsolete,wwv_flow_upg_col_obsolete,wwv_flow_upg_tab_name_changes,wwv_flow_upg_col_name_changes)
Rem       jstraub  04/08/2003 - Added REGULAR_EXPRESSION to check constraint wwv_valid_fsval_valtype
Rem       jstraub  04/09/2003 - Added missing indexes on flow_id where defined as foreign key
Rem       jstraub  04/10/2003 - Added column template_translatable to wwv_flow_tranlsatable_cols$ and wwv_flow_translatable_text$
Rem       jstraub  04/10/2003 - Altered inserts into wwv_flow_translatable_cols$ to inlcude new template_translatable column
Rem       jstraub  04/10/2003 - Added inserts into wwv_flow_translatable_cols$, id's 52 - 77
Rem       cbcho    04/14/2003 - Added Sharon's hint tables (wwv_flow_hnt_table_info, wwv_flow_hnt_column_info)
Rem       cbcho    04/15/2003 - Added wwv_flow_region_chart_ser_attr DDL (bug 2722911)
Rem       cbcho    04/15/2003 - Added Sharon's wwv_flow_hnt_column_info DDL change
Rem       jstraub  04/16/2003 - Fixed insert into wwv_flow_translatable_cols$
Rem       msewtz   04/18/2003 - Added asc and desc image info columns to wwv_flow_page_plugs
Rem       jkallman 04/23/2003 - Add support for flow attributes, shortcuts, post_element_text in translatable columns
Rem       jkallman 04/24/2003 - Added column flow_id to wwv_flow_menu_options
Rem       jkallman 04/24/2003 - Add support for wwv_flow_menu_options in translatable columns
Rem       sspadafo 04/26/2003 - Added display type POPUP_KEY_LOV_NOFETCH to wwv_valid_fsitem_displayas
Rem       msewtz   04/28/2003 - Added wwv_flow_region_report_filter
Rem       msewtz   04/28/2003 - Added wwv_flow_region_report_column
Rem       msewtz   04/28/2003 - Added wwv_flow_query_condition
Rem       msewtz   04/28/2003 - Added wwv_flow_query_column
Rem       msewtz   04/28/2003 - Added wwv_flow_query_object
Rem       msewtz   04/28/2003 - Added wwv_flow_query_definition
Rem       cbcho    04/29/2003 - Added Sharon's PK of WWV_FLOW_HNT_COLUMN_INFO for fix an error
Rem       cbcho    04/29/2003 - Added Sharon's wwv_flow_hnt_procedure_info and wwv_flow_hnt_argument_info DDL
Rem       jkallman 05/01/2003 - Reorder indexed columns in index wwv_flow_messages_idx1, added wwv_flow_messages_idx2
Rem       jstraub  05/02/2003 - Added cond_column to wwv_flow_query_condition, and made condition nullable
Rem       jkallman 05/02/2003 - Removed extra blank line in definition of wwv_flow_page_plugs (would not compile)
Rem       jstraub  05/02/2003 - Added 'JOIN' to valid_compound_operator check condition on wwv_flow_query_condition
Rem       jkallman 05/02/2003 - Convert datatypes in wwv_flow_translatable_text$ to NCLOB and NVARCHAR2
Rem       cbcho    05/02/2003 - Added reference_id in wwv_flow_step_item_help
Rem       msewtz   05/05/2003 - Added indexes to wwv_flow_region_report_column, ...region_report_filter, .query_definition, ...query_object, ...query_condition and .query_column tables
Rem       msewtz   05/06/2003 - Added query_column_id to wwv_flow_report_column
Rem       jstraub  05/07/2003 - Added 'NONE' to valid_compound_operator check condition on wwv_flow_query_condition, made operator col not null
Rem       jstraub  05/07/2003 - Added cond_root to wwv_flow_query_condition
Rem       jstraub  05/07/2003 - Added 'NJOIN' to valid_compound_operator
Rem       jkallman 05/08/2003 - Added WWV_FLOW_PAGE_PLUGS.PLUG_QUERY_MORE_DATA to translatable columns
Rem       jkallman 05/08/2003 - Added flow_id to wwv_flow_list_of_values_data, add same table to translatable columns
Rem       jkallman 05/09/2003 - Add auth_setups columns to translatable columns, added wwv_flow_lov_data_idx2, wwv_flow_menu_opt_idx1
Rem       jkallman 05/09/2003 - Add wwv_flow_step_items.lov_null_text to translatable columns
Rem       jkallman 05/09/2003 - Remove 2 columns from auth_setups in translatable columns
Rem       cbcho    05/12/2003 - Removed DDL for WWV_FLOW_VBSCHART_SEQ and wwv_flow_vbschart_sql since Excel chart deprecated.
Rem       mhichwa  05/12/2003 - Added columns to region report columns to support upd reports, bug 2861658
Rem       mhichwa  05/12/2003 - Made column heading nullable, bug 2861658
Rem       jstraub  05/13/2003 - Removed query_name from wwv_flow_query_definition and added region_id
Rem       jkallman 05/13/2003 - Added 4 columns from table WWV_FLOW_REGION_REPORT_COLUMN to translatable columns
Rem       jstraub  05/14/2003 - Added index on region_id for wwv_flow_query_definition
Rem       jstraub  05/14/2003 - Removed query_source from wwv_flow_query_definition
Rem       msewtz   05/14/2003 - Added form_element_id to wwv_flow_region_report_column
Rem       mhichwa  05/16/2003 - Added two new columns to page plugs for dml returning feature, bug 2965281
Rem       cbcho    05/20/2003 - Added insert statement to add 'WHENEVER' as value of WWV_FLOW_SW_SQLPLUS_CMD table
Rem       mhichwa  05/22/2003 - moved RETURN_KEY_INTO_ITEM1 and 2 from page plugs to step processing, bug 2965281
Rem       jstraub  05/29/2003 - Removed wwv_flow_xml_mapping, wwv_flow_xml_structure and wwv_flow_xml_upload bug 2972214
Rem       mhichwa  05/29/2003 - added format mask to step items, bug 2983469
Rem       sbkenned 06/02/2003 - wwv_flow_hnt_column_info: Renamed mask to mask_report, added mask_form
Rem       jkallman 06/02/2003 - Rewrite view wwv_flow_collections to use dual for optimzation
Rem       msewtz   06/25/2003 - Changed column_alias to varchar(4000) in create_region_report_column
Rem       klrice   07/02/2003 - added wwv_flow_activity_log_mv for log reporting. and changed wwv_flow_user_activity_log to use the mat view
Rem       sspadafo 07/02/2003 - removed activity log mv ddl, added indexes to log tables, added initrans/maxtrans
Rem       sspadafo 07/02/2003 - made time_stamp col in activity log tables not null, created index on that col
Rem       msewtz   07/22/2003 - added POPUP_QUERY to WWV_REGREPCOL_DISPLAY_AS constraint
Rem       jkallman 07/22/2003 - Add additional columns to index wwv_flow_translatable_from_id (Bug 3048414)
Rem       jkallman 07/23/2003 - Added plug_customized_name to translatable columns
Rem       mhichwa  07/23/2003 - Removed bug tables, feature obsolete, bug 3037774
Rem       jkallman 08/04/2003 - Add nls_sort values to wwv_flow_languages (Bug 3032142)
Rem       jkallman 08/04/2003 - Added wwv_flow_charsets (Bug 3033761)
Rem       msewtz   08/05/2003 - Added text_from_lov to wwv_regrepcol_display_as
Rem       jkallman 08/05/2003 - Added wwv_flow_step_item_help to translatable columns (Bug 3086786)
Rem       sspadafo 08/18/2003 - Remove unique index wwv_flow_page_alias_idx, replace with unique constraint (Bug 3039513)
Rem       jkallman 08/19/2003 - Set template_translatable to 'N' for certain Popup LOV template attributes (Bug 3104790)
Rem       sspadafo 08/19/2003 - Add non_unique index on wwv_flow_steps (flow_id,alias), remove unique constraint (Bug 3039513)
Rem       mhichwa  08/25/2003 - Added PICK_DATE_USING_APP_FORMAT_MASK (bug 3113258)
Rem       jstraub  09/02/2003 - Added file_charset to wwv_flow_files
Rem       jkallman 09/05/2003 - Use FLOW_ITEM_ID as table pk in translatable columns for WWV_FLOW_STEP_ITEM_HELP
Rem       jkallman 09/16/2003 - Remove wwv_flow_page_plugs.plug_query_headings from translatable columns
Rem       msewtz   09/18/2003 - Added constraint wwv_flow_urc_to_plug_fk to wwv_flow_region_upd_rpt_cols (bug 3147935)
Rem       jkallman 09/23/2003 - Modified entries in wwv_flow_charsets, added Chinese EUC (per SGT)
Rem       jkallman 09/23/2003 - Updated IANA name for Korean EUC
Rem       sspadafo 11/02/2003 - new indexes for wwv_flow_language_map (Bug 3231672)
Rem       sspadafo 11/19/2003 - Expanded audit columns in wwv_flow_hnt* tables (Bug 3243851)
Rem       jkallman 12/16/2003 - Added view wwv_flow_format_masks (Bug 3246079)
Rem       jkallman 04/01/2004 - Added clob001 to wwv_flow_collection_members$ and to wwv_flow_collections
Rem       cbcho    04/07/2004 - Added GET_NEXT_OR_PREV_PK type to wwv_flow_step_processing
Rem       jkallman 04/16/2004 - Modified constraint wwv_flow_valid_shortcut_type to include MESSAGE, MESSAGE_ESCAPE_JS, and TEXT_ESCAPE_JS
Rem       mhichwa  04/22/2004 - Add lov_template column bug 3588925
Rem       mhichwa  04/29/2004 - Add kris.rice calendar tables bug 360246
Rem       mhichwa  04/29/2004 - Added reference_id to calendar template table bug 360246
Rem       jstraub  05/03/2004 - Added tables for improved web services feature
Rem       msewtz   05/03/2004 - modified WWV_REGREPCOL_DISPLAY_AS check constraint for support of date popups in tabular forms
Rem       jkallman 05/04/2004 - Corrected wwv_Flow_Cals, wwv_flow_cal_templates
Rem       jstraub  05/13/2004 - Added output_message_style to wwv_flow_ws_operations
Rem       jstraub  05/13/2004 - Added on delete cascade to parameter_id on wwv_flow_ws_process_parms_map
Rem       jstraub  05/14/2004 - Removed parent_type, array_name from wwv_flow_ws_parameters and added parent_id
Rem       jstraub  05/17/2004 - Add input_message_style column to wwv_flow_ws_opertaions
Rem       mhichwa  05/17/2004 - Add columns to wwv_flows to support default region templates by component type (bug 3633463)
Rem       mhichwa  05/17/2004 - Add default menu region template to wwv_flows (bug 3633463)
Rem       jkallman 05/18/2004 - Corrected spelling of last_updated_by in wwv_flow_cal_templates, moved calendar creation after wwv_flow_page_plugs (Bug 3622018)
Rem       msewtz   05/18/2004 - added form_region_title and report_region_title to wwv_flow_hnt_table_info table, removed comments
Rem       msewtz   05/18/2004 - updated wwv_flow_hnt_column_info table, removed comments
Rem       msewtz   05/18/2004 - added wwv_flow_hnt_lov_data
Rem       msewtz   05/18/2004 - added pk_col_source_type, pk_col_source, derived_column, ref_schema, ref_table_name, ref_column_name to wwv_flow_region_report_column table
Rem       msewtz   05/18/2004 - added CHECKBOX, RADIOGROUP to wwv_regrepcol_display_as constraint
Rem       msewtz   05/18/2004 - added 'MULTI_ROW_DELETE','ADD_ROWS_TO_TABULAR_FORM','RESET_PAGINATION_FOR_REGION','RESET_SORTING_FOR_REGION' to wwv_valid_fsproc_type
Rem       msewtz   05/18/2004 - added row_style_mouse_over, row_style_mouse_out, row_style_checked, row_style_unchecked columns to wwv_flow_row_template table
Rem       mhichwa  05/19/2004 - Added item_link and day_link to wwv_flow_cals table to support required calendar feature function
Rem       mhichwa  05/19/2004 - Added breadcrumb_def_reg_pos and sidebar_def_reg_pos to wwv_flow_templates
Rem       klrice   05/21/2004 - removed not null from wwv_flow_Cals
Rem       mhichwa  05/24/2004 - Added default_listr_template column to wwv_flows table
Rem       mhichwa  05/24/2004 - Added wwv_flow_lock_page and wwv_flow_lock_page_log tables
Rem       mhichwa  05/26/2004 - Added navbar_entry template to wwv_flow_templates to facilitate improved navbar HTML coding
Rem       jkallman 05/27/2004 - Remove references to ^FLOW_OWNER
Rem       jkallman 06/01/2004 - Added ITEM_IS_DATE to constraint on wwv_flow_step_validations.validation_type
Rem       mhichwa  06/01/2004 - Added theme_id and theme_class_id columns to template tables
Rem       mhichwa  06/01/2004 - Added theme_id to wwv_flows table to identify the theme used for a specific application
Rem       mhichwa  06/01/2004 - Added default_calendar_template to wwv_flows
Rem       jstraub  06/02/2004 - Added header_message_name and header_message_style to wwv_flow_ws_operations, and 'H' in chk for parm_type
Rem       klrice   06/03/2004 - Renamed and ez_ to easy_
Rem       klrice   06/04/2004 - Add display_type to wwv_flow_Cals
Rem       sspadafo 06/06/2004 - Add tables wwv_flow_roles, wwv_flow_local_users, wwv_flow_user_roles
Rem       sspadafo 06/06/2004 - Add column to wwv_flow_step_processing for dml_fetch_mode option
Rem       sspadafo 06/07/2004 - Remove column from wwv_flow_step_processing for dml_fetch_mode option
Rem       sspadafo 06/07/2004 - Revise tables wwv_flow_roles, wwv_flow_local_users, wwv_flow_user_roles
Rem       sspadafo 06/07/2004 - Remove tables wwv_flow_roles, wwv_flow_local_users, wwv_flow_user_roles
Rem       jkallman 06/08/2004 - Rename columns in wwv_flow_mail_queue, add new columns to wwv_flow_mail_log
Rem       jkallman 06/08/2004 - Added views wwv_flow_user_mail_queue and wwv_flow_user_mail_log
Rem       cbcho    06/09/2004 - Added aggregate_by to wwv_flow_hnt_column_info
Rem       jkallman 06/10/2004 - Add wwv_flow_shortcuts.error_text to translatable_columns
Rem       jkallman 06/10/2004 - Renamed index wwv_flow_step_item_help to wwv_flow_step_item_help_idx (Bug 3256811)
Rem       mhichwa  06/10/2004 - Added theme_id and theme_class_id columns to popup lov template table
Rem       mhichwa  06/10/2004 - Added wwv_flow_themes table and index
Rem       sspadafo 06/11/2004 - Add table wwv_flow_customized_tasks
Rem       jkallman 06/11/2004 - Modify values of check constraint for displayed in wwv_flow_customized_tasks, name check constraints
Rem       mhichwa  06/11/2004 - Refined datatypes in wwv_flow_themes table
Rem       msewtz   06/11/2004 - added new report attributes to wwv_flow_page_plugs and wwv_flow_region_report_column
Rem       skutz    06/11/2004 - added wwv_flow_templates_all and wwv_flow_templates_used views
Rem       skutz    06/11/2004 - modified view wwv_flow_templates_used views and corrected case issues
Rem       skutz    06/14/2004 - added or corrected unique indexes on tempalte tables to include theme_id
Rem       skutz    06/14/2004 - added theme_id to unique index on wwv_flow_popup_lov_template
Rem       sspadafo 06/18/2004 - Add database_action to wwv_flow_step_buttons
Rem       sspadafo 06/18/2004 - Add web_password_raw to wwv_flow_fnd_user
Rem       klrice   06/21/2004 - added start_of_week and print_url
Rem       klrice   06/22/2004 - changed display_as to varchar2(100) and removed contraint
Rem       klrice   06/24/2004 - added display_item to wwv_flow_cals
Rem       msewtz   06/25/2004 - added 'T' as type code to wwv_flow_regrepcol_src_type
Rem       mhichwa  07/08/2004 - Added wwv_flow_page_groups
Rem       mhichwa  07/08/2004 - Added group_id column to wwv_flow_page_steps
Rem       mhichwa  07/09/2004 - Enlarge TAB_ALSO_CURRENT_FOR_PAGES column from 255 to 4000
Rem       mhichwa  07/09/2004 - Added column_link_attr to report columns table
Rem       jkallman 07/12/2004 - Added missing comma to column_link_attr
Rem       jkallman 07/14/2004 - Add wwv_flow_online_help and wwv_flow_online_help_ja
Rem       mhichwa  07/15/2004 - Add template_comments column to wwv_flow_cal_templates table
Rem       jkallman 07/16/2004 - Add plaintext columns to wwv_flow_online_help and wwv_flow_online_help_ja
Rem       sbkenned 07/27/2004 - Added TEXT_FROM_LOV as a valid value for wwv_flow_hnt_column_info.display_as_tab_form and display_as_report
Rem       sspadafo 07/29/2004 - Add wwv_flow_restrict_admin (Bug 3781714)
Rem       mhichwa  08/02/2004 - Added list template id column to page plugs table
Rem       mhichwa  08/02/2004 - Added 2 column to wwv_flows table (logo_image and logo_image_attributes)
Rem       jstraub  08/09/2004 - Changed WWV_DICTIONARY$ to WWV_FLOW_DICTIONARY$
Rem       jkallman 08/13/2004 - Add cset column to wwv_flow_online_help_ja
Rem       skutz    08/30/2004 - Modified wwv_flow_tempaltes_used to support new list template defaults at page level (bug 3857356)
Rem       sbkenned 09/09/2004 - Modified check constraints on wwv_flow_hnt_column_info for display_as form, tab_form & report to include PICK_DATE_YYYY_MM_DD & PICK_DATE_RR_MON_DD
Rem       jkallman 09/22/2004 - Added one additional format mask to view wwv_flow_format_masks
Rem       jstraub  10/27/2004 - Added indexes on foreign keys for wwv_flow_hnt_lov_data and wwv_flow_page_groups
Rem       sspadafo 12/13/2004 - Changed last_updated_by/created_by to vc2(255) in couple of wwv_flow_hnt_* tables (Bug 4064128)
Rem       msewtz   01/07/2004 - Added columns parent_list_item_id, sub_item_count to table wwv_flow_list_items
Rem       msewtz   01/07/2004 - Added columns between_items, before_sub_list, after_sub_list, between_sub_list_items, sub_list_item_current, sub_list_item_noncurrent to table wwv_flow_list_templates
Rem       msewtz   01/07/2004 - Added index parent_list_item_id_idx
Rem       msewtz   01/07/2004 - Added columns item_template_curr_w_child, item_template_noncurr_w_child clob, sub_template_curr_w_child, sub_template_noncurr_w_child to wwv_flow_list_templates
Rem       sspadafo 01/14/2005 - Added wwv_flow_qb_saved_query
Rem       sspadafo 01/17/2005 - Added translatable columns dml for sub list columns in wwv_flow_list_templates
Rem       sspadafo 01/17/2005 - Remove unused column list_item_parent_id from wwv_flow_list_items
Rem       sspadafo 01/17/2005 - Adjusted column sizes, constraints, renamed owner column name for wwv_flow_qb_saved_query
Rem       cbcho    01/27/2005 - Removed tables wwv_flow_sw_ctrl_files,wwv_flow_sw_parameters,wwv_flow_sw_ctrlfile_stats,wwv_flow_sw_statistics,wwv_flow_sw_detail_statistics,wwv_flow_sw_valid_file,wwv_flow_sw_ctrl_file_details,wwv_flow_sw_archives
Rem       cbcho    01/27/2005 - Removed insert to wwv_flow_sw_valid_file
Rem       cbcho    01/27/2005 - Removed insert of '@' to wwv_flow_sw_sqlplus_cmd
Rem       cbcho    01/27/2005 - Added tables wwv_flow_sw_binds,wwv_flow_sw_results,wwv_flow_sw_detail_results
Rem       msewtz   01/27/2005 - Added parent_list_item_fk constraint to wwv_flow_list_items
Rem       sspadafo 01/28/2005 - Added wwv_flow_qb_saved_cond, wwv_flow_qb_saved_join, wwv_flow_qb_saved_tabs
Rem       cbcho    01/31/2005 - Changed DDL for wwv_flow_sw_results,wwv_flow_sw_detail_results
Rem       cbcho    02/01/2005 - Removed extra ',' in parent_list_item_fk constraint for msewtz
Rem       cbcho    02/01/2005 - Removed qb_js column from wwv_flow_qb_saved_query for sspadafo
Rem       msewtz   02/03/2005 - Added print_url_label to wwv_flow_page_plugs
Rem       cbcho    02/04/2005 - Removed retain_result, kill_job, run_complete from wwv_flow_sw_results, and added status column
Rem       sspadafo 02/06/2005 - Added escape_on_http_input and protection level columns to wwv_flow_step_items, protection_level to wwv_flow_items
Rem       sspadafo 02/06/2005 - Added protection level column to wwv_flow_steps, checksum_salt, checksum_salt_last_reset to wwv_flows
Rem       sspadafo 02/06/2005 - Removed page_is_protected_y_n from wwv_flow_steps
Rem       sspadafo 02/06/2005 - Added translate_title to wwv_flow_page_plugs
Rem       sspadafo 02/06/2005 - Added wwv_flow_computations.computation_error_message,wwv_flow_step_computations.computation_error_message to translatable cols
Rem       sspadafo 02/08/2005 - Added wwv_flow.page_protection_enabled_y_n for URL tampering feature
Rem       sspadafo 02/08/2005 - Added check constraint on wwv_flow.page_protection_enabled_y_n
Rem       cbcho    02/11/2005 - Added start_time, end_time to wwv_flow_sw_results
Rem       cbcho    02/11/2005 - Added start_time, end_time, seq_id, file_id to wwv_flow_sw_detail_results
Rem       jkallman 02/14/2005 - Add additional PICK_DATE values to constraint wwv_valid_fsitem_displayas on wwv_flow_step_items
Rem       jkallman 02/16/2005 - Add additional PICK_DATE values to constraints on  wwv_flow_hnt_column_info
Rem       jkallman 02/17/2005 - Correct typo in check constraint for DD_MM_YYYY_HH24_MI_DASH
Rem       cbcho    02/18/2005 - Removed DDL for wwv_flow_sw_statements table (by sspadafo)
Rem       sspadafo 02/19/2005 - Change wwv_flow_page_plugs.translate_title column to template_translatable
Rem       jkallman 02/21/2005 - Add wwv_flow_sw_stmts, wwv_flow_sw_main_keywords, wwv_flow_sw_set_keywords, wwv_flow_sw_create_keywords
Rem       jkallman 02/21/2005 - Set template_translatable = 'Y' for wwv_flow_page_plugs.plug_name in translatable columns
Rem       jkallman 02/22/2005 - Change wwv_flow_page_plugs.template_translatable back to translate_title
Rem       jkallman 02/22/2005 - Add additional date picker types to constraint wwv_flow_region_report_column.wwv_regrepcol_display_as
Rem       msewtz   02/23/2005 - Added column_link_checksum_type to wwv_flow_region_report_column
Rem       sspadafo 02/24/2005 - Added CLOSE_WINDOW to wwv_flow_step_processing check constraint
Rem       cjones   02/25/2005 - Add isrunnable column for script parsing
Rem       sspadafo 02/27/2005 - Remove template_translatable column from wwv_flow_page_plugs
Rem       sspadafo 03/05/2005 - Add 'CANCELING' to check constraint on wwv_flow_sw_results (cbcho)
Rem       sspadafo 03/05/2005 - Added wwv_flow_models, wwv_flow_model_pages, wwv_flow_model_page_cols (msewtz)
Rem       sspadafo 03/05/2005 - Added allow_plsql_editing column to wwv_flow_companies
Rem       sspadafo 03/08/2005 - Add item_filter column to wwv_flow_data
Rem       sspadafo 03/18/2005 - Added '999G999G999G999G990D0000' to view wwv_flow_format_masks
Rem       skutz    03/23/2005 - Added table wwv_flow_sc_trans
Rem       cjones   04/01/2005 - Allow COMMIT and ROLLBACK in scripts
Rem       sspadafo 04/05/2005 - Revised wwv_flow_models, wwv_flow_model_pages, wwv_flow_model_page_cols (msewtz)
Rem       jkallman 04/20/2005 - Modify view wwv_flow_collections to remove user_id from the predicate (Bug 4316237)
Rem       jkallman 04/20/2005 - Modify model pages for MSewtz
Rem       msewtz   04/27/2004 - modified model_page_cols, constraint wwv_flow_mpc_alignment: alignment in 'LEFT','CENTER','RIGHT'
Rem       cbcho    05/03/2005 - Added result_size to wwv_flow_sw_detail_results
Rem       cbcho    05/05/2005 - Added wwv_flow_sw_d_result_idx3 index to wwv_flow_sw_detail_results
Rem       cbcho    05/05/2005 - Added wwv_flow_sw_stmts_idx3 index to wwv_flow_sw_stmts
Rem       cbcho    05/05/2005 - Added wwv_flow_sw_result_idx3 to wwv_flow_sw_results
Rem       msewtz   05/06/2005 - added plug_query_max_columns to wwv_flow_page_plugs
Rem       sspadafo 05/06/2005 - Added check constraints to wwv_flow_qb_saved_cond out,st,grp columns for SKutz
Rem       cbcho    05/11/2005 - Changed wwv_flow_sw_stmts_idx3 to include stmt_id in the index
Rem       jkallman 05/12/2005 - Add wwv_flow_languages.nls_windows_charset
Rem       jkallman 05/12/2005 - Add wwv_flows.csv_encoding
Rem       sspadafo 05/17/2005 - Added SINCE to view wwv_flow_format_masks
Rem       msewtz   05/19/2005 - Modified create wwv_flow_models, made security group ID FK instead of session, replaces session index with security group id index
Rem       jkallman 05/31/2005 - Added index wwv_flow_list_items_idx1
Rem       jkallman 06/05/2005 - Added index wwv_flow_list_items_idx2
Rem       jkallman 06/22/2005 - Added index wwv_flow_qb_saved_query_uk
Rem       sspadafo 07/10/2005 - Removed table wwv_flow_restrict_admin, add tables wwv_flow_restricted_schemas, wwv_flow_rschema_exceptions (Bug 4296276)
Rem       sspadafo 07/19/2005 - Changed datatype of wwv_flow_page_plugs.required_patch from varchar2(255) to number (Bug 4499768)
Rem       jkallman 08/19/2005 - Add index wwv_flow_template_idx3
Rem       jkallman 12/03/2005 - Remove tables wwv_flow_rt_distributions$, wwv_flow_rt_requests$, wwv_flow_rt_downloads$
Rem       jkallman 12/09/2005 - Implement rotating logs for clickthru_log (Bug 4861215)
Rem       madelfio 01/23/2006 - Added tables associated with install wizard (wwv_flow_install_*)
Rem       jkallman 01/26/2006 - Add mail_reply to wwv_flow_mail_queue
Rem       madelfio 01/26/2006 - Modified wwv_flow_install for config message, install trigger conditions, and build options change.
Rem       madelfio 01/30/2006 - Combined indexes on wwv_flow_install_scripts and wwv_flow_install_checks
Rem       madelfio 02/06/2006 - Added build_options_message to wwv_flow_install
Rem       madelfio 02/09/2006 - Added required_free_kb, required_sys_privs, and required_names_available to wwv_flow_install
Rem       jkallman 02/15/2006 - Change mail_reply to varchar2 in wwv_flow_mail tables and views, add mail_send_error and mail_send_count
Rem       jkallman 02/22/2006 - Add US-ASCII to wwv_flow_charsets (Bug 4922076)
Rem       mhichwa  03/07/2006 - add LAST_LOGIN, BUILDER_LOGIN_COUNT, LAST_AGENT, LAST_IP columns to WWV_FLOW_FND_USER
Rem       mhichwa  03/07/2006 - add LAST_LOGIN column to WWV_FLOW_COMPANIES
Rem       mhichwa  04/06/2006 - Added wwv_flow_debug table and index
Rem       mhichwa  04/14/2006 - Added wwv_flow_app_comments table and index
Rem       jkallman 04/25/2006 - Add wwv_flow_builder_audit_trail and triggers from original audit.sql (Bug 5070914)
Rem       cbcho    05/18/2006 - Changed wwv_flow_templates_used to include default_page_template from wwv_flows (Bug 5192856)
Rem       mhichwa  06/01/2006 - Added sqlerrm column to wwv_flow_activity_log1$ and 2 and view.
Rem       mhichwa  06/05/2006 - Added calendar_icon and calendar_icon_attr columns to wwv_flow_themes table
Rem       mhichwa  06/06/2006 - Added sqlerrm_component_type and sqlerrm_component_name column
Rem       jkallman 06/09/2006 - Added sqlerrm_component_type and sqlerrm_component_name to wwv_flow_user_activity_log
Rem       mhichwa  06/12/2006 - Added page caching columns to wwv_flow_steps table, added wwv_flow_page_cache table
Rem       mhichwa  06/12/2006 - Added created_on and created_by to wwv_flow_steps to track page creation date
Rem       mhichwa  06/13/2006 - Added foreign key to delete cascade application page cache on removal of application
Rem       mhichwa  06/14/2006 - Added page_mode column to wwv_flow_activity_log1$ and 2$ tables, added column to activity log view
Rem       sbkenned 06/19/2006 - Added wwv_flow_site_map view to facilitate the creation of site maps for applications
Rem       msewtz   06/20/2006 - removed wwv_flow_application_tab and wwv_flow_application_tab_set (bug 5231754)
Rem       sbkenned 06/21/2006 - modified wwv_flow_site_map to include flow_id
Rem       sbkenned 06/21/2006 - added new views to expose application attributes outside of tool, but only within FLOWS user
Rem                           - wwv_flow_applications, wwv_flow_application_pages, wwv_flow_app_page_items, wwv_flow_app_page_regions, wwv_flow_app_page_processes
Rem       mhichwa  06/22/2006 - Added use_custom_item_layout, custom_item_layout columns to wwv_flow_page_plugs
Rem       mhichwa  06/22/2006 - Moved apex views added by sharon on 6/21 and 6/22 to new apex_views file
Rem       msewtz   06/29/2006 - added wwv_flow_model_page_cols.column_sequence (bug 5363758)
Rem       jkallman 08/23/2006 - Corrected page_id column of wwv_flow_translatable_columns for post element text (Bug 5485723)
Rem       jkallman 08/23/2006 - Added grant of delete on wwv_flow_user_mail_queue (Bug 5485866)
Rem       jkallman 08/23/2006 - Added indexes on wwv_flow_mail_queue and wwv_flow_mail_log (Bug 5453208)
Rem       mhichwa  11/03/2006 - added tables to store images, css, and js examples
Rem       mhichwa  11/06/2006 - Added wwv_flow_app_build_pref table
Rem       mhichwa  11/06/2006 - Added language columns to wwv_flow_app_build_pref
Rem       mhichwa  11/08/2006 - Changed csv_output_link_text from a varchar2(255) to a varchar2(4000)
Rem       mhichwa  11/08/2006 - added region_name varchar2(255) to wwv_flow_page plugs
Rem       msewtz   11/28/2006 - added PDF attributes to wwv_flow_page_plugs
Rem       sspadafo 11/30/2006 - Added views wwv_flow_list_of_values_data_v,wwv_flow_lists_of_values$_v (Bug 5597257)
Rem       sspadafo 11/30/2006 - Added access log tables, views
Rem       sspadafo 11/30/2006 - Added new columns to wwv_flow_fnd_user and wwv_flow_companies for new security features
Rem       cbcho    12/04/2006 - Added POPUP_COLOR as wwv_valid_fsitem_displayas check constraint value
Rem       cbcho    12/04/2006 - Added popup_icon2, popup_icon_attr2 to wwv_flow_popup_lov_template
Rem       cbcho    12/05/2006 - Added wwv_flow_flash_charts, wwv_flow_flash_chart_series tables
Rem       sathikum 12/06/2006 - Added fields to wwv_flow_cal_templates for Daily & Weekly Calendar
Rem       msewtz   12/08/2006 - Added wwv_flow_print_templates
Rem       msewtz   12/11/2006 - Changed wwv_flow_print_templates, removed one column, changed one column name
Rem       mhichwa  12/11/2006 - Added shared_query_id column to wwv_flow_page plugs to support shared queries shared component
Rem       mhichwa  12/12/2006 - added wwv_flow_print_templates and wwv_flow_shared_queries tables
Rem       jkallman 12/12/2006 - Correct syntax errors in plug_prn_format check constraint
Rem       mhichwa  12/12/2006 - Changed lob storage for wwv_flow_page_cache, per tkyte recommendation, doc says it works in 9.2
Rem       mhichwa  12/13/2006 - Enabled additional inline lob storage to avoid phyical reads per each access
Rem       jstraub  12/13/2006 - Added 'A' to check constraint on wwv_flow_ws_parameters
Rem       msewtz   12/13/2006 - Renamed wwv_flow_print_templates to wwv_flow_report_layouts
Rem       jstraub  12/13/2006 - Added wallet_path and wallet_pwd to wwv_flows for SSL (HTTPS) support
Rem       msewtz   12/13/2006 - Added new standard icons
Rem       mhichwa  12/14/2006 - added get_version_sql_query column to support wwv_flow_install table to determine if upgrade needed
Rem       mhichwa  12/14/2006 - added script_type to wwv_flow_install_scripts to track if script type
Rem       mhichwa  12/14/2006 - Added index wwv_flow_page_cache_idx2
Rem       mhichwa  12/14/2006 - Added lob (page_text) store as (cache enable storage in row) to page cache table
Rem       mhichwa  12/14/2006 - Changed page cache table to not have unique indexes to support caching by user
Rem       mhichwa  12/21/2006 - Added plug_cache_when, plug_cache_expression1, plug_cache_expression2 columns
Rem       mhichwa  12/22/2006 - Indexed unindexed foreign keys for flash charts and sc trans table
Rem       mhichwa  12/29/2006 - added run_process_by_mode column to wwv_flow_page_processing in support of paetec
Rem       mhichwa  12/29/2006 - removed run_process_by_mode
Rem       mhichwa  01/02/2007 - Added pre_element_text column to wwv_flow_step_items table
Rem       mhichwa  01/02/2007 - Added cached_regions column to activity logs to track regions rendered from cache by page view
Rem       msewtz   01/02/2007 - Added include_in_export, print width and print align to wwv_flow_region_report_column
Rem       msewtz   01/03/2007 - Added prn_output_file_name to wwv_flow_page_plugs
Rem       cbcho    01/03/2007 - Changed wwv_flow_flash_charts ddl
Rem       mhichwa  01/03/2007 - Added remote_addr column to sessions table
Rem       jstraub  01/03/2007 - Removed wallet columns from wwv_flows, moved to platform preference
Rem       cbcho    01/04/2007 - Added gradient_rotation,names_rotation,values_rotation cols to wwv_flow_flash_charts
Rem       mhichwa  01/05/2007 - Added pre element text as a translatable text column (126)
Rem       cbcho    01/05/2007 - Changed wwv_flow_flash_chart_series.series_query varchar2(4000) to clob
Rem       mhichwa  01/05/2007 - Changed index: create index wwv_flow_page_cache_idx2 to put region id on leading edge
Rem       nagkrish 01/08/2007 - Added two new tables wwv_flow_random_images and wwv_flow_request_verifications
Rem       rvallam  01/08/2007 - Added a new value 'SHUTTLE' to constraint wwv_valid_fsitem_displayas in wwv_flow_step_items
Rem       ashiverm 01/09/2007 - Added new values 'TEXTAREA_WITH_HTML_EDITOR_BASIC' and 'TEXTAREA_WITH_HTML_EDITOR_STANDARD' to constraints
Rem                           - wwv_valid_fsitem_displayas in wwv_flow_step_items, wwv_fhc_display_as_form in wwv_flow_hnt_column_info,
Rem                           - wwv_flow_hnt_display_as_form in wwv_flow_hnt_argument_info, and wwv_mpc_display_as_form in wwv_flow_model_page_cols
Rem       cbcho    01/09/2007 - Added attribute_01 - 05 to wwv_flow_flash_charts
Rem       msewtz   01/10/2007 - Added 32x32 standard icons
Rem       cbcho    01/10/2007 - Added prefix,postfix,decimal_sep,group_sep,decimal_place for x and y axis to wwv_flow_flash_charts
Rem       mhichwa  01/11/2007 - Added chart_region_id
Rem       jkallman 01/11/2007 - Remove extraneous newline in wwv_flow_request_verifications
Rem	      sathikum 01/12/2007 - Added fields to wwv_flow_cals to support weekly & Daily Calendar
Rem       cbcho    01/16/2007 - Removed series_color,series_chart_type,display_attr from wwv_flow_flash_chart_series
Rem       msewtz   01/16/2007 - Added columns to wwv_flow_shared_queries
Rem       jkallman 01/17/2007 - Correct formatting errors, correct issues with wwv_flow_standard_css, wwv_flow_standard_icons, and wwv_flow_standard_js
Rem       madelfio 01/17/2007 - Added columns to wwv_flow_install for upgrade messages
Rem       cbcho    01/18/2007 - Added wwv_flow_flash_chart,wwv_flow_flash_chart_series to translatable columns
Rem       cbcho    01/18/2007 - Added flow_id to wwv_flow_flash_chart_series
Rem       cbcho    01/18/2007 - Added wwv_flow_fl_ch_idx and wwv_flow_fl_ch_sr_idx in wwv_flow_flash_charts and wwv_flow_flash_chart_series
Rem       jstraub  01/22/2007 - Added date_type_column to wwv_flow_cals
Rem       jkallman 01/23/2007 - Move insert statements to apex_install_data.sql
Rem       cbcho    01/23/2007 - Added wwv_flow_flash_charts_fk2 to wwv_flow_flash_charts and removed x_axis_decimal_sep, y_axis_decimal_sep
Rem       cbcho    01/25/2007 - Changed wwv_flow_flash_chart_series to make series_query_parse_opt nullable
Rem       msewtz   01/25/2007 - Added xml_structure to wwv_flow_shared_queries
Rem       madelfio 01/25/2007 - Added script_type column to the unique index on wwv_flow_install_scripts
Rem       jkallman 01/26/2007 - Added PICK_DATE_USING_FORMAT_MASK
Rem       sspadafo 01/27/2007 - Fixed views wwv_flow_list_of_values_data_v,wwv_flow_lists_of_values$_v (Bug 5597257)
Rem       jkallman 01/28/2007 - Correct views wwv_flow_list_of_values_data_v,wwv_flow_lists_of_values$_v
Rem       sspadafo 01/28/2007 - Fix bug in view wwv_flow_lists_of_values$_v
Rem       msewtz   02/01/2007 - Added columns for print header and footer alignment and border color to page_plugs
Rem       cbcho    02/02/2007 - Added columns dial_tick_attr,margins,grid_spacing,grid_labels_font,chart_title_font to wwv_flow_flash_charts
Rem       cbcho    02/02/2007 - Added columns x_axis_grid_spacing,y_axis_grid_spacing,omit_label_interval to wwv_flow_flash_charts
Rem       mhichwa  02/02/2007 - Added sort_null column
Rem       jstraub  02/05/2007 - Added daily_month_title_format to wwv_flow_cal_templates
Rem       sspadafo 02/09/2007 - Added "and security_group_id <> 0" to wwv_flow_files view
Rem       jkallman 02/20/2007 - Reduce size of index wwv_flow_mail_log_idx1 (to avoid ORA-01450 on small db block size dbs)
Rem       sspadafo 02/23/2007 - Added web_password2 to wwv_flow_fnd_user (Bugs 5613085,5597269)
Rem       jstraub  03/07/2007 - Added wwv_flow_upgrade_progress
Rem       sspadafo 04/27/2007 - Fixed view wwv_flow_templates_used (Bug 5979712)
Rem       jstraub  05/03/2007 - Replaced stand-alone flow_id indexes for wwv_flow_*_templates with index on security_group_id, reference_id (Bug 6031972)
Rem       jstraub  05/03/2007 - Fixed index on wwv_flow_popup_lov_template
Rem       jkallman 05/29/2007 - Reduce size of indexes wwv_flow_mail_log_idx1 and wwv_flow_report_layouts_idx2 (Bug 6066919)
Rem       sspadafo 06/01/2007 - Fixed view wwv_flow_templates_used to work around optimizer bug (base bugs 4533352 and 5979712, new bug filed:6087758)
Rem       madelfio 08/13/2007 - Merged all create table statements from worksheet_tab.sql
Rem       jstraub  08/23/2007 - Added wwv_flow_worksheet_categories and category_id to wwv_flow_worksheet_rpts
Rem       jstraub  08/23/2007 - Added display_sequence to wwv_flow_worksheet_categories
Rem       jstraub  08/24/2007 - Removed session_id from wwv_flow_worksheet_categories
Rem       madelfio 09/05/2007 - Added search_string to wwv_flow_worksheet_rpts
Rem       madelfio 09/05/2007 - Added detail_link to wwv_flow_worksheets
Rem       madelfio 09/07/2007 - Updated wwv_flow_worksheet_conditions to support text search conditions
Rem       madelfio 09/12/2007 - Added autosave column and increased length of break_on in wwv_flow_worksheet_rpts
Rem       madelfio 09/12/2007 - Added alias column to wwv_flow_worksheets
Rem       madelfio 09/17/2007 - Added report_list_mode to wwv_flow_worksheets
Rem       madelfio 09/18/2007 - Changed condition_text to condition_sql in wwv_flow_worksheets
Rem       madelfio 09/24/2007 - Added flashback columns to worksheet_rpts and configuration option columns to wwv_flow_worksheets
Rem       madelfio 09/27/2007 - Updated worksheet tables to support SQL queries and disabling breaks
Rem       madelfio 10/02/2007 - Added preference columns to wwv_flow_worksheets
Rem       jkallman 10/02/2007 - Convert LONG columns to CLOB in wwv_flow_data and wwv_flow_banner
Rem       madelfio 10/02/2007 - Added report_type, additional aggregation columns to wwv_flow_worksheet_rpts
Rem       madelfio 10/03/2007 - Added new worksheet columns, wwv_flow_worksheet_computation table for computed columns
Rem       madelfio 10/04/2007 - Added flow_id, page_id, and region_id to relevant worksheet tables
Rem       jkallman 10/04/2007 - Added table wwv_flow_mail_attachments, view wwv_flow_user_mail_attachments
Rem       jkallman 10/08/2007 - Add column inline to wwv_flow_mail_attachments
Rem       jstraub  10/09/2007 - Added foreign key constraint on wwv_flow_worksheets(region_id) to wwv_flow_page_plugs
Rem       madelfio 10/09/2007 - Added description column to wwv_flow_worksheet_rpts
Rem       madelfio 10/09/2007 - Added download_formats column to wwv_flow_worksheets
Rem       madelfio 10/09/2007 - Added repeat_control_break_headers column to wwv_flow_worksheets
Rem       madelfio 10/11/2007 - Added columns to support worksheet column links
Rem       madelfio 10/11/2007 - Fixed bad column reference in constraint on wwv_flow_worksheets.pagination_type
Rem       madelfio 10/11/2007 - Fixed creation of wwv_flow_worksheets
Rem       madelfio 10/11/2007 - Added flow_id to wwv_flow_worksheet_columns and wwv_flow_worksheet_col_groups
Rem       jstraub  10/11/2007 - Added wwv_flow_worksheet_lov_entries
Rem       madelfio 10/15/2007 - Added page_id, display_by_default columns to wwv_flow_worksheet_columns
Rem       jkallman 10/15/2007 - Added media_type column to wwv_flows and wwv_flow_steps
Rem       mhichwa  10/15/2007 - Added builder_notification_message column to wwv_flow_companies table
Rem       cbcho    10/15/2007 - Added wwv_flow_ws_exclude_null_ck,wwv_flow_ws_hide_extra_ck to wwv_flow_worksheets
Rem       mhichwa  10/16/2007 - Added ITEM_IS_NOT_NUMERIC validation type
Rem       mhichwa  10/24/2007 - Added table wwv_flow_application_groups to manage application groups
Rem       madelfio 10/26/2007 - Added columns for report sequence, permanent filters, and star schema support (for Audit Vault)
Rem       madelfio 10/26/2007 - Removed display_by_default
Rem       cbcho    10/26/2007 - Removed show_detail_link,detail_link,display_detail_location from wwv_flow_worksheets
Rem       madelfio 10/26/2007 - Changed tabs to spaces.  Added report_id_item to wwv_flow_worksheets
Rem       madelfio 10/26/2007 - Added max_row_count, max_row_count_message to wwv_flow_worksheets
Rem       cbcho    10/29/2007 - Added display_condition_type,display_condition,display_condition2,security_scheme to wwv_flow_worksheet_columns
Rem       madelfio 10/30/2007 - Removed repeat_control_break_headers from wwv_flow_worksheets
Rem       madelfio 10/30/2007 - Removed compute_sum, etc from wwv_flow_worksheet_columns
Rem       msewtz   10/31/2007 - Added report_implementation to wwv_flow_model_pages
Rem       madelfio 11/01/2007 - Made worksheet alias nullable
Rem       madelfio 11/01/2007 - Removed obsolete download_link_display_position column from wwv_flow_worksheets
Rem       madelfio 11/02/2007 - Added show_detail_link, detail_link back into wwv_flow_worksheets
Rem       madelfio 11/02/2007 - Added sql_hint to wwv_flow_worksheets
Rem       madelfio 11/02/2007 - Added no_data_found_message to wwv_flow_worksheets
Rem       madelfio 11/05/2007 - Added worksheet rpt lov columns, removed distinct_value_filter
Rem       sathikum 11/06/2007 - Added calendar_type column to wwv_flow_cals
Rem       mhichwa  11/07/2007 - Added not null sgid for wwv_flow_templates, wwv_flow_cal_templates, wwv_flow_jobs, wwv_flow_page_submissions
Rem       mhichwa  11/07/2007 - Added not null sgid for wwv_flow_shared_queries, wwv_flow_shortcuts, wwv_flow_mail_log, wwv_flow_mail_queue_pk
Rem       mhichwa  11/07/2007 - Added not null sgid for wwv_flow_clickthru_log$, wwv_flow_clickthru_log2$, wwv_flow_popup_lov_template, wwv_flow_app_build_pref
Rem       mhichwa  11/07/2007 - Changed view wwv_flow_plsql_jobs to select sgid from dual, and to use a nv, numeric value, and not a v varchar value.
Rem       mhichwa  11/07/2007 - Changed view wwv_flow_collections to reference flow_id session state using the nv function and not v function
Rem       mhichwa  11/07/2007 - Changed view wwv_flow_clickthru_log to select sgid from dual and not directly reference plsql function
Rem       jkallman 11/19/2007 - Added date_format to wwv_flows
Rem       jkallman 11/20/2007 - Added PICK_DATE_USING_APP_DATE_FORMAT to all display_as check constraints
Rem       msewtz   11/21/2007 - Added table wwv_flow_shared_qry_sql_stmts
Rem       mhichwa  11/26/2007 - Added include_apex_css_js_yn column to wwv_flow_steps table
Rem       jstraub  11/28/2007 - Added heading_alignment, column_alignment, display_text_as, rpt_show_filter_lov, rpt_filter_date_ranges, is_sortable to wwv_flow_worksheet_columns
Rem       jstraub  11/28/2007 - Added is_default to wwv_flow_worksheet_rpts
Rem       mhichwa  11/28/2007 - Added theme_description, theme_image, theme_security_group_id
Rem       hfarrell 11/28/2007 - Updated constraint wwv_flow_mp_page_type on wwv_flow_model_pages to include MASTERDETAIL page_type
Rem       mhichwa  11/28/2007 - Added runtime_where_clause column
Rem       jkallman 11/28/2007 - Added ISO number masks to wwv_flow_format_masks (Bug 5142796)
Rem       jkallman 11/28/2007 - Added date_format column to wwv_flow_app_build_pref
Rem       madelfio 11/28/2007 - Updated wwv_flow_worksheet_col_grps_fk to set null on delete
Rem       mhichwa  11/29/2007 - Added runtime_where_clause column to wwv_flow_processing table
Rem       sspadafo 11/30/2007 - Added ajax_pagination column to wwv_flow_page_plugs
Rem       sspadafo 11/30/2007 - Changed ajax_pagination column in wwv_flow_page_plugs to ajax_enabled
Rem       sspadafo 12/01/2007 - Added 'HIDDEN_PROTECTED' wherever 'HIDDEN' occurred, except for check constraint on wwv_flow_region_upd_rpt_cols
Rem       sspadafo 12/01/2007 - Removed extra occurrence of 'HIDDEN' from several check constraints where it was listed twice
Rem       mhichwa  12/03/2007 - Added before_column_heading and after_column_heading columns to support scrollable fixed header templates
Rem       mhichwa  12/04/2007 - Added insert into wwv_flow_companies 3,11,REPOSITORY
Rem       mhichwa  12/04/2007 - Added theme_image_mime_type and  custom_image column to wwv_flow_themes table
Rem       msewtz   12/06/2007 - Added XML as option to constraint on wwv_flow_page_plugs.plug_prn_format
Rem       cbcho    12/07/2007 - Changed wwv_flow_ws_col_disp_txt_as_ck in wwv_flow_worksheet_columns table
Rem       msewtz   12/09/2007 - Added prn_print_server_overwrite to wwv_flow_page_plugs
Rem       hfarrell 12/10/2007 - Added wwv_flow_model_page_regions table and modified wwv_flow_model_pages and wwv_flow_model_page_cols tables
Rem       hfarrell 12/10/2007 - Removed check constraint wwv_flow_mpr_source from wwv_flow_model_page_regions.region_source column
Rem       madelfio 12/10/2007 - Updated check constraints on wwv_flow_worksheet.show_detail_link and wwv_flow_worksheet_columns.display_text_as
Rem       madelfio 12/10/2007 - Added columns in wwv_flow_worksheets, wwv_flow_worksheet_columns, and wwv_flow_worksheet_rpts
Rem       madelfio 12/11/2007 - Added region_attributes_substitution to wwv_flow_page_plugs for mhichwa
Rem       madelfio 12/11/2007 - Added show_help to wwv_flow_worksheets
Rem       mhichwa  12/11/2007 - Added std_rpt_max_query_cost to wwv_flow_page_plugs
Rem       madelfio 12/11/2007 - Added chart_value_column, chart_value_label to wwv_flow_worksheet_rpts
Rem       msewtz   12/12/2007 - Added prn_content_disposition, prn_document_header, prn_width_units to wwv_flow_page_plugs
Rem       msewtz   12/12/2007 - Added content_disposition, document_header to wwv_flow_shared_queries
Rem       hfarrell 12/13/2007 - Removed extra line from wwv_flow_model_page_regions table ddl
Rem       mhichwa  12/13/2007 - Added check constraint RIGHT_OF_IR_SEARCH_BAR
Rem       mhichwa  12/13/2007 - Added report_attributes_substitution
Rem       madelfio 12/14/2007 - Added show_control_break to wwv_flow_worksheets
Rem       msewtz   12/17/2007 - Added XML as option to constraint wwv_flow_shared_qry_format
Rem       madelfio 12/17/2007 - Added columns to wwv_flow_worksheets, modified flow_id in worksheet_rpts to be not null
Rem       madelfio 12/18/2007 - Updated wwv_flow_wscol_showfil_lov_ck constraint
Rem       madelfio 12/18/2007 - Added to wwv_flow_worksheets: show_nulls_as, download_filename
Rem       madelfio 12/18/2007 - Added to wwv_flow_worksheet_columns: column_comment
Rem       madelfio 12/20/2007 - Changed wwv_flow_worksheet_computation.format_mask to varchar2
Rem       madelfio 12/20/2007 - Added flow_id, page_id to worksheet_conditions, worksheet_computations
Rem       hfarrell 01/02/2008 - Added 'HIDDEN_PROTECTED' wherever 'HIDDEN' occurred in the wwv_flow_model_page_cols model table
Rem       madelfio 01/08/2008 - Added count_columns_on_break to wwv_flow_worksheet_rpts
Rem       madelfio 01/10/2008 - Changed length of column_identifier for standard and computed IR columns
Rem       madelfio 01/13/2008 - Added missing foreign key indexes for worksheet tables
Rem       hfarrell 01/16/2008 - Updated DATATYPE check constraint on wwv_flow_model_page_cols to include BLOB
Rem       jstraub  01/18/2008 - Updated wwv_flow_worksheet_categories, added flow_id, changed foreign key reference to security_group_id not worksheet_id
Rem       sspadafo 01/22/2008 - Fixed view wwv_flow_user_access_log to check for zero security_group_id (Bug 6454065)
Rem       madelfio 01/23/2008 - Added chart_sorting to wwv_flow_worksheet_rpts
Rem       madelfio 01/24/2008 - Added pagination_min_row to wwv_flow_worksheet_rpts
Rem       madelfio 01/24/2008 - Added 'CLOB', 'OTHER' to interactive report column_type check
Rem       madelfio 01/26/2008 - Altered unique constraint on wwv_flow_worksheet_conditions to support translating filter names
Rem       madelfio 01/26/2008 - Added page_id to worksheets index, to speed up reset pagination query.
Rem       hfarrell 01/31/2008 - Updated DATATYPE check constraint on wwv_flow_model_page_cols to include CLOB
Rem       jkallman 01/31/2008 - Corrected index wwv_flow_worksheet_cond_uk2
Rem       jkallman 02/11/2008 - Rename workspace name for SGID=11 to COM.ORACLE.APEX.REPOSITORY
Rem       madelfio 02/12/2008 - Added to wwv_flow_worksheet_computation: column_type
Rem       madelfio 02/18/2008 - Updated unique index wwv_flow_worksheet_cond_uk2 to fix bug 6827883
Rem       madelfio 02/21/2008 - Updated unique index wwv_flow_worksheet_cond_uk2 to avoid key length error
Rem       jkallman 02/25/2008 - Corrected wwv_flow_worksheet_cond_uk2
Rem       madelfio 02/26/2008 - Added not null constraint on wwv_flow_worksheet_rpts.page_id
Rem       madelfio 05/21/2008 - Added foreign key on wwv_flow_worksheet_rpts.security_group_id (bug 7115813)
Rem       hfarrell 12/04/2008 - Added block_id and mig_comments to WWV_FLOW_MODEL_PAGES table for Forms Conversions
Rem       hfarrell 12/08/2008 - Added report_id to WWV_FLOW_MODEL_PAGES table for Oracle Reports Conversion
Rem       jstraub  12/16/2008 - Added autocomplete_on_off to wwv_flow_steps
Rem       jkallman 12/18/2008 - Added application_info to log tables
Rem       jkallman 12/20/2008 - Corrected typo in data type of autocomplete_on_off
Rem       sspadafo 12/22/2008 - Added MAX_SESSION_LENGTH_MIN, ON_MAX_SESSION_TIMEOUT_URL, MAX_SESSION_IDLE_MIN, ON_MAX_IDLE_TIMEOUT_URL columns
Rem       sspadafo 12/26/2008 - Added encrypt_session_state_yn column to wwv_flow_step_items
Rem       sspadafo 12/26/2008 - Added is_encrypted to wwv_flow_data table
Rem       jstraub  12/29/2008 - Added PASSWORD DNSS types to check constraints in tables wwv_flow_step_items, wwv_flow_hnt_column_info, wwv_flow_model_page_regions
Rem       sspadafo 01/05/2009 - Added use_secure_cookie_yn and check constraint in wwv_flow_custom_auth_setups
Rem       sspadafo 01/09/2009 - Added save_state_before_branch_yn to wwv_flow_step_branches
Rem       sspadafo 01/17/2009 - Added table wwv_flow_password_history to record passwords that cannot be re-used for an account for a certain period
Rem       sspadafo 01/18/2009 - Added column last_failed_login to wwv_flow_fnd_user
Rem       sspadafo 01/22/2009 - Added fk constraint on security_group_id in wwv_flow_password_history
Rem       sspadafo 01/24/2009 - Redo wwv_flow_password_history table/index structure
Rem       jstraub  04/15/2009 - Added composite index on wwv_flow_region_report_column, security_group_id,flow_id (Bug 8371342)

------------------------
-- Set Security Group ID
--

begin
wwv_flow_security.g_security_group_id := 10;
end;
/

--------------------------------------------------------------------
-- F L O W   S E S S I O N   S E Q U E N C E
-- This sequence is used for flow sessions (wwv_flow_sessions$).
--

create sequence wwv_flow_session_seq
/



--------------------------------------------------------------------
-- W O R K S P A C E
-- id                      = internal ID number
-- provisioning_company_id = security_group_id (workspace id)
-- short_name              = the company name / workspace name
-- schema_name             = name used to login into the service
--

create table wwv_flow_companies (
    id                            number
                                  constraint wwv_flow_companies_pk
                                  primary key,
    provisioning_company_id       number not null unique,
    short_name                    varchar2(255) not null,
    first_schema_provisioned      varchar2(30) not null,
    allow_plsql_editing           varchar2(1),
    last_login                    date,
    expire_fnd_user_accounts      varchar2(1)
                                  constraint wwv_flow_companies_expire
                                  check (expire_fnd_user_accounts in ('Y','N')),
    account_lifetime_days         number,
    fnd_user_max_login_failures   number,
    builder_notification_message  varchar2(4000)
    )
/


-- create unique index wwv_flow_companies_idx0 on wwv_flow_companies (provisioning_company_id)
create unique index wwv_flow_companies_idx1 on wwv_flow_companies (short_name)
/
create unique index wwv_flow_companies_idx2 on wwv_flow_companies (provisioning_company_id, short_name)
/

prompt ...insert default companies

begin
    insert into wwv_flow_companies (id, provisioning_company_id, short_name, first_schema_provisioned) values (0,0,'Unknown',wwv_flow.g_flow_schema_owner);
    insert into wwv_flow_companies (id, provisioning_company_id, short_name, first_schema_provisioned) values (1,10,'INTERNAL',wwv_flow.g_flow_schema_owner);
    insert into wwv_flow_companies (id, provisioning_company_id, short_name, first_schema_provisioned) values (3,11,'COM.ORACLE.APEX.REPOSITORY',wwv_flow.g_flow_schema_owner);
    commit;
end;
/



create table wwv_flow_company_schemas (
    id                      number
                            constraint wwv_flow_company_schemas_pk
                            primary key,
    security_group_id       number not null
                            constraint wwv_flow_comp_schemas_fk
                            references wwv_flow_companies(provisioning_company_id)
                            on delete cascade,
    schema                  varchar(30),
    company_schema_comments varchar2(4000)
    )
/

create unique index wwv_flow_company_schemas_idx on wwv_flow_company_schemas (security_group_id, schema);


------------------
-- P L A T F O R M
--
create table wwv_flow_platform_prefs (
    id                number
                      constraint wwv_flow_platform_prefs_pk
                      primary key,
    name              varchar2(255) not null,
    value             varchar2(4000) not null,
    pref_desc         varchar2(4000),
    security_group_id number not null
                      constraint wwv_flow_platform_prefs_fk
                      references wwv_flow_companies(provisioning_company_id)
                      on delete cascade)
/


--------------------------------------------------------------------
-- F L O W S
-- id                = flow number
-- display_id        = flowID unique within a security_group_id (not yet implemented)
-- security_group_id = identifies company
-- owner             = identifies who the flow is parsed as
-- name              = identifies the logical name of the flow
-- global_id         = globally uniquely identifies this flow (not implemented)

prompt ...create table wwv_flows

create table wwv_flows (
    id                            number
                                  constraint wwv_flow_flow_PK
                                  primary key,
    security_group_id             number not null
                                  constraint wwv_flows_fk
                                  references wwv_flow_companies(provisioning_company_id)
                                  on delete cascade,
    global_id                     number,
    alias                         varchar2(255) not null,
    display_id                    number,
    owner                         varchar2(30)  not null,
    name                          varchar2(255) not null,
    default_page_template         number,
    home_link                     varchar2(2000),
    box_width                     varchar2(30),
    webdb_logging                 varchar2(30)
                                  constraint wwv_valid_flow_loggingyesno
                                  check (webdb_logging in (
                                  'YES',
                                  'NO')),
    printer_friendly_template     number,
    default_region_template       number,
    default_label_template        number,
    default_report_template       number,
    default_list_template         number,
    default_menu_template         number,
    default_button_template       number,
    default_calendar_template     number,
    error_template                number,
    flow_language                 varchar2(255),
    flow_language_derived_from    varchar2(30)
                                  constraint wwv_valid_flow_lang_from
                                  check (flow_language_derived_from in (
                                  'en-US', 'en-GB',
                                  'fr', 'es',
                                  'no', 'pt',
                                  'de', 'it',
                                  'bg', 'zh',
                                  'cs', 'da',
                                  'nl', 'fi',
                                  'fr-CA', 'fr-BE',
                                  'el', 'hu',
                                  'id', 'ga',
                                  'ja', 'ko',
                                  'pl', 'pt-BR',
                                  'ro', 'ru',
                                  'sr', 'sk',
                                  'sl', 'sv',
                                  'tr', 'uk',
                                  'FLOW_PRIMARY_LANGUAGE',
                                  'BROWSER',
                                  'ITEM_PREFERENCE',
                                  'FLOW_PREFERENCE',
                                  '0')),
    charset                       varchar2(255),
    media_type                    varchar2(255),
    date_format                   varchar2(255),
    flow_image_prefix             varchar2(255),
    authentication                varchar2(255)
                                  constraint wwv_flow_valid_auth
                                  check (authentication in (
                                  'DATABASE',
                                  'COOKIE',
                                  'ASFCOOKIE',
                                  'ORACLE_LOGIN_SERVER',
                                  'CUSTOM2',
                                  'CUSTOM')),
    login_url                     varchar2(2000),
    logout_url                    varchar2(2000),
    --
    MAX_SESSION_LENGTH_SEC        number,
    ON_MAX_SESSION_TIMEOUT_URL    varchar2(4000),
    MAX_SESSION_IDLE_SEC          number,
    ON_MAX_IDLE_TIMEOUT_URL       varchar2(4000),
    --
    logo_image                    varchar2(500),
    logo_image_attributes         varchar2(4000),
    public_url_prefix             varchar2(255),
    public_user                   varchar2(255),
    dbauth_url_prefix             varchar2(255),
    proxy_server                  varchar2(255),
    custom_authentication_process varchar2(4000),
    custom_authentication_page    varchar2(255),
    custom_auth_login_url         varchar2(4000),
    flow_version                  varchar2(255),
    flow_status                   varchar2(30)
                                  constraint wwv_flow_valid_status
                                  check (flow_status in (
                                  'AVAILABLE',
                                  'AVAILABLE_W_EDIT_LINK',
                                  'AVAILABLE_W_INLINE_EDIT',
                                  'DEVELOPERS_ONLY',
                                  'UNAVAILABLE_URL',
                                  'UNAVAILABLE_PLSQL',
                                  'RESTRICTED_ACCESS',
                                  'UNAVAILABLE')),
    flow_unavailable_text         varchar2(4000),
    restrict_to_user_list         varchar2(4000),
    application_tab_set           number,
    exact_substitutions_only      varchar2(1)
                                  constraint wwv_flow_exact_subs_flag
                                  check (exact_substitutions_only in ('Y','N')),
    csv_encoding                  varchar2(1) constraint wwv_flow_csv_encoding
                                  check (csv_encoding in (
                                  'Y',
                                  'N')),
    --
    build_status                  varchar2(30)
                                  constraint wwv_flow_valid_build_status
                                  check (build_status in (
                                  'RUN_AND_BUILD',
                                  'RUN_ONLY')),
    --
    vpd                           varchar2(4000),
    security_scheme               varchar2(255),
    rejoin_existing_sessions      varchar2(1) constraint wwv_flow_valid_rejoin_es
                                  check (rejoin_existing_sessions in (
                                  'Y',
                                  'N')),
    --
    checksum_salt                 raw(255),
    checksum_salt_last_reset      date,
    --
    substitution_string_01        varchar2(255),
    substitution_value_01         varchar2(4000),
    substitution_string_02        varchar2(255),
    substitution_value_02         varchar2(4000),
    substitution_string_03        varchar2(255),
    substitution_value_03         varchar2(4000),
    substitution_string_04        varchar2(255),
    substitution_value_04         varchar2(4000),
    substitution_string_05        varchar2(255),
    substitution_value_05         varchar2(4000),
    substitution_string_06        varchar2(255),
    substitution_value_06         varchar2(4000),
    substitution_string_07        varchar2(255),
    substitution_value_07         varchar2(4000),
    substitution_string_08        varchar2(255),
    substitution_value_08         varchar2(4000),
    substitution_string_09        varchar2(255),
    substitution_value_09         varchar2(4000),
    substitution_string_10        varchar2(255),
    substitution_value_10         varchar2(4000),
    substitution_string_11        varchar2(255),
    substitution_value_11         varchar2(4000),
    substitution_string_12        varchar2(255),
    substitution_value_12         varchar2(4000),
    substitution_string_13        varchar2(255),
    substitution_value_13         varchar2(4000),
    substitution_string_14        varchar2(255),
    substitution_value_14         varchar2(4000),
    substitution_string_15        varchar2(255),
    substitution_value_15         varchar2(4000),
    substitution_string_16        varchar2(255),
    substitution_value_16         varchar2(4000),
    substitution_string_17        varchar2(255),
    substitution_value_17         varchar2(4000),
    substitution_string_18        varchar2(255),
    substitution_value_18         varchar2(4000),
    substitution_string_19        varchar2(255),
    substitution_value_19         varchar2(4000),
    substitution_string_20        varchar2(255),
    substitution_value_20         varchar2(4000),
    --
    last_updated_by               varchar2(255),
    last_updated_on               date,
    --
    default_chart_template        number,
    default_reportr_template      number,
    default_form_template         number,
    default_wizard_template       number,
    default_tabform_template      number,
    default_menur_template        number,
    default_listr_template        number,
    theme_id                      number,
    group_id                      number,
    --
    global_notification           varchar2(4000),
    page_protection_enabled_y_n   varchar2(1)
                                    constraint wwv_flow_page_prot_enable_flag
                                    check (page_protection_enabled_y_n in ('Y','N'))
    )
/

create unique index wwv_flows_pk_idx on wwv_flows (security_group_id, id)
/

create unique index wwv_flows_alias_idx on wwv_flows(alias, security_group_id)
/



--
--
--
prompt ...wwv_flow_application_groups

create table wwv_flow_application_groups (
   id                         number
                              constraint wwv_flow_app_group_pk
                              primary key,
   group_name                 varchar2(255) not null,
   group_comment              varchar2(4000),
   created_on                 date,
   created_by                 varchar2(255),
   updated_on                 date,
   updated_by                 varchar2(255),
   security_group_id          number not null
                              constraint wwv_flow_app_groups_fk
                              references wwv_flow_companies(provisioning_company_id)
                              on delete cascade)
/


create index wwv_flow_app_grp_idx1 on wwv_flow_application_groups (security_group_id);

--
-- This table allows flows developers to reserve an ID and then choose
-- to create a flow or not to create a flow.  This prevents two developers
-- from being able to create the same flow id using the create flow wizard.
--
prompt ...wwv_flows_reserved

create table wwv_flows_reserved (
   id                number
                     constraint wwv_flow_reserved_pk
                     primary key,
   created_on        date,
   created_by        varchar2(255)
   )
/


create index wwv_flows_reserved_idx on wwv_flows_reserved(created_on)
/

--
-- This table allows flows developers to reserve an ID and then choose
-- to create a page or not to create a page.  This prevents two developers
-- from being able to create the same flow page using the create page wizard.
--
prompt ...wwv_flow_pages_reserved

create table wwv_flow_pages_reserved (
   id                number,
   flow_id           number
                     constraint wwv_flow_pages_reserved_fk
                     references wwv_flows
                     on delete cascade,
   flow_session      number,
   created_on        date,
   created_by        varchar2(255)
   )
/

alter table wwv_flow_pages_reserved add constraint wwv_flow_pages_reserved_pk primary key (id, flow_id)
/

create index wwv_flow_pages_reserved_idx on wwv_flow_pages_reserved(created_on)
/

create index wwv_flow_pages_reserved_idx2 on wwv_flow_pages_reserved(flow_id)
/


--------------------------------------------------------------------
-- Alternate Configurations
--
prompt ...wwv_flow_alternate_config

create table wwv_flow_alternate_config (
   id                            number
                                 constraint wwv_flow_alt_cong_pk
                                 primary key,
   security_group_id             number not null,
   flow_id                       number
                                 constraint wwv_flow_alt_cfg_fk
                                 references wwv_flows
                                 on delete cascade,
   name                          varchar2(255) not null,
   last_updated_by               varchar2(255),
   last_updated_on               date,
   config_comments               varchar2(4000)
   )
/


create unique index wwv_biu_fl_alt_config_idx1 on wwv_flow_alternate_config (flow_id, name,security_group_id);

prompt ...wwv_flow_alt_config_detail

create table wwv_flow_alt_config_detail (
   id                             number
                                  constraint wwv_flow_alt_conf_det_pk
                                  primary key,
   security_group_id              number not null,
   config                         number
                                  constraint wwv_flow_alt_cfg_d_fk
                                  references wwv_flow_alternate_config
                                  on delete cascade,
   table_dot_column               varchar2(255) not null,
   id_column_value                number not null,
   new_value                      varchar2(4000) not null,
   last_updated_by                varchar2(255),
   last_updated_on                date,
   config_comment                 varchar2(4000)
   )
/


create unique index wwv_flow_alt_conf_det_idx1 on wwv_flow_alt_config_detail
(config, table_dot_column, id_column_value, security_group_id);


create table wwv_flow_alt_config_pick (
   id                number
                     constraint wwv_flow_alt_con_pic_pk
                     primary key,
   tab_dot_col       varchar2(255) not null,
   tab_dot_col_desc  varchar2(255) not null)
/

--------
-- Debug
--
create table wwv_flow_debug (
    id                       number,
    seq                      number,
    message                  varchar2(4000))
/

create index wwv_flow_debug_idx1 on wwv_flow_debug (id);

-----------
-- Comments
--
create table  wwv_flow_app_comments (
   id                         number constraint wwv_flow_app_comments_pk
                              primary key,
   flow_id                    number not null
                              constraint wwv_flow_app_comments_fk
                              references wwv_flows
                              on delete cascade,
   pages                      varchar2(4000),
   app_comment                varchar2(4000) not null,
   created_on                 date,
   created_by                 varchar2(255),
   updated_on                 date,
   updated_by                 varchar2(255),
   comment_owner              varchar2(255),
   comment_flag               varchar2(4000),
   app_version                varchar2(255),
   security_group_id          number not null)
/

create index wwv_flow_commments_idx1 on wwv_flow_app_comments (flow_id);

--------------------------------------------------------------------
-- Page Security Schemes
--


prompt ...create wwv_flow_security_schemes

create table wwv_flow_security_schemes (
   id                         number
                              constraint wwv_flow_sec_scheme_pk
                              primary key,
   security_group_id          number not null,
   flow_id                    number not null
                              constraint wwv_flow_sec_schemes_fk
                              references wwv_flows
                              on delete cascade,
   name                       varchar2(255) not null,
   scheme_type                varchar2(255),
   scheme                     varchar2(4000) not null,
   scheme_text                varchar2(4000),
   error_message              varchar2(4000) not null,
   caching                    varchar2(255)
                              constraint wwv_flow_sec_scheme_cache check (caching in (
                              'BY_USER_BY_PAGE_VIEW',
                              'BY_USER_BY_SESSION')),
   reference_id               number,
   last_updated_by            varchar2(255),
   last_updated_on            date,
   comments                   varchar2(4000)
   )
/


--------------------------------------------------------------------
-- TEMPLATE PREFERENCES
--


create table wwv_flow_template_preferences (
    owner                        varchar2(30)
                                 constraint wwv_flow_templ_pref_pk
                                 primary key,
    flow_id                      number
                                 not null
                                 constraint wwv_flow_templ_pref_fk
                                 references wwv_flows
                                 on delete cascade,
    template_preference          varchar2(120),
    printer_template_preference  varchar2(120),
    security_group_id            number         not null
    )
/


create unique index wwv_flow_template_pref_idx on
    wwv_flow_template_preferences (owner, flow_id, template_preference, printer_template_preference, security_group_id)
/





--------------------------------------------------------------------
-- FLOW BANNER
--


create table wwv_flow_banner (
    id                           number
                                 constraint wwv_flow_banner_fk
                                 references wwv_flows
                                 on delete cascade,
    banner                       clob,
    security_group_id            number not null)
    lob (banner) store as (cache reads enable storage in row)
/
create unique index wwv_flow_banner_u_idx on wwv_flow_banner(id)
/






-------------------------------
-- NLS and TRANSLATION Services
--

create table wwv_flow_languages (
    id                  number
                        constraint wwv_flow_languages_pk
                        primary key,
    lang_id             varchar2(255) not null,
    lang_id_upper       varchar2(255) not null,
    lang_name           varchar2(255) not null,
    nls_language        varchar2(255) not null,
    nls_territory       varchar2(255),
    nls_sort            varchar2(255),
    nls_windows_charset varchar2(255)
    )
/


create unique index wwv_flow_language_idx1 on wwv_flow_languages (lang_id)
/

create index wwv_flow_lang_comp_idx1 on wwv_flow_languages (lang_id_upper, nls_language, nls_territory)
/

create table wwv_flow_language_map (
     id                             number
                                    constraint wwv_flow_lang_map_pk
                                    primary key,
     primary_language_flow_id       number
                                    constraint   wwv_flow_lang_flow_id_fk
                                    references   wwv_flows on delete cascade,
     translation_flow_id            number       not null,
     translation_flow_language_code varchar2(30) not null,
     trans_flow_lang_code_root      varchar2(30),
     translation_image_directory    varchar2(255),
     translation_comments           varchar2(4000),
     security_group_id              number not null,
     last_updated_by                varchar2(255),
     last_updated_on                date,
     map_comments                   varchar2(4000)
     )
/

create unique index wwv_flow_language_map_idx1 on wwv_flow_language_map
    (primary_language_flow_id, translation_flow_language_code)
/
create unique index wwv_flow_language_map_idx2 on wwv_flow_language_map
    (translation_flow_id)
/

create table wwv_flow_translatable_cols$ (
    id                         number
                               constraint wwv_flow_trans_cols_pk
                               primary key,
    table_name                 varchar2(30),
    column_name                varchar2(30),
    table_pk                   varchar2(30),
    flow_id_column             varchar2(30),
    page_id_column             varchar2(30),
    datatype                   varchar2(30),
    template_translatable      varchar2(1)
                               constraint wwv_flow_trans_cols_chk
                               check (template_translatable in ('Y','N')),
    column_description         varchar2(4000)
    )
/


-- text_substr_1_255 column may be obsolete


create table wwv_flow_translatable_text$ (
    id                            number
                                  constraint wwv_flow_trans_text_pk
                                  primary key,
    translated_flow_id            number,
    flow_id                       number  not null
                                  constraint wwv_flow_trans_text_fk
                                  references wwv_flows
                                  on delete cascade,
    page_id                       number,
    translate_from_id             number,
    translate_to_id               number,
    translate_from_flow_table     varchar2(61),
    translate_from_flow_column    varchar2(30),
    translate_to_lang_code        varchar2(30),
    translation_specific_to_item  varchar2(3)
                                  constraint wwv_flow_trans_specific_check
                                  check (translation_specific_to_item in ('YES','NO')),
    translate_to_text             nclob,
    translate_from_text           nclob,
    template_translatable         varchar2(1)
                                  constraint wwv_flow_trans_temp_trans_chk
                                  check (template_translatable in ('Y','N')),
    security_group_id             number not null,
    last_updated_by               varchar2(255),
    last_updated_on               date,
    text_substr_1_255             nvarchar2(255)
    )
/


create unique index wwv_flow_translatable_text_pk on wwv_flow_translatable_text$ (
     flow_id, page_id, translate_from_id, translate_from_flow_table, translate_from_flow_column,
     translate_to_lang_code);


create index wwv_flow_translatable_substr  on wwv_flow_translatable_text$ (text_substr_1_255) ;
create index wwv_flow_translatable_key     on wwv_flow_translatable_text$ (flow_id, page_id, translate_from_id) ;
create index wwv_flow_translatable_from_id on wwv_flow_translatable_text$ (translate_from_id, translated_flow_id, translate_from_flow_table, translate_from_flow_column);
create index wwv_flow_translatable_key2    on wwv_flow_translatable_text$ (flow_id, translate_from_flow_table, translate_from_flow_column);


create table wwv_flow_dynamic_translations$ (
    id                         number
                               constraint wwv_flow_dyn_trans_pk
                               primary key,
    flow_id                    number,
    translate_to_lang_code     varchar2(30),
    translate_from_text        varchar2(4000),
    translate_to_text          varchar2(4000),
    security_group_id          number not null
                               constraint wwv_flow_dynamic_trans_fk
                               references wwv_flow_companies(provisioning_company_id)
                               on delete cascade)
/



------------------------------
-- P A G E   C A C H I N G
--

create table wwv_flow_page_cache (
   id                number
                     constraint wwv_flow_page_cache_pk
                     primary key,
   flow_id           number
                     constraint wwv_flow_page_cache_fk
                     references wwv_flows
                     on delete cascade,
   page_id           number not null, -- page
   security_group_id number not null, -- workspace
   language          varchar2(255),   -- all cached pages are by language
   user_name         varchar2(255),   -- if cached by user set this value
   context1          varchar2(255),   -- cache context leading edge
   context2          varchar2(4000),  -- overflow flow cache context
   page_text         clob,            -- HTML cache of page
   request           varchar2(4000),  -- requests must be the same, trigger maintained
   chart_region_id   number,          -- indicates a cached chart
   region_id         number,          -- support caching regions as well
   updated_on        date,            -- date of update
   updated_by        varchar2(255),   -- user performing update
   cached_on         date,            -- create date
   cached_by         varchar2(255),   -- user who did the caching, trigger maintained
   valid_util        date)
   lob (page_text) store as (cache enable storage in row)
/

create index wwv_flow_page_cache_fkidx on wwv_flow_page_cache (flow_id)
/

create index wwv_flow_page_cache_idx1 on wwv_flow_page_cache (flow_id, page_id, language, context1)
/

create index wwv_flow_page_cache_idx2 on wwv_flow_page_cache (region_id, flow_id, page_id)
/

create index wwv_flow_page_cache_idx3 on wwv_flow_page_cache (chart_region_id)
/


------------------------------
-- P A G E   T E M P L A T E S
--

create table wwv_flow_templates (
    id                            number
                                  constraint wwv_flow_templates_pk
                                  primary key,
    flow_id                       number not null
                                  constraint wwv_flow_templates_fk
                                  references wwv_flows
                                  on delete cascade,
    name                          varchar2(255),
    look                          number,
    header_template               clob,
    footer_template               clob,
    success_message               varchar2(4000),
    --
    current_tab                   varchar2(4000),
    current_tab_font_attr         varchar2(255),
    non_current_tab               varchar2(4000),
    non_current_tab_font_attr     varchar2(255),
    --
    current_image_tab             varchar2(4000),
    non_current_image_tab         varchar2(4000),
    --
    top_current_tab               varchar2(4000),
    top_current_tab_font_attr     varchar2(255),
    top_non_current_tab           varchar2(4000),
    top_non_current_tab_font_attr varchar2(255),
    --
    box                           clob,
    navigation_bar                varchar2(4000),
    navbar_entry                  varchar2(4000),
    body_title                    varchar2(4000),
    message                       varchar2(4000),
    attribute1                    varchar2(4000),
    attribute2                    varchar2(4000),
    attribute3                    varchar2(4000),
    attribute4                    varchar2(4000),
    attribute5                    varchar2(4000),
    attribute6                    varchar2(4000),
    default_button_position       varchar2(30),
    --
    table_bgcolor                 varchar2(255),
    heading_bgcolor               varchar2(255),
    table_cattributes             varchar2(255),
    font_size                     varchar2(255),
    font_face                     varchar2(255),
    --
    region_table_cattributes      varchar2(255),
    --
    app_tab_before_tabs           varchar2(4000), -- obsolete
    app_tab_current_tab           varchar2(4000), -- obsolete
    app_tab_non_current_tab       varchar2(4000), -- obsolete
    app_tab_after_tabs            varchar2(4000), -- obsolete
    --
    error_page_template           varchar2(4000),
    reference_id                  number,
    --
    breadcrumb_def_reg_pos        varchar2(255),
    sidebar_def_reg_pos           varchar2(255),
    --
    required_patch                number,
    security_group_id             number not null,
    --
    theme_id                      number,
    theme_class_id                number,
    --
    last_updated_by               varchar2(255),
    last_updated_on               date,
    translate_this_template       varchar2(1)
                                    constraint wwv_flow_trans_temp
                                    check (translate_this_template in ('Y','N')),
    template_comment              varchar2(4000)
)   lob (header_template, footer_template, box) store as (cache reads enable storage in row)
/

create index wwv_flow_template_idx1 on wwv_flow_templates (security_group_id, reference_id)
/
create unique index wwv_flow_template_idx2 on wwv_flow_templates (flow_id,name,theme_id)
/

--
-- obsolete table

create table wwv_flow_required_roles (
    id                number
                      constraint wwv_flow_req_roles_pk
                      primary key,
    flow_id           number not null
                      constraint wwv_flow_req_roles_fk
                      references wwv_flows
                      on delete cascade,
    --
    role_name         varchar2(30),
    security_group_id number
    )
/



--
-- F I E L D   T E M P L A T E S
--




create table wwv_flow_field_templates (
    id                            number
                                  constraint wwv_flow_field_template_pk
                                  primary key,
    flow_id                       number not null
                                  constraint wwv_flow_field_temp_f_fk
                                  references wwv_flows on delete cascade,
    security_group_id             number not null,
    --
    theme_id                      number,
    theme_class_id                number,
    --
    template_name                 varchar2(255) not null,
    template_body1                varchar2(4000),
    template_body2                varchar2(4000),
    reference_id                  number,
    on_error_before_label         varchar2(4000),
    on_error_after_label          varchar2(4000),
    last_updated_on               date,
    last_updated_by               varchar2(255),
    translate_this_template       varchar2(1)
                                    constraint wwv_flow_field_trans_temp
                                    check (translate_this_template in ('Y','N')),
    template_comment              varchar2(4000)
    )
/

create index wwv_flow_field_temp_idx1 on wwv_flow_field_templates (security_group_id, reference_id)
/
create unique index wwv_flow_field_temp_idx2 on wwv_flow_field_templates (flow_id,template_name, theme_id)
/

--
-- N A V I G A T I O N   B A R
--

create table wwv_flow_icon_bar_attributes (
    id                    number
                          constraint wwv_flow_iconbarattr_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_iconbarattr_fk
                          references wwv_flows
                          on delete cascade,
    icon_bar_text         varchar2(255),
    icon_bar_table_width  varchar2(30),
    security_group_id     number not null
    )
/

create index wwv_flow_icon_bar_attr_idx1 on wwv_flow_icon_bar_attributes (flow_id)
/

create table wwv_flow_icon_bar (
    id                number
                      constraint wwv_flow_icon_bar_pk
                      primary key,
    flow_id           number not null
                      constraint wwv_flow_icon_bar_fk
                      references wwv_flows
                      on delete cascade,
    icon_sequence     number not null,
    --
    icon_image        varchar2(255),
    icon_image2       varchar2(255),
    icon_image3       varchar2(255),
    icon_subtext      varchar2(255),
    icon_subtext2     varchar2(255),
    icon_subtext3     varchar2(255),
    icon_target       varchar2(4000),
    icon_image_alt    varchar2(4000),
    icon_height       number,
    icon_width        number,
    icon_height2      number,
    icon_width2       number,
    icon_height3      number,
    icon_width3       number,
    --
    icon_bar_disp_cond varchar2(4000),
    icon_bar_disp_cond_type varchar2(255),
    icon_bar_flow_cond_instr varchar2(4000),
    begins_on_new_line varchar2(30)
                      constraint valid_ficon_beginonnewline
                      check (begins_on_new_line in ('NO','YES')),
    cell_colspan      number,
    onclick           varchar2(4000),
    required_patch    number,
    security_scheme   varchar2(255),
    reference_id      number,
    security_group_id number not null,
    last_updated_by   varchar2(255),
    last_updated_on   date,
    icon_bar_comment  varchar2(4000)
    )
/



create index wwv_flow_icon_bar_idx2 on wwv_flow_icon_bar (flow_id, security_group_id)
/





--
-- F L O W    P R O C E S S I N G
--

create table wwv_flow_processing (
    id                number
                      constraint wwv_flow_processing_pk
                      primary key,
    flow_id           number not null
                      constraint wwv_flow_processing_fk
                      references wwv_flows
                      on delete cascade,
    --
    process_sequence  number,
    process_point     varchar2(255)
                      constraint valid_fproc_procpoint
                      check (process_point in (
                      'ON_DEMAND',
                      'ON_SUBMIT_BEFORE_COMPUTATION',
                      'AFTER_AUTHENTICATION',
                      'BEFORE_HEADER',
                      'AFTER_HEADER',
                      'AFTER_ERROR_HEADER',
                      'BEFORE_ERROR_FOOTER',
                      'BEFORE_BOX_BODY',
                      'BEFORE_SHOW_ITEMS',
                      'AFTER_SHOW_ITEMS',
                      'AFTER_BOX_BODY',
                      'BEFORE_FOOTER',
                      'AFTER_FOOTER',
                      'AFTER_SUBMIT_BEFORE_VALIDATION',
                      'AFTER_SUBMIT')),
    --
    process_type           varchar2(255)
                           constraint wwv_valid_proc_type
                           check (process_type in (
                           'SET_ITEM_USING_STATIC_ASSIGNMENT',
                           'SET_ITEM_USING_PLSQL_FUNCTION_BODY',
                           'SET_ITEM_USING_PLSQL_EXPRESSION',
                           'SET_ITEM_USING_SQL_EXPRESSION',
                           'SET_ITEM_USING_SQL_QUERY',
                           'PLSQL',
                           'INITIALIZE_ALL_PAGE_ITEMS'
                           )),
    --
    process_name           varchar2(255)  not null,
    process_sql_clob       clob,
    process_error_message  varchar2(4000),
    process_when           varchar2(4000),
    process_when_type      varchar2(255),
    process_when2          varchar2(4000),
    process_when_type2     varchar2(255),
    item_name              varchar2(255),
    required_patch         number,
    security_scheme        varchar2(255),
    runtime_where_clause   varchar2(4000),
    --
    security_group_id      number not null,
    last_updated_by        varchar2(255),
    last_updated_on        date,
    process_comment        varchar2(4000)
    )    lob (process_sql_clob) store as (cache reads enable storage in row)
/









--
-- F L O W    I T E M S
--

create table wwv_flow_items (
    id                         number
                               constraint wwv_flow_items_pk
                               primary key,
    flow_id                    number not null
                               constraint wwv_flow_items_fk
                               references wwv_flows
                               on delete cascade,
    name                       varchar2(255) not null,
    name_length                number,
    data_type                  varchar2(30)
                               constraint valid_fitems_datatype
                               check (data_type in (
                               'VARCHAR',
                               'NUMBER',
                               'DATE')),
    is_Persistent              varchar2(1)
                               constraint valid_fitems_ispers
                               check (is_Persistent in ('Y','N','U','A')),
    protection_level           varchar2(1)
                               constraint valid_fitems_protection_level
                               check (protection_level in ('N','B','P','S','I')),
    required_patch             number,
    security_group_id          number not null,
    last_updated_by            varchar2(255),
    last_updated_on            date,
    item_comment               varchar2(4000)
    )
/

create index wwv_flow_items_u_name on wwv_flow_items (flow_id,name);
create unique index wwv_flow_items_idx2 on wwv_flow_items (id,is_persistent);
create unique index wwv_flow_items_idx3 on wwv_flow_items (flow_id,security_group_id,name);






--
--  F L O W    C O M P U T A T I O N S
--

create table wwv_flow_computations (
    id                    number
                          constraint wwv_flow_computations_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_computations_fk
                          references wwv_flows
                          on delete cascade,
    --
    computation_sequence  number,
    computation_item      varchar2(255) not null,
    computation_point     varchar2(255)
                          constraint valid_fcomp_point
                          check (computation_point in (
                          'ON_NEW_INSTANCE',
                          'BEFORE_HEADER',
                          'AFTER_ERROR_HEADER',
                          'BEFORE_ERROR_FOOTER',
                          'AFTER_HEADER',
                          'BEFORE_BOX_BODY',
                          'AFTER_BOX_BODY',
                          'BEFORE_FOOTER',
                          'AFTER_FOOTER',
                          'AFTER_SUBMIT')),
    -- computation_item_type to be obsoleted (SSpadafore)
    computation_item_type varchar2(30)
                          constraint valid_fcomp_itemtype
                          check (computation_item_type in (
                          'VARCHAR',
                          'VC_ARR',
                          'NUMBER')),
    computation_type      varchar2(30)
                          constraint valid_fcomp_comptype
                          check (computation_type in (
                          'SET_ITEM_EQUAL_THIS_PREFERENCE',
                          'STATIC_ASSIGNMENT',
                          'FUNCTION_BODY',
                          'QUERY',
                          'PLSQL_EXPRESSION',
                          'SQL_EXPRESSION',
                          'SQL_EXPRESION',
                          'ITEM_VALUE')),
    computation_processed varchar2(30)
                          constraint valid_fcomp_compproc
                          check (computation_processed in (
                          'ON_NEW_INSTANCE',
                          'REPLACE_EXISTING',
                          'ADD_TO_EXISTING',
                          'RAISE_ERROR_ON_REPLACE',
                          'REPLACE_NULL_VALUES')),
    computation                varchar2(4000),
    required_patch             number,
    compute_when               varchar2(4000),
    compute_when_type          varchar2(255),
    compute_when_text          varchar2(4000),
    computation_error_message  varchar2(4000),
    security_scheme            varchar2(255),
    security_group_id          number not null,
    last_updated_by            varchar2(255),
    last_updated_on            date,
    computation_comment        varchar2(4000)
    )
/


--------------------------------------------------------------------
-- S T A N D A R D   T A B S
--

create table wwv_flow_tabs (
    id                         number
                               constraint wwv_flow_tabs_pk
                               primary key,
    flow_id                    number not null
                               constraint wwv_flow_tabs_fk
                               references wwv_flows
                               on delete cascade,
    tab_set                    varchar2(255)  not null,
    tab_sequence               number         not null,
    tab_name                   varchar2(255)  not null,
    tab_image                  varchar2(255),
    tab_non_current_image      varchar2(255),
    tab_image_attributes       varchar2(255),
    tab_text                   varchar2(2000) not null,
    tab_step                   number not null,
    tab_also_current_for_pages varchar2(4000),
    tab_parent_tabset          varchar2(255),
    tab_plsql_condition        varchar2(4000),
    display_condition_type     varchar2(255),
    tab_disp_cond_text         varchar2(4000),
    required_patch             number,
    security_scheme            varchar2(255),
    security_group_id          number not null,
    last_updated_by            varchar2(255),
    last_updated_on            date,
    tab_comment                varchar2(4000)
    )
/

create unique index wwv_flow_tabs_unique on wwv_flow_tabs (flow_id, tab_set, tab_name)
/

create unique index wwv_flow_tabs_unique2 on wwv_flow_tabs (flow_id, security_group_id, tab_set, tab_name)
/






------------------------
-- P A R E N T   T A B S
--

create table wwv_flow_toplevel_tabs (
    id                         number
                               constraint wwv_flow_toplev_tab_pk
                               primary key,
    flow_id                    number not null
                               constraint wwv_flow_toplev_tab_fk
                               references wwv_flows
                               on delete cascade,
    tab_set                    varchar2(255)  not null,
    tab_sequence               number         not null,
    tab_name                   varchar2(255)  not null,
    tab_image                  varchar2(255),
    tab_non_current_image      varchar2(255),
    tab_image_attributes       varchar2(255),
    tab_text                   varchar2(2000) not null,
    tab_target                 varchar2(4000) not null,
    display_condition          varchar2(4000),
    display_condition2         varchar2(4000),
    display_condition_type     varchar2(255),
    current_on_tabset          varchar2(255),
    required_patch             number,
    security_scheme            varchar2(255),
    security_group_id          number not null,
    last_updated_by            varchar2(255),
    last_updated_on            date,
    tab_comment                varchar2(4000)
    )
/

create unique index wwv_flow_tl_tabs_unique on wwv_flow_toplevel_tabs (flow_id, tab_set, tab_name)
/
create unique index wwv_flow_tl_tabs_unique2 on wwv_flow_toplevel_tabs (flow_id, security_group_id, tab_set, tab_name)
/




------------------------
--  F L O W   T R E E S
--

create table wwv_flow_trees  (
    id                        number
                              constraint wwv_flow_tree_pk
                              primary key,
    flow_id                   number not null
                              constraint wwv_flow_tree_fk
                              references wwv_flows
                              on delete cascade,
    tree_name                 varchar2(255)  not null,
    tree_type                 varchar2(30)
                              constraint wwv_flow_tree_type
                              check (tree_type in ('DYNAMIC','STATIC')),
    tree_query                varchar2(4000),
    flow_item                 varchar2(255),
    security_group_id         number not null,
    max_levels                number not null
                              constraint wwv_flow_valid_level
                              check (max_levels between 1 and 100),
    unexpanded_parent         varchar2(4000),
    unexpanded_parent_last    varchar2(4000),
    expanded_parent           varchar2(4000),
    expanded_parent_last      varchar2(4000),
    leaf_node                 varchar2(4000),
    leaf_node_last            varchar2(4000),
    drill_up                  varchar2(4000),
    name_link_anchor_tag      varchar2(4000),
    name_link_not_anchor_tag  varchar2(4000),
    indent_vertical_line      varchar2(4000),
    indent_vertical_line_last varchar2(4000),
    --
    before_tree               varchar2(4000),
    after_tree                varchar2(4000),
    --
    level_1_template          varchar2(4000),
    level_2_template          varchar2(4000),
    level_3_template          varchar2(4000),
    level_4_template          varchar2(4000),
    level_5_template          varchar2(4000),
    level_6_template          varchar2(4000),
    level_7_template          varchar2(4000),
    level_8_template          varchar2(4000),
    last_updated_by           varchar2(255),
    last_updated_on           date,
    tree_comment              varchar2(4000)
    )
/




---------------------------------------
-- L I S T S   O F   V A L U E S  (LOV)
--


create global temporary table wwv_flow_lov_temp (
  insert_order number,
  disp         varchar2(4000),
  val          varchar2(4000)
)
/



create table wwv_flow_lists_of_values$ (
    id                        number
                              constraint wwv_flow_lov_pk
                              primary key,
    flow_id                   number not null
                              constraint wwv_flow_lov_fk
                              references wwv_flows
                              on delete cascade,
    lov_name                  varchar2(255)  not null,
    lov_query                 varchar2(4000) not null,
    security_group_id         number         not null,
    reference_id              number,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    lov_comment               varchar2(4000)
    )
/

create index wwv_flow_lov_unique on wwv_flow_lists_of_values$ (flow_id, lov_name)
/
create unique index wwv_flow_lov_unique2 on wwv_flow_lists_of_values$ (flow_id, security_group_id, lov_name)
/




create table wwv_flow_list_of_values_data (
    id                        number
                              constraint wwv_flow_lov_data_pk
                              primary key,
    lov_id                    number
                              constraint wwv_flow_lov_data_fk
                              references wwv_flow_lists_of_values$
                              on delete cascade,
    flow_id                   number,
    lov_disp_sequence         number not null,
    lov_disp_value            varchar2(4000) not null,
    lov_return_value          varchar2(4000) not null,
    lov_template              varchar2(4000),
    lov_disp_cond_type        varchar2(255),
    lov_disp_cond             varchar2(4000),
    lov_disp_cond2            varchar2(4000),
    required_patch            number,
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    lov_data_comment          varchar2(4000)
    )
/


create unique index wwv_flow_lov_data_idx1 on wwv_flow_list_of_values_data (
    lov_id, security_group_id, lov_disp_sequence, id)
/

create index wwv_flow_lov_data_idx2 on wwv_flow_list_of_values_data(
    flow_id, id)
/

create or replace view wwv_flow_list_of_values_data_v
as
select id, lov_id, lov_disp_sequence, lov_disp_value, lov_return_value, lov_template, required_patch
  from wwv_flow_list_of_values_data w,
       (select wwv_flow_security.get_translated_flow_id flow_id from dual) f
  where w.flow_id = f.flow_id
/


create or replace view wwv_flow_lists_of_values$_v
as
select id from wwv_flow_lists_of_values$ w,
  (select wwv_flow_security.get_flow_id flow_id from dual) f
  where   w.flow_id = f.flow_id
/


------------------------------------
-- F L O W   P A G E S   (steps)
--


create table wwv_flow_steps (
    id                  number,
    flow_id             number not null
                        constraint wwv_flow_steps_fk
                        references wwv_flows on delete cascade,
    tab_set             varchar2(255),
    name                varchar2(255) not null,
    alias               varchar2(255),
    page_component_map  varchar2(255),
    --
    step_title          varchar2(255),
    step_sub_title      varchar2(255),
    step_sub_title_type varchar2(30)
                        constraint valid_fsteps_subtitletype
                        check (step_sub_title_type in (
                        'NO_DISPLAY_FOR_CUSTOM_LOOK1',
                        'NO_DISPLAY_FOR_CUSTOM_LOOK2',
                        'NO_DISPLAY_FOR_CUSTOM_LOOK3',
                        'DISPLAY_FOR_CUSTOM_LOOK1_ONLY',
                        'DISPLAY_FOR_CUSTOM_LOOK2_ONLY',
                        'DISPLAY_FOR_CUSTOM_LOOK3_ONLY',
                        'TEXT_WITH_SUBSTITUTIONS',
                        'SQL_EXPRESSION',
                        'SQL_EXPRESION')),
    first_item                varchar2(255),
    include_apex_css_js_yn    varchar2(1),
    welcome_text              varchar2(4000),
    box_welcome_text          varchar2(4000),
    box_footer_text           varchar2(4000),
    footer_text               varchar2(4000),
    help_text                 clob,
    step_template             number,
    box_image                 varchar2(255),  -- obsolete
    required_role             varchar2(255),  -- obsolete
    required_patch            number,
    html_page_header          clob,
    html_page_onload          varchar2(4000),
    allow_duplicate_submissions varchar2(1)
                              constraint valid_all_dup_page_sub
                              check (allow_duplicate_submissions in (
                              'Y',
                              'N')),
    on_dup_submission_goto_url  varchar2(4000),
    page_is_public_y_n        varchar2(1)
                              constraint wwv_flow_pages_pgpub_flag
                              check (page_is_public_y_n in ('Y','N')),
    protection_level          varchar2(1)
                              constraint valid_fsteps_protection_level
                              check (protection_level in ('N','C','U','D')),
    security_group_id         number not null,
    error_notification_text   varchar2(4000),
    autocomplete_on_off       varchar2(3),
    id2                       number,
    --
    cache_page_yn             varchar2(1),
    cache_timeout_seconds     number,
    cache_by_user_yn          varchar2(1),
    cache_when_condition_type varchar2(255),
    cache_when_condition_e1   varchar2(4000),
    cache_when_condition_e2   varchar2(4000),
    --
    created_on                date,
    created_by                varchar2(255),
    --
    last_updated_by           varchar2(255),
    last_updated_on           date,
    group_id                  number,
    media_type                varchar2(255),
    page_comment              varchar2(4000),
    constraint wwv_flow_steps_pk primary key (flow_id, id)
    )    lob (html_page_header) store as (cache reads enable storage in row)
/

prompt ...create indexes on wwv_flow_steps table
create index wwv_flow_page_id_idx1         on wwv_flow_steps (id)
/
create unique index wwv_flow_page_id_idx2  on wwv_flow_steps (id, flow_id, security_group_id)
/
create index wwv_flow_page_alias_idx1  on wwv_flow_steps (flow_id, alias)
/


----------------
-- B U T T O N S
--

create table wwv_flow_step_buttons (
    id                        number
                              constraint wwv_flow_step_buttons_pk
                              primary key,
    flow_id                   number  not null
                              constraint wwv_flow_step_buttons_fk1
                              references wwv_flows
                              on delete cascade,
    flow_step_id              number ,
    button_sequence           number,
    button_plug_id            number,
    button_name               varchar2(2000),
    button_image              varchar2(2000),
    button_image_alt          varchar2(2000),
    button_position           varchar2(30)
                              constraint valid_fstepb_position
                              check (button_position in (
                              'LEFT_OF_TITLE',
                              'RIGHT_OF_TITLE',
                              'ABOVE_BOX',
                              'TOP',
                              'BOTTOM',
                              'TOP_AND_BOTTOM',
                              'TEMPLATE_DEFAULT',
                              'BELOW_BOX',
                              'REGION_TEMPLATE_CREATE',
                              'REGION_TEMPLATE_CREATE2',
                              'REGION_TEMPLATE_CLOSE',
                              'REGION_TEMPLATE_EXPAND',
                              'REGION_TEMPLATE_EDIT',
                              'REGION_TEMPLATE_NEXT',
                              'REGION_TEMPLATE_PREVIOUS',
                              'REGION_TEMPLATE_CHANGE',
                              'REGION_TEMPLATE_DELETE',
                              'REGION_TEMPLATE_COPY',
                              'REGION_TEMPLATE_HELP',
                              'RIGHT_OF_IR_SEARCH_BAR'
                              ) and button_position is not null),
    button_alignment          varchar2(30)
                              constraint wwv_flow_valid_fbutton_align
                              check (button_alignment in ('LEFT','MIDDLE','RIGHT')),
    button_redirect_url       varchar2(4000),
    button_condition          varchar2(4000),
    button_condition2         varchar2(4000),
    button_condition_type     varchar2(255),
    button_image_attributes   varchar2(500),
    button_cattributes        varchar2(2000),
    database_action           varchar2(30),
    required_patch            number,
    security_scheme           varchar2(255),
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    button_comment            varchar2(4000),
    constraint wwv_flow_step_buttons_fk2
    foreign key (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
/



create index wwv_flow_step_buttons_idx1 on wwv_flow_step_buttons (flow_step_id, flow_id);

create unique index wwv_flow_step_buttons_idx2 on wwv_flow_step_buttons (flow_step_id, flow_id, security_group_id, id);



------------------
-- B R A N C H E S
--

create table wwv_flow_step_branches (
    id                number
                      constraint wwv_flow_step_branches_pk
                      primary key,
    flow_id           number  not null
                      constraint wwv_flow_step_branches_fk
                      references wwv_flows on delete cascade,
    flow_step_id      number,
    branch_action     varchar2(4000),
    branch_point      varchar2(30)
                      constraint valid_fsbranch_point
                      check (branch_point in (
                      'BEFORE_HEADER',
                      'BEFORE_COMPUTATION',
                      'BEFORE_VALIDATION',
                      'BEFORE_PROCESSING',
                      'AFTER_PROCESSING')),
    branch_when_button_id number,
    branch_type       varchar2(255) not null
                      constraint valid_fsbranch_branchtype
                      check (branch_type in (
                      'BRANCH_TO_FUNCTION_RETURNING_PAGE',
                      'BRANCH_TO_FUNCTION_RETURNING_URL',
                      'BRANCH_TO_PAGE_IDENT_BY_ITEM',
                      'BRANCH_TO_URL_IDENT_BY_ITEM',
                      'BRANCH_TO_STEP',
                      'BRANCH_TO_PAGE_ACCEPT',
                      'PLSQL',
                      'REDIRECT_URL',
                      'BRANCH_TO_ENTRY_POINT',
                      'BRANCH_TO_ENTRY_POINT_IDENT_BY_ITEM')),
    branch_sequence           number,
    clear_page_cache          varchar2(4000),
    save_state_before_branch_yn varchar2(1) 
                              constraint wwv_flow_step_branches_svstate 
                              check (save_state_before_branch_yn in ('Y','N')),
    branch_condition_type     varchar2(255),
    branch_condition          varchar2(4000),
    branch_condition_text     varchar2(4000),
    required_patch            number,
    security_scheme           varchar2(255),
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    branch_comment            varchar2(4000),
    constraint wwv_flow_step_branches_fk2
    foreign key (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
/



create index wwv_flow_step_branches_idx1 on wwv_flow_step_branches (flow_step_id, flow_id);
create unique index wwv_flow_step_branches_idx2 on wwv_flow_step_branches (flow_step_id, flow_id, security_group_id, id);


------------------------
-- B R A N C H   A R G S
--

create table wwv_flow_step_branch_args(
    id                                                 number
        constraint wwv_flow_step_branch_args_pk
        primary key,
    flow_step_branch_id                                number
        constraint wwv_flow_step_branch_args_fk
        references wwv_flow_step_branches on delete cascade,
    branch_arg_sequence                                number not null,
    branch_arg_source_type                             varchar2(30)
         constraint valid_fstepbrancharg_srctype
         check (branch_arg_source_type in (
         'VALUE_OF_ITEM',
         'STATIC_ASSIGNMENT',
         'FUNCTION_BODY',
         'QUERY',
         'PLSQL_EXPRESSION',
         'SQL_EXPRESSION')),
    branch_arg_source                                  clob,
    security_group_id                                  number not null,
    last_updated_by                                    varchar2(255),
    last_updated_on                                    date,
    branch_arg_comment                                 varchar2(4000)
    ) lob (branch_arg_source) store as (cache reads enable storage in row)
/



create index wwv_flow_step_branch_args_idx2 on wwv_flow_step_branch_args(flow_step_branch_id)
/





----------------------
-- P A G E   I T E M S
--

create table wwv_flow_step_items (
    id                		number
                      		constraint wwv_flow_step_items_pk
                      		primary key,
    flow_id           		number  not null
                      		constraint wwv_flow_step_items_fk
                      		references wwv_flows on
                      		delete cascade,
    flow_step_id      		number,
    name              		varchar2(255) not null,
    name_length       		number,
    data_type         		varchar2(30)
                      		constraint valid_fsitem_datatype
                      		check (data_type in (
                      		'VARCHAR',
                      		'NUMBER',
                      		'DATE')),
    accept_processing 		varchar2(30)
                      		constraint wwv_valid_fsitem_accpproc
                      		check (accept_processing in (
                      		'REPLACE_EXISTING',
                      		'REPLACE_NULL_VALUES',
                      		'RAISE_ERROR_ON_REPLACE',
                      		'ADD_TO_EXISTING')),
    item_sequence     		number,
    item_plug_id      		number,
    use_cache_before_default 	varchar2(30)
                      		constraint wwv_valid_fsitem_usecache
                      		check (use_cache_before_default in (
                      		'YES',
                      		'NO')),
    item_default      		varchar2(4000),
    item_default_type 		varchar2(255)
                      		constraint wwv_valid_fsitem_idt
                      		check (item_default_type in (
                      		'STATIC_TEXT_WITH_SUBSTITUTIONS',
                      		'PLSQL_FUNCTION_BODY',
                      		'PLSQL_EXPRESSION',
                      		'SQL_QUERY')),
    prompt            		varchar2(4000),
    pre_element_text      varchar2(4000),
    post_element_text 		varchar2(4000),
    format_mask                 varchar2(255),
    item_field_template 	number,
    source            		varchar2(4000),
    source_type       		varchar2(30)
                      		constraint wwv_valid_fsitem_sourcetype
                      		check (source_type in (
                      		'PREFERENCE',
                      		'ALWAYS_NULL',
                      		'STATIC',
                      		'QUERY',
                      		'ITEM',
                      		'FUNCTION',
                      		'FUNCTION_BODY',
                      		'DB_COLUMN',
                      		'PLSQL_ANONYMOUS_BLOCK')),
    source_post_computation 	varchar2(4000),
    display_as       		varchar2(50)
                     		constraint wwv_valid_fsitem_displayas
                     		check (display_as in (
                                'DISPLAY_ONLY_PLSQL',
                                'FILE',
                                'BUTTON',
                                'HIDDEN',
                                'HIDDEN_PROTECTED',
                                'DISPLAY_ONLY_HTML',
                                'STOP_AND_START_HTML_TABLE',
                                'DISPLAY_ONLY_ESCAPE_SC',
                                'IMAGE',
                                'DISPLAY_AND_SAVE',
                                'DISPLAY_AND_SAVE_LOV',
                                'CHECKBOX',
                                'POPUP',
                                'POPUP_FILTER',
                                'POPUP2',
                                'POPUP3',
                                'POPUP4',
                                'POPUP5',
                                'POPUP6',
                                'POPUP_KEY_LOV',
                                'POPUP_KEY_LOV_NOFETCH',
                                'POPUP_COLOR',
                                'PICK_DATE_USING_FLOW_FORMAT_MASK',
                                'PICK_DATE_USING_APP_FORMAT_MASK',
                                'PICK_DATE_USING_APP_DATE_FORMAT',
                                'PICK_DATE_USING_FORMAT_MASK',
                                'PICK_DATE_DD_MON_RR',
                                'PICK_DATE_DD_MON_RR_HH_MI',
                                'PICK_DATE_DD_MON_RR_HH24_MI',
                                'PICK_DATE_DD_MON_YYYY',
                                'PICK_DATE_DD_MON_YYYY_HH_MI',
                                'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY',
                                'PICK_DATE_DD_MM_YYYY_HH_MI',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                'PICK_DATE_MM_DD_YYYY',
                                'PICK_DATE_MM_DD_YYYY_HH_MI',
                                'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                'PICK_DATE_DD_MON_YY',
                                'PICK_DATE_DD_MON_YY_HH_MI',
                                'PICK_DATE_DD_MON_YY_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD',
                                'PICK_DATE_YYYY_MM_DD_HH_MI',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                'PICK_DATE_RR_MON_DD',
                                'PICK_DATE_RR_MON_DD_HH_MI',
                                'PICK_DATE_RR_MON_DD_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                'PICK_DATE_YYYY_MM_DD_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                'DISPLAY_ONLY_LOV',
                                'COMBOBOX',
                                'SHOW_AS_SL_WITH_POPUP',
                                'COMBOBOX_WITH_URL_REDIRECT',
                                'COMBOBOX_WITH_BRANCH_TO_PAGE',
                                'COMBOBOX_WITH_SUBMIT',
                                'COMBOBOX_WITH_JS_POST',
                                'COMBOBOX_WITH_JS_REDIRECT',
                                'MULTIPLESELECT',
                                'SHUTTLE',
                                'RADIOGROUP',
                                'RADIOGROUP2',
                                'RADIOGROUP_WITH_REDIRECT',
                                'RADIOGROUP_WITH_SUBMIT',
                                'RADIOGROUP_WITH_JS_SUBMIT',
                                'TEXTAREA',
                                'TEXTAREA_WITH_SPELL_CHECK',
                                'TEXTAREA-AUTO-HEIGHT',
                                'TEXTAREA_WITH_CONTROLS',
                                'TEXTAREA_WITH_HTML_EDITOR_BASIC',
                                'TEXTAREA_WITH_HTML_EDITOR_STANDARD',
                                'TEXTAREA_CHAR_COUNT',
                                'TEXTAREA_CHAR_COUNT_SPELL',
                                'TEXT',
                                'TEXT_WITH_ENTER_SUBMIT',
                                'TEXT_DISABLED',
                                'TEXT_DISABLED_AND_SAVE',
                                'TEXT_WITH_CALCULATOR',
                                'PASSWORD',
                                'PASSWORD_WITH_ENTER_SUBMIT',
                                'PASSWORD_DNSS',
                                'PASSWORD_WITH_SUBMIT_DNSS',
                                'LIST_MGR',
                                'LIST_MGR2',
                                'LIST_MGR3',
                                'LIST_MGR_VIEW',
                                'LIST_MGR_VIEW2'
                                )),
    read_only_when              varchar2(4000),
    read_only_when2             varchar2(4000),
    read_only_when_type         varchar2(255),
    read_only_disp_attr         varchar2(4000),
    named_lov         		varchar2(255),
    lov               		varchar2(4000),
    lov_columns       		number,
    lov_display_extra 		varchar2(30)
                      		constraint valid_fsitem_lovextra
                      		check (lov_display_extra in (
                      		'YES',
                      		'NO')),
    lov_display_null  		varchar2(30)
                      		constraint valid_fsitem_lovdispnull
                      		check (lov_display_null in (
                      		'YES',
                      		'NO')),
    lov_null_text     		varchar2(255),
    lov_null_value    		varchar2(255),
    lov_translated    		varchar2(1)
                      		constraint wwv_valid_lov_trans
                      		check (lov_translated in ('Y','N',null)),
    cSize             		number,
    cMaxlength        		number,
    cHeight           		number,
    cAttributes       		varchar2(2000),
    cattributes_element         varchar2(4000),
    tag_attributes    		varchar2(2000),
    tag_attributes2   		varchar2(4000),
    --
    button_image      		varchar2(255),
    button_image_attr 		varchar2(255),
    --
    begin_on_new_line 		varchar2(30)
                      		constraint valid_fsitem_beginonnewline
                      		check (begin_on_new_line in (
                      		'YES',
                      		'NO')),
    begin_on_new_field		 varchar2(30)
                      		constraint valid_fsitem_beginonnewfield
                      		check (begin_on_new_field in (
                      		'YES',
                      		'NO')),
    colspan           		number,
    rowspan           		number,
    label_alignment   		varchar2(30)
                      		constraint valid_fsitem_labelalign
                      		check (label_alignment in (
                      		'LEFT',
                      		'RIGHT',
                      		'CENTER',
                      		'ABOVE',
                      		'BELOW',
                      		'LEFT-TOP',
                      		'RIGHT-TOP',
                      		'CENTER-TOP',
                      		'LEFT-BOTTOM',
                      		'RIGHT-BOTTOM',
                      		'CENTER-BOTTOM',
                      		'LEFT-CENTER',
                      		'RIGHT-CENTER',
                      		'CENTER-CENTER'
                      		)),
    field_alignment   		varchar2(30)
                      		constraint valid_fsitem_fieldalign
                      		check (field_alignment in (
                      		'LEFT',
                      		'RIGHT',
                      		'CENTER',
                      		'LEFT-TOP',
                      		'RIGHT-TOP',
                      		'CENTER-TOP',
                      		'LEFT-BOTTOM',
                      		'RIGHT-BOTTOM',
                      		'CENTER-BOTTOM',
                      		'LEFT-CENTER',
                      		'RIGHT-CENTER',
                      		'CENTER-CENTER'
                      		)),
    field_template            number,
    label_cell_attr           varchar2(4000),
    field_cell_attr           varchar2(4000),
    display_when              varchar2(4000),
    display_when2             varchar2(4000),
    display_when_type         varchar2(255),
    is_Persistent             varchar2(1)
                              constraint valid_fsitem_ispersistent
                              check (is_Persistent in ('Y','N','U')),
    protection_level          varchar2(1)
                              constraint valid_fsitem_protection_level
                              check (protection_level in ('N','B','P','S','I')),
    escape_on_http_input      varchar2(1),
                              constraint valfsitem_escape_on_http_input
                              check (escape_on_http_input in ('Y','N')),
    security_scheme           varchar2(255),
    required_patch            number,
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    --
    encrypt_session_state_yn  varchar2(1),
    --
    item_comment              varchar2(4000),
    constraint                wwv_flow_step_items_fk2
    foreign key               (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
/

create index wwv_flow_step_item_idx1 on wwv_flow_step_items (flow_step_id, flow_id);
create index wwv_flow_step_item_idx2 on wwv_flow_step_items (flow_id, name_length);
create index wwv_flow_step_item_idx3 on wwv_flow_step_items (flow_id, flow_step_id, item_sequence);
create unique index wwv_flow_step_items_u_name on wwv_flow_step_items (flow_id, name, security_group_id);





create table wwv_flow_step_item_help (
    id                        number
                              constraint wwv_flow_page_helptext_pk
                              primary key,
    flow_id                   number  not null
                              constraint wwv_flow_page_helptext_fk
                              references wwv_flows
                              on delete cascade,
    flow_item_id              number
                              constraint wwv_flow_item_helptext_fk
                              references wwv_flow_step_items
                              on delete cascade,
    help_text                 varchar2(4000),
    reference_id              number,
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    item_help_text_comment    varchar2(4000)
    )
/


create unique index wwv_flow_step_item_help_idx on wwv_flow_step_item_help (flow_id, flow_item_id, security_group_id);


------------------------------------
-- P A G E   C O M P U T A T I O N S
--


create table wwv_flow_step_computations (
    id                    number
                          constraint wwv_flow_step_comp_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_step_comp_fk
                          references wwv_flows
                          on delete cascade,
    flow_step_id          number ,
    --
    computation_sequence  number,
    computation_item      varchar2(255) not null,
    computation_point     varchar2(255)
                          constraint valid_fstepcomp_point
                          check (computation_point in (
                          'ON_NEW_INSTANCE',
                          'BEFORE_HEADER',
                          'AFTER_HEADER',
                          'BEFORE_BOX_BODY',
                          'AFTER_BOX_BODY',
                          'BEFORE_FOOTER',
                          'AFTER_FOOTER',
                          'AFTER_SUBMIT')),
    -- computation_item_type to be obsoleted (SSpadafore)
    computation_item_type varchar2(30)
                          constraint valid_fstepcomp_itemtype
                          check (computation_item_type in (
                          'VARCHAR',
                          'VC_ARR',
                          'NUMBER')),
    computation_type      varchar2(30)
                          constraint valid_fstepcomp_comptype
                          check (computation_type in (
                          'STATIC_ASSIGNMENT',
                          'FUNCTION_BODY',
                          'QUERY',
                          'PLSQL_EXPRESSION',
                          'SQL_EXPRESSION',
                          'SQL_EXPRESION',
                          'ITEM_VALUE')),
    computation_processed varchar2(30)
                          constraint valid_fstepcomp_compproc
                          check (computation_processed in (
                          'ON_NEW_INSTANCE',
                          'REPLACE_EXISTING',
                          'ADD_TO_EXISTING',
                          'RAISE_ERROR_ON_REPLACE',
                          'REPLACE_NULL_VALUES')),
    computation               varchar2(4000),
    compute_when              varchar2(4000),
    compute_when_type         varchar2(255),
    compute_when_text         varchar2(4000),
    computation_error_message varchar2(4000),
    required_patch            number,
    security_scheme           varchar2(255),
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    computation_comment       varchar2(4000),
    constraint                wwv_flow_step_comp_fk2
    foreign key               (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
/



create index wwv_flow_step_comp_idx1 on wwv_flow_step_computations (flow_step_id, flow_id);
create unique index wwv_flow_step_comp_idx2 on wwv_flow_step_computations (flow_step_id, flow_id, security_group_id, id);





-----------------------------------
-- P A G E    V A L I D A T I O N S
--
--
-- Validation Types:
--
-- SQL_EXPRESION    &FIELD1 = &FIELD2
--                  &FIELD1 in ('A','B','C')
--                  success if "select 1 from dual where SQL_EXPRESION" returns a row
-- PLSQL_EXPRESION  1 = my_func(&FIELD1)
--                  since some operations may use impure calls
-- PLSQL_ERROR      declare x number; begin x := &FIELD1; end;
--                  success if plsql does not raise an error
-- EXISTS           select 1 from dual where &FIELD > 1
--                  success if query returns at least one value
--


create table wwv_flow_step_validations (
    id                        number
                              constraint wwv_flow_step_val_pk
                              primary key,
    flow_id                   number not null
                              constraint wwv_flow_step_val_fk
                              references wwv_flows
                              on delete cascade,
    flow_step_id              number ,
    validation_name           varchar2(255) not null,
    validation_sequence       number,
    validation                varchar2(4000),
    validation2               varchar2(4000),
    validation_type           varchar2(255),
                              constraint wwv_valid_fsval_valtype
                              check (validation_type in (
                              'ITEM_NOT_NULL',
                              'ITEM_NOT_NULL_OR_ZERO',
                              'ITEM_NOT_ZERO',
                              'ITEM_IS_ALPHANUMERIC',
                              'ITEM_IS_NUMERIC',
                              'ITEM_IS_NOT_NUMERIC',
                              'ITEM_IS_DATE',
                              'ITEM_CONTAINS_NO_SPACES',
                              'SQL_EXPRESION',
                              'SQL_EXPRESSION',
                              'PLSQL_EXPRESION',
                              'PLSQL_EXPRESSION',
                              'REGULAR_EXPRESSION',
                              'FUNC_BODY_RETURNING_ERR_TEXT',
                              'FUNC_BODY_RETURNING_BOOLEAN',
                              'PLSQL_ERROR',
                              'NOT_EXISTS',
                              'EXISTS',
                              'ITEM_IN_VALIDATION_IN_STRING2',
                              'ITEM_IN_VALIDATION_NOT_IN_STRING2',
                              'ITEM_IN_VALIDATION_EQ_STRING2',
                              'ITEM_IN_VALIDATION_NOT_EQ_STRING2',
                              'ITEM_IN_VALIDATION_CONTAINS_AT_LEAST_ONE_CHAR_IN_STRING2',
                              'ITEM_IN_VALIDATION_CONTAINS_ONLY_CHAR_IN_STRING2',
                              'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2'
                              )),
    validation_condition      varchar2(4000),
    validation_condition2     varchar2(4000),
    validation_condition_type varchar2(255),
    when_button_pressed       number,
    error_message             varchar2(4000),
    associated_item           number,
    error_display_location    varchar2(255)
                              constraint wwv_valid_val_edl
                              check (error_display_location in (
                              'INLINE_WITH_FIELD',
                              'INLINE_WITH_FIELD_AND_NOTIFICATION',
                              'INLINE_IN_NOTIFICATION',
                              'ON_ERROR_PAGE')),
    required_patch            number,
    security_scheme           varchar2(255),
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    validation_comment        varchar2(4000),
    constraint                wwv_flow_step_val_fk2
    foreign key               (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
/




create index wwv_flow_step_validations_idx1 on wwv_flow_step_validations (flow_step_id, flow_id);
create unique index wwv_flow_step_validations_idx2 on wwv_flow_step_validations(flow_step_id,flow_id,security_group_id,id);






---------------------------------
-- P A G E    P R O C E S S I N G
--

create table wwv_flow_step_processing (
    id                     number
                           constraint wwv_flow_step_proc_pk
                           primary key,
    flow_id                number not null
                           constraint wwv_flow_step_proc_fk
                           references wwv_flows
                           on delete cascade,
    flow_step_id           number,
    --
    process_sequence       number,
    process_point          varchar2(255)
                           constraint valid_fsproc_point
                           check (process_point in (
                           'AFTER_AUTHENTICATION',
                           'ON_SUBMIT_BEFORE_COMPUTATION',
                           'BEFORE_HEADER',
                           'AFTER_HEADER',
                           'BEFORE_BOX_BODY',
                           'BEFORE_SHOW_ITEMS',
                           'AFTER_SHOW_ITEMS',
                           'AFTER_BOX_BODY',
                           'BEFORE_FOOTER',
                           'AFTER_FOOTER',
                           'AFTER_SUBMIT',
                           'AFTER_SUBMIT_BEFORE_VALIDATION',
                           'AFTER_ERROR_HEADER',
                           'BEFORE_ERROR_FOOTER')),
    --
    process_type           varchar2(255)
                           constraint wwv_valid_fsproc_type
                           check (process_type in (
                           'CLEAR_CACHE_CURRENT_FLOW',
                           'CLEAR_CACHE_FOR_FLOWS',
                           'SET_ITEM_USING_STATIC_ASSIGNMENT',
                           'SET_ITEM_USING_PLSQL_FUNCTION_BODY',
                           'SET_ITEM_USING_PLSQL_EXPRESSION',
                           'SET_ITEM_USING_SQL_QUERY',
                           'SET_ITEM_USING_SQL_EXPRESSION',
                           'WEB_SERVICE',
                           'ON_DEMAND',
                           'PLSQL',
                           'PLSQL_DBMS_JOB',
                           'RESET_PAGINATION',
                           'RESET_SESSION_STATE',
                           'CLEAR_CACHE_FOR_PAGES',
                           'CLEAR_CACHE_FOR_ITEMS',
                           'SET_PREFERENCE_TO_ITEM_VALUE',
                           'SET_PREFERENCE_TO_ITEM_VALUE_IF_ITEM_NOT_NULL',
                           'MULTI_ROW_UPDATE',
                           'MULTI_ROW_DELETE',
                           'ADD_ROWS_TO_TABULAR_FORM',
                           'RESET_PAGINATION_FOR_REGION',
                           'RESET_SORTING_FOR_REGION',
                           'DML_FETCH_ROW',
                           'DML_PROCESS_ROW',
                           'DML_PROCESS_INSERT_ROW',
                           'DML_PROCESS_UPDATE_ROW',
                           'DML_PROCESS_DELETE_ROW',
                           'RESET_USER_PREFERENCES',
                           'INITIALIZE_ALL_PAGE_ITEMS',
                           'INITIALIZE_SESSION',
                           'INITIALIZE_PAGE_PAGINATION',
                           'INITIALIZE_PAGINATION_FOR_ALL_PAGES',
                           'GET_NEXT_OR_PREV_PK',
                           'CLOSE_WINDOW'
                           )),
    --
    process_name           varchar2(255)  not null,
    item_name              varchar2(255),
    process_sql_clob       clob,
    process_error_message  varchar2(4000),
    process_when_button_id number,
    process_when           varchar2(4000),
    process_when_type      varchar2(255),
    process_when2          varchar2(4000),
    process_when_type2     varchar2(255)
                           constraint valid_fsproc_whentype2
                           check (process_when_type2 in (
                           'CURRENT_PAGE_NOT_IN_CONDITION',
                           'CURRENT_PAGE_IN_CONDITION',
                           'NEVER',
                           'CONDITION_IN_REQUEST',
                           'CONDITION_NOT_IN_REQUEST',
                           'REQUEST_EQUALS_CONDITION',
                           'REQUEST_IN_CONDITION',
                           'REQUEST_NOT_IN_CONDITION',
                           'ITEM_IS_NULL',
                           'ITEM_IS_NOT_NULL',
                           'ITEM_IS_NOT_NULL_OR_ZERO')),
    process_is_stateful_y_n VARCHAR2(1)
                            constraint valid_fsproc_stateful
                            check(process_is_stateful_y_n in ('Y','N')),
    --
    runtime_where_clause    varchar2(4000),
    --
    return_key_into_item1        varchar2(255),
    return_key_into_item2        varchar2(255),
    --
    process_success_message varchar2(4000),
    required_patch          number,
    security_scheme         varchar2(255),
    security_group_id       number not null,
    last_updated_by         varchar2(255),
    last_updated_on         date,
    process_comment         varchar2(4000),
    constraint              wwv_flow_step_proc_fk2
    foreign key             (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
    lob (process_sql_clob) store as (cache reads enable storage in row)
/



create index wwv_flow_step_processing_idx1 on wwv_flow_step_processing (flow_step_id, flow_id)
/
create index wwv_flow_step_processing_idx2 on wwv_flow_step_processing (flow_step_id, flow_id, security_group_id, id)
/



---------------------------------------------
-- P A G E   B U T T O N    T E M P L A T E S
--


create table wwv_flow_button_templates (
    id                        number
                              constraint wwv_flow_button_temp_pk
                              primary key,
    flow_id                   number not null
                              constraint wwv_flow_buttont_fk
                              references wwv_flows
                              on delete cascade,
    template_name             varchar2(255) not null,
    template                  clob not null,
    security_group_id         number not null,
    reference_id              number,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    --
    theme_id                  number,
    theme_class_id            number,
    --
    translate_this_template   varchar2(1)
                                constraint wwv_flow_button_trans_temp
                                check (translate_this_template in ('Y','N')),
    template_comment          varchar2(4000)
    ) lob (template) store as (cache reads enable storage in row)
/

create index wwv_flow_button_temp_idx1 on wwv_flow_button_templates (security_group_id, reference_id)
/
create unique index wwv_flow_button_temp_idx2 on wwv_flow_button_templates (flow_id, template_name, theme_id)
/


------------------------------------------------------------------
-- P A G E   R E G I O N    T E M P L A T E S   (PLUG TEMPLATES)
--


create table wwv_flow_page_plug_templates (
    id                        number
                              constraint wwv_flow_plug_temp_pk
                              primary key,
    flow_id                   number not null
                              constraint wwv_flow_plug_temp_fk
                              references wwv_flows
                              on delete cascade,
    page_plug_template_name   varchar2(255) not null,
    template                  clob not null,
    template2                 clob,
    template3                 clob,
    plug_table_bgcolor        varchar2(255),
    plug_heading_bgcolor      varchar2(255),
    plug_font_size            varchar2(255),
    security_group_id         number not null,
    reference_id              number,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    --
    theme_id                  number,
    theme_class_id            number,
    --
    translate_this_template   varchar2(1)
                                constraint wwv_flow_region_trans_temp
                                check (translate_this_template in ('Y','N')),
    template_comment          varchar2(4000)
    ) lob (template,template2,template3) store as (cache reads enable storage in row)
/

create index wwv_flow_page_plug_idx1 on wwv_flow_page_plug_templates (security_group_id, reference_id)
/
create unique index wwv_flow_page_plug_idx2 on wwv_flow_page_plug_templates (flow_id, page_plug_template_name, theme_id)
/


----------------------------------
-- R E P O R T   T E M P L A T E S
--


create table wwv_flow_row_templates (
    id                            number
                                  constraint wwv_flow_row_template_pk
                                  primary key,
    flow_id                       number not null
                                  constraint wwv_flow_row_template_fk
                                  references wwv_flows
                                  on delete cascade,
    row_template_name             varchar2(255) not null,
    row_template_type             varchar2(30)
                                  constraint wwv_flow_row_template_ty
                                  check (row_template_type in (
                                  'GENERIC_COLUMNS',
                                  'NAMED_COLUMNS')),
    before_column_heading         varchar2(4000),
    column_heading_template       varchar2(4000),
    after_column_heading          varchar2(4000),
    row_template1                 clob,
    row_template_condition1       varchar2(4000),
    row_template_display_cond1    varchar2(30),
    row_template2                 clob,
    row_template_condition2       varchar2(4000),
    row_template_display_cond2    varchar2(30),
    row_template3                 clob,
    row_template_condition3       varchar2(4000),
    row_template_display_cond3    varchar2(30),
    row_template4                 clob,
    row_template_condition4       varchar2(4000),
    row_template_display_cond4    varchar2(30),
    row_template_before_rows      varchar2(4000),
    row_template_after_rows       varchar2(4000),
    ROW_TEMPLATE_BEFORE_FIRST     VARCHAR2 (4000),
    ROW_TEMPLATE_AFTER_LAST       VARCHAR2 (4000),
    row_template_table_attributes varchar2(4000),
    --
    pagination_template           varchar2(4000),
    next_page_template            varchar2(4000),
    previous_page_template        varchar2(4000),
    next_set_template             varchar2(4000),
    previous_set_template         varchar2(4000),
    --
    row_style_mouse_over          varchar2(255),
    row_style_mouse_out           varchar2(255),
    row_style_checked             varchar2(255),
    row_style_unchecked           varchar2(255),
    --
    reference_id                  number,
    security_group_id             number not null,
    last_updated_by               varchar2(255),
    last_updated_on               date,
    --
    theme_id                      number,
    theme_class_id                number,
    --
    translate_this_template       varchar2(1)
                                    constraint wwv_flow_report_trans_temp
                                    check (translate_this_template in ('Y','N')),
    row_template_comment          varchar2(4000)
    ) lob (row_template1,row_template2,row_template3,row_template4) store as (cache reads enable storage in row)
/



create index wwv_flow_row_templates_idx1 on wwv_flow_row_templates(security_group_id, reference_id)
/
create unique index wwv_flow_row_templates_idx2 on wwv_flow_row_templates(flow_id, row_template_name,theme_id)
/




--------------------------------
-- L I S T    T E M P L A T E S
--

prompt ...wwv_flow_list_templates

create table wwv_flow_list_templates (
    id                            number
                                  constraint wwv_flow_list_template_pk
                                  primary key,
    flow_id                       number not null
                                  constraint wwv_flow_list_template_fk
                                  references wwv_flows
                                  on delete cascade,
    list_template_name            varchar2(255) not null,
    list_template_current         clob,
    list_template_noncurrent      clob,
    list_template_before_rows     varchar2(4000),
    list_template_after_rows      varchar2(4000),
    --
    between_items                 varchar2(4000),
    before_sub_list               varchar2(4000),
    after_sub_list                varchar2(4000),
    between_sub_list_items        varchar2(4000),
    sub_list_item_current         clob,
    sub_list_item_noncurrent      clob,
    --
    item_template_curr_w_child    clob,
    item_template_noncurr_w_child clob,
    sub_template_curr_w_child     clob,
    sub_template_noncurr_w_child  clob,
    --
    reference_id                  number,
    security_group_id             number not null,
    last_updated_by               varchar2(255),
    last_updated_on               date,
    --
    theme_id                      number,
    theme_class_id                number,
    --
    translate_this_template       varchar2(1)
                                    constraint wwv_flow_list_trans_temp
                                    check (translate_this_template in ('Y','N')),
    list_template_comment         varchar2(4000)
    ) lob (list_template_current,
           list_template_noncurrent,
           sub_list_item_current,
           sub_list_item_noncurrent,
           item_template_curr_w_child,
           item_template_noncurr_w_child,
           sub_template_curr_w_child,
           sub_template_noncurr_w_child) store as (cache reads enable storage in row)
/

create index wwv_flow_list_templates_idx1 on wwv_flow_list_templates(security_group_id, reference_id)
/
create unique index wwv_flow_list_templates_idx2 on wwv_flow_list_templates(flow_id ,list_template_name, theme_id)
/



------------------------------------------
-- P A G E    R E G I O N S   (page plugs)
--

prompt ...create wwv_flow_page_plugs


create table wwv_flow_page_plugs (
    id                           number
                                 constraint wwv_flow_page_plugs_pk
                                 primary key,
    flow_id                      number not null
                                 constraint wwv_flow_plug_to_flow_fk
                                 references wwv_flows
                                 on delete cascade,
    page_id                      number,
    plug_name                    varchar2(255) not null,
    region_name                  varchar2(255),
    --
    plug_template                number,
    plug_display_sequence        number not null,
    plug_display_column          number
                                 constraint wwv_valid_plug_disp_column
                                 check (plug_display_column in (1,2,3,4,5,6,7,8,9)),
    plug_display_point           varchar2(255)
                                 constraint wwv_valid_plug_disppoint
                                 check (plug_display_point in (
                                 'REGION_POSITION_01',
                                 'REGION_POSITION_02',
                                 'REGION_POSITION_03',
                                 'REGION_POSITION_04',
                                 'REGION_POSITION_05',
                                 'REGION_POSITION_06',
                                 'REGION_POSITION_07',
                                 'REGION_POSITION_08',
                                 'REGION_POSITION_09',
                                 'REGION_POSITION_10',
                                 'REGION_POSITION_11',
                                 'REGION_POSITION_12',
                                 'REGION_POSITION_13',
                                 'REGION_POSITION_14',
                                 'REGION_POSITION_15',
                                 'REGION_POSITION_16',
                                 'REGION_POSITION_17',
                                 'REGION_POSITION_18',
                                 'REGION_POSITION_19',
                                 'REGION_POSITION_20',
                                 'REGION_POSITION_21',
                                 'REGION_POSITION_22',
                                 'REGION_POSITION_23',
                                 'REGION_POSITION_24',
                                 'REGION_POSITION_25',
                                 'REGION_POSITION_26',
                                 'REGION_POSITION_27',
                                 'REGION_POSITION_28',
                                 'REGION_POSITION_29',
                                 'REGION_POSITION_30',
                                 'AFTER_HEADER',
                                 'BEFORE_BOX_BODY',
                                 'BEFORE_SHOW_ITEMS',
                                 'AFTER_SHOW_ITEMS',
                                 'BEFORE_FOOTER')),
    --
    plug_source                  clob,
    menu_template_id             number,
    list_template_id             number,
    plug_source_type             varchar2(255),
    plug_display_error_message   varchar2(4000),
    --
    --
    plug_required_role           varchar2(255),
    plug_display_when_condition  varchar2(4000),
    plug_display_when_cond2      varchar2(4000),
    plug_display_condition_type  varchar2(255),
    --
    plug_header                  varchar2(4000),
    plug_footer                  varchar2(4000),
    --
    plug_query_row_template      number,
    plug_query_headings          varchar2(4000),
    plug_query_headings_type     varchar2(255)
                                 constraint wwv_plug_head_type_check
                                 check (plug_query_headings_type in (
                                 'NO_HEADINGS',
                                 'SORT_ENABLED_COLON_DELMITED_LIST',
                                 'SORT_ENABLED_QUERY_COLUMNS',
                                 'SORT_ENABLED_QUERY_COLUMNS_INITCAP',
                                 'COLON_DELMITED_LIST',
                                 'COLON_DELIMITED_LIST',
                                 'PIPE_DELMITED_LIST',
                                 'BACKSLASH_DELMITED_LIST',
                                 'QUERY_COLUMNS',
                                 'QUERY_COLUMNS_INITCAP',
                                 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
                                 'FUNCTION_BODY_RETURNING_PIPE_DELIMITED_LIST')),
    plug_query_num_rows          number,
    plug_query_num_rows_type     varchar2(255)
                                 constraint wwv_plug_query_num_rows_type
                                 check (plug_query_num_rows_type in (
                                 'NEXT_PREVIOUS_LINKS',
                                 'COMPUTED_BUT_NOT_DISPLAYED',
                                 'ROW_RANGES',
                                 'ROW_RANGES_RIGHT',
                                 'ROW_RANGES_WITH_LINKS_RIGHT',
                                 'ROW_RANGES_WITH_LINKS',
                                 'ROW_RANGES_IN_SELECT_LIST',
                                 'ROW_RANGES_IN_SELECT_LIST_RIGHT',
                                 'ROWS_PER_PAGE_FROM_ITEM',
                                 'ROWS_X_TO_Y_OF_Z',
                                 'ROWS_X_TO_Y',
                                 'SEARCH_ENGINE',
                                 'SEARCH_ENGINE_RIGHT',
                                 '0'
                                 )),
    pagination_display_position  varchar2(255),
    ajax_enabled                 varchar2(1),
    plug_query_num_rows_item     varchar2(255),
    plug_query_no_data_found     varchar2(4000),
    plug_query_more_data         varchar2(4000),
    plug_query_row_count_max     number,
    --
    plug_query_format_out        varchar2(255),
    plug_query_show_nulls_as     varchar2(255),
    plug_query_col_allignments   varchar2(255),
    plug_query_break_cols        varchar2(255),
    plug_query_sum_cols          varchar2(255),
    plug_query_number_formats    varchar2(4000),
    plug_query_table_border      varchar2(255),
    plug_query_hit_highlighting  varchar2(4000),
    plug_query_asc_image         varchar2(4000),
    plug_query_asc_image_attr    varchar2(4000),
    plug_query_desc_image        varchar2(4000),
    plug_query_desc_image_attr   varchar2(4000),
    --
    plug_query_exp_filename      varchar2(255),
    plug_query_exp_separator     varchar2(1),
    plug_query_exp_enclosed_by   varchar2(1),
    plug_query_strip_html        varchar2(1)
                                 constraint wwv_plug_strip_html
                                 check(plug_query_strip_html in ('Y','N')),
    --
    plug_query_options           varchar2(4000),
    plug_query_max_columns       number,
    plug_column_width            varchar2(255),
    plug_customized              varchar2(255),
    plug_customized_name         varchar2(4000),
    plug_override_reg_pos        varchar2(255),
    --
    required_patch               number,
    --
    plug_url_text_begin          varchar2(4000),
    plug_url_text_end            varchar2(4000),
    plug_caching                 varchar2(255)
                                 constraint wwv_plug_valid_caching
                                 check (plug_caching in (
                                 'NOT_CACHED',
                                 'CACHED',
                                 'CACHED_BY_USER',
                                 'CACHED_BY_USER_AND_SESSION')),
    plug_cache_when              varchar2(255),
    plug_cache_expression1       varchar2(4000),
    plug_cache_expression2       varchar2(4000),
    plug_caching_session_state   varchar2(4000),
    plug_caching_max_age_in_sec  number,
    plug_ignore_pagination       number,
    --
    plug_chart_font_size         varchar2(255),
    plug_chart_max_rows          number,
    plug_chart_num_mask          varchar2(255),
    plug_chart_scale             varchar2(255),
    plug_chart_axis              varchar2(255),
    plug_chart_show_summary      varchar2(255),
    --
    report_total_text_format    varchar2(4000),
    break_column_text_format    varchar2(4000),
    break_before_row            varchar2(4000),
    break_generic_column        varchar2(4000),
    break_after_row             varchar2(4000),
    break_type_flag             varchar2(255)
                                constraint wwv_break_flag_cc
                                check(break_type_flag in (
                                'REPEAT_HEADINGS_ON_BREAK_1',
                                'DEFAULT_BREAK_FORMATTING')),
    break_repeat_heading_format varchar2(4000),
    csv_output                   varchar2(1)
                                 constraint wwv_csv_output_flag_ck
                                 check(csv_output in ('Y','N')),
    csv_output_link_text         varchar2(4000),
    print_url                    varchar2(4000),
    print_url_label              varchar2(4000),
    --
    prn_output                   varchar2(1) constraint plug_prn_output
                                     check (prn_output in ('Y','N')),
    prn_print_server_overwrite   varchar2(4000),
    prn_template_id              number,
    prn_format                   varchar2(255) constraint plug_prn_format
                                     check (prn_format in (
                                          'PDF',
                                          'RTF',
                                          'XLS',
                                          'HTM',
                                          'XML'
                                      )),
    prn_format_item              varchar2(4000),
    prn_output_show_link         varchar2(1)
                                     constraint plug_prn_show_link
                                         check(prn_output_show_link in ('Y','N')),
    prn_output_link_text         varchar2(4000),
    prn_output_file_name         varchar2(4000),
    prn_content_disposition      varchar2(255) constraint plug_prn_content_disp
                                     check (prn_content_disposition in (
                                         'INLINE',
                                         'ATTACHMENT'
                                     )),
    prn_document_header          varchar2(255) constraint plug_prn_doc_header
                                     check (prn_document_header in (
                                         'SERVER',
                                         'APEX'
                                     )),
    prn_units                    varchar2(4000) constraint plug_prn_units
                                     check (prn_units in (
                                         'POINTS',
                                         'INCHES',
                                         'MILLIMETERS',
                                         'CENTIMETERS'
                                     )),
    prn_paper_size               varchar2(4000) constraint plug_prn_paper_size
                                     check (prn_paper_size in (
                                        'CUSTOM',
                                        'LETTER',
                                        'LEGAL',
                                        'TABLOID',
                                        'A4',
                                        'A3'
                                     )),
    prn_width_units              varchar2(255) constraint plug_prn_width_units
                                     check (prn_width_units in (
                                         'PERCENTAGE',
                                         'POINTS'
                                     )),
    prn_width                    number,
    prn_height                   number,
    prn_orientation              varchar2(4000) constraint plug_prn_orientation
                                     check (prn_orientation in (
                                         'HORIZONTAL',
                                         'VERTICAL'
                                     )),
    prn_page_header              varchar2(4000),
    prn_page_header_alignment    varchar2(255) constraint plug_prn_header_align
                                     check (prn_page_header_alignment in ('LEFT','CENTER','RIGHT')),
    prn_page_header_font_color   varchar2(4000),
    prn_page_header_font_family  varchar2(4000),
    prn_page_header_font_weight  varchar2(4000),
    prn_page_header_font_size    varchar2(4000),
    prn_page_footer              varchar2(4000),
    prn_page_footer_alignment    varchar2(255) constraint plug_prn_footer_align
                                     check (prn_page_footer_alignment in ('LEFT','CENTER','RIGHT')),
    prn_page_footer_font_color   varchar2(4000),
    prn_page_footer_font_family  varchar2(4000),
    prn_page_footer_font_weight  varchar2(4000),
    prn_page_footer_font_size    varchar2(4000),
    prn_header_bg_color          varchar2(4000),
    prn_header_font_color        varchar2(4000),
    prn_header_font_family       varchar2(4000),
    prn_header_font_weight       varchar2(4000),
    prn_header_font_size         varchar2(4000),
    prn_body_bg_color            varchar2(4000),
    prn_body_font_color          varchar2(4000),
    prn_body_font_family         varchar2(4000),
    prn_body_font_weight         varchar2(4000),
    prn_body_font_size           varchar2(4000),
    prn_border_color             varchar2(4000),
    prn_border_width             number,
    --
    shared_query_id              number,
    --
    translate_title              varchar2(1)
                                 constraint wwv_translate_title_ck
                                 check(translate_title in ('Y','N')),
    --
    security_group_id            number not null,
    last_updated_by              varchar2(255),
    last_updated_on              date,
    plug_comment                 varchar2(4000),
    --
    use_custom_item_layout       varchar2(1),
    custom_item_layout           clob,
    sort_null                    varchar2(1)
                                 constraint wwv_pp_sort_null_ck
                                 check (sort_null in (null,'F','L')),
    region_attributes_substitution varchar2(4000),
    report_attributes_substitution varchar2(4000),
    std_rpt_max_query_cost       number,
    -- obsolete columns
    java_entry_point             varchar2(255), --obsolete
    plug_create_link_text        varchar2(4000), --obsolete
    plug_create_link_target      varchar2(4000), --obsolete
    plug_create_image            varchar2(4000), --obsolete
    plug_create_image_attributes varchar2(4000), --obsolete
    plug_edit_link_text          varchar2(4000), --obsolete
    plug_edit_link_target        varchar2(4000), --obsolete
    plug_edit_image              varchar2(4000), --obsolete
    plug_edit_image_attributes   varchar2(4000), --obsolete
    plug_expand_link_text        varchar2(4000), --obsolete
    plug_expand_link_target      varchar2(4000), --obsolete
    plug_expand_image            varchar2(4000), --obsolete
    plug_expand_image_attributes varchar2(4000), --obsolete
    plug_close_link_text         varchar2(4000), --obsolete
    plug_close_link_target       varchar2(4000), --obsolete
    plug_close_image             varchar2(4000), --obsolete
    plug_close_image_attributes  varchar2(4000), --obsolete
    constraint                   wwv_flow_plug_to_page_fk
    foreign key                  (flow_id, page_id) references wwv_flow_steps (flow_id, id) on delete cascade)
    lob (plug_source,custom_item_layout) store as (cache reads enable storage in row)
/




create index wwv_flow_page_plugs_idx1 on wwv_flow_page_plugs (flow_id);
create index wwv_flow_page_plugs_idx2 on wwv_flow_page_plugs (page_id);
create index wwv_flow_page_plugs_idx3 on wwv_flow_page_plugs (plug_name);
create unique index wwv_flow_page_plugs_idx_u1 on wwv_flow_page_plugs (id, page_id, flow_id, security_group_id);



-------------------------------------------------
-- P A G E    R E G I O N S   A T T R I B U T E S
--

prompt ...create wwv_flow_page_generic_attr


create table wwv_flow_page_generic_attr (
    id                           number
                                 constraint wwv_flow_page_generic_pk
                                 primary key,
    region_id                    number not null
                                 constraint wwv_flow_genattr_to_region_fk
                                 references wwv_flow_page_plugs
                                 on delete cascade,
    attribute_id                 number not null,
    security_group_id            number not null,
    attribute_value              clob)
    lob (attribute_value) store as (cache reads enable storage in row)
/

create unique index wwv_flow_page_genattr_idx on wwv_flow_page_generic_attr(region_id,attribute_id)
/




---------------------------------------------
-- C A L E N D A R
--

create table wwv_flow_cals (
  id                          number
                              constraint      wwv_flow_cals_pk
                              primary key,
  flow_id                     number          not null
                              constraint      wwv_flow_cal_to_flow_fk
                              references      wwv_flows
                              on delete       cascade,
  plug_id                     number          not null
                              constraint      wwv_flow_plug_calendar_fk
                              references      wwv_flow_page_plugs
                              on delete       cascade,
  start_date                  varchar2(255),
  end_date                    varchar2(255),
  begin_at_start_of_interval  varchar2(1)
                              constraint      wwv_flow_val_calendar_si
                              check           (begin_at_start_of_interval in ('Y','N')),
  date_item                   varchar2(255)   default null,
  display_as                  varchar2(100),
  display_item                varchar2(255),
  display_type                varchar2(10)
                               constraint      wwv_flow_dis_calendar_typ
                               check           (display_type in ('NONE','COL','CUS')),
  item_format                 varchar2(4000),
  easy_sql_owner              varchar2(255),
  easy_sql_table              varchar2(255),
  date_column                 varchar2(255),
  display_column              varchar2(255),
  start_of_week               number,
  template_id                 number,
  item_link                   varchar2(4000),
  day_link                    varchar2(4000),
  start_time                  number,
  end_time                    number,
  time_format                 varchar2(6)
                              constraint wwv_flow_dis_time_format
                              check(time_format in ('12HOUR','24HOUR') ),
  week_start_day              number,
  week_end_day                number,
  date_type_column            varchar2(255),
  security_group_id           number not null,
  last_updated_by             varchar2(255),
  last_updated_on             date,
  calendar_type               varchar2(1),
  calendar_comments           varchar2(4000)
  )
/

create index wwv_flow_cal_fk_idx1 on wwv_flow_cals(flow_id, security_group_id)
/
create index wwv_flow_cal_fk_idx2 on wwv_flow_cals(plug_id, security_group_id)
/


---------------------------------------------
-- C A L E N D A R   T E M P L A T E S
--

create table wwv_flow_cal_templates (
   id                      number
                           constraint wwv_flow_cal_templates_pk
                           primary key,
   name                    varchar2(512),
   flow_id                 number
                           constraint      wwv_flow_cal_templ_to_flow_fk
                           references      wwv_flows
                           on delete       cascade,
   security_group_id       number not null,
   last_updated_by         varchar2(255),
   last_updated_on         date,
   --
   theme_id                number,
   theme_class_id          number,
   --
   translate_this_template varchar2(1),
   reference_id            number,
   --
   month_title_format      varchar2(4000),
   day_of_week_format      varchar2(4000),
   month_open_format       varchar2(4000),
   month_close_format      varchar2(4000),
   day_title_format        varchar2(4000),
   day_open_format         varchar2(4000),
   day_close_format        varchar2(4000),
   today_open_format       varchar2(4000),
   weekend_title_format    varchar2(4000),
   weekend_open_format     varchar2(4000),
   weekend_close_format    varchar2(4000),
   nonday_title_format     varchar2(4000),
   nonday_open_format      varchar2(4000),
   nonday_close_format     varchar2(4000),
   week_title_format       varchar2(4000), -- used for week headers
   week_open_format        varchar2(4000), -- used for week headers
   week_close_format       varchar2(4000), -- used for week headers
   daily_title_format      varchar2(4000), -- used for daily view header
   daily_open_format       varchar2(4000), -- used for daily view header
   daily_close_format      varchar2(4000), -- used for daily view header
   weekly_title_format     varchar2(4000),
   weekly_day_of_week_format   varchar2(4000),
   weekly_month_open_format    varchar2(4000),
   weekly_month_close_format   varchar2(4000),
   weekly_day_title_format     varchar2(4000),
   weekly_day_open_format      varchar2(4000),
   weekly_day_close_format     varchar2(4000),
   weekly_today_open_format    varchar2(4000),
   weekly_weekend_title_format varchar2(4000),
   weekly_weekend_open_format  varchar2(4000),
   weekly_weekend_close_format varchar2(4000),
   weekly_time_open_format     varchar2(4000),
   weekly_time_close_format    varchar2(4000),
   weekly_time_title_format    varchar2(4000),
   weekly_hour_open_format     varchar2(4000),
   weekly_hour_close_format    varchar2(4000),
   daily_day_of_week_format    varchar2(4000),
   daily_month_title_format    varchar2(4000),
   daily_month_open_format     varchar2(4000),
   daily_month_close_format    varchar2(4000),
   daily_day_title_format      varchar2(4000),
   daily_day_open_format       varchar2(4000),
   daily_day_close_format      varchar2(4000),
   daily_today_open_format     varchar2(4000),
   daily_time_open_format      varchar2(4000),
   daily_time_close_format     varchar2(4000),
   daily_time_title_format     varchar2(4000),
   daily_hour_open_format      varchar2(4000),
   daily_hour_close_format     varchar2(4000),
   template_comments           varchar2(4000)
   )
/

create index wwv_flow_cal_temp_idx1 on wwv_flow_cal_templates (security_group_id, reference_id)
/
create unique index wwv_flow_cal_temp_idx2 on wwv_flow_cal_templates (flow_id, name, theme_id)
/


------------
-- T H E M E
--
create table wwv_flow_themes (
     id                          number
                                 constraint wwv_flow_themes_PK
                                 primary key,
     flow_id                     number not null
                                 constraint wwv_flow_themes_2f_fk
                                 references wwv_flows
                                 on delete cascade,
     theme_id                    number not null,
     security_group_id           number not null,
     theme_name                  varchar2(255) not null,
     default_page_template       number,
     error_template              number,
     printer_friendly_template   number,
     breadcrumb_display_point    varchar2(2000),
     sidebar_display_point       varchar2(2000),
     login_template              number,
     default_button_template     number,
     default_region_template     number,
     default_chart_template      number,
     default_form_template       number,
     default_reportr_template    number,
     default_tabform_template    number,
     default_wizard_template     number,
     default_menur_template      number,
     default_listr_template      number,
     default_report_template     number,
     default_label_template      number,
     default_menu_template       number,
     default_calendar_template   number,
     default_list_template       number,
     default_option_label        number,
     default_required_label      number,
     --
     theme_description           varchar2(4000),
     theme_image                 blob,
     theme_image_mime_type       varchar2(255),
     custom_image                varchar2(1),
     theme_security_group_id     number,
     --
     calendar_icon               varchar2(255),
     calendar_icon_attr          varchar2(4000),
     --
     last_updated_on             date,
     last_updated_by             varchar2(255)
     )
/



create unique index wwv_flow_themes_idx1 on wwv_flow_themes (flow_id, theme_id)
/





-------------------------------------------------------------
-- F L O W   S E S S I O N    S T A T E   M A N A G E M E N T
--
--
-- User Session Information Storage
--
-- id                 session identifier
-- created_by         database user, user for DATABASE authentication, and user for all types of auth
-- created_on         date created used to purge old sessions
-- cookie_session_id  session the cookie was created with
-- cookie             application user for cookie based authentication
-- security_group_id  vpd
-- last_changed       depricated
-- expires_on         depricated
-- ip_address         depricated
--

prompt ...create tables to manage session state

create table wwv_flow_sessions$ (
    id                        number
                              constraint wwv_flow_sessions_pk
                              primary key,
    session_id_hashed         varchar2(255) not null,
    cookie_session_id         number,
    created_by                varchar2(255),
    created_on                date,
    cookie                    varchar2(255),
    on_new_instance_fired_for varchar2(4000),
    passed_sec_checks         varchar2(4000),
    failed_sec_checks         varchar2(4000),
    security_group_id         number not null,
    last_changed              date,
    expires_on                date,
    ip_address                varchar2(2000),
    remote_addr               varchar2(255)
    )
    storage (initial 100K next 1M freelists 20)
/


create index wwv_flow_session_idx1 on  wwv_flow_sessions$ (cookie_session_id)
/

create unique index wwv_flow_session_idx2 on  wwv_flow_sessions$ (session_id_hashed)
/

create table wwv_flow_purged_sessions$ (
    purge_date          date,
    purged_sessions     number,
    min_session_id      number,
    max_session_id      number,
    min_session_date    date,
    max_session_date    date,
    elap_seconds        number,
    security_group_id   number not null)
/



prompt ...wwv_flow_data



create table wwv_flow_data (
    flow_instance        number not null
                         constraint wwv_flow_data_fk
                         references wwv_flow_sessions$
                         on delete cascade,
    item_id              number,
    item_element_id      number,
    item_filter          varchar2(1)
                         constraint valid_item_filter
                         check (item_filter in ('Y','N')),
    session_state_status varchar2(1)
                         constraint valid_session_state_status
                         check (session_state_status in ('I','U','R')),
    flow_id              number,
    item_name            varchar2(255),
    name_length          int,
    is_encrypted         varchar2(1),
    item_value           clob)
    storage (initial 1M next 1M freelists 20)
    lob (item_value) store as (cache reads enable storage in row)
/




create unique index WWV_FLOW_DATA_IDX1 on wwv_flow_data (FLOW_INSTANCE,ITEM_ID);
create index WWV_FLOW_DATA_IDX2 on wwv_flow_data (flow_id,FLOW_INSTANCE);







---------------------------------------------------------------------------
-- F L O W   A C T I V I T Y   L O G G I N G
--
-- logging can be disabled
-- you may not wish to maintain indexes on log tables for active applications
--

prompt ...create flow log tables

create table wwv_flow_activity_log_number$ (
    current_log_number     number not null
                           check (current_log_number in (1,2)),
    current_log_timestamp  date   not null
    )
/
insert into wwv_flow_activity_log_number$
    select 1, sysdate from dual where 0 = (select count(*) from wwv_flow_activity_log_number$);


--
-- security group id for logs is not set via a trigger for performance reasons
--


create table wwv_flow_activity_log1$ (
    time_stamp             date not null,
    component_type         varchar2(255),
    component_name         varchar2(255),
    component_attribute    varchar2(4000),
    information            varchar2(4000),
    elap                   number,
    num_rows               number,
    userid                 varchar2(255),
    ip_address             varchar2(4000),
    user_agent             varchar2(4000),
    flow_id                number,
    step_id                number,
    session_id             number,
    security_group_id      number not null,
    sqlerrm                varchar2(4000),
    sqlerrm_component_type varchar2(255),
    sqlerrm_component_name varchar2(255),
    page_mode              varchar2(1),
    cached_regions         number,
    application_info       varchar2(4000)
    )
    initrans 8
    maxtrans 255
    storage (initial 1m next 1m)
/

create index wwv_flow_activity_log1$_idx1
    on wwv_flow_activity_log1$(time_stamp)
    initrans 8
    maxtrans 255
    storage (
    initial 100K
    next    100K)
/

create table wwv_flow_activity_log2$ (
    time_stamp             date not null,
    component_type         varchar2(255),
    component_name         varchar2(255),
    component_attribute    varchar2(4000),
    information            varchar2(4000),
    elap                   number,
    num_rows               number,
    userid                 varchar2(255),
    ip_address             varchar2(4000),
    user_agent             varchar2(4000),
    flow_id                number,
    step_id                number,
    session_id             number,
    security_group_id      number not null,
    sqlerrm                varchar2(4000),
    sqlerrm_component_type varchar2(255),
    sqlerrm_component_name varchar2(255),
    page_mode              varchar2(1),
    cached_regions         number,
    application_info       varchar2(4000)
    )
    initrans 8
    maxtrans 255
    storage (initial 1m next 1m)
/

create index wwv_flow_activity_log2$_idx1
    on wwv_flow_activity_log2$(time_stamp)
    initrans 8
    maxtrans 255
    storage (
    initial 100K
    next    100K)
/

create or replace view wwv_flow_activity_log as
    select * from wwv_flow_activity_log1$ union all
    select * from wwv_flow_activity_log2$
/

create or replace view wwv_flow_user_activity_log as
    select time_stamp, component_type, component_name, component_attribute,
           information, elap, num_rows, userid, ip_address, user_agent,
           flow_id, step_id, session_id, sqlerrm, sqlerrm_component_type, sqlerrm_component_name,
           page_mode, application_info
      from wwv_flow_activity_log
     where security_group_id = (select wwv_flow.get_sgid from dual where rownum = 1)
/

--
-- Access Log
--

create table wwv_flow_user_access_log_num$ (
    current_log_number     number not null
                           check (current_log_number in (1,2)),
    current_log_timestamp  date   not null,
    minimum_retained_days  number not null
    )
/

insert into wwv_flow_user_access_log_num$(current_log_number, current_log_timestamp, minimum_retained_days)
    select 1, sysdate, 14 from dual where 0 = (select count(*) from wwv_flow_user_access_log_num$)
/

create table wwv_flow_user_access_log1$ (
    login_name             varchar2(255) not null,
    authentication_method  varchar2(255),
    application            number,
    owner                  varchar2(255),
    access_date            date,
    ip_address             varchar2(255),
    remote_user            varchar2(255),
    authentication_result  number, -- 0:okay,1:invalid user,2:account locked,3:account expired,4:password mismatch,5:pw first use,6:attempts exceeded
    custom_status_text     varchar2(4000),
    security_group_id      number not null
    )
/

create table wwv_flow_user_access_log2$ (
    login_name             varchar2(255) not null,
    authentication_method  varchar2(255),
    application            number,
    owner                  varchar2(255),
    access_date            date,
    ip_address             varchar2(255),
    remote_user            varchar2(255),
    authentication_result  number, -- 0:okay,1:invalid user,2:account locked,3:account expired,4:password mismatch,5:pw first use,6:attempts exceeded
    custom_status_text     varchar2(4000),
    security_group_id      number not null
    )
/

create or replace view wwv_flow_user_access_log_v as
    select login_name, authentication_method, application, owner, access_date, ip_address, remote_user, authentication_result, custom_status_text, security_group_id
      from wwv_flow_user_access_log1$
    union all
    select login_name, authentication_method, application, owner, access_date, ip_address, remote_user, authentication_result, custom_status_text, security_group_id
      from wwv_flow_user_access_log2$
/

create or replace view wwv_flow_user_access_log as
    select login_name, authentication_method, application, owner, access_date, ip_address, remote_user, authentication_result, custom_status_text
      from wwv_flow_user_access_log_v
     where security_group_id = wwv_flow.get_sgid and security_group_id <> 0
/



--------------
-- PREFERENCES
--

prompt ...create wwv_flow_preferences$ table

create table wwv_flow_preferences$ (
    id                     number
                           constraint wwv_flow_prefs_pk
                           primary key,
    user_id                varchar2(255) not null,
    preference_name        varchar2(255) not null,
    attribute_value        varchar2(4000),
    security_group_id      number not null
                           constraint wwv_flow_prefs_fk
                           references wwv_flow_companies(provisioning_company_id)
                           on delete cascade
    )
    storage (
        initial 10K
        next    100K)
/



create index wwv_flow_pref_user_pref_idx
    on wwv_flow_preferences$ (user_id, preference_name)
    storage (
        initial 100K
        next    100K)
/







---------------------------------------------
-- MESSAGES
--

prompt ...create wwv_flow_messages$ table

create table wwv_flow_messages$ (
    id                           number
                                 constraint wwv_flow_messages_pk
                                 primary  key,
    flow_id                      number not null
                                 constraint wwv_flow_messages_fk
                                 references wwv_flows
                                 on delete cascade,
    name                         varchar2(255) not null,
    message_language             varchar2(50)  not null,
    message_text                 varchar2(4000) not null,
    security_group_id            number not null,
    last_updated_by              varchar2(255),
    last_updated_on              date,
    message_comment              varchar2(4000)
    )
/
create unique index wwv_flow_messages_idx1 on wwv_flow_messages$ (flow_id, name, security_group_id, message_language)
/
create index wwv_flow_messages_idx2 on wwv_flow_messages$ (security_group_id, name, message_language)
/



------------------------
-- PATCH (BUILD OPTIONS)
--

prompt ...create wwv_flow_patches table

create table wwv_flow_patches (
    id                           number
                                 constraint wwv_flow_patches_pk
                                 primary  key,
    flow_id                      number  not null
                                 constraint wwv_flow_patches_fk
                                 references wwv_flows
                                 on delete cascade,
    patch_name                   varchar2(255) not null,
    patch_status                 varchar2(30)
                                 constraint wwv_flow_patch_valid_status check (patch_status in ('INCLUDE','EXCLUDE')),
    security_group_id            number not null,
    --
    default_on_export            varchar2(30),
    attribute1                   varchar2(255),
    attribute2                   varchar2(255),
    attribute3                   varchar2(255),
    attribute4                   varchar2(255),
    --
    last_updated_by              varchar2(255),
    last_updated_on              date,
    patch_comment                varchar2(4000)
    )
/

create or replace view wwv_flow_build_options as select * from wwv_flow_patches
/



----------------------------------------------------------
-- FLOW DEVELOPERS
--
-- EDIT        edit one or more flows and page builder
-- ADMIN       root priv on flows
-- BROWSE      priv to run the flow that allows database browsing
-- USER_MANAGERpriv to run the cookie based user manager
-- CREATE      create a new flow
-- MONITOR     monitor flow application information
-- DB_MONITOR  monitor database parameters and state
-- SQL         sql workshop
--

prompt ...create tables used to manage flow developers

create table wwv_flow_developer_roles (
    developer_role     varchar2(255) primary key,
    role_description   varchar2(4000) )
/


create table wwv_flow_developers (
    id                 number
                       constraint wwv_flow_developers_pk
                       primary key,
    user_id            number,
    userid             varchar2(255) not null,
    flow_id            number,
    email              varchar2(255),
    developer_role     varchar2(4000) not null,
    developer_comments varchar2(4000),
    security_group_id  number not null
                       constraint wwv_flow_dev_fk
                       references wwv_flow_companies(provisioning_company_id)
                       on delete cascade
    )
/

create unique index wwv_flow_developers_pk2 on wwv_flow_developers(userid,flow_id, security_group_id);
create index wwv_flow_developers_id on wwv_flow_developers(user_id);



















------------------------------------
--   L I S T S
--

prompt ...create wwv_flow_lists table

create table wwv_flow_lists (
     id                       number
                              constraint wwv_flow_lists_pk
                              primary key,
     flow_id                  number not null
                              constraint wwv_flow_lists_flow_fk
                              references wwv_flows
                              on delete cascade,
     name                     varchar2(255) not null,
     list_status              varchar2(255),
                              constraint wwv_flows_val_list_status
                              check (list_status in ('PERSONAL','PUBLIC')),
     list_displayed           varchar2(255)
                              constraint wwv_flow_val_listdisplayed1
                              check (list_displayed in ('ON_DEMAND','ALWAYS','NEVER','BY_DEFAULT')),
     display_row_template_id  number,
     required_patch           number,
     security_group_id        number not null,
     last_updated_by          varchar2(255),
     last_updated_on          date,
     list_comment             varchar2(4000)
     )
/


prompt ...create wwv_flow_list_items table

create table wwv_flow_list_items (
     id                           number
                                  constraint wwv_flow_list_items_pk
                                  primary key,
     list_id                      number
                                  constraint wwv_flow_list_items_fk
                                  references wwv_flow_lists
                                  on delete cascade,
     flow_id                      number,
     --
     sub_item_count               number,
     parent_list_item_id          number
                                  constraint parent_list_item_fk
                                  references wwv_flow_list_items
                                  on delete cascade,
     --
     list_item_type               varchar2(255)
                                  constraint wwv_flows_val_listitemtype
                                  check (list_item_type in ('LINK','FILE','TABLE')),
     list_item_status             varchar2(255),
                                  constraint wwv_flows_val_listitemstatus
                                  check (list_item_status in ('PERSONAL','PUBLIC')),
     item_displayed               varchar2(255)
                                  constraint wwv_flow_val_listdisplayed
                                  check (item_displayed in ('ON_DEMAND','ALWAYS','NEVER','BY_DEFAULT')),
     list_item_display_sequence   number,
     list_item_link_text          varchar2(4000),
     list_item_link_target        varchar2(4000),
     list_item_icon               varchar2(4000),
     list_item_icon_attributes    varchar2(4000),
     --
     list_item_icon_exp           varchar2(4000),
     list_item_icon_exp_attr      varchar2(4000),
     --
     list_item_owner              varchar2(255),
     list_item_current_for_pages  varchar2(4000),
     list_item_current_type       varchar2(30)
                                  constraint wwv_flow_lst_curr_type_val
                                  check (list_item_current_type in (
                                  'COLON_DELIMITED_PAGE_LIST',
                                  'PLSQL_EXPRESSION',
                                  'ALWAYS',
                                  'NEVER',
                                  'EXISTS',
                                  'NOT_EXISTS')),
     list_item_disp_cond_type     varchar2(255),
     list_item_disp_condition     varchar2(4000),
     list_item_disp_cond_type2    varchar2(255),
     list_item_disp_condition2    varchar2(4000),
     list_countclicks_y_n         varchar2(1)
                                  constraint wwv_flow_list_count_chk
                                  check (list_countclicks_y_n in ('Y','N')),
     list_countclicks_cat         varchar2(255),
     list_text_01                 varchar2(4000),
     list_text_02                 varchar2(4000),
     list_text_03                 varchar2(4000),
     list_text_04                 varchar2(4000),
     list_text_05                 varchar2(4000),
     list_text_06                 varchar2(4000),
     list_text_07                 varchar2(4000),
     list_text_08                 varchar2(4000),
     list_text_09                 varchar2(4000),
     list_text_10                 varchar2(4000),
     list_text_11                 varchar2(4000),
     list_text_12                 varchar2(4000),
     list_text_13                 varchar2(4000),
     list_text_14                 varchar2(4000),
     list_text_15                 varchar2(4000),
     list_text_16                 varchar2(4000),
     list_text_17                 varchar2(4000),
     list_text_18                 varchar2(4000),
     list_text_19                 varchar2(4000),
     list_text_20                 varchar2(4000),
     required_patch               number,
     security_scheme              varchar2(255),
     security_group_id            number not null,
     last_updated_by              varchar2(255),
     last_updated_on              date,
     list_item_comment            varchar2(4000)
     )
/


create index parent_list_item_id_idx on wwv_flow_list_items ( parent_list_item_id )
/

create index wwv_flow_list_items_idx1 on wwv_flow_list_items( security_group_id, flow_id, list_id )
/

create unique index wwv_flow_list_items_idx2 on wwv_flow_list_items(list_id,id,item_displayed,required_patch)
/


---------------
-- shared query
--
create table  wwv_flow_shared_queries (
    id                    number
                             constraint wwv_flow_shared_qry_pk
                             primary key,
    flow_id               number not null
                             constraint wwv_flow_shdqry_flow_fk
                             references wwv_flows
                             on delete cascade,
    name                  varchar2(255) not null enable,
    security_group_id     number not null,
     --
    query_text            clob   not null,
    xml_structure         varchar2(255) constraint wwv_flow_shared_qry_xml_strc
                             check (xml_structure in (
                                 'STANDARD',
                                 'APEX'
                             )),
    report_layout_id      number,
    format                varchar2(255) constraint wwv_flow_shared_qry_format
                             check (format in (
                                 'PDF',
                                 'RTF',
                                 'XLS',
                                 'HTM',
                                 'XML'
                             )),
    format_item           varchar2(4000),
    output_file_name      varchar2(4000),
    content_disposition   varchar2(255) constraint shared_qry_content_disp
                              check (content_disposition in (
                                  'INLINE',
                                  'ATTACHMENT'
                              )),
    document_header       varchar2(255) constraint shared_qry_header
                             check (document_header in (
                                 'SERVER',
                                 'APEX'
                             )),
    xml_items             varchar2(4000),
    --
    created_on            date,
    created_by            varchar2(255),
    last_updated_on       date,
    last_updated_by       varchar2(255)
	) lob (query_text) store as (cache reads enable storage in row)
/

create unique index wwv_flow_stored_queries_uk1 on wwv_flow_shared_queries (name, flow_id)
/

create index wwv_flow_stored_qry_fid_fk on wwv_flow_shared_queries(flow_id)
/

-------------------------------
-- shared query SQL Statements
--
create table  wwv_flow_shared_qry_sql_stmts (
    id                    number
                             constraint wwv_flow_sqry_sql_pk
                             primary key,
    flow_id               number not null
                             constraint wwv_flow_sqry_sql_flow_fk
                             references wwv_flows
                             on delete cascade,
    shared_query_id       number not null
                             constraint wwv_flow_sqry_sql_sqry_fk
                             references wwv_flow_shared_queries
                             on delete cascade,
    security_group_id     number not null,
     --
    sql_statement         clob   not null,
    --
    created_on            date,
    created_by            varchar2(255),
    last_updated_on       date,
    last_updated_by       varchar2(255)
) lob (sql_statement) store as (cache reads enable storage in row)
/

create index wwv_flow_sqry_sql_fk1 on wwv_flow_shared_qry_sql_stmts(flow_id)
/

create index wwv_flow_sqry_sql_fk2 on wwv_flow_shared_qry_sql_stmts(shared_query_id)
/


----------------
-- SPELL CHECKER
--

prompt ...create wwv_flow_dictionary$ table used for spell checking


create table wwv_flow_dictionary$ (
  words                 varchar2(255),
  owner                 varchar2(50),
  language              varchar2(255),
  words_capitalized     varchar2(255),
  words_soundex         varchar2(10),
  security_group_id     number  not null
                        constraint wwv_dictionary_fk
                        references wwv_flow_companies(provisioning_company_id)
                        on delete cascade
  )
/





create unique index wwv_flow_dictionary$words on wwv_flow_dictionary$( words, owner, language, security_group_id )
/

create index wwv_flow_dictionary$caped on wwv_flow_dictionary$( words_capitalized, owner, language )
/

create index wwv_flow_dictionary$soundex on wwv_flow_dictionary$( words_soundex, language )
/




---
-- IMAGE REPOSITORY
--

prompt ...create wwv_flow_image_repository table

create table wwv_flow_image_repository (
     id                       number
                              constraint wwv_flow_image_repo_pk
                              primary key,
     flow_id                  number,
     image_name               varchar2(255) not null,
     image_tag                varchar2(270) not null,
     upper_image_name         varchar2(255) not null,
     file_object_id           number,
     national_language        varchar2(30),
     height                   number,
     width                    number,
     notes                    varchar2(4000),
     is_on_filesystem         varchar2(1),
     security_group_id        number not null
                              constraint wwv_flow_img_rep_fk
                              references wwv_flow_companies(provisioning_company_id)
                              on delete cascade)
/


create unique index wwv_flow_image_repo_idx1 on wwv_flow_image_repository (flow_id,image_name,security_group_id)
/

create index wwv_flow_image_repo_idx2 on wwv_flow_image_repository (file_object_id)
/

create index wwv_flow_image_repo_idx3 on wwv_flow_image_repository (is_on_filesystem)
/

create index wwv_flow_image_tag_idx on wwv_flow_image_repository (image_tag)
/

create index wwv_flow_image_upper_name on wwv_flow_image_repository (upper_image_name)
/


---
-- CSS REPOSITORY
--

prompt ...create wwv_flow_css_repository table

create table wwv_flow_css_repository (
    id                           number
                                 constraint wwv_flow_css_repo_pk
                                 primary key,
    flow_id                      number not null,
    security_group_id            number not null
                                 constraint wwv_flow_css_rep_fk
                                 references wwv_flow_companies(provisioning_company_id)
                                 on delete cascade,
    css_tag                      varchar2(270) not null,
    css_name                     varchar2(255) not null,
    upper_css_name               varchar2(255) not null,
    file_object_id               number,
    notes                        varchar2(4000)
    )
/

create unique index wwv_flow_css_repo_idx1 on wwv_flow_css_repository (flow_id,css_name,security_group_id)
/

create index wwv_flow_css_repo_idx2 on wwv_flow_css_repository (file_object_id)
/

create index wwv_flow_css_tag_idx on wwv_flow_css_repository (css_tag)
/

create index wwv_flow_css_upper_name on wwv_flow_css_repository (upper_css_name)
/



--
-- HTML REPOSITORY
--

prompt ...create wwv_flow_html_repository table

create table wwv_flow_html_repository (
    id                           number
                                 constraint wwv_flow_html_repo_pk
                                 primary key,
    flow_id                      number not null,
    security_group_id            number not null
                                 constraint wwv_flow_html_rep_fk
                                 references wwv_flow_companies(provisioning_company_id)
                                 on delete cascade,
    html_tag                     varchar2(270) not null,
    html_name                    varchar2(255) not null,
    upper_html_name              varchar2(255) not null,
    file_object_id               number,
    notes                        varchar2(4000)
    )
/

create unique index wwv_flow_html_repo_idx1 on wwv_flow_html_repository (flow_id,html_name,security_group_id)
/

create index wwv_flow_html_repo_idx2 on wwv_flow_html_repository (file_object_id)
/

create index wwv_flow_html_tag_idx on wwv_flow_html_repository (html_tag)
/

create index wwv_flow_html_upper_name on wwv_flow_html_repository (upper_html_name)
/



---
-- UTILITY TABLES (used for lists of values)
--

prompt ...create dual100 utilitiy table

create table wwv_flow_dual100 ( i number )
/
delete from wwv_flow_dual100;
begin
    for i in 1..100 loop
       insert into wwv_flow_dual100 values (i);
    end loop;
end;
/
commit;
grant select on wwv_flow_dual100 to public
/



--
-- The select from the 20 byte string is required for NLS support
--
create or replace view wwv_flow_months_mon_temp (month_display, month_value) as
select to_char(to_date(to_char(rownum,'00'),'MM'),'Mon') month, rownum value from wwv_flow_dual100
where rownum < 13
union all
select '                    ', 20 from dual;

create or replace view wwv_flow_months_mon (month_display, month_value) as
select * from wwv_flow_months_mon_temp where month_value < 13;

grant select on wwv_flow_months_mon to public
/



--
-- The select from the 20 byte string is required for NLS support
--

prompt ...create wwv_flow_months_month_temp view

create or replace view wwv_flow_months_month_temp (month_display, month_value) as
select to_char(to_date(to_char(rownum,'00'),'MM'),'Month') month, rownum value from wwv_flow_dual100
where rownum < 13
union all
select '                    ', 20 from dual;

create or replace view wwv_flow_months_month (month_display, month_value) as
select * from wwv_flow_months_month_temp where month_value < 13;

grant select on wwv_flow_months_month to public
/

create or replace view wwv_flow_years(year_value) as
select i+1919 from wwv_flow_dual100
union all
select i+2019 from wwv_flow_dual100 where i < 32
/

grant select on wwv_flow_years to public
/


create or replace view wwv_flow_hours_24 (hour_value) as
select i-1 from wwv_flow_dual100 where i < 25
/

grant select on wwv_flow_hours_24 to public
/


create or replace view wwv_flow_hours_12 (hour_value) as
select i from wwv_flow_dual100 where i < 13
/

grant select on wwv_flow_hours_12 to public
/

create or replace view wwv_flow_minutes_5 (minute_value) as
select (i-1)*5 from wwv_flow_dual100 where i < 13
/

grant select on wwv_flow_minutes_5 to public
/

create or replace view wwv_flow_minutes (minute_value) as
select i-1 from wwv_flow_dual100 where i < 61
/

grant select on wwv_flow_minutes to public
/


--
-- L I S T   O F   V A L U E S
--

prompt ...create wwv_flow_lov_values table

create table wwv_flow_lov_values (
    id                     number
                           constraint wwv_flow_lov_values_pk
                           primary key,
    list_owner             varchar2(255) not null,
    list_name              varchar2(255) not null,
    list_display_value     varchar2(255),
    list_return_value      varchar2(255) not null,
    list_sequence          number,
    list_disp_cond         varchar2(4000),
    list_display_cond_type varchar2(30),
    security_group_id      number not null )
/


--
-- Effective User
--

prompt ...create wwv_flow_effective_userid_map table

create table wwv_flow_effective_userid_map (
    id                     number
                           constraint wwv_flow_eff_userid_map_pk
                           primary key,
    userid                 varchar2(255) not null,
    effective_userid       varchar2(255) not null,
    flow_id                number        not null,
    security_group_id      number        not null
                           constraint wwv_flow_eff_usr_map_fk
                           references wwv_flow_companies(provisioning_company_id)
                           on delete cascade)
/

create unique index wwv_flow_eff_userid_map_idx1 on
       wwv_flow_effective_userid_map(userid, effective_userid, flow_id, security_group_id);

--
-- Shortcuts
--
prompt ...shortcuts

create table wwv_flow_shortcuts (
    id                       number
                             constraint wwv_flow_shortcuts_pk
                             primary key,
    flow_id                  number not null
                             constraint wwv_flow_shortcuts_to_flow_fk
                             references wwv_flows
                             on delete cascade,
    security_group_id        number not null,
    shortcut_name            varchar2(255) not null,
    shortcut_consideration_seq number,
    shortcut_type            varchar2(30)
                             constraint wwv_flow_valid_shortcut_type
                             check (shortcut_type in (
                             'HTML_TEXT',
                             'HTML_TEXT_ESCAPE_SC',
                             'FUNCTION_BODY',
                             'IMAGE',
                             'MESSAGE',
                             'MESSAGE_ESCAPE_JS',
                             'TEXT_ESCAPE_JS')),
    shortcut_condition_type1 varchar2(255),
    shortcut_condition1      varchar2(4000),
    shortcut_condition_type2 varchar2(255),
    shortcut_condition2      varchar2(4000),
    build_option             number,
    error_text               varchar2(4000),
    shortcut                 clob,
    reference_id             number,
    last_updated_by          varchar2(255),
    last_updated_on          date,
    comments                 varchar2(4000)
    ) lob (shortcut) store as (cache reads enable storage in row)
/

create unique index wwv_flow_shortcut_idx1 on wwv_flow_shortcuts (flow_id, shortcut_name, shortcut_consideration_seq)
/



create table wwv_flow_shortcut_usage_map (
    shortcut_id               number,
    flow_id                   number,
    reference_id              number,
    reference_id_type         varchar2(30)
                              check (reference_id_type in (
                              'PAGE_HELP',
                              'ITEM_PROMPT',
                              'PAGE_PROCESS',
                              'REGION_TEMPLATE',
                              'PAGE_TEMPLATE',
                              'ROW_TEMPLATE',
                              'LIST_TEMPLATE',
                              'FLOW_PROCESS')),
    security_group_id         number not null
    )
/





create global temporary table wwv_flow_temp_table (
   r    number,
   c001 varchar2(4000),
   c002 varchar2(4000),
   c003 varchar2(4000),
   c004 varchar2(4000),
   c005 varchar2(4000),
   c006 varchar2(4000),
   c007 varchar2(4000),
   c008 varchar2(4000),
   c009 varchar2(4000),
   c010 varchar2(4000),
   c011 varchar2(4000),
   c012 varchar2(4000),
   c013 varchar2(4000),
   c014 varchar2(4000),
   c015 varchar2(4000),
   c016 varchar2(4000),
   c017 varchar2(4000),
   c018 varchar2(4000),
   c019 varchar2(4000),
   c020 varchar2(4000),
   c021 varchar2(4000),
   c022 varchar2(4000),
   c023 varchar2(4000),
   c024 varchar2(4000),
   c025 varchar2(4000),
   c026 varchar2(4000),
   c027 varchar2(4000),
   c028 varchar2(4000),
   c029 varchar2(4000),
   c030 varchar2(4000),
   c031 varchar2(4000),
   c032 varchar2(4000),
   c033 varchar2(4000),
   c034 varchar2(4000),
   c035 varchar2(4000),
   c036 varchar2(4000),
   c037 varchar2(4000),
   c038 varchar2(4000),
   c039 varchar2(4000),
   c040 varchar2(4000),
   c041 varchar2(4000),
   c042 varchar2(4000),
   c043 varchar2(4000),
   c044 varchar2(4000),
   c045 varchar2(4000),
   c046 varchar2(4000),
   c047 varchar2(4000),
   c048 varchar2(4000),
   c049 varchar2(4000),
   c050 varchar2(4000),
   c051 varchar2(4000),
   c052 varchar2(4000),
   c053 varchar2(4000),
   c054 varchar2(4000),
   c055 varchar2(4000),
   c056 varchar2(4000),
   c057 varchar2(4000),
   c058 varchar2(4000),
   c059 varchar2(4000),
   c060 varchar2(4000),
   c061 varchar2(4000),
   c062 varchar2(4000),
   c063 varchar2(4000),
   c064 varchar2(4000),
   c065 varchar2(4000)
   )
/



prompt ...create wwv_flow_mail_log

create table wwv_flow_mail_log(
  mail_to              varchar2(2000),
  mail_from            varchar2(2000),
  mail_replyto         varchar2(2000),
  mail_subj            varchar2(2000),
  mail_cc              varchar2(2000),
  mail_bcc             varchar2(2000),
  mail_send_error      varchar2(4000),
  last_updated_by      varchar2(255),
  last_updated_on      date,
  security_group_id    number not null
)
/


create index wwv_flow_mail_log_idx1 on wwv_flow_mail_log( substr(mail_to,1,500) )
/

create index wwv_flow_mail_log_idx2 on wwv_flow_mail_log( last_updated_by )
/

create index wwv_flow_mail_log_idx3 on wwv_flow_mail_log( security_group_id )
/


create or replace view wwv_flow_user_mail_log as
    select mail_to, mail_from, mail_replyto, mail_subj, mail_cc, mail_bcc, mail_send_error, last_updated_on
      from wwv_flow_mail_log
     where security_group_id = (select wwv_flow.get_sgid from dual where rownum = 1)
/


prompt ...create wwv_flow_mail_queue

create table wwv_flow_mail_queue
(
  id number constraint wwv_flow_mail_queue_pk
                       primary key,
  mail_to              varchar2(2000),
  mail_from            varchar2(2000),
  mail_replyto         varchar2(2000),
  mail_subj            varchar2(2000),
  mail_cc              varchar2(2000),
  mail_bcc             varchar2(2000),
  mail_body            clob,
  mail_body_html       clob,
  mail_send_count      number(2),
  mail_send_error      varchar2(4000),
  includes_html        number(1) default 0,
  last_updated_by      varchar2(255),
  last_updated_on      date,
  security_group_id    number not null
)
/

create or replace view wwv_flow_user_mail_queue as
    select id, mail_to, mail_from, mail_replyto, mail_subj, mail_cc, mail_bcc, mail_body, mail_body_html, mail_send_count, mail_send_error, last_updated_by, last_updated_on
      from wwv_flow_mail_queue
     where security_group_id = (select wwv_flow.get_sgid from dual where rownum = 1)
/

create index wwv_flow_mail_queue_idx1 on wwv_flow_mail_queue( security_group_id )
/

grant delete on wwv_flow_user_mail_queue to public
/

create table wwv_flow_mail_attachments
(
  id number constraint wwv_flow_mail_attachments_pk
                       primary key,
  mail_id              number not null
                           constraint wwv_flow_mail_attachments_fk1
                           references wwv_flow_mail_queue(id)
                           on delete cascade,
  filename             varchar2(4000) not null,
  mime_type            varchar2(48)   not null,
  inline               varchar2(1)    not null
                           constraint wwv_flow_mail_attachments_ck1
                           check (inline in ('Y','N')),
  attachment           blob,
  last_updated_by      varchar2(255),
  last_updated_on      date,
  security_group_id    number not null
)
/

create index wwv_flow_mail_attachments_idx1 on wwv_flow_mail_attachments( mail_id, security_group_id )
/


create or replace view wwv_flow_user_mail_attachments as
    select id, mail_id, filename, mime_type, inline, attachment, last_updated_by, last_updated_on
      from wwv_flow_mail_attachments
     where security_group_id = (select wwv_flow.get_sgid from dual where rownum = 1)
/

grant delete on wwv_flow_user_mail_attachments to public
/


--
-- S Q L   W O R K S H O P
--
prompt ... create wwv_flow_file_object_id

create or replace package wwv_flow_file_object_id
is
   g_id number;
end;
/
show errors


prompt ...create wwv_flow_files
-- may need to remove later, tmuth
create or replace view wwv_flow_files as
  select id, flow_id, name, filename, title, mime_type, doc_size, dad_charset,
         created_by, created_on, updated_by, updated_on, last_updated, content_type,
         blob_content, language, description, file_type, file_charset
    from wwv_flow_file_objects$
   where security_group_id = wwv_flow.get_sgid and security_group_id <> 0;



prompt ...create wwv_flow_file_objects$part

-- may need to remove later, tmuth
create table wwv_flow_file_objects$part(
  document varchar2(350) not null,
  part varchar2(350) not null,
  uploaded char(1)
  )
/



prompt ...create wwv_flow_sw_binds

create table wwv_flow_sw_binds (
    id                   number
                         constraint wwv_flow_sw_bind_pk
                         primary key,
    file_id              number not null
                         constraint wwv_flow_sw_bind_fk
                         references flows_files.wwv_flow_file_objects$(id)
                         on delete cascade,
    stmt_num             number not null,
    bind_type            varchar2(255)
                         constraint wwv_valid_bind_type
                         check (bind_type in (
                         'BIND',
                         'SUBSTITUTION')),
    name                 varchar2(255),
    value                varchar2(4000),
    security_group_id    number not null
                         constraint wwv_flow_sw_bind_fk2
                         references wwv_flow_companies(provisioning_company_id)
                         on delete cascade
    )
/

create index wwv_flow_sw_bind_idx1 on wwv_flow_sw_binds (file_id)
/
create index wwv_flow_sw_bind_idx2 on wwv_flow_sw_binds (security_group_id)
/


prompt ...create wwv_flow_sw_results

create table wwv_flow_sw_results (
    id                    number
                          constraint wwv_flow_sw_result_pk
                          primary key,
    file_id               number not null
                          constraint wwv_flow_sw_result_fk
                          references flows_files.wwv_flow_file_objects$(id)
                          on delete cascade,
    job_id                number,
    run_by                varchar2(255) not null,
    run_as                varchar2(255) not null,
    started               date not null,
    start_time            number not null,
    ended                 date,
    end_time              number,
    status                varchar2(255)
                          constraint wwv_flow_result_status
                          check (status in (
                          'SUBMITTED',
                          'EXECUTING',
                          'COMPLETE',
                          'CANCELED',
                          'CANCELING')),
    run_comments          varchar2(4000),
    security_group_id     number not null
                          constraint wwv_flow_sw_result_fk2
                          references wwv_flow_companies(provisioning_company_id)
                          on delete cascade
    )
/

create index wwv_flow_sw_result_idx1 on wwv_flow_sw_results (file_id)
/
create index wwv_flow_sw_result_idx2 on wwv_flow_sw_results (security_group_id)
/
create unique index wwv_flow_sw_result_idx3 on wwv_flow_sw_results(security_group_id,id,status) compress 1
/



prompt ...create wwv_flow_sw_detail_results

create table wwv_flow_sw_detail_results (
    id                    number
                          constraint wwv_flow_sw_d_result_pk
                          primary key,
    result_id             number not null
                          constraint wwv_flow_sw_d_result_fk
                          references wwv_flow_sw_results(id)
                          on delete cascade,
    file_id               number not null,
    seq_id                number not null,
    stmt_num              number not null,
    stmt_text             clob default empty_clob(),
    result                clob default empty_clob(),
    result_size           number,
    result_rows           number,
    msg                   varchar2(4000),
    success               varchar2(1) default 'N'
                          constraint wwv_run_success_flg
                          check (success in (
                          'Y',
                          'N')),
    failure               varchar2(1) default 'N'
                          constraint wwv_run_failure_flag
                          check (failure in (
                          'Y',
                          'N')),
    started               date not null,
    start_time            number not null,
    ended                 date,
    end_time              number,
    run_complete          varchar2(1) default 'N'
                          constraint wwv_stmt_run_complete_flag
                          check (run_complete in (
                          'Y',
                          'N')),
    last_updated          date,
    security_group_id     number not null
                          constraint wwv_flow_sw_d_result_fk2
                          references wwv_flow_companies(provisioning_company_id)
                          on delete cascade
    ) lob (stmt_text) store as (cache reads enable storage in row)
/

create index wwv_flow_sw_d_result_idx1 on wwv_flow_sw_detail_results (result_id)
/
create index wwv_flow_sw_d_result_idx2 on wwv_flow_sw_detail_results (security_group_id)
/
create index wwv_flow_sw_d_result_idx3 on wwv_flow_sw_detail_results(security_group_id,result_id,file_id) compress 2
/



prompt ...create wwv_flow_sw_sqlplus_cmd

create table wwv_flow_sw_sqlplus_cmd (
    command                varchar2(30) primary key
    )
/

prompt ...create wwv_flow_sw_sql_cmds

create table wwv_flow_sw_sql_cmds (
    id                              number
                                    constraint wwv_flow_sw_sql_cmds_pk
                                    primary key,
    command             clob,
    parsed_schema           varchar2(30),
    created_by                      varchar2(255),
    created_on                      date,
    security_group_id               number not null
                                    constraint WWV_FLOW_SW_SQL_CMDS_fk
                                    references wwv_flow_companies(provisioning_company_id)
                                    on delete cascade
    )
/



--
-- Parser output table.  Will store each line of the statement.
--
prompt ...create wwv_flow_sw_stmts
create table wwv_flow_sw_stmts (
   id                  number
                       constraint wwv_flow_sw_stmts_pk
                       primary key,
   file_id             number not null
                       constraint wwv_flow_sw_stmts_fk
                       references flows_files.wwv_flow_file_objects$(id)
                       on delete cascade,
   stmt_number         number,
   src_line_number     number,
   offset              number,
   length              number,
   stmt_class          number,
   stmt_id             number,
   isrunnable          varchar2(1),
   stmt                clob,
   security_group_id   number not null
                       constraint wwv_flow_sw_stmts_fk2
                       references wwv_flow_companies(provisioning_company_id)
                       on delete cascade
  );

create index wwv_flow_sw_stmts_idx on wwv_flow_sw_stmts (file_id);
create index wwv_flow_sw_stmts_idx2 on wwv_flow_sw_stmts (security_group_id);
create index wwv_flow_sw_stmts_idx3 on wwv_flow_sw_stmts(security_group_id,file_id,isrunnable,stmt_id,stmt_number) compress 2;



--
-- Holds the list of non special-character first keywords
--
prompt ...create wwv_flow_sw_main_keywords
create table wwv_flow_sw_main_keywords (
    id         number
               constraint wwv_flow_sw_mkeywords_pk
               primary key,
    keyword    VARCHAR2(20),
    stmt_class INTEGER,
    stmt_id    INTEGER,
    isrunnable VARCHAR2(1)
  );

create unique index wwv_flow_sw_mkeywords_idx on wwv_flow_sw_main_keywords (keyword);

--
-- Holds the list of second keywords for SQL SET commands.
--
prompt ...create wwv_flow_sw_set_keywords
create table wwv_flow_sw_set_keywords (
    id         number
               constraint wwv_flow_sw_skeywords_pk
               primary key,
    keyword    VARCHAR2(20),
    stmt_class INTEGER,
    stmt_id    INTEGER,
    isrunnable VARCHAR2(1)
  );

create unique index wwv_flow_sw_skeywords_idx on wwv_flow_sw_set_keywords (keyword);


--
-- Holds the list of second keywords for PL/SQL CREATE commands.
--
prompt ...create wwv_flow_sw_create_keywords
create table wwv_flow_sw_create_keywords (
    id         number
               constraint wwv_flow_sw_ckeywords_pk
               primary key,
    keyword    VARCHAR2(20),
    stmt_class INTEGER,
    stmt_id    INTEGER,
    isrunnable VARCHAR2(1)
  );

create unique index wwv_flow_sw_ckeywords_idx on wwv_flow_sw_create_keywords (keyword);


------------------------------------------
-- J O B S
--

create table wwv_flow_jobs (
  id                            number,
  job                           number,
  flow_id                       number,
  security_group_id             number not null,
  owner                         varchar2(30),
  enduser                       varchar2(255),
  created                       date,
  modified                      date,
  completed                     date,
  status                        varchar2(100),
  system_status                 varchar2(4000),
  system_modified               date,
  what                          clob   not null)
/

alter table wwv_flow_jobs
add constraint wwv_flow_jobs_pk
primary key (job)
/

create index wwv_flow_jobs_sgid_idx
on wwv_flow_jobs (security_group_id)
/

create index wwv_flow_jobs_comp_idx
on wwv_flow_jobs (completed)
/


--
-- IOTs must have the primary key inline, as you can't
-- create an index-organized table w/o a primary key
--
--

create table wwv_flow_job_bind_values (
  job                           number,
  name                          varchar2(200),
  value                         varchar2(3125),
  primary key (job,name)
)
organization index
tablespace ^8
including value
overflow tablespace ^8
/


create or replace view wwv_flow_plsql_jobs as
  select id, job, flow_id, owner, enduser, created, modified,
         status, system_status, system_modified, security_group_id
    from wwv_flow_jobs
   where security_group_id = (select nv('FLOW_SECURITY_GROUP_ID') sgid from dual)
/


--
-- Duplicate Page Submision Prevension
--

create table wwv_flow_page_submissions (
    submit_id          number
                       constraint wwv_flow_page_submissions_pk
                       primary key,
    security_group_id  number not null,
    flow_id            number not null
                       constraint wwv_flow_page_sub_fk
                       references wwv_flows on delete cascade,
    page_id            number,
    session_id         number)
/

create index wwv_flow_page_sub_idx1 on wwv_flow_page_submissions (flow_id)
/

----------------------------
-- I M P O R T   E X P O R T
--
-- This is where the import and export "jobs" go. The java gets the information
-- from here and processes it. Output goes here AND to WWV_FLOW_FILE_OBJECTS$
--

prompt ...wwv_flow_import_export

create table wwv_flow_import_export (
      id                number
                        constraint wwv_flow_imp_exp_pk
                        primary key,
      security_group_id number not null
                        constraint wwv_flow_imp_exp_fk
                        references wwv_flow_companies(provisioning_company_id)
                        on delete cascade,
      data_id           number,
      job_id            number,
      parms             varchar2(4000),
      schema_name       varchar2(30),
      run_mode          varchar2(1),
      timeout           number           default 900,
      return_code       number           default null,
      created_by        varchar2(100),
      created_by_id     number,
      started           date             default null,
      ended             date             default null,
      result            clob             default empty_clob(),
                        constraint wwv_flow_import_export_fk foreign key (data_id)
                        references flows_files.wwv_flow_file_objects$(id))
/

prompt ...wwv_flow_platform_pref

create table wwv_flow_platform_pref (
      id          number           primary key,
      name        varchar2(255)    not null unique,
      value       varchar2(4000)   not null)
/



------------------------
-- C O L L E C T I O N S
--
create table wwv_flow_collections$ (
   id                 number        not null,
   session_id         number        not null,
   user_id            varchar2(255) not null,
   flow_id            number        not null,
   collection_name    varchar2(255) not null,
   collection_changed varchar2(10)  not null,
   created_on         date          not null,
   security_group_id  number        not null
   )
/


alter table wwv_flow_collections$
    add constraint wwv_flow_collections_pk
    primary key(id)
/

alter table wwv_flow_collections$
    add constraint wwv_flow_collections_uk
    unique(session_id, user_id, flow_id, collection_name, security_group_id)
/


alter table wwv_flow_collections$
    add constraint wwv_flow_collection_fk
    foreign key( session_id ) references wwv_flow_sessions$(id)
    on delete cascade
/


create table wwv_flow_collection_members$ (
   collection_id     number        not null,
   seq_id            number        not null,
   c001              varchar2(4000),
   c002              varchar2(4000),
   c003              varchar2(4000),
   c004              varchar2(4000),
   c005              varchar2(4000),
   c006              varchar2(4000),
   c007              varchar2(4000),
   c008              varchar2(4000),
   c009              varchar2(4000),
   c010              varchar2(4000),
   c011              varchar2(4000),
   c012              varchar2(4000),
   c013              varchar2(4000),
   c014              varchar2(4000),
   c015              varchar2(4000),
   c016              varchar2(4000),
   c017              varchar2(4000),
   c018              varchar2(4000),
   c019              varchar2(4000),
   c020              varchar2(4000),
   c021              varchar2(4000),
   c022              varchar2(4000),
   c023              varchar2(4000),
   c024              varchar2(4000),
   c025              varchar2(4000),
   c026              varchar2(4000),
   c027              varchar2(4000),
   c028              varchar2(4000),
   c029              varchar2(4000),
   c030              varchar2(4000),
   c031              varchar2(4000),
   c032              varchar2(4000),
   c033              varchar2(4000),
   c034              varchar2(4000),
   c035              varchar2(4000),
   c036              varchar2(4000),
   c037              varchar2(4000),
   c038              varchar2(4000),
   c039              varchar2(4000),
   c040              varchar2(4000),
   c041              varchar2(4000),
   c042              varchar2(4000),
   c043              varchar2(4000),
   c044              varchar2(4000),
   c045              varchar2(4000),
   c046              varchar2(4000),
   c047              varchar2(4000),
   c048              varchar2(4000),
   c049              varchar2(4000),
   c050              varchar2(4000),
   clob001           clob default empty_clob(),
   md5_original      varchar2(4000),
   security_group_id number not null
   )  lob (clob001) store as (cache reads enable storage in row)
/

alter table wwv_flow_collection_members$
    add constraint wwv_flow_collection_members_pk
    primary key(collection_id, seq_id, security_group_id)
/

alter table wwv_flow_collection_members$
    add constraint wwv_flow_collection_membes_fk
    foreign key( collection_id ) references wwv_flow_collections$(id)
    on delete cascade
/



--
-- Primary View accessible to users
--
--
-- Primary View accessible to users
--
create or replace view wwv_flow_collections as
    select c.collection_name, m.seq_id, m.c001, m.c002, m.c003, m.c004, m.c005, m.c006, m.c007,
           m.c008, m.c009, m.c010, m.c011, m.c012, m.c013, m.c014, m.c015, m.c016, m.c017,
           m.c018, m.c019, m.c020, m.c021, m.c022, m.c023, m.c024, m.c025, m.c026, m.c027,
           m.c028, m.c029, m.c030, m.c031, m.c032, m.c033, m.c034, m.c035, m.c036, m.c037,
           m.c038, m.c039, m.c040, m.c041, m.c042, m.c043, m.c044, m.c045, m.c046, m.c047,
           m.c048, m.c049, m.c050, m.clob001, m.md5_original
      from wwv_flow_collections$ c, wwv_flow_collection_members$ m
     where c.session_id = (select v('SESSION') from dual)
       and c.security_group_id = (select wwv_flow.get_sgid from dual)
       and c.id = m.collection_id
       and c.flow_id = (select nv('FLOW_ID') from dual)
/





--------------------------------
-- U S E R  M A N A G E M E N T
-- APPS TABLES
--

create table wwv_flow_fnd_user (
    USER_ID                                  NUMBER not null
                                             constraint wwv_flow_fnd_user_pk
                                             unique,
    USER_NAME                                VARCHAR2(100) not null,
    FIRST_NAME                               VARCHAR2(255),
    LAST_NAME                                VARCHAR2(255),
    KNOWN_AS                                 VARCHAR2(255),
    LAST_UPDATE_DATE                         DATE not null,
    LAST_UPDATED_BY                          varchar2(255),
    CREATION_DATE                            DATE not null,
    CREATED_BY                               varchar2(255),
    START_DATE                               DATE,
    END_DATE                                 DATE,
    DESCRIPTION                              VARCHAR2(240),
    PASSWORD_DATE                            DATE,
    PASSWORD_ACCESSES_LEFT                   NUMBER(15),
    PASSWORD_LIFESPAN_ACCESSES               NUMBER(15),
    PASSWORD_LIFESPAN_DAYS                   NUMBER(15),
    EMPLOYEE_ID                              NUMBER(15),
    PERSON_TYPE                              VARCHAR2(1),
    EMAIL_ADDRESS                            VARCHAR2(240),
    person_id                                number,
    security_group_id                        number not null
                                             constraint wwv_flow_fnd_user_fk
                                             references wwv_flow_companies(provisioning_company_id)
                                             on delete cascade,
    web_password                             varchar2(255),
    web_password2                            raw(255),
    web_password_raw                         raw(255),
    default_schema                           varchar2(30),
    allow_access_to_schemas                  varchar2(4000),
    attribute_01                             varchar2(4000),
    attribute_02                             varchar2(4000),
    attribute_03                             varchar2(4000),
    attribute_04                             varchar2(4000),
    attribute_05                             varchar2(4000),
    attribute_06                             varchar2(4000),
    attribute_07                             varchar2(4000),
    attribute_08                             varchar2(4000),
    attribute_09                             varchar2(4000),
    attribute_10                             varchar2(4000),
    last_login                               date,
    builder_login_count                      number,
    last_agent                               varchar2(4000),
    last_ip                                  varchar2(4000),
    account_locked                           varchar2(1)
                                             constraint fnd_user_account_locked
                                             check (account_locked in ('Y','N')),
    account_expiry                           date,
    failed_access_attempts                   number,
    last_failed_login                        date,
    first_password_use_occurred              varchar2(1)
                                             constraint fnd_user_first_pw_use
                                             check (first_password_use_occurred in ('Y','N')),
    change_password_on_first_use             varchar2(1)
                                             constraint fnd_user_change_pw_on_first
                                             check (change_password_on_first_use in ('Y','N'))
    )
/

create table wwv_flow_password_history (
    id                                       number primary key,
    user_id                                  number 
                                             constraint wwv_flow_pwhist_uid_fk
                                             references wwv_flow_fnd_user(user_id)
                                             on delete cascade,
    password                                 raw(255),
    created                                  date,
    security_group_id                        number not null
                                             constraint wwv_flow_pwhist_sgid_fk
                                             references wwv_flow_companies(provisioning_company_id)
                                             on delete cascade    
    )
/    

create index wwv_flow_passwd_history_fkidx1 on wwv_flow_password_history(security_group_id)
/
create index wwv_flow_passwd_history_fkidx2 on wwv_flow_password_history(user_id)
/

prompt ...wwv_flow_fnd_user_pw_pref package

create or replace package wwv_flow_fnd_user_pw_pref
as
    web_password_format varchar2(255) := 'CLEAR_TEXT';
end wwv_flow_fnd_user_pw_pref;
/
show errors

prompt ...wwv_flow_fnd_user_groups table

create table wwv_flow_fnd_user_groups (
    id                  number
                        constraint fnd_flow_user_group_pk
                        primary key,
    group_name          varchar2(255) not null,
    security_group_id   number not null
                        constraint wwv_flow_fnd_user_grps_fk
                        references wwv_flow_companies(provisioning_company_id)
                        on delete cascade,
    group_desc          varchar2(4000)
    )
/


prompt ...wwv_flow_fnd_group_users table

create table wwv_flow_fnd_group_users (
    group_id   number not null
               constraint wwv_flow_fnd_gu_int_g_fk
               references wwv_flow_fnd_user_groups (id)
               on delete cascade,
    user_id    number not null
               constraint wwv_flow_fnd_gu_int_u_fk
               references wwv_flow_fnd_user (user_id)
               on delete cascade,
    security_group_id number not null)
/



------------------------------
-- D B   A U T H   T A B L E S
--
prompt ...wwv_flow_db_auth

create table wwv_flow_db_auth (
    db_auth_schema     varchar2(30)
                       constraint wwv_flow_db_auth_pk
                       primary key,
    security_group_id  number  not null
                       constraint wwv_flow_db_auth_fk
                       references wwv_flow_companies(provisioning_company_id)
                       on delete cascade)
/



-------------------------------
-- UPDATEABLE report attributes
--

prompt ...wwv_flow_region_upd_rpt_cols

create table wwv_flow_region_upd_rpt_cols (
    id                           number
                                 constraint wwv_flow_upd_rpt_col
                                 primary key,
    flow_id                      number not null
                                 constraint wwv_flow_urc_to_flow_fk
                                 references wwv_flows
                                 on delete cascade,
    security_group_id            number not null,
    plug_id                      number not null,
    column_sequence              number not null,
    query_column_name            varchar2(255),
    display_as                   varchar2(255)
                                 constraint wwv_flow_upc_display_as
                                 check ( display_as in (
                                 'DISPLAY_AND_SAVE',
                                 'WITHOUT_MODIFICATION',
                                 'ESCAPE_SC',
                                 'TEXT',
                                 'TEXTAREA',
                                 'SELECT_LIST',
                                 'SELECT_LIST_FROM_LOV',
                                 'SELECT_LIST_FROM_QUERY',
                                 'HIDDEN',
                                 'POPUP',
                                 'DATE_POPUP'
                                 )),
    named_lov                    number,
    inline_lov                   varchar2(4000),
    lov_show_nulls               varchar2(3)
                                 constraint wwv_flow_upd_rpt_cols_lovn
                                 check (lov_show_nulls in (
                                 'YES',
                                 'NO')),
    lov_null_text                varchar2(255),
    lov_null_value               varchar2(255),
    column_width                 number,
    column_height                number,
    cattributes                  varchar2(4000),
    cattributes_element          varchar2(4000),
    column_comment               varchar2(4000)
    )
/

create unique index wwv_flow_region_upd_rpt_ci1 on wwv_flow_region_upd_rpt_cols (plug_id,query_column_name);
create index wwv_flow_region_upd_rpt_ci2 on wwv_flow_region_upd_rpt_cols (plug_id,column_sequence);
create index wwv_flow_region_upd_rpt_ci3 on wwv_flow_region_upd_rpt_cols (flow_id)
/

alter table wwv_flow_region_upd_rpt_cols
    add constraint wwv_flow_urc_to_plug_fk
        foreign key (plug_id)
        references wwv_flow_page_plugs (id)
        on delete cascade
/

create table wwv_flow_templates$ (
    id                        number
                              constraint wwv_flow_tmps_pk
                              primary key,
    short_name                varchar2(255)  not null,
    template_name             varchar2(255)  not null,
    template_proc             varchar2(4000) not null,
    template_type             varchar2(255)  not null
                              constraint wwv_flow_tmplt_type
                              check (template_type in(
                              'Page',
                              'Region',
                              'List',
                              'Field',
                              'Report',
                              'Button',
                              'Menu',
                              'PopUp')),
    theme                     number,
    preview_link              varchar2(4000)
    )
/

create unique index wwv_flow_tmps_unique on wwv_flow_templates$ (template_name)
/

create unique index wwv_flow_tmps_unique_sn on wwv_flow_templates$ (short_name)
/



create table wwv_flow_template_themes$(
    id                          number
                                constraint wwv_fl_tmp_thm_pk
                                primary key,
    name                        varchar2(255),
    required_css                varchar2(255)
    )
/


-----------------------------------------
-- C L I C K T H R U  L O G
--
create table wwv_flow_clickthru_log_number$ (
    current_log_number     number not null
                           check (current_log_number in (1,2)),
    current_log_timestamp  date   not null,
    minimum_retained_days  number not null
    )
/

insert into wwv_flow_clickthru_log_number$(current_log_number, current_log_timestamp, minimum_retained_days)
    select 1, sysdate, 14 from dual where 0 = (select count(*) from wwv_flow_clickthru_log_number$)
/


create table wwv_flow_clickthru_log$ (
    clickdate           date,
    category            varchar2(255),
    id                  number,
    flow_user           varchar2(255),
    ip                  varchar2(30),
    security_group_id   number not null
    )
/

create table wwv_flow_clickthru_log2$ (
    clickdate           date,
    category            varchar2(255),
    id                  number,
    flow_user           varchar2(255),
    ip                  varchar2(30),
    security_group_id   number not null
    )
/

create or replace view wwv_flow_clickthru_log_v as
    select clickdate, category, id, flow_user, ip, security_group_id
      from wwv_flow_clickthru_log$
    union all
    select clickdate, category, id, flow_user, ip, security_group_id
      from wwv_flow_clickthru_log2$
/

create or replace view wwv_flow_clickthru_log as
    select clickdate, category, id, flow_user, ip
      from wwv_flow_clickthru_log_v
     where security_group_id = (select wwv_flow.get_sgid from dual)
/


--
-- views for lists of values
--
create or replace view wwv_flow_tabset_view as
select tab_set ||
       replace(' ('||
       max(decode(seq,1,tab_text,null))||
       max(decode(seq,2,', '||tab_text,null))||
       max(decode(seq,3,', '||tab_text,null))||
       max(decode(seq,4,'...',null))||
       ')','&'||'nbsp;',' ') d,
       tab_set r
from (
select tab_set, tab_text, tab_sequence, row_number() over (partition by tab_set order by tab_sequence nulls last) seq
from wwv_flow_tabs
where flow_id = (select v('FB_FLOW_ID') from dual) ) x
group by tab_set
/



create or replace view wwv_flow_tabset_view2 as
select d,r from(
    select tab_set ||
           replace(' ('||
           max(decode(seq,1,tab_text,null))||
           max(decode(seq,2,', '||tab_text,null))||
           max(decode(seq,3,', '||tab_text,null))||
           max(decode(seq,4,'...',null))||
           ')','&'||'nbsp;',' ') d,
           tab_set r, 1 ob
    from (
    select tab_set, tab_text, tab_sequence, row_number() over (partition by tab_set order by tab_sequence nulls last) seq
    from wwv_flow_tabs
    where flow_id = (select v('FB_FLOW_ID') from dual) ) x
    group by tab_set
    union
    (select CURRENT_ON_TABSET d,CURRENT_ON_TABSET r, 2 ob
       from wwv_flow_toplevel_tabs
      where flow_id = (select v('FB_FLOW_ID') from dual)
      minus
     select tab_set d,tab_set r,2 ob
       from wwv_flow_tabs
      where flow_id = (select v('FB_FLOW_ID') from dual) )
    )
order by ob
/



create table wwv_flow_popup_lov_template (
    id                 number
                       constraint wwv_flow_pk_poplov_temp
                       primary key,
    security_group_id  number not null,
    flow_id            number
                       constraint wwv_flow_fk_poplov_temp
                       references wwv_flows
                       on delete cascade,
    --
    popup_icon         varchar2(4000) default '#IMAGE_PREFIX#list.gif',
    popup_icon_attr    varchar2(4000) default 'width="13" height="13"',
    popup_icon2        varchar2(4000) default null,
    popup_icon_attr2   varchar2(4000) default null,
    --
    page_name          varchar2(255)  default 'winlov',
    page_title         varchar2(255)  default 'Search Dialog',
    page_html_head     varchar2(4000) default '<link rel="stylesheet" href="#IMAGE_PREFIX#platform2.css" type="text/css">',
    page_body_attr     varchar2(255)  default 'bgcolor="white" OnLoad="first_field()"',
    before_field_text  varchar2(4000) default ' ',
    after_field_text   varchar2(4000) default '</div><br />',
    page_heading_text  varchar2(4000) default '<link rel="stylesheet" href="#IMAGE_PREFIX#platform2.css" type="text/css"><style>a:link { color:#336699; text-decoration:none; padding:2px;} a:visited { color:#336699; text-decoration:none;} a:hover { color:red; text-decoration:underline;} body { font-family:arial; background-color:#ffffff;} </style>',
    page_footer_text   varchar2(4000) default '</center></td></tr></table>',
    --
    before_result_set  varchar2(4000) default '',
    after_result_set   varchar2(4000) default '',
    --
    filter_width       varchar2(255)  default '20',
    filter_max_width   varchar2(255)  default '100',
    filter_text_attr   varchar2(4000) default null,
    --
    find_button_text   varchar2(255)  default 'Search',
    find_button_image  varchar2(255)  default null,
    find_button_attr   varchar2(4000) default '',
    --
    close_button_text  varchar2(255)  default 'Close',
    close_button_image varchar2(255)  default null,
    close_button_attr  varchar2(4000) default '',
    --
    next_button_text   varchar2(255)  default 'Next',
    next_button_image  varchar2(255)  default null,
    next_button_attr   varchar2(4000) default '',
    --
    prev_button_text   varchar2(255)  default 'Previous',
    prev_button_image  varchar2(255)  default null,
    prev_button_attr   varchar2(4000) default '',
    --
    --
    scrollbars         varchar2(255)  default '1',
    resizable          varchar2(255)  default '1',
    width              varchar2(255)  default '400',
    height             varchar2(255)  default '450',
    --
    result_row_x_of_y  varchar2(255)  default 'Row(s) #FIRST_ROW# - #LAST_ROW',
    result_rows_per_pg number         default 10,
    --
    when_no_data_found_message   varchar2(4000),
    before_first_fetch_message   varchar2(4000),
    minimum_characters_required  number,
    --
    theme_id                      number,
    theme_class_id                number,
    reference_id       number,
    --
    last_updated_on    date,
    last_updated_by    varchar2(255),
    translate_this_template       varchar2(1)
                                    constraint wwv_flow_popup_trans_temp
                                    check (translate_this_template in ('Y','N')),
    template_comment   varchar2(4000)
    )
/

create index wwv_flow_poplov_temp_idx1 on wwv_flow_popup_lov_template (security_group_id, reference_id)
/
create unique index wwv_flow_lovt_u_flow_id on wwv_flow_popup_lov_template (flow_id,theme_id)
/



------------------------------------
--   M E N U S
--
prompt ...create wwv_flow_menus table


create table wwv_flow_menus (
     id                       number
                              constraint wwv_flow_menus_pk
                              primary key,
     flow_id                  number not null
                              constraint wwv_flow_menus_flow_fk
                              references wwv_flows
                              on delete cascade,
     name                     varchar2(255) not null,
     security_group_id        number not null,
     last_updated_by          varchar2(255),
     last_updated_on          date,
     menu_comment             varchar2(4000)
     )
/

create index wwv_flow_menus_idx1 on wwv_flow_menus (flow_id)
/

create table wwv_flow_menu_options (
     id                       number
                              constraint wwv_flow_menu_opts_pk
                              primary key,
     parent_id                number,
     menu_id                  number not null
                              constraint wwv_flow_opt_menus_fk
                              references wwv_flow_menus
                              on delete cascade,
     flow_id                  number,
     option_sequence          number,
     short_name               varchar2(255) not null,
     long_name                varchar2(4000),
     link                     varchar2(4000),
     page_id                  number,
     also_current_for_pages   varchar2(4000),
     display_when_cond_type   varchar2(255),
     display_when_condition   varchar2(4000),
     display_when_condition2  varchar2(4000),
     security_scheme          varchar2(255),
     required_patch           number,
     security_group_id        number not null,
     last_updated_by          varchar2(255),
     last_updated_on          date,
     menu_option_comment      varchar2(4000)
     )
/

create unique index wwv_flow_unique_menu_opt on wwv_flow_menu_options (menu_id, page_id);

create index wwv_flow_menu_opt_idx1 on wwv_flow_menu_options (flow_id, id);

create table wwv_flow_menu_templates (
     id                       number
                              constraint wwv_flow_menu_templs_pk
                              primary key,
     flow_id                  number not null
                              constraint wwv_flow_menus_t_flow_fk
                              references wwv_flows
                              on delete cascade,
     name                     varchar2(255) not null,
     --
     before_first             varchar2(4000),
     current_page_option      varchar2(4000),
     non_current_page_option  varchar2(4000),
     menu_link_attributes     varchar2(4000),
     between_levels           varchar2(4000),
     after_last               varchar2(4000),
     max_levels               number,
     start_with_node          varchar2(255),
     reference_id             number,
     security_group_id        number not null,
     last_updated_by          varchar2(255),
     last_updated_on          date,
     --
     theme_id                 number,
     theme_class_id           number,
     --
     translate_this_template  varchar2(1)
                                constraint wwv_flow_menu_trans_temp
                                check (translate_this_template in ('Y','N')),
     template_comments        varchar2(4000)
     )
/

create index wwv_flow_menu_temp_idx1 on wwv_flow_menu_templates (security_group_id, reference_id)
/
create unique index wwv_flow_menu_temp_idx2 on wwv_flow_menu_templates (flow_id, name, theme_id)
/

Prompt ...wwv_flow_version$

create table wwv_flow_version$(
    seq                 number
                        constraint wwv_flow_version$_PK
                        primary key,
    date_applied        date            not null,
    major_version       number          not null,
    minor_version       number          not null,
    patch_version       number          not null,
    banner              varchar2(255)   not null,
    comments            varchar2(4000)
    )
/



create unique index wwv_flow_version_idx on wwv_flow_version$(major_version,minor_version,patch_version);


create or replace view wwv_flow_version as
    select seq,date_applied,major_version,minor_version,patch_version,
           major_version||'.'||minor_version||'.'||patch_version version,
           banner,comments
      from wwv_flow_version$
     where seq = (select max(seq)
                    from wwv_flow_version$)
/

--------------------------------------
--   C U S T O M  A U T H  S E T U P S
--
prompt ...create wwv_flow_custom_auth_setups table

create table wwv_flow_custom_auth_setups(
    ID                                                 NUMBER
        constraint wwv_flow_auth_setups_pk
        primary key,
    FLOW_ID                                            NUMBER NOT NULL
        constraint wwv_flow_auth_setups_fk
        references wwv_flows on delete cascade,
    REFERENCE_ID                                       NUMBER,
    NAME                                               VARCHAR2(255) NOT NULL,
    DESCRIPTION                                        VARCHAR2(4000),
    PAGE_SENTRY_FUNCTION                               CLOB,
    SESS_VERIFY_FUNCTION                               CLOB,
    INVALID_SESSION_PAGE                               NUMBER,
    INVALID_SESSION_URL                                VARCHAR2(4000),
    PRE_AUTH_PROCESS                                   CLOB,
    AUTH_FUNCTION                                      CLOB,
    POST_AUTH_PROCESS                                  CLOB,
    COOKIE_NAME                                        VARCHAR2(4000),
    COOKIE_PATH                                        VARCHAR2(4000),
    COOKIE_DOMAIN                                      VARCHAR2(4000),
    USE_SECURE_COOKIE_YN                               varchar2(1)
                                                       constraint wwv_flow_custom_auth_chk1
                                                       check (USE_SECURE_COOKIE_YN in ('Y','N')),    
    --
    LDAP_HOST                                          varchar(255),
    LDAP_PORT                                          varchar(255),
    LDAP_STRING                                        varchar(255),
    ATTRIBUTE_01                                       varchar(4000),
    ATTRIBUTE_02                                       varchar(4000),
    ATTRIBUTE_03                                       varchar(4000),
    ATTRIBUTE_04                                       varchar(4000),
    ATTRIBUTE_05                                       varchar(4000),
    ATTRIBUTE_06                                       varchar(4000),
    ATTRIBUTE_07                                       varchar(4000),
    ATTRIBUTE_08                                       varchar(4000),
    --
    REQUIRED_PATCH                                     NUMBER,
    SECURITY_GROUP_ID                                  NUMBER NOT NULL,
    LAST_UPDATED_BY                                    VARCHAR2(255),
    LAST_UPDATED_ON                                    DATE)
    lob (PAGE_SENTRY_FUNCTION, SESS_VERIFY_FUNCTION, PRE_AUTH_PROCESS, AUTH_FUNCTION, POST_AUTH_PROCESS) store as (cache reads enable storage in row)
/
create index wwv_flow_auth_setups_idx1 on wwv_flow_custom_auth_setups(flow_id);


--------------------------
-- E N T R Y   P O I N T S
--

create table wwv_flow_entry_points(
    id                                                 number
        constraint wwv_flow_entry_points_pk
        primary key,
    flow_id                                            number
        constraint wwv_flow_entry_points_fk
        references wwv_flows on delete cascade,
    name                                               varchar2(255) not null,
    page_reset                                         varchar2(4000),
    security_group_id                                  number not null,
    last_updated_by                                    varchar2(255),
    last_updated_on                                    date,
    entry_point_comment                                varchar2(4000)
    )
/

create index wwv_flow_entry_points_idx1 on wwv_flow_entry_points(flow_id);
create unique index wwv_flow_entry_points_idx2 on wwv_flow_entry_points (flow_id,security_group_id,name);


----------------------------------
-- E N T R Y   P O I N T   A R G S
--

create table wwv_flow_entry_point_args(
    id                                                 number
        constraint wwv_flow_entry_point_args_pk
        primary key,
    flow_entry_point_id                                number
        constraint wwv_flow_entry_point_args_fk
        references wwv_flow_entry_points on delete cascade,
    entry_point_arg_sequence                           number not null,
    entry_point_arg_item_id                            number not null,
    security_group_id                                  number not null,
    last_updated_by                                    varchar2(255),
    last_updated_on                                    date,
    entry_point_arg_comment                            varchar2(4000)
    )
/

create index wwv_flow_entry_point_arg_idx2 on wwv_flow_entry_point_args(flow_entry_point_id);

----------------------------------
-- T R E E S
--
-- ****************************************************************************
-- These types define tree entries and arrays of these entries. The entry has
-- elements that map to the wwv_flow_temp_trees table. The array of tree entries
-- represents a list of sub-tree entries.
-- ****************************************************************************
create or replace type wwv_flow_tree_entry as object
( seq      number,
  lev      number,
  id       varchar2(4000),
  pid      varchar2(4000),
  kids     number,
  expand   varchar2(1),
  indent   varchar2(4000),
  name     varchar2(4000),
  link     varchar2(4000),
  a1       varchar2(4000),
  a2       varchar2(4000) )
/
create or replace type wwv_flow_tree_subs as table of wwv_flow_tree_entry not null;
/
create or replace type wwv_flow_tree_num_arr as table of number not null
/
create global temporary table wwv_flow_temp_trees(
  seq     number,
  lev     number,
  id      varchar2(4000),
  pid     varchar2(4000),
  kids    number,
  expand  varchar2(1) default 'Y',
  indent  varchar2(4000) default null,
  name    varchar2(4000),
  link    varchar2(4000) default null,
  a1      varchar2(4000) default null,
  a2      varchar2(4000) default null)
  on commit preserve rows
/
create table wwv_flow_tree_state(
  id         number not null,
  tree_id    number not null,
  expand     clob default empty_clob(),
  contract   clob default empty_clob(),
  constraint wwv_flow_tree_state$pk primary key(id,tree_id),
  constraint wwv_flow_tree_state$fk foreign key(id) references wwv_flow_sessions$(id) on delete cascade)
  lob (expand,contract) store as (cache reads enable storage in row)
/

----------------------------------
-- W E B  S E R V I C E S
--
create table wwv_flow_shared_web_services (
   id                            number
                                 constraint wwv_flow_web_services_pk
                                 primary key,
   --
   -- columns that identifies who owns the service description
   --
   security_group_id             number not null,
   flow_id                       number
                                 constraint wwv_flow_ws_fk
                                 references wwv_flows
                                 on delete cascade,
   name                          varchar2(255) not null,
   --
   -- columns that describe the service
   --
   url                           varchar2(4000),
   action                        varchar2(4000),
   proxy_override                varchar2(4000),
   --
   -- can be generated, but can also be edited after generation
   --
   soap_envelope                 clob,
   --
   -- body / envelope substitution strings
   --
   flow_items_comma_delimited    clob,
   static_parm_01                varchar2(4000),
   static_parm_02                varchar2(4000),
   static_parm_03                varchar2(4000),
   static_parm_04                varchar2(4000),
   static_parm_05                varchar2(4000),
   static_parm_06                varchar2(4000),
   static_parm_07                varchar2(4000),
   static_parm_08                varchar2(4000),
   static_parm_09                varchar2(4000),
   static_parm_10                varchar2(4000),
   --
   -- columns that deal with soap responce
   --
   stylesheet                    clob,
   --
   -- administrative columns
   --
   reference_id                  number,
   last_updated_by               varchar2(255),
   last_updated_on               date
   ) lob (soap_envelope, stylesheet) store as (cache reads enable storage in row)
/

comment on column wwv_flow_shared_web_services.url is 'SOAP Service URL';
comment on column wwv_flow_shared_web_services.action is 'SOAP Action';
comment on column wwv_flow_shared_web_services.proxy_override is 'HTTP proxy for SOAP request';
comment on column wwv_flow_shared_web_services.soap_envelope is 'May contain #ITEM_NAME# substitutions';
comment on column wwv_flow_shared_web_services.flow_items_comma_delimited is 'A comma delmited list of flow items contained in the body for example: ITEM1,ITEM2,ITEM3';

create index wwv_flow_shared_web_serv_idx1 on wwv_flow_shared_web_services (flow_id)
/

create table wwv_flow_ws_operations (
    id                      number
                            constraint wwv_flow_ws_opers_pk
                            primary key,
    ws_id                   number
                            constraint wwv_flow_ws_opers_fk
                            references wwv_flow_shared_web_services
                            on delete cascade,
    name                    varchar2(255),
    input_message_name      varchar2(255),
    input_message_ns        varchar2(4000),
    input_message_style     varchar2(255),
    output_message_name     varchar2(255),
    output_message_ns       varchar2(4000),
    output_message_style    varchar2(255),
    header_message_name     varchar2(4000),
    header_message_style    varchar2(255),
    soap_action             varchar2(4000),
    --
    security_group_id       number not null,
    last_updated_by         varchar2(255),
    last_updated_on         date
    )
/

create index wwv_flow_ws_opers_idx1 on wwv_flow_ws_operations (ws_id)
/

create table wwv_flow_ws_parameters (
    id                      number
                            constraint wwv_flow_ws_parms_pk
                            primary key,
    ws_opers_id             number
                            constraint wwv_flow_ws_parms_fk
                            references wwv_flow_ws_operations
                            on delete cascade,
    name                    varchar2(255),
    input_or_output         varchar2(1)
                            constraint wwv_flow_ws_parms_chk1
                            check (input_or_output in ('I','O','H','A')),
    parm_type               varchar2(255),
    type_is_xsd             varchar2(1)
                            constraint wwv_flow_ws_parms_chk2
                            check (type_is_xsd in ('Y','N')),
    parent_id               number,
    --
    security_group_id       number not null,
    last_updated_by         varchar2(255),
    last_updated_on         date
    )
/

create index wwv_flow_ws_parms_idx1 on wwv_flow_ws_parameters (ws_opers_id)
/

create table wwv_flow_ws_process_parms_map (
    id                      number
                            constraint wwv_flow_ws_map_pk
                            primary key,
    parameter_id            number
                            constraint wwv_flows_ws_map_fk1
                            references wwv_flow_ws_parameters
                            on delete cascade,
    process_id              number
                            constraint wwv_flow_ws_map_fk2
                            references wwv_flow_step_processing
                            on delete cascade,
    map_type                varchar2(10)
                            constraint wwv_flow_ws_map_chk
                            check (map_type in ('ITEM','STATIC','COLLECTION')),
    parm_value              varchar2(4000),
    --
    security_group_id       number not null,
    last_updated_by         varchar2(255),
    last_updated_on         date
    )
/

create index wwv_flow_ws_map_idx1 on wwv_flow_ws_process_parms_map (parameter_id)
/
create index wwv_flow_ws_map_idx2 on wwv_flow_ws_process_parms_map (process_id)
/



------------------------------------
-- D E V E L O P E R   L O C K I N G
--


create table wwv_flow_lock_page (
  id                  number
                      constraint wwv_flow_lock_page_pk
                      primary key,
  flow_id             number
                      references wwv_flows (id)
                      on delete cascade,
  object_id           number,
  locked_by           varchar2(255),
  locked_on           date,
  lock_comment        varchar2(4000),
  security_group_id   number not null
  )
/

create index wwv_flow_lock_page_fk on wwv_flow_lock_page (flow_id)
/

create index wwv_flow_lock_page_by on wwv_flow_lock_page (locked_by)
/

create unique index wwv_flow_lock_page_pg on wwv_flow_lock_page (object_id,flow_id)
/



create table wwv_flow_lock_page_log (
    id             number
                   constraint wwv_flow_lock_pg_log_pk
                   primary key,
    lock_id        number not null,
    lock_flow      number,
    lock_page      number,
    action         varchar2(30) not null
                   constraint dev_file_lock_log_action
                   check ( action in ('LOCK','UNLOCK','UPDATE')),
    action_date    date,
    developer      varchar2(255),
    lock_comment   varchar2(4000)
    )
/


create index wwv_flow_lock_page_log_i1 on wwv_flow_lock_page_log (lock_flow)
/

create index wwv_flow_lock_page_log_i2 on wwv_flow_lock_page_log (lock_id)
/


---------------------------------------
-- C O M P O U N D  C O N D I T I O N S
--
create table wwv_flow_compound_conditions(
    id number                   constraint wwv_flow_compound_conds_pk
                                primary key,
    flow_id                     number
                                constraint wwv_flow_comp_cond_fk
                                references wwv_flows
                                on delete cascade,
    condition_logical_operator  varchar2(255)
                                constraint wwv_flow_comp_cond_oper
                                check (condition_logical_operator in ('OR','AND','NOR','NAND')),
    condition_disabled_y_n      varchar2(1)
                                constraint wwv_flow_comp_cond_flag
                                check (condition_disabled_y_n in ('Y','N')),
    condition_term_count        number          not null,
    term1_cond_type             varchar2(255),
    term1_cond_exp1             varchar2(4000),
    term1_cond_exp2             varchar2(4000),
    term2_cond_type             varchar2(255),
    term2_cond_exp1             varchar2(4000),
    term2_cond_exp2             varchar2(4000),
    term3_cond_type             varchar2(255),
    term3_cond_exp1             varchar2(4000),
    term3_cond_exp2             varchar2(4000),
    term4_cond_type             varchar2(255),
    term4_cond_exp1             varchar2(4000),
    term4_cond_exp2             varchar2(4000),
    term5_cond_type             varchar2(255),
    term5_cond_exp1             varchar2(4000),
    term5_cond_exp2             varchar2(4000),
    term6_cond_type             varchar2(255),
    term6_cond_exp1             varchar2(4000),
    term6_cond_exp2             varchar2(4000),
    term7_cond_type             varchar2(255),
    term7_cond_exp1             varchar2(4000),
    term7_cond_exp2             varchar2(4000),
    term8_cond_type             varchar2(255),
    term8_cond_exp1             varchar2(4000),
    term8_cond_exp2             varchar2(4000),
    security_group_id           number          not null,
    last_updated_by             varchar2(255)   not null,
    last_updated_on             date            not null)
/

create index wwv_flow_compound_cond_idx1 on wwv_flow_compound_conditions(flow_id)
/

prompt ...create table wwv_flow_upg_tab_obsolete

create table wwv_flow_upg_tab_obsolete (
    table_name       varchar2(30)  not null
                     constraint wwv_flow_upg_tab_obs_pk
                     primary key,
    obsolete_date    date          not null,
    change_made      varchar2(1)   not null
                     constraint wwv_flow_upg_tab_obs_done
                     check (change_made in ('Y','N')) )
/


prompt ...create table wwv_flow_upg_col_obsolete

-- include code for WWV_FLOW_UPG_COL_OBSOLETE, already exists as WWV_COLUMN_EXCEPTIONS
-- need to include additional column for change_made flag


prompt ...create table wwv_flow_upg_tab_name_changes

create table wwv_flow_upg_tab_name_changes (
    old_table_name    varchar2(30)  not null
                      constraint wwv_flow_upg_tab_name_chng_pk
                      primary key,
    new_table_name   varchar2(30)  not null
                      constraint wwv_flow_upg_tab_name_chng_uk
                      unique,
    change_date       date          not null,
    change_made       varchar2(1)   not null
                      constraint wwv_flow_upg_tab_name_chg_done
                      check (change_made in ('Y','N')) )
/


prompt ...create table wwv_flow_upg_col_name_changes

create table wwv_flow_upg_col_name_changes (
    old_table_name     varchar2(30)  not null,
    old_column_name    varchar2(30)  not null,
    new_column_name    varchar2(30)  not null,
    change_date        date          not null,
    change_made        varchar2(1)   not null
                       constraint wwv_flow_upg_col_name_chg_done
                       check (change_made in ('Y','N')) )
/

alter table wwv_flow_upg_col_name_changes
   add constraint wwv_flow_upg_col_name_chng_pk
       primary key (old_table_name,old_column_name)
/


prompt ...create table wwv_flow_hnt_table_info

create table wwv_flow_hnt_table_info (
    table_id             number        not null
                             constraint wwv_flow_hnt_table_info_pk
                             primary key,
    schema               varchar2(30)  not null,
    table_name           varchar2(30)  not null,
    --
    form_region_title    varchar2(255),
    report_region_title  varchar2(255),
    --
    created_by           varchar2(255)  not null,
    created_on           date          not null,
    last_updated_by      varchar2(255),
    last_updated_on      date,
    --
    title                varchar2(255)
 )
/

alter table wwv_flow_hnt_table_info
    add constraint wwv_flow_hnt_table_info_uk
        unique (schema, table_name)
/

prompt ...create table wwv_flow_hnt_column_info

create table wwv_flow_hnt_column_info (
    column_id           number        not null
                            constraint wwv_flow_hnt_column_info_pk
                            primary key,
    table_id            number        not null
                            constraint wwv_flow_hnt_col_info_tab_fk
                            references wwv_flow_hnt_table_info
                            on delete cascade,
    column_name         varchar2(30)  not null,
    --
    label               varchar2(255),
    help_text           varchar2(4000),
    mask_form           varchar2(255),
    display_seq_form    number,
    display_in_form     varchar2(1)
                            constraint wwv_fhc_display_in_form
                            check (display_in_form in ('Y','N')),
    display_as_form     varchar2(50)
                            constraint wwv_fhc_display_as_form
                            check (display_as_form in (
                                'DISPLAY_ONLY_PLSQL',
                                'FILE',
                                'BUTTON',
                                'HIDDEN',
                                'HIDDEN_PROTECTED',
                                'DISPLAY_ONLY_HTML',
                                'STOP_AND_START_HTML_TABLE',
                                'DISPLAY_ONLY_ESCAPE_SC',
                                'IMAGE',
                                'DISPLAY_AND_SAVE',
                                'DISPLAY_AND_SAVE_LOV',
                                'CHECKBOX',
                                'POPUP',
                                'POPUP_FILTER',
                                'POPUP2',
                                'POPUP3',
                                'POPUP4',
                                'POPUP5',
                                'POPUP6',
                                'POPUP_KEY_LOV',
                                'POPUP_KEY_LOV_NOFETCH',
                                'PICK_DATE_USING_FLOW_FORMAT_MASK',
                                'PICK_DATE_USING_APP_FORMAT_MASK',
                                'PICK_DATE_USING_APP_DATE_FORMAT',
                                'PICK_DATE_USING_FORMAT_MASK',
                                'PICK_DATE_DD_MON_RR',
                                'PICK_DATE_DD_MON_RR_HH_MI',
                                'PICK_DATE_DD_MON_RR_HH24_MI',
                                'PICK_DATE_DD_MON_YY',
                                'PICK_DATE_DD_MON_YY_HH_MI',
                                'PICK_DATE_DD_MON_YY_HH24_MI',
                                'PICK_DATE_DD_MON_YYYY',
                                'PICK_DATE_DD_MON_YYYY_HH_MI',
                                'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY',
                                'PICK_DATE_DD_MM_YYYY_HH_MI',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                'PICK_DATE_MM_DD_YYYY',
                                'PICK_DATE_MM_DD_YYYY_HH_MI',
                                'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD',
                                'PICK_DATE_YYYY_MM_DD_HH_MI',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                'PICK_DATE_RR_MON_DD',
                                'PICK_DATE_RR_MON_DD_HH_MI',
                                'PICK_DATE_RR_MON_DD_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                'PICK_DATE_YYYY_DD_MM_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                'DISPLAY_ONLY_LOV',
                                'COMBOBOX',
                                'SHOW_AS_SL_WITH_POPUP',
                                'COMBOBOX_WITH_URL_REDIRECT',
                                'COMBOBOX_WITH_BRANCH_TO_PAGE',
                                'COMBOBOX_WITH_SUBMIT',
                                'COMBOBOX_WITH_JS_POST',
                                'COMBOBOX_WITH_JS_REDIRECT',
                                'MULTIPLESELECT',
                                'RADIOGROUP',
                                'RADIOGROUP2',
                                'RADIOGROUP_WITH_REDIRECT',
                                'RADIOGROUP_WITH_SUBMIT',
                                'RADIOGROUP_WITH_JS_SUBMIT',
                                'TEXTAREA',
                                'TEXTAREA_WITH_SPELL_CHECK',
                                'TEXTAREA-AUTO-HEIGHT',
                                'TEXTAREA_WITH_CONTROLS',
                                'TEXTAREA_WITH_HTML_EDITOR_BASIC',
                                'TEXTAREA_WITH_HTML_EDITOR_STANDARD',
                                'TEXTAREA_CHAR_COUNT',
                                'TEXTAREA_CHAR_COUNT_SPELL',
                                'TEXT',
                                'TEXT_WITH_ENTER_SUBMIT',
                                'TEXT_DISABLED',
                                'TEXT_DISABLED_AND_SAVE',
                                'TEXT_WITH_CALCULATOR',
                                'PASSWORD',
                                'PASSWORD_WITH_ENTER_SUBMIT',
                                'PASSWORD_DNSS',
                                'PASSWORD_WITH_SUBMIT_DNSS',
                                'LIST_MGR',
                                'LIST_MGR2',
                                'LIST_MGR3',
                                'LIST_MGR_VIEW',
                                'LIST_MGR_VIEW2')),
    display_as_tab_form varchar2(255)
                            constraint wwv_fhc_display_as_tab_form
                            check (display_as_tab_form in (
                                'READONLY',
                                'DISPLAY_AND_SAVE',
                                'WITHOUT_MODIFICATION',
                                'ESCAPE_SC',
                                'TEXT',
                                'TEXTAREA',
                                'TEXT_FROM_LOV',
                                'SELECT_LIST',
                                'SELECT_LIST_FROM_LOV',
                                'SELECT_LIST_FROM_QUERY',
                                'HIDDEN',
                                'HIDDEN_PROTECTED',
                                'POPUP',
                                'POPUP_QUERY',
                                'DATE_POPUP',
                                'PICK_DATE_USING_APP_FORMAT_MASK',
                                'PICK_DATE_USING_APP_DATE_FORMAT',
                                'PICK_DATE_USING_FORMAT_MASK',
                                'PICK_DATE_DD_MON_RR',
                                'PICK_DATE_DD_MON_RR_HH_MI',
                                'PICK_DATE_DD_MON_RR_HH24_MI',
                                'PICK_DATE_DD_MON_YY',
                                'PICK_DATE_DD_MON_YY_HH_MI',
                                'PICK_DATE_DD_MON_YY_HH24_MI',
                                'PICK_DATE_DD_MON_YYYY',
                                'PICK_DATE_DD_MON_YYYY_HH_MI',
                                'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY',
                                'PICK_DATE_DD_MM_YYYY_HH_MI',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                'PICK_DATE_MM_DD_YYYY',
                                'PICK_DATE_MM_DD_YYYY_HH_MI',
                                'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD',
                                'PICK_DATE_YYYY_MM_DD_HH_MI',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                'PICK_DATE_RR_MON_DD',
                                'PICK_DATE_RR_MON_DD_HH_MI',
                                'PICK_DATE_RR_MON_DD_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                'PICK_DATE_YYYY_DD_MM_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                'CHECKBOX',
                                'RADIOGROUP')),
    display_seq_report  number,
    display_in_report   varchar2(1)
                            constraint wwv_fhc_display_in_report
                            check (display_in_report in ('Y','N')),
    display_as_report   varchar2(255)
                            constraint wwv_fhc_display_as_report
                            check (display_as_report in (
                                'READONLY',
                                'DISPLAY_AND_SAVE',
                                'WITHOUT_MODIFICATION',
                                'ESCAPE_SC',
                                'TEXT',
                                'TEXTAREA',
                                'TEXT_FROM_LOV',
                                'SELECT_LIST',
                                'SELECT_LIST_FROM_LOV',
                                'SELECT_LIST_FROM_QUERY',
                                'HIDDEN',
                                'HIDDEN_PROTECTED',
                                'POPUP',
                                'POPUP_QUERY',
                                'DATE_POPUP',
                                'PICK_DATE_USING_APP_FORMAT_MASK',
                                'PICK_DATE_USING_APP_DATE_FORMAT',
                                'PICK_DATE_USING_FORMAT_MASK',
                                'PICK_DATE_DD_MON_RR',
                                'PICK_DATE_DD_MON_RR_HH_MI',
                                'PICK_DATE_DD_MON_RR_HH24_MI',
                                'PICK_DATE_DD_MON_YY',
                                'PICK_DATE_DD_MON_YY_HH_MI',
                                'PICK_DATE_DD_MON_YY_HH24_MI',
                                'PICK_DATE_DD_MON_YYYY',
                                'PICK_DATE_DD_MON_YYYY_HH_MI',
                                'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY',
                                'PICK_DATE_DD_MM_YYYY_HH_MI',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                'PICK_DATE_MM_DD_YYYY',
                                'PICK_DATE_MM_DD_YYYY_HH_MI',
                                'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD',
                                'PICK_DATE_YYYY_MM_DD_HH_MI',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                'PICK_DATE_RR_MON_DD',
                                'PICK_DATE_RR_MON_DD_HH_MI',
                                'PICK_DATE_RR_MON_DD_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                'PICK_DATE_YYYY_DD_MM_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                'CHECKBOX',
                                'RADIOGROUP')),
    mask_report         varchar2(255),
    aggregate_by        varchar2(1)
                            constraint wwv_fhc_aggregate_by
                            check (aggregate_by in ('Y','N')),
    lov_query           varchar2(4000),
    default_value       varchar2(255),
    required            varchar2(1)
                            constraint wwv_fhc_required
                            check (required in ('Y','N')),
    alignment           varchar2(1)
                            constraint wwv_fhc_alignment
                            check (alignment in ('L','C','R')),
    display_width       number,
    max_width           number,
    height              number,
    group_by            varchar2(1)
                            constraint wwv_fhc_group_by
                            check (group_by in ('Y','N')),
    order_by_seq        number,
    order_by_asc_desc   varchar2(1)
                            constraint wwv_fhc_order_by
                            check (order_by_asc_desc in ('A','D')),
    searchable          varchar2(1)
                            constraint wwv_fhc_searchable
                            check (searchable in ('Y','N')),
    created_by          varchar2(255)  not null,
    created_on          date          not null,
    last_updated_by     varchar2(255),
    last_updated_on     date)
/

alter table wwv_flow_hnt_column_info
    add constraint wwv_flow_hnt_column_info_uk
        unique (table_id, column_name)
/

prompt ...create table wwv_flow_hnt_lov_data

create table wwv_flow_hnt_lov_data (
    id                 number         not null
                           constraint wwv_flow_hnt_lov_data_pk
                           primary key,
    --
    column_id          number         not null
                           constraint wwv_flow_hnt_lov_data_col_fk
                           references wwv_flow_hnt_column_info
                           on delete cascade,
    lov_disp_sequence  number         not null,
    lov_disp_value     varchar2(4000) not null,
    lov_return_value   varchar2(4000) not null,
    last_updated_by    varchar2(255)   not null,
    last_updated_on    date           not null)
/

create index wwv_flow_hnt_lov_data_idx on wwv_flow_hnt_lov_data(column_id)
/

prompt ...create table wwv_flow_region_chart_ser_attr

create table wwv_flow_region_chart_ser_attr (
    id                           number
                                 constraint wwv_flow_chart_series_pk
                                 primary key,
    region_id                    number not null
                                 constraint wwv_flow_seattr_to_region_fk
                                 references wwv_flow_page_plugs
                                 on delete cascade,
    series_id                    number not null,
    security_group_id            number not null,
    a001                         clob,
    a002                         varchar2(4000),
    a003                         varchar2(4000),
    a004                         varchar2(4000),
    a005                         varchar2(4000),
    a006                         varchar2(4000),
    a007                         varchar2(4000),
    a008                         varchar2(4000),
    a009                         varchar2(4000),
    a010                         varchar2(4000),
    a011                         varchar2(4000),
    a012                         varchar2(4000),
    a013                         varchar2(4000),
    a014                         varchar2(4000),
    a015                         varchar2(4000),
    a016                         varchar2(4000),
    a017                         varchar2(4000),
    a018                         varchar2(4000),
    a019                         varchar2(4000),
    a020                         varchar2(4000),
    a021                         varchar2(4000),
    a022                         varchar2(4000),
    a023                         varchar2(4000),
    a024                         varchar2(4000),
    a025                         varchar2(4000),
    a026                         varchar2(4000),
    a027                         varchar2(4000),
    a028                         varchar2(4000),
    a029                         varchar2(4000),
    a030                         varchar2(4000),
    a031                         varchar2(4000),
    a032                         varchar2(4000),
    a033                         varchar2(4000),
    a034                         varchar2(4000),
    a035                         varchar2(4000),
    a036                         varchar2(4000),
    a037                         varchar2(4000),
    a038                         varchar2(4000),
    a039                         varchar2(4000),
    a040                         varchar2(4000),
    a041                         varchar2(4000),
    a042                         varchar2(4000),
    a043                         varchar2(4000),
    a044                         varchar2(4000),
    a045                         varchar2(4000),
    a046                         varchar2(4000),
    a047                         varchar2(4000),
    a048                         varchar2(4000),
    a049                         varchar2(4000),
    a050                         varchar2(4000))
/

create unique index wwv_flow_chart_seattr_idx on wwv_flow_region_chart_ser_attr (region_id,series_id)
/

prompt ...create table wwv_flow_query_definition

create table wwv_flow_query_definition (
  id                            number          not null
                                constraint query_definition_pk
                                primary key,
  region_id                     number          not null
                                constraint query_def_to_region_fk
                                references wwv_flow_page_plugs
                                on delete cascade,
  flow_id                       number,
  reference_id                  number,
  security_group_id             number          not null,
  last_updated_by               varchar2(255),
  last_updated_on               date
)
/

create index wwv_flow_query_definition_idx on wwv_flow_query_definition (flow_id,security_group_id)
/

create index wwv_flow_query_def_idx2 on wwv_flow_query_definition(region_id)
/

prompt ...create table wwv_flow_query_object

create table wwv_flow_query_object (
  id                            number          not null
                                constraint query_object_pk
                                primary key,
  query_id                      number          not null
                                constraint query_object_to_query_fk
                                references wwv_flow_query_definition
                                on delete cascade,
  object_owner                  varchar2(30)    not null,
  object_name                   varchar2(30)    not null,
  object_alias                  varchar2(255)   not null,
  security_group_id             number          not null,
  last_updated_by               varchar2(255),
  last_updated_on               date
)
/

create index wwv_flow_query_object_idx on wwv_flow_query_object (query_id)
/

prompt ...create table wwv_flow_query_column

create table wwv_flow_query_column (
  id                            number          not null
                                constraint query_column_pk
                                primary key,
  query_id                      number          not null
                                constraint query_column_to_query_fk
                                references wwv_flow_query_definition
                                on delete cascade,
  query_object_id               number
                                constraint query_column_to_qry_object_fk
                                references wwv_flow_query_object
                                on delete cascade,
  column_number                 number           not null,
  column_alias                  varchar2(255)    not null,
  column_sql_expression         varchar2(4000)   not null,
  column_group_by_sequence      number,
  security_group_id             number           not null,
  last_updated_by               varchar2(255),
  last_updated_on               date
)
/

create index wwv_flow_query_column_idx1 on wwv_flow_query_column (query_id)
/

create index wwv_flow_query_column_idx2 on wwv_flow_query_column (query_object_id)
/

prompt ...create table wwv_flow_query_condition

create table wwv_flow_query_condition (
  id                            number          not null
                                constraint wwv_flow_query_condition_pk
                                primary key,
  query_id                      number          not null
                                constraint query_condition_to_query_fk
                                references wwv_flow_query_definition
                                on delete cascade,
  condition                     varchar2(4000),
  cond_column                   varchar2(255),
  cond_id1                      number,
  cond_id2                      number,
  cond_root                     varchar2(1)
                                      constraint valid_cond_root
                                      check (cond_root in ('Y','N')),
  operator                      varchar2(30)    not null
                      		          constraint valid_compound_operator
                      		          check (operator in (
                      		             'AND',
                      		             'OR',
                      		             'NOT',
                      		             'JOIN',
                      		             'NJOIN',
                      		             'NONE'
                                		)),
  security_group_id             number          not null,
  last_updated_by               varchar2(255),
  last_updated_on               date
)
/

create index wwv_flow_query_condition_idx on wwv_flow_query_condition (query_id)
/

prompt ...create table wwv_flow_region_report_column

create table wwv_flow_region_report_column (
  id                            number          not null
                                constraint report_column_pk
                                primary key,
  region_id                     number          not null
                                constraint report_column_to_region_fk
                                references wwv_flow_page_plugs
                                on delete cascade,
  flow_id                       number,
  query_column_id               number,
  form_element_id               number,
  column_alias                  varchar2(4000)    not null,
  column_display_sequence       number           not null,
  column_heading                varchar2(4000),
  column_format                 varchar2(4000),
  column_html_expression        varchar2(4000),
  column_css_class              varchar2(4000),
  column_css_style              varchar2(4000),
  column_hit_highlight          varchar2(4000),
  column_link                   varchar2(4000),
  column_linktext               varchar2(4000),
  column_link_attr              varchar2(4000),
  column_link_checksum_type     varchar2(255) constraint wwv_regrepcol_checksum_type
                                check (column_link_checksum_type in (
                                '1', -- workspace
                                '2', -- user
                                '3'  -- session
                                )),
  column_alignment              varchar2(4000),
  heading_alignment             varchar2(4000),
  default_sort_column_sequence  number,
  default_sort_dir              varchar2(255),
  disable_sort_column           varchar2(1),
  sum_column                    varchar2(1),
  hidden_column                 varchar2(1),
  display_when_cond_type        varchar2(255),
  display_when_condition        varchar2(4000),
  display_when_condition2       varchar2(4000),
  report_column_required_role   varchar2(255),
  security_group_id             number           not null,
  last_updated_by               varchar2(255),
  last_updated_on               date,
  --
  display_as                   varchar2(255)
                               constraint wwv_regrepcol_display_as
                               check ( display_as in (
                               'READONLY',
                               'DISPLAY_AND_SAVE',
                               'WITHOUT_MODIFICATION',
                               'ESCAPE_SC',
                               'TEXT',
                               'TEXT_FROM_LOV',
                               'TEXTAREA',
                               'SELECT_LIST',
                               'SELECT_LIST_FROM_LOV',
                               'SELECT_LIST_FROM_QUERY',
                               'CHECKBOX',
                               'RADIOGROUP',
                               'HIDDEN',
                               'HIDDEN_PROTECTED',
                               'POPUP',
                               'POPUP_QUERY',
                               'DATE_POPUP',
                               'PICK_DATE_USING_APP_FORMAT_MASK',
                               'PICK_DATE_USING_APP_DATE_FORMAT',
                               'PICK_DATE_USING_FORMAT_MASK',
                               'PICK_DATE_DD_MON_RR',
                               'PICK_DATE_DD_MON_RR_HH_MI',
                               'PICK_DATE_DD_MON_RR_HH24_MI',
                               'PICK_DATE_DD_MON_YYYY',
                               'PICK_DATE_DD_MON_YYYY_HH_MI',
                               'PICK_DATE_DD_MON_YYYY_HH24_MI',
                               'PICK_DATE_DD_MM_YYYY',
                               'PICK_DATE_DD_MM_YYYY_HH_MI',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI',
                               'PICK_DATE_MM_DD_YYYY',
                               'PICK_DATE_MM_DD_YYYY_HH_MI',
                               'PICK_DATE_MM_DD_YYYY_HH24_MI',
                               'PICK_DATE_DD_MON_YY',
                               'PICK_DATE_DD_MON_YY_HH_MI',
                               'PICK_DATE_DD_MON_YY_HH24_MI',
                               'PICK_DATE_YYYY_MM_DD',
                               'PICK_DATE_YYYY_MM_DD_HH_MI',
                               'PICK_DATE_YYYY_MM_DD_HH24_MI',
                               'PICK_DATE_RR_MON_DD',
                               'PICK_DATE_RR_MON_DD_HH_MI',
                               'PICK_DATE_RR_MON_DD_HH24_MI',
                               'PICK_DATE_DD_MM_YYYY_DASH',
                               'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                               'PICK_DATE_DD_MM_YYYY_DOT',
                               'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                               'PICK_DATE_YYYY_DD_MM_DOT',
                               'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                               'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                               'PICK_DATE_YYYY_MM_DD_SLASH',
                               'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                               'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH'
                               )),
  named_lov                    number,
  inline_lov                   varchar2(4000),
  lov_show_nulls               varchar2(3)
                               constraint wwv_flow_regrepcol_lovn
                               check (lov_show_nulls in (
                               'YES',
                               'NO')),
  lov_null_text                varchar2(255),
  lov_null_value               varchar2(255),
  column_width                 number,
  column_height                number,
  cattributes                  varchar2(4000),
  cattributes_element          varchar2(4000),
  --
  column_comment               varchar2(4000),
  --
  pk_col_source_type           varchar2(1)
                                   constraint wwv_flow_regrepcol_src_type
                                   check (pk_col_source_type in (
                                   'S',
                                   'F',
                                   'T')),
  pk_col_source                clob,
  derived_column               varchar2(1)
                                   constraint wwv_flow_regrepcol_derv_col
                                   check (derived_column in (
                                   'Y',
                                   'N')),
  --
  column_default               varchar2(4000),
  column_default_type          varchar2(255),
  lov_display_extra            varchar2(30),
  --
  include_in_export            varchar2(1)
                                   constraint wwv_flow_regrepcol_incl_exp
                                   check (include_in_export in (
                                   'Y',
                                   'N')),
  print_col_width              varchar2(4000),
  print_col_align              varchar2(4000),
  --
  ref_schema                   varchar2(255),
  ref_table_name               varchar2(255),
  ref_column_name              varchar2(255)
) lob (pk_col_source) store as (cache reads enable storage in row)
/

create index wwv_flow_region_report_col_idx on wwv_flow_region_report_column (region_id)
/

create index wwv_flow_region_rpt_col_idx2 on wwv_flow_region_report_column (security_group_id,flow_id)
/

prompt ...create table wwv_flow_region_report_filter

create table wwv_flow_region_report_filter (
  id                            number           not null
                                constraint report_filter_pk
                                primary key,
  region_id                     number           not null
                                references wwv_flow_page_plugs (id)
                                on delete cascade,
  condition_type                varchar2(255)    not null,
  cond_expression1              varchar2(4000)   not null,
  cond_expression2              varchar2(4000)   not null,
  compound_operator             varchar2(4000)
                                  constraint valid_rep_compound_operator
                                  check (compound_operator in (
                      		             'and',
                      		             'or',
                      		             'not'
                                		)),
  security_group_id             number           not null,
  last_updated_by               varchar2(255),
  last_updated_on               date
)
/

create index wwv_flow_region_report_flt_idx on wwv_flow_region_report_filter (region_id)
/

prompt ...create table wwv_flow_hnt_procedure_info

create table wwv_flow_hnt_procedure_info (
    procedure_id     number        not null,
    schema           varchar2(30)  not null,
    procedure_name   varchar2(61)  not null,
    --
    title            varchar2(255),
    created_by       varchar2(255)  not null,
    created_on       date          not null,
    last_updated_by  varchar2(255),
    last_updated_on  date )
/

alter table wwv_flow_hnt_procedure_info
    add constraint wwv_flow_hnt_proc_info_pk
        primary key (procedure_id)
/
alter table wwv_flow_hnt_procedure_info
    add constraint wwv_flow_hnt_proc_info_uk
        unique (schema, procedure_name)
/

comment on table wwv_flow_hnt_procedure_info is 'Contains information about each procedure in a schema.  This can be just a procedure or a procedure within a package.  This can be used by the wizards to default forms.';
comment on column wwv_flow_hnt_procedure_info.procedure_id is 'System generated PK.';
comment on column wwv_flow_hnt_procedure_info.schema is 'Name of the schema owning the procedure.';
comment on column wwv_flow_hnt_procedure_info.procedure_name is 'Name of the procedure or package and procedure in "package.procedure" format.';
comment on column wwv_flow_hnt_procedure_info.title is 'Will become the region title.';
comment on column wwv_flow_hnt_procedure_info.created_by is 'Auditing; user that created the record.';
comment on column wwv_flow_hnt_procedure_info.created_on is 'Auditing; date the record was created.';
comment on column wwv_flow_hnt_procedure_info.last_updated_by is 'Auditing; user that last modified the record.';
comment on column wwv_flow_hnt_procedure_info.last_updated_on is 'Auditing; date the record was last modified.';


prompt ...create table wwv_flow_hnt_argument_info

create table wwv_flow_hnt_argument_info (
    argument_id         number        not null,
    procedure_id        number        not null,
    argument_name       varchar2(30)  not null,
    --
    label               varchar2(255),
    help_text           varchar2(4000),
    mask                varchar2(255),
    display_seq_form    number,
    display_in_form     varchar2(1)  constraint wwv_flow_hnt_display_in_form check (display_in_form in ('Y','N')),
    display_as_form     varchar2(50) constraint wwv_flow_hnt_display_as_form check (display_as_form in (
                                    'DISPLAY_ONLY_PLSQL',
                                    'FILE',
                                    'BUTTON',
                                    'HIDDEN',
                                    'HIDDEN_PROTECTED',
                                    'DISPLAY_ONLY_HTML',
                                    'STOP_AND_START_HTML_TABLE',
                                    'DISPLAY_ONLY_ESCAPE_SC',
                                    'IMAGE',
                                    'DISPLAY_AND_SAVE',
                                    'DISPLAY_AND_SAVE_LOV',
                                    'CHECKBOX',
                                    'POPUP',
                                    'POPUP_FILTER',
                                    'POPUP2',
                                    'POPUP3',
                                    'POPUP4',
                                    'POPUP5',
                                    'POPUP6',
                                    'POPUP_KEY_LOV',
                                    'PICK_DATE_USING_APP_FORMAT_MASK',
                                    'PICK_DATE_USING_APP_DATE_FORMAT',
                                    'PICK_DATE_USING_FORMAT_MASK',
                                    'PICK_DATE_DD_MON_RR',
                                    'PICK_DATE_DD_MON_RR_HH_MI',
                                    'PICK_DATE_DD_MON_RR_HH24_MI',
                                    'PICK_DATE_DD_MON_YYYY',
                                    'PICK_DATE_DD_MON_YYYY_HH_MI',
                                    'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                    'PICK_DATE_DD_MM_YYYY',
                                    'PICK_DATE_DD_MM_YYYY_HH_MI',
                                    'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                    'PICK_DATE_MM_DD_YYYY',
                                    'PICK_DATE_MM_DD_YYYY_HH_MI',
                                    'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                    'PICK_DATE_DD_MON_YY',
                                    'PICK_DATE_DD_MON_YY_HH_MI',
                                    'PICK_DATE_DD_MON_YY_HH24_MI',
                                    'PICK_DATE_YYYY_MM_DD',
                                    'PICK_DATE_YYYY_MM_DD_HH_MI',
                                    'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                    'PICK_DATE_RR_MON_DD',
                                    'PICK_DATE_RR_MON_DD_HH_MI',
                                    'PICK_DATE_RR_MON_DD_HH24_MI',
                                    'PICK_DATE_DD_MM_YYYY_DASH',
                                    'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                    'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                    'PICK_DATE_DD_MM_YYYY_DOT',
                                    'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                    'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                    'PICK_DATE_YYYY_DD_MM_DOT',
                                    'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                    'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                    'PICK_DATE_YYYY_MM_DD_SLASH',
                                    'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                    'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                    'DISPLAY_ONLY_LOV',
                                    'COMBOBOX',
                                    'SHOW_AS_SL_WITH_POPUP',
                                    'COMBOBOX_WITH_URL_REDIRECT',
                                    'COMBOBOX_WITH_BRANCH_TO_PAGE',
                                    'COMBOBOX_WITH_SUBMIT',
                                    'COMBOBOX_WITH_JS_POST',
                                    'COMBOBOX_WITH_JS_REDIRECT',
                                    'MULTIPLESELECT',
                                    'RADIOGROUP',
                                    'RADIOGROUP2',
                                    'RADIOGROUP_WITH_REDIRECT',
                                    'RADIOGROUP_WITH_SUBMIT',
                                    'RADIOGROUP_WITH_JS_SUBMIT',
                                    'TEXTAREA',
                                    'TEXTAREA_WITH_SPELL_CHECK',
                                    'TEXTAREA-AUTO-HEIGHT',
                                    'TEXTAREA_WITH_CONTROLS',
                                    'TEXTAREA_WITH_HTML_EDITOR_BASIC',
                                    'TEXTAREA_WITH_HTML_EDITOR_STANDARD',
                                    'TEXTAREA_CHAR_COUNT',
                                    'TEXTAREA_CHAR_COUNT_SPELL',
                                    'TEXT',
                                    'TEXT_DISABLED',
                                    'TEXT_DISABLED_AND_SAVE',
                                    'TEXT_WITH_CALCULATOR',
                                    'PASSWORD',
                                    'LIST_MGR',
                                    'LIST_MGR2',
                                    'LIST_MGR3',
                                    'LIST_MGR_VIEW',
                                    'LIST_MGR_VIEW2')),
    lov_query            varchar2(4000),
    default_value        varchar2(255),
    required             varchar2(1) check (required in ('Y','N')),
    alignment            varchar2(1) check (alignment in ('L','C','R')),
    display_width        number,
    max_width            number,
    height               number,
    created_by           varchar2(255)   not null,
    created_on           date           not null,
    last_updated_by      varchar2(255),
    last_updated_on      date )
/

alter table wwv_flow_hnt_argument_info
    add constraint wwv_flow_hnt_arg_info_pk
        primary key (argument_id)
/

alter table wwv_flow_hnt_argument_info
    add constraint wwv_flow_hnt_arg_info_uk
        unique (procedure_id, argument_name)
/

alter table wwv_flow_hnt_argument_info
    add constraint wwv_flow_hnt_arg_info_proc_fk
        foreign key (procedure_id)
        references wwv_flow_hnt_procedure_info
        on delete cascade
/

comment on table wwv_flow_hnt_argument_info is 'Contains information about each argument in each procedure in a schema.  This information can be used by the wizards to default forms.';
comment on column wwv_flow_hnt_argument_info.argument_id is 'System generated PK.';
comment on column wwv_flow_hnt_argument_info.procedure_id is 'FK to wwv_flow_hnt_procedure_info.';
comment on column wwv_flow_hnt_argument_info.argument_name is 'Name of the argument within the procedure.';
comment on column wwv_flow_hnt_argument_info.label is 'Will become the label of the item.';
comment on column wwv_flow_hnt_argument_info.help_text is 'Will become item help.';
comment on column wwv_flow_hnt_argument_info.mask is 'A mask that would be applied against the data, such as 999-99-9999.';
comment on column wwv_flow_hnt_argument_info.display_seq_form is 'Display sequence of items in a form.';
comment on column wwv_flow_hnt_argument_info.display_in_form is 'Indicates whether this argument would typically be displayed in a form.';
comment on column wwv_flow_hnt_argument_info.display_as_form is 'Indicates how the item would typcially be displayed, such as BUTTON or CHECKBOX, in a form.';
comment on column wwv_flow_hnt_argument_info.lov_query is 'Will be used to generate a lov.  This will only be valid for certain "display_as" types.';
comment on column wwv_flow_hnt_argument_info.default_value is 'The default value associated with this argument.';
comment on column wwv_flow_hnt_argument_info.required is 'Will be used to generate a validation that the resulting item must be NOT NULL.';
comment on column wwv_flow_hnt_argument_info.display_width is 'Will be used for display width.';
comment on column wwv_flow_hnt_argument_info.max_width is 'The maximum string length that a user would be allowed to enter in this item.';
comment on column wwv_flow_hnt_argument_info.height is 'Will be used as the display height of item.';
comment on column wwv_flow_hnt_argument_info.created_by is 'Auditing; user that created the record.';
comment on column wwv_flow_hnt_argument_info.created_on is 'Auditing; date the record was created.';
comment on column wwv_flow_hnt_argument_info.last_updated_by is 'Auditing; user that last modified the record.';
comment on column wwv_flow_hnt_argument_info.last_updated_on is 'Auditing; date the record was last modified.';
comment on column wwv_flow_hnt_argument_info.alignment is 'Will be used for alignment in reporting; Left, Center, or Right.';

create table wwv_flow_charsets (
    id                         number
                               constraint wwv_flow_charsets_pk
                               primary key,
    display_name               varchar2(4000) not null,
    iana_charset               varchar2(255)  not null,
    db_charset                 varchar2(255)  not null
    )
/


create or replace view wwv_flow_format_masks as
select to_char((5234 + 10/100),'FML999G999G999G999G990D00') d, 'FML999G999G999G999G990D00' r, 'N' t from dual
    union all
select trim(to_char((5234 + 10/100),'999G999G999G999G990D00')) d, '999G999G999G999G990D00' r, 'N' t from dual
    union all
select trim(to_char((5234 + 10/100),'999G999G999G999G990D0000')) d, '999G999G999G999G990D0000' r, 'N' t from dual
    union all
select trim(to_char(5234,'999G999G999G999G999G999G990')) d, '999G999G999G999G999G999G990' r, 'N' t from dual
    union all
select trim(to_char((-5234 - 10/100),'999G999G999G999G990D00MI')) d, '999G999G999G999G990D00MI' r, 'N' t from dual
    union all
select trim(to_char((-5234 - 10/100),'S999G999G999G999G990D00')) d, 'S999G999G999G999G990D00' r, 'N' t from dual
    union all
select trim(to_char((-5234 - 10/100),'999G999G999G999G990D00PR')) d, '999G999G999G999G990D00PR' r, 'N' t from dual
    union all
select to_char(to_date('20040112143000','YYYYMMDDHH24MISS'),'DD-MON-RR') d, 'DD-MON-RR' r, 'D' t from dual
    union all
select to_char(to_date('20040112143000','YYYYMMDDHH24MISS'),'DD-MON-YYYY') d, 'DD-MON-YYYY' r, 'D' t from dual
    union all
select to_char(to_date('20040112143000','YYYYMMDDHH24MISS'),'DD-MON') d, 'DD-MON' r, 'D' t from dual
    union all
select to_char(to_date('20040112143000','YYYYMMDDHH24MISS'),'RR-MON-DD') d, 'RR-MON-DD' r, 'D' t from dual
    union all
select to_char(to_date('20040112143000','YYYYMMDDHH24MISS'),'YYYY-MM-DD') d, 'YYYY-MM-DD' r, 'D' t from dual
    union all
select to_char(to_date('20040112143000','YYYYMMDDHH24MISS'),'fmDay, fmDD fmMonth, YYYY') d, 'fmDay, fmDD fmMonth, YYYY' r, 'D' t from dual
    union all
select to_char(to_date('20040112143000','YYYYMMDDHH24MISS'),'DD-MON-YYYY HH24:MI') d, 'DD-MON-YYYY HH24:MI' r, 'D' t from dual
    union all
select to_char(to_date('20040112143000','YYYYMMDDHH24MISS'),'DD-MON-YYYY HH24:MI:SS') d, 'DD-MON-YYYY HH24:MI:SS' r, 'D' t from dual
    union all
select to_char(to_date('20040112143000','YYYYMMDDHH24MISS'),'DD-MON-YYYY HH:MIPM') d, 'DD-MON-YYYY HH:MIPM' r, 'D' t from dual
    union all
select to_char(to_date('20040112143000','YYYYMMDDHH24MISS'),'Month') d, 'Month' r, 'D' t from dual
    union all
select wwv_flow_lang.system_message('SINCE_DATE_MASK') d, 'SINCE' r, 'D' t from dual
/

create table wwv_flow_customized_tasks (
    id                          number primary key,
    task_name                   varchar2(4000),
    task_link                   varchar2(4000) null,
    display_sequence            number,
    display_location            varchar2(30)
                                constraint wwv_flow_ctasks_location
                                check (display_location in ('WORKSPACE_HOME','WORKSPACE_LOGIN')),
    displayed                   varchar2(1)
                                constraint wwv_flow_ctasks_displayed
                                check (displayed in ('Y','N')),
    security_group_id number    null)
/


create table wwv_flow_page_groups (
    id                number
                      constraint wwv_flow_page_grp_pk
                      primary key,
    flow_id           number
                      references wwv_flows
                      on delete cascade,
    group_name        varchar2(255) not null,
    group_desc        varchar2(4000),
    security_group_id number not null)
/

create index wwv_flow_page_groups_idx on wwv_flow_page_groups(flow_id)
/


--
-- T H E M E / T E M P L A T E   V I E W S
--

-- view to report on defined templates
create or replace view wwv_flow_templates_all
(flow_id, theme_id, theme_class_id, temp_type, name, id)
as
select flow_id, theme_id, theme_class_id, 'PAGE' temp_type, name ,id from wwv_flow_templates -- page
union all
select flow_id, theme_id, theme_class_id, 'REGION' temp_type, PAGE_PLUG_TEMPLATE_NAME ,id from wwv_flow_page_plug_templates -- region
union all
select flow_id, theme_id, theme_class_id, 'REPORT' temp_type, ROW_TEMPLATE_NAME ,id from wwv_flow_row_templates -- report
union all
select flow_id, theme_id, theme_class_id, 'LIST' temp_type, LIST_TEMPLATE_NAME ,id from wwv_flow_list_templates -- list
union all
select flow_id, theme_id, theme_class_id, 'LABEL' temp_type, TEMPLATE_NAME ,id from wwv_flow_field_templates -- label
union all
select flow_id, theme_id, theme_class_id, 'BUTTON' temp_type, TEMPLATE_NAME ,id from wwv_flow_button_templates -- button
union all
select flow_id, theme_id, theme_class_id, 'MENU' temp_type, name ,id from wwv_flow_menu_templates -- menu
union all
select flow_id, theme_id, theme_class_id, 'CALENDAR' temp_type, name  ,id from wwv_flow_cal_templates -- calendar
union all
select flow_id, theme_id, theme_class_id, 'POPUP' temp_type, page_name ,id from wwv_flow_popup_lov_template -- popup_lov
/

-- view to report on defined templates
create or replace view wwv_flow_templates_used
(flow_id, temp_type, id, name,
 theme_id, theme_class_id)
as
select t.*, a.name, to_char(a.theme_id),a.theme_class_id from (
select flow_id, 'PAGE' temp_type ,to_char(step_template) id from wwv_flow_steps where step_template is not null
-- region
union all
select flow_id, 'REGION', to_char(plug_template) from wwv_flow_page_plugs where (plug_template != 0 and plug_template is not null)
-- report
union all
select flow_id,'REPORT',to_char(plug_query_row_template) from wwv_flow_page_plugs where (plug_query_row_template not in (1,2,3) and plug_query_row_template is not null)
-- list
union all
select flow_id,'LIST',to_char(list_template_id) from wwv_flow_page_plugs where list_template_id is not null
--select flow_id, 'LIST',display_row_template_id from wwv_flow_lists where display_row_template_id is not null
-- label
union all
select flow_id, 'LABEL',to_char(item_field_template) from wwv_flow_step_items where item_field_template is not null
-- button
union all
select flow_id,'BUTTON',to_char(nvl(button_image,'-99')) id from (select flow_id,substr(button_image,10) button_image from wwv_flow_step_buttons where substr(button_image,1,9) = 'template:')
union all
select flow_id,'BUTTON',to_char(nvl(tag_attributes,'-99')) id from (select flow_id,substr(tag_attributes,10) tag_attributes from wwv_flow_step_items where substr(tag_attributes,1,9) = 'template:')
-- menu
union all
select flow_id,'MENU',to_char(menu_template_id) from wwv_flow_page_plugs where menu_template_id is not null
-- calendar
union all
select flow_id, 'CALENDAR',to_char(template_id) from wwv_flow_cals where template_id is not null
-- default page template
union all
select id, 'PAGE' temp_type, to_char(default_page_template) from wwv_flows
) t, wwv_flow_templates_all a where a.temp_type = t.temp_type and a.id = t.id
/


create table wwv_flow_online_help(
    id                number
                      constraint wwv_flow_online_help_pk
                      primary key,
    url               varchar2(4000) not null,
    filename          varchar2(4000) not null,
    title             varchar2(4000) not null,
    plaintext         clob )
/

create table wwv_flow_online_help_ja(
    id                number
                      constraint wwv_flow_online_help_ja_pk
                      primary key,
    url               varchar2(4000) not null,
    filename          varchar2(4000) not null,
    title             varchar2(4000) not null,
    cset              varchar2(100)  not null,
    plaintext         clob )
/

create table wwv_flow_restricted_schemas(
    id                number
                      constraint wwv_flow_restrict_schema_pk primary key,
    schema            varchar2(30)       not null,
    created_by        varchar2(255)      not null,
    created_on        date               not null,
    last_updated_by   varchar2(255),
    last_updated_on   date)
/

create unique index wwv_flow_restricted_schemas_uk on wwv_flow_restricted_schemas(schema)
/

create table wwv_flow_rschema_exceptions (
    id                number
                      constraint wwv_flow_rschema_exceptions_pk primary key,
    schema_id         number             not null
                      constraint wwv_flow_rschema_exceptions_fk
                      references wwv_flow_restricted_schemas(id)
                      on delete cascade,
    workspace_name    varchar2(255)      not null,
    created_by        varchar2(255)      not null,
    created_on        date               not null,
    last_updated_by   varchar2(255),
    last_updated_on   date)
/

create index wwv_flow_rs_exp_fk1 on wwv_flow_rschema_exceptions(schema_id)
/

create table wwv_flow_qb_saved_query(
    id                number
                      constraint wwv_flow_qb_saved_query_pk primary key,
    query_owner       varchar2(255)      not null,
    title             varchar2(255)      not null,
    qb_sql            clob,
    description       varchar2(4000),
    query_type        varchar2(1)        not null
                      check (query_type in ('P','R','W')),
    created_by        varchar2(255)      not null,
    created_on        date               not null,
    last_updated_by   varchar2(255),
    last_updated_on   date,
    security_group_id number             not null
                      constraint wwv_flow_qb_saved_query_fk
                      references wwv_flow_companies(provisioning_company_id)
                      on delete cascade)
/

create index wwv_flow_qb_saved_query_fkidx on wwv_flow_qb_saved_query(security_group_id)
/
create unique index wwv_flow_qb_saved_query_uk on wwv_flow_qb_saved_query(title, created_by, security_group_id )
/


create table wwv_flow_qb_saved_cond(
  id     number                          not null,
  col    varchar2(255)                   not null,
  alias  varchar2(255)                   not null,
  fv     varchar2(255),
  fp     varchar2(255),
  out    varchar2(255)    constraint wwv_flow_qb_saved_cond_out
                          check (out in ('true','false')),
  st     varchar2(255)    constraint wwv_flow_qb_saved_cond_st
                          check (st in ('ASC','DESC')),
  so     varchar2(255),
  grp    varchar2(255)    constraint wwv_flow_qb_saved_cond_grp
                          check (grp in ('true','false')),
  con    varchar2(255),
  ord    number                          not null,
  security_group_id number               not null,
  constraint pk_wwv_flow_qb_saved_cond primary key (id, col),
  foreign key (id)
    references wwv_flow_qb_saved_query (id)
    on delete cascade)
/

create table wwv_flow_qb_saved_join(
  id      number                         not null,
  field1  varchar2(255)                  not null,
  field2  varchar2(255)                  not null,
  cond    varchar2(1)                    not null,
  security_group_id number               not null,
  constraint pk_wwv_flow_qb_saved_join primary key (id, field1, field2),
  foreign key (id)
    references wwv_flow_qb_saved_query (id)
    on delete cascade)
/

create table wwv_flow_qb_saved_tabs(
  id     number                             not null,
  oid    number                             not null,
  cnt    number                             not null,
  top    varchar2(255),
  left   varchar2(255),
  tname  varchar2(255)                      not null,
  security_group_id number                  not null,
  constraint pk_wwv_flow_qb_saved_tabs primary key (id, oid, cnt),
  foreign key (id)
    references wwv_flow_qb_saved_query (id)
    on delete cascade)
/


create table  wwv_flow_models  (
   id                number         not null
                        constraint wwv_flow_models_pk primary key,
   security_group_id number not null
                        constraint wwv_flow_models_fk
                            references wwv_flow_companies(provisioning_company_id)
                            on delete cascade,
   session_id        number not null,
   flow_id           number,
   owner             varchar2(4000),
   name              varchar2(4000),
   model_complete    varchar2(1)
                         constraint wwv_flow_model_complete
                              check (model_complete in (
                                 'Y',
                                 'N')),
   created_by        varchar2(255)  not null,
   created_on        date           not null,
   last_updated_by   varchar2(255),
   last_updated_on   date
)
/

create index wwv_flow_models_sec_group_idx on wwv_flow_models (security_group_id)
/


create table  wwv_flow_model_pages (
   id                       number        not null
                                constraint wwv_flow_model_pages_pk primary key,
   model_id                 number        not null
                                constraint wwv_flow_model_pages_fk
                                references wwv_flow_models (id)
                                    on delete cascade,
   page_id                  number,
   parent_page_id           number
                                constraint wwv_flow_model_pages_fk2
                                references wwv_flow_model_pages (id)
                                    on delete cascade,
   display_sequence         number,
   page_type                varchar2(255)
                                constraint wwv_flow_mp_page_type
                                check (page_type in (
                                    'BLANK',
                                    'REPORT',
                                    'FORM',
                                    'TABULARFORM',
                                    'REPORTANDFORM',
                                    'PIE_CHART',
                                    'BAR_CHART',
                                    'MASTERDETAIL')),
   page_source              varchar2(255)
                                constraint wwv_flow_mp_page_source
                                check (page_source in (
                                    'TABLE',
                                    'QUERY',
                                    'SPREADSHEET')),
   page_name                varchar2(255),
   source                   clob,
   security_group_id        number         not null,
   block_id                 number,
   report_id                number,
   mig_comments             varchar2(4000),
   created_by               varchar2(255)  not null,
   created_on               date           not null,
   last_updated_by          varchar2(255),
   last_updated_on          date
)
/

create index wwv_flow_model_pages_model_idx on wwv_flow_model_pages (model_id)
/

create index wwv_flow_mp_parent_page_idx on wwv_flow_model_pages (parent_page_id)
/

create index wwv_flow_mp_block_id_idx on wwv_flow_model_pages (block_id)
/

create index wwv_flow_mp_rep_id_idx on wwv_flow_model_pages (report_id)
/

create table wwv_flow_model_page_regions (
   id                   number not null
                          constraint wwv_flow_mpr_pk primary key,
   model_page_id        number not null
                           constraint wwv_flow_mpr_fk
                           references wwv_flow_model_pages (id)
                             on delete cascade,
   region_id            number,
   region_name          varchar2(4000),
   region_source        varchar2(255),
   source               clob,
   display_sequence     number,
   report_implementation    varchar(30)
                                constraint wwv_flow_mpr_rpt_impl_type
                                check (report_implementation in  (
                                    'CLASSIC',
                                    'INTERACTIVE'
                                )),
   search_enabled           varchar2(1)
                                constraint wwv_flow_mpr_search_enables
                                check (search_enabled in (
                                    'Y',
                                    'N')),
   link_column              varchar2(255),
   link_text                varchar2(255),
   parent_link_from_column1 varchar2(255),
   parent_link_from_column2 varchar2(255),
   link_to_column1          varchar2(255),
   link_to_column2          varchar2(255),
   report_filter            varchar2(255),
   column_heading_sorting   varchar2(255),
   download_link            varchar2(255),
   security_group_id        number         not null,
   created_by               varchar2(255)  not null,
   created_on               date           not null,
   last_updated_by          varchar2(255),
   last_updated_on          date
)
/

create index wwv_flow_mpr_model_idx on wwv_flow_model_page_regions (model_page_id)
/

create table  wwv_flow_model_page_cols  (
   id                   number         not null
                           constraint wwv_flow_model_page_cols_pk primary key,
   model_region_id        number         not null
                           constraint wwv_flow_model_page_cols_fk
                           references wwv_flow_model_page_regions (id)
                             on delete cascade,
   column_name          varchar2(4000),
   column_display_name  varchar2(4000),
   column_sequence      number,
   help_text            varchar2(4000),
   display_as_form      varchar2(50)
                            constraint wwv_mpc_display_as_form
                            check (display_as_form in (
                                'DISPLAY_ONLY_PLSQL',
                                'FILE',
                                'BUTTON',
                                'HIDDEN',
                                'HIDDEN_PROTECTED',
                                'DISPLAY_ONLY_HTML',
                                'STOP_AND_START_HTML_TABLE',
                                'DISPLAY_ONLY_ESCAPE_SC',
                                'IMAGE',
                                'DISPLAY_AND_SAVE',
                                'DISPLAY_AND_SAVE_LOV',
                                'CHECKBOX',
                                'POPUP',
                                'POPUP_FILTER',
                                'POPUP2',
                                'POPUP3',
                                'POPUP4',
                                'POPUP5',
                                'POPUP6',
                                'POPUP_KEY_LOV',
                                'POPUP_KEY_LOV_NOFETCH',
                                'PICK_DATE_USING_FLOW_FORMAT_MASK',
                                'PICK_DATE_USING_APP_FORMAT_MASK',
                                'PICK_DATE_USING_APP_DATE_FORMAT',
                                'PICK_DATE_USING_FORMAT_MASK',
                                'PICK_DATE_DD_MON_RR',
                                'PICK_DATE_DD_MON_RR_HH_MI',
                                'PICK_DATE_DD_MON_RR_HH24_MI',
                                'PICK_DATE_DD_MON_YY',
                                'PICK_DATE_DD_MON_YY_HH_MI',
                                'PICK_DATE_DD_MON_YY_HH24_MI',
                                'PICK_DATE_DD_MON_YYYY',
                                'PICK_DATE_DD_MON_YYYY_HH_MI',
                                'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY',
                                'PICK_DATE_DD_MM_YYYY_HH_MI',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                'PICK_DATE_MM_DD_YYYY',
                                'PICK_DATE_MM_DD_YYYY_HH_MI',
                                'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD',
                                'PICK_DATE_YYYY_MM_DD_HH_MI',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                'PICK_DATE_RR_MON_DD',
                                'PICK_DATE_RR_MON_DD_HH_MI',
                                'PICK_DATE_RR_MON_DD_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                'PICK_DATE_YYYY_DD_MM_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                'DISPLAY_ONLY_LOV',
                                'COMBOBOX',
                                'SHOW_AS_SL_WITH_POPUP',
                                'COMBOBOX_WITH_URL_REDIRECT',
                                'COMBOBOX_WITH_BRANCH_TO_PAGE',
                                'COMBOBOX_WITH_SUBMIT',
                                'COMBOBOX_WITH_JS_POST',
                                'COMBOBOX_WITH_JS_REDIRECT',
                                'MULTIPLESELECT',
                                'RADIOGROUP',
                                'RADIOGROUP2',
                                'RADIOGROUP_WITH_REDIRECT',
                                'RADIOGROUP_WITH_SUBMIT',
                                'RADIOGROUP_WITH_JS_SUBMIT',
                                'TEXTAREA',
                                'TEXTAREA_WITH_SPELL_CHECK',
                                'TEXTAREA-AUTO-HEIGHT',
                                'TEXTAREA_WITH_CONTROLS',
                                'TEXTAREA_WITH_HTML_EDITOR_BASIC',
                                'TEXTAREA_WITH_HTML_EDITOR_STANDARD',
                                'TEXTAREA_CHAR_COUNT',
                                'TEXTAREA_CHAR_COUNT_SPELL',
                                'TEXT',
                                'TEXT_WITH_ENTER_SUBMIT',
                                'TEXT_DISABLED',
                                'TEXT_DISABLED_AND_SAVE',
                                'TEXT_WITH_CALCULATOR',
                                'PASSWORD',
                                'PASSWORD_WITH_ENTER_SUBMIT',
                                'PASSWORD_DNSS',
                                'PASSWORD_WITH_SUBMIT_DNSS',
                                'LIST_MGR',
                                'LIST_MGR2',
                                'LIST_MGR3',
                                'LIST_MGR_VIEW',
                                'LIST_MGR_VIEW2')),
   display_as_tab_form varchar2(255)
                            constraint wwv_mpc_display_as_tab_form
                            check (display_as_tab_form in (
                                'READONLY',
                                'DISPLAY_AND_SAVE',
                                'WITHOUT_MODIFICATION',
                                'ESCAPE_SC',
                                'TEXT',
                                'TEXTAREA',
                                'TEXT_FROM_LOV',
                                'SELECT_LIST',
                                'SELECT_LIST_FROM_LOV',
                                'SELECT_LIST_FROM_QUERY',
                                'HIDDEN',
                                'HIDDEN_PROTECTED',
                                'POPUP',
                                'POPUP_QUERY',
                                'DATE_POPUP',
                                'PICK_DATE_USING_APP_FORMAT_MASK',
                                'PICK_DATE_USING_APP_DATE_FORMAT',
                                'PICK_DATE_USING_FORMAT_MASK',
                                'PICK_DATE_DD_MON_RR',
                                'PICK_DATE_DD_MON_RR_HH_MI',
                                'PICK_DATE_DD_MON_RR_HH24_MI',
                                'PICK_DATE_DD_MON_YY',
                                'PICK_DATE_DD_MON_YY_HH_MI',
                                'PICK_DATE_DD_MON_YY_HH24_MI',
                                'PICK_DATE_DD_MON_YYYY',
                                'PICK_DATE_DD_MON_YYYY_HH_MI',
                                'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY',
                                'PICK_DATE_DD_MM_YYYY_HH_MI',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                'PICK_DATE_MM_DD_YYYY',
                                'PICK_DATE_MM_DD_YYYY_HH_MI',
                                'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD',
                                'PICK_DATE_YYYY_MM_DD_HH_MI',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                'PICK_DATE_RR_MON_DD',
                                'PICK_DATE_RR_MON_DD_HH_MI',
                                'PICK_DATE_RR_MON_DD_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                'PICK_DATE_YYYY_DD_MM_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                'CHECKBOX',
                                'RADIOGROUP')),
   datatype             varchar2(4000)
                            constraint datatype
                            check (datatype in ('DATE','NUMBER','VARCHAR2','BLOB','CLOB')),
   alignment            varchar2(4000)
                            constraint wwv_flow_mpc_alignment
                            check (alignment in ('LEFT','CENTER','RIGHT')),
   display_width        number,
   max_width            number,
   height               number,
   format_mask          varchar2(4000),
   hidden_column        varchar2(1),
   sort_sequence        number,
   sort_dir             number,        -- new 03/28, values ASC or DESC
   security_group_id    number         not null,
   created_by           varchar2(255)  not null,
   created_on           date           not null,
   last_updated_by      varchar2(255),
   last_updated_on      date
)
/

create index wwv_flow_mpc_mp_idx on wwv_flow_model_page_cols (model_region_id)
/

create table wwv_flow_sc_trans (
    session_id          number not null
                                  constraint wwv_flow_sc_trans_fk2
                                  references wwv_flow_sessions$(id)
                                  on delete cascade,
    transaction_id      number not null,
    security_group_id   number not null
                                  constraint wwv_flow_sc_trans_fk1
                                  references wwv_flow_companies(provisioning_company_id)
                                  on delete cascade,
    transaction_user    varchar2(2000) not null,
    transaction_schema  varchar2(2000) not null,
    transaction_type    varchar2(10) not null
                                 constraint wwv_flow_sc_trans_ck1
                                 check (transaction_type in (
                                 'STOP',
                                 'SQL',
                                 'PLSQL')),
    transaction_status  varchar2(1) not null
                                constraint wwv_flow_sc_trans_ck2
                                 check (transaction_status in (
                                 'N',
                                 'R')),
    transaction_rows    number not null,
    transaction_binds   varchar2(4000),
    transaction_sql     clob not null,
    transaction_result  clob,
    transaction_output  clob,
    created_on          date not null,
    updated_on          date
    );

alter table wwv_flow_sc_trans add constraint wwv_flow_sc_trans_pk primary key (SESSION_ID, transaction_id)
/

create index wwv_flow_sc_trans_fk1 on wwv_flow_sc_trans (security_group_id)
/



create table wwv_flow_report_layouts (
    id                             number
                                       constraint wwv_flow_report_layouts_pk
                                       primary key,
    flow_id                        number not null
                                       constraint wwv_flow_report_layoutse_fk
                                       references wwv_flows
                                       on delete cascade,
    report_layout_name             varchar2(4000) not null,
    report_layout_type             varchar2(255) constraint wwv_flow_report_layout_type
                                     check (report_layout_type in (
                                          'RTF_FILE',
                                          'XSL_FILE',
                                          'XSL_GENERIC'
                                      )),
    --
    page_template                  clob not null,
    xslfo_column_heading_template  varchar2(4000),
    xslfo_column_template          varchar2(4000),
    xslfo_column_template_width    varchar2(4000),
    --
    reference_id                   number,
    security_group_id              number not null,
    --
    created_on                     date,
    created_by                     varchar2(255),
    last_updated_by                varchar2(255),
    last_updated_on                date,
    --
    report_layout_comment          varchar2(4000)
    ) lob (page_template) store as (cache reads enable storage in row)
/

create index wwv_flow_report_layouts_idx1 on wwv_flow_report_layouts (flow_id,security_group_id)
/
create unique index wwv_flow_report_layouts_idx2 on wwv_flow_report_layouts(flow_id,substr(report_layout_name,1,500))
/


----------------
-- I N S T A L L
--

create table wwv_flow_install (
     id                        number
                               constraint wwv_flow_install_pk
                               primary key,
     flow_id                   number  not null
                               constraint wwv_flow_install_fk
                               references wwv_flows
                               on delete cascade,
     security_group_id         number not null
                               constraint wwv_flow_install_fk2
                               references wwv_flow_companies(provisioning_company_id),
     --
     include_in_export_yn      varchar2(1)
                               constraint wwv_install_in_export
                               check (include_in_export_yn in ('Y','N')),
     --
     welcome_message           varchar2(4000),
     license_message           varchar2(4000),
     configuration_message     varchar2(4000),
     build_options_message     varchar2(4000),
     validation_message        varchar2(4000),
     install_message           varchar2(4000),
     install_success_message   varchar2(4000),
     install_failure_message   varchar2(4000),
     --
     get_version_sql_query     varchar2(4000),
     upgrade_message           varchar2(4000),
     upgrade_confirm_message   varchar2(4000),
     upgrade_success_message   varchar2(4000),
     upgrade_failure_message   varchar2(4000),
     --
     deinstall_message         varchar2(4000),
     deinstall_success_message varchar2(4000),
     deinstall_failure_message varchar2(4000),
     deinstall_script          clob,
     --
     prompt_substitution_01_yn varchar2(1)
                               constraint wwv_install_sub_01
                               check (prompt_substitution_01_yn in ('Y','N')),
     prompt_substitution_02_yn varchar2(1)
                               constraint wwv_install_sub_02
                               check (prompt_substitution_02_yn in ('Y','N')),
     prompt_substitution_03_yn varchar2(1)
                               constraint wwv_install_sub_03
                               check (prompt_substitution_03_yn in ('Y','N')),
     prompt_substitution_04_yn varchar2(1)
                               constraint wwv_install_sub_04
                               check (prompt_substitution_04_yn in ('Y','N')),
     prompt_substitution_05_yn varchar2(1)
                               constraint wwv_install_sub_05
                               check (prompt_substitution_05_yn in ('Y','N')),
     prompt_substitution_06_yn varchar2(1)
                               constraint wwv_install_sub_06
                               check (prompt_substitution_06_yn in ('Y','N')),
     prompt_substitution_07_yn varchar2(1)
                               constraint wwv_install_sub_07
                               check (prompt_substitution_07_yn in ('Y','N')),
     prompt_substitution_08_yn varchar2(1)
                               constraint wwv_install_sub_08
                               check (prompt_substitution_08_yn in ('Y','N')),
     prompt_substitution_09_yn varchar2(1)
                               constraint wwv_install_sub_09
                               check (prompt_substitution_09_yn in ('Y','N')),
     prompt_substitution_10_yn varchar2(1)
                               constraint wwv_install_sub_10
                               check (prompt_substitution_10_yn in ('Y','N')),
     prompt_substitution_11_yn varchar2(1)
                               constraint wwv_install_sub_11
                               check (prompt_substitution_11_yn in ('Y','N')),
     prompt_substitution_12_yn varchar2(1)
                               constraint wwv_install_sub_12
                               check (prompt_substitution_12_yn in ('Y','N')),
     prompt_substitution_13_yn varchar2(1)
                               constraint wwv_install_sub_13
                               check (prompt_substitution_13_yn in ('Y','N')),
     prompt_substitution_14_yn varchar2(1)
                               constraint wwv_install_sub_14
                               check (prompt_substitution_14_yn in ('Y','N')),
     prompt_substitution_15_yn varchar2(1)
                               constraint wwv_install_sub_15
                               check (prompt_substitution_15_yn in ('Y','N')),
     prompt_substitution_16_yn varchar2(1)
                               constraint wwv_install_sub_16
                               check (prompt_substitution_16_yn in ('Y','N')),
     prompt_substitution_17_yn varchar2(1)
                               constraint wwv_install_sub_17
                               check (prompt_substitution_17_yn in ('Y','N')),
     prompt_substitution_18_yn varchar2(1)
                               constraint wwv_install_sub_18
                               check (prompt_substitution_18_yn in ('Y','N')),
     prompt_substitution_19_yn varchar2(1)
                               constraint wwv_install_sub_19
                               check (prompt_substitution_19_yn in ('Y','N')),
     prompt_substitution_20_yn varchar2(1)
                               constraint wwv_install_sub_20
                               check (prompt_substitution_20_yn in ('Y','N')),
     install_prompt_01         varchar2(255),
     install_prompt_02         varchar2(255),
     install_prompt_03         varchar2(255),
     install_prompt_04         varchar2(255),
     install_prompt_05         varchar2(255),
     install_prompt_06         varchar2(255),
     install_prompt_07         varchar2(255),
     install_prompt_08         varchar2(255),
     install_prompt_09         varchar2(255),
     install_prompt_10         varchar2(255),
     install_prompt_11         varchar2(255),
     install_prompt_12         varchar2(255),
     install_prompt_13         varchar2(255),
     install_prompt_14         varchar2(255),
     install_prompt_15         varchar2(255),
     install_prompt_16         varchar2(255),
     install_prompt_17         varchar2(255),
     install_prompt_18         varchar2(255),
     install_prompt_19         varchar2(255),
     install_prompt_20         varchar2(255),
     --
     prompt_if_mult_auth_yn    varchar2(1)
                               constraint wwv_auth_prompt
                               check (prompt_if_mult_auth_yn in ('Y','N')),
     --
     trigger_install_when_cond varchar2(255),
     trigger_install_when_exp1 varchar2(4000),
     trigger_install_when_exp2 varchar2(4000),
     trigger_failure_message   varchar2(4000),
     required_free_kb          number,
     required_sys_privs        varchar2(4000),
     required_names_available  varchar2(4000),
     --
     last_updated_by           varchar2(255),
     last_updated_on           date,
     created_by                varchar2(255),
     created_on                date
)
/

create unique index wwv_flow_install_idx1 on wwv_flow_install (flow_id)
/
create index wwv_flow_install_idx2 on wwv_flow_install (security_group_id)
/

--------------------------------
-- I N S T A L L   S C R I P T S
--

create table wwv_flow_install_scripts (
    id                    number
                          constraint wwv_flow_install_scripts_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_install_scripts_fk
                          references wwv_flows,
    security_group_id     number not null
                          constraint wwv_flow_install_scripts_fk2
                          references wwv_flow_companies(provisioning_company_id),
    install_id            number  not null
                          constraint wwv_flow_install_scripts_fk3
                          references wwv_flow_install
                          on delete cascade,
    name                  varchar2(255) not null,
    sequence              number not null,
    script                clob not null,
    script_type           varchar2(30)
                          constraint wwv_flow_install_st_ck
                          check (script_type in ('INSTALL','UPGRADE','DEINSTALL')),
    ---
    condition_type        varchar2(255),
    condition             varchar2(4000),
    condition2            varchar2(4000),
    ---
    last_updated_by       varchar2(255),
    last_updated_on       date,
    created_by            varchar2(255),
    created_on            date
)
/
create unique index wwv_flow_install_scripts_idx1 on wwv_flow_install_scripts (flow_id, name, script_type)
/
create index wwv_flow_install_scripts_idx2 on wwv_flow_install_scripts (security_group_id)
/
create index wwv_flow_install_scripts_idx3 on wwv_flow_install_scripts (install_id)
/

--------------------------------
-- I N S T A L L   C H E C K S  (validations)
--

create table wwv_flow_install_checks (
    id                    number
                          constraint wwv_flow_install_checks_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_install_checks_fk
                          references wwv_flows,
    security_group_id     number not null
                          constraint wwv_flow_install_checks_fk2
                          references wwv_flow_companies(provisioning_company_id),
    install_id            number  not null
                          constraint wwv_flow_install_checks_fk3
                          references wwv_flow_install
                          on delete cascade,
    name                  varchar2(255) not null,
    sequence              number not null,
    check_type            varchar2(255),
    check_condition       varchar2(4000),
    check_condition2      varchar2(4000),
    failure_message       varchar2(4000),
    ---
    condition_type        varchar2(255),
    condition             varchar2(4000),
    condition2            varchar2(4000),
    ---
    last_updated_by       varchar2(255),
    last_updated_on       date,
    created_by            varchar2(255),
    created_on            date
)
/

create unique index wwv_flow_install_checks_idx1 on wwv_flow_install_checks (flow_id, name)
/
create index wwv_flow_install_checks_idx2 on wwv_flow_install_checks (security_group_id)
/
create index wwv_flow_install_checks_idx3 on wwv_flow_install_checks (install_id)
/


--------------------------------------------
-- I N S T A L L   B U I L D   O P T I O N S
--

create table wwv_flow_install_build_opt (
    id                    number
                          constraint wwv_flow_install_build_opt_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_install_build_opt_fk
                          references wwv_flows,
    security_group_id     number not null
                          constraint wwv_flow_install_build_opt_fk2
                          references wwv_flow_companies(provisioning_company_id),
    install_id            number  not null
                          constraint wwv_flow_install_build_opt_fk3
                          references wwv_flow_install
                          on delete cascade,
    build_opt_id          number  not null
                          constraint wwv_flow_install_build_opt_fk4
                          references wwv_flow_patches
                          on delete cascade
)
/

create index wwv_flow_install_build_idx1 on wwv_flow_install_build_opt (flow_id)
/
create index wwv_flow_install_build_idx2 on wwv_flow_install_build_opt (security_group_id)
/
create index wwv_flow_install_build_idx3 on wwv_flow_install_build_opt (install_id)
/
create index wwv_flow_install_build_idx4 on wwv_flow_install_build_opt (build_opt_id)
/

--------------------------------------------
-- A U D I T   T R A I L
--

create table wwv_flow_builder_audit_trail (
   id                        number
                             constraint wwv_flow_bld_audit_pk
                             primary key,
   audit_date                date,
   audit_action              varchar2(1)
                             constraint wwv_flow_bld_audit_ck_a
                             check (audit_action in ('I','U','D')),
   flow_table                varchar2(30),
   flow_table_pk             number,
   flow_user                 varchar2(255),
   flow_id                   number,
   page_id                   number,
   security_group_id         number not null,
   scn                       number,
   audit_comment             varchar2(255))
/

create index wwv_flow_build_audit_trail_i3 on wwv_flow_builder_audit_trail(flow_id, security_group_id)
/

create index wwv_flow_build_audit_trail_i5 on wwv_flow_builder_audit_trail(security_group_id,flow_user,flow_id,audit_date)
/



--------------------------------------------------------
-- S T A N D A R D    F I L E    R E P O S I T O R I E S
--


create table wwv_flow_standard_icons(
    id         number not null,
	icon_name  varchar2(255) not null,
	icon_size  number not null,
	constraint wwv_flow_standard_icons_pk primary key (id))
/

create unique index wwv_flow_std_icons_idx1 on wwv_flow_standard_icons (icon_name)
/


create table wwv_flow_standard_css (
	id              number not null,
	class_name      varchar2(4000) not null,
	definition      varchar2(4000) not null,
	example_01      varchar2(4000),
	example_02      varchar2(4000),
	class_category  varchar2(255),
	constraint wwv_flow_standard_css_pk primary key (id))
/

create table wwv_flow_standard_js (
    id                  number not null,
	javascript_name     varchar2(4000),
	javascript_syntax   varchar2(4000),
	example_01          varchar2(4000),
	example_02          varchar2(4000),
	example_03          varchar2(4000),
	constraint wwv_flow_standard_js_pk primary key (id) ) ;




create table wwv_flow_app_build_pref (
  id                                  number not null,
  security_group_id                   number not null
                                      constraint wwv_flow_app_bldprf_fk
                                      references wwv_flow_companies(provisioning_company_id)
                                      on delete cascade,
  default_parsing_schema              varchar2(255),
  default_authentication_scheme       varchar2(255),
  default_application_theme           number,
  default_tabs                        varchar2(255),
  default_proxy_server                varchar2(500),
  default_language                    varchar2(255),
  default_language_derived            varchar2(255),
  date_format                         varchar2(255),
  --
  created_on                          date,
  created_by                          varchar2(255),
  updated_on                          date,
  updated_by                          varchar2(255),
  constraint wwv_flow_app_bldprf_pk   primary key (id)
  );

create unique index wwv_flow_app_build_pref_idx1 on
    wwv_flow_app_build_pref (security_group_id);

create or replace trigger wwv_flow_biw_appbldpref
before insert or update on  wwv_flow_app_build_pref
for each row
begin
  if inserting and :new.id is null then
     :new.id := wwv_flow_id.next_val;
  end if;
  if inserting then
     :new.created_on := sysdate;
     :new.created_by := v('USER');
  end if;
  if updating then
     :new.updated_on := sysdate;
     :new.updated_by := v('USER');
  end if;
  if :new.security_group_id is null then
     :new.security_group_id := nvl(wwv_flow_security.g_security_group_id,0);
  end if;
end;
/

create table wwv_flow_flash_charts (
      id                            number
                                    constraint wwv_flow_flash_charts_pk
                                    primary key,
      flow_id                       number not null
                                    constraint wwv_flow_flash_charts_fk
                                    references wwv_flows
                                    on delete cascade,
      page_id                       number,
      region_id                     number not null
                                    constraint wwv_flow_flash_charts_fk2
                                    references wwv_flow_page_plugs
                                    on delete cascade,
      default_chart_type            varchar2(255) not null,
      chart_title                   varchar2(255),
      chart_width                   number,
      chart_height                  number,
      chart_animation               varchar2(255),
      display_attr                  varchar2(4000),
      dial_tick_attr                varchar2(4000),
      margins                       varchar2(4000),
      omit_label_interval           number,
      --
      color_scheme                  varchar2(255),
      custom_colors                 varchar2(4000),
      bgtype                        varchar2(255),
      bgcolor1                      varchar2(30),
      bgcolor2                      varchar2(30),
      gradient_rotation             number,
      --
      x_axis_title                  varchar2(4000),
      x_axis_min                    number,
      x_axis_max                    number,
      x_axis_grid_spacing           number,
      x_axis_prefix                 varchar2(4000),
      x_axis_postfix                varchar2(4000),
      x_axis_group_sep              varchar2(1)
                                    constraint wwv_flow_flash_charts_xgroup
                                      check (x_axis_group_sep in ('Y','N')),
      x_axis_decimal_place          number,
      y_axis_title                  varchar2(4000),
      y_axis_min                    number,
      y_axis_max                    number,
      y_axis_grid_spacing           number,
      y_axis_prefix                 varchar2(4000),
      y_axis_postfix                varchar2(4000),
      y_axis_group_sep              varchar2(1)
                                    constraint wwv_flow_flash_charts_ygroup
                                      check (y_axis_group_sep in ('Y','N')),
      y_axis_decimal_place          number,
      async_update                  varchar2(1)
                                    constraint wwv_flow_flash_charts_update
                                      check (async_update in ('Y','N')),
      async_time                    number,
      --
      names_font                    varchar2(4000),
      names_rotation                number,
      values_font                   varchar2(4000),
      values_rotation               number,
      hints_font                    varchar2(4000),
      legend_font                   varchar2(4000),
      grid_labels_font              varchar2(4000),
      chart_title_font              varchar2(4000),
      x_axis_title_font             varchar2(4000),
      y_axis_title_font             varchar2(4000),
      --
      use_chart_xml                 varchar2(1)
                                    constraint wwv_flow_flash_charts_xml
                                      check (use_chart_xml in ('Y','N')),
      chart_xml                     clob,
      attribute_01                  varchar2(4000),
      attribute_02                  varchar2(4000),
      attribute_03                  varchar2(4000),
      attribute_04                  varchar2(4000),
      attribute_05                  varchar2(4000),
      created_on                    date not null,
      created_by                    varchar2(255) not null,
      updated_on                    date,
      updated_by                    varchar2(255),
      security_group_id             number not null
  ) lob (chart_xml) store as (cache enable storage in row)
/

create index wwv_flow_fl_ch_fid_fk on wwv_flow_flash_charts (flow_id)
/

create index wwv_flow_fl_ch_fid_fk2 on wwv_flow_flash_charts (region_id)
/

create index wwv_flow_fl_ch_idx on wwv_flow_flash_charts(region_id, flow_id, security_group_id)
/

create table wwv_flow_flash_chart_series (
       id                           number
                                    constraint wwv_flow_flash_chart_series_pk
                                    primary key,
       chart_id                     number not null
                                    constraint wwv_flow_flash_chart_series_fk
                                    references wwv_flow_flash_charts
                                    on delete cascade,
       flow_id                      number,
       series_seq                   number not null,
       series_name                  varchar2(255) not null,
       series_query                 clob not null,
       series_query_type            varchar2(255) not null
                                    constraint wwv_flow_flash_query_type
                                       check (series_query_type in ('SQL_QUERY','FUNCTION_RETURNING_SQL_QUERY')),
       series_query_parse_opt       varchar2(255),
       series_query_no_data_found   varchar2(4000),
       series_query_row_count_max   number,
       created_on                   date not null,
       created_by                   varchar2(255) not null,
       updated_on                   date,
       updated_by                   varchar2(255),
       security_group_id            number not null
   )
/

create index wwv_flow_fl_ch_sr_idx on wwv_flow_flash_chart_series(chart_id, flow_id, security_group_id)
/


----------------------------------------------------
-- Install tables for random image generator

create table wwv_flow_random_images (
         id                   number
                              constraint wwv_flow_random_images_pk
                              primary key,
         image_name           varchar2(4000) not null,
         image_code           varchar2(10) not null,
         blob_content         blob not null
   )
/

create table wwv_flow_request_verifications (
         session_id            number
                               constraint wwv_flow_request_verif_pk
                               primary key,
         verification_string   varchar2(100) not null,
         constraint wwv_flow_request_verif_fk
         foreign key (session_id) references wwv_flow_sessions$ (id) on delete cascade
   )
/

--------------------------------------------
-- W O R K S H E E T S
--

create table wwv_flow_worksheets (
    id                        number not null,
    flow_id                   number not null
                              constraint wwv_flow_worksheets_flow_fk
                              references wwv_flows
                              on delete cascade,
    page_id                   number,
    region_id                 number
                              constraint wwv_flow_worksheets_reg_fk
                              references wwv_flow_page_plugs
                              on delete cascade,
    name                      varchar2(255) not null,
    folder_id                 number,
    alias                     varchar2(255),
    -- view settings
    report_id_item            varchar2(255),
    max_row_count             varchar2(255),
    max_row_count_message     varchar2(4000),
    no_data_found_message     varchar2(4000),
    max_rows_per_page         varchar2(4000),
    search_button_label       varchar2(4000),
    page_items_to_submit      varchar2(4000),
    sort_asc_image            varchar2(4000),
    sort_asc_image_attr       varchar2(4000),
    sort_desc_image           varchar2(4000),
    sort_desc_image_attr      varchar2(4000),
    -- base table
    sql_query                 clob,
    base_table_or_view        varchar2(4000),
    base_pk1                  varchar2(30),
    base_pk2                  varchar2(30),
    base_pk3                  varchar2(30),
    sql_hint                  varchar2(4000),
    -- status
    status                    varchar2(30)
                              constraint wwv_flow_ws_status_ck
                              check (status in (
                              'AVAILABLE_FOR_OWNER',
                              'NOT_AVAILABLE',
                              'AVAILABLE',
                              'ACL')),
    --
    allow_report_saving       varchar2(1)
                              constraint wwv_flow_ws_allow_save_ck
                              check (allow_report_saving in (
                              'Y',
                              'N')),
    allow_report_categories   varchar2(1)
                              constraint wwv_flow_ws_allow_cat_ck
                              check (allow_report_categories in (
                              'Y',
                              'N')),
    --
    show_nulls_as             varchar2(255),
    pagination_type           varchar2(255)
                              constraint wwv_flow_ws_pag_type
                              check (pagination_type in (
                              'ROWS_X_TO_Y_OF_Z',
                              'ROWS_X_TO_Y'
                              )),
    pagination_display_position    varchar2(255),
    button_template           number,
    --
    show_finder_drop_down     varchar2(1) not null
                              constraint wwv_flow_show_fnd_drop_ck
                              check (show_finder_drop_down in (
                              'Y',
                              'N')),
    show_display_row_count    varchar2(1) not null
                              constraint wwv_flow_show_row_cnt_ck
                              check (show_display_row_count in (
                              'Y',
                              'N')),
    show_search_bar           varchar2(1) not null
                              constraint wwv_flow_show_search_bar_ck
                              check (show_search_bar in (
                              'Y',
                              'N')),
    show_search_textbox       varchar2(1) not null
                              constraint wwv_flow_show_search_box_ck
                              check (show_search_textbox in (
                              'Y',
                              'N')),
    show_actions_menu         varchar2(1) not null
                              constraint wwv_flow_show_actions_ck
                              check (show_actions_menu in (
                              'Y',
                              'N')),
    actions_menu_icon         varchar2(4000),
    finder_icon               varchar2(4000),
    report_list_mode          varchar2(255) not null
                              constraint wwv_flow_list_reps_ck
                              check (report_list_mode in (
                              'TABS',
                              'NONE')),
    show_select_columns       varchar2(1) not null
                              constraint wwv_flow_ws_show_col_ck
                              check (show_select_columns in (
                              'Y',
                              'N')),
    show_filter               varchar2(1) not null
                              constraint wwv_flow_ws_show_filter_ck
                              check (show_filter in (
                              'Y',
                              'N')),
    show_sort                 varchar2(1) not null
                              constraint wwv_flow_ws_show_sort_ck
                              check (show_sort in (
                              'Y',
                              'N')),
    show_control_break        varchar2(1) not null
                              constraint wwv_flow_ws_show_break_ck
                              check (show_control_break in (
                              'Y',
                              'N')),
    show_highlight            varchar2(1) not null
                              constraint wwv_flow_ws_show_hl_ck
                              check (show_highlight in (
                              'Y',
                              'N')),
    show_computation          varchar2(1) not null
                              constraint wwv_flow_ws_show_comp_ck
                              check (show_computation in (
                              'Y',
                              'N')),
    show_aggregate            varchar2(1) not null
                              constraint wwv_flow_ws_show_agg_ck
                              check (show_aggregate in (
                              'Y',
                              'N')),
    show_chart                varchar2(1) not null
                              constraint wwv_flow_ws_show_chart_ck
                              check (show_chart in (
                              'Y',
                              'N')),
    show_calendar             varchar2(1) not null
                              constraint wwv_flow_ws_show_cal_ck
                              check (show_calendar in (
                              'Y',
                              'N')),
    show_flashback            varchar2(1) not null
                              constraint wwv_flow_ws_show_fb_ck
                              check (show_flashback in (
                              'Y',
                              'N')),
    show_reset                varchar2(1) not null
                              constraint wwv_flow_ws_show_reset_ck
                              check (show_reset in (
                              'Y',
                              'N')),
    show_download             varchar2(1) not null
                              constraint wwv_flow_ws_show_dl_ck
                              check (show_download in (
                              'Y',
                              'N')),
    show_help                 varchar2(1) not null
                              constraint wwv_flow_ws_show_help_ck
                              check (show_help in (
                              'Y',
                              'N')),
    show_detail_link          varchar2(1) not null
                              constraint wwv_flow_ws_detail_link_ck
                              check (show_detail_link in (
                              'Y',
                              'N',
                              'C')),
    download_formats          varchar2(30),
    download_filename         varchar2(255),
    csv_output_separator      varchar2(1),
    csv_output_enclosed_by    varchar2(1),
    --
    detail_link               varchar2(4000),
    detail_link_text          varchar2(4000),
    detail_link_attr          varchar2(4000),
    detail_link_checksum_type varchar2(255) constraint wwv_ir_link_checksum_type
                                check (detail_link_checksum_type in (
                                '1', -- workspace
                                '2', -- user
                                '3'  -- session
                                )),
    detail_link_condition_type varchar2(255),
    detail_link_cond          varchar2(4000),
    detail_link_cond2         varchar2(4000),
    detail_link_auth_scheme   varchar2(4000),
    allow_exclude_null_values varchar2(1) not null
                              constraint wwv_flow_ws_exclude_null_ck
                              check (allow_exclude_null_values in (
                              'Y',
                              'N')),
    allow_hide_extra_columns  varchar2(1) not null
                              constraint wwv_flow_ws_hide_extra_ck
                              check (allow_hide_extra_columns in (
                              'Y',
                              'N')),
    --
    max_query_cost            varchar2(4000),
    max_flashback             varchar2(4000),
    --
    worksheet_flags           varchar2(4000),
    --
    description               varchar2(4000),
    owner                     varchar2(255),
    --
    created_on                date          not null,
    created_by                varchar2(255) not null,
    updated_on                date,
    updated_by                varchar2(255),
    security_group_id         number        not null
    )
/

alter table wwv_flow_worksheets
    add constraint wwv_flow_worksheets_pk
    primary key(id)
/

create index wwv_flow_ws_idx1 on wwv_flow_worksheets (flow_id, page_id);
create index wwv_flow_ws_idx2 on wwv_flow_worksheets (region_id);

create unique index  wwv_flow_worksheets_unq_idx on wwv_flow_worksheets
    (case when region_id is null then flow_id end,
     case when region_id is null then owner end,
     case when region_id is null then folder_id end,
     case when region_id is null then name end)
/

create unique index wwv_flow_ws_unq_alias_idx on wwv_flow_worksheets
    (case when alias is not null then flow_id end,
     alias)
/

create table wwv_flow_worksheet_categories (
    id                     number
                           constraint wwv_flow_worksheet_cat_pk
                           primary key,
    worksheet_id           number not null,
    flow_id                number not null,
    base_cat_id            number,
    application_user       varchar2(255),
    name                   varchar2(255),
    display_sequence       number,
    --
    created_on             date          not null,
    created_by             varchar2(255) not null,
    updated_on             date,
    updated_by             varchar2(255),
    security_group_id      number        not null
    )
/

alter table wwv_flow_worksheet_categories
    add constraint wwv_flow_worksheet_cat_fk
    foreign key( security_group_id ) references wwv_flow_companies(provisioning_company_id)
    on delete cascade
/

create index wwv_flow_worksheet_cat_idx1 on wwv_flow_worksheet_categories(security_group_id)
/


----------
-- History
--

create table wwv_flow_worksheet_history (
    row_id              number not null,
    worksheet_id        number not null,
    --
    column_name         varchar2(255),
    old_value           varchar2(4000),
    new_value           varchar2(4000),
    --
    application_user_id varchar2(255),
    change_date         date,
    security_group_id   number        not null
    )
/

create index wwv_flow_worksheet_hist_01 on wwv_flow_worksheet_history (worksheet_id, row_id)
/


--------------------------
-- wwv_flow_worksheet_rows
--

create table wwv_flow_worksheet_rows (
    id                 number    not null,
    worksheet_id       number    not null,
    unique_value       varchar2(255),
    c001               varchar2(4000),
    c002               varchar2(4000),
    c003               varchar2(4000),
    c004               varchar2(4000),
    c005               varchar2(4000),
    c006               varchar2(4000),
    c007               varchar2(4000),
    c008               varchar2(4000),
    c009               varchar2(4000),
    c010               varchar2(4000),
    c011               varchar2(4000),
    c012               varchar2(4000),
    c013               varchar2(4000),
    c014               varchar2(4000),
    c015               varchar2(4000),
    c016               varchar2(4000),
    c017               varchar2(4000),
    c018               varchar2(4000),
    c019               varchar2(4000),
    c020               varchar2(4000),
    c021               varchar2(4000),
    c022               varchar2(4000),
    c023               varchar2(4000),
    c024               varchar2(4000),
    c025               varchar2(4000),
    c026               varchar2(4000),
    c027               varchar2(4000),
    c028               varchar2(4000),
    c029               varchar2(4000),
    c030               varchar2(4000),
    c031               varchar2(4000),
    c032               varchar2(4000),
    c033               varchar2(4000),
    c034               varchar2(4000),
    c035               varchar2(4000),
    c036               varchar2(4000),
    c037               varchar2(4000),
    c038               varchar2(4000),
    c039               varchar2(4000),
    c040               varchar2(4000),
    c041               varchar2(4000),
    c042               varchar2(4000),
    c043               varchar2(4000),
    c044               varchar2(4000),
    c045               varchar2(4000),
    c046               varchar2(4000),
    c047               varchar2(4000),
    c048               varchar2(4000),
    c049               varchar2(4000),
    c050               varchar2(4000),
    n001               number,
    n002               number,
    n003               number,
    n004               number,
    n005               number,
    n006               number,
    n007               number,
    n008               number,
    n009               number,
    n010               number,
    n011               number,
    n012               number,
    n013               number,
    n014               number,
    n015               number,
    n016               number,
    n017               number,
    n018               number,
    n019               number,
    n020               number,
    n021               number,
    n022               number,
    n023               number,
    n024               number,
    n025               number,
    n026               number,
    n027               number,
    n028               number,
    n029               number,
    n030               number,
    n031               number,
    n032               number,
    n033               number,
    n034               number,
    n035               number,
    n036               number,
    n037               number,
    n038               number,
    n039               number,
    n040               number,
    n041               number,
    n042               number,
    n043               number,
    n044               number,
    n045               number,
    n046               number,
    n047               number,
    n048               number,
    n049               number,
    n050               number,
    d001               date,
    d002               date,
    d003               date,
    d004               date,
    d005               date,
    d006               date,
    d007               date,
    d008               date,
    d009               date,
    d010               date,
    d011               date,
    d012               date,
    d013               date,
    d014               date,
    d015               date,
    d016               date,
    d017               date,
    d018               date,
    d019               date,
    d020               date,
    d021               date,
    d022               date,
    d023               date,
    d024               date,
    d025               date,
    d026               date,
    d027               date,
    d028               date,
    d029               date,
    d030               date,
    d031               date,
    d032               date,
    d033               date,
    d034               date,
    d035               date,
    d036               date,
    d037               date,
    d038               date,
    d039               date,
    d040               date,
    d041               date,
    d042               date,
    d043               date,
    d044               date,
    d045               date,
    d046               date,
    d047               date,
    d048               date,
    d049               date,
    d050               date,
    document           blob,
    clob001            clob,
    parent_row_id      number,
    owner              varchar2(255),
    geocode            varchar2(512),
    load_order         number,
    --
    created_on         date          not null,
    created_by         varchar2(255) not null,
    updated_on         date,
    updated_by         varchar2(255),
    security_group_id  number not null
    )
/


alter table wwv_flow_worksheet_rows
    add constraint wwv_flow_worksheet_rows_pk
    primary key(id)
/

alter table wwv_flow_worksheet_rows
    add constraint wwv_flow_worksheet_rows_fk
    foreign key( worksheet_id ) references wwv_flow_worksheets(id)
    on delete cascade
/

create index wwv_flow_worksheet_rows_idx1 on wwv_flow_worksheet_rows(worksheet_id)
/


----------------------------
-- worksheet columns
--
create table wwv_flow_worksheet_col_groups (
    id                  number        not null,
    flow_id             number        not null
                        constraint wwv_flow_worksheet_col_grp_fk
                        references wwv_flows
                        on delete cascade,
    worksheet_id        number        not null,
    name                varchar2(255) not null,
    description         varchar2(4000),
    display_sequence    number,
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/

alter table wwv_flow_worksheet_col_groups
    add constraint wwv_flow_worksheet_col_grps_pk
    primary key(id)
/

alter table wwv_flow_worksheet_col_groups
    add constraint wwv_flow_worksheet_col_grws_fk
    foreign key( worksheet_id ) references wwv_flow_worksheets(id)
    on delete cascade
/

alter table wwv_flow_worksheet_col_groups
    add constraint wwv_flow_worksheet_col_grps_uk
    unique(worksheet_id, name)
/

create index wwv_flow_ws_col_grps_idx1 on wwv_flow_worksheet_col_groups (flow_id);


--
-- Lists of Values (LOV)
--

create table wwv_flow_worksheet_lovs (
    id                  number        not null,
    worksheet_id        number        not null,
    name                varchar2(255) not null,
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/

alter table wwv_flow_worksheet_lovs
    add constraint wwv_flow_worksheet_lovs_pk
    primary key(id)
/

alter table wwv_flow_worksheet_lovs
    add constraint wwv_flow_worksheet_lovs_fk
    foreign key( worksheet_id ) references wwv_flow_worksheets(id)
    on delete cascade
/

alter table wwv_flow_worksheet_lovs
    add constraint wwv_flow_worksheet_lovs_uk
    unique(worksheet_id, name)
/

create table wwv_flow_worksheet_lov_entries (
    id                  number        not null,
    worksheet_id        number        not null,
    lov_id              number        not null,
    display_sequence    number        not null,
    entry_text          varchar2(255) not null,
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/

alter table wwv_flow_worksheet_lov_entries
    add constraint wwv_flow_worksheet_lov_ent_pk
    primary key(id)
/

alter table wwv_flow_worksheet_lov_entries
    add constraint wwv_flow_worksheet_lov_ent_fk
    foreign key( worksheet_id ) references wwv_flow_worksheets(id)
    on delete cascade
/

alter table wwv_flow_worksheet_lov_entries
    add constraint wwv_flow_worksheet_lov_ent_fk2
    foreign key( lov_id ) references wwv_flow_worksheet_lovs(id)
    on delete cascade
/

alter table wwv_flow_worksheet_lov_entries
    add constraint wwv_flow_ws_lov_ents_uk
    unique(lov_id, entry_text)
/

create index wwv_flow_ws_lov_ent_idx1 on wwv_flow_worksheet_lov_entries (worksheet_id);

--
-- Columns
--
create table wwv_flow_worksheet_columns (
    id                  number    not null,
    flow_id             number    not null
                        constraint wwv_flow_worksheet_col_fk
                        references wwv_flows
                        on delete cascade,
    page_id             number,
    worksheet_id        number    not null,
    db_column_name      varchar2(30) not null,
    display_order       number    not null,
    group_id            number,
    column_identifier   varchar2(10) not null,
    column_expr         varchar2(4000),
    -- label
    column_label        varchar2(4000) not null,
    report_label        varchar2(4000) not null,
    sync_form_label     varchar2(1)
                        constraint wwv_flow_val_wscol_sync_lab
                        check (sync_form_label in ('Y','N')),
    -- display
    display_in_default_rpt varchar2(1)
                           constraint wwv_flow_ws_display_col
                           check (display_in_default_rpt in ('Y','N')),
    column_html_expression varchar2(4000),
    column_link            varchar2(4000),
    column_linktext        varchar2(4000),
    column_link_attr       varchar2(4000),
    column_link_checksum_type varchar2(255)
                              constraint wwv_flow_ws_checksum_type
                              check (column_link_checksum_type in (
                              '1', -- workspace
                              '2', -- user
                              '3'  -- session
                              )),
    is_sortable         varchar2(1)
                        constraint wwv_flow_ws_col_sort_ck
                        check (is_sortable in ('Y','N')),
    allow_sorting       varchar2(1) not null
                        constraint wwv_flow_ws_col_sorting_ck
                        check (allow_sorting in ('Y','N')),
    allow_filtering     varchar2(1) not null
                        constraint wwv_flow_ws_col_filter_ck
                        check (allow_filtering in ('Y','N')),
    allow_ctrl_breaks   varchar2(1) not null
                        constraint wwv_flow_ws_col_ctrl_ck
                        check (allow_ctrl_breaks in ('Y','N')),
    allow_aggregations  varchar2(1) not null
                        constraint wwv_flow_ws_col_agg_ck
                        check (allow_aggregations in ('Y','N')),
    allow_computations  varchar2(1) not null
                        constraint wwv_flow_ws_col_comp_ck
                        check (allow_computations in ('Y','N')),
    allow_charting      varchar2(1) not null
                        constraint wwv_flow_ws_col_chart_ck
                        check (allow_charting in ('Y','N')),
    -- column filters
    use_custom          varchar2(1),
    custom_filter       varchar2(4000),
    base_column         varchar2(30),
    allow_filters       varchar2(1),
    -- security
    others_may_edit     varchar2(1),
    others_may_view     varchar2(1),
    -- display controls
    column_type         varchar2(255) not null
                        constraint wwv_flow_valid_ws_col_type
                      	check (column_type in (
                      	'STRING',
                      	'DATE',
                      	'NUMBER',
                      	'CLOB',
                      	'FILE',
                      	'COMPUTED',
                      	'DETAIL_LINK',
                      	'OTHER')),
    display_as          varchar2(255) not null
                        constraint wwv_flow_ws_col_disp_as_ck
                        check (display_as in (
                        'READONLY',
                        'TEXT',
                        'TEXTAREA',
                        'SELECTLIST',
                        'CHECKBOX',
                        'RADIOGROUP',
                        'POPUP_LOV',
                        'DATE_PICKER')),
    display_text_as     varchar2(255) not null
                        constraint wwv_flow_ws_col_disp_txt_as_ck
                        check (display_text_as in (
                        'WITHOUT_MODIFICATION',
                        'ESCAPE_SC',
                        'HIDDEN')),
    heading_alignment   varchar2(255) not null
                        constraint wwv_flow_ws_col_head_al_ck
                        check (heading_alignment in (
                        'LEFT',
                        'RIGHT',
                        'CENTER')),
    column_alignment    varchar2(255) not null
                        constraint wwv_flow_ws_col_col_al_ck
                        check (column_alignment in (
                        'LEFT',
                        'RIGHT',
                        'CENTER')),
    max_length          number,
    display_width       integer,
    display_height      integer,
    allow_null          varchar2(1)
                        constraint wwv_flow_wscol_allow_null
                      	check (allow_null in ('Y','N')),
    format_mask         varchar2(255),
    -- warehouse
    fact_table_key        varchar2(255),
    dimension_table       varchar2(255),
    dimension_table_id    varchar2(255),
    dimension_table_value varchar2(255),
    -- report list of values
    rpt_distinct_lov    varchar2(1)
                        constraint wwv_flow_wscol_lov
                        check (rpt_distinct_lov in ('Y','N')),
    rpt_lov             varchar2(4000),
    rpt_named_lov       number,
    rpt_show_filter_lov varchar2(1)
                        constraint wwv_flow_wscol_showfil_lov_ck
                        check (rpt_show_filter_lov in ('D','S','N')),
    rpt_filter_date_ranges varchar2(255)
                        constraint wwv_flow_wscol_fil_dtrng_ck
                        check (rpt_filter_date_ranges in ('ALL','PAST','FUTURE')),
    -- form list of values
    static_lov          varchar2(4000),
    lov_null_text       varchar2(255),
    lov_allow_new_values varchar2(1)
                        constraint wwv_flow_ws_lov_allow_new
                        check (lov_allow_new_values in ('Y','N')),
    lov_is_distinct_values varchar2(1)
                        constraint wwv_flow_ws_lov_distinct_vals
                        check (lov_is_distinct_values in ('Y','N')),
    lov_num_columns     number,
    lov_id              number,
    --
    computation_type    varchar2(255),
    computation_expr_1  varchar2(4000),
    computation_expr_2  varchar2(4000),
    --
    validation_type     varchar2(255),
    validation_expr_1   varchar2(4000),
    validation_expr_2   varchar2(4000),
    --
    display_condition_type    varchar2(255),
    display_condition         varchar2(4000),
    display_condition2        varchar2(4000),
    -- default values
    default_value       varchar2(4000),
    default_when        varchar2(30),
    --
    help_text           varchar2(4000),
    --
    security_scheme     varchar2(255),
    --
    column_flags        varchar2(4000),
    column_comment      varchar2(4000),
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/

alter table wwv_flow_worksheet_columns
    add constraint wwv_flow_worksheet_columns_pk
    primary key(id)
/

alter table wwv_flow_worksheet_columns
    add constraint wwv_flow_worksheet_columns_fk
    foreign key( worksheet_id ) references wwv_flow_worksheets(id)
    on delete cascade
/

alter table wwv_flow_worksheet_columns
    add constraint wwv_flow_worksheet_col_grps_fk
    foreign key( group_id ) references wwv_flow_worksheet_col_groups(id)
    on delete set null
/

alter table wwv_flow_worksheet_columns
    add constraint wwv_flow_worksheet_columns_uk2
    unique(worksheet_id, db_column_name)
/

create index wwv_flow_worksheet_cols_idx1 on wwv_flow_worksheet_columns (worksheet_id, column_identifier);
create index wwv_flow_worksheet_cols_idx2 on wwv_flow_worksheet_columns (flow_id);
create index wwv_flow_worksheet_cols_idx3 on wwv_flow_worksheet_columns (group_id);


---------------------------
-- worksheet Privs

create table wwv_flow_worksheet_privs (
    id                  number not null,
    worksheet_id        number not null,
    application_user    varchar2(255),
    -- worksheet privs
    view_priv           varchar2(1) constraint wwv_flow_worksheet_priv_q_ck check (view_priv  in ('Y','N')),
    edit_priv           varchar2(1) constraint wwv_flow_worksheet_priv_e_ck check (edit_priv  in ('Y','N')),
    develop_priv        varchar2(1) constraint wwv_flow_worksheet_priv_d_ck check (develop_priv  in ('Y','N')),
    -- row privs
    row_filter_1_db_col varchar2(255),
    row_filter_1_expr   varchar2(30),
    row_filter_1_value  varchar2(4000),
    row_filter_2_db_col varchar2(255),
    row_filter_2_expr   varchar2(30),
    row_filter_2_value  varchar2(4000),
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/


alter table wwv_flow_worksheet_privs
    add constraint wwv_flow_worksheet_priv_pk
    primary key(id)
/

alter table wwv_flow_worksheet_privs
    add constraint wwv_flow_worksheet_priv_fk
    foreign key( worksheet_id ) references wwv_flow_worksheets (id)
    on delete cascade
/

create index wwv_flow_worksheet_privs_idx1 on wwv_flow_worksheet_privs (worksheet_id);

-------------------------------
-- Stickies
--

create table wwv_flow_worksheet_stick (
    id                  number not null,
    worksheet_id        number not null,
    row_id              number not null,
    content             clob,
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/

alter table wwv_flow_worksheet_stick
    add constraint wwv_flow_worksheet_stick_pk
    primary key(id)
/

alter table wwv_flow_worksheet_stick
    add constraint wwv_flow_worksheet_stick_fk
    foreign key ( row_id ) references wwv_flow_worksheet_rows(id)
    on delete cascade
/

create index wwv_flow_ws_stick_idx1 on wwv_flow_worksheet_stick (row_id);

-------------------------------
-- Links
--

create table wwv_flow_worksheet_links (
    id                  number not null,
    worksheet_id        number not null,
    row_id              number not null,
    link_name           varchar2(255)  not null,
    url                 varchar2(4000) not null,
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/

alter table wwv_flow_worksheet_links
    add constraint wwv_flow_worksheet_links_pk
    primary key(id)
/

alter table wwv_flow_worksheet_links
    add constraint wwv_flow_worksheet_links_fk
    foreign key ( row_id ) references wwv_flow_worksheet_rows(id)
    on delete cascade
/

create index wwv_flow_worksheet_links_idx1 on wwv_flow_worksheet_links (row_id);


-------------------------------
-- Documents
--

create table wwv_flow_worksheet_docs (
	  id                  number not null,
	  row_id              number not null,
	  name                varchar2(255) not null,
	  description         varchar2(4000),
	  content             blob,
    mime_type           varchar2(48)  not null,
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/

alter table wwv_flow_worksheet_docs
    add constraint wwv_flow_worksheet_doc_pk
    primary key(id)
/

alter table wwv_flow_worksheet_docs
    add constraint wwv_flow_worksheet_doc_fk
    foreign key ( row_id ) references wwv_flow_worksheet_rows(id)
    on delete cascade
/

create index wwv_flow_worksheet_docs_idx1 on wwv_flow_worksheet_docs (row_id);

----------
-- Reports
--

create table wwv_flow_worksheet_rpts (
    id                     number not null,
    worksheet_id           number not null,
    flow_id                number not null,
    page_id                number not null,
    session_id             number,
    base_report_id         number,
    application_user       varchar2(255),
    name                   varchar2(255),
    description            varchar2(4000),
    report_seq             number not null,
    report_type            varchar2(255),
    status                 varchar2(30)
                           constraint wwv_flow_ws_rpt_status_ck
                           check (status in (
                           'PRIVATE',
                           'PUBLIC')),
    category_id            number,
    autosave               varchar2(1),
    is_default             varchar2(1) not null
                           constraint wwv_flow_ws_rpt_def_ck
                           check (is_default in (
                           'Y',
                           'N')),
    -- column display
    display_rows           number,
    pagination_min_row     number,
    report_columns         varchar2(4000),
    -- sorting
    sort_column_1          varchar2(255),
    sort_direction_1       varchar2(255),
    sort_column_2          varchar2(255),
    sort_direction_2       varchar2(255),
    sort_column_3          varchar2(255),
    sort_direction_3       varchar2(255),
    sort_column_4          varchar2(255),
    sort_direction_4       varchar2(255),
    sort_column_5          varchar2(255),
    sort_direction_5       varchar2(255),
    sort_column_6          varchar2(255),
    sort_direction_6       varchar2(255),
    -- control break
    break_on               varchar2(4000),
    break_enabled_on       varchar2(4000),
    control_break_options  varchar2(255),
    -- aggregation
    sum_columns_on_break   varchar2(4000),
    avg_columns_on_break   varchar2(4000),
    max_columns_on_break   varchar2(4000),
    min_columns_on_break   varchar2(4000),
    median_columns_on_break varchar2(4000),
    mode_columns_on_break  varchar2(4000),
    count_columns_on_break varchar2(4000),
    -- flashback
    flashback_mins_ago     varchar2(255),
    flashback_enabled      varchar2(1) not null
                           constraint wwv_flow_ws_rpt_fb_ck
                           check (flashback_enabled in (
                           'Y',
                           'N')),
    -- chart
    chart_type             varchar2(255),
    chart_3d               varchar2(1),
    chart_label_column     varchar2(255),
    chart_label_title      varchar2(255),
    chart_value_column     varchar2(255),
    chart_aggregate        varchar2(255),
    chart_value_title      varchar2(255),
    chart_sorting          varchar2(30)
                           constraint wwv_flow_ws_rpt_chrt_ck
                           check (chart_sorting in (
                           'DEFAULT',
                           'VALUE_DESC',
                           'VALUE_ASC',
                           'LABEL_DESC',
                           'LABEL_ASC')),
    -- calendar
    calendar_date_column   varchar2(255),
    calendar_display_column varchar2(255),
    -- audit
    created_on             date          not null,
    created_by             varchar2(255) not null,
    updated_on             date,
    updated_by             varchar2(255),
    security_group_id      number        not null
    )
/


alter table wwv_flow_worksheet_rpts
    add constraint wwv_flow_worksheet_rpts_pk
    primary key(id)
/

alter table wwv_flow_worksheet_rpts
    add constraint wwv_flow_worksheet_rpts_fk
    foreign key ( category_id ) references wwv_flow_worksheet_categories(id)
/

alter table wwv_flow_worksheet_rpts
    add constraint wwv_flow_worksheet_rpts_fk2
    foreign key( security_group_id ) references wwv_flow_companies(provisioning_company_id)
    on delete cascade
/

create index wwv_flow_ws_rpts_idx on wwv_flow_worksheet_rpts (worksheet_id, is_default);
create index wwv_flow_ws_base_rpt_idx on wwv_flow_worksheet_rpts (base_report_id, application_user);
create index wwv_flow_ws_cat_rpt_idx on wwv_flow_worksheet_rpts(category_id);
create index wwv_flow_ws_rpts_sgid_idx on wwv_flow_worksheet_rpts(security_group_id);


create unique index  wwv_flow_worksheet_rpts_uk on wwv_flow_worksheet_rpts
    (case when session_id is null then worksheet_id end,
     case when session_id is null then application_user end,
     case when session_id is null then category_id end,
     case when session_id is null then name end)
/


create table wwv_flow_worksheet_conditions (
     id                  number not null,
     flow_id             number not null,
     page_id             number,
     worksheet_id        number not null,
     report_id           number not null,
     name                varchar2(255),
     condition_type      varchar2(255)
                         constraint wwv_flow_ws_c_type_ck
                         check (condition_type in ('FILTER','HIGHLIGHT','SEARCH')),
     allow_delete        varchar2(1) not null
                         constraint wwv_flow_ws_c_del_ck
                         check (allow_delete in ('Y','N','R')), -- R = Filter can be replaced by another on the same column
     -- filter expression
     column_name         varchar2(4000),
     operator            varchar2(30),
     expr_type           varchar2(255),
     expr                varchar2(4000),
     expr2               varchar2(4000),
     condition_sql       varchar2(4000),
     condition_display   varchar2(4000),
     -- enabled?
     enabled             varchar2(1) not null
                         constraint wwv_flow_ws_c_enabled_ck
                         check (enabled in ('Y','N')),
     -- highlighting settings
     highlight_sequence  number,
     row_bg_color        varchar2(255),
     row_font_color      varchar2(255),
     row_format          varchar2(3),
     column_bg_color     varchar2(255),
     column_font_color   varchar2(255),
     column_format       varchar2(3),
     -- audit
     created_on          date not null,
     created_by          varchar2(255) not null,
     updated_on          date,
     updated_by          varchar2(255),
     security_group_id   number not null
     )
/

alter table wwv_flow_worksheet_conditions
    add constraint wwv_flow_worksheet_cond_pk
    primary key(id)
/

alter table wwv_flow_worksheet_conditions
    add constraint wwv_flow_worksheet_cond_fk
    foreign key ( report_id ) references wwv_flow_worksheet_rpts(id)
    on delete cascade
/

create unique index wwv_flow_worksheet_cond_uk2 on wwv_flow_worksheet_conditions
    (report_id,
     substr(condition_type,1,30),
     substr(column_name,1,30),
     operator,
     substr(expr,1,250),
     substr(expr2,1,100))
/

create index wwv_flow_ws_conditions_idx on wwv_flow_worksheet_conditions (worksheet_id)
/


create table wwv_flow_worksheet_computation (
     id                  number not null,
     flow_id             number not null,
     page_id             number,
     worksheet_id        number not null,
     report_id           number not null,
     --
     db_column_name      varchar2(30) not null,
     column_identifier   varchar2(10) not null,
     computation_expr    varchar2(4000),
     format_mask         varchar2(255),
     column_type         varchar2(255)
                         constraint wwv_flow_valid_ws_comp_type
                         check (column_type in (
                         'STRING',
                         'DATE',
                         'NUMBER',
                         'CLOB',
                         'OTHER')),
     -- label
     column_label        varchar2(4000) not null,
     report_label        varchar2(4000) not null,
     -- audit
     created_on          date not null,
     created_by          varchar2(255) not null,
     updated_on          date,
     updated_by          varchar2(255),
     security_group_id   number not null
     )
/

alter table wwv_flow_worksheet_computation
    add constraint wwv_flow_ws_comp_cols_pk
    primary key(id)
/

alter table wwv_flow_worksheet_computation
    add constraint wwv_flow_ws_comp_cols_fk
    foreign key ( report_id ) references wwv_flow_worksheet_rpts(id)
    on delete cascade
/

alter table wwv_flow_worksheet_computation
    add constraint wwv_flow_ws_comp_cols_uk
    unique(report_id, db_column_name)
/

alter table wwv_flow_worksheet_computation
    add constraint wwv_flow_ws_comp_cols_uk2
    unique(report_id, column_identifier)
/

create index wwv_flow_ws_comp_cols_idx on wwv_flow_worksheet_computation (worksheet_id)
/


--------------------
-- Folders
--
create table wwv_flow_folders (
    id                  number not null,
    name                varchar2(255),
    parent_id           varchar2(255),
    --
    status              varchar2(30)
                        constraint wwv_flow_folder_status_ck
                        check (status in (
                        'AVAILABLE_FOR_OWNER',
                        'NOT_AVAILABLE',
                        'AVAILABLE',
                        'ACL')),
    owner               varchar2(255),
    description         varchar2(4000),
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/


alter table wwv_flow_folders
    add constraint wwv_flow_folder_pk
    primary key(id)
/


--------------
-- Web Pages
--

create table wwv_flow_web_pages (
    id                  number not null,
    name                varchar2(255),
    folder_id           number,
    --
    status              varchar2(30)
                        constraint wwv_flow_fold_status_ck
                        check (status in (
                        'AVAILABLE_FOR_OWNER',
                        'NOT_AVAILABLE',
                        'AVAILABLE',
                        'ACL')),
    owner               varchar2(255),
    description         varchar2(4000),
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/


alter table wwv_flow_web_pages
    add constraint wwv_flow_webpage_pk
    primary key(id)
/

create table wwv_flow_web_pg_regions (
    id                  number not null,
    name                varchar2(255),
    web_page_id         number,
    --
    display_sequence    number,
    page_position       varchar2(30)
                        constraint wwv_flow_webpgreg_pgpos_ck
                        check (page_position in (
                        'TOP',
                        'BOTTOM',
                        'LEFT',
                        'RIGHT',
                        'CENTER'
                        )),
    display_as          varchar2(30)
                        constraint wwv_flow_webpgreg_dispas_ck
                        check (display_as in (
                        'UNORDERED_LIST',
                        'ORDERED_LIST',
                        'TABS',
                        'BUTTONS',
                        'VERTICAL_LIST',
                        'HORIZONTAL_LIST')),
    heading_text        varchar2(4000),
    content             clob,
    footer_text         varchar2(4000),
    --
    status              varchar2(30)
                        constraint wwv_flow_webpgreg_status_ck
                        check (status in (
                        'AVAILABLE_FOR_OWNER',
                        'NOT_AVAILABLE',
                        'AVAILABLE',
                        'ACL')),
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/


alter table wwv_flow_web_pg_regions
    add constraint wwv_flow_webpage_region_pk
    primary key(id)
/

alter table wwv_flow_web_pg_regions
    add constraint wwv_flow_web_pg_rg_fk
    foreign key ( web_page_id ) references wwv_flow_web_pages(id)
    on delete cascade
/

create index wwv_flow_web_pg_regions_idx1 on wwv_flow_web_pg_regions (web_page_id);


create table wwv_flow_web_pg_list_entries (
    id                  number not null,
    name                varchar2(255),
    region_id           number,
    --
    entry_name          varchar2(4000),
    entry_link          varchar2(4000),
    display_sequence    number,
    --
    created_on          date          not null,
    created_by          varchar2(255) not null,
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/


alter table wwv_flow_web_pg_list_entries
    add constraint wwv_flow_webpglistentry_pk
    primary key(id)
/

alter table wwv_flow_web_pg_list_entries
    add constraint wwv_flow_web_pg_le_fk
    foreign key ( region_id ) references wwv_flow_web_pg_regions(id)
    on delete cascade
/

create index wwv_flow_web_pg_list_ent_idx1 on wwv_flow_web_pg_list_entries (region_id);

create table wwv_flow_worksheet_geocache (
    address varchar2(4000),
    geocode varchar2(512)
    )
/

--------------------------------------------
-- U P G R A D E
--

create table wwv_flow_upgrade_progress (
   upgrade_id number,
   upgrade_date date,
   upgrade_sequence number,
   upgrade_action   varchar2(4000),
   upgrade_error    varchar2(4000),
   upgrade_command  varchar2(4000)
   )
/

prompt ...done create tables
