set define '^'
set verify off
column temp new_val FLOW_OWNER
select sys_context( 'userenv', 'current_schema') temp from dual;
prompt ...create flow views



Rem  Copyright (c) Oracle Corporation 1999 - 2002. All Rights Reserved.
Rem
Rem    NAME
Rem      view.sql
Rem
Rem    DESCRIPTION
Rem      Create flow views
Rem
Rem    NOTES
Rem      Tables that describe a given flow.  Every attribute relates
Rem      back to the ID column of the WWV_FLOWS table.
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem    tmuth       12/02/2002 - Created
Rem    jstraub     03/10/2003 - Replaced select user with select sys_context( 'userenv', 'current_schema') for FLOW_OWNER
Rem    sspadafo    01/24/2009 - Revise wwv_flow_users view so as not to include password columns (Bug 7827992)

prompt ...wwv_flow_users view
create or replace view wwv_flow_users as select
		user_id,
		user_name,
		first_name,
		last_name,
		known_as,
		last_update_date,
		last_updated_by,
		creation_date,
		created_by,
		start_date,
		end_date,
		description,
		password_date,
		password_accesses_left,
		password_lifespan_accesses,
		password_lifespan_days,
		employee_id,
		person_type,
		email_address,
		person_id,
		security_group_id,
		default_schema,
		allow_access_to_schemas,
		attribute_01,
		attribute_02,
		attribute_03,
		attribute_04,
		attribute_05,
		attribute_06,
		attribute_07,
		attribute_08,
		attribute_09,
		attribute_10,
		last_login,
		builder_login_count,
		last_agent,
		last_ip,
		account_locked,
		account_expiry,
		failed_access_attempts,
		first_password_use_occurred,
		change_password_on_first_use,
		last_failed_login
from wwv_flow_fnd_user		
where security_group_id = (select nv('FLOW_SECURITY_GROUP_ID') s from dual)
/


prompt ...wwv_flow_group_users view
create or replace view wwv_flow_group_users as
select g.id group_id,
          g.group_name,
          ug.user_id
  from WWV_FLOW_FND_GROUP_USERS ug,
         WWV_FLOW_FND_USER_GROUPS g
where g.id = ug.group_id
   and ug.security_group_id = (
             select nv('FLOW_SECURITY_GROUP_ID') s
             from dual)
/