set define '^'
set verify off
prompt ...wwv_flow_calendar3.sql

Rem  NAME
Rem       wwv_flow_calendar3.sql
Rem
Rem     SCRIPT ARGUMENTS
Rem       1:
Rem       2:
Rem       3:
Rem
Rem      MODIFIED  (MM/DD/YYYY)
Rem        klrice    04/22/2004 - Created
Rem        klrice    05/27/2004 - Checkpoint for compilations
Rem        klrice    06/04/2004 - Formatting
Rem        klrice    06/04/2004 - added display_type to cals
Rem        klrice    06/21/2004 - Changed to start_date/end_date and addeed start_of_week
Rem        klrice    07/01/2004 - Added display_item to wiz call
Rem        klrice    08/25/2004 - added flag to link all days or not, bug # 3855299
Rem        klrice    08/31/2004 - added separator for use when display is a Column
Rem        sspadafo  02/19/2005 - Added day_link, item_link references
Rem        klrice    05/09/2005 - Added is_Valid_query
Rem        Sathikum  01/02/2007 - Added printMonthCal, printWeekCal, printDayCal
Rem	   Sathikum  01/12/2007 - Added support for Start Time, End Time , Time format for Weekly & Daily Calendar also start day & end day feature for weekly calendar.
Rem        jstraub   01/16/2007 - Added new columns for wwv_flow_cals to set_Attributes
Rem	   sathikum  01/19/2997 - Added parameter to store calender type field.
Rem        sathikum  10/30/2007 - added process_calendar_date for ajax calendar
Rem        sathikum  10/31/2007 - added functionality to support both ajax and classic calendar
Rem        jstraub   11/21/2007 - added p_calendar_type to set_Attributes



create or replace package wwv_flow_calendar3 as

--  Copyright (c) Oracle Corporation 1999 - 2004. All Rights Reserved.
--
--    DESCRIPTION
--      Calendar rendering engine package specification.
--
--    NOTES
--      This program shows regions of type CALENDAR and EASY_CALENDAR.
--
--    RUNTIME DEPLOYMENT: YES
--

procedure create_wizard_elements(p_flow_id          number,
                                  p_page_id         number,
                                  p_region_id       number,
                                  p_date_item_name  varchar2,
                                  p_display_item_name  varchar2,
                                  p_buttons         varchar2,
                                  p_button_template varchar2,
                                  p_date_item_type_name varchar2 default null,
                                  p_is_ajax_calendar varchar2 default null);

procedure loadCols(p_sql         varchar2        default null,
                    p_owner      varchar2        default null,
                    p_table      varchar2        default null,
                    p_collection varchar2);

 /*  made public for testing performace */
function mySubsDates(p_text  varchar2,
                      p_date date) return varchar2;

 /*  made public for testing performace */
function checkDateSub(p_text    varchar2,
                       p_format varchar2,
                       p_date   date) return varchar2;


procedure set_Attributes(p_flow_id                     number,
                         p_template_id                 number,
                         p_plug_id                     number,
                         p_start_date                  varchar2    default null,
                         p_end_date                    varchar2    default null,
                         p_begin_at_Start_of_interval  varchar2    default 'Y',
                         p_date_item                   varchar2    default null,
                         p_date_type_item              varchar2    default null,
                         p_interval                    varchar2    default 'M',
                         p_display_item                varchar2    default null,
                         p_display_type                varchar2    default null,
                         p_item_format                 varchar2    default null,
                         p_easy_sql_owner              varchar2    default null,
                         p_easy_sql_table              varchar2    default null,
                         p_date_col                    varchar2    default null,
                         p_display_col                 varchar2    default null,
                         p_start_of_week               number      default null,
                         p_day_link                    varchar2    default null,
                         p_item_link                   varchar2    default null,
                         p_start_time                  in varchar2 default null,
                         p_end_time                    in varchar2 default null,
                         p_time_format                 in varchar2 default null,
                         p_week_start_day              in varchar2 default null,
                         p_week_end_day                in varchar2 default null,
                         p_calendar_type               in varchar2 default null,
                         p_SECURITY_GROUP_ID           number      default wwv_flow_security.g_security_group_id ,
                         p_LAST_UPDATED_BY             varchar2    default wwv_flow.g_user,
                         p_LAST_UPDATED_ON             date        default sysdate);

procedure show(p_plug_id number,p_cal_type varchar2 default 'M',p_cal_action varchar2 default null,p_date_value varchar2 default null);

procedure printMonthCal( p_sql                         varchar2,
                    p_start                       date     := null,
                    p_date_col                    varchar2 := null,
                    p_display_col                 varchar2 := null,

                    p_begin_at_Start_of_interval  varchar2 := 'Y',
                    p_start_of_week               number   := null,
                    p_end                         date     := null,
                    --p_display_as                  varchar2 := 'M', SATHIKUM F30 Commented
		    p_display_as                  varchar2 := null, --SATHIKUM F30 Added to support weekly and Daily
                    p_item_format                 varchar2 := null,
                    p_separator                   varchar2 := null,
                    p_item_link                   varchar2 := null,
                    p_day_link                    varchar2 := null,
                    p_link_all_days               boolean  := true,

                    p_month_title_format          varchar2 := null,
                    p_day_of_week_format          varchar2 := null,
                    p_month_open_format           varchar2 := null,
                    p_month_close_format          varchar2 := null,

                    p_day_title_format            varchar2 := null,
                    p_day_open_format             varchar2 := null,
                    p_day_close_format            varchar2 := null,

                    p_today_open_format           varchar2 := null,

                    p_weekend_title_format        varchar2 := null,
                    p_weekend_open_format         varchar2 := null,
                    p_weekend_close_format        varchar2 := null,

                    p_nonday_title_format         varchar2 := null,
                    p_nonday_open_format          varchar2 := null,
                    p_nonday_close_format         varchar2 := null,

                    p_week_title_format           varchar2 := null,
                    p_week_open_format            varchar2 := null,
                    p_week_close_format           varchar2 := null,

                    p_daily_title_format          varchar2 := null,
                    p_daily_open_format           varchar2 := null,
                    p_daily_close_format          varchar2 := null
          );

procedure printDayCal( p_sql                         varchar2,
                    p_start                       date     := null,
                    p_date_col                    varchar2 := null,
                    p_display_col                 varchar2 := null,

                    p_begin_at_Start_of_interval  varchar2 := 'Y',
                    p_start_of_week               number   := null,
                    p_end                         date     := null,
                    p_display_as                  varchar2 := 'D',
                    p_item_format                 varchar2 := null,
                    p_separator                   varchar2 := null,
                    p_item_link                   varchar2 := null,
                    p_day_link                    varchar2 := null,
                    p_link_all_days               boolean  := true,

		p_start_time			  number := null,
		p_end_time			  number := null,
		p_time_format			  varchar2 := null,
		p_week_start_day		  number := null,
		p_week_end_day			  number := null,

     		p_daily_title_format 	       varchar2 := null,
		p_daily_day_of_week_format   varchar2 := null,

		p_daily_month_open_format    varchar2 := null,
		p_daily_month_close_format   varchar2 := null,

		p_daily_day_title_format     varchar2 := null,
		p_daily_day_open_format      varchar2 := null,
		p_daily_day_close_format     varchar2 := null,
		p_daily_today_open_format    varchar2 := null,

		p_daily_time_open_format     varchar2 := null,
		p_daily_time_close_format    varchar2 := null,
		p_daily_time_title_format    varchar2 := null,

		p_daily_hour_open_format     varchar2 := null,
		p_daily_hour_close_format    varchar2 := null

          );

procedure printWeekCal( p_sql                         varchar2,
                    p_start                       date     := null,
                    p_date_col                    varchar2 := null,
                    p_display_col                 varchar2 := null,
                    p_begin_at_Start_of_interval  varchar2 := 'Y',
                    p_start_of_week               number   := null,
                    p_end                         date     := null,
                    p_display_as                  varchar2 := 'M',
                    p_item_format                 varchar2 := null,
                    p_separator                   varchar2 := null,
                    p_item_link                   varchar2 := null,
                    p_day_link                    varchar2 := null,
                    p_link_all_days               boolean  := true,

		p_start_time			  number := null,
		p_end_time			  number := null,
		p_time_format			  varchar2 := null,
		p_week_start_day		  number := null,
		p_week_end_day			  number := null,

     		p_weekly_title_format 	       varchar2 := null,
		p_weekly_day_of_week_format   varchar2 := null,

		p_weekly_month_open_format    varchar2 := null,
		p_weekly_month_close_format   varchar2 := null,

		p_weekly_day_title_format     varchar2 := null,
		p_weekly_day_open_format      varchar2 := null,
		p_weekly_day_close_format     varchar2 := null,
		p_weekly_today_open_format    varchar2 := null,

		p_weekly_weekend_title_format varchar2 := null,
		p_weekly_weekend_open_format  varchar2 := null,
		p_weekly_weekend_close_format varchar2 := null,

		p_weekly_time_open_format     varchar2 := null,
		p_weekly_time_close_format    varchar2 := null,
		p_weekly_time_title_format    varchar2 := null,

		p_weekly_hour_open_format     varchar2 := null,
		p_weekly_hour_close_format    varchar2 := null

          );

function  is_valid_query(p_query  varchar2,
                         p_owner  varchar2) return varchar2;


procedure  process_calendar_date( p_request varchar2,
    p_date    varchar2,
    p_type    varchar2,
    p_date_item varchar2
    ) ;

end wwv_flow_calendar3;
/
show errors
