set define '^'
set feedback off
prompt ...wwv_flow_install_wizard

Rem    NAME
Rem      wwv_flow_install_wizard.sql
Rem    Arguments:
Rem     1:  
Rem     2:
Rem     3:  Flow user
Rem    MODIFIED (MM/DD/YYYY)
Rem     cbcho    01/17/2006 - Created
Rem     madelfio 01/26/2006 - Added deinstall, set_sub_strings, install_condition
Rem     cbcho    01/30/2006 - Added p_flow_id in install_condition, install
Rem     cbcho    03/31/2006 - Added procedure configuration_options; logic moved from 4000:2103 large PLSQL region, Configuration Options
Rem     madelfio 05/04/2006 - Added p_flow_id to deinstall procedure to support application-specific deployment logs
Rem     madelfio 06/22/2006 - Added get_existing_objects, get_missing_privs, get_free_space functions to perform prerequisite checks
Rem     madelfio 01/11/2007 - Created upgrade procedure
Rem     cbcho    01/26/2007 - Added create_acl_ddl


create or replace package wwv_flow_install_wizard
as
--  Copyright (c) Oracle Corporation 2006. All Rights Reserved.
--
--
--    DESCRIPTION
--      This package provides install engine for application install wizard.
--
--      
--    SECURITY
--      No grants, must be run as FLOW schema owner.
--
--    NOTES
--
--    INTERNATIONALIZATION
--      unknown
--
--    MULTI-CUSTOMER
--      unknown
--
--    CUSTOMER MAY CUSTOMIZE
--      NO
--
--    RUNTIME DEPLOYMENT: YES
--

function install_condition (
    p_flow_id           in number,
    p_condition_type    in varchar2 default null,
    p_condition         in varchar2 default null,
    p_condition2        in varchar2 default null)
    return boolean;

procedure install (
    p_install_id          in number,
    p_flow_id             in number,
    p_schema              in varchar2
    );

procedure upgrade (
    p_install_id          in number,
    p_flow_id             in number,
    p_schema              in varchar2
    );
    
procedure deinstall (
    p_install_id  in number,
    p_flow_id     in number,
    p_schema      in varchar2
    );
    
procedure set_sub_strings (
    p_ss_prompts in wwv_flow_global.vc_arr2,
    p_ss_values  in wwv_flow_global.vc_arr2,
    p_install_id in number
    );
    
procedure configuration_options (
    p_flow_id in number default null
    );

function get_existing_objects(
    p_flow_id in number)
    return varchar2;
    
function get_missing_privs(
    p_flow_id in number)
    return varchar2;
    
function get_free_space(
    p_flow_id in number)
    return varchar2;

procedure create_acl_ddl (
    p_flow_id             in number,
    p_security_group_id   in number
    );
end wwv_flow_install_wizard;
/

show errors